#Requirements: files from full_NUMT_blast.loop.based_on_COX1.sh that end with *results.txt and *.blast_alignment.txt

#set working directory and install required packages    
setwd("PATH/TO/WORKING/DIRECTORY")
require(ggplot2)
require(scales)
require(grid)
require(gridExtra)
require(ggalt)
require(ggforce)
require(tidyr)
require(ggpubr)
library("seqinr")
library(Biostrings)

#create taxonomy data frame
temp <- strsplit("Lepidoptera Noctuidae Abrostola Abrostola_tripartita 381.042 54 13645312 NA 658", " ")
temp <- c(temp, strsplit("Coleoptera Lampyridae Abscondita Abscondita_terminalis 499.653 67.39 1220005 NA 658", " "))
temp <- c(temp, strsplit("Orthoptera Gryllidae Acheta Acheta_domesticus 929.173 1309.81732 1566 1956 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Achlyodes Achlyodes_pallida 260.266 0.87 520 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Noctuidae Acronicta Acronicta_aceris 466.369 39 15394549 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Saturniidae Actias Actias_luna 684.276 240 112291 547.68 658", " "))
temp <- c(temp, strsplit("Hemiptera Aphididae Acyrthosiphon Acyrthosiphon_pisum 541.121 789.41 25858 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Adelidae Adela Adela_reaumurella 874.161 120 12648 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Tortricidae Adoxophyes Adoxophyes_honmai 469.62 338 26229 NA 658", " "))
temp <- c(temp, strsplit("Diptera Culicidae Aedes Aedes_aegypti 1278.72 110 6938895 NA 658", " "))
temp <- c(temp, strsplit("Diptera Culicidae Aedes Aedes_albopictus 1923.48 229 18430 NA 658", " "))
temp <- c(temp, strsplit("Hemiptera Pentatomidae Aelia Aelia_acuminata 1170.03 31 4690255 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Aeromachus Aeromachus_stigmata 212.578 0.71 784 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Aethilla Aethilla_lavochrea 284.819 0.95 624 NA 658", " "))
temp <- c(temp, strsplit("Coleoptera Nitidulidae Aethina Aethina_tumida 234.344 535 298879 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Agathymus Agathymus_mariae 410.468 1.37 6664 NA 658", " "))
temp <- c(temp, strsplit("Coleoptera Buprestidae Agrilus Agrilus_planipennis 353.057 124.7 28329 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Geometridae Agriopis Agriopis_aurantiaria 485.37 35 13323862 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Noctuidae Agrochola Agrochola_circellaris 572.147 33 19711079 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Noctuidae Agrotis Agrotis_ipsilon 486.925 140 820105 NA 658", " "))
temp <- c(temp, strsplit("Trichoptera Phryganeidae Agrypnia Agrypnia_vestita 1353.06 106 111757 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Aguna Aguna_metophis 305.106 1.04 840 NA 658", " "))
temp <- c(temp, strsplit("Coleoptera Elateridae Alaus Alaus_oculatus 188.381 141 2461 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Allancastria Allancastria_cerisyi 149.927 0.5 436 NA 658", " "))
temp <- c(temp, strsplit("Plecoptera Nemouridae Amphinemura Amphinemura_sulcicollis 271.925 1.37 846 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Noctuidae Amphipyra Amphipyra_berbera 582.315 41 19930773 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Noctuidae Amphipyra Amphipyra_tragopoginis 805.653 41 23469271 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Ampulicidae Ampulex Ampulex_compressa 277.736 157 42854 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Pyralidae Amyelois Amyelois_transitella 406.468 36 17697 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Anastrus Anastrus_sempiternus 283.001 0.94 477 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Vespidae Ancistrocerus Ancistrocerus_nigricornis 231.996 69 18662773 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Andrenidae Andrena Andrena_haemorrhoa 330.671 77 13237341 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Cynipidae Andricus Andricus_curvator 1713.4 33 635 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Cynipidae Andricus Andricus_inflator 1869.31 38 980 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Cynipidae Andricus Andricus_quercusramuli 1937.57 36 977 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Anisynta Anisynta_dominula 106.537 0.36 332 NA 658", " "))
temp <- c(temp, strsplit("Diptera Culicidae Anopheles Anopheles_arabiensis 256.808 114 23935993 NA 658", " "))
temp <- c(temp, strsplit("Diptera Culicidae Anopheles Anopheles_atroparvus 220.079 98 53613 NA 658", " "))
temp <- c(temp, strsplit("Diptera Culicidae Anopheles Anopheles_christyi 172.659 35 8461 NA 658", " "))
temp <- c(temp, strsplit("Diptera Culicidae Anopheles Anopheles_coluzzii 273.409 100 8269537 NA 658", " "))
temp <- c(temp, strsplit("Diptera Culicidae Anopheles Anopheles_cracens 326.466 212.09 9003 NA 658", " "))
temp <- c(temp, strsplit("Diptera Culicidae Anopheles Anopheles_culicifacies 202.999 31 13414 NA 658", " "))
temp <- c(temp, strsplit("Diptera Culicidae Anopheles Anopheles_darlingi 136.936 20 115072 NA 658", " "))
temp <- c(temp, strsplit("Diptera Culicidae Anopheles Anopheles_dirus 216.308 184 76300 NA 658", " "))
temp <- c(temp, strsplit("Diptera Culicidae Anopheles Anopheles_epiroticus 223.487 49 88996 NA 658", " "))
temp <- c(temp, strsplit("Diptera Culicidae Anopheles Anopheles_funestus 444.53 234 107489 NA 658", " "))
temp <- c(temp, strsplit("Diptera Culicidae Anopheles Anopheles_gambiae 236.403 8 42558 NA 658", " "))
temp <- c(temp, strsplit("Diptera Culicidae Anopheles Anopheles_longipalpis 347.073 150 27945 NA 658", " "))
temp <- c(temp, strsplit("Diptera Culicidae Anopheles Anopheles_maculatus 462.689 93.21 38030 NA 658", " "))
temp <- c(temp, strsplit("Diptera Culicidae Anopheles Anopheles_melas 224.162 147 11312 NA 658", " "))
temp <- c(temp, strsplit("Diptera Culicidae Anopheles Anopheles_merus 294.364 50 2729089 NA 658", " "))
temp <- c(temp, strsplit("Diptera Culicidae Anopheles Anopheles_minimus 201.793 211 123292 NA 658", " "))
temp <- c(temp, strsplit("Diptera Culicidae Anopheles Anopheles_nili 98.32 0.4 2278 NA 658", " "))
temp <- c(temp, strsplit("Diptera Culicidae Anopheles Anopheles_parensis 278.978 149 44720 NA 658", " "))
temp <- c(temp, strsplit("Diptera Culicidae Anopheles Anopheles_punctulatus 146.157 50 10256 NA 658", " "))
temp <- c(temp, strsplit("Diptera Culicidae Anopheles Anopheles_quadriannulatus 283.829 93 39415 NA 658", " "))
temp <- c(temp, strsplit("Diptera Culicidae Anopheles Anopheles_rivulorum 321.482 131 25195 NA 658", " "))
temp <- c(temp, strsplit("Diptera Culicidae Anopheles Anopheles_sinensis 375.764 86 17961 NA 658", " "))
temp <- c(temp, strsplit("Diptera Culicidae Anopheles Anopheles_stephensi 243.46 180 38117870 NA 658", " "))
temp <- c(temp, strsplit("Diptera Culicidae Anopheles Anopheles_vaneedeni 308.7 139 40521 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Pompilidae Anoplius Anoplius_nigerrimus 623.784 29 1681933 NA 658", " "))
temp <- c(temp, strsplit("Coleoptera Cerambycidae Anoplophora Anoplophora_glabripennis 706.953 121 80490 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Saturniidae Antheraea Antheraea_mylitta 698.408 166.6 64049 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Saturniidae Antheraea Antheraea_pernyi 786.985 100 45425 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Pieridae Anthocharis Anthocharis_cardamines 359.602 69 6265090 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Noctuidae Apamea Apamea_monoglypha 576.032 25 9140809 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Formicidae Aphaenogaster Aphaenogaster_fulva 346.134 22 15753 410.76 658", " "))
temp <- c(temp, strsplit("Hymenoptera Formicidae Aphaenogaster Aphaenogaster_picea 386.045 31 15430 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Braconidae Aphidius Aphidius_ervi 138.952 178 25199 146.7 658", " "))
temp <- c(temp, strsplit("Hymenoptera Braconidae Aphidius Aphidius_gifuensis 156.944 69 3929594 NA 658", " "))
temp <- c(temp, strsplit("Hemiptera Aphididae Aphis Aphis_craccivora 318.873 100 32785 410.76 658", " "))
temp <- c(temp, strsplit("Hemiptera Aphididae Aphis Aphis_glycines 308.064 123 1958040 NA 658", " "))
temp <- c(temp, strsplit("Hemiptera Aphididae Aphis Aphis_gossypii 377.586 104 2200049 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Apidae Apis Apis_cerana 226.971 304 7065000 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Apidae Apis Apis_dorsata 230.34 60 8422 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Apidae Apis Apis_florea 228.997 20.5 24915 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Apidae Apis Apis_laboriosa 226.063 304 303790 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Apidae Apis Apis_mellifera 225.235 192 5382476 249.39 658", " "))
temp <- c(temp, strsplit("Lepidoptera Riodinidae Apodemia Apodemia_duryi 647.832 2.16 1323 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Riodinidae Apodemia Apodemia_hypoglauca 215.119 0.72 347 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Riodinidae Apodemia Apodemia_mejicanus 198.573 0.66 319 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Riodinidae Apodemia Apodemia_mormo 225.764 0.75 331 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Riodinidae Apodemia Apodemia_multiplaga 21.7217 0.07 283 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Riodinidae Apodemia Apodemia_murphyi 334.439 1.12 436 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Riodinidae Apodemia Apodemia_virgulti 145.403 0.48 312 NA 658", " "))
temp <- c(temp, strsplit("Coleoptera Attelabidae Apoderus Apoderus_coryli 428.056 59 15031106 NA 658", " "))
temp <- c(temp, strsplit("Hemiptera Miridae Apolygus Apolygus_lucorum 1023.62 100 783891 880.2 658", " "))
temp <- c(temp, strsplit("Lepidoptera Pieridae Aporia Aporia_crataegi 229.679 101 9626953 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Apostictopterus Apostictopterus_fuliginosus 99.0625 0.33 356 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Tortricidae Apotomis Apotomis_turbidana 720.45 32 13785672 NA 658", " "))
temp <- c(temp, strsplit("Orthoptera Gryllidae Apteronemobius Apteronemobius_asahinai 1676.22 143 26422 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Apyrrothrix Apyrrothrix_aesculapus 391.107 1.3 2969 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Apyrrothrix Apyrrothrix_araxes 318.697 1.062507473 1145 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Apyrrothrix Apyrrothrix_chalybea 265.229 0.88 490 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Archon Archon_apollinus 739.52 2.47 1808 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Erebidae Arctia Arctia_plantaginis 584.648 75 2313902 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Lycaenidae Aricia Aricia_agestis 435.265 54 17774651 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Arteurotia Arteurotia_tractipennis 32.8511 0.11 273 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Asbolis Asbolis_capucinus 428.891 1.43 8112 NA 658", " "))
temp <- c(temp, strsplit("Coleoptera Tenebrionidae Asbolus Asbolus_verrucosus 249.608 30 4550 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Braconidae Asobara Asobara_japonica 270.937 94 1651859 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Aspitha Aspitha_agenoria 221.436 0.74 651 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Aspitha Aspitha_aspitha 281.658 0.94 6792 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Astictopterus Astictopterus_jama 92.0665 0.31 312 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Astraptes Astraptes_enotrus 320.489 1.07 1152 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Astraptes Astraptes_talus 320.704 1.07 904 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Atarnes Atarnes_sallei 199.028 0.67 411 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Noctuidae Atethmia Atethmia_centrago 926.64 29 26605457 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Tenthredinidae Athalia Athalia_rosae 171.955 103 7096104 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Atrophaneura Atrophaneura_alcinous 293.431 0.98 2748 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Atrophaneura Atrophaneura_dixoni 332.821 1.11 14642 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Atrytonopsis Atrytonopsis_hianna 372.568 1.24 1071 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Formicidae Atta Atta_colombica 291.258 129 15290 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Formicidae Atta Atta_texana 286.873 150 6806 264.06 658", " "))
temp <- c(temp, strsplit("Hemiptera Aphididae Aulacorthum Aulacorthum_solani 316.098 60 5312 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Autochton Autochton_bipunctatus 122.62 0.44 375 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Autochton Autochton_itylus 415.258 1.39 1835 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Autochton Autochton_longipennis 248.611 0.84 472 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Autochton Autochton_pseudocellus 311.657 1.04 563 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Autochton Autochton_zarex 320.977 1.07 823 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Noctuidae Autographa Autographa_gamma 373.052 36 11185469 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Noctuidae Autographa Autographa_pulchrina 426.226 47 9609940 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Azonax Azonax_typhaon 283.456 0.95 1599 NA 658", " "))
temp <- c(temp, strsplit("Diptera Tephritidae Bactrocera Bactrocera_dorsalis 468.671 50 90458965 NA 658", " "))
temp <- c(temp, strsplit("Diptera Tephritidae Bactrocera Bactrocera_latifrons 462.489 101 31499 NA 658", " "))
temp <- c(temp, strsplit("Diptera Tephritidae Bactrocera Bactrocera_oleae 484.932 100 187710 NA 658", " "))
temp <- c(temp, strsplit("Diptera Tephritidae Bactrocera Bactrocera_tryoni 570.643 60 350910 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Riodinidae Baeotis Baeotis_zonata 146.288 0.49 320 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Barca Barca_bicolor 4.84573 0.02 353 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Baronia Baronia_brevicornis 472.426 1.57 1886 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Sesiidae Bembecia Bembecia_ichneumoniformis 511.395 30 15603170 NA 658", " "))
temp <- c(temp, strsplit("Hemiptera Aleyrodidae Bemisia Bemisia_tabaci 615.017 300 84501 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Bibasis Bibasis_iluska 96.2715 0.32 327 NA 658", " "))
temp <- c(temp, strsplit("Diptera Bibionidae Bibio Bibio_marci 340.009 53 44910499 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Bicyclus Bicyclus_anynana 475.4 260 78697 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Blastobasidae Blastobasis Blastobasis_adustella 557.425 50 17994227 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Blastobasidae Blastobasis Blastobasis_lacticolella 577.068 32 11597587 NA 658", " "))
temp <- c(temp, strsplit("Blattodea Ectobiidae Blattella Blattella_germanica 2037.3 158.5 12126 NA 658", " "))
temp <- c(temp, strsplit("Diptera Mycetophilidae Bolitophila Bolitophila_cinerea 365.299 120 42952 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Bolla Bolla_brennus 14.94 0.05 361 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Apidae Bombus Bombus_balteatus 250.066 35 8601724 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Apidae Bombus Bombus_bifarius 266.785 125 2202782 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Apidae Bombus Bombus_confusus 239.101 100 411713 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Apidae Bombus Bombus_cullumanus 246.986 100 1128213 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Apidae Bombus Bombus_difficillimus 243.56 100 338993 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Apidae Bombus Bombus_haemorrhoidalis 240.539 100 874667 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Apidae Bombus Bombus_hortorum 296.297 82 10578496 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Apidae Bombus Bombus_ignitus 242.565 100 714304 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Apidae Bombus Bombus_impatiens 246.856 127 59072 484.11 658", " "))
temp <- c(temp, strsplit("Hymenoptera Apidae Bombus Bombus_opulentus 242.354 100 731585 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Apidae Bombus Bombus_polaris 245.79 100 427351 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Apidae Bombus Bombus_pyrosoma 254.805 100 781044 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Apidae Bombus Bombus_sibiricus 262.42 100 561947 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Apidae Bombus Bombus_soroeensis 243.574 100 582038 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Apidae Bombus Bombus_sylvestris 302.566 79 5862009 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Apidae Bombus Bombus_sylvicola 252.082 30 3020754 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Apidae Bombus Bombus_terrestris 393.078 57 6780370 518.34 658", " "))
temp <- c(temp, strsplit("Hymenoptera Apidae Bombus Bombus_waltoni 231.15 100 1152409 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Bombycidae Bombyx Bombyx_huttoni 450.339 30 768 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Bombycidae Bombyx Bombyx_mandarina 398.573 362.2 322127 469.44 658", " "))
temp <- c(temp, strsplit("Lepidoptera Bombycidae Bombyx Bombyx_mori 460.334 140 12201325 NA 658", " "))
temp <- c(temp, strsplit("Plecoptera Taeniopterygidae Brachyptera Brachyptera_putata 436.497 64 1512184 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Bungalotis Bungalotis_erythus 365.423 1.22 1972 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Noctuidae Busseola Busseola_fusca 492.903 70 2742 948.66 658", " "))
temp <- c(temp, strsplit("Lepidoptera Pyralidae Cactoblastis Cactoblastis_cactorum 411.558 40 2605 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Riodinidae Calephelis Calephelis_virginiensis 855.082 92 16821 NA 658", " "))
temp <- c(temp, strsplit("Diptera Calliphoridae Calliphora Calliphora_vicina 459.231 10.4 1086 743.28 658", " "))
temp <- c(temp, strsplit("Odonata Calopterygidae Calopteryx Calopteryx_splendens 1628.35 65 4472 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Calpodes Calpodes_ethlius 415.728 1.39 6102 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Caltoris Caltoris_sirius 356.585 1.19 1502 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Riodinidae Calydna Calydna_sturnula 27.0739 1.73 6135 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Geometridae Campaea Campaea_margaritaria 335.21 48 11935323 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Camptopleura Camptopleura_auxo 285.228 0.95 495 NA 658", " "))
temp <- c(temp, strsplit("Coleoptera Cantharidae Cantharis Cantharis_rustica 445.918 43 17823022 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Carcharodus Carcharodus_alceae 199.276 0.67 363 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Peleopodidae Carcina Carcina_quercana 409.502 57 13030025 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Carposinidae Carposina Carposina_sasakii 399.04 125 2597711 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Carystus Carystus_phorcus 388.34 1.3 6065 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Cecropterus Cecropterus_lyciades 566.819 84 7706 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Cecropterus Cecropterus_tehuacana 310.608 1.04 550 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Cecropterus Cecropterus_toxeus 462.106 1.54 7640 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Celaenorrhinus Celaenorrhinus_ficulnea 5.76195 0.02 260 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Celaenorrhinus Celaenorrhinus_patula 181.722 0.61 312 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Lycaenidae Celastrina Celastrina_argiolus 499.099 32 7710655 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Cephise Cephise_aelius 453.903 1.51 1865 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Cephidae Cephus Cephus_cinctus 162.226 56 44905 205.38 658", " "))
temp <- c(temp, strsplit("Hymenoptera Apidae Ceratina Ceratina_australensis 219.302 10 12363 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Apidae Ceratina Ceratina_calcarata 199.937 20 23399 665.04 658", " "))
temp <- c(temp, strsplit("Diptera Tephritidae Ceratitis Ceratitis_capitata 436.475 152.5 845931 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Chaetocneme Chaetocneme_critomedia 176.287 0.59 338 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Chamunda Chamunda_chamunda 4.36977 0.02 274 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Charaxes Charaxes_varanes 520.283 1.74 1528 NA 658", " "))
temp <- c(temp, strsplit("Diptera Syrphidae Cheilosia Cheilosia_vulpina 405.366 51 45551726 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Crambidae Chilo Chilo_suppressalis 824.354 160 642389 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Chioides Chioides_albofasciatus 384.568 1.29 2451 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Chiomara Chiomara_georgina 399.386 1.33 1423 NA 658", " "))
temp <- c(temp, strsplit("Diptera Chironomidae Chironomus Chironomus_riparius 178.168 100 284852 195.6 658", " "))
temp <- c(temp, strsplit("Diptera Chironomidae Chironomus Chironomus_tentans 213.463 50 7697 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Choaspes Choaspes_benjaminii 357.906 1.19 2532 NA 658", " "))
temp <- c(temp, strsplit("Coleoptera Scarabaeidae Chrysina Chrysina_resplendens 611.44 180 20382 NA 658", " "))
temp <- c(temp, strsplit("Diptera Calliphoridae Chrysomya Chrysomya_rufifacies 295.134 43 3240 430.32 658", " "))
temp <- c(temp, strsplit("Neuroptera Chrysopidae Chrysopa Chrysopa_pallens 538.353 204 1321525 NA 658", " "))
temp <- c(temp, strsplit("Neuroptera Chrysopidae Chrysoperla Chrysoperla_carnea 560.233 40 67795596 NA 658", " "))
temp <- c(temp, strsplit("Diptera Syrphidae Chrysotoxum Chrysotoxum_bicinctum 912.919 29 5739793 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Chymomyza Chymomyza_costata 315.185 219.9 8126076 NA 658", " "))
temp <- c(temp, strsplit("Hemiptera Cimicidae Cimex Cimex_hemipterus 2.66463 1 519 NA 658", " "))
temp <- c(temp, strsplit("Hemiptera Aphididae Cinara Cinara_cedri 396.043 80 282647 NA 658", " "))
temp <- c(temp, strsplit("Ephemeroptera Baetidae Cloeon Cloeon_dipterum 180.287 132 434950 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Notodontidae Clostera Clostera_curtula 512.666 24 6772994 NA 658", " "))
temp <- c(temp, strsplit("Diptera Chironomidae Clunio Clunio_marinus 85.4914 140 154800 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Crambidae Cnaphalocrocis Cnaphalocrocis_exigua 797.607 376.7 2488183 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Crambidae Cnaphalocrocis Cnaphalocrocis_medinalis 528.45 330 524627 NA 658", " "))
temp <- c(temp, strsplit("Diptera Scatopsidae Coboldia Coboldia_fuscipes 98.7591 53 145453 97.8 658", " "))
temp <- c(temp, strsplit("Coleoptera Coccinellidae Coccinella Coccinella_septempunctata 398.849 76 16512651 420.54 658", " "))
temp <- c(temp, strsplit("Diptera Calliphoridae Cochliomyia Cochliomyia_hominivorax 534.026 30 616429 440.1 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Codatractus Codatractus_alcaeus 423.192 1.41 2666 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Coeliades Coeliades_ramanatek 344.205 1.15 864 NA 658", " "))
temp <- c(temp, strsplit("Diptera Coelopidae Coelopa Coelopa_frigida 230.966 63 313772 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Pieridae Colias Colias_croceus 324.897 68 10749422 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Colletidae Colletes Colletes_gigas 273.057 150 6455398 NA 658", " "))
temp <- c(temp, strsplit("Diptera Dolichopodidae Condylostylus Condylostylus_patibulatus 451.942 15.8 1110 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Gracillariidae Conopomorpha Conopomorpha_cramerella 497.288 99 11353 NA 658", " "))
temp <- c(temp, strsplit("Diptera Cecidomyiidae Contarinia Contarinia_nasturtii 185.885 57 95005 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Encyrtidae Copidosoma Copidosoma_floridanum 553.956 139 40744 NA 658", " "))
temp <- c(temp, strsplit("Blattodea Rhinotermitidae Coptotermes Coptotermes_formosanus 875.712 10 159654 909.54 658", " "))
temp <- c(temp, strsplit("Lepidoptera Noctuidae Cosmia Cosmia_trapezina 825.172 43 7584852 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Braconidae Cotesia Cotesia_congregata 199.191 157 52137 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Braconidae Cotesia Cotesia_glomerata 288.846 130 668782 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Braconidae Cotesia Cotesia_vestalis 132 109.67 1100 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Noctuidae Craniophora Craniophora_ligustri 437.978 21 12212030 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Formicidae Crematogaster Crematogaster_levior 326.2 110 255727 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Creonpyge Creonpyge_creon 370.946 1.24 2502 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Cressida Cressida_cressida 400.896 1.35 1386 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Geometridae Crocallis Crocallis_elinguaria 430.383 44 28485152 NA 658", " "))
temp <- c(temp, strsplit("Coleoptera Coccinellidae Cryptolaemus Cryptolaemus_montrouzieri 988.107 107.91 10375940 NA 658", " "))
temp <- c(temp, strsplit("Blattodea Kalotermitidae Cryptotermes Cryptotermes_secundus 1018.93 45 63940 NA 658", " "))
temp <- c(temp, strsplit("Siphonaptera Pulicidae Ctenocephalides Ctenocephalides_felis 775.453 25 61000 459.66 658", " "))
temp <- c(temp, strsplit("Hymenoptera Apidae Ctenoplectra Ctenoplectra_terminalis 410.32 10 22447 NA 658", " "))
temp <- c(temp, strsplit("Diptera Culicidae Culex Culex_pipiens 566.659 250 838087 NA 658", " "))
temp <- c(temp, strsplit("Diptera Culicidae Culex Culex_quinquefasciatus 573.214 76 2875282 NA 658", " "))
temp <- c(temp, strsplit("Diptera Ceratopogonidae Culicoides Culicoides_sonorensis 209.428 NA 166828 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Cupitha Cupitha_purreea 308.137 1.03 1099 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Lycaenidae Curetis Curetis_bulis 371.728 1.24 1108 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Lycaenidae Cyaniris Cyaniris_semiargus 441.504 42 16283616 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Lycaenidae Cyclargus Cyclargus_thomasi 378.921 1.28 13881 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Cycloglypha Cycloglypha_thrasibulus 327.345 1.09 469 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Tortricidae Cydia Cydia_pomonella 772.892 120 823676 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Tortricidae Cydia Cydia_splendana 630.602 36 6521190 NA 658", " "))
temp <- c(temp, strsplit("Hemiptera Miridae Cyrtorhinus Cyrtorhinus_lividipennis 345.74 131 169452 352.08 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Dalla Dalla_cyprius 304.984 1.02 1029 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Danaus Danaus_chrysippus 322.399 65 452245 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Danaus Danaus_erippus 238.325 0.79 4236 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Danaus Danaus_gilippus 290.006 0.97 1365 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Danaus Danaus_melanippus 354.197 110 14547 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Danaus Danaus_plexippus 248.676 522 108026 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Dardarina Dardarina_dardaris 210.143 0.7 1158 NA 658", " "))
temp <- c(temp, strsplit("Diptera Asilidae Dasypogon Dasypogon_diadema 505.154 110 9253 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Sphingidae Deilephila Deilephila_porcellus 402.057 40 14884985 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Pieridae Delias Delias_pasithoe 297.182 240 103537 NA 658", " "))
temp <- c(temp, strsplit("Coleoptera Curculionidae Dendroctonus Dendroctonus_ponderosae 224.789 747 16218 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Lasiocampidae Dendrolimus Dendrolimus_kikuchii 705.516 118 20894489 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Lasiocampidae Dendrolimus Dendrolimus_punctatus 614.071 100 1359888 NA 658", " "))
temp <- c(temp, strsplit("Coleoptera Chrysomelidae Diabrotica Diabrotica_virgifera 2418.07 50 6238 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Braconidae Diachasma Diachasma_alloeum 384.372 24 45480 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Ichneumonidae Diadegma Diadegma_semiclausum 168.496 203.07 808 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Ichneumonidae Diadromus Diadromus_collaris 188.923 150 695 NA 658", " "))
temp <- c(temp, strsplit("Hemiptera Liviidae Diaphorina Diaphorina_citri 485.705 180 34407 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Crambidae Diatraea Diatraea_saccharalis 453.235 60 14183 NA 658", " "))
temp <- c(temp, strsplit("Hemiptera Aphididae Diuraphis Diuraphis_noxia 395.058 104 13141 381.42 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Doberes Doberes_anticus 404.243 1.35 3835 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Vespidae Dolichovespula Dolichovespula_media 247.581 74 1625878 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Vespidae Dolichovespula Dolichovespula_saxonica 221.834 27 910126 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Drepanidae Drepana Drepana_arcuata 270.473 400 46084 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Drephalys Drephalys_kidonoi 357.112 1.19 940 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_albomicans 165.83 50 33427555 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_ambigua 161.264 133.3 11334561 176.04 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_americana 163.287 60 14333 273.84 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_ananassae 213.818 370 26427416 198.86 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_arawakana 171.39 149.9 4863239 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_arizonae 141.387 52 15132 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_asahinai 189.051 28 77794 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_auraria 197.421 39 47547 244.5 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_azteca 219.084 135 17833963 195.6 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_baimaii 175.824 20 9903 273.84 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_bakoue 187.249 59 36923 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_barbarae 113.181 20 3025 195.6 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_biarmipes 169.379 186.9 474639 195.6 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_bifasciata 192.75 45 2386451 195.6 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_bipectinata 167.264 266.3 149088 195.6 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_birchii 156.594 36 209731 195.6 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_bocki 151.202 41 73461 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_bocqueti 134.382 20 9742 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_bunnanda 151.823 33 106114 215.16 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_burlai 175.666 45 31415 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_busckii 135.749 172.9 157428 166.26 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_cardini 181.106 102 4216638 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_diplacantha 117.735 20 2263 224.94 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_dunni 177.496 99.7 14045695 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_elegans 294.667 20 25164 195.6 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_equinoxialis 221.734 46.5 6639417 273.84 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_ercepeae 178.958 103.4 22310376 215.16 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_erecta 135.658 89.5 20389455 146.7 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_eugracilis 156.942 218.1 224458 224.94 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_fengkainensis 158.251 20 3046 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_ficusphila 152.439 208.7 275894 185.82 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_funebris 154.246 65.5 14085961 332.52 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_fuyamai 229.101 124.6 4123611 264.06 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_greeni 112.789 20 2233 195.6 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_guanche 140.633 278 294367 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_hydei 139.941 170 38689 185.82 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_immigrans 183.277 156.4 9651916 303.18 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_innubila 166.269 20 3071820 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_insularis 212.412 120.5 6295961 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_kanapiae 152.203 38 348318 166.26 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_lacteicornis 182.681 25 66522 244.5 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_leontia 164.602 37 24887 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_lini 133.807 20 12231 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_littoralis 236.786 100.5 7098318 234.72 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_malagassya 143.664 20 4402 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_malerkotliana 191.126 131.3 10924301 195.6 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_mauritiana 152.298 165 22120385 146.7 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_mayri 167.807 34 131064 254.28 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_melanica 174.881 47.6 4562 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_melanogaster 144.107 147 22302559 173.246 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_micromelanica 156.838 48.1 49440 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_miranda 287.096 100 11978448 176.04 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_mojavensis 193.826 8.2 121517 161.37 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_montana 183.585 40 6978 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_murphyi 153.853 124.1 11375470 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_nasuta 154.475 80 69820 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_navojoa 147.358 81 26679 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_neocordata 194.831 114.5 6033383 215.16 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_nigromelanica 162.544 28.9 60665 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_nikananu 190.505 40 28823 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_novamexicana 177.224 165 3158326 244.5 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_obscura 181.869 425 114814 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_ogumai 134.345 20 26281 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_ohnishii 133.627 20 5908 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_orena 182.891 100 5273554 268.95 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_orosa 142.362 20 8616 215.16 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_parabipectinata 209.862 89.1 11640351 205.38 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_parvula 143.574 20 11313 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_pectinifera 149.209 22 93696 293.4 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_persimilis 160.643 72 18749661 180.93 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_prosaltans 214.135 100 2707258 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_pseudoananassae 187.676 141.7 6062361 224.94 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_pseudoobscura 163.267 280 30706867 159.74 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_repleta 154.012 101.9 9288829 166.26 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_repletoides 181.448 64.5 18762850 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_rhopaloa 197.376 214.5 19484 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_robusta 179.074 30.8 18538 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_rufa 186.168 29 57257 254.28 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_saltans 249.307 101.9 2961640 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_santomea 146.801 103 10765947 166.26 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_sechellia 154.171 115 19907079 166.26 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_seguyi 178.857 38 83310 215.16 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_serrata 159.68 31 66278 205.38 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_simulans 121.252 180 117617 146.7 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_sproati 138.134 124.5 7964422 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_sturtevanti 172.593 65.5 3949872 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_subobscura 126.232 118 11370518 146.7 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_subpulchrella 265.154 260 11590999 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_sucinea 184.69 109.4 8149606 205.38 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_suzukii 268.012 160 2609782 327.63 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_takahashii 182.107 242.1 126259 195.6 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_tani 180.973 40 55635 195.6 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_teissieri 149.494 168 6375862 151.59 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_triauraria 195.276 52 1117044 244.5 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_tropicalis 211.041 51.2 5082839 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_truncata 167.897 51 101914 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_tsacasi 144.986 20 22791 215.16 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_virilis 169.772 80 5099607 366.75 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_vulcana 187.579 29 70792 224.94 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_watanabei 196.826 38 32759 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_willistoni 247.196 150 9079863 205.38 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Drosophila Drosophila_yakuba 150.004 90 13143520 169.52 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Dryas Dryas_iulia 440.278 44 4051594 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Noctuidae Dryobotodes Dryobotodes_eremita 709.791 28 22620483 NA 658", " "))
temp <- c(temp, strsplit("Phasmatodea Phasmatidae Dryococelus Dryococelus_australis 3416.45 9 17257 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Halictidae Dufourea Dufourea_novaeangliae 279.506 90 191865 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Dyscophellus Dyscophellus_porcius 411.369 1.37 1206 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Ebrietas Ebrietas_anacreon 360.137 1.2 729 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Eburuncus Eburuncus_unifasciata 288.773 0.96 623 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Formicidae Eciton Eciton_burchellii 192.453 250 220958 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Crabronidae Ectemnius Ectemnius_continuus 260.337 92 12091100 371.64 658", " "))
temp <- c(temp, strsplit("Hymenoptera Crabronidae Ectemnius Ectemnius_lituratus 235.157 110 1594160 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Geometridae Ectropis Ectropis_grisescens 784.887 108 3108904 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Erebidae Eilema Eilema_depressum 622.007 54 21724503 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Erebidae Eilema Eilema_sororculum 729.402 43 11816033 NA 658", " "))
temp <- c(temp, strsplit("Coleoptera Curculionidae Elaeidobius Elaeidobius_kamerunicus 269.635 17 849 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Elbella Elbella_theseus 358.676 1.2 2326 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Elymnias Elymnias_hypermnestra 566.918 131 152309 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Riodinidae Emesis Emesis_angularis 620.091 2.07 664 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Riodinidae Emesis Emesis_aurimna 530.99 1.77 551 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Riodinidae Emesis Emesis_brimo 550.673 1.84 865 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Riodinidae Emesis Emesis_cypria 465.365 1.55 435 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Riodinidae Emesis Emesis_diogenia 492.878 1.65 521 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Riodinidae Emesis Emesis_heteroclita 545.416 1.82 512 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Riodinidae Emesis Emesis_lacrines 697.981 2.33 645 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Riodinidae Emesis Emesis_liodes 604.793 2.02 673 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Riodinidae Emesis Emesis_lupina 289.467 0.97 360 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Riodinidae Emesis Emesis_mandana 455.904 1.52 430 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Riodinidae Emesis Emesis_ocypore 596.61 1.99 743 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Riodinidae Emesis Emesis_russula 484.808 1.62 475 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Riodinidae Emesis Emesis_spreta 595.192 1.98 666 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Riodinidae Emesis Emesis_tegula 639.185 2.13 1325 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Riodinidae Emesis Emesis_tenedia 655.346 2.18 835 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Riodinidae Emesis Emesis_vulpina 13.9891 0.08 276 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Pterophoridae Emmelina Emmelina_monodactyla 312.395 38 10272145 NA 658", " "))
temp <- c(temp, strsplit("Hemiptera Cicadellidae Empoasca Empoasca_onukii 599.258 100 2169089 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Pyralidae Endotricha Endotricha_flammealis 473.934 19 3020129 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Epargyreus Epargyreus_clarus 426.392 63 3741491 NA 658", " "))
temp <- c(temp, strsplit("Ephemeroptera Ephemeridae Ephemera Ephemera_danica 474.347 207.7 55305 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Pyralidae Ephestia Ephestia_elutella 576.941 129 433391 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Geometridae Erannis Erannis_defoliaria 522.357 23 11448532 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Erebia Erebia_ligea 506.62 34 14975182 NA 658", " "))
temp <- c(temp, strsplit("Hemiptera Coccidae Ericerus Ericerus_pela 654.86 10 410234 NA 658", " "))
temp <- c(temp, strsplit("Hemiptera Pemphigidae Eriosoma Eriosoma_lanigerum 334.868 50 157895 NA 658", " "))
temp <- c(temp, strsplit("Diptera Syrphidae Eristalis Eristalis_arbustorum 451.027 19 1235116 NA 658", " "))
temp <- c(temp, strsplit("Diptera Syrphidae Eristalis Eristalis_dimidiata 315.429 8 405 NA 658", " "))
temp <- c(temp, strsplit("Diptera Syrphidae Eristalis Eristalis_pertinax 482.075 29 3485103 NA 658", " "))
temp <- c(temp, strsplit("Diptera Syrphidae Eristalis Eristalis_tenax 487.003 36 6649640 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Ernsta Ernsta_confusa 7.42298 0.03 304 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Ernsta Ernsta_delagoae 253.254 0.84 3270 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Erynnis Erynnis_brizo 320.272 1.07 2796 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Erynnis Erynnis_tages 329.343 29 8006790 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Eueides Eueides_isabella 440.124 60 2115984 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Eueides Eueides_tales 792.524 2.64 3461 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Braconidae Eumacrocentrus Eumacrocentrus_americanus 116.92 35 3670 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Lycaenidae Eumaeus Eumaeus_atala 538.114 92 36024 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Eupelmidae Eupelmus Eupelmus_urozonus 376.748 122 17904 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Euphyes Euphyes_dion 305.065 1.02 1014 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Agaonidae Eupristina Eupristina_koningsbergeri 318.364 61.4 2702599 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Erebidae Euproctis Euproctis_similis 507.633 70 21398081 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Noctuidae Eupsilia Eupsilia_transversa 466.907 29 15275328 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Pieridae Eurema Eurema_mandarina 265.963 0.89 9030 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Euryades Euryades_corethrus 317.672 1.06 1810 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Riodinidae Eurybia Eurybia_lycisca 383.091 1.28 818 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Eurytides Eurytides_dolicaon 527.522 1.76 2436 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Euschemon Euschemon_rafflesia 28.9871 0.1 277 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Riodinidae Euselasia Euselasia_chrysippe 438.505 1.46 1806 NA 658", " "))
temp <- c(temp, strsplit("Diptera Tephritidae Eutreta Eutreta_diana 233.053 5.2 387 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Tenthredinidae Euura Euura_saliciscinereae 222.2 145 23325 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Apidae Exoneura Exoneura_robusta 460.705 10 15652 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Apidae Exoneurella Exoneurella_tridentata 441.469 10 74835 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Fabriciana Fabriciana_adippe 484.811 49 15984712 NA 658", " "))
temp <- c(temp, strsplit("Hemiptera Pseudococcidae Ferrisia Ferrisia_virgata 304.571 40 24304 NA 649", " "))
temp <- c(temp, strsplit("Hymenoptera Braconidae Fopius Fopius_arisanus 153.632 137.6 51867 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Formicidae Formica Formica_exsecta 277.634 80 24299 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Formicidae Formica Formica_selysi 290.452 100 5698920 NA 658", " "))
temp <- c(temp, strsplit("Thysanoptera Thripidae Frankliniella Frankliniella_occidentalis 415.771 158.7 6158 342.3 658", " "))
temp <- c(temp, strsplit("Lepidoptera Notodontidae Furcula Furcula_furcula 736.106 28 24892123 NA 658", " "))
temp <- c(temp, strsplit("Coleoptera Chrysomelidae Galerucella Galerucella_tenella 460.593 110 21782 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Pyralidae Galleria Galleria_mellonella 401.9 26 22549 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Figitidae Ganaspis Ganaspis_brasiliensis 821.363 24 4255 NA 658", " "))
temp <- c(temp, strsplit("Hemiptera Gerridae Gerris Gerris_buenoi 994.443 73.8 10917 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Gindanes Gindanes_brontinus 467.592 1.56 971 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Lycaenidae Glaucopsyche Glaucopsyche_alexis 619.529 43 7600873 NA 658", " "))
temp <- c(temp, strsplit("Diptera Glossinidae Glossina Glossina_austeni 370.265 62 45924 NA 658", " "))
temp <- c(temp, strsplit("Diptera Glossinidae Glossina Glossina_brevipalpis 315.36 81 62009 NA 658", " "))
temp <- c(temp, strsplit("Diptera Glossinidae Glossina Glossina_fuscipes 374.775 120 64354 489 658", " "))
temp <- c(temp, strsplit("Diptera Glossinidae Glossina Glossina_morsitans 348.063 13.9 3909 NA 658", " "))
temp <- c(temp, strsplit("Diptera Glossinidae Glossina Glossina_pallidipes 357.332 78 167200 459.66 658", " "))
temp <- c(temp, strsplit("Trichoptera Glossosomatidae Glossosoma Glossosoma_conforme 604.294 53 14418 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Gomalia Gomalia_elma 107.187 0.36 330 NA 658", " "))
temp <- c(temp, strsplit("Coleoptera Chrysomelidae Gonioctena Gonioctena_quinquepunctata 1731.95 128 432124 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Gorgopas Gorgopas_trochilus 217.7 0.73 677 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Gorgythion Gorgythion_begga 177.145 0.6 471 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Grais Grais_stigmaticus 259.093 0.86 1430 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Granila Granila_paseas 55.0533 0.19 310 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Graphium Graphium_androcles 851.994 2.84 2411 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Graphium Graphium_doson 730.517 140 110680 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Graphium Graphium_evemon 1042.81 3.48 1967 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Graphium Graphium_sarpedon 596.841 1.99 1073 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Noctuidae Griposia Griposia_aprilina 720.411 31 18585834 NA 658", " "))
temp <- c(temp, strsplit("Orthoptera Gryllidae Gryllus Gryllus_bimaculatus 1658.01 80 33340 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Gunayan Gunayan_rubricollis 217.089 0.73 407 NA 658", " "))
temp <- c(temp, strsplit("Diptera Tachinidae Gymnosoma Gymnosoma_rotundatum 780.496 31 9400655 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Apidae Habropoda Habropoda_laboriosa 296.955 113 22370 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Drepanidae Habrosyne Habrosyne_pyritoides 400.553 52 14121114 NA 658", " "))
temp <- c(temp, strsplit("Diptera Muscidae Haematobia Haematobia_irritans 1143.54 1 5359 1183.38 658", " "))
temp <- c(temp, strsplit("Hemiptera Pentatomidae Halyomorpha Halyomorpha_halys 1150.09 113.7 17705 NA 658", " "))
temp <- c(temp, strsplit("Coleoptera Coccinellidae Harmonia Harmonia_axyridis 425.525 53 22915403 459.66 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Hasora Hasora_badra 251.778 0.84 478 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Hasora Hasora_chromus 369.118 1.23 2464 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Noctuidae Hecatera Hecatera_dysodea 640.896 47 18008363 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Tortricidae Hedya Hedya_salicella 742.375 25 25550971 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Helias Helias_cama 360.823 1.2 1839 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Heliconius Heliconius_besckei 399.444 1.33 2118 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Heliconius Heliconius_burneyi 582.151 1.94 3487 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Heliconius Heliconius_charithonia 351.778 1.17 4391 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Heliconius Heliconius_clysonymus 428.295 1.43 1607 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Heliconius Heliconius_cydno 282.335 NA 2167 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Heliconius Heliconius_eleuchia 327.203 1.09 5720 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Heliconius Heliconius_elevatus 364.783 NA 1512 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Heliconius Heliconius_ethilla 282.526 NA 2400 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Heliconius Heliconius_hecale 78.53 NA 2245 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Heliconius Heliconius_hecalesia 566.016 1.89 2505 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Heliconius Heliconius_hecuba 212.767 NA 789 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Heliconius Heliconius_hermathena 391.646 100 118192 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Heliconius Heliconius_heurippa 309.419 NA 1849 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Heliconius Heliconius_hierax 210.868 NA 807 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Heliconius Heliconius_ismenius 259.837 NA 2386 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Heliconius Heliconius_numata 357.839 56 67572 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Heliconius Heliconius_pachinus 279.264 NA 1241 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Heliconius Heliconius_pardalinus 293.608 NA 2860 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Heliconius Heliconius_ricini 342.957 1.14 3151 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Heliconius Heliconius_sapho 335.596 1.12 3500 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Heliconius Heliconius_telesiphe 674.682 2.25 2224 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Heliconius Heliconius_timareta 319.429 NA 1486 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Heliconius Heliconius_wallacei 365.01 NA 676 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Heliconius Heliconius_xanthocles 198.611 NA 781 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Noctuidae Helicoverpa Helicoverpa_armigera 337.072 267 23479 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Noctuidae Helicoverpa Helicoverpa_zea 341.147 135 20602 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Heliopetes Heliopetes_ericetorum 373.303 1.25 851 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Sphingidae Hemaris Hemaris_fuciformis 448.838 88 10683069 NA 658", " "))
temp <- c(temp, strsplit("Diptera Stratiomyidae Hermetia Hermetia_illucens 1004.93 141 16011611 1154.04 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Hesperia Hesperia_comma 525.335 28 10272607 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Hesperia Hesperia_meskei 357.819 1.19 3518 NA 658", " "))
temp <- c(temp, strsplit("Trichoptera Limnephilidae Hesperophylax Hesperophylax_magnus 1233.59 75 768217 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Hesperopsis Hesperopsis_alpheus 304.72 1.02 1301 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Hestina Hestina_assimilis 421.032 150 13763034 NA 658", " "))
temp <- c(temp, strsplit("Hemiptera Cicadellidae Homalodisca Homalodisca_vitripennis 1930.92 71 118317 NA 658", " "))
temp <- c(temp, strsplit("Hemiptera Hormaphididae Hormaphis Hormaphis_cornu 319.693 266 66442 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Hovala Hovala_pardalina 263.371 0.88 2154 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Hyalothyrus Hyalothyrus_neleus 369.355 1.23 3068 NA 658", " "))
temp <- c(temp, strsplit("Coleoptera Meloidae Hycleus Hycleus_cichorii 99.1653 39.3 86942 NA 658", " "))
temp <- c(temp, strsplit("Coleoptera Meloidae Hycleus Hycleus_phaleratus 90.8698 36.8 75478 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Noctuidae Hydraecia Hydraecia_micacea 562.425 30 18807492 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Geometridae Hydriomena Hydriomena_furcata 423.302 42 13929574 NA 658", " "))
temp <- c(temp, strsplit("Trichoptera Hydropsychidae Hydropsyche Hydropsyche_tenuis 229.663 280 2190134 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Geometridae Hylaea Hylaea_fasciaria 327.919 72 11053481 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Sphingidae Hyles Hyles_vespertilio 651.398 45 7475438 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Erebidae Hypena Hypena_proboscidalis 636.771 23 18834925 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Hypermnestra Hypermnestra_helios 280.717 0.94 402 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Erebidae Hyphantria Hyphantria_cunea 510.512 289 152331 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Hypolimnas Hypolimnas_misippus 408.794 200 135179 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Riodinidae Hypophylla Hypophylla_argenissa 494.325 1.65 490 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Cosmopterigidae Hyposmocoma Hyposmocoma_kahamanoa 731.441 41 58944 NA 658", " "))
temp <- c(temp, strsplit("Coleoptera Curculionidae Hypothenemus Hypothenemus_hampei 162.571 142 36294 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Ichneumonidae Ichneumon Ichneumon_xanthorius 314.972 55 4079616 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Geometridae Idaea Idaea_aversata 436.713 56 14903667 NA 658", " "))
temp <- c(temp, strsplit("Coleoptera Elateridae Ignelater Ignelater_luminosus 842.899 100 31102 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Iphiclides Iphiclides_podalirius 366.845 1.22 2719 NA 658", " "))
temp <- c(temp, strsplit("Coleoptera Curculionidae Ips Ips_typographus 236.816 211 6654004 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Lycaenidae Jalmenus Jalmenus_evagoras 345.824 1.15 1485 224.94 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Jemadia Jemadia_hospita 217.185 0.73 466 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Jemadia Jemadia_pseudognetus 339.275 1.13 6243 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Jemadia Jemadia_scomber 233.093 0.78 465 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Jemadia Jemadia_suekentonmiller 347.281 1.16 5665 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Jera Jera_tricuspidata 258.444 0.86 665 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Jonaspyge Jonaspyge_jonas 349.587 1.17 1411 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Junonia Junonia_coenia 397.133 1.32 1837 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Junonia Junonia_evarete 440.171 1.47 2502 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Junonia Junonia_genoveva 371.22 1.24 1526 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Junonia Junonia_litoralis 346.417 1.15 1550 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Junonia Junonia_oenone 668.222 2.23 1092 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Junonia Junonia_vestina 279.544 0.93 1533 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Junonia Junonia_villida 93.0367 0.31 371 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Katreus Katreus_johnstonii 82.784 0.28 314 NA 658", " "))
temp <- c(temp, strsplit("Coleoptera Lampyridae Lamprigera Lamprigera_yunnana 1052.93 74.05 3509824 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Lamproptera Lamproptera_meges 462.444 1.55 1786 NA 658", " "))
temp <- c(temp, strsplit("Hemiptera Delphacidae Laodelphax Laodelphax_striatellus 540.152 277 86418 508.56 658", " "))
temp <- c(temp, strsplit("Lepidoptera Sphingidae Laothoe Laothoe_populi 576.387 28 6972935 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Laparus Laparus_doris 464.778 1.56 3838 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Halictidae Lasioglossum Lasioglossum_albipes 336.521 96 16944 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Halictidae Lasioglossum Lasioglossum_lativentre 478.936 34 4089460 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Halictidae Lasioglossum Lasioglossum_morio 505.652 35 7842008 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Formicidae Lasius Lasius_niger 236.236 19 17048 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Erebidae Laspeyria Laspeyria_flexula 450.882 48 12239498 NA 658", " "))
temp <- c(temp, strsplit("Plecoptera Nemouridae Lednia Lednia_tumana 304.502 60 4212 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Apidae Lepidotrigona Lepidotrigona_ventralis 333.081 447 6124 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Pieridae Leptidea Leptidea_juvernica 523.094 1.74 1739 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Pieridae Leptidea Leptidea_reali 405.019 1.35 2611 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Pieridae Leptidea Leptidea_sinapis 685.583 36 14011732 NA 658", " "))
temp <- c(temp, strsplit("Coleoptera Chrysomelidae Leptinotarsa Leptinotarsa_decemlineata 641.993 52.3 46596 NA 658", " "))
temp <- c(temp, strsplit("Coleoptera Chrysomelidae Leptinotarsa Leptinotarsa_haldemani 549.179 22.6 2472 NA 658", " "))
temp <- c(temp, strsplit("Coleoptera Chrysomelidae Leptinotarsa Leptinotarsa_juncta 578.212 20.5 2814 NA 658", " "))
temp <- c(temp, strsplit("Coleoptera Chrysomelidae Leptinotarsa Leptinotarsa_lineolata 647.43 19 6286 NA 658", " "))
temp <- c(temp, strsplit("Coleoptera Chrysomelidae Leptinotarsa Leptinotarsa_rubiginosa 566.667 19.3 2836 NA 658", " "))
temp <- c(temp, strsplit("Coleoptera Chrysomelidae Leptinotarsa Leptinotarsa_texana 640.408 19 5536 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Figitidae Leptopilina Leptopilina_boulardi 323.668 300 44515 361.86 658", " "))
temp <- c(temp, strsplit("Hymenoptera Figitidae Leptopilina Leptopilina_clavipes 255.344 87 8276 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Figitidae Leptopilina Leptopilina_heterotoma 497.698 114 4476 459.66 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Lerema Lerema_accius 298.17 135 16756 NA 658", " "))
temp <- c(temp, strsplit("Hemiptera Belostomatidae Lethocerus Lethocerus_indicus 426.832 60 5900000 NA 658", " "))
temp <- c(temp, strsplit("Coleoptera Geotrupidae Lethrus Lethrus_apterus 286.932 120 7185 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Crambidae Leucinodes Leucinodes_orbonalis 855.313 350 76911 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Leucophenga Leucophenga_varia 303.593 27.3 560182 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Limenitis Limenitis_arthemis 270.767 0.91 631 381.42 658", " "))
temp <- c(temp, strsplit("Trichoptera Limnephilidae Limnephilus Limnephilus_lunatus 1270.17 36 18993099 NA 658", " "))
temp <- c(temp, strsplit("Coleoptera Elateridae Limonius Limonius_californicus 1072.67 70 19395 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Formicidae Linepithema Linepithema_humile 219.501 30 35858 254.28 658", " "))
temp <- c(temp, strsplit("Diptera Agromyzidae Liriomyza Liriomyza_trifolii 69.6986 26 1816 NA 658", " "))
temp <- c(temp, strsplit("Coleoptera Curculionidae Listronotus Listronotus_bonariensis 1112.44 38 120328 NA 658", " "))
temp <- c(temp, strsplit("Coleoptera Curculionidae Listronotus Listronotus_oregonensis 1293.28 67 53091 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Lobocla Lobocla_liliana 396.376 1.33 1074 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Lobocla Lobocla_nepos 192.437 0.64 355 NA 658", " "))
temp <- c(temp, strsplit("Orthoptera Acrididae Locusta Locusta_migratoria 5759.8 114 9587 6298.32 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Losaria Losaria_neptunus 244.117 0.81 2068 NA 658", " "))
temp <- c(temp, strsplit("Diptera Calliphoridae Lucilia Lucilia_cuprina 378.274 158.3 94823 616.14 658", " "))
temp <- c(temp, strsplit("Diptera Calliphoridae Lucilia Lucilia_sericata 319.935 8.5 1613 674.82 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Luehdorfia Luehdorfia_chinensis 727.361 100 5903040 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Luehdorfia Luehdorfia_japonica 506.812 1.69 1327 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Lycaenidae Lycaena Lycaena_phlaeas 420.468 55 18072480 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Lychnuchoides Lychnuchoides_ozias 385.305 1.29 1985 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Erebidae Lymantria Lymantria_dispar 998.43 115 661876 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Erebidae Lymantria Lymantria_monacha 915.653 39 33489103 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Lycaenidae Lysandra Lysandra_bellargus 528.918 52 2881691 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Lycaenidae Lysandra Lysandra_coridon 540.719 47 2004790 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Braconidae Lysiphlebus Lysiphlebus_fabarum 140.706 30 216143 NA 658", " "))
temp <- c(temp, strsplit("Hemiptera Pseudococcidae Maconellicoccus Maconellicoccus_hirsutus 163.045 40 44863 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Braconidae Macrocentrus Macrocentrus_cingulum 127.916 750 65089 156.48 658", " "))
temp <- c(temp, strsplit("Hymenoptera Melittidae Macropis Macropis_europaea 541.822 30 8431811 NA 658", " "))
temp <- c(temp, strsplit("Hemiptera Aphididae Macrosiphum Macrosiphum_rosae 568.543 50 6600 NA 658", " "))
temp <- c(temp, strsplit("Hemiptera Cicadidae Magicicada Magicicada_septendecim 1579.03 120 14990 NA 658", " "))
temp <- c(temp, strsplit("Hemiptera Cicadidae Magicicada Magicicada_septendecula 1585.98 180 8221 NA 658", " "))
temp <- c(temp, strsplit("Coleoptera Melyridae Malachius Malachius_bipustulatus 544.241 32 5740145 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Noctuidae Mamestra Mamestra_brassicae 576.169 35 17758554 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Noctuidae Mamestra Mamestra_configurata 571.308 7438 42480 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Sphingidae Manduca Manduca_sexta 470.021 38 424948 420.54 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Maniola Maniola_jurtina 402.039 76 13288869 NA 658", " "))
temp <- c(temp, strsplit("Diptera Cecidomyiidae Mayetiola Mayetiola_destructor 185.828 34 14032 136.92 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Meandrusa Meandrusa_sciron 440.507 1.47 2584 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Megachilidae Megachile Megachile_rotundata 272.661 300 64153 811.74 658", " "))
temp <- c(temp, strsplit("Hymenoptera Halictidae Megalopta Megalopta_genalis 390.114 51.25 30643 NA 658", " "))
temp <- c(temp, strsplit("Diptera Phoridae Megaselia Megaselia_abdita 412.271 20.1 3270 557.46 658", " "))
temp <- c(temp, strsplit("Diptera Phoridae Megaselia Megaselia_scalaris 489.347 NA 931 469.44 658", " "))
temp <- c(temp, strsplit("Hemiptera Aphididae Melanaphis Melanaphis_sacchari 300.272 100 275006 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Riodinidae Melanis Melanis_pixe 565.955 1.89 1328 NA 658", " "))
temp <- c(temp, strsplit("Diptera Syrphidae Melanostoma Melanostoma_mellinum 731.024 26 4649678 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Melitaea Melitaea_cinxia 499.398 28 7977876 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Mellicta Mellicta_athalia 609.55 30 9808070 NA 658", " "))
temp <- c(temp, strsplit("Strepsiptera Mengenillidae Mengenilla Mengenilla_moldrzyki 155.727 16 4038 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Noctuidae Mesoligia Mesoligia_furuncula 889.612 24 4695465 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Riodinidae Mesosemia Mesosemia_grandis 473.097 1.58 2427 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Metardaris Metardaris_cosinga 342.57 1.14 1931 NA 658", " "))
temp <- c(temp, strsplit("Hemiptera Aphididae Metopolophium Metopolophium_dirhodum 480.812 85.31 7032305 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Microceris Microceris_merops 365.058 1.22 5562 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Microceris Microceris_scylla 371.33 1.24 5499 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Braconidae Microplitis Microplitis_demolitor 241.19 26 14116 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Milanion Milanion_marciana 355.847 1.19 1206 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Sphingidae Mimas Mimas_tiliae 477.966 37 17797476 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Mimoides Mimoides_lysithous 458.291 1.53 4663 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Mimoniades Mimoniades_nurscia 357.099 1.2 5810 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Mimoniades Mimoniades_ocyalus 363.161 1.21 4789 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Mimoniades Mimoniades_versicolor 347.077 1.16 4168 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Crabronidae Mimumesa Mimumesa_dahlbomi 286.146 52 9606734 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Formicidae Monomorium Monomorium_pharaonis 325.507 96 1861574 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Morvina Morvina_fissimacula 366.893 1.22 1296 NA 658", " "))
temp <- c(temp, strsplit("Diptera Muscidae Musca Musca_domestica 750.404 76 11807 948.66 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Muschampia Muschampia_antonia 305.32 1.02 456 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Muschampia Muschampia_leuzeae 28.5928 0.1 288 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Muschampia Muschampia_lutulenta 72.459 0.24 307 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Muschampia Muschampia_mohammed 10.1516 0.04 295 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Muschampia Muschampia_musta 343.615 1.15 782 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Muschampia Muschampia_nomas 290.257 0.97 527 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Muschampia Muschampia_poggei 307.651 1.03 492 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Muschampia Muschampia_proteides 83.9602 1.47 1884 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Muschampia Muschampia_proto 20.5577 0.07 289 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Muschampia Muschampia_tersa 368.092 1.23 789 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Muschampia Muschampia_tessellum 318.636 1.06 593 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Mylon Mylon_lassia 246.199 0.82 460 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Myscelus Myscelus_amystis 277.532 0.93 6707 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Mysoria Mysoria_affinis 15.0098 0.05 276 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Mysoria Mysoria_ambigua 353.993 1.18 5959 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Mysoria Mysoria_barcastus 268.184 0.89 567 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Mysoria Mysoria_galgala 195.324 0.67 419 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Mysoria Mysoria_sejanus 359.431 1.2 4740 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Noctuidae Mythimna Mythimna_ferrago 861.027 31 27190380 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Noctuidae Mythimna Mythimna_impura 949.116 38 23340292 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Noctuidae Mythimna Mythimna_separata 700.25 17 3403396 NA 658", " "))
temp <- c(temp, strsplit("Hemiptera Aphididae Myzus Myzus_persicae 347.296 200 218922 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Pteromalidae Nasonia Nasonia_giraulti 259.025 270 34917 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Pteromalidae Nasonia Nasonia_vitripennis 297.31 142 7180486 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Nastra Nastra_julia 267.235 0.89 2287 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Diprionidae Neodiprion Neodiprion_lecontei 239.777 112 87373 NA 658", " "))
temp <- c(temp, strsplit("Megaloptera Corydalidae Neoneuromus Neoneuromus_ignobilis 767.796 50 2248 NA 658", " "))
temp <- c(temp, strsplit("Hemiptera Miridae Nesidiocoris Nesidiocoris_tenuis 355.121 25 13359 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Cynipidae Neuroterus Neuroterus_quercusbaccarum 2569.68 22 1019 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Nicephellus Nicephellus_nicephorus 341.487 1.14 1155 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Niconiades Niconiades_incomptus 395.815 1.32 1559 NA 658", " "))
temp <- c(temp, strsplit("Coleoptera Silphidae Nicrophorus Nicrophorus_orbicollis 192.639 350 13046 NA 658", " "))
temp <- c(temp, strsplit("Coleoptera Silphidae Nicrophorus Nicrophorus_vespilloides 195.273 175 67958 NA 658", " "))
temp <- c(temp, strsplit("Hemiptera Delphacidae Nilaparvata Nilaparvata_lugens 1087.81 418 583858 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Noctuidae Noctua Noctua_fimbriata 573.94 20 4379755 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Noctuidae Noctua Noctua_janthe 532.771 48 18438343 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Noctuidae Noctua Noctua_pronuba 529.179 47 16195000 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Noctuana Noctuana_haematospila 256.222 0.86 3959 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Noctuana Noctuana_stator 247.847 0.83 6377 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Apidae Nomada Nomada_fabriciana 233.584 99 13396754 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Nosphistia Nosphistia_zonara 360.186 1.2 1356 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Notamblyscirtes Notamblyscirtes_simius 112.109 0.38 332 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Tortricidae Notocelia Notocelia_uddmanniana 794.107 18 6700113 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Notocrypta Notocrypta_feisthamelii 352.625 1.18 962 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Notodontidae Notodonta Notodonta_dromedarius 341.976 77 10324145 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Nymphalis Nymphalis_io 384.157 64 12944774 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Nymphalis Nymphalis_polychloros 398.098 36 13933406 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Riodinidae Nymphidium Nymphidium_onaeum 419.411 1.4 911 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Crabronidae Nysson Nysson_spinosus 314.616 54 7396645 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Ochlodes Ochlodes_sylvanus 379.669 23 6806391 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Noctuidae Ochropleura Ochropleura_plecta 643.947 46 9617699 NA 658", " "))
temp <- c(temp, strsplit("Coleoptera Staphylinidae Ocypus Ocypus_olens 1083.85 40 4567902 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Formicidae Odontomachus Odontomachus_brunneus 393.037 40 22002 430.32 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Oechydrus Oechydrus_chersis 395.907 1.33 2086 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Oileides Oileides_vulpinus 41.2647 0.14 262 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Noctuidae Omphaloscelis Omphaloscelis_lunosa 661.859 29 21574654 NA 658", " "))
temp <- c(temp, strsplit("Hemiptera Lygaeidae Oncopeltus Oncopeltus_fasciatus 1099.61 106.9 11156 NA 658", " "))
temp <- c(temp, strsplit("Coleoptera Scarabaeidae Onthophagus Onthophagus_taurus 267.079 86 101202 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Formicidae Ooceraea Ooceraea_biroi 223.876 100 3735272 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Geometridae Operophtera Operophtera_brumata 638.208 35 28848 NA 658", " "))
temp <- c(temp, strsplit("Coleoptera Chrysomelidae Ophraella Ophraella_communa 774.411 40 195463 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Erebidae Orgyia Orgyia_antiqua 480.095 14 32004277 NA 658", " "))
temp <- c(temp, strsplit("Hemiptera Anthocoridae Orius Orius_laevigatus 150.957 432 104060 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Ornithoptera Ornithoptera_priamus 1287.88 120 11782 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Ornithoptera Ornithoptera_richmondia 425.745 1.43 1327 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Orphe Orphe_vatinius 39.721 0.13 292 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Orses Orses_cynisca 303.334 1.01 1628 NA 658", " "))
temp <- c(temp, strsplit("Coleoptera Scarabaeidae Oryctes Oryctes_rhinoceros 372.388 85 8606 NA 658", " "))
temp <- c(temp, strsplit("Coleoptera Silvanidae Oryzaephilus Oryzaephilus_surinamensis 104.009 43.2 19466 185.82 658", " "))
temp <- c(temp, strsplit("Hymenoptera Megachilidae Osmia Osmia_bicornis 222.969 93 9077890 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Megachilidae Osmia Osmia_lignaria 177.072 127 5475884 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Crambidae Ostrinia Ostrinia_furnacalis 437.28 213 474742 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Crambidae Ostrinia Ostrinia_nubilalis 454.916 95 10587 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Ouleus Ouleus_salvina 258.351 0.86 449 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Oxynetra Oxynetra_confusa 335.209 1.117632223 1568 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Oxynetra Oxynetra_hopfferi 292.344 0.975773867 1391 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Oxynetra Oxynetra_semihyalina 54.932 0.183142833 316 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Oxynetra Oxynetra_stangelandi 343.868 1.15 4335 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Pachliopta Pachliopta_kotzebuea 298.782 1 9296 NA 658", " "))
temp <- c(temp, strsplit("Hemiptera Aphalaridae Pachypsylla Pachypsylla_venusta 481.97 4897 17590 723.72 658", " "))
temp <- c(temp, strsplit("Lepidoptera Riodinidae Pachythone Pachythone_gigas 413.814 1.38 815 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Tortricidae Pammene Pammene_fasciana 564.421 36 16017629 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Panoquina Panoquina_ocola 322.144 1.08 3812 NA 658", " "))
temp <- c(temp, strsplit("Odonata Libellulidae Pantala Pantala_flavescens 663.274 80 16157025 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Papilio Papilio_alexanor 407.803 1.36 4381 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Papilio Papilio_ambrax 211.184 0.7 3714 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Papilio Papilio_bianor 402.688 2019 18540 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Papilio Papilio_clytia 340.409 1.14 7634 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Papilio Papilio_dardanus 231.123 78 20902 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Papilio Papilio_gigon 270.735 0.9 1321 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Papilio Papilio_glaucus 374.816 72 12225 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Papilio Papilio_joanae 368.019 1.23 1237 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Papilio Papilio_machaon 252.114 99 8641220 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Papilio Papilio_memnon 232.529 130 11857 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Papilio Papilio_polytes 227.006 595 47768 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Papilio Papilio_polyxenes 407.974 1.36 1672 254.28 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Papilio Papilio_protenor 260.288 0.87 1408 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Papilio Papilio_slateri 334.128 1.11 4422 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Papilio Papilio_thoas 339.518 1.13 1024 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Papilio Papilio_xuthus 243.89 300 128246 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Papilio Papilio_zelicaon 352.936 1.18 1569 NA 658", " "))
temp <- c(temp, strsplit("Hemiptera Pseudococcidae Paracoccus Paracoccus_marginatus 191.208 40 6250 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Crambidae Parapoynx Parapoynx_stratiotata 478.233 26 13784991 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Pararge Pararge_aegeria 516.571 42 19375358 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Parelbella Parelbella_ahira 346.316 1.15 10918 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Parelbella Parelbella_macleannani 339.861 1.13 4743 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Parelbella Parelbella_polyzona 336.277 1.12 4051 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Parides Parides_photinus 356.426 1.19 1971 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Parnara Parnara_guttata 208.911 0.7 542 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Parnassius Parnassius_apollo 1391.97 49 7071491 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Parnassius Parnassius_orleans 780.845 2.6 2674 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Parnassius Parnassius_smintheus 755.614 2.52 1739 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Passova Passova_gellias 289.263 0.96 5729 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Passova Passova_nigrocephala 41.9412 0.14 293 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Passova Passova_passova 309.168 1.03 1395 NA 658", " "))
temp <- c(temp, strsplit("Diptera Rhinophoridae Paykullia Paykullia_maculata 422.395 96 5917 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Pellicia Pellicia_arina 417.079 1.39 1338 NA 658", " "))
temp <- c(temp, strsplit("Hemiptera Aphididae Pentalonia Pentalonia_nigronervosa 375.223 45 64073 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Geometridae Peribatodes Peribatodes_rhomboidaria 499.713 44 15093624 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Perichares Perichares_adela 401.353 1.34 3219 NA 658", " "))
temp <- c(temp, strsplit("Blattodea Blattidae Periplaneta Periplaneta_americana 3374.84 295 50814 3334.98 658", " "))
temp <- c(temp, strsplit("Lepidoptera Notodontidae Phalera Phalera_bucephala 933.132 34 8469804 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Phareas Phareas_burnsi 480.083 1.6 4512 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Pharmacophagus Pharmacophagus_antenor 355.334 1.2 7932 NA 658", " "))
temp <- c(temp, strsplit("Hemiptera Pseudococcidae Phenacoccus Phenacoccus_solenopsis 292.538 382 489811 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Notodontidae Pheosia Pheosia_gnoma 271.334 60 7537178 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Notodontidae Pheosia Pheosia_tremula 290.205 73 7703384 NA 658", " "))
temp <- c(temp, strsplit("Hemiptera Aphrophoridae Philaenus Philaenus_spumarius 2760.69 56 12045 2581.92 658", " "))
temp <- c(temp, strsplit("Diptera Psychodidae Phlebotomus Phlebotomus_papatasi 363.768 15.1 5795 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Noctuidae Phlogophora Phlogophora_meticulosa 538.644 45 17289153 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Phocides Phocides_pigmalion 416.404 1.39 9497 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Pieridae Phoebis Phoebis_sennae 287.49 100 26405 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Pholisora Pholisora_mejicanus 320.99 1.07 609 NA 658", " "))
temp <- c(temp, strsplit("Diptera Calliphoridae Phormia Phormia_regina 532.827 44 5106 528.12 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Phortica Phortica_variegata 155.55 14.9 6905 NA 658", " "))
temp <- c(temp, strsplit("Coleoptera Lampyridae Photinus Photinus_pyralis 471.511 40 170308 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Pieridae Pieris Pieris_brassicae 292.326 92 21291167 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Pieridae Pieris Pieris_napi 319.989 91 10922705 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Pieridae Pieris Pieris_rapae 256.355 56 10651053 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Piruna Piruna_aea 337.836 1.13 1331 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Piruna Piruna_pirus 357.798 1.19 1380 NA 658", " "))
temp <- c(temp, strsplit("Diptera Syrphidae Platycheirus Platycheirus_albimanus 677.802 50 5597966 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Lycaenidae Plebejus Plebejus_anna 269.096 0.9 2041 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Lycaenidae Plebejus Plebejus_argus 382.093 23 3678063 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Lycaenidae Plebejus Plebejus_idas 280.92 0.94 1710 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Lycaenidae Plebejus Plebejus_melissa 278.397 0.93 1770 NA 658", " "))
temp <- c(temp, strsplit("Trichoptera Polycentropodidae Plectrocnemia Plectrocnemia_conspersa 396.695 100 868980 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Pyralidae Plodia Plodia_interpunctella 382.236 100 311734 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Plutellidae Plutella Plutella_xylostella 328.847 27 4976034 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Formicidae Pogonomyrmex Pogonomyrmex_californicus 241.055 75 36058 244.5 658", " "))
temp <- c(temp, strsplit("Coleoptera Carabidae Pogonus Pogonus_chalceus 280.876 30 5623 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Vespidae Polistes Polistes_canadensis 211.202 100 29465 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Vespidae Polistes Polistes_dominula 208.026 243.3 42260 293.4 658", " "))
temp <- c(temp, strsplit("Hymenoptera Vespidae Polistes Polistes_fuscatus 219.117 110 879627 400.98 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Polyctor Polyctor_polyctor 359.437 1.2 1204 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Polygonus Polygonus_leo 444.669 1.48 4805 NA 658", " "))
temp <- c(temp, strsplit("Diptera Chironomidae Polypedilum Polypedilum_vanderplanki 118.969 375 219078 97.8 658", " "))
temp <- c(temp, strsplit("Coleoptera Scarabaeidae Popillia Popillia_japonica 531.53 40 13656 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Potamanaxas Potamanaxas_melicertes 296.341 0.99 1360 NA 658", " "))
temp <- c(temp, strsplit("Coleoptera Cupedidae Priacma Priacma_serrata 12.0783 0 4805 1036.68 658", " "))
temp <- c(temp, strsplit("Diptera Asilidae Proctacanthus Proctacanthus_coquilletti 208.908 132 781095 NA 658", " "))
temp <- c(temp, strsplit("Diptera Chironomidae Propsilocerus Propsilocerus_akamusi 85.8369 112 6207813 NA 658", " "))
temp <- c(temp, strsplit("Coleoptera Scarabaeidae Protaetia Protaetia_brevitarsis 1143.9 150 318221 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Proteides Proteides_mercurius 294.946 0.98 643 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Protelbella Protelbella_alburna 35.7571 0.12 286 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Protesilaus Protesilaus_protesilaus 858.086 2.86 1249 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Formicidae Pseudomyrmex Pseudomyrmex_concolor 196.808 81 14566 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Formicidae Pseudomyrmex Pseudomyrmex_cubaensis 204.625 61 33812 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Formicidae Pseudomyrmex Pseudomyrmex_elongatus 244.059 91 24312 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Formicidae Pseudomyrmex Pseudomyrmex_flavicornis 198.473 66 35663 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Formicidae Pseudomyrmex Pseudomyrmex_gracilis 282.776 89 38830 391.2 658", " "))
temp <- c(temp, strsplit("Hymenoptera Formicidae Pseudomyrmex Pseudomyrmex_pallidus 200.367 77 22233 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Pseudonascus Pseudonascus_paulliniae 266.513 0.89 574 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Pseudosarbia Pseudosarbia_flavofasciata 16.3382 0.06 283 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Pteromalidae Pteromalus Pteromalus_puparum 338.171 241 98825 NA 658", " "))
temp <- c(temp, strsplit("Coleoptera Carabidae Pterostichus Pterostichus_madidus 705.14 34 15821749 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Notodontidae Ptilodon Ptilodon_capucinus 348.696 55 12643213 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Pyrgus Pyrgus_malvae 724.634 69 25951495 NA 658", " "))
temp <- c(temp, strsplit("Coleoptera Pyrochroidae Pyrochroa Pyrochroa_serraticornis 249.397 26 12970676 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Pyrrhopyge Pyrrhopyge_creona 381.594 1.27 1663 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Pyrrhopyge Pyrrhopyge_cressoni 19.5965 0.07 292 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Pyrrhopyge Pyrrhopyge_crida 360.757 1.2 1137 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Pyrrhopyge Pyrrhopyge_kelita 259.801 0.866219257 471 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Pyrrhopyge Pyrrhopyge_papius 360.707 1.204129537 797 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Pyrrhopyge Pyrrhopyge_pelota 411.088 1.37 1817 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Pyrrhopyge Pyrrhopyge_phidias 24.843 0.08 286 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Pyrrhopyge Pyrrhopyge_proculus 25.2051 0.084495573 284 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Pyrrhopyge Pyrrhopyge_sadia 355.597 1.19 1268 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Pyrrhopyge Pyrrhopyge_schausi 7.73839 0.03 301 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Pyrrhopyge Pyrrhopyge_sergius 391.702 1.305810873 1105 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Pyrrhopyge Pyrrhopyge_tatei 4.58117 0.02 317 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Pyrrhopyge Pyrrhopyge_thericles 34.3765 0.114758443 290 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Pyrrhopyge Pyrrhopyge_zenodorus 410.872 1.37 2043 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Pythonides Pythonides_amaryllis 286.948 0.96 693 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Quadrus Quadrus_cerialis 345.573 1.15 702 NA 658", " "))
temp <- c(temp, strsplit("Diptera Tephritidae Rhagoletis Rhagoletis_pomonella 1223.29 20 23570 948.66 658", " "))
temp <- c(temp, strsplit("Diptera Tephritidae Rhagoletis Rhagoletis_zephyria 1113.96 35 19348 NA 658", " "))
temp <- c(temp, strsplit("Coleoptera Cantharidae Rhagonycha Rhagonycha_fulva 424.662 41 21086067 NA 658", " "))
temp <- c(temp, strsplit("Hemiptera Reduviidae Rhodnius Rhodnius_prolixus 706.824 8.3 35751 733.5 658", " "))
temp <- c(temp, strsplit("Hemiptera Aphididae Rhopalosiphum Rhopalosiphum_maidis 326.023 208 9046396 NA 658", " "))
temp <- c(temp, strsplit("Coleoptera Curculionidae Rhynchophorus Rhynchophorus_ferrugineus 782.098 108 23825 NA 658", " "))
temp <- c(temp, strsplit("Hemiptera Alydidae Riptortus Riptortus_pedestris 1079.52 100 161368828 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Salantoia Salantoia_eriopis 96.2003 0.32 309 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Salatis Salatis_canalis 312.72 1.04 1385 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Saturniidae Samia Samia_ricini 450.479 100 21366385 NA 658", " "))
temp <- c(temp, strsplit("Diptera Sarcophagidae Sarcophaga Sarcophaga_bullata 476.287 67 19090 NA 658", " "))
temp <- c(temp, strsplit("Diptera Sarcophagidae Sarcophaga Sarcophaga_peregrina 560.735 104 3839545 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Riodinidae Sarota Sarota_myrtea 331.774 1.11 625 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Satarupa Satarupa_nymphalis 318.674 1.07 2307 NA 658", " "))
temp <- c(temp, strsplit("Diptera Syrphidae Scaeva Scaeva_pyrastri 320.03 119 8651641 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Scaptodrosophila Scaptodrosophila_lebanonensis 187.417 26.8 7584 234.72 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Scaptomyza Scaptomyza_graminum 137.787 139.3 17407008 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Scaptomyza Scaptomyza_montana 229.077 103 2436812 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Scaptomyza Scaptomyza_pallida 201.65 157.2 4279569 NA 658", " "))
temp <- c(temp, strsplit("Hemiptera Aphididae Schizaphis Schizaphis_graminum 499.222 25 15350123 518.34 658", " "))
temp <- c(temp, strsplit("Hemiptera Pemphigidae Schlechtendalia Schlechtendalia_chinensis 280.428 470 3390999 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Erebidae Schrankia Schrankia_costaestrigalis 571.976 38 14389424 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Crambidae Scirpophaga Scirpophaga_incertulas 308.37 45 1243 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Halictidae Seladonia Seladonia_tumulorum 375.928 58 15130577 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Sericinus Sericinus_montela 553.137 1.84 3585 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Noctuidae Sesamia Sesamia_nonagrioides 1021.25 38.9 1074562 948.66 658", " "))
temp <- c(temp, strsplit("Lepidoptera Sesiidae Sesia Sesia_apiformis 546.793 26 19957231 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Signeta Signeta_flammeata 373.279 1.24 628 NA 658", " "))
temp <- c(temp, strsplit("Hemiptera Aphididae Sipha Sipha_flava 353.18 60 163055 NA 658", " "))
temp <- c(temp, strsplit("Hemiptera Aphididae Sitobion Sitobion_avenae 393.019 242 244199 NA 658", " "))
temp <- c(temp, strsplit("Diptera Cecidomyiidae Sitodiplosis Sitodiplosis_mosellana 208.784 57 62752 NA 658", " "))
temp <- c(temp, strsplit("Coleoptera Curculionidae Sitophilus Sitophilus_oryzae 770.55 101 1039787 NA 658", " "))
temp <- c(temp, strsplit("Hemiptera Delphacidae Sogatella Sogatella_furcifera 656.292 340 57334 694.38 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Sostrata Sostrata_bifasciata 244.636 0.82 576 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Spathilepia Spathilepia_clonius 406.289 1.35 4123 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Halictidae Sphecodes Sphecodes_monilicornis 491.794 34 7420798 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Spialia Spialia_ali 23.2916 0.08 289 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Spialia Spialia_doris 49.977 0.17 327 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Spialia Spialia_mafa 282.096 0.94 1183 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Spialia Spialia_orbifer 198.835 0.66 502 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Spialia Spialia_phlomidis 282.135 0.94 814 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Spialia Spialia_sertorius 216.414 0.72 529 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Spialia Spialia_spio 277.439 0.92 2151 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Spialia Spialia_struvei 30.836 0.1 291 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Erebidae Spilarctia Spilarctia_lutea 584.772 28 19053634 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Erebidae Spilosoma Spilosoma_lubricipeda 587.347 39 20639572 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Spioniades Spioniades_abbreviata 386.11 1.29 1963 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Noctuidae Spodoptera Spodoptera_exigua 446.801 85 3467000 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Noctuidae Spodoptera Spodoptera_frugiperda 486.272 374 1129999 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Noctuidae Spodoptera Spodoptera_litura 438.941 111 68350 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Riodinidae Stalachtis Stalachtis_halloweeni 366.973 1.22 447 NA 658", " "))
temp <- c(temp, strsplit("Trichoptera Stenopsychidae Stenopsyche Stenopsyche_tienmushanensis 451.494 300 1296863 NA 658", " "))
temp <- c(temp, strsplit("Hemiptera Pentatomidae Stiretrus Stiretrus_anchorago 866.582 120 36287 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Riodinidae Styx Styx_infernalis 449.824 1.51 1717 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Riodinidae Symmachia Symmachia_rubina 587.429 1.96 713 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Sesiidae Synanthedon Synanthedon_vespiformis 287.384 94 10304072 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Cynipidae Synergus Synergus_japonicus 226.414 132 55627 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Cynipidae Synergus Synergus_umbraculus 235.334 365 42371 NA 658", " "))
temp <- c(temp, strsplit("Diptera Syrphidae Syritta Syritta_pipiens 318.507 44 28212948 NA 658", " "))
temp <- c(temp, strsplit("Diptera Tachinidae Tachina Tachina_fera 751.72 41 16231967 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Taenaris Taenaris_catops 456.368 260 54861 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Tagiades Tagiades_gana 340.719 1.137479993 970 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Tagiades Tagiades_litigiosa 272.162 0.91 2329 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Teinopalpus Teinopalpus_imperialis 478.053 1.59 5488 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Telemiades Telemiades_fides 345.401 1.15 1517 NA 658", " "))
temp <- c(temp, strsplit("Orthoptera Gryllidae Teleogryllus Teleogryllus_occipitalis 1933.83 88 197533 NA 658", " "))
temp <- c(temp, strsplit("Diptera Diopsidae Teleopsis Teleopsis_dalmanni 623.66 106.73 62489 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Formicidae Temnothorax Temnothorax_curvispinosus 303.539 41 38942 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Formicidae Temnothorax Temnothorax_longispinosus 260.682 85 30134 NA 658", " "))
temp <- c(temp, strsplit("Coleoptera Tenebrionidae Tenebrio Tenebrio_molitor 294.395 103 23310 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Tenthredinidae Tenthredo Tenthredo_notha 252.822 77 7016856 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Apidae Tetragonula Tetragonula_clypearis 294.05 37 14852 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Formicidae Tetramorium Tetramorium_bicarinatum 229.238 150 28450 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Formicidae Tetramorium Tetramorium_immigrans 227.079 150 29160 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Notodontidae Thaumetopoea Thaumetopoea_pityocampa 593.43 250 4075 NA 658", " "))
temp <- c(temp, strsplit("Diptera Tachinidae Thecocarcelia Thecocarcelia_acutangulata 692.88 40 32012514 NA 658", " "))
temp <- c(temp, strsplit("Diptera Sepsidae Themira Themira_minor 99.8855 21.8 2825 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Riodinidae Theope Theope_publius 370.723 1.24 484 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Riodinidae Thisbe Thisbe_lycorias 363.11 1.21 1855 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Drepanidae Thyatira Thyatira_batis 314.784 29 7458081 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Thymelicus Thymelicus_lineola 299.932 1 1182 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Thymelicus Thymelicus_sylvestris 470.71 40 16606550 NA 658", " "))
temp <- c(temp, strsplit("Phasmatodea Timematidae Timema Timema_californicum 1220.42 68 17799 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Timochares Timochares_trifasciata 271.934 0.91 376 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Tineidae Tinea Tinea_semifulvella 596.585 45 12032256 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Tineidae Tinea Tinea_trinotella 371.722 33 13660558 NA 658", " "))
temp <- c(temp, strsplit("Diptera Tipulidae Tipula Tipula_oleracea 541.697 6.1 600 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Formicidae Trachymyrmex Trachymyrmex_cornetzi 369.438 109 29356 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Formicidae Trachymyrmex Trachymyrmex_septentrionalis 291.747 102 14962 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Trapezites Trapezites_symmomus 105.982 0.36 314 NA 658", " "))
temp <- c(temp, strsplit("Hemiptera Aleyrodidae Trialeurodes Trialeurodes_vaporariorum 842.015 100 16012 NA 658", " "))
temp <- c(temp, strsplit("Hemiptera Reduviidae Triatoma Triatoma_infestans 949.486 200 95318 1618.59 658", " "))
temp <- c(temp, strsplit("Coleoptera Tenebrionidae Tribolium Tribolium_castaneum 165.929 7 73049 205.38 658", " "))
temp <- c(temp, strsplit("Coleoptera Tenebrionidae Tribolium Tribolium_confusum 305.133 80 4094517 NA 658", " "))
temp <- c(temp, strsplit("Coleoptera Tenebrionidae Tribolium Tribolium_madens 149.378 22 76672 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Trichogrammatidae Trichogramma Trichogramma_brassicae 235.387 162 556663 244.5 658", " "))
temp <- c(temp, strsplit("Hymenoptera Trichogrammatidae Trichogramma Trichogramma_evanescens 213.671 100 27346 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Pteromalidae Trichomalopsis Trichomalopsis_sarcophagae 236.426 74 9960 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Noctuidae Trichoplusia Trichoplusia_ni 368.211 600 621965 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Trogonoptera Trogonoptera_brookiana 265.142 0.88 2264 NA 658", " "))
temp <- c(temp, strsplit("Diptera Tephritidae Trupanea Trupanea_jonesi 97.2813 8.4 865 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Gelechiidae Tuta Tuta_absoluta 906.54 71 20713 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Typhedanus Typhedanus_ampyx 169.682 0.57 427 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Udranomia Udranomia_eurus 340.448 1.14 4116 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Udranomia Udranomia_kikkawai 387.645 1.29 2216 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Udranomia Udranomia_orcinus 336.236 1.12 3331 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Urbanus Urbanus_esmeraldus 352.927 1.18 1693 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Urbanus Urbanus_evona 325.389 1.09 1455 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Urbanus Urbanus_proteus 417.918 1.39 6389 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Urbanus Urbanus_velinus 377.465 1.26 2090 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Vanessa Vanessa_atalanta 370.421 34 12152710 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Vanessa Vanessa_cardui 424.798 25 7041724 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Nymphalidae Vanessa Vanessa_tameamea 357.125 50.6 254123 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Venada Venada_nevada 425.885 1.42 1612 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Ichneumonidae Venturia Venturia_canescens 290.76 40 11235615 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Vespidae Vespa Vespa_crabro 229.579 70 2980993 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Vespidae Vespa Vespa_mandarinia 247.71 135 2778186 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Vespidae Vespa Vespa_velutina 193.977 56 1520875 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Vespidae Vespula Vespula_germanica 178.197 152 84379 224.94 658", " "))
temp <- c(temp, strsplit("Hymenoptera Vespidae Vespula Vespula_pensylvanica 179.37 644 96617 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Vespidae Vespula Vespula_vulgaris 176.273 97 7528 195.6 658", " "))
temp <- c(temp, strsplit("Hymenoptera Formicidae Vollenhovia Vollenhovia_emeryi 287.901 47 32417 NA 658", " "))
temp <- c(temp, strsplit("Diptera Syrphidae Volucella Volucella_inanis 961.447 26 30067333 NA 658", " "))
temp <- c(temp, strsplit("Hymenoptera Formicidae Wasmannia Wasmannia_auropunctata 324.12 67 37912 NA 658", " "))
temp <- c(temp, strsplit("Diptera Syrphidae Xanthogramma Xanthogramma_pedissequum 977.154 36 7832695 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Noctuidae Xestia Xestia_nigrum 760.304 35 25037238 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Noctuidae Xestia Xestia_xanthographa 933.867 27 9149592 NA 658", " "))
temp <- c(temp, strsplit("Diptera Syrphidae Xylota Xylota_sylvarum 534.82 34 29218644 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Yanguna Yanguna_cometes 346.112 1.15 703 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Yanguna Yanguna_cosyra 373.502 1.245097603 2338 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Yanguna Yanguna_spatiosa 380.268 1.26763838 2424 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Yanguna Yanguna_thelersa 38.4852 0.12847163 289 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Ypsolophidae Ypsolopha Ypsolopha_scabrella 853.578 17 26541151 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Riodinidae Zabuella Zabuella_tenellus 228.289 0.76 405 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Zaprionus Zaprionus_africanus 162.494 96.6 11319005 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Zaprionus Zaprionus_camerounensis 167.163 177.6 14525333 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Zaprionus Zaprionus_davidi 156.05 133.2 16225587 166.26 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Zaprionus Zaprionus_gabonicus 187.603 105 13481452 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Zaprionus Zaprionus_ghesquierei 198.078 146.4 8961507 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Zaprionus Zaprionus_indianus 197.261 130.3 6768749 215.16 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Zaprionus Zaprionus_inermis 149.55 129 5752227 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Zaprionus Zaprionus_kolodkinae 182.973 106.6 6507380 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Zaprionus Zaprionus_lachaisei 148.388 83.6 9167822 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Zaprionus Zaprionus_nigranus 175.473 102.2 2235796 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Zaprionus Zaprionus_ornatus 206.773 139.3 11228854 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Zaprionus Zaprionus_taronus 162.913 54.6 5997490 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Zaprionus Zaprionus_tsacasi 165.519 174.6 5453558 NA 658", " "))
temp <- c(temp, strsplit("Diptera Drosophilidae Zaprionus Zaprionus_vittiger 162.326 152.2 8723810 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Pieridae Zerene Zerene_cesonia 266.406 195 43484 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Papilionidae Zerynthia Zerynthia_polyxena 467.435 1.56 1120 NA 658", " "))
temp <- c(temp, strsplit("Diptera Tephritidae Zeugodacus Zeugodacus_cucurbitae 374.805 66.2 17360 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Cossidae Zeuzera Zeuzera_pyrina 686.888 38 23452699 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Zonia Zonia_zonia 191.263 0.64 406 NA 658", " "))
temp <- c(temp, strsplit("Blattodea Termopsidae Zootermopsis Zootermopsis_nevadensis 485.009 98 22794 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Hesperiidae Zopyrion Zopyrion_sandace 243.637 0.82 380 NA 658", " "))
temp <- c(temp, strsplit("Lepidoptera Zygaenidae Zygaena Zygaena_filipendulae 365.947 58 12640274 NA 658", " "))

tax.info <- as.data.frame(do.call(rbind, lapply(temp, as.vector)))
tax.info <- tax.info[,c(1:9)]
names(tax.info) <- c("Order","Family","Genus","Species","Size.Mb","Coverage","N50","FCM","COI.Length")

#Concatenate all input files into a single table that will be used for the indel scan
all.input <- data.frame()
for (f in list.files(pattern = "*results.txt")) {
  input <- read.csv(f,header = T, sep = "\t")
  if (nrow(input) == 0) {   #if file contains no blast hits, create blank data frame
    query.id <- paste(sapply(strsplit(f,"_"),"[",c(1,2)),collapse = "_")
    query.id <- gsub(".blast",".COX1",query.id)
    input[1,1] <- query.id
    input$Subject_ID <- NA
    input$evalue <- NA
    input$Alignment_length <- 0
    input$percent_ID <- 0
  }
  all.input <- rbind(all.input,input)
}
all.input$Query_ID <- gsub(".COX1","",all.input$Query_ID)
names(all.input) <- c("Species","Subject_ID","E-Value","Alignment.Length","X..Pairwise.Identity")
to.indel.scan <- all.input[all.input$Alignment.Length != 0,c(2,3,4,5)]

#calculate species that failed BLAST but which we will add to the final results table
to.add.back <- data.frame("Species" = all.input[all.input$Alignment.Length == 0,1],
                          "NUMT.ID" = NA, "Sequence" = NA, "Temp.BOLD.ID" = NA, "Sequence.Length" = 0,
                          "Percent.ID" = 0, "Indel" = NA, "STOP" = NA, "IPSC" = NA)
to.add.back <- merge(to.add.back,tax.info, by = "Species")
to.add.back$Coverage <- as.numeric(to.add.back$Coverage)
to.add.back$Coverage[is.na(to.add.back$Coverage)] <- 0
to.add.back$Coverage.Category <- ifelse(to.add.back$Coverage < 5, "low","high")
to.add.back <- to.add.back[,c(1,10,11,12,2,3,4,5,6,7,8,9,13,15,16,14,18,17)]

#perform indel scan
output <- data.frame()

for (i in list.files(pattern = "*.blast_alignment.txt")) {
  #get input
  input <- read.table(i)
  name <- gsub(".blast_alignment.txt","",i)
  
  #remove blank lines
  if (nrow(input) >= 3) {
    input <- input[-seq(3,nrow(input),by = 3),]
  } else{
    input <- input[1:nrow(input),]
  }
  
  #rename sequence headers
  counter <- 1
  line <- 1
  while (line != length(input) + 1) {
    if(line %% 2 != 0) {
      input[line] <- gsub("Hsp_qseq",sprintf("%s|query-%03d",name,counter),input[line])
    } else {
      input[line] <- gsub("Hsp_hseq",sprintf("%s|subject-%03d",name,counter),input[line])
      counter <- counter + 1
    }
    line <- line + 1
  }
  
  #convert to dataframe and then count indels that are not a multiple of three
  df <- data.frame(input)
  df <- data.frame(df,do.call(rbind, strsplit(as.character(df$input),">",fixed=TRUE)))
  df <- df[,c(2,3)]
  names(df) <- c("Seq.Name","Sequence")
  df$Frameshift.Count <- NA
  
  for (f in 1:length(df$Seq.Name)){
    max.gaps <- 1:max(longestConsecutive(df$Sequence[f],"-"))
    indel.gaps <- max.gaps[!(!max.gaps%%3)]
    final.pattern <- as.character()
    for (i in indel.gaps) {
      temp <- paste("[A-Z]",paste(rep("-",i), collapse = ""),"[A-Z]", sep = "")
      final.pattern <- paste(final.pattern,temp,sep = "|")
    }
    final.pattern <- sub('.', '', final.pattern)
    frameshift.count <- sum(gregexpr(final.pattern, df$Sequence[f], ignore.case = TRUE)[[1]] > 0)
    df$Frameshift.Count[f] <- frameshift.count
  }
  
  #Append indel count to master file
  output <- rbind(output,df)
  
}

#calculate and output summary results
output.summary <- data.frame(output,do.call(rbind, strsplit(as.character(output$Seq.Name),"-",fixed=TRUE)))
output.summary <- output.summary[,c(4,5,3,2)]
names(output.summary) <- c("Species","NUMT.ID","Frameshift.Count","Sequence")
output.summary$NUMT.ID <- paste("numt",output.summary$NUMT.ID,sep = "-")
output.numts <- output.summary
output.summary$Species <- gsub("\\|query|\\|subject","",output.summary$Species)
output.summary <- aggregate(Frameshift.Count~Species + NUMT.ID, data = output.summary, FUN = sum)
output.summary <- output.summary[order(output.summary$Species),]
output.numts <- output.numts[grep(pattern = "subject",output.numts$Species),]
output.numts$Species <- gsub("\\|subject","",output.numts$Species)
output.summary$Index <- paste(output.summary$Species,output.summary$NUMT.ID,sep="|")
output.numts$Index <- paste(output.numts$Species,output.numts$NUMT.ID,sep = "|")
output.numts <- merge(output.numts,output.summary,by = "Index")
output.numts$Indel <- ifelse(output.numts$Frameshift.Count.y != 0,"Yes","No")
output.numts <- output.numts[,c(2,3,5,9)]
names(output.numts) <- c("Species","NUMT.ID","Sequence","Indel")
output.numts$Temp.BOLD.ID <- sprintf("SPRD%03d-22",seq(1:nrow(output.numts)))
output.numts$Sequence <- gsub("-","",output.numts$Sequence) # remove gaps in NUMT sequences
output.numts$Sequence.Length <- nchar(output.numts$Sequence)
output.numts$STOP <- ""
output.numts$IPSC <- ""
output.numts <- cbind(output.numts,to.indel.scan)
output.numts <- output.numts[,c(1:6,12,7,8)]
output.numts <- merge(output.numts,tax.info, by = 'Species') #Add taxonomy and other metadata
output.numts$Coverage <- as.numeric(output.numts$Coverage)
output.numts$Coverage[is.na(output.numts$Coverage)] <- 0 #replace NA coverage with 0
output.numts$Coverage.Category <- ifelse(output.numts$Coverage < 5, "low","high") #rank coverage
output.numts <- output.numts[,c(1,10,11,12,2,3,5,6,7,4,8,9,13,15,16,14,18,17)]
names(output.numts)[9] <- "Percent.ID"

#create and output FASTA file of NUMTs
#these will be uploaded to BOLD for stop codon screening
output.fasta <- output.numts[,c(7,6)]
output.fasta <- output.fasta[nchar(output.fasta$Sequence) > 50,]
output.fasta$Temp.BOLD.ID <- paste(">",output.fasta$Temp.BOLD.ID,sep = "") #add > to sequence headers
output.fasta <- do.call(rbind, lapply(seq(nrow(output.fasta)), function(i) t(output.fasta[i, ]))) #shift sequences below headers
write.table(file = "NUMT_IPSC_ToBOLD.fasta",output.fasta, row.names = FALSE, col.names = FALSE, quote = FALSE) #output while removing column and row names

#add species with no NUMTs to output.numts
output.numts <- rbind(output.numts,to.add.back)
output.numts$Species <- gsub("_"," ",output.numts$Species)
output.numts <- output.numts[order(output.numts$Order, output.numts$Family, output.numts$Species),]

#convert Sequence.Length to Sequence.Coverage using COI.Length and output all hits
output.numts$Sequence.Coverage <- as.numeric(output.numts$Sequence.Length)/as.numeric(output.numts$COI.Length)
output.numts <- output.numts[,c(1:8,19,9:18)]
write.csv(output.numts,"NUMT_All_Hits_Results.csv", quote = F, row.names = FALSE)

#reduce data set to genomes with high coverage and NUMT >= 100 bp and not [> 99% ID and with 100% coverage +- 1 bp]
all.input <- output.numts[output.numts$Coverage.Category == "high",]
all.input <- all.input[all.input$Sequence.Length >= 100,]
all.input <- all.input[!(all.input$Percent.ID >= 99 & all.input$Sequence.Coverage >=0.998 & all.input$Sequence.Coverage <=1.002),]

#add missing species back to 'reliable hits' data set
missing.species <- output.numts[!(output.numts$Species %in% all.input$Species),]
missing.species <- missing.species[!duplicated(missing.species$Species),]
missing.species <- missing.species[missing.species$Coverage.Category == "high",]
missing.species[,c(8,9,10)] <- 0
missing.species[,c(5,6,7,11,12,13)] <- NA
all.input <- rbind(all.input,missing.species)
write.csv(all.input,"NUMT_Reliable_Hits_Results.csv", quote = F, row.names = F)