#requirements: three tree files in Newick format: NUMT_w_COI_Tree1.tre, NUMT_w_COI_Tree2.tre, and NUMT_w_COI_Tree3.tre
#requirements: NUMT_w_COI_TreeData.txt

#set working directory and install required packages
setwd("/PATH/TO/WORKING/DIRECTORY")
require(ggplot2)
require(scales)
require(grid)
require(gridExtra)
require(phytools)
require(ggtreeExtra)
require(ggtree)
require(RColorBrewer)

####################################
####### TREE 1 #####################
####################################

#load tree file and extra data file
tree <- read.tree("NUMT_w_COI_Tree1.tre")
data.in <- read.csv("NUMT_w_COI_TreeData.txt", sep = "\t", header = TRUE)

#reduce data to only species contained within tree (if necessary)
data <- data.in[data.in$Tip.Labels %in% tree[4][[1]],]

#remove NUMT info from tip labels and associated data
tree[4][[1]] <- sapply(strsplit(as.character(tree[4][[1]]),"|",fixed=TRUE), "[[", 1)
data$Tip.Labels <- sapply(strsplit(as.character(data$Tip.Labels),"|",fixed=TRUE), "[[", 1)

#set order of Orders for plot legend
data$Species <- factor(data$Species, levels = unique(data$Species))

#add custom colours
number <- nlevels(data$Species)
palette <- rep(c("#cc0011","#ffaa00","#66cc33","#443333","#0099cc"), length.out = number)

#Create tree object and attach associated data
g.tree <- ggtree(tree, aes(color = Species), branch.length = "branch.length",layout = "rectangular", size = 1, colour = "black") %<+% data

g.tree +
              geom_tiplab(size = 5) +
              geom_treescale(x = 0, y = -1, width = 0.1) +
              scale_color_manual(breaks = levels(data$Species), values = palette, guide = "none") +
              scale_fill_manual(values = colours, guide = "none") +
              xlim(NA, 1) +
              #ylim(1, NA) +
              theme(plot.margin = unit(c(0,0,0,0),"cm"))
ggsave("Figure_11_Tree1.pdf", width = 20, height = 30, units = "in", limitsize = F)

 
#####################################
####### TREE 2 #####################
####################################

#load tree file and extra data file
tree <- read.tree("NUMT_w_COI_Tree2.tre")
data.in <- read.csv("NUMT_w_COI_TreeData.txt", sep = "\t", header = TRUE)

#reduce data to only species contained within tree (if necessary)
data <- data.in[data.in$Tip.Labels %in% tree[4][[1]],]

#remove NUMT info from tip labels and associated data
tree[4][[1]] <- sapply(strsplit(as.character(tree[4][[1]]),"|",fixed=TRUE), "[[", 1)
data$Tip.Labels <- sapply(strsplit(as.character(data$Tip.Labels),"|",fixed=TRUE), "[[", 1)

#set order of Orders for plot legend
data$Species <- factor(data$Species, levels = unique(data$Species))

#add custom colours
number <- nlevels(data$Species)
palette <- rep(c("#cc0011","#ffaa00","#66cc33","#443333","#0099cc"), length.out = number)


#Create tree object and attach associated data
g.tree <- ggtree(tree, aes(color = Species),branch.length = "branch.length", layout = "rectangular", size = 1, colour = "black") %<+% data

g.tree +
  geom_tiplab(size = 5) +
  geom_treescale(x = 0, y = -1, width = 0.1) +
  scale_color_manual(breaks = levels(data$Species), values = palette, guide = "none") +
  scale_fill_manual(values = colours, guide = "none") +
  xlim(NA, 2) +
  #ylim(1, NA) +
  theme(plot.margin = unit(c(0,0,0,0),"cm"))
ggsave("Figure_11_Tree2.pdf", width = 10, height = 30, units = "in", limitsize = F)


####################################
####### TREE 3 #####################
####################################

#load tree file and extra data file
tree <- read.tree("NUMT_w_COI_Tree3.tre")
data.in <- read.csv("NUMT_w_COI_TreeData.txt", sep = "\t", header = TRUE)

#reduce data to only species contained within tree (if necessary)
data <- data.in[data.in$Tip.Labels %in% tree[4][[1]],]

#remove NUMT info from tip labels and associated data
tree[4][[1]] <- sapply(strsplit(as.character(tree[4][[1]]),"|",fixed=TRUE), "[[", 1)
data$Tip.Labels <- sapply(strsplit(as.character(data$Tip.Labels),"|",fixed=TRUE), "[[", 1)

#set order of Orders for plot legend
data$Species <- factor(data$Species, levels = unique(data$Species))

#add custom colours
number <- nlevels(data$Species)
palette <- rep(c("#cc0011","#ffaa00","#66cc33","#443333","#0099cc"), length.out = number)


#Create tree object and attach associated data
g.tree <- ggtree(tree, aes(color = Species), branch.length = "branch.length",layout = "rectangular", size = 1, colour = "black") %<+% data

g.tree +
  geom_tiplab(size = 5) +
  scale_color_manual(breaks = levels(data$Species), values = palette, guide = "none") +
  scale_fill_manual(values = colours, guide = "none") +
  geom_treescale(x = 0, y = -1, width = 0.1) +
  xlim(NA, 2) +
  #ylim(1, NA) +
  theme(plot.margin = unit(c(0,0,0,0),"cm"))
ggsave("Figure_11_Tree3.pdf", width = 10, height = 30, units = "in", limitsize = F)
