#include "test_EccentricityExpansionCoefficients.h"

void test_EccentricityExpansionCoefficients::single_test(int m, int s,
		double e, unsigned max_e_power, bool deriv, double answer)
{
	std::ostringstream msg;
	msg.precision(16);
	msg.setf(std::ios_base::scientific);
	if(deriv) msg << "d/de";
	double value=__pms(m, s, e, max_e_power, deriv)/(2.0*M_PI);
	answer/=2.0*M_PI;
	msg << "P_{" << m << "," << s << "}(e=" << e << ")=" << value
		<< "+O(e^" << max_e_power+1 << "), expected " << answer
		<< "+O(e^" << max_e_power+1 << "), difference "
		<< value-answer;
	TEST_ASSERT_MSG(check_diff(value, answer, 1e-10, 0.0), 
			msg.str().c_str());
}

void test_EccentricityExpansionCoefficients::test_values()
{
    single_test(-2, -2, 0.3, 0, false, 1.e0);
    single_test(-2, -1, 0.3, 0, false, 0e0);
    single_test(-2, 0, 0.3, 0, false, 0e0);
    single_test(-2, 1, 0.3, 0, false, 0e0);
    single_test(-2, 2, 0.3, 0, false, 0e0);
    single_test(-2, -3, 0.3, 1, false, 1.05e0);
    single_test(-2, -2, 0.3, 1, false, 1.e0);
    single_test(-2, -1, 0.3, 1, false, -1.5e-1);
    single_test(-2, 0, 0.3, 1, false, 0e0);
    single_test(-2, 1, 0.3, 1, false, 0e0);
    single_test(-2, 2, 0.3, 1, false, 0e0);
    single_test(-2, 3, 0.3, 1, false, 0e0);
    single_test(-2, -4, 0.3, 2, false, 7.65e-1);
    single_test(-2, -3, 0.3, 2, false, 1.05e0);
    single_test(-2, -2, 0.3, 2, false, 7.75e-1);
    single_test(-2, -1, 0.3, 2, false, -1.5e-1);
    single_test(-2, 0, 0.3, 2, false, 0e0);
    single_test(-2, 1, 0.3, 2, false, 0e0);
    single_test(-2, 2, 0.3, 2, false, 0e0);
    single_test(-2, 3, 0.3, 2, false, 0e0);
    single_test(-2, 4, 0.3, 2, false, 0e0);
    single_test(-2, -5, 0.3, 3, false, 4.753125000000001e-1);
    single_test(-2, -4, 0.3, 3, false, 7.65e-1);
    single_test(-2, -3, 0.3, 3, false, 8.424375e-1);
    single_test(-2, -2, 0.3, 3, false, 7.75e-1);
    single_test(-2, -1, 0.3, 3, false, -1.483125e-1);
    single_test(-2, 0, 0.3, 3, false, 0e0);
    single_test(-2, 1, 0.3, 3, false, 5.625e-4);
    single_test(-2, 2, 0.3, 3, false, 0e0);
    single_test(-2, 3, 0.3, 3, false, 0e0);
    single_test(-2, 4, 0.3, 3, false, 0e0);
    single_test(-2, 5, 0.3, 3, false, 0e0);
    single_test(-2, -6, 0.3, 4, false, 2.6983125e-1);
    single_test(-2, -5, 0.3, 4, false, 4.753125000000001e-1);
    single_test(-2, -4, 0.3, 4, false, 6.0975e-1);
    single_test(-2, -3, 0.3, 4, false, 8.424375e-1);
    single_test(-2, -2, 0.3, 4, false, 7.8158125e-1);
    single_test(-2, -1, 0.3, 4, false, -1.483125e-1);
    single_test(-2, 0, 0.3, 4, false, 0e0);
    single_test(-2, 1, 0.3, 4, false, 5.625e-4);
    single_test(-2, 2, 0.3, 4, false, 3.375e-4);
    single_test(-2, 3, 0.3, 4, false, 0e0);
    single_test(-2, 4, 0.3, 4, false, 0e0);
    single_test(-2, 5, 0.3, 4, false, 0e0);
    single_test(-2, 6, 0.3, 4, false, 0e0);
    single_test(-2, -7, 0.3, 5, false, 1.445008359375e-1);
    single_test(-2, -6, 0.3, 5, false, 2.6983125e-1);
    single_test(-2, -5, 0.3, 5, false, 3.724013671875e-1);
    single_test(-2, -4, 0.3, 5, false, 6.0975e-1);
    single_test(-2, -3, 0.3, 5, false, 8.51720859375e-1);
    single_test(-2, -2, 0.3, 5, false, 7.8158125e-1);
    single_test(-2, -1, 0.3, 5, false, -1.48344140625e-1);
    single_test(-2, 0, 0.3, 5, false, 0e0);
    single_test(-2, 1, 0.3, 5, false, 5.973046875e-4);
    single_test(-2, 2, 0.3, 5, false, 3.375e-4);
    single_test(-2, 3, 0.3, 5, false, 1.537734375e-4);
    single_test(-2, 4, 0.3, 5, false, 0e0);
    single_test(-2, 5, 0.3, 5, false, 0e0);
    single_test(-2, 6, 0.3, 5, false, 0e0);
    single_test(-2, 7, 0.3, 5, false, 0e0);
    single_test(0, -2, 0.3, 0, false, 0e0);
    single_test(0, -1, 0.3, 0, false, 0e0);
    single_test(0, 0, 0.3, 0, false, 1.e0);
    single_test(0, 1, 0.3, 0, false, 0e0);
    single_test(0, 2, 0.3, 0, false, 0e0);
    single_test(0, -3, 0.3, 1, false, 0e0);
    single_test(0, -2, 0.3, 1, false, 0e0);
    single_test(0, -1, 0.3, 1, false, 4.5e-1);
    single_test(0, 0, 0.3, 1, false, 1.e0);
    single_test(0, 1, 0.3, 1, false, 4.5e-1);
    single_test(0, 2, 0.3, 1, false, 0e0);
    single_test(0, 3, 0.3, 1, false, 0e0);
    single_test(0, -4, 0.3, 2, false, 0e0);
    single_test(0, -3, 0.3, 2, false, 0e0);
    single_test(0, -2, 0.3, 2, false, 2.025e-1);
    single_test(0, -1, 0.3, 2, false, 4.5e-1);
    single_test(0, 0, 0.3, 2, false, 1.135e0);
    single_test(0, 1, 0.3, 2, false, 4.5e-1);
    single_test(0, 2, 0.3, 2, false, 2.025e-1);
    single_test(0, 3, 0.3, 2, false, 0e0);
    single_test(0, 4, 0.3, 2, false, 0e0);
    single_test(0, -5, 0.3, 3, false, 0e0);
    single_test(0, -4, 0.3, 3, false, 0e0);
    single_test(0, -3, 0.3, 3, false, 8.94375e-2);
    single_test(0, -2, 0.3, 3, false, 2.025e-1);
    single_test(0, -1, 0.3, 3, false, 4.955625e-1);
    single_test(0, 0, 0.3, 3, false, 1.135e0);
    single_test(0, 1, 0.3, 3, false, 4.955625e-1);
    single_test(0, 2, 0.3, 3, false, 2.025e-1);
    single_test(0, 3, 0.3, 3, false, 8.94375e-2);
    single_test(0, 4, 0.3, 3, false, 0e0);
    single_test(0, 5, 0.3, 3, false, 0e0);
    single_test(0, -6, 0.3, 4, false, 0e0);
    single_test(0, -5, 0.3, 4, false, 0e0);
    single_test(0, -4, 0.3, 4, false, 3.898124999999999e-2);
    single_test(0, -3, 0.3, 4, false, 8.94375e-2);
    single_test(0, -2, 0.3, 4, false, 2.16675e-1);
    single_test(0, -1, 0.3, 4, false, 4.955625e-1);
    single_test(0, 0, 0.3, 4, false, 1.1501875e0);
    single_test(0, 1, 0.3, 4, false, 4.955625e-1);
    single_test(0, 2, 0.3, 4, false, 2.16675e-1);
    single_test(0, 3, 0.3, 4, false, 8.94375e-2);
    single_test(0, 4, 0.3, 4, false, 3.898124999999999e-2);
    single_test(0, 5, 0.3, 4, false, 0e0);
    single_test(0, 6, 0.3, 4, false, 0e0);
    single_test(0, -7, 0.3, 5, false, 0e0);
    single_test(0, -6, 0.3, 5, false, 0e0);
    single_test(0, -5, 0.3, 5, false, 1.68296484375e-2);
    single_test(0, -4, 0.3, 5, false, 3.898124999999999e-2);
    single_test(0, -3, 0.3, 5, false, 9.31679296875e-2);
    single_test(0, -2, 0.3, 5, false, 2.16675e-1);
    single_test(0, -1, 0.3, 5, false, 5.00517421875e-1);
    single_test(0, 0, 0.3, 5, false, 1.1501875e0);
    single_test(0, 1, 0.3, 5, false, 5.00517421875e-1);
    single_test(0, 2, 0.3, 5, false, 2.16675e-1);
    single_test(0, 3, 0.3, 5, false, 9.31679296875e-2);
    single_test(0, 4, 0.3, 5, false, 3.898124999999999e-2);
    single_test(0, 5, 0.3, 5, false, 1.68296484375e-2);
    single_test(0, 6, 0.3, 5, false, 0e0);
    single_test(0, 7, 0.3, 5, false, 0e0);
    single_test(2, -2, 0.3, 0, false, 0e0);
    single_test(2, -1, 0.3, 0, false, 0e0);
    single_test(2, 0, 0.3, 0, false, 0e0);
    single_test(2, 1, 0.3, 0, false, 0e0);
    single_test(2, 2, 0.3, 0, false, 1.e0);
    single_test(2, -3, 0.3, 1, false, 0e0);
    single_test(2, -2, 0.3, 1, false, 0e0);
    single_test(2, -1, 0.3, 1, false, 0e0);
    single_test(2, 0, 0.3, 1, false, 0e0);
    single_test(2, 1, 0.3, 1, false, -1.5e-1);
    single_test(2, 2, 0.3, 1, false, 1.e0);
    single_test(2, 3, 0.3, 1, false, 1.05e0);
    single_test(2, -4, 0.3, 2, false, 0e0);
    single_test(2, -3, 0.3, 2, false, 0e0);
    single_test(2, -2, 0.3, 2, false, 0e0);
    single_test(2, -1, 0.3, 2, false, 0e0);
    single_test(2, 0, 0.3, 2, false, 0e0);
    single_test(2, 1, 0.3, 2, false, -1.5e-1);
    single_test(2, 2, 0.3, 2, false, 7.75e-1);
    single_test(2, 3, 0.3, 2, false, 1.05e0);
    single_test(2, 4, 0.3, 2, false, 7.65e-1);
    single_test(2, -5, 0.3, 3, false, 0e0);
    single_test(2, -4, 0.3, 3, false, 0e0);
    single_test(2, -3, 0.3, 3, false, 0e0);
    single_test(2, -2, 0.3, 3, false, 0e0);
    single_test(2, -1, 0.3, 3, false, 5.625e-4);
    single_test(2, 0, 0.3, 3, false, 0e0);
    single_test(2, 1, 0.3, 3, false, -1.483125e-1);
    single_test(2, 2, 0.3, 3, false, 7.75e-1);
    single_test(2, 3, 0.3, 3, false, 8.424375e-1);
    single_test(2, 4, 0.3, 3, false, 7.65e-1);
    single_test(2, 5, 0.3, 3, false, 4.753125000000001e-1);
    single_test(2, -6, 0.3, 4, false, 0e0);
    single_test(2, -5, 0.3, 4, false, 0e0);
    single_test(2, -4, 0.3, 4, false, 0e0);
    single_test(2, -3, 0.3, 4, false, 0e0);
    single_test(2, -2, 0.3, 4, false, 3.375e-4);
    single_test(2, -1, 0.3, 4, false, 5.625e-4);
    single_test(2, 0, 0.3, 4, false, 0e0);
    single_test(2, 1, 0.3, 4, false, -1.483125e-1);
    single_test(2, 2, 0.3, 4, false, 7.8158125e-1);
    single_test(2, 3, 0.3, 4, false, 8.424375e-1);
    single_test(2, 4, 0.3, 4, false, 6.0975e-1);
    single_test(2, 5, 0.3, 4, false, 4.753125000000001e-1);
    single_test(2, 6, 0.3, 4, false, 2.6983125e-1);
    single_test(2, -7, 0.3, 5, false, 0e0);
    single_test(2, -6, 0.3, 5, false, 0e0);
    single_test(2, -5, 0.3, 5, false, 0e0);
    single_test(2, -4, 0.3, 5, false, 0e0);
    single_test(2, -3, 0.3, 5, false, 1.537734375e-4);
    single_test(2, -2, 0.3, 5, false, 3.375e-4);
    single_test(2, -1, 0.3, 5, false, 5.973046875e-4);
    single_test(2, 0, 0.3, 5, false, 0e0);
    single_test(2, 1, 0.3, 5, false, -1.48344140625e-1);
    single_test(2, 2, 0.3, 5, false, 7.8158125e-1);
    single_test(2, 3, 0.3, 5, false, 8.51720859375e-1);
    single_test(2, 4, 0.3, 5, false, 6.0975e-1);
    single_test(2, 5, 0.3, 5, false, 3.724013671875e-1);
    single_test(2, 6, 0.3, 5, false, 2.6983125e-1);
    single_test(2, 7, 0.3, 5, false, 1.445008359375e-1);
    single_test(-2, -2, 0.6, 0, false, 1.e0);
    single_test(-2, -1, 0.6, 0, false, 0e0);
    single_test(-2, 0, 0.6, 0, false, 0e0);
    single_test(-2, 1, 0.6, 0, false, 0e0);
    single_test(-2, 2, 0.6, 0, false, 0e0);
    single_test(-2, -3, 0.6, 1, false, 2.1e0);
    single_test(-2, -2, 0.6, 1, false, 1.e0);
    single_test(-2, -1, 0.6, 1, false, -3.e-1);
    single_test(-2, 0, 0.6, 1, false, 0e0);
    single_test(-2, 1, 0.6, 1, false, 0e0);
    single_test(-2, 2, 0.6, 1, false, 0e0);
    single_test(-2, 3, 0.6, 1, false, 0e0);
    single_test(-2, -4, 0.6, 2, false, 3.06e0);
    single_test(-2, -3, 0.6, 2, false, 2.1e0);
    single_test(-2, -2, 0.6, 2, false, 1.000000000000001e-1);
    single_test(-2, -1, 0.6, 2, false, -3.e-1);
    single_test(-2, 0, 0.6, 2, false, 0e0);
    single_test(-2, 1, 0.6, 2, false, 0e0);
    single_test(-2, 2, 0.6, 2, false, 0e0);
    single_test(-2, 3, 0.6, 2, false, 0e0);
    single_test(-2, 4, 0.6, 2, false, 0e0);
    single_test(-2, -5, 0.6, 3, false, 3.8025e0);
    single_test(-2, -4, 0.6, 3, false, 3.06e0);
    single_test(-2, -3, 0.6, 3, false, 4.395e-1);
    single_test(-2, -2, 0.6, 3, false, 1.000000000000001e-1);
    single_test(-2, -1, 0.6, 3, false, -2.865e-1);
    single_test(-2, 0, 0.6, 3, false, 0e0);
    single_test(-2, 1, 0.6, 3, false, 4.5e-3);
    single_test(-2, 2, 0.6, 3, false, 0e0);
    single_test(-2, 3, 0.6, 3, false, 0e0);
    single_test(-2, 4, 0.6, 3, false, 0e0);
    single_test(-2, 5, 0.6, 3, false, 0e0);
    single_test(-2, -6, 0.6, 4, false, 4.3173e0);
    single_test(-2, -5, 0.6, 4, false, 3.8025e0);
    single_test(-2, -4, 0.6, 4, false, 5.760000000000001e-1);
    single_test(-2, -3, 0.6, 4, false, 4.395e-1);
    single_test(-2, -2, 0.6, 4, false, 2.053000000000001e-1);
    single_test(-2, -1, 0.6, 4, false, -2.865e-1);
    single_test(-2, 0, 0.6, 4, false, 0e0);
    single_test(-2, 1, 0.6, 4, false, 4.5e-3);
    single_test(-2, 2, 0.6, 4, false, 5.4e-3);
    single_test(-2, 3, 0.6, 4, false, 0e0);
    single_test(-2, 4, 0.6, 4, false, 0e0);
    single_test(-2, 5, 0.6, 4, false, 0e0);
    single_test(-2, 6, 0.6, 4, false, 0e0);
    single_test(-2, -7, 0.6, 5, false, 4.62402675e0);
    single_test(-2, -6, 0.6, 5, false, 4.3173e0);
    single_test(-2, -5, 0.6, 5, false, 5.093437500000007e-1);
    single_test(-2, -4, 0.6, 5, false, 5.760000000000001e-1);
    single_test(-2, -3, 0.6, 5, false, 7.365675e-1);
    single_test(-2, -2, 0.6, 5, false, 2.053000000000001e-1);
    single_test(-2, -1, 0.6, 5, false, -2.875125e-1);
    single_test(-2, 0, 0.6, 5, false, 0e0);
    single_test(-2, 1, 0.6, 5, false, 5.61375e-3);
    single_test(-2, 2, 0.6, 5, false, 5.4e-3);
    single_test(-2, 3, 0.6, 5, false, 4.92075e-3);
    single_test(-2, 4, 0.6, 5, false, 0e0);
    single_test(-2, 5, 0.6, 5, false, 0e0);
    single_test(-2, 6, 0.6, 5, false, 0e0);
    single_test(-2, 7, 0.6, 5, false, 0e0);
    single_test(0, -2, 0.6, 0, false, 0e0);
    single_test(0, -1, 0.6, 0, false, 0e0);
    single_test(0, 0, 0.6, 0, false, 1.e0);
    single_test(0, 1, 0.6, 0, false, 0e0);
    single_test(0, 2, 0.6, 0, false, 0e0);
    single_test(0, -3, 0.6, 1, false, 0e0);
    single_test(0, -2, 0.6, 1, false, 0e0);
    single_test(0, -1, 0.6, 1, false, 9.e-1);
    single_test(0, 0, 0.6, 1, false, 1.e0);
    single_test(0, 1, 0.6, 1, false, 9.e-1);
    single_test(0, 2, 0.6, 1, false, 0e0);
    single_test(0, 3, 0.6, 1, false, 0e0);
    single_test(0, -4, 0.6, 2, false, 0e0);
    single_test(0, -3, 0.6, 2, false, 0e0);
    single_test(0, -2, 0.6, 2, false, 8.1e-1);
    single_test(0, -1, 0.6, 2, false, 9.e-1);
    single_test(0, 0, 0.6, 2, false, 1.54e0);
    single_test(0, 1, 0.6, 2, false, 9.e-1);
    single_test(0, 2, 0.6, 2, false, 8.1e-1);
    single_test(0, 3, 0.6, 2, false, 0e0);
    single_test(0, 4, 0.6, 2, false, 0e0);
    single_test(0, -5, 0.6, 3, false, 0e0);
    single_test(0, -4, 0.6, 3, false, 0e0);
    single_test(0, -3, 0.6, 3, false, 7.155e-1);
    single_test(0, -2, 0.6, 3, false, 8.1e-1);
    single_test(0, -1, 0.6, 3, false, 1.2645e0);
    single_test(0, 0, 0.6, 3, false, 1.54e0);
    single_test(0, 1, 0.6, 3, false, 1.2645e0);
    single_test(0, 2, 0.6, 3, false, 8.1e-1);
    single_test(0, 3, 0.6, 3, false, 7.155e-1);
    single_test(0, 4, 0.6, 3, false, 0e0);
    single_test(0, 5, 0.6, 3, false, 0e0);
    single_test(0, -6, 0.6, 4, false, 0e0);
    single_test(0, -5, 0.6, 4, false, 0e0);
    single_test(0, -4, 0.6, 4, false, 6.236999999999999e-1);
    single_test(0, -3, 0.6, 4, false, 7.155e-1);
    single_test(0, -2, 0.6, 4, false, 1.0368e0);
    single_test(0, -1, 0.6, 4, false, 1.2645e0);
    single_test(0, 0, 0.6, 4, false, 1.783e0);
    single_test(0, 1, 0.6, 4, false, 1.2645e0);
    single_test(0, 2, 0.6, 4, false, 1.0368e0);
    single_test(0, 3, 0.6, 4, false, 7.155e-1);
    single_test(0, 4, 0.6, 4, false, 6.236999999999999e-1);
    single_test(0, 5, 0.6, 4, false, 0e0);
    single_test(0, 6, 0.6, 4, false, 0e0);
    single_test(0, -7, 0.6, 5, false, 0e0);
    single_test(0, -6, 0.6, 5, false, 0e0);
    single_test(0, -5, 0.6, 5, false, 5.3854875e-1);
    single_test(0, -4, 0.6, 5, false, 6.236999999999999e-1);
    single_test(0, -3, 0.6, 5, false, 8.3487375e-1);
    single_test(0, -2, 0.6, 5, false, 1.0368e0);
    single_test(0, -1, 0.6, 5, false, 1.4230575e0);
    single_test(0, 0, 0.6, 5, false, 1.783e0);
    single_test(0, 1, 0.6, 5, false, 1.4230575e0);
    single_test(0, 2, 0.6, 5, false, 1.0368e0);
    single_test(0, 3, 0.6, 5, false, 8.3487375e-1);
    single_test(0, 4, 0.6, 5, false, 6.236999999999999e-1);
    single_test(0, 5, 0.6, 5, false, 5.3854875e-1);
    single_test(0, 6, 0.6, 5, false, 0e0);
    single_test(0, 7, 0.6, 5, false, 0e0);
    single_test(2, -2, 0.6, 0, false, 0e0);
    single_test(2, -1, 0.6, 0, false, 0e0);
    single_test(2, 0, 0.6, 0, false, 0e0);
    single_test(2, 1, 0.6, 0, false, 0e0);
    single_test(2, 2, 0.6, 0, false, 1.e0);
    single_test(2, -3, 0.6, 1, false, 0e0);
    single_test(2, -2, 0.6, 1, false, 0e0);
    single_test(2, -1, 0.6, 1, false, 0e0);
    single_test(2, 0, 0.6, 1, false, 0e0);
    single_test(2, 1, 0.6, 1, false, -3.e-1);
    single_test(2, 2, 0.6, 1, false, 1.e0);
    single_test(2, 3, 0.6, 1, false, 2.1e0);
    single_test(2, -4, 0.6, 2, false, 0e0);
    single_test(2, -3, 0.6, 2, false, 0e0);
    single_test(2, -2, 0.6, 2, false, 0e0);
    single_test(2, -1, 0.6, 2, false, 0e0);
    single_test(2, 0, 0.6, 2, false, 0e0);
    single_test(2, 1, 0.6, 2, false, -3.e-1);
    single_test(2, 2, 0.6, 2, false, 1.000000000000001e-1);
    single_test(2, 3, 0.6, 2, false, 2.1e0);
    single_test(2, 4, 0.6, 2, false, 3.06e0);
    single_test(2, -5, 0.6, 3, false, 0e0);
    single_test(2, -4, 0.6, 3, false, 0e0);
    single_test(2, -3, 0.6, 3, false, 0e0);
    single_test(2, -2, 0.6, 3, false, 0e0);
    single_test(2, -1, 0.6, 3, false, 4.5e-3);
    single_test(2, 0, 0.6, 3, false, 0e0);
    single_test(2, 1, 0.6, 3, false, -2.865e-1);
    single_test(2, 2, 0.6, 3, false, 1.000000000000001e-1);
    single_test(2, 3, 0.6, 3, false, 4.395e-1);
    single_test(2, 4, 0.6, 3, false, 3.06e0);
    single_test(2, 5, 0.6, 3, false, 3.8025e0);
    single_test(2, -6, 0.6, 4, false, 0e0);
    single_test(2, -5, 0.6, 4, false, 0e0);
    single_test(2, -4, 0.6, 4, false, 0e0);
    single_test(2, -3, 0.6, 4, false, 0e0);
    single_test(2, -2, 0.6, 4, false, 5.4e-3);
    single_test(2, -1, 0.6, 4, false, 4.5e-3);
    single_test(2, 0, 0.6, 4, false, 0e0);
    single_test(2, 1, 0.6, 4, false, -2.865e-1);
    single_test(2, 2, 0.6, 4, false, 2.053000000000001e-1);
    single_test(2, 3, 0.6, 4, false, 4.395e-1);
    single_test(2, 4, 0.6, 4, false, 5.760000000000001e-1);
    single_test(2, 5, 0.6, 4, false, 3.8025e0);
    single_test(2, 6, 0.6, 4, false, 4.3173e0);
    single_test(2, -7, 0.6, 5, false, 0e0);
    single_test(2, -6, 0.6, 5, false, 0e0);
    single_test(2, -5, 0.6, 5, false, 0e0);
    single_test(2, -4, 0.6, 5, false, 0e0);
    single_test(2, -3, 0.6, 5, false, 4.92075e-3);
    single_test(2, -2, 0.6, 5, false, 5.4e-3);
    single_test(2, -1, 0.6, 5, false, 5.61375e-3);
    single_test(2, 0, 0.6, 5, false, 0e0);
    single_test(2, 1, 0.6, 5, false, -2.875125e-1);
    single_test(2, 2, 0.6, 5, false, 2.053000000000001e-1);
    single_test(2, 3, 0.6, 5, false, 7.365675e-1);
    single_test(2, 4, 0.6, 5, false, 5.760000000000001e-1);
    single_test(2, 5, 0.6, 5, false, 5.093437500000007e-1);
    single_test(2, 6, 0.6, 5, false, 4.3173e0);
    single_test(2, 7, 0.6, 5, false, 4.62402675e0);
    single_test(-2, -2, 0.9, 0, false, 1.e0);
    single_test(-2, -1, 0.9, 0, false, 0e0);
    single_test(-2, 0, 0.9, 0, false, 0e0);
    single_test(-2, 1, 0.9, 0, false, 0e0);
    single_test(-2, 2, 0.9, 0, false, 0e0);
    single_test(-2, -3, 0.9, 1, false, 3.15e0);
    single_test(-2, -2, 0.9, 1, false, 1.e0);
    single_test(-2, -1, 0.9, 1, false, -4.5e-1);
    single_test(-2, 0, 0.9, 1, false, 0e0);
    single_test(-2, 1, 0.9, 1, false, 0e0);
    single_test(-2, 2, 0.9, 1, false, 0e0);
    single_test(-2, 3, 0.9, 1, false, 0e0);
    single_test(-2, -4, 0.9, 2, false, 6.884999999999999e0);
    single_test(-2, -3, 0.9, 2, false, 3.15e0);
    single_test(-2, -2, 0.9, 2, false, -1.025e0);
    single_test(-2, -1, 0.9, 2, false, -4.5e-1);
    single_test(-2, 0, 0.9, 2, false, 0e0);
    single_test(-2, 1, 0.9, 2, false, 0e0);
    single_test(-2, 2, 0.9, 2, false, 0e0);
    single_test(-2, 3, 0.9, 2, false, 0e0);
    single_test(-2, 4, 0.9, 2, false, 0e0);
    single_test(-2, -5, 0.9, 3, false, 1.28334375e1);
    single_test(-2, -4, 0.9, 3, false, 6.884999999999999e0);
    single_test(-2, -3, 0.9, 3, false, -2.454187499999999e0);
    single_test(-2, -2, 0.9, 3, false, -1.025e0);
    single_test(-2, -1, 0.9, 3, false, -4.044375e-1);
    single_test(-2, 0, 0.9, 3, false, 0e0);
    single_test(-2, 1, 0.9, 3, false, 1.51875e-2);
    single_test(-2, 2, 0.9, 3, false, 0e0);
    single_test(-2, 3, 0.9, 3, false, 0e0);
    single_test(-2, 4, 0.9, 3, false, 0e0);
    single_test(-2, 5, 0.9, 3, false, 0e0);
    single_test(-2, -6, 0.9, 4, false, 2.185633124999999e1);
    single_test(-2, -5, 0.9, 4, false, 1.28334375e1);
    single_test(-2, -4, 0.9, 4, false, -5.690249999999996e0);
    single_test(-2, -3, 0.9, 4, false, -2.454187499999999e0);
    single_test(-2, -2, 0.9, 4, false, -4.919187499999998e-1);
    single_test(-2, -1, 0.9, 4, false, -4.044375e-1);
    single_test(-2, 0, 0.9, 4, false, 0e0);
    single_test(-2, 1, 0.9, 4, false, 1.51875e-2);
    single_test(-2, 2, 0.9, 4, false, 2.733749999999999e-2);
    single_test(-2, 3, 0.9, 4, false, 0e0);
    single_test(-2, 4, 0.9, 4, false, 0e0);
    single_test(-2, 5, 0.9, 4, false, 0e0);
    single_test(-2, 6, 0.9, 4, false, 0e0);
    single_test(-2, -7, 0.9, 5, false, 3.511370313281247e1);
    single_test(-2, -6, 0.9, 5, false, 2.185633124999999e1);
    single_test(-2, -5, 0.9, 5, false, -1.217396777343749e1);
    single_test(-2, -4, 0.9, 5, false, -5.690249999999996e0);
    single_test(-2, -3, 0.9, 5, false, -1.983311718750005e-1);
    single_test(-2, -2, 0.9, 5, false, -4.919187499999998e-1);
    single_test(-2, -1, 0.9, 5, false, -4.12126171875e-1);
    single_test(-2, 0, 0.9, 5, false, 0e0);
    single_test(-2, 1, 0.9, 5, false, 2.364503906249999e-2);
    single_test(-2, 2, 0.9, 5, false, 2.733749999999999e-2);
    single_test(-2, 3, 0.9, 5, false, 3.736694531249998e-2);
    single_test(-2, 4, 0.9, 5, false, 0e0);
    single_test(-2, 5, 0.9, 5, false, 0e0);
    single_test(-2, 6, 0.9, 5, false, 0e0);
    single_test(-2, 7, 0.9, 5, false, 0e0);
    single_test(0, -2, 0.9, 0, false, 0e0);
    single_test(0, -1, 0.9, 0, false, 0e0);
    single_test(0, 0, 0.9, 0, false, 1.e0);
    single_test(0, 1, 0.9, 0, false, 0e0);
    single_test(0, 2, 0.9, 0, false, 0e0);
    single_test(0, -3, 0.9, 1, false, 0e0);
    single_test(0, -2, 0.9, 1, false, 0e0);
    single_test(0, -1, 0.9, 1, false, 1.35e0);
    single_test(0, 0, 0.9, 1, false, 1.e0);
    single_test(0, 1, 0.9, 1, false, 1.35e0);
    single_test(0, 2, 0.9, 1, false, 0e0);
    single_test(0, 3, 0.9, 1, false, 0e0);
    single_test(0, -4, 0.9, 2, false, 0e0);
    single_test(0, -3, 0.9, 2, false, 0e0);
    single_test(0, -2, 0.9, 2, false, 1.8225e0);
    single_test(0, -1, 0.9, 2, false, 1.35e0);
    single_test(0, 0, 0.9, 2, false, 2.215e0);
    single_test(0, 1, 0.9, 2, false, 1.35e0);
    single_test(0, 2, 0.9, 2, false, 1.8225e0);
    single_test(0, 3, 0.9, 2, false, 0e0);
    single_test(0, 4, 0.9, 2, false, 0e0);
    single_test(0, -5, 0.9, 3, false, 0e0);
    single_test(0, -4, 0.9, 3, false, 0e0);
    single_test(0, -3, 0.9, 3, false, 2.414812499999999e0);
    single_test(0, -2, 0.9, 3, false, 1.8225e0);
    single_test(0, -1, 0.9, 3, false, 2.580187499999999e0);
    single_test(0, 0, 0.9, 3, false, 2.215e0);
    single_test(0, 1, 0.9, 3, false, 2.580187499999999e0);
    single_test(0, 2, 0.9, 3, false, 1.8225e0);
    single_test(0, 3, 0.9, 3, false, 2.414812499999999e0);
    single_test(0, 4, 0.9, 3, false, 0e0);
    single_test(0, 5, 0.9, 3, false, 0e0);
    single_test(0, -6, 0.9, 4, false, 0e0);
    single_test(0, -5, 0.9, 4, false, 0e0);
    single_test(0, -4, 0.9, 4, false, 3.157481249999999e0);
    single_test(0, -3, 0.9, 4, false, 2.414812499999999e0);
    single_test(0, -2, 0.9, 4, false, 2.970674999999999e0);
    single_test(0, -1, 0.9, 4, false, 2.580187499999999e0);
    single_test(0, 0, 0.9, 4, false, 3.445187499999999e0);
    single_test(0, 1, 0.9, 4, false, 2.580187499999999e0);
    single_test(0, 2, 0.9, 4, false, 2.970674999999999e0);
    single_test(0, 3, 0.9, 4, false, 2.414812499999999e0);
    single_test(0, 4, 0.9, 4, false, 3.157481249999999e0);
    single_test(0, 5, 0.9, 4, false, 0e0);
    single_test(0, 6, 0.9, 4, false, 0e0);
    single_test(0, -7, 0.9, 5, false, 0e0);
    single_test(0, -6, 0.9, 5, false, 0e0);
    single_test(0, -5, 0.9, 5, false, 4.089604570312497e0);
    single_test(0, -4, 0.9, 5, false, 3.157481249999999e0);
    single_test(0, -3, 0.9, 5, false, 3.321306914062498e0);
    single_test(0, -2, 0.9, 5, false, 2.970674999999999e0);
    single_test(0, -1, 0.9, 5, false, 3.784233515624998e0);
    single_test(0, 0, 0.9, 5, false, 3.445187499999999e0);
    single_test(0, 1, 0.9, 5, false, 3.784233515624998e0);
    single_test(0, 2, 0.9, 5, false, 2.970674999999999e0);
    single_test(0, 3, 0.9, 5, false, 3.321306914062498e0);
    single_test(0, 4, 0.9, 5, false, 3.157481249999999e0);
    single_test(0, 5, 0.9, 5, false, 4.089604570312497e0);
    single_test(0, 6, 0.9, 5, false, 0e0);
    single_test(0, 7, 0.9, 5, false, 0e0);
    single_test(2, -2, 0.9, 0, false, 0e0);
    single_test(2, -1, 0.9, 0, false, 0e0);
    single_test(2, 0, 0.9, 0, false, 0e0);
    single_test(2, 1, 0.9, 0, false, 0e0);
    single_test(2, 2, 0.9, 0, false, 1.e0);
    single_test(2, -3, 0.9, 1, false, 0e0);
    single_test(2, -2, 0.9, 1, false, 0e0);
    single_test(2, -1, 0.9, 1, false, 0e0);
    single_test(2, 0, 0.9, 1, false, 0e0);
    single_test(2, 1, 0.9, 1, false, -4.5e-1);
    single_test(2, 2, 0.9, 1, false, 1.e0);
    single_test(2, 3, 0.9, 1, false, 3.15e0);
    single_test(2, -4, 0.9, 2, false, 0e0);
    single_test(2, -3, 0.9, 2, false, 0e0);
    single_test(2, -2, 0.9, 2, false, 0e0);
    single_test(2, -1, 0.9, 2, false, 0e0);
    single_test(2, 0, 0.9, 2, false, 0e0);
    single_test(2, 1, 0.9, 2, false, -4.5e-1);
    single_test(2, 2, 0.9, 2, false, -1.025e0);
    single_test(2, 3, 0.9, 2, false, 3.15e0);
    single_test(2, 4, 0.9, 2, false, 6.884999999999999e0);
    single_test(2, -5, 0.9, 3, false, 0e0);
    single_test(2, -4, 0.9, 3, false, 0e0);
    single_test(2, -3, 0.9, 3, false, 0e0);
    single_test(2, -2, 0.9, 3, false, 0e0);
    single_test(2, -1, 0.9, 3, false, 1.51875e-2);
    single_test(2, 0, 0.9, 3, false, 0e0);
    single_test(2, 1, 0.9, 3, false, -4.044375e-1);
    single_test(2, 2, 0.9, 3, false, -1.025e0);
    single_test(2, 3, 0.9, 3, false, -2.454187499999999e0);
    single_test(2, 4, 0.9, 3, false, 6.884999999999999e0);
    single_test(2, 5, 0.9, 3, false, 1.28334375e1);
    single_test(2, -6, 0.9, 4, false, 0e0);
    single_test(2, -5, 0.9, 4, false, 0e0);
    single_test(2, -4, 0.9, 4, false, 0e0);
    single_test(2, -3, 0.9, 4, false, 0e0);
    single_test(2, -2, 0.9, 4, false, 2.733749999999999e-2);
    single_test(2, -1, 0.9, 4, false, 1.51875e-2);
    single_test(2, 0, 0.9, 4, false, 0e0);
    single_test(2, 1, 0.9, 4, false, -4.044375e-1);
    single_test(2, 2, 0.9, 4, false, -4.919187499999998e-1);
    single_test(2, 3, 0.9, 4, false, -2.454187499999999e0);
    single_test(2, 4, 0.9, 4, false, -5.690249999999996e0);
    single_test(2, 5, 0.9, 4, false, 1.28334375e1);
    single_test(2, 6, 0.9, 4, false, 2.185633124999999e1);
    single_test(2, -7, 0.9, 5, false, 0e0);
    single_test(2, -6, 0.9, 5, false, 0e0);
    single_test(2, -5, 0.9, 5, false, 0e0);
    single_test(2, -4, 0.9, 5, false, 0e0);
    single_test(2, -3, 0.9, 5, false, 3.736694531249998e-2);
    single_test(2, -2, 0.9, 5, false, 2.733749999999999e-2);
    single_test(2, -1, 0.9, 5, false, 2.364503906249999e-2);
    single_test(2, 0, 0.9, 5, false, 0e0);
    single_test(2, 1, 0.9, 5, false, -4.12126171875e-1);
    single_test(2, 2, 0.9, 5, false, -4.919187499999998e-1);
    single_test(2, 3, 0.9, 5, false, -1.983311718750005e-1);
    single_test(2, 4, 0.9, 5, false, -5.690249999999996e0);
    single_test(2, 5, 0.9, 5, false, -1.217396777343749e1);
    single_test(2, 6, 0.9, 5, false, 2.185633124999999e1);
    single_test(2, 7, 0.9, 5, false, 3.511370313281247e1);
}

void test_EccentricityExpansionCoefficients::test_derivatives()
{
    single_test(-2, -2, 0.3, 0, true, 0e0);
    single_test(-2, -1, 0.3, 0, true, 0e0);
    single_test(-2, 0, 0.3, 0, true, 0e0);
    single_test(-2, 1, 0.3, 0, true, 0e0);
    single_test(-2, 2, 0.3, 0, true, 0e0);
    single_test(-2, -3, 0.3, 1, true, 3.5e0);
    single_test(-2, -2, 0.3, 1, true, 0e0);
    single_test(-2, -1, 0.3, 1, true, -5.e-1);
    single_test(-2, 0, 0.3, 1, true, 0e0);
    single_test(-2, 1, 0.3, 1, true, 0e0);
    single_test(-2, 2, 0.3, 1, true, 0e0);
    single_test(-2, 3, 0.3, 1, true, 0e0);
    single_test(-2, -4, 0.3, 2, true, 5.1e0);
    single_test(-2, -3, 0.3, 2, true, 3.5e0);
    single_test(-2, -2, 0.3, 2, true, -1.5e0);
    single_test(-2, -1, 0.3, 2, true, -5.e-1);
    single_test(-2, 0, 0.3, 2, true, 0e0);
    single_test(-2, 1, 0.3, 2, true, 0e0);
    single_test(-2, 2, 0.3, 2, true, 0e0);
    single_test(-2, 3, 0.3, 2, true, 0e0);
    single_test(-2, 4, 0.3, 2, true, 0e0);
    single_test(-2, -5, 0.3, 3, true, 4.753125e0);
    single_test(-2, -4, 0.3, 3, true, 5.1e0);
    single_test(-2, -3, 0.3, 3, true, 1.424375e0);
    single_test(-2, -2, 0.3, 3, true, -1.5e0);
    single_test(-2, -1, 0.3, 3, true, -4.831250000000001e-1);
    single_test(-2, 0, 0.3, 3, true, 0e0);
    single_test(-2, 1, 0.3, 3, true, 5.625e-3);
    single_test(-2, 2, 0.3, 3, true, 0e0);
    single_test(-2, 3, 0.3, 3, true, 0e0);
    single_test(-2, 4, 0.3, 3, true, 0e0);
    single_test(-2, 5, 0.3, 3, true, 0e0);
    single_test(-2, -6, 0.3, 4, true, 3.59775e0);
    single_test(-2, -5, 0.3, 4, true, 4.753125e0);
    single_test(-2, -4, 0.3, 4, true, 3.029999999999999e0);
    single_test(-2, -3, 0.3, 4, true, 1.424375e0);
    single_test(-2, -2, 0.3, 4, true, -1.41225e0);
    single_test(-2, -1, 0.3, 4, true, -4.831250000000001e-1);
    single_test(-2, 0, 0.3, 4, true, 0e0);
    single_test(-2, 1, 0.3, 4, true, 5.625e-3);
    single_test(-2, 2, 0.3, 4, true, 4.5e-3);
    single_test(-2, 3, 0.3, 4, true, 0e0);
    single_test(-2, 4, 0.3, 4, true, 0e0);
    single_test(-2, 5, 0.3, 4, true, 0e0);
    single_test(-2, 6, 0.3, 4, true, 0e0);
    single_test(-2, -7, 0.3, 5, true, 2.408347265625e0);
    single_test(-2, -6, 0.3, 5, true, 3.59775e0);
    single_test(-2, -5, 0.3, 5, true, 3.037939453125e0);
    single_test(-2, -4, 0.3, 5, true, 3.029999999999999e0);
    single_test(-2, -3, 0.3, 5, true, 1.57909765625e0);
    single_test(-2, -2, 0.3, 5, true, -1.41225e0);
    single_test(-2, -1, 0.3, 5, true, -4.8365234375e-1);
    single_test(-2, 0, 0.3, 5, true, 0e0);
    single_test(-2, 1, 0.3, 5, true, 6.205078125e-3);
    single_test(-2, 2, 0.3, 5, true, 4.5e-3);
    single_test(-2, 3, 0.3, 5, true, 2.562890625e-3);
    single_test(-2, 4, 0.3, 5, true, 0e0);
    single_test(-2, 5, 0.3, 5, true, 0e0);
    single_test(-2, 6, 0.3, 5, true, 0e0);
    single_test(-2, 7, 0.3, 5, true, 0e0);
    single_test(0, -2, 0.3, 0, true, 0e0);
    single_test(0, -1, 0.3, 0, true, 0e0);
    single_test(0, 0, 0.3, 0, true, 0e0);
    single_test(0, 1, 0.3, 0, true, 0e0);
    single_test(0, 2, 0.3, 0, true, 0e0);
    single_test(0, -3, 0.3, 1, true, 0e0);
    single_test(0, -2, 0.3, 1, true, 0e0);
    single_test(0, -1, 0.3, 1, true, 1.5e0);
    single_test(0, 0, 0.3, 1, true, 0e0);
    single_test(0, 1, 0.3, 1, true, 1.5e0);
    single_test(0, 2, 0.3, 1, true, 0e0);
    single_test(0, 3, 0.3, 1, true, 0e0);
    single_test(0, -4, 0.3, 2, true, 0e0);
    single_test(0, -3, 0.3, 2, true, 0e0);
    single_test(0, -2, 0.3, 2, true, 1.35e0);
    single_test(0, -1, 0.3, 2, true, 1.5e0);
    single_test(0, 0, 0.3, 2, true, 9.e-1);
    single_test(0, 1, 0.3, 2, true, 1.5e0);
    single_test(0, 2, 0.3, 2, true, 1.35e0);
    single_test(0, 3, 0.3, 2, true, 0e0);
    single_test(0, 4, 0.3, 2, true, 0e0);
    single_test(0, -5, 0.3, 3, true, 0e0);
    single_test(0, -4, 0.3, 3, true, 0e0);
    single_test(0, -3, 0.3, 3, true, 8.94375e-1);
    single_test(0, -2, 0.3, 3, true, 1.35e0);
    single_test(0, -1, 0.3, 3, true, 1.955625e0);
    single_test(0, 0, 0.3, 3, true, 9.e-1);
    single_test(0, 1, 0.3, 3, true, 1.955625e0);
    single_test(0, 2, 0.3, 3, true, 1.35e0);
    single_test(0, 3, 0.3, 3, true, 8.94375e-1);
    single_test(0, 4, 0.3, 3, true, 0e0);
    single_test(0, 5, 0.3, 3, true, 0e0);
    single_test(0, -6, 0.3, 4, true, 0e0);
    single_test(0, -5, 0.3, 4, true, 0e0);
    single_test(0, -4, 0.3, 4, true, 5.197500000000001e-1);
    single_test(0, -3, 0.3, 4, true, 8.94375e-1);
    single_test(0, -2, 0.3, 4, true, 1.539e0);
    single_test(0, -1, 0.3, 4, true, 1.955625e0);
    single_test(0, 0, 0.3, 4, true, 1.1025e0);
    single_test(0, 1, 0.3, 4, true, 1.955625e0);
    single_test(0, 2, 0.3, 4, true, 1.539e0);
    single_test(0, 3, 0.3, 4, true, 8.94375e-1);
    single_test(0, 4, 0.3, 4, true, 5.197500000000001e-1);
    single_test(0, 5, 0.3, 4, true, 0e0);
    single_test(0, 6, 0.3, 4, true, 0e0);
    single_test(0, -7, 0.3, 5, true, 0e0);
    single_test(0, -6, 0.3, 5, true, 0e0);
    single_test(0, -5, 0.3, 5, true, 2.80494140625e-1);
    single_test(0, -4, 0.3, 5, true, 5.197500000000001e-1);
    single_test(0, -3, 0.3, 5, true, 9.56548828125e-1);
    single_test(0, -2, 0.3, 5, true, 1.539e0);
    single_test(0, -1, 0.3, 5, true, 2.03820703125e0);
    single_test(0, 0, 0.3, 5, true, 1.1025e0);
    single_test(0, 1, 0.3, 5, true, 2.03820703125e0);
    single_test(0, 2, 0.3, 5, true, 1.539e0);
    single_test(0, 3, 0.3, 5, true, 9.56548828125e-1);
    single_test(0, 4, 0.3, 5, true, 5.197500000000001e-1);
    single_test(0, 5, 0.3, 5, true, 2.80494140625e-1);
    single_test(0, 6, 0.3, 5, true, 0e0);
    single_test(0, 7, 0.3, 5, true, 0e0);
    single_test(2, -2, 0.3, 0, true, 0e0);
    single_test(2, -1, 0.3, 0, true, 0e0);
    single_test(2, 0, 0.3, 0, true, 0e0);
    single_test(2, 1, 0.3, 0, true, 0e0);
    single_test(2, 2, 0.3, 0, true, 0e0);
    single_test(2, -3, 0.3, 1, true, 0e0);
    single_test(2, -2, 0.3, 1, true, 0e0);
    single_test(2, -1, 0.3, 1, true, 0e0);
    single_test(2, 0, 0.3, 1, true, 0e0);
    single_test(2, 1, 0.3, 1, true, -5.e-1);
    single_test(2, 2, 0.3, 1, true, 0e0);
    single_test(2, 3, 0.3, 1, true, 3.5e0);
    single_test(2, -4, 0.3, 2, true, 0e0);
    single_test(2, -3, 0.3, 2, true, 0e0);
    single_test(2, -2, 0.3, 2, true, 0e0);
    single_test(2, -1, 0.3, 2, true, 0e0);
    single_test(2, 0, 0.3, 2, true, 0e0);
    single_test(2, 1, 0.3, 2, true, -5.e-1);
    single_test(2, 2, 0.3, 2, true, -1.5e0);
    single_test(2, 3, 0.3, 2, true, 3.5e0);
    single_test(2, 4, 0.3, 2, true, 5.1e0);
    single_test(2, -5, 0.3, 3, true, 0e0);
    single_test(2, -4, 0.3, 3, true, 0e0);
    single_test(2, -3, 0.3, 3, true, 0e0);
    single_test(2, -2, 0.3, 3, true, 0e0);
    single_test(2, -1, 0.3, 3, true, 5.625e-3);
    single_test(2, 0, 0.3, 3, true, 0e0);
    single_test(2, 1, 0.3, 3, true, -4.831250000000001e-1);
    single_test(2, 2, 0.3, 3, true, -1.5e0);
    single_test(2, 3, 0.3, 3, true, 1.424375e0);
    single_test(2, 4, 0.3, 3, true, 5.1e0);
    single_test(2, 5, 0.3, 3, true, 4.753125e0);
    single_test(2, -6, 0.3, 4, true, 0e0);
    single_test(2, -5, 0.3, 4, true, 0e0);
    single_test(2, -4, 0.3, 4, true, 0e0);
    single_test(2, -3, 0.3, 4, true, 0e0);
    single_test(2, -2, 0.3, 4, true, 4.5e-3);
    single_test(2, -1, 0.3, 4, true, 5.625e-3);
    single_test(2, 0, 0.3, 4, true, 0e0);
    single_test(2, 1, 0.3, 4, true, -4.831250000000001e-1);
    single_test(2, 2, 0.3, 4, true, -1.41225e0);
    single_test(2, 3, 0.3, 4, true, 1.424375e0);
    single_test(2, 4, 0.3, 4, true, 3.029999999999999e0);
    single_test(2, 5, 0.3, 4, true, 4.753125e0);
    single_test(2, 6, 0.3, 4, true, 3.59775e0);
    single_test(2, -7, 0.3, 5, true, 0e0);
    single_test(2, -6, 0.3, 5, true, 0e0);
    single_test(2, -5, 0.3, 5, true, 0e0);
    single_test(2, -4, 0.3, 5, true, 0e0);
    single_test(2, -3, 0.3, 5, true, 2.562890625e-3);
    single_test(2, -2, 0.3, 5, true, 4.5e-3);
    single_test(2, -1, 0.3, 5, true, 6.205078125e-3);
    single_test(2, 0, 0.3, 5, true, 0e0);
    single_test(2, 1, 0.3, 5, true, -4.8365234375e-1);
    single_test(2, 2, 0.3, 5, true, -1.41225e0);
    single_test(2, 3, 0.3, 5, true, 1.57909765625e0);
    single_test(2, 4, 0.3, 5, true, 3.029999999999999e0);
    single_test(2, 5, 0.3, 5, true, 3.037939453125e0);
    single_test(2, 6, 0.3, 5, true, 3.59775e0);
    single_test(2, 7, 0.3, 5, true, 2.408347265625e0);
    single_test(-2, -2, 0.6, 0, true, 0e0);
    single_test(-2, -1, 0.6, 0, true, 0e0);
    single_test(-2, 0, 0.6, 0, true, 0e0);
    single_test(-2, 1, 0.6, 0, true, 0e0);
    single_test(-2, 2, 0.6, 0, true, 0e0);
    single_test(-2, -3, 0.6, 1, true, 3.5e0);
    single_test(-2, -2, 0.6, 1, true, 0e0);
    single_test(-2, -1, 0.6, 1, true, -5.e-1);
    single_test(-2, 0, 0.6, 1, true, 0e0);
    single_test(-2, 1, 0.6, 1, true, 0e0);
    single_test(-2, 2, 0.6, 1, true, 0e0);
    single_test(-2, 3, 0.6, 1, true, 0e0);
    single_test(-2, -4, 0.6, 2, true, 1.02e1);
    single_test(-2, -3, 0.6, 2, true, 3.5e0);
    single_test(-2, -2, 0.6, 2, true, -3.e0);
    single_test(-2, -1, 0.6, 2, true, -5.e-1);
    single_test(-2, 0, 0.6, 2, true, 0e0);
    single_test(-2, 1, 0.6, 2, true, 0e0);
    single_test(-2, 2, 0.6, 2, true, 0e0);
    single_test(-2, 3, 0.6, 2, true, 0e0);
    single_test(-2, 4, 0.6, 2, true, 0e0);
    single_test(-2, -5, 0.6, 3, true, 1.90125e1);
    single_test(-2, -4, 0.6, 3, true, 1.02e1);
    single_test(-2, -3, 0.6, 3, true, -4.8025e0);
    single_test(-2, -2, 0.6, 3, true, -3.e0);
    single_test(-2, -1, 0.6, 3, true, -4.325e-1);
    single_test(-2, 0, 0.6, 3, true, 0e0);
    single_test(-2, 1, 0.6, 3, true, 2.25e-2);
    single_test(-2, 2, 0.6, 3, true, 0e0);
    single_test(-2, 3, 0.6, 3, true, 0e0);
    single_test(-2, 4, 0.6, 3, true, 0e0);
    single_test(-2, 5, 0.6, 3, true, 0e0);
    single_test(-2, -6, 0.6, 4, true, 2.8782e1);
    single_test(-2, -5, 0.6, 4, true, 1.90125e1);
    single_test(-2, -4, 0.6, 4, true, -6.360000000000003e0);
    single_test(-2, -3, 0.6, 4, true, -4.8025e0);
    single_test(-2, -2, 0.6, 4, true, -2.298e0);
    single_test(-2, -1, 0.6, 4, true, -4.325e-1);
    single_test(-2, 0, 0.6, 4, true, 0e0);
    single_test(-2, 1, 0.6, 4, true, 2.25e-2);
    single_test(-2, 2, 0.6, 4, true, 3.6e-2);
    single_test(-2, 3, 0.6, 4, true, 0e0);
    single_test(-2, 4, 0.6, 4, true, 0e0);
    single_test(-2, 5, 0.6, 4, true, 0e0);
    single_test(-2, 6, 0.6, 4, true, 0e0);
    single_test(-2, -7, 0.6, 5, true, 3.853355625e1);
    single_test(-2, -6, 0.6, 5, true, 2.8782e1);
    single_test(-2, -5, 0.6, 5, true, -8.43046875e0);
    single_test(-2, -4, 0.6, 5, true, -6.360000000000003e0);
    single_test(-2, -3, 0.6, 5, true, -2.3269375e0);
    single_test(-2, -2, 0.6, 5, true, -2.298e0);
    single_test(-2, -1, 0.6, 5, true, -4.409375e-1);
    single_test(-2, 0, 0.6, 5, true, 0e0);
    single_test(-2, 1, 0.6, 5, true, 3.178125e-2);
    single_test(-2, 2, 0.6, 5, true, 3.6e-2);
    single_test(-2, 3, 0.6, 5, true, 4.100625e-2);
    single_test(-2, 4, 0.6, 5, true, 0e0);
    single_test(-2, 5, 0.6, 5, true, 0e0);
    single_test(-2, 6, 0.6, 5, true, 0e0);
    single_test(-2, 7, 0.6, 5, true, 0e0);
    single_test(0, -2, 0.6, 0, true, 0e0);
    single_test(0, -1, 0.6, 0, true, 0e0);
    single_test(0, 0, 0.6, 0, true, 0e0);
    single_test(0, 1, 0.6, 0, true, 0e0);
    single_test(0, 2, 0.6, 0, true, 0e0);
    single_test(0, -3, 0.6, 1, true, 0e0);
    single_test(0, -2, 0.6, 1, true, 0e0);
    single_test(0, -1, 0.6, 1, true, 1.5e0);
    single_test(0, 0, 0.6, 1, true, 0e0);
    single_test(0, 1, 0.6, 1, true, 1.5e0);
    single_test(0, 2, 0.6, 1, true, 0e0);
    single_test(0, 3, 0.6, 1, true, 0e0);
    single_test(0, -4, 0.6, 2, true, 0e0);
    single_test(0, -3, 0.6, 2, true, 0e0);
    single_test(0, -2, 0.6, 2, true, 2.7e0);
    single_test(0, -1, 0.6, 2, true, 1.5e0);
    single_test(0, 0, 0.6, 2, true, 1.8e0);
    single_test(0, 1, 0.6, 2, true, 1.5e0);
    single_test(0, 2, 0.6, 2, true, 2.7e0);
    single_test(0, 3, 0.6, 2, true, 0e0);
    single_test(0, 4, 0.6, 2, true, 0e0);
    single_test(0, -5, 0.6, 3, true, 0e0);
    single_test(0, -4, 0.6, 3, true, 0e0);
    single_test(0, -3, 0.6, 3, true, 3.5775e0);
    single_test(0, -2, 0.6, 3, true, 2.7e0);
    single_test(0, -1, 0.6, 3, true, 3.3225e0);
    single_test(0, 0, 0.6, 3, true, 1.8e0);
    single_test(0, 1, 0.6, 3, true, 3.3225e0);
    single_test(0, 2, 0.6, 3, true, 2.7e0);
    single_test(0, 3, 0.6, 3, true, 3.5775e0);
    single_test(0, 4, 0.6, 3, true, 0e0);
    single_test(0, 5, 0.6, 3, true, 0e0);
    single_test(0, -6, 0.6, 4, true, 0e0);
    single_test(0, -5, 0.6, 4, true, 0e0);
    single_test(0, -4, 0.6, 4, true, 4.158e0);
    single_test(0, -3, 0.6, 4, true, 3.5775e0);
    single_test(0, -2, 0.6, 4, true, 4.212e0);
    single_test(0, -1, 0.6, 4, true, 3.3225e0);
    single_test(0, 0, 0.6, 4, true, 3.42e0);
    single_test(0, 1, 0.6, 4, true, 3.3225e0);
    single_test(0, 2, 0.6, 4, true, 4.212e0);
    single_test(0, 3, 0.6, 4, true, 3.5775e0);
    single_test(0, 4, 0.6, 4, true, 4.158e0);
    single_test(0, 5, 0.6, 4, true, 0e0);
    single_test(0, 6, 0.6, 4, true, 0e0);
    single_test(0, -7, 0.6, 5, true, 0e0);
    single_test(0, -6, 0.6, 5, true, 0e0);
    single_test(0, -5, 0.6, 5, true, 4.48790625e0);
    single_test(0, -4, 0.6, 5, true, 4.158e0);
    single_test(0, -3, 0.6, 5, true, 4.57228125e0);
    single_test(0, -2, 0.6, 5, true, 4.212e0);
    single_test(0, -1, 0.6, 5, true, 4.643812499999999e0);
    single_test(0, 0, 0.6, 5, true, 3.42e0);
    single_test(0, 1, 0.6, 5, true, 4.643812499999999e0);
    single_test(0, 2, 0.6, 5, true, 4.212e0);
    single_test(0, 3, 0.6, 5, true, 4.57228125e0);
    single_test(0, 4, 0.6, 5, true, 4.158e0);
    single_test(0, 5, 0.6, 5, true, 4.48790625e0);
    single_test(0, 6, 0.6, 5, true, 0e0);
    single_test(0, 7, 0.6, 5, true, 0e0);
    single_test(2, -2, 0.6, 0, true, 0e0);
    single_test(2, -1, 0.6, 0, true, 0e0);
    single_test(2, 0, 0.6, 0, true, 0e0);
    single_test(2, 1, 0.6, 0, true, 0e0);
    single_test(2, 2, 0.6, 0, true, 0e0);
    single_test(2, -3, 0.6, 1, true, 0e0);
    single_test(2, -2, 0.6, 1, true, 0e0);
    single_test(2, -1, 0.6, 1, true, 0e0);
    single_test(2, 0, 0.6, 1, true, 0e0);
    single_test(2, 1, 0.6, 1, true, -5.e-1);
    single_test(2, 2, 0.6, 1, true, 0e0);
    single_test(2, 3, 0.6, 1, true, 3.5e0);
    single_test(2, -4, 0.6, 2, true, 0e0);
    single_test(2, -3, 0.6, 2, true, 0e0);
    single_test(2, -2, 0.6, 2, true, 0e0);
    single_test(2, -1, 0.6, 2, true, 0e0);
    single_test(2, 0, 0.6, 2, true, 0e0);
    single_test(2, 1, 0.6, 2, true, -5.e-1);
    single_test(2, 2, 0.6, 2, true, -3.e0);
    single_test(2, 3, 0.6, 2, true, 3.5e0);
    single_test(2, 4, 0.6, 2, true, 1.02e1);
    single_test(2, -5, 0.6, 3, true, 0e0);
    single_test(2, -4, 0.6, 3, true, 0e0);
    single_test(2, -3, 0.6, 3, true, 0e0);
    single_test(2, -2, 0.6, 3, true, 0e0);
    single_test(2, -1, 0.6, 3, true, 2.25e-2);
    single_test(2, 0, 0.6, 3, true, 0e0);
    single_test(2, 1, 0.6, 3, true, -4.325e-1);
    single_test(2, 2, 0.6, 3, true, -3.e0);
    single_test(2, 3, 0.6, 3, true, -4.8025e0);
    single_test(2, 4, 0.6, 3, true, 1.02e1);
    single_test(2, 5, 0.6, 3, true, 1.90125e1);
    single_test(2, -6, 0.6, 4, true, 0e0);
    single_test(2, -5, 0.6, 4, true, 0e0);
    single_test(2, -4, 0.6, 4, true, 0e0);
    single_test(2, -3, 0.6, 4, true, 0e0);
    single_test(2, -2, 0.6, 4, true, 3.6e-2);
    single_test(2, -1, 0.6, 4, true, 2.25e-2);
    single_test(2, 0, 0.6, 4, true, 0e0);
    single_test(2, 1, 0.6, 4, true, -4.325e-1);
    single_test(2, 2, 0.6, 4, true, -2.298e0);
    single_test(2, 3, 0.6, 4, true, -4.8025e0);
    single_test(2, 4, 0.6, 4, true, -6.360000000000003e0);
    single_test(2, 5, 0.6, 4, true, 1.90125e1);
    single_test(2, 6, 0.6, 4, true, 2.8782e1);
    single_test(2, -7, 0.6, 5, true, 0e0);
    single_test(2, -6, 0.6, 5, true, 0e0);
    single_test(2, -5, 0.6, 5, true, 0e0);
    single_test(2, -4, 0.6, 5, true, 0e0);
    single_test(2, -3, 0.6, 5, true, 4.100625e-2);
    single_test(2, -2, 0.6, 5, true, 3.6e-2);
    single_test(2, -1, 0.6, 5, true, 3.178125e-2);
    single_test(2, 0, 0.6, 5, true, 0e0);
    single_test(2, 1, 0.6, 5, true, -4.409375e-1);
    single_test(2, 2, 0.6, 5, true, -2.298e0);
    single_test(2, 3, 0.6, 5, true, -2.3269375e0);
    single_test(2, 4, 0.6, 5, true, -6.360000000000003e0);
    single_test(2, 5, 0.6, 5, true, -8.43046875e0);
    single_test(2, 6, 0.6, 5, true, 2.8782e1);
    single_test(2, 7, 0.6, 5, true, 3.853355625e1);
    single_test(-2, -2, 0.9, 0, true, 0e0);
    single_test(-2, -1, 0.9, 0, true, 0e0);
    single_test(-2, 0, 0.9, 0, true, 0e0);
    single_test(-2, 1, 0.9, 0, true, 0e0);
    single_test(-2, 2, 0.9, 0, true, 0e0);
    single_test(-2, -3, 0.9, 1, true, 3.5e0);
    single_test(-2, -2, 0.9, 1, true, 0e0);
    single_test(-2, -1, 0.9, 1, true, -5.e-1);
    single_test(-2, 0, 0.9, 1, true, 0e0);
    single_test(-2, 1, 0.9, 1, true, 0e0);
    single_test(-2, 2, 0.9, 1, true, 0e0);
    single_test(-2, 3, 0.9, 1, true, 0e0);
    single_test(-2, -4, 0.9, 2, true, 1.53e1);
    single_test(-2, -3, 0.9, 2, true, 3.5e0);
    single_test(-2, -2, 0.9, 2, true, -4.5e0);
    single_test(-2, -1, 0.9, 2, true, -5.e-1);
    single_test(-2, 0, 0.9, 2, true, 0e0);
    single_test(-2, 1, 0.9, 2, true, 0e0);
    single_test(-2, 2, 0.9, 2, true, 0e0);
    single_test(-2, 3, 0.9, 2, true, 0e0);
    single_test(-2, 4, 0.9, 2, true, 0e0);
    single_test(-2, -5, 0.9, 3, true, 4.277812499999999e1);
    single_test(-2, -4, 0.9, 3, true, 1.53e1);
    single_test(-2, -3, 0.9, 3, true, -1.5180625e1);
    single_test(-2, -2, 0.9, 3, true, -4.5e0);
    single_test(-2, -1, 0.9, 3, true, -3.48125e-1);
    single_test(-2, 0, 0.9, 3, true, 0e0);
    single_test(-2, 1, 0.9, 3, true, 5.062499999999998e-2);
    single_test(-2, 2, 0.9, 3, true, 0e0);
    single_test(-2, 3, 0.9, 3, true, 0e0);
    single_test(-2, 4, 0.9, 3, true, 0e0);
    single_test(-2, 5, 0.9, 3, true, 0e0);
    single_test(-2, -6, 0.9, 4, true, 9.713925e1);
    single_test(-2, -5, 0.9, 4, true, 4.277812499999999e1);
    single_test(-2, -4, 0.9, 4, true, -4.058999999999999e1);
    single_test(-2, -3, 0.9, 4, true, -1.5180625e1);
    single_test(-2, -2, 0.9, 4, true, -2.130750000000001e0);
    single_test(-2, -1, 0.9, 4, true, -3.48125e-1);
    single_test(-2, 0, 0.9, 4, true, 0e0);
    single_test(-2, 1, 0.9, 4, true, 5.062499999999998e-2);
    single_test(-2, 2, 0.9, 4, true, 1.215e-1);
    single_test(-2, 3, 0.9, 4, true, 0e0);
    single_test(-2, 4, 0.9, 4, true, 0e0);
    single_test(-2, 5, 0.9, 4, true, 0e0);
    single_test(-2, 6, 0.9, 4, true, 0e0);
    single_test(-2, -7, 0.9, 5, true, 1.950761285156249e2);
    single_test(-2, -6, 0.9, 5, true, 9.713925e1);
    single_test(-2, -5, 0.9, 5, true, -9.6151904296875e1);
    single_test(-2, -4, 0.9, 5, true, -4.058999999999999e1);
    single_test(-2, -3, 0.9, 5, true, -2.648089843750002e0);
    single_test(-2, -2, 0.9, 5, true, -2.130750000000001e0);
    single_test(-2, -1, 0.9, 5, true, -3.9083984375e-1);
    single_test(-2, 0, 0.9, 5, true, 0e0);
    single_test(-2, 1, 0.9, 5, true, 9.7611328125e-2);
    single_test(-2, 2, 0.9, 5, true, 1.215e-1);
    single_test(-2, 3, 0.9, 5, true, 2.075941406249999e-1);
    single_test(-2, 4, 0.9, 5, true, 0e0);
    single_test(-2, 5, 0.9, 5, true, 0e0);
    single_test(-2, 6, 0.9, 5, true, 0e0);
    single_test(-2, 7, 0.9, 5, true, 0e0);
    single_test(0, -2, 0.9, 0, true, 0e0);
    single_test(0, -1, 0.9, 0, true, 0e0);
    single_test(0, 0, 0.9, 0, true, 0e0);
    single_test(0, 1, 0.9, 0, true, 0e0);
    single_test(0, 2, 0.9, 0, true, 0e0);
    single_test(0, -3, 0.9, 1, true, 0e0);
    single_test(0, -2, 0.9, 1, true, 0e0);
    single_test(0, -1, 0.9, 1, true, 1.5e0);
    single_test(0, 0, 0.9, 1, true, 0e0);
    single_test(0, 1, 0.9, 1, true, 1.5e0);
    single_test(0, 2, 0.9, 1, true, 0e0);
    single_test(0, 3, 0.9, 1, true, 0e0);
    single_test(0, -4, 0.9, 2, true, 0e0);
    single_test(0, -3, 0.9, 2, true, 0e0);
    single_test(0, -2, 0.9, 2, true, 4.05e0);
    single_test(0, -1, 0.9, 2, true, 1.5e0);
    single_test(0, 0, 0.9, 2, true, 2.7e0);
    single_test(0, 1, 0.9, 2, true, 1.5e0);
    single_test(0, 2, 0.9, 2, true, 4.05e0);
    single_test(0, 3, 0.9, 2, true, 0e0);
    single_test(0, 4, 0.9, 2, true, 0e0);
    single_test(0, -5, 0.9, 3, true, 0e0);
    single_test(0, -4, 0.9, 3, true, 0e0);
    single_test(0, -3, 0.9, 3, true, 8.049375e0);
    single_test(0, -2, 0.9, 3, true, 4.05e0);
    single_test(0, -1, 0.9, 3, true, 5.600624999999999e0);
    single_test(0, 0, 0.9, 3, true, 2.7e0);
    single_test(0, 1, 0.9, 3, true, 5.600624999999999e0);
    single_test(0, 2, 0.9, 3, true, 4.05e0);
    single_test(0, 3, 0.9, 3, true, 8.049375e0);
    single_test(0, 4, 0.9, 3, true, 0e0);
    single_test(0, 5, 0.9, 3, true, 0e0);
    single_test(0, -6, 0.9, 4, true, 0e0);
    single_test(0, -5, 0.9, 4, true, 0e0);
    single_test(0, -4, 0.9, 4, true, 1.403325e1);
    single_test(0, -3, 0.9, 4, true, 8.049375e0);
    single_test(0, -2, 0.9, 4, true, 9.153e0);
    single_test(0, -1, 0.9, 4, true, 5.600624999999999e0);
    single_test(0, 0, 0.9, 4, true, 8.1675e0);
    single_test(0, 1, 0.9, 4, true, 5.600624999999999e0);
    single_test(0, 2, 0.9, 4, true, 9.153e0);
    single_test(0, 3, 0.9, 4, true, 8.049375e0);
    single_test(0, 4, 0.9, 4, true, 1.403325e1);
    single_test(0, 5, 0.9, 4, true, 0e0);
    single_test(0, 6, 0.9, 4, true, 0e0);
    single_test(0, -7, 0.9, 5, true, 0e0);
    single_test(0, -6, 0.9, 5, true, 0e0);
    single_test(0, -5, 0.9, 5, true, 2.272002539062499e1);
    single_test(0, -4, 0.9, 5, true, 1.403325e1);
    single_test(0, -3, 0.9, 5, true, 1.3085455078125e1);
    single_test(0, -2, 0.9, 5, true, 9.153e0);
    single_test(0, -1, 0.9, 5, true, 1.228976953124999e1);
    single_test(0, 0, 0.9, 5, true, 8.1675e0);
    single_test(0, 1, 0.9, 5, true, 1.228976953124999e1);
    single_test(0, 2, 0.9, 5, true, 9.153e0);
    single_test(0, 3, 0.9, 5, true, 1.3085455078125e1);
    single_test(0, 4, 0.9, 5, true, 1.403325e1);
    single_test(0, 5, 0.9, 5, true, 2.272002539062499e1);
    single_test(0, 6, 0.9, 5, true, 0e0);
    single_test(0, 7, 0.9, 5, true, 0e0);
    single_test(2, -2, 0.9, 0, true, 0e0);
    single_test(2, -1, 0.9, 0, true, 0e0);
    single_test(2, 0, 0.9, 0, true, 0e0);
    single_test(2, 1, 0.9, 0, true, 0e0);
    single_test(2, 2, 0.9, 0, true, 0e0);
    single_test(2, -3, 0.9, 1, true, 0e0);
    single_test(2, -2, 0.9, 1, true, 0e0);
    single_test(2, -1, 0.9, 1, true, 0e0);
    single_test(2, 0, 0.9, 1, true, 0e0);
    single_test(2, 1, 0.9, 1, true, -5.e-1);
    single_test(2, 2, 0.9, 1, true, 0e0);
    single_test(2, 3, 0.9, 1, true, 3.5e0);
    single_test(2, -4, 0.9, 2, true, 0e0);
    single_test(2, -3, 0.9, 2, true, 0e0);
    single_test(2, -2, 0.9, 2, true, 0e0);
    single_test(2, -1, 0.9, 2, true, 0e0);
    single_test(2, 0, 0.9, 2, true, 0e0);
    single_test(2, 1, 0.9, 2, true, -5.e-1);
    single_test(2, 2, 0.9, 2, true, -4.5e0);
    single_test(2, 3, 0.9, 2, true, 3.5e0);
    single_test(2, 4, 0.9, 2, true, 1.53e1);
    single_test(2, -5, 0.9, 3, true, 0e0);
    single_test(2, -4, 0.9, 3, true, 0e0);
    single_test(2, -3, 0.9, 3, true, 0e0);
    single_test(2, -2, 0.9, 3, true, 0e0);
    single_test(2, -1, 0.9, 3, true, 5.062499999999998e-2);
    single_test(2, 0, 0.9, 3, true, 0e0);
    single_test(2, 1, 0.9, 3, true, -3.48125e-1);
    single_test(2, 2, 0.9, 3, true, -4.5e0);
    single_test(2, 3, 0.9, 3, true, -1.5180625e1);
    single_test(2, 4, 0.9, 3, true, 1.53e1);
    single_test(2, 5, 0.9, 3, true, 4.277812499999999e1);
    single_test(2, -6, 0.9, 4, true, 0e0);
    single_test(2, -5, 0.9, 4, true, 0e0);
    single_test(2, -4, 0.9, 4, true, 0e0);
    single_test(2, -3, 0.9, 4, true, 0e0);
    single_test(2, -2, 0.9, 4, true, 1.215e-1);
    single_test(2, -1, 0.9, 4, true, 5.062499999999998e-2);
    single_test(2, 0, 0.9, 4, true, 0e0);
    single_test(2, 1, 0.9, 4, true, -3.48125e-1);
    single_test(2, 2, 0.9, 4, true, -2.130750000000001e0);
    single_test(2, 3, 0.9, 4, true, -1.5180625e1);
    single_test(2, 4, 0.9, 4, true, -4.058999999999999e1);
    single_test(2, 5, 0.9, 4, true, 4.277812499999999e1);
    single_test(2, 6, 0.9, 4, true, 9.713925e1);
    single_test(2, -7, 0.9, 5, true, 0e0);
    single_test(2, -6, 0.9, 5, true, 0e0);
    single_test(2, -5, 0.9, 5, true, 0e0);
    single_test(2, -4, 0.9, 5, true, 0e0);
    single_test(2, -3, 0.9, 5, true, 2.075941406249999e-1);
    single_test(2, -2, 0.9, 5, true, 1.215e-1);
    single_test(2, -1, 0.9, 5, true, 9.7611328125e-2);
    single_test(2, 0, 0.9, 5, true, 0e0);
    single_test(2, 1, 0.9, 5, true, -3.9083984375e-1);
    single_test(2, 2, 0.9, 5, true, -2.130750000000001e0);
    single_test(2, 3, 0.9, 5, true, -2.648089843750002e0);
    single_test(2, 4, 0.9, 5, true, -4.058999999999999e1);
    single_test(2, 5, 0.9, 5, true, -9.6151904296875e1);
    single_test(2, 6, 0.9, 5, true, 9.713925e1);
    single_test(2, 7, 0.9, 5, true, 1.950761285156249e2);
}

test_EccentricityExpansionCoefficients::test_EccentricityExpansionCoefficients
(const std::string &fname)
{
	__pms.read(fname);
	TEST_ADD(test_EccentricityExpansionCoefficients::test_values);
	TEST_ADD(test_EccentricityExpansionCoefficients::test_derivatives);
}

#ifdef STANDALONE
int main()
{
	std::cout.setf(std::ios_base::scientific);
	std::cout.precision(16);
	Test::TextOutput output(Test::TextOutput::Verbose);
	test_EccentricityExpansionCoefficients tests;
	return (tests.run(output) ? EXIT_SUCCESS : EXIT_FAILURE);
}
#endif
