(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    206712,       4613]
NotebookOptionsPosition[    199005,       4488]
NotebookOutlinePosition[    199399,       4504]
CellTagsIndexPosition[    199356,       4501]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  StyleBox["Numerical", "Text"], 
  StyleBox[" ", "Text"], 
  StyleBox["evoluation", "Text"], 
  StyleBox[" ", "Text"], 
  StyleBox["of", "Text"], 
  StyleBox[" ", "Text"], 
  SubscriptBox[
   StyleBox["p", "Text"], 
   RowBox[{"0", ",", "s"}]], " ", "coefficients", " ", 
  RowBox[{"(", 
   RowBox[{
   "without", " ", "the", " ", "overall", " ", "factor", " ", "of", " ", "2", 
    "\[Pi]\[Omega]"}], ")"}]}]], "Text",
 CellChangeTimes->{{3.801237460558775*^9, 3.801237463889371*^9}, {
   3.801237531142343*^9, 3.801237575855632*^9}, {3.801237620450335*^9, 
   3.8012376241757917`*^9}, {3.8012379015733547`*^9, 3.801237920955213*^9}, {
   3.801237963142592*^9, 3.801237974566012*^9}, 3.801238487594733*^9, {
   3.801242496665675*^9, 3.80124249815585*^9}, 3.801242611278714*^9, 
   3.8012465151220913`*^9, {3.801251752687017*^9, 3.801251753620428*^9}, {
   3.8012527971553707`*^9, 3.801252851170168*^9}, {3.801844747644662*^9, 
   3.8018447599601793`*^9}, {3.801844820087236*^9, 3.801844834556225*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"4025eb12-2a83-4555-9516-d9ab96160d14"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"e_", ",", "s_"}], "]"}], ":=", 
  RowBox[{"NIntegrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{"I", "*", "s", "*", 
       RowBox[{"(", 
        RowBox[{"u", "-", 
         RowBox[{"e", "*", 
          RowBox[{"Sin", "[", "u", "]"}]}]}], ")"}]}], "]"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"e", "*", 
         RowBox[{"Cos", "[", "u", "]"}]}]}], ")"}], "^", "2"}]}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"u", ",", " ", "0", ",", " ", 
      RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{3.801844825823498*^9, 3.8036699602179623`*^9},
 CellLabel->"In[11]:=",ExpressionUUID->"501e030c-1be2-4e11-b6db-114503de5ab5"],

Cell[BoxData[
 StyleBox[
  RowBox[{"Analytical", " ", "expression", " ", "of", " ", 
   SubscriptBox[
    StyleBox["p", "Text"], 
    RowBox[{"0", ",", "s"}]], " ", "coefficients", " ", 
   RowBox[{"(", 
    RowBox[{
    "without", " ", "the", " ", "overall", " ", "factor", " ", "of", " ", "2",
      "\[Pi]\[Omega]"}], ")"}]}], "Text"]], "Text",
 CellChangeTimes->{{3.801251758732712*^9, 3.801251761300823*^9}, {
  3.801252860091793*^9, 3.8012528774825773`*^9}, {3.801844516235324*^9, 
  3.801844526313285*^9}, {3.8018448688213367`*^9, 
  3.801844884642879*^9}},ExpressionUUID->"ce8e4104-be6d-46a8-aa91-\
271e74cd07a0"],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", 
   RowBox[{"e_", ",", "s_"}], "]"}], ":=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{"I", "*", "s", "*", 
       RowBox[{"(", 
        RowBox[{"u", "-", 
         RowBox[{"e", "*", 
          RowBox[{"Sin", "[", "u", "]"}]}]}], ")"}]}], "]"}], "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"e", "*", 
         RowBox[{"Cos", "[", "u", "]"}]}]}], ")"}], "^", "2"}]}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"u", ",", " ", "0", ",", " ", 
      RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Element", "[", 
        RowBox[{"e", ",", "Reals"}], "]"}], ",", " ", 
       RowBox[{"e", ">", "0"}]}], "}"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[12]:=",ExpressionUUID->"83fc1049-75da-4b3e-ac58-d5200eee6010"],

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"e", ",", " ", "0"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"e", ",", "1"}], "]"}], ",", " ", 
     RowBox[{"f", "[", 
      RowBox[{"e", ",", " ", "2"}], "]"}], ",", " ", 
     RowBox[{"f", "[", 
      RowBox[{"e", ",", " ", "3"}], "]"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"e", ",", " ", "0", ",", " ", "1"}], "}"}], ",", " ", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*SubscriptBox[\(p\), \(0, 0\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(0, 1\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(0, 2\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(0, 3\)]\)\>\""}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"Style", "[", 
     RowBox[{
     "\"\<The first four \!\(\*SubscriptBox[\(p\), \(0, s\)]\) coefficients \
as a function of eccentricity\>\"", ",", 
      RowBox[{"FontSize", "\[Rule]", "32"}]}], "]"}]}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"\"\<e\>\"", ",", 
        RowBox[{"FontSize", "\[Rule]", "24"}]}], "]"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{"\"\<\!\(\*SubscriptBox[\(p\), \(0, s\)]\)\>\"", ",", 
        RowBox[{"FontSize", "\[Rule]", "24"}]}], "]"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.801246431083424*^9, 3.801246442382601*^9}, {
  3.801246525915083*^9, 3.801246555824313*^9}, {3.801246604019704*^9, 
  3.801246606049181*^9}, {3.801247848714984*^9, 3.8012479600161457`*^9}, {
  3.80124821363104*^9, 3.801248323245021*^9}, {3.801248396201047*^9, 
  3.801248429198563*^9}, {3.801248476679228*^9, 3.801248484994207*^9}, {
  3.8012485810351686`*^9, 3.801248586768881*^9}, {3.801252901397027*^9, 
  3.801252936411373*^9}, {3.8012534815118437`*^9, 3.801253538807951*^9}, {
  3.801253580254601*^9, 3.801253619232914*^9}, {3.801253657223055*^9, 
  3.8012536814239388`*^9}, {3.801253797416469*^9, 3.801253860381431*^9}, {
  3.8038315984048223`*^9, 
  3.803831602866914*^9}},ExpressionUUID->"f6c40af6-bcfd-4b97-a97e-\
01e7dae00d8c"],

Cell[BoxData[
 RowBox[{
  RowBox[{"divergenceless", "[", 
   RowBox[{"e_", ",", "s_"}], "]"}], ":=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{"I", "*", "s", "*", 
       RowBox[{"(", 
        RowBox[{"u", "-", 
         RowBox[{"e", "*", 
          RowBox[{"Sin", "[", "u", "]"}]}]}], ")"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"e", "^", "2"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"3", "/", "2"}], ")"}]}], "/", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"e", "*", 
          RowBox[{"Cos", "[", "u", "]"}]}]}], ")"}], "^", "2"}]}]}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"u", ",", " ", "0", ",", " ", 
      RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Element", "[", 
        RowBox[{"e", ",", "Reals"}], "]"}], ",", " ", 
       RowBox[{"e", ">", "0"}], ",", 
       RowBox[{"e", "<", "1"}]}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8038316054943247`*^9, 3.8038316366270323`*^9}},
 CellLabel->"In[32]:=",ExpressionUUID->"b6f2c8d7-28b4-4cba-b778-b4a1c5fa07fb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"g", "[", 
     RowBox[{"e", ",", "1"}], "]"}], "*", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"e", "^", "2"}]}], ")"}], "^", 
     RowBox[{"(", 
      RowBox[{"3", "/", "2"}], ")"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.803669993370434*^9, 3.803670048626871*^9}, {
  3.8036701003333673`*^9, 3.803670114971332*^9}},
 CellLabel->"In[17]:=",ExpressionUUID->"ee56e455-8401-4c5b-9259-c5e89aa795c4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"3", " ", "\[Pi]", " ", "e"}], "-", 
   FractionBox[
    RowBox[{"9", " ", "\[Pi]", " ", 
     SuperscriptBox["e", "3"]}], "8"], "+", 
   FractionBox[
    RowBox[{"9", " ", "\[Pi]", " ", 
     SuperscriptBox["e", "5"]}], "64"], "-", 
   FractionBox[
    RowBox[{"19", " ", "\[Pi]", " ", 
     SuperscriptBox["e", "7"]}], "3072"], "-", 
   FractionBox[
    RowBox[{"133", " ", "\[Pi]", " ", 
     SuperscriptBox["e", "9"]}], "81920"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "e", "]"}], "11"],
    SeriesData[$CellContext`e, 0, {}, 1, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`e, 0, {
   3 Pi, 0, Rational[-9, 8] Pi, 0, Rational[9, 64] Pi, 0, Rational[-19, 3072] 
    Pi, 0, Rational[-133, 81920] Pi}, 1, 11, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.80367001185045*^9, 3.803670061793933*^9}, 
   3.803670110302498*^9, 3.803672663440892*^9},
 CellLabel->"Out[17]=",ExpressionUUID->"0335c0c6-b84c-4b8a-a2be-011aab2a1ec2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      SubscriptBox["p", 
       RowBox[{"0", ",", "s"}]], ",", "\"\<:  \>\"", " ", ",", 
      RowBox[{"FullSimplify", "[", 
       RowBox[{"Series", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"g", "[", 
           RowBox[{"e", ",", "s"}], "]"}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"e", "^", "2"}]}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{"3", "/", "2"}], ")"}]}]}], ",", 
         RowBox[{"{", 
          RowBox[{"e", ",", "0", ",", "10"}], "}"}]}], "]"}], "]"}]}], "]"}], 
    ",", " ", 
    RowBox[{"{", 
     RowBox[{"s", ",", "0", ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.803672963396302*^9, 3.803673044160784*^9}, {
  3.803673092774116*^9, 3.80367322291187*^9}, {3.803673254390283*^9, 
  3.803673278932005*^9}},
 CellLabel->"In[28]:=",ExpressionUUID->"fec6af7a-eaf9-46ab-a7c3-f061c6bb9323"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["p", 
    RowBox[{"0", ",", "0"}]], "\[InvisibleSpace]", "\<\":  \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"2", " ", "\[Pi]"}]}],
  SequenceForm[
   Subscript[$CellContext`p, 0, 0], ":  ", 2 Pi],
  Editable->False]], "Print",
 CellChangeTimes->{{3.803673214684305*^9, 3.80367322342837*^9}, 
   3.803673293442339*^9},
 CellLabel->
  "During evaluation of \
In[28]:=",ExpressionUUID->"6f9f1050-16ee-463f-a507-b7cbccd89572"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["p", 
    RowBox[{"0", ",", "1"}]], "\[InvisibleSpace]", "\<\":  \"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    RowBox[{
     RowBox[{"3", " ", "\[Pi]", " ", "e"}], "-", 
     FractionBox[
      RowBox[{"9", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "3"]}], "8"], "+", 
     FractionBox[
      RowBox[{"9", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "5"]}], "64"], "-", 
     FractionBox[
      RowBox[{"19", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "7"]}], "3072"], "-", 
     FractionBox[
      RowBox[{"133", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "9"]}], "81920"], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "e", "]"}], "11"],
      SeriesData[$CellContext`e, 0, {}, 1, 11, 1],
      Editable->False]}],
    SeriesData[$CellContext`e, 0, {
     3 Pi, 0, Rational[-9, 8] Pi, 0, Rational[9, 64] Pi, 0, 
      Rational[-19, 3072] Pi, 0, Rational[-133, 81920] Pi}, 1, 11, 1],
    Editable->False]}],
  SequenceForm[
   Subscript[$CellContext`p, 0, 1], ":  ", 
   SeriesData[$CellContext`e, 0, {
    3 Pi, 0, Rational[-9, 8] Pi, 0, Rational[9, 64] Pi, 0, 
     Rational[-19, 3072] Pi, 0, Rational[-133, 81920] Pi}, 1, 11, 1]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.803673214684305*^9, 3.80367322342837*^9}, 
   3.803675548693849*^9},
 CellLabel->
  "During evaluation of \
In[28]:=",ExpressionUUID->"b1993beb-aa65-469c-9efc-98a9c5654dd7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["p", 
    RowBox[{"0", ",", "2"}]], "\[InvisibleSpace]", "\<\":  \"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    RowBox[{
     FractionBox[
      RowBox[{"9", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "2"]}], "2"], "-", 
     FractionBox[
      RowBox[{"13", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "4"]}], "4"], "+", 
     FractionBox[
      RowBox[{"27", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "6"]}], "32"], "-", 
     FractionBox[
      RowBox[{"29", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "8"]}], "320"], "+", 
     FractionBox[
      RowBox[{"67", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "10"]}], "11520"], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "e", "]"}], "11"],
      SeriesData[$CellContext`e, 0, {}, 2, 11, 1],
      Editable->False]}],
    SeriesData[$CellContext`e, 0, {
     Rational[9, 2] Pi, 0, Rational[-13, 4] Pi, 0, Rational[27, 32] Pi, 0, 
      Rational[-29, 320] Pi, 0, Rational[67, 11520] Pi}, 2, 11, 1],
    Editable->False]}],
  SequenceForm[
   Subscript[$CellContext`p, 0, 2], ":  ", 
   SeriesData[$CellContext`e, 0, {
    Rational[9, 2] Pi, 0, Rational[-13, 4] Pi, 0, Rational[27, 32] Pi, 0, 
     Rational[-29, 320] Pi, 0, Rational[67, 11520] Pi}, 2, 11, 1]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.803673214684305*^9, 3.80367322342837*^9}, 
   3.8036781918803043`*^9},
 CellLabel->
  "During evaluation of \
In[28]:=",ExpressionUUID->"1d906aca-1c9c-4ffd-a2ab-4a77077f6e8e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["p", 
    RowBox[{"0", ",", "3"}]], "\[InvisibleSpace]", "\<\":  \"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    RowBox[{
     FractionBox[
      RowBox[{"53", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "3"]}], "8"], "-", 
     FractionBox[
      RowBox[{"879", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "5"]}], "128"], "+", 
     FractionBox[
      RowBox[{"13893", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "7"]}], "5120"], "-", 
     FractionBox[
      RowBox[{"21359", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "9"]}], "40960"], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "e", "]"}], "11"],
      SeriesData[$CellContext`e, 0, {}, 3, 11, 1],
      Editable->False]}],
    SeriesData[$CellContext`e, 0, {
     Rational[53, 8] Pi, 0, Rational[-879, 128] Pi, 0, Rational[13893, 5120] 
      Pi, 0, Rational[-21359, 40960] Pi}, 3, 11, 1],
    Editable->False]}],
  SequenceForm[
   Subscript[$CellContext`p, 0, 3], ":  ", 
   SeriesData[$CellContext`e, 0, {
    Rational[53, 8] Pi, 0, Rational[-879, 128] Pi, 0, Rational[13893, 5120] 
     Pi, 0, Rational[-21359, 40960] Pi}, 3, 11, 1]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.803673214684305*^9, 3.80367322342837*^9}, 
   3.8036812191300287`*^9},
 CellLabel->
  "During evaluation of \
In[28]:=",ExpressionUUID->"f6123323-ba47-4de3-8561-b262d4886f77"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["p", 
    RowBox[{"0", ",", "4"}]], "\[InvisibleSpace]", "\<\":  \"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    RowBox[{
     FractionBox[
      RowBox[{"77", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "4"]}], "8"], "-", 
     FractionBox[
      RowBox[{"513", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "6"]}], "40"], "+", 
     FractionBox[
      RowBox[{"2179", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "8"]}], "320"], "-", 
     FractionBox[
      RowBox[{"19157", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "10"]}], "10080"], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "e", "]"}], "11"],
      SeriesData[$CellContext`e, 0, {}, 4, 11, 1],
      Editable->False]}],
    SeriesData[$CellContext`e, 0, {
     Rational[77, 8] Pi, 0, Rational[-513, 40] Pi, 0, Rational[2179, 320] Pi, 
      0, Rational[-19157, 10080] Pi}, 4, 11, 1],
    Editable->False]}],
  SequenceForm[
   Subscript[$CellContext`p, 0, 4], ":  ", 
   SeriesData[$CellContext`e, 0, {
    Rational[77, 8] Pi, 0, Rational[-513, 40] Pi, 0, Rational[2179, 320] Pi, 
     0, Rational[-19157, 10080] Pi}, 4, 11, 1]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.803673214684305*^9, 3.80367322342837*^9}, 
   3.803684787251586*^9},
 CellLabel->
  "During evaluation of \
In[28]:=",ExpressionUUID->"945d66ca-aa9f-48c5-8e79-590a2d128ec6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["p", 
    RowBox[{"0", ",", "5"}]], "\[InvisibleSpace]", "\<\":  \"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    RowBox[{
     FractionBox[
      RowBox[{"1773", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "5"]}], "128"], "-", 
     FractionBox[
      RowBox[{"68815", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "7"]}], "3072"], "+", 
     FractionBox[
      RowBox[{"855815", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "9"]}], "57344"], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "e", "]"}], "11"],
      SeriesData[$CellContext`e, 0, {}, 5, 11, 1],
      Editable->False]}],
    SeriesData[$CellContext`e, 0, {
     Rational[1773, 128] Pi, 0, Rational[-68815, 3072] Pi, 0, 
      Rational[855815, 57344] Pi}, 5, 11, 1],
    Editable->False]}],
  SequenceForm[
   Subscript[$CellContext`p, 0, 5], ":  ", 
   SeriesData[$CellContext`e, 0, {
    Rational[1773, 128] Pi, 0, Rational[-68815, 3072] Pi, 0, 
     Rational[855815, 57344] Pi}, 5, 11, 1]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.803673214684305*^9, 3.80367322342837*^9}, 
   3.8036890845335073`*^9},
 CellLabel->
  "During evaluation of \
In[28]:=",ExpressionUUID->"a19d7af9-5de1-448c-8c46-5b09c2e1ce73"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["p", 
    RowBox[{"0", ",", "6"}]], "\[InvisibleSpace]", "\<\":  \"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    RowBox[{
     FractionBox[
      RowBox[{"3167", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "6"]}], "160"], "-", 
     FractionBox[
      RowBox[{"84003", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "8"]}], "2240"], "+", 
     FractionBox[
      RowBox[{"538113", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "10"]}], "17920"], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "e", "]"}], "11"],
      SeriesData[$CellContext`e, 0, {}, 6, 11, 1],
      Editable->False]}],
    SeriesData[$CellContext`e, 0, {
     Rational[3167, 160] Pi, 0, Rational[-84003, 2240] Pi, 0, 
      Rational[538113, 17920] Pi}, 6, 11, 1],
    Editable->False]}],
  SequenceForm[
   Subscript[$CellContext`p, 0, 6], ":  ", 
   SeriesData[$CellContext`e, 0, {
    Rational[3167, 160] Pi, 0, Rational[-84003, 2240] Pi, 0, 
     Rational[538113, 17920] Pi}, 6, 11, 1]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.803673214684305*^9, 3.80367322342837*^9}, 
   3.8036934057328043`*^9},
 CellLabel->
  "During evaluation of \
In[28]:=",ExpressionUUID->"d2ea917d-e546-4f69-a5fa-fd7ee3e7701f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["p", 
    RowBox[{"0", ",", "7"}]], "\[InvisibleSpace]", "\<\":  \"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    RowBox[{
     FractionBox[
      RowBox[{"432091", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "7"]}], "15360"], "-", 
     FractionBox[
      RowBox[{"9987299", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "9"]}], "163840"], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "e", "]"}], "11"],
      SeriesData[$CellContext`e, 0, {}, 7, 11, 1],
      Editable->False]}],
    SeriesData[$CellContext`e, 0, {
     Rational[432091, 15360] Pi, 0, Rational[-9987299, 163840] Pi}, 7, 11, 1],
    
    Editable->False]}],
  SequenceForm[
   Subscript[$CellContext`p, 0, 7], ":  ", 
   SeriesData[$CellContext`e, 0, {
    Rational[432091, 15360] Pi, 0, Rational[-9987299, 163840] Pi}, 7, 11, 1]],
  
  Editable->False]], "Print",
 CellChangeTimes->{{3.803673214684305*^9, 3.80367322342837*^9}, 
   3.803697927950164*^9},
 CellLabel->
  "During evaluation of \
In[28]:=",ExpressionUUID->"6abb7eb8-3bf4-49e4-9be5-117e7c9cf867"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["p", 
    RowBox[{"0", ",", "8"}]], "\[InvisibleSpace]", "\<\":  \"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    RowBox[{
     FractionBox[
      RowBox[{"178331", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "8"]}], "4480"], "-", 
     FractionBox[
      RowBox[{"5863513", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "10"]}], "60480"], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "e", "]"}], "11"],
      SeriesData[$CellContext`e, 0, {}, 8, 11, 1],
      Editable->False]}],
    SeriesData[$CellContext`e, 0, {
     Rational[178331, 4480] Pi, 0, Rational[-5863513, 60480] Pi}, 8, 11, 1],
    Editable->False]}],
  SequenceForm[
   Subscript[$CellContext`p, 0, 8], ":  ", 
   SeriesData[$CellContext`e, 0, {
    Rational[178331, 4480] Pi, 0, Rational[-5863513, 60480] Pi}, 8, 11, 1]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.803673214684305*^9, 3.80367322342837*^9}, 
   3.8037029811690607`*^9},
 CellLabel->
  "During evaluation of \
In[28]:=",ExpressionUUID->"6c15587f-144d-4464-975f-f5b26aaf66d9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["p", 
    RowBox[{"0", ",", "9"}]], "\[InvisibleSpace]", "\<\":  \"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    RowBox[{
     FractionBox[
      RowBox[{"64370707", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "9"]}], "1146880"], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "e", "]"}], "11"],
      SeriesData[$CellContext`e, 0, {}, 9, 11, 1],
      Editable->False]}],
    SeriesData[$CellContext`e, 0, {Rational[64370707, 1146880] Pi}, 9, 11, 1],
    
    Editable->False]}],
  SequenceForm[
   Subscript[$CellContext`p, 0, 9], ":  ", 
   SeriesData[$CellContext`e, 0, {Rational[64370707, 1146880] Pi}, 9, 11, 1]],
  
  Editable->False]], "Print",
 CellChangeTimes->{{3.803673214684305*^9, 3.80367322342837*^9}, 
   3.803708555804689*^9},
 CellLabel->
  "During evaluation of \
In[28]:=",ExpressionUUID->"983b6d48-1b8e-4b57-bce6-6cd73faefe57"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["p", 
    RowBox[{"0", ",", "10"}]], "\[InvisibleSpace]", "\<\":  \"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    RowBox[{
     FractionBox[
      RowBox[{"7635529", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "10"]}], "96768"], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "e", "]"}], "11"],
      SeriesData[$CellContext`e, 0, {}, 10, 11, 1],
      Editable->False]}],
    SeriesData[$CellContext`e, 0, {Rational[7635529, 96768] Pi}, 10, 11, 1],
    Editable->False]}],
  SequenceForm[
   Subscript[$CellContext`p, 0, 10], ":  ", 
   SeriesData[$CellContext`e, 0, {Rational[7635529, 96768] Pi}, 10, 11, 1]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.803673214684305*^9, 3.80367322342837*^9}, 
   3.803714416579319*^9},
 CellLabel->
  "During evaluation of \
In[28]:=",ExpressionUUID->"a29b7084-83ec-42a3-9f7f-a19e21162425"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      SubscriptBox["p", 
       RowBox[{"0", ",", "s"}]], ",", "\"\<:  \>\"", " ", ",", 
      RowBox[{"FullSimplify", "[", 
       RowBox[{"Series", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"g", "[", 
           RowBox[{"e", ",", "s"}], "]"}], "*", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"e", "^", "2"}]}], ")"}], "^", 
           RowBox[{"(", 
            RowBox[{"3", "/", "2"}], ")"}]}]}], ",", 
         RowBox[{"{", 
          RowBox[{"e", ",", "0", ",", 
           RowBox[{"10", "+", "s"}]}], "}"}]}], "]"}], "]"}]}], "]"}], ",", 
    " ", 
    RowBox[{"{", 
     RowBox[{"s", ",", "0", ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.803726480833777*^9, 3.8037264811283503`*^9}},
 CellLabel->"In[29]:=",ExpressionUUID->"d657667b-1937-47f2-8679-8ad4f7962366"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["p", 
    RowBox[{"0", ",", "0"}]], "\[InvisibleSpace]", "\<\":  \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"2", " ", "\[Pi]"}]}],
  SequenceForm[
   Subscript[$CellContext`p, 0, 0], ":  ", 2 Pi],
  Editable->False]], "Print",
 CellChangeTimes->{3.803726497200341*^9},
 CellLabel->
  "During evaluation of \
In[29]:=",ExpressionUUID->"a2939ec3-dc48-422a-8c30-758e9e00c97b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["p", 
    RowBox[{"0", ",", "1"}]], "\[InvisibleSpace]", "\<\":  \"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    RowBox[{
     RowBox[{"3", " ", "\[Pi]", " ", "e"}], "-", 
     FractionBox[
      RowBox[{"9", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "3"]}], "8"], "+", 
     FractionBox[
      RowBox[{"9", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "5"]}], "64"], "-", 
     FractionBox[
      RowBox[{"19", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "7"]}], "3072"], "-", 
     FractionBox[
      RowBox[{"133", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "9"]}], "81920"], "-", 
     FractionBox[
      RowBox[{"14177", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "11"]}], "9830400"], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "e", "]"}], "12"],
      SeriesData[$CellContext`e, 0, {}, 1, 12, 1],
      Editable->False]}],
    SeriesData[$CellContext`e, 0, {
     3 Pi, 0, Rational[-9, 8] Pi, 0, Rational[9, 64] Pi, 0, 
      Rational[-19, 3072] Pi, 0, Rational[-133, 81920] Pi, 0, 
      Rational[-14177, 9830400] Pi}, 1, 12, 1],
    Editable->False]}],
  SequenceForm[
   Subscript[$CellContext`p, 0, 1], ":  ", 
   SeriesData[$CellContext`e, 0, {
    3 Pi, 0, Rational[-9, 8] Pi, 0, Rational[9, 64] Pi, 0, 
     Rational[-19, 3072] Pi, 0, Rational[-133, 81920] Pi, 0, 
     Rational[-14177, 9830400] Pi}, 1, 12, 1]],
  Editable->False]], "Print",
 CellChangeTimes->{3.8037287348196993`*^9},
 CellLabel->
  "During evaluation of \
In[29]:=",ExpressionUUID->"cc625cd4-bf73-4c5c-9ffe-e21c5ecc86a9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["p", 
    RowBox[{"0", ",", "2"}]], "\[InvisibleSpace]", "\<\":  \"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    RowBox[{
     FractionBox[
      RowBox[{"9", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "2"]}], "2"], "-", 
     FractionBox[
      RowBox[{"13", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "4"]}], "4"], "+", 
     FractionBox[
      RowBox[{"27", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "6"]}], "32"], "-", 
     FractionBox[
      RowBox[{"29", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "8"]}], "320"], "+", 
     FractionBox[
      RowBox[{"67", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "10"]}], "11520"], "-", 
     FractionBox[
      RowBox[{"299", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "12"]}], "268800"], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "e", "]"}], "13"],
      SeriesData[$CellContext`e, 0, {}, 2, 13, 1],
      Editable->False]}],
    SeriesData[$CellContext`e, 0, {
     Rational[9, 2] Pi, 0, Rational[-13, 4] Pi, 0, Rational[27, 32] Pi, 0, 
      Rational[-29, 320] Pi, 0, Rational[67, 11520] Pi, 0, 
      Rational[-299, 268800] Pi}, 2, 13, 1],
    Editable->False]}],
  SequenceForm[
   Subscript[$CellContext`p, 0, 2], ":  ", 
   SeriesData[$CellContext`e, 0, {
    Rational[9, 2] Pi, 0, Rational[-13, 4] Pi, 0, Rational[27, 32] Pi, 0, 
     Rational[-29, 320] Pi, 0, Rational[67, 11520] Pi, 0, 
     Rational[-299, 268800] Pi}, 2, 13, 1]],
  Editable->False]], "Print",
 CellChangeTimes->{3.803731359898192*^9},
 CellLabel->
  "During evaluation of \
In[29]:=",ExpressionUUID->"8f4cee34-0ade-42b2-b333-8d2c93c7c710"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["p", 
    RowBox[{"0", ",", "3"}]], "\[InvisibleSpace]", "\<\":  \"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    RowBox[{
     FractionBox[
      RowBox[{"53", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "3"]}], "8"], "-", 
     FractionBox[
      RowBox[{"879", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "5"]}], "128"], "+", 
     FractionBox[
      RowBox[{"13893", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "7"]}], "5120"], "-", 
     FractionBox[
      RowBox[{"21359", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "9"]}], "40960"], "+", 
     FractionBox[
      RowBox[{"41067", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "11"]}], "655360"], "-", 
     FractionBox[
      RowBox[{"3547143", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "13"]}], "734003200"], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "e", "]"}], "14"],
      SeriesData[$CellContext`e, 0, {}, 3, 14, 1],
      Editable->False]}],
    SeriesData[$CellContext`e, 0, {
     Rational[53, 8] Pi, 0, Rational[-879, 128] Pi, 0, Rational[13893, 5120] 
      Pi, 0, Rational[-21359, 40960] Pi, 0, Rational[41067, 655360] Pi, 0, 
      Rational[-3547143, 734003200] Pi}, 3, 14, 1],
    Editable->False]}],
  SequenceForm[
   Subscript[$CellContext`p, 0, 3], ":  ", 
   SeriesData[$CellContext`e, 0, {
    Rational[53, 8] Pi, 0, Rational[-879, 128] Pi, 0, Rational[13893, 5120] 
     Pi, 0, Rational[-21359, 40960] Pi, 0, Rational[41067, 655360] Pi, 0, 
     Rational[-3547143, 734003200] Pi}, 3, 14, 1]],
  Editable->False]], "Print",
 CellChangeTimes->{3.803734460697915*^9},
 CellLabel->
  "During evaluation of \
In[29]:=",ExpressionUUID->"a34c908f-0cec-450a-aa0b-d9011b831d48"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["p", 
    RowBox[{"0", ",", "4"}]], "\[InvisibleSpace]", "\<\":  \"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    RowBox[{
     FractionBox[
      RowBox[{"77", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "4"]}], "8"], "-", 
     FractionBox[
      RowBox[{"513", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "6"]}], "40"], "+", 
     FractionBox[
      RowBox[{"2179", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "8"]}], "320"], "-", 
     FractionBox[
      RowBox[{"19157", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "10"]}], "10080"], "+", 
     FractionBox[
      RowBox[{"71857", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "12"]}], "215040"], "-", 
     FractionBox[
      RowBox[{"41663", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "14"]}], "1075200"], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "e", "]"}], "15"],
      SeriesData[$CellContext`e, 0, {}, 4, 15, 1],
      Editable->False]}],
    SeriesData[$CellContext`e, 0, {
     Rational[77, 8] Pi, 0, Rational[-513, 40] Pi, 0, Rational[2179, 320] Pi, 
      0, Rational[-19157, 10080] Pi, 0, Rational[71857, 215040] Pi, 0, 
      Rational[-41663, 1075200] Pi}, 4, 15, 1],
    Editable->False]}],
  SequenceForm[
   Subscript[$CellContext`p, 0, 4], ":  ", 
   SeriesData[$CellContext`e, 0, {
    Rational[77, 8] Pi, 0, Rational[-513, 40] Pi, 0, Rational[2179, 320] Pi, 
     0, Rational[-19157, 10080] Pi, 0, Rational[71857, 215040] Pi, 0, 
     Rational[-41663, 1075200] Pi}, 4, 15, 1]],
  Editable->False]], "Print",
 CellChangeTimes->{3.803738427351541*^9},
 CellLabel->
  "During evaluation of \
In[29]:=",ExpressionUUID->"22afe477-6bc8-4508-bf32-7b7bcf06cf50"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["p", 
    RowBox[{"0", ",", "5"}]], "\[InvisibleSpace]", "\<\":  \"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    RowBox[{
     FractionBox[
      RowBox[{"1773", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "5"]}], "128"], "-", 
     FractionBox[
      RowBox[{"68815", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "7"]}], "3072"], "+", 
     FractionBox[
      RowBox[{"855815", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "9"]}], "57344"], "-", 
     FractionBox[
      RowBox[{"30103445", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "11"]}], "5505024"], "+", 
     FractionBox[
      RowBox[{"3055138525", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "13"]}], "2378170368"], "-", 
     FractionBox[
      RowBox[{"438397391", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "15"]}], "2113929216"], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "e", "]"}], "16"],
      SeriesData[$CellContext`e, 0, {}, 5, 16, 1],
      Editable->False]}],
    SeriesData[$CellContext`e, 0, {
     Rational[1773, 128] Pi, 0, Rational[-68815, 3072] Pi, 0, 
      Rational[855815, 57344] Pi, 0, Rational[-30103445, 5505024] Pi, 0, 
      Rational[3055138525, 2378170368] Pi, 0, 
      Rational[-438397391, 2113929216] Pi}, 5, 16, 1],
    Editable->False]}],
  SequenceForm[
   Subscript[$CellContext`p, 0, 5], ":  ", 
   SeriesData[$CellContext`e, 0, {
    Rational[1773, 128] Pi, 0, Rational[-68815, 3072] Pi, 0, 
     Rational[855815, 57344] Pi, 0, Rational[-30103445, 5505024] Pi, 0, 
     Rational[3055138525, 2378170368] Pi, 0, Rational[-438397391, 2113929216] 
     Pi}, 5, 16, 1]],
  Editable->False]], "Print",
 CellChangeTimes->{3.8037450297592707`*^9},
 CellLabel->
  "During evaluation of \
In[29]:=",ExpressionUUID->"d99bd015-73e3-4eff-971f-589d1c588861"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["p", 
    RowBox[{"0", ",", "6"}]], "\[InvisibleSpace]", "\<\":  \"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    RowBox[{
     FractionBox[
      RowBox[{"3167", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "6"]}], "160"], "-", 
     FractionBox[
      RowBox[{"84003", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "8"]}], "2240"], "+", 
     FractionBox[
      RowBox[{"538113", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "10"]}], "17920"], "-", 
     FractionBox[
      RowBox[{"488317", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "12"]}], "35840"], "+", 
     FractionBox[
      RowBox[{"5781747", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "14"]}], "1433600"], "-", 
     FractionBox[
      RowBox[{"18910653", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "16"]}], "22528000"], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "e", "]"}], "17"],
      SeriesData[$CellContext`e, 0, {}, 6, 17, 1],
      Editable->False]}],
    SeriesData[$CellContext`e, 0, {
     Rational[3167, 160] Pi, 0, Rational[-84003, 2240] Pi, 0, 
      Rational[538113, 17920] Pi, 0, Rational[-488317, 35840] Pi, 0, 
      Rational[5781747, 1433600] Pi, 0, Rational[-18910653, 22528000] Pi}, 6, 
     17, 1],
    Editable->False]}],
  SequenceForm[
   Subscript[$CellContext`p, 0, 6], ":  ", 
   SeriesData[$CellContext`e, 0, {
    Rational[3167, 160] Pi, 0, Rational[-84003, 2240] Pi, 0, 
     Rational[538113, 17920] Pi, 0, Rational[-488317, 35840] Pi, 0, 
     Rational[5781747, 1433600] Pi, 0, Rational[-18910653, 22528000] Pi}, 6, 
    17, 1]],
  Editable->False]], "Print",
 CellChangeTimes->{3.80375012833921*^9},
 CellLabel->
  "During evaluation of \
In[29]:=",ExpressionUUID->"0ce0a05e-6058-4469-91f9-740ceb39ec06"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["p", 
    RowBox[{"0", ",", "7"}]], "\[InvisibleSpace]", "\<\":  \"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    RowBox[{
     FractionBox[
      RowBox[{"432091", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "7"]}], "15360"], "-", 
     FractionBox[
      RowBox[{"9987299", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "9"]}], "163840"], "+", 
     FractionBox[
      RowBox[{"671904569", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "11"]}], "11796480"], "-", 
     FractionBox[
      RowBox[{"130846410289", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "13"]}], "4246732800"], "+", 
     FractionBox[
      RowBox[{"83318824393", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "15"]}], "7549747200"], "-", 
     FractionBox[
      RowBox[{"168738442158643", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "17"]}], "59793997824000"], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "e", "]"}], "18"],
      SeriesData[$CellContext`e, 0, {}, 7, 18, 1],
      Editable->False]}],
    SeriesData[$CellContext`e, 0, {
     Rational[432091, 15360] Pi, 0, Rational[-9987299, 163840] Pi, 0, 
      Rational[671904569, 11796480] Pi, 0, 
      Rational[-130846410289, 4246732800] Pi, 0, 
      Rational[83318824393, 7549747200] Pi, 0, 
      Rational[-168738442158643, 59793997824000] Pi}, 7, 18, 1],
    Editable->False]}],
  SequenceForm[
   Subscript[$CellContext`p, 0, 7], ":  ", 
   SeriesData[$CellContext`e, 0, {
    Rational[432091, 15360] Pi, 0, Rational[-9987299, 163840] Pi, 0, 
     Rational[671904569, 11796480] Pi, 0, Rational[-130846410289, 4246732800] 
     Pi, 0, Rational[83318824393, 7549747200] Pi, 0, 
     Rational[-168738442158643, 59793997824000] Pi}, 7, 18, 1]],
  Editable->False]], "Print",
 CellChangeTimes->{3.803755509965209*^9},
 CellLabel->
  "During evaluation of \
In[29]:=",ExpressionUUID->"6b8d1d5c-a6cb-438c-8475-b130f5820537"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["p", 
    RowBox[{"0", ",", "8"}]], "\[InvisibleSpace]", "\<\":  \"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    RowBox[{
     FractionBox[
      RowBox[{"178331", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "8"]}], "4480"], "-", 
     FractionBox[
      RowBox[{"5863513", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "10"]}], "60480"], "+", 
     FractionBox[
      RowBox[{"83437241", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "12"]}], "806400"], "-", 
     FractionBox[
      RowBox[{"576377581", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "14"]}], "8870400"], "+", 
     FractionBox[
      RowBox[{"29950260751", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "16"]}], "1094860800"], "-", 
     FractionBox[
      RowBox[{"31381640833", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "18"]}], "3773952000"], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "e", "]"}], "19"],
      SeriesData[$CellContext`e, 0, {}, 8, 19, 1],
      Editable->False]}],
    SeriesData[$CellContext`e, 0, {
     Rational[178331, 4480] Pi, 0, Rational[-5863513, 60480] Pi, 0, 
      Rational[83437241, 806400] Pi, 0, Rational[-576377581, 8870400] Pi, 0, 
      Rational[29950260751, 1094860800] Pi, 0, 
      Rational[-31381640833, 3773952000] Pi}, 8, 19, 1],
    Editable->False]}],
  SequenceForm[
   Subscript[$CellContext`p, 0, 8], ":  ", 
   SeriesData[$CellContext`e, 0, {
    Rational[178331, 4480] Pi, 0, Rational[-5863513, 60480] Pi, 0, 
     Rational[83437241, 806400] Pi, 0, Rational[-576377581, 8870400] Pi, 0, 
     Rational[29950260751, 1094860800] Pi, 0, 
     Rational[-31381640833, 3773952000] Pi}, 8, 19, 1]],
  Editable->False]], "Print",
 CellChangeTimes->{3.803761103951894*^9},
 CellLabel->
  "During evaluation of \
In[29]:=",ExpressionUUID->"e2740cd7-bdd9-4bc2-bf7f-85a549d76a7c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["p", 
    RowBox[{"0", ",", "9"}]], "\[InvisibleSpace]", "\<\":  \"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    RowBox[{
     FractionBox[
      RowBox[{"64370707", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "9"]}], "1146880"], "-", 
     FractionBox[
      RowBox[{"6955625097", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "11"]}], "45875200"], "+", 
     FractionBox[
      RowBox[{"734132462571", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "13"]}], "4037017600"], "-", 
     FractionBox[
      RowBox[{"8396796965937", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "15"]}], "64592281600"], "+", 
     FractionBox[
      RowBox[{"845650572188427", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "17"]}], "13435194572800"], "-", 
     FractionBox[
      RowBox[{"83532070070172513", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "19"]}], "3761854480384000"], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "e", "]"}], "20"],
      SeriesData[$CellContext`e, 0, {}, 9, 20, 1],
      Editable->False]}],
    SeriesData[$CellContext`e, 0, {
     Rational[64370707, 1146880] Pi, 0, Rational[-6955625097, 45875200] Pi, 0,
       Rational[734132462571, 4037017600] Pi, 0, 
      Rational[-8396796965937, 64592281600] Pi, 0, 
      Rational[845650572188427, 13435194572800] Pi, 0, 
      Rational[-83532070070172513, 3761854480384000] Pi}, 9, 20, 1],
    Editable->False]}],
  SequenceForm[
   Subscript[$CellContext`p, 0, 9], ":  ", 
   SeriesData[$CellContext`e, 0, {
    Rational[64370707, 1146880] Pi, 0, Rational[-6955625097, 45875200] Pi, 0, 
     Rational[734132462571, 4037017600] Pi, 0, 
     Rational[-8396796965937, 64592281600] Pi, 0, 
     Rational[845650572188427, 13435194572800] Pi, 0, 
     Rational[-83532070070172513, 3761854480384000] Pi}, 9, 20, 1]],
  Editable->False]], "Print",
 CellChangeTimes->{3.803767153579088*^9},
 CellLabel->
  "During evaluation of \
In[29]:=",ExpressionUUID->"379093c9-50db-4c9a-861f-d2e46cf56f56"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["p", 
    RowBox[{"0", ",", "10"}]], "\[InvisibleSpace]", "\<\":  \"\>", 
   "\[InvisibleSpace]", 
   InterpretationBox[
    RowBox[{
     FractionBox[
      RowBox[{"7635529", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "10"]}], "96768"], "-", 
     FractionBox[
      RowBox[{"166026365", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "12"]}], "709632"], "+", 
     FractionBox[
      RowBox[{"1767674785", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "14"]}], "5677056"], "-", 
     FractionBox[
      RowBox[{"994626571585", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "16"]}], "3985293312"], "+", 
     FractionBox[
      RowBox[{"363110363225", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "18"]}], "2656862208"], "-", 
     FractionBox[
      RowBox[{"6130679273701", " ", "\[Pi]", " ", 
       SuperscriptBox["e", "20"]}], "111588212736"], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "e", "]"}], "21"],
      SeriesData[$CellContext`e, 0, {}, 10, 21, 1],
      Editable->False]}],
    SeriesData[$CellContext`e, 0, {
     Rational[7635529, 96768] Pi, 0, Rational[-166026365, 709632] Pi, 0, 
      Rational[1767674785, 5677056] Pi, 0, 
      Rational[-994626571585, 3985293312] Pi, 0, 
      Rational[363110363225, 2656862208] Pi, 0, 
      Rational[-6130679273701, 111588212736] Pi}, 10, 21, 1],
    Editable->False]}],
  SequenceForm[
   Subscript[$CellContext`p, 0, 10], ":  ", 
   SeriesData[$CellContext`e, 0, {
    Rational[7635529, 96768] Pi, 0, Rational[-166026365, 709632] Pi, 0, 
     Rational[1767674785, 5677056] Pi, 0, Rational[-994626571585, 3985293312] 
     Pi, 0, Rational[363110363225, 2656862208] Pi, 0, 
     Rational[-6130679273701, 111588212736] Pi}, 10, 21, 1]],
  Editable->False]], "Print",
 CellChangeTimes->{3.803773295524373*^9},
 CellLabel->
  "During evaluation of \
In[29]:=",ExpressionUUID->"945b8e2c-d537-47b4-9b7e-84ba0dafd59d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      SubscriptBox["p", 
       RowBox[{"0", ",", "s"}]], ",", "\"\<:  \>\"", " ", ",", 
      RowBox[{"FullSimplify", "[", 
       RowBox[{"Series", "[", 
        RowBox[{
         RowBox[{"divergenceless", "[", 
          RowBox[{"e", ",", "s"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"e", ",", "1", ",", 
           RowBox[{"10", "+", "s"}]}], "}"}], ",", 
         RowBox[{"Assumptions", "\[Rule]", 
          RowBox[{"e", "<", "1"}]}]}], "]"}], "]"}]}], "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"s", ",", "0", ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.803756790478421*^9, 3.803756815267407*^9}, {
  3.803824312816039*^9, 3.803824323431096*^9}, {3.803824371190621*^9, 
  3.8038244024551773`*^9}, {3.803824541467121*^9, 3.803824545760132*^9}, {
  3.803831673317328*^9, 3.8038316799678497`*^9}},
 CellLabel->"In[33]:=",ExpressionUUID->"8ae4c4f8-bcf5-462e-b047-2036e485c79b"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["p", 
    RowBox[{"0", ",", "0"}]], "\[InvisibleSpace]", "\<\":  \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"2", " ", "\[Pi]"}]}],
  SequenceForm[
   Subscript[$CellContext`p, 0, 0], ":  ", 2 Pi],
  Editable->False]], "Print",
 CellChangeTimes->{3.803824453770048*^9, 3.80382455679803*^9, 
  3.803831707573504*^9},
 CellLabel->
  "During evaluation of \
In[33]:=",ExpressionUUID->"d7633835-163d-455f-a9b4-dd466ad92af9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SubscriptBox["p", 
    RowBox[{"0", ",", "1"}]], "\[InvisibleSpace]", "\<\":  \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          SuperscriptBox["e", "2"]}], ")"}], 
        RowBox[{"3", "/", "2"}]], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"\[ImaginaryI]", " ", 
         RowBox[{"(", 
          RowBox[{"u", "-", 
           RowBox[{"e", " ", 
            RowBox[{"Sin", "[", "u", "]"}]}]}], ")"}]}]]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"e", " ", 
          RowBox[{"Cos", "[", "u", "]"}]}]}], ")"}], "2"]], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", 
       RowBox[{"2", " ", "\[Pi]"}]}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"0", "<", "e", "<", "1"}]}]}], "]"}]}],
  SequenceForm[
   Subscript[$CellContext`p, 0, 1], ":  ", 
   Integrate[(1 - $CellContext`e^2)^Rational[3, 2] 
    E^(Complex[0, 1] ($CellContext`u - $CellContext`e 
       Sin[$CellContext`u])) (-1 + $CellContext`e 
       Cos[$CellContext`u])^(-2), {$CellContext`u, 0, 2 Pi}, Assumptions -> 
    Inequality[0, Less, $CellContext`e, Less, 1]]],
  Editable->False]], "Print",
 CellChangeTimes->{3.803824453770048*^9, 3.80382455679803*^9, 
  3.8038512283769703`*^9},
 CellLabel->
  "During evaluation of \
In[33]:=",ExpressionUUID->"5c032676-9f61-46a3-90ba-4c4cc4e8ddb7"]
}, Open  ]],

Cell[BoxData["$Aborted"], "Output",
 CellChangeTimes->{3.803824523782648*^9, 3.803831653163595*^9, 
  3.803911777767627*^9},
 CellLabel->"Out[33]=",ExpressionUUID->"6349911c-fde0-4af1-80de-0553315a299d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogLogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"1", "-", "x"}], ",", " ", "0"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"1", "-", "x"}], ",", "1"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"1", "-", "x"}], ",", "2"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"1", "-", "x"}], ",", "3"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"10", "^", 
      RowBox[{"-", "3"}]}], ",", 
     RowBox[{"10", "^", 
      RowBox[{"-", "1"}]}]}], "}"}], ",", 
   RowBox[{"PlotPoints", "\[Rule]", "100"}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*SubscriptBox[\(p\), \(0, 0\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(0, 1\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(0, 2\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(0, 3\)]\)\>\""}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"Style", "[", 
     RowBox[{
     "\"\<Zoom of \!\(\*SubscriptBox[\(p\), \(0, s\)]\) coefficients for e \
near 1\>\"", ",", 
      RowBox[{"FontSize", "\[Rule]", "32"}]}], "]"}]}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"\"\<1-e\>\"", ",", 
        RowBox[{"FontSize", "\[Rule]", "24"}]}], "]"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{"\"\<\!\(\*SubscriptBox[\(p\), \(0, s\)]\)\>\"", ",", 
        RowBox[{"FontSize", "\[Rule]", "24"}]}], "]"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.8012486306343517`*^9, 3.801248674896487*^9}, {
  3.801248738074431*^9, 3.801248749350185*^9}, {3.801248784040505*^9, 
  3.8012488728629417`*^9}, {3.801248934219266*^9, 3.801248938274579*^9}, {
  3.801249071388444*^9, 3.801249099775344*^9}, {3.8012529574218597`*^9, 
  3.801252988286579*^9}, {3.8012530186050253`*^9, 3.801253020045125*^9}, {
  3.801253888357154*^9, 3.801253913611144*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"70dad235-308f-4ed3-846d-08706ae5f7bb"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{}, {}, 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwVy3k41Qsex3H9cCyJ8zv7YjnHQdnSYkuLL0akchGpqBsyE1IiMZVTtghF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          "]]}, 
        Annotation[#, "Charting`Private`Tag$76263#1"]& ], 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwVy3s01AkcBfBpRWuSmTHv+c2MeSuS5P3cb0QUJZGKpKytmU7Zpk7Z6ljS
JjKa3Woc22zIqpFiRSU99kvSi0SEXS1pSEWSapFq7R/33PM591zxxsTwhK9I
JNKqqfzfizq+12UWEMjIELU4hCvAOEyJfJRPILPZUn16hQLSZpTR+VPmMkhW
ginXug5pz58kMEfzagU5TAFwXHn44QkCK6L7m42hCvAJ35jC0hEo7trSkhus
ANeGlapTmQRaMKrbTBYqYDa6+lbvIFD+MaWv3UEBS+j69RQ/AkmvrhXryQpI
SL7NKaMTWE2c8+98LgetetpFt34eHjeZKKq7JYfx5r/u9VXyMCurq7EhXw7R
wXuS/jnIQ1XzqvqQZDlM2F3Jm4zgYZDaQfditRzO5pidNZHx0OfbUl8XZzms
JHghkR+4WLbg9/Ixmhw8yI2bGuq4GNeqYXUOyoBLCySydVw8cIi0yPGeDMwL
GsvdlVyM5nsHuhtk4Kp/V/O1OxdLrvRHxaTJYF3ZU6WUzMX048W2Y3EyqLHf
dji+g4Ojarmi3EsGLi7m2qwzHByYv30Wly2DwgjVXNIeDjqavjw39k4Ky7pV
frlBHLyqbf31fZMURlMd3+zjcbBTQfZVnZdC25Ec9sEBNrrdTVs+mS6F2woL
SdJlNqrDfWN94qVQ0RZYV5nBRsbPfPYHkELXsKiHtZqN1/UVWxsIKXwW1xy9
OYeNoZXtKt64BByfJNqumWShaYBFLLtdAgUmNzwZ91kYcCxZuuCCBMh+Lb3c
31io8x5JrTsigfJXP00P2MJCz20nu3eqJLBZGGS+xpOFa6MEMa0BEuAoHxZd
tmBhiGzDhhKpBMysx656/c3E3sB7hvzPYhga7FOSzzNRW3R0x6wuMRj9eydq
fmSi5Z4N4XOqxcA1SzbNW8bE/iiX6/HHxbC4p/tMvYiJf3Aqc5g7xFAhf3qT
PszAFLetPv2hYuCkGXaXIAO9brFC5tmJQaNMtpx7lIFrx+sz5OZigKujwpYN
DLzaVP7ayyiCQZnD7VonBuY3vS+8WyOCtnHzFx3TGBg0xGrapRdBU9ToUPtD
Om7RdSc+2i2C2sZTmeJCOponaP3PRIrgbelIvnY7HdeVZU87MV8EfIPZ8iX+
dPzOzm/A1FIEq2xtewaZdKx1jI+DDmtoZA+9rDRa4VDIg7qL2dbgK9iluX3J
CuNekZ24S6xhUHOy+MsBK9xRIQ278UUIZ9PbDKIIK4yN0Y3UXhLCxtyWb7IU
VvjExmfxRbUQoliJYYL3NLTzUGpezhZCYEnz2Fg9DTM4NzbPMgpAXfKIN3GM
hvO6LPx25gqg1NlobYyn4YUWvsIrTADGtuprHFcaGh4MOg3PFEBU7/xH6uk0
tD9y6P5ADR/qzLamsh9Tcd3+BQlN+/iwsPKyVZGBir577auZHnz42FAgWL2b
ih77NgUVDhNQ+mkFRgZTUdWaHykoISAvt6AriU3FY/4sck8cAc5WeRYXWVR8
Ik3KuraegDuZeu8RJhWHnntTcmMJeLM3R69kUFG/dpgZHkMAxGpi1tKoyDk9
blMXRUCP5Icur5lUfF5VHmtYNrWvLqj69ImCdpHW7O3eBGwO1nN2TVLwWfJk
UagXAVrPnKTXExS8k+nrYus59edr3Lv/peCijJGIZ24EpDxNqsIRCpKMjNxI
JwJQFVaV1kfBs/brnT1tCRiIXsqZfEbBtzN+ucuaQwA1NDBpZy8FdfW260dt
CIhz8HZP6KbgjAXZh8/JCSC9s6kK7KRgYbrwhVBMwOw+CefPdgpql+5P/WhN
gMHvoLD1MQXXhQ4Xh0z5P7mQYFs=
          "]], 
         LineBox[CompressedData["
1:eJwVzH0w1HkcB3Dz3V271u7+fPdnWfvTYYyYIeZuFFfig+QhyuhJyBV1iSOZ
49xpZD30sG0PKsZjXKdOJ/JwV+mq+7DUlufLNNwMKQ8zHRouFtfddO6P97zn
9cf7bRd3LOIwMTIy2rKa/7v6Puvp9ILBUVFyaKE1B/pbspLqAQZPnkmaSuY4
mCszWVb2Myi7058TouJAqeVHFvYy+FJbwTlacTC/u5/vv2qJzHNwRsnBswvP
PzQ8Z5C6O/j4W3Bg1nbczm3V8zf/XTOh4GCMP6HZ9ZRBqde7gg6Wgxytfn9V
G4P3KD+qgOHgcXkhb/1dBrdIZaxQyIHXA/sdB6oYvFa3rBcbVOCxFDh19ziD
wyPKQHZQBbWBfcI7MgYPLXVfTtaoQKJ/E+nVLEO1WpXXEqCCS1FsavleGYb1
Ts/tIyq4qMv9LmBRimkXnaPCWq1AHZP9c36pFJedgmqd061gtuv+a9kGKTap
ll9GOltBaNJJb9dhCUZnWJalTimhyzr+oE22BLWBC5lvryuhs6bgm2hOgqUN
PhMt+5TQHOP+yOU3U8wcapg/olCCatrOEBRtiiO+qD/WZQnXz7ksblgRo8Om
9it/5FrCmhid/YNKMbrbXBhd52MJLK804MxGMWry99oMLVrAP8N/F0+PmOBY
njg2sckCBLpvG2zzTDB71Ox8bIoFnM31aK22NUG9ylRQ72ABRmnq9790iDA7
8ob8zWsFzHuI7SwOirA+1Nnx6xIF8MwazYM+CvGcG88/MVwBIuUbD6ZGiJYV
Nf4BUgWcNkRst/MV4sM/80XqDnNY4Ydf1U8Y4w3b4eHqHHPQOiRW+2qM8WFf
CLH3NodSa12VwMkYFzK/rzMxsFDqX9sb2y1Ag3cW/N7Mgrlv9xw5KsCta1x3
kEQWclNO+HlJBDjjqrVi17Jg1hAcFdjEx9tjO/mnxuVg1bH7cOV2Pu5tLxcd
KpeDQvyu6sxfPFQM9a/YRMpBu7az5/EFHv6Y7v4omJGD/e7WticuPKxz4n59
+ZRCfcvnk/EDBNnuj57eBRRSym9b9/QRJAmvpxT5FFzzbHZt6CV4tQeLZnMp
NEYIdKIugkmVmYaKHArN8/3V9R0Ea0ef6T5kUbjrlhCzdI/g2dnR861pFB7X
Fb/QXCNoFuzyav0BCtlXTEwXKghO9pTeln5BwSfrhN/+coJyJcma3E8BQ+Ka
3EpW95fbVUXRFNrfrrs4WEiw7zOjLxf2UHji2BnySQFBD+89zi1hFE4xnrmn
8whifLzoXCiFwKWfWufUBCOLj07FbaOgf3LJSZe9+nfnwA15MIXnh2OMEzIJ
hucZXNO2UNCE9W0eyCDYPq5nQ/wpbFvvl74xnaDwyJUVOz8K3XynCUkaQVGs
mX7Ah4J2pozLSCWYUNTeeMubQtigdOerFIJjGV+VqTdTkD3M0QQlr3pcWrDP
i0LvD+/bmpIINj66mfrpJgr/AWeK1Wk=
          "]]}, 
        Annotation[#, "Charting`Private`Tag$76263#2"]& ], 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwVjXtUDHgYhkt2ViPN/fqbqbmXSC6VlK1PtjQUKSmLJMdSbruxldjS6WZL
DJakyLAIXUlSdn1FcilSO01WS9JtV0mSMkrb/vGe9zznOe95paE7/DZOMDIy
ChzP//1t8w/HU7UEM68T5gw/FbT30QIazxCc6ne4+LflKkj4upAlGufpD0yX
k3GucuzV5J8m2ORlopnkqwI4FpZWn0Vwchbf/LWPCr7xC93HPU6wy1BLPaFW
gWOtf/jZVIJT6CGUCQtUYI2OruU7CQbPWEJpslPBYlb2Opo7wYeDbhdOUlWw
MbaGX8giaBP6J9F3KUETYXx9bqcQa6vHAquqlfDp6V8PO0qEKIRk/4dnlLBa
HRP9IlmIkZszLBfHKsEw7WbOyAohfvG9X9EZpITLGZTLJgohJsVV2M62V4I/
EXoHfBQgp1MWPshQwjxq3abauwK8cvzYIV2PAgQMT3LwuACp9yN+tn2oAFNt
XbFTmACNvx+db5+rAMfsD5WTnAS4aR7dOChBAWsLX4XJqeOcb508EKKAStvt
aRua+fhUr7bKc1GAg4Op5sBFPqYl2RayeAo4tyJ8ulEMH28Hufa9/yCHpS/D
3TO9+GjSrdze90QOA/Gz3u0V8lFYY3V2Q74cdIcyeMndPKwzd5s9mCKHGpWZ
LPoGDxu2LCpz2CCHazrPuyW/8NCQFNjdC3Jo6ZO0coN4WHqtPOcOkcMXaeXR
O1N5mPV64Sj9kwxm/b3DZtUIF1W/D3tN0ctAa/KHM/sRF6/a/rTE6qoMqO4N
bYJTXPSCM51lh2RQ/CZposcWLrqFmKzfHC6DzRZepqucufhsz6reex4y4IfV
n79hxsXHOo8Jp+QyoFgOV7g852Be96tZh79IobenI4yaz8F++6ntI8+l0L6w
zVAZx0H9/rRsXrkUBJTYr3KWclC4P6XI95gUFrW+vHhPwsGzQyfnGO+UwjXl
qzusPjYuzd2qrveRAj8hN+oKsrF3zaN73GlSSA+LNZ9+lI2MrZ+DzUylABUD
Fg3r2ehgeNssaZdAj8KupmoOG/nberR5lRLQfTL9p9mYjQ3Fpw8FZkvgSeBA
r76ehSGNL54WR0mgqu5sqvQcC5+x2zwSAiTwvqD/jOZHFvpSH7jtmikBUS5l
2eKFLFQ53l7XMkUCK21sWns4LCyZUbq7S28Jdbzef0vamagfm8xYedASXMWR
6TWlTMzbNJR3VW0JPemnL40lMrHO2LVp2ZgFXE7R5UpWMNHphnSKd6kFhGY2
uB1QMbE4xn3AIcICArk7fMWDDNSMtISut7YAzytPh4fvMdCoaXBNzGsxRFxp
FBp+ZaD3UUqR7oQYCuzbLds3MDDZZ1ewZpkY2nXlt/iODAw1XTfNabIYAttm
NkZMZOCyk3aR8koR3KVsi+c10bGTm1XweY8IFpTcYJ7PpaNbfFHrbCcRfK7V
ioOi6FjUf6Cq4C2BgtHlGKCm42P/UjPeZQI5mdqWaB4dt+VrJ1SvI2DPzDG7
zqUjLVE9UxtM4H5q9vx+Dh03ejsH/7yWwLs9GdlhbDpm1n8sd1hNAILT13zH
oGP53paoCysJtMp2t7hMpqOV2fqxFJ9xH6QtGx2lYbgq0WOJC4HN6mx+5AgN
DW+C9lo5E9A4Z0S/NdDw7bGoaybzxveidKeXQzQcKTkiu+VIYN+r6DLsp+HN
9zDRdjYBDPctS+igIcs4UWc+lUD36iX8kdc0pB810N9YEaD7eEbvaqPhkfgK
7xoVgRC7+U4bX9LQ/oioOk5BwOiDVZnnMxp2+a+5+c6SgHWHjH9bP/6XpRqq
tSDg2ySOnttEw117XRwuiQmU87tWKHU0HIiLNLSICPwHprtutg==
          "]], 
         LineBox[CompressedData["
1:eJwVx384FHYcwPF7vneH49z53i/nrsZ1rc6myNYptD6UHRaTmB7OpLo9HCr9
XE2nqOhSMk1JdVr1aKIhhPXjw6FbuCRlbZqStR/NkqKH9WTtj/fzet6K1esj
dYTBYMDb/jd55uPibZ18lP244q5OIgeVqSH1RAcf31wwHWwRy8GpOV3heZOP
jgVlKTUiOTxkDRmjbrz9lh2qrwVy2JVniTc18zEoyfPccp4crpUUMOfX87GR
01fezZaDf5Py01UmPrqcCvnd+lIGPq80T+rT+ag/ypnV2SOD85pbtt/z+Bir
23iKu18GXMvgSv8aHhrmjeQvWCqDw7HCDSUxPCx/MqPYzJBBvjlrR9CYI0ZZ
gyeLLrvAbq2hdk+xI5YX8HnRm1xguKPhEU/tiGk9z/Zr3V1gWUrmR3Pvc/ED
dnho+JAUOqatSXQ1cFFnDuCaSqXQdnbvtjg5F/ddYWX7xkihRvvhVY/rDnhy
9Ib/dYEUZE8V48FxDpjkE1uWb3GGbw94jKkn7DHYqzrjeqYzTNealU0n7XG5
1jWhz88ZhMzioFxfe7yUmDjlNyqB1/cni54+4ODAUcNwTqUE2ObtF92yOdhT
WWeZp5fA/iyfxlI3Dka+CaTuCgkwNu5+Uddqh921TVKbB2J47mOvkCTa4dwf
zv7qVSgGplOVKHjKFjMjEvobQsVgJx304Z+1xaklx+pm2oohZzwyXBFgiz9P
9/jjwVURTLAijliGbFAZd+HE9u0iyHtXXxpgtMGVH5/pW68WQfE0s4mtssFv
DjP/rR4WQvGS89bPO9kYdmfctfc7IYgCOkdIMhvxi8Z4WCWErHUZgf5cNvZX
jB4xyoXgdDEkVlPNQs1Dbst7PwnApTVadzKchXLV1FGnfAGI7f8x5Y4yMW1A
9Lg7VAB5s9q6rh1i4sAoQ9LDEIAyurG53YOJVQ0RBxQNFCovLfxtzW2CFVUR
zprNFNaVVEzrukVws2jHiHQThbnZrlFqK8H+ezmWv9IpVEWyzXYdBJ+NLtty
aD2FmufdpZWtBPdY1zbf1VOo90zSvrpM0LuLqVybSOHahaI7xlME27sr2LvC
KRgKOQ4vTxAc8zvXuDyMwuKvMgLjSwieJrpU5TIKGLq62vMYwaFBtbU9hELL
n3PyewsIBh7jZDsGUWif3Rb6zl6CyYeKqo77UdjHX5CVk03ws6WFEam+FDSv
yhtHdhPUuwU/W7SQgqX9sMpsINiXek/1SE3hpk5rk/QlQaLS5832pmAMu7Xo
9laCtx9zZ0x4UfhkfuAW3y0Ey14n1N/0pNDJUg1xNxLMiBH+kjaHQt7fx+Vb
NxAMOZ2estiDQliv44qBdQSvxmRMOr1PgXdllzE4jeDOnd65g+4UrGdeNFen
EKwVFYpqVRT+A9+SvSI=
          "]]}, 
        Annotation[#, "Charting`Private`Tag$76263#3"]& ], 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwVinlYzAkch0t0bX7NNPdvau7GlkIkNuRbKNNW0iGihCVlSdklpDZFSAod
2tIh6dpmJIkGfcuRRbqkREnPIDRCSiXa9o/3+Tzv83mFG0M8Nk/S0NDwneD/
Xdq+M/VYLheLjXL+tPCQgqrf0Lslh4s3d16g562UQoyOgmY84TPiFeWcCa+1
USeVZnHR++u/n7TdpQApQfGNGVzkXeXveOkqhUUeG/9ipnIxYOmKwFSZFGwe
egafO8ZFh4qatRr2UvgZbeyqdk301VNdH8+UgjMtc72hAxe7mk88OKMvhc2R
dWwFjYtgkMlvfWMKSWGaFfNek9gR8vd8vGMKI00d919dJlHLzPqnezmmsFa2
L7zrMIn+Sc5yp0hTGJ1+LXvMi8Sp449I1WpTKE7TLtaSkJg0Eug709oUPLmk
i/cQB5mTdv72mWoKv+jXBz68zcFRH8cVzX0S4FAduSdSOcgIC5xkfl8Cern1
ZfODOLgo1jN2VqEEbDK/1OjO56BPxkUNrxgJ+CleBon1Ofhe9n1Rf4AEaix3
xG9qZ2Pb15PxBQskMHeuXtLxAjb6RdkoCZYE8ryCLTT2sXEkVjNP/UUMbi+C
HdKXs/HsfXPl2wYxDERbfYwg2bi3aP4Rv1IxtCamsQ73snCZXkTOhzgx1EkN
ROGVLLw42FUwY5MYylsdb18+ysK2m+I1r0EMz/sF3czVLPy95V2EkiuGH8Ka
07fMWDhZO8hRd0QEVp0h5mvGmOi65eKQVpsIcrVu2tIfMDGvauZSk0si0Hdo
7uGcZWJ09ZiZPFEEZe8PTV62jYmKNZZN64JFsJW3XG+NLROvLLSLrFomAnZQ
Y36lARNPPsksTxSLQJs/rFzwjIEPD7Z0HfwhBHXfqyD9UgZys9/Eq58JQbWk
Z7QmioEuEd+sdKqEwNGOnJLtxsDka77ai1OE4NT9ouCugIFDarrsQ5gQyk1f
3qL109EyMOut0lUI7JjCPSVIR2fVtI8a04WQEBRJWJymY8VW/x9fdIUAygFe
8wY6dm5jlOqoBNAnmVlXO4eO++RLik7WCKB1RO9tuyYdZZ01B2wzBdDgM6Bu
a6RhudI97tQeAdTWnzsmzKMhXc6o2eAtgM/yTzlJoTTs0u0Xus8SgHGh9grn
JTS8S6vOr5gqgFXm5t19DBrO6fz1SHIbH+pZ6neXVUY4eKi5ciyBD3YmuxPq
rhhhQLrvKw8ZH/oSsorGY40wkOqS0PuDB8VxrYUCLyO0OxDX+LyCBxvTmxcf
lxrhwmrD6zdDeeDDDHE3GaTimURlR/c0HjiWNA0P36XinLiB3R97TCCspIUc
Tabi9cSjT+GMCcitVXzVJip+cyPV/W4moGqtus62oaL7YCrluL4J+PTMagmb
TMXA84qqIDSG29rbo1lPKNjQPsXWer8x2F+uNMovpOBbLbPBdfOM4dvDXJPV
eyiYx5aq69RckH9fid4yCur1zLHiF3EhOz33eTiLgprDAYuu+XPB/sB4pV69
IY4eWX6rjMGFeV+dXl8JNcRpWzifUppIKHRq0FEQhhg3NB51I44Eg3s9qxde
InB0LcOz0YGEVccWtzZdJPCp1T5KrT0JOS6ZKwMVBGYcnfKoHEiwbvJ2PvUP
gVMVibI0OxLWddxb0HuBwCsbQh38bUko7ZPzkjMIvPN0y4I+KxLcqPtV72MJ
HGwZk+kKSTjT0hYQHUNg9Tszg1E+CT0p1p3MgwSmjUU8es8jYTf5odU+isCk
8WTPBmMSssQb6tL2EliodXx9KpuE3lc3lliGE+j5R6/oCIuE2YUk1u6e+JXB
r/cySbhr8fiqeheB15Xd2/3oJFD6Z82NCSPQYttjqxU0EnzLEsrYoQTmd6kH
wYiE87veWcpDCAyhWlbNppKgU6EsebyDwGmczalJFBL+A/Bpjw0=
          "]], 
         LineBox[CompressedData["
1:eJwBQQO+/CFib1JlAgAAADMAAAACAAAAQFG//XoHDMCuFYU5DEYYQADdwz4x
BwzAeFwVS9VFGEDAUvHITwQMwNox6PqvQxhAvABdGkTtC8Ala46FhTIYQLJc
NL0svwvAoau41zAQGEAa6yH2SFsLwFaez83KxRdAooss9Tb5CsBXl06WwHwX
QB1cwyO6nQrAQyyr3J04F0ATA5lFiDoKwGe5oae97hZA/Nn6luvdCcA14FLt
w6kWQAXDea4ggwnAxi6qACRmFkCJgje5oCAJwPSXwo/EHBZAAHKB87XECMBT
iCPZSdgVQPE3CiEWYQjABX4ebQ2OFUADELAUSP8HwNbH3C0nRRVACBjiNw+k
B8CvbyyFIwEVQIf2Uk4hQQfAaWQDdVm3FED5BFCUyOQGwD3JNRNwchRAjCVq
oEGKBsCo2QYR2S4UQJkcw58FKAbAtt+ozXTlE0CZQ6jOXswFwHhq1UXuoBNA
FEHM8AJpBcDd93yrk1YTQIJufEI8DAXA0Bct2BMRE0AQrklaR7EEwFxx8DTd
zBJAGcRVZZ1OBMAiU5mYxYISQBUK7p+I8gPAHCC4b4Q9EkCMJsXNvo4DwKVu
AbJV8hFAI1W5wcYsA8CJjSgnX6gRQK2zOeVj0QLA/xiTozljEUBum6wczc8C
wBTOlnwFYhFALoMfVDbOAsBLrUtS0WARQLBSBcMIywLAeAzC82heEUCy8dCg
rcQCwIMSsQ6YWRFAti9oXPe3AsCG1BOj9U8RQL6rltOKngLApYSfOa48EUB+
kwkL9JwCwCpMZqV5OxFAP3t8Ql2bAsDFz6UNRToRQMBKYrEvmALAqseH09s3
EUDC6S2P1JECwJVzpDQJMxFAxifFSh6FAsBP0qVKYykRQIYPOIKHgwLAu7wc
fS4oEUBH96q58IECwF/17qv5JhFAyMaQKMN+AsC32J3+jyQRQMplXAZoeALA
Suzwd7wfEUCKTc890XYCwPfSDY2HHhFASzVCdTp1AsC3AHeeUh0RQMwEKOQM
cgLAuJ0mtugaEUCM7JobdnACwABBabyzGRFATdQNU99uAsBnk/C+fhgRQA68
gIpIbQLAyqy6vUkXEUDOo/PBsWsCwCukxbgUFhFAaGBhxQ==
          "]]}, 
        Annotation[#, "Charting`Private`Tag$76263#4"]& ]}}, {}}, {
    DisplayFunction -> Identity, 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
       None}, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     Ticks -> {Quiet[
        Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , Quiet[
        Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& }, 
     AxesOrigin -> {-6.907755278982137, 4.271563422263209}, 
     FrameTicks -> {{Quiet[
         Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , 
        Charting`ScaledFrameTicks[{Log, Exp}]}, {Quiet[
         Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , 
        Charting`ScaledFrameTicks[{Log, Exp}]}}, GridLines -> {None, None}, 
     DisplayFunction -> Identity, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None,
        "ClippingRange" -> {{{-6.9077552324652665`, -2.3025851395109163`}, {
        4.271563422263209, 
        11.160539331864747`}}, {{-6.9077552324652665`, -2.3025851395109163`}, \
{4.271563422263209, 11.160539331864747`}}}}, DisplayFunction -> Identity, 
     AspectRatio -> NCache[GoldenRatio^(-1), 0.6180339887498948], 
     Axes -> {True, True}, AxesLabel -> {
       FormBox[
        StyleBox["\"1-e\"", FontSize -> 24, StripOnInput -> False], 
        TraditionalForm], 
       FormBox[
        StyleBox[
        "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(0, s\\)]\\)\"", FontSize -> 24, 
         StripOnInput -> False], TraditionalForm]}, 
     AxesOrigin -> {-6.907755278982137, 4.271563422263209}, 
     CoordinatesToolOptions -> {"DisplayFunction" -> ({
         Exp[
          Part[#, 1]], 
         Exp[
          Part[#, 2]]}& ), "CopiedValueFunction" -> ({
         Exp[
          Part[#, 1]], 
         Exp[
          Part[#, 2]]}& )}, DisplayFunction :> Identity, 
     Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
       None}, PlotLabel -> FormBox[
       StyleBox[
       "\"Zoom of \\!\\(\\*SubscriptBox[\\(p\\), \\(0, s\\)]\\) coefficients \
for e near 1\"", FontSize -> 32, StripOnInput -> False], TraditionalForm], 
     PlotRange -> 
     NCache[{{-Log[1000], -Log[10]}, {4.271563422263209, 
        11.160539331864747`}}, {{-6.907755278982137, -2.302585092994046}, {
       4.271563422263209, 11.160539331864747`}}], PlotRangeClipping -> True, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(0, 0\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(0, 1\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(0, 2\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(0, 3\\)]\\)\""}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #4}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.37345400000000006`, 0.461046, 0.12992333333333334`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.560181`", ",", "0.691569`", ",", "0.194885`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.560181, 0.691569, 0.194885]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.560181, 0.691569, 0.194885], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.6150173333333333, 0.25708400000000003`, 
                    0.13945266666666667`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.922526`", ",", "0.385626`", ",", "0.209179`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.922526, 0.385626, 0.209179]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.922526, 0.385626, 0.209179], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.801248679404364*^9, {3.801248739703601*^9, 3.80124875188836*^9}, {
   3.801248786339608*^9, 3.801248874903563*^9}, 3.8012489425195436`*^9, {
   3.801249082042302*^9, 3.801249105819645*^9}, 3.801253197793944*^9, 
   3.801253924546926*^9, 3.801837746248804*^9},
 CellLabel->"Out[7]=",ExpressionUUID->"e8219c85-3289-484a-a178-e54c088dc904"]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"The", " ", "above", " ", "look", " ", "very", " ", "linear"}], 
   ",", " ", 
   RowBox[{
   "so", " ", "check", " ", "if", " ", "the", " ", "slope", " ", "appears", 
    " ", "to", " ", "be", " ", "constant", " ", "for", " ", "e", " ", 
    "approaching", " ", "1"}]}], "Text"]], "Input",
 CellChangeTimes->{{3.801252784385046*^9, 3.801252784624908*^9}, {
  3.801255167059971*^9, 3.801255168310883*^9}, {3.8018378219395123`*^9, 
  3.801837853341497*^9}, {3.801838165192511*^9, 3.801838170390254*^9}},
 EmphasizeSyntaxErrors->
  True,ExpressionUUID->"9e17e15d-468c-49cd-b422-3b58a8237c6c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Limit", "[", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"Log", "[", 
       RowBox[{"g", "[", 
        RowBox[{
         RowBox[{"1", "-", 
          RowBox[{"Exp", "[", 
           RowBox[{"-", "x"}], "]"}]}], ",", "0"}], "]"}], "]"}], ",", "x"}], 
     "]"}], ",", 
    RowBox[{"x", "\[Rule]", "Infinity"}]}], "]"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.801838171939908*^9, 3.8018381735890903`*^9}},
 CellLabel->"In[12]:=",ExpressionUUID->"ffdbfb07-c5f5-41ee-a1a7-13f8a5ce8eb2"],

Cell[BoxData[
 FractionBox["3", "2"]], "Output",
 CellChangeTimes->{3.801838295449553*^9},
 CellLabel->"Out[12]=",ExpressionUUID->"0bcd098b-faff-4967-a55b-3516b0d5274a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"e", ",", "0"}], "]"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "e"}], ")"}], "^", "1.5"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"e", ",", "1"}], "]"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "e"}], ")"}], "^", "1.5"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"e", ",", "2"}], "]"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "e"}], ")"}], "^", "1.5"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"e", ",", "3"}], "]"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "e"}], ")"}], "^", "1.5"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*SubscriptBox[\(p\), \(0, \
0\)]\)(1-e\!\(\*SuperscriptBox[\()\), \(3/2\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(0, \
1\)]\)(1-e\!\(\*SuperscriptBox[\()\), \(3/2\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(0, \
2\)]\)(1-e\!\(\*SuperscriptBox[\()\), \(3/2\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(0, \
3\)]\)(1-e\!\(\*SuperscriptBox[\()\), \(3/2\)]\)\>\""}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"Style", "[", 
     RowBox[{"\"\<Removing the divergence as e\[Rule]1\>\"", ",", 
      RowBox[{"FontSize", "\[Rule]", "32"}]}], "]"}]}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"\"\<e\>\"", ",", 
        RowBox[{"FontSize", "\[Rule]", "24"}]}], "]"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{
       "\"\<\!\(\*SubscriptBox[\(p\), \(0, s\)]\)(1-e\!\(\*SuperscriptBox[\()\
\), \(3/2\)]\)\>\"", ",", 
        RowBox[{"FontSize", "\[Rule]", "24"}]}], "]"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.801254374593122*^9, 3.8012544345369*^9}, {
  3.801254481338109*^9, 3.8012544995447397`*^9}, {3.801254755222713*^9, 
  3.8012548125976267`*^9}, {3.80125495813765*^9, 3.801255092333497*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"08fc819a-8ae0-4d8c-ad46-9e217ae72a81"],

Cell[BoxData[
 TemplateBox[{
  "NIntegrate", "ncvb", 
   "\"NIntegrate failed to converge to prescribed accuracy after \
\\!\\(\\*RowBox[{\\\"9\\\"}]\\) recursive bisections in \
\\!\\(\\*RowBox[{\\\"u\\\"}]\\) near \\!\\(\\*RowBox[{\\\"{\\\", \\\"u\\\", \
\\\"}\\\"}]\\) = \\!\\(\\*RowBox[{\\\"{\\\", \
\\\"6.28318519448951320385675257047976413268819406710008479421958327293`65.\
954589770191\\\", \\\"}\\\"}]\\). NIntegrate obtained \
\\!\\(\\*RowBox[{\\\"1.7669199436909366`*^-13\\\", \\\"-\\\", \
RowBox[{\\\"2.7755575615628914`*^-17\\\", \\\" \\\", \
\\\"\[ImaginaryI]\\\"}]}]\\) and \
\\!\\(\\*RowBox[{\\\"1.3678797854282469`*^-12\\\"}]\\) for the integral and \
error estimates.\"", 2, 8, 6, 33279117470031742122, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.8012550936849203`*^9, 3.801837814788067*^9},
 CellLabel->
  "During evaluation of \
In[8]:=",ExpressionUUID->"f80cb757-9c23-4347-9f6c-1b2f57f5be75"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{}, {}, 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwVxX041AccAHC/n+O4k7vz/iMZaSOsFmmt+H4rpaEXUmYkCctNy9uytooz
J+X12XNPiUioFUWFUiQPppLUoU45Lkc6rz/KSxS37Y/P8zEPOuwVQqqoqGz7
z/+7hSjEdYO7nT3q/Vw/mVPI2GQcIaMc4Jvtj9rVzCi0v5B1vpxygXD1R5Pc
xRS6P5XcyqW8Iauv+4OVAYU+wTP3/6KCwfnJeO8+FoXdK05uSqNi4A/m9h8H
3xthvv6OpNNUIqy0KSgMazRCgUb5V6coESznMBmGYUb4g+/FsvGJIgifC8mJ
LDZEtlLg77qkDHb2RwjUCENc5jmmaEipgCmLtsjoIAOMbV0LWZN3wXJ2usG7
Vh8NK3g9BPEAGFxWh4mtPt6Wb2p5tr4e1Melh2tEeljPzzXxHWmE3jwxq0td
D6e+dOJcP/QQ/E7YeVkl6yI5W8I1WdYM3LNO7pkMXXRUBt7eVdoCYsW0oSRd
B1sSHVqblj8D0cTWsBkzHTTLHJ69OvYc5s90Vx25xsPhGVnPi5Vt4PvS3fO9
Cw+LhqqbtdPboUn8McDsFRe1Tf+m+/s7IJxlKoiN5mJqWGVovuVLOEZmJ6w2
4uI0lvQfjJPAFb3ND55EcjBmVWOFQUMnFE/dig5r0kZZaWOK2Pw1LC3hvDui
q42f+B051r93QdbHqDEX/iK02cBcCK2WQpdBbeC4WAtdC8x/umnYA2knjrXF
rdLCWNN9Fr3+MtDZXJxQV8BG25HdbMm2N/D51B6XUGM26nLGNRrn3oDVYPVx
/xQWMh7klC093ws3urnZG1gs/Nmh+pWmuxzynZRW8gRNLPk+KL92Wg629uyY
/aQmTg0bcwfO9IFjRUvNlnQNrNzlqipy6YeMukVvXfU0MG6r8ELFQD+07frV
bvgSE8273ToLhW/hYbbFvb71TPxuTaKIWjUAuXlRZ3e2qqP/kmezRPsAGFKj
EfZ8dZxqTpNHCN7BHbcDX3SrqGMWIyDGy1IBJz8VuOy/qIa6PZUFZKMChL0l
xX5b1FDtuMB7beQgeF0LzAsbYKDK1YAyuc4QxO6x996fwcCo7LI0nfoh0DTm
y2/ZM/C+TbIG75dhmCDrckGqijy3KNsE7RHwZOiO96SqotTuefvRmhHo8jj0
3mStKt7IA8v+gFFgCh0dlSMk7i1z5JkujMIpHZs1LkUkxgsvCqTFY3DgiuRu
sA+J1xWmOdoeNMCGIWMBj8TkXGFgz3YaUmboOQ8uicFeo8tKPWnQv2s9b8Qh
cXFNzY1tPjS8M7U8eFOLxNMZfk2pQTQcll6Q9DFJPOh4boJ1lAahp47RjgUC
LRL1tjIv09BppTvnPEzgwrfHFkmu0BBaFGTAGSLw1Whf2+USGuRsZ2+ZgsBM
n/K9W27S4FaV6BA/QKByuVe0sIYGNlmb1NBLoFSckafaToMoMODQzk4Cq5Jm
DrS/oMEmhMy3kBAoWrfPurCTBv+Psg+TLwh0v/R1xcYeGuZbrJXn2gm899vT
x4JBGuLLSwrfthJ4xm51hucIDU5aabKqpwRGys97m9M0bDSOW5/aQqCVR7is
bpKGioV4X/tmAhlER1HmDA2uxUkU8zGBbyrX8QPnaHh5J3nu9UMCa/iFK1bO
05Cul/C5tInAs2bsKaWShhVhx83+/IfAfwEy7ThW
          "]]}, 
        Annotation[#, "Charting`Private`Tag$104263#1"]& ], 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAAm6kTEecZ8D7bKtnn4/ciPwRDGnDf
GTQ/vyuo34yrZz8zn5icsxlEP5GWJ/mPqHc/S83Xsp0ZVD8IpzHu5KKHP1dk
972SGWQ/5p6SzLqXlz/dL4dDjRl0P7ZSX7mOgac/oBVPhooZhD8JRr3KklW3
P4EIsyeJGZQ/Tpwy6OP+xj9YWaGv8PGkP1dl/5RzONc/C/+BXEcerz/uK2PI
HsHgPyVR7ujDi7Q/yaIrKqGB5T93zjk/mPS5PxGpFsNEWuo/F7QR3gEBvz88
tpEp2ZnuP7biQ8zPPMI/YMle/PV18T/Cap0bWezEP5zHPKQVcvM/9SY9D61t
xz+gQfDYgi71PwL5qxAbJco/Rb+nksbx9j82/2C2U67MPxs2l5Wfe/g/zIQ0
zsYqzz+sn1GBMeX5Px+Q6/mp7tA/GcvvxUNT+z/r99/e1TDSPyBEXmZNkfw/
pOq7yg6O0z9HabiGhtH9Pw4dp+/k5NQ/7KPPhSv0/j+MabVmoCTWP+exjXP1
7v8/6kCtiAsq1j9siU+NC/P/P0cYpap2L9Y/YxNgRiD3/z8Cx5TuTDrWPzH/
ZpdF//8/eSR0dvlP1j9Spe7dvwcAQGbfMoZSe9Y/+1tiItkXAEDEtiqovYDW
P60bTDjZGQBAIo4iyiiG1j8Ybc2f2BsAQN08Eg7/kNY/ZdcRZNUfAEBUmvGV
q6bWPza7/cTGJwBAsnHptxas1j8BLABrwSkAQA9J4dmBsdY/MZqPY7srAECM
2hJHl7LWP2M3eIAgLABAlyQfkQ==
          "]], 
         LineBox[CompressedData["
1:eJwV1nk4VV0XAHAclOEjU1KiQYMhVCoR66CQqWggpAwJZUhXEkVFo0qmRGRs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          "]], 
         LineBox[CompressedData["
1:eJwBwQI+/SFib1JlAgAAACsAAAACAAAA9rvZ25YG6T+iJbCxVIUDQCpoKQCs
B+k/8ibNsDKFA0CmlvDaYArpP7zH8HndhANAnfN+kMoP6T/DAsIqMoQDQIyt
m/udGuk/l5zVB9iCA0AFfYFUOXHpP3mEfmFfdwNAtPHs+b9z6T8f5iVLBXcD
QGRmWJ9Gduk/mMfa9Kp2A0DETy/qU3vpP47HkYj1dQNAhCLdf26F6T99XzWy
h3QDQATIOKujmek/1t1PFqBxA0ACE/ABDsLpPzxoNGGhawNAAKler+IS6j/T
ZDX0514DQHKar40Swuo/ApaLkAlAA0C9K4gIEW7rPy326rR5HQNAEUpyLIIO
7D+NVsMqjfkCQNwt0NN5vOw/qWyKJq/OAkCwnj8k5F7tPyY87RAMowJAXa82
ER3+7T/klsTX4XQCQICFoYHcqu4/egNnteU+AkCt6B2bDkzvPzcekPWFCAJA
iJ2FYN5O7z+iIsxEiQcCQGRS7SWuUe8/IGZHNIwGAkAcvLywTVfvP8g0a/GQ
BAJAio9bxoxi7z9gh13RlQACQGg2mfEKee8/yMq0fIz4AUAihBRIB6bvP5bb
64Um6AFA/jh8Ddeo7z8GnTcZHOcBQNnt49Kmq+8/fTgiKBHmAUCQV7NdRrHv
P9NPHbD54wFA/ypSc4W87z9ekUskxN8BQNzRj54D0+8/dvDq4TvXAUC4hvdj
09XvP23svM0n1gFAlDtfKaPY7z+TdCL6EtUBQEulLrRC3u8/IpHB9+bSAUC6
eM3JgenvPwV37oKEzgFAli01j1Hs7z8rOQZxac0BQHHinFQh7+8/naVJQU3M
AUAoTGzfwPTvP6WSyx8RygFABAHUpJD37z/o+WDj8MgBQOC1O2pg+u8/1YL0
5c7HAUC8aqMvMP3vP+h7/reqxgFAlx8L9f//7z9hSH0fg8UBQKoeS50=
          "]]}, 
        Annotation[#, "Charting`Private`Tag$104263#2"]& ], 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwV1nk8FV8UAHBvKIVsKaWyRaUkJVpUZ0SWSrJUlH0LCaFIlrJWIiJkSWRf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          "]], 
         LineBox[CompressedData["
1:eJwVz2tM02cUBvC+rwrlViJiXVDTYL1QmJTM4CWsnqMoIBQmlVDmJEjtNkJA
ZN6mKQpqCfGyskg0IpItFXUoFi3KgkyaTcogVECkanTVoOIU+r4SMSWg1L8f
Tp78cs6H54TrijTfU5FItEyYz+lKVdrfDbshMPi/Y9XpFI/+kfLg+ogb3izL
MuwX7DB6W5TcDY0VXYnBgjWrfzykGHODr9/QxhUbKWZbls+cP+WGL/rbIsvS
KN7cPC7pFTHYVeR8IRYs8WkJPDyNQa7ZQCtTKdq2qMSvxQyeXluRV6OmuMB/
nbdpFoO5t6seNyRTHNKnu9UKBkcK5BprAsXtYQWdhgwGLyWnhhNXU7S3L+1Q
ahl0VRaP3lJRlBXzO4PfMnBFhmUpBfd2/GRLymGgid2cGPo1xa9272sOzWfQ
GKeod66i6Okpr7tykMH6vce3qWIplhp/L3tSz8Ap8av6NYpi0F7f5NwGBt+c
Uy35EEmxOq8wZMjCwNKdHfWDYGvKKjNvYjD0vt64UiH0ndl3h7YxIExd4lxM
MaVWJFb0C//o1qg94RSlzTm/7J5kcMvU2901h6L5UnvmxEcGsx9LQ+SCY6qj
ZAdFHErKjbb9UoobSjyWihkc/C1GbcRsioZ4U9/ZYA4jEWq9IYTiYM/t0L/l
HDICJOd9gyg2/D//rETNYRHRn7xIKFacM251pXF4uyk30ymiqNe4F11NF+5T
RcnTBc9rbW1M1XJwLJG3ZU8RPGr6zn5cx0HbHf2PzyTBvOVnRv33ccjKrF0Y
M0ZwwZHQJN8Lwj7k2OKBlwSnVhqCHlzi0BPkjH71guAj9/N7Fy5zSLA+/HL8
OcFKrTU74RqHvELLpHSQoDdSs9PYyqHGx7Ez0UXwSZ+pdlo/Bynq44ucBP8s
92zrH+CQJv5ry/YBglVxOQrzQw4fDiT4FdwnmFIX3bTWxWFPhXxYd49gy8+O
zrLXHHQuVZjqLsFTS2NN6SMcjHXxc5QOgsWDNRnhnMPd0gkfWTfBCHXBU9sY
h8DSEwHjnQSnk/vnKz0cCpszfnv2L8FnN+Lyt05wsI1Zg+0dBFvzzcqYjxwe
jZaeuWgneFoW8N7r5bAjpkR2uJ3gJ7+5cuY=
          "]], 
         LineBox[{{0.025297705183108157`, 0.008710616972307636}, {
          0.025613575668885218`, 0.008925270269760633}, {
          0.025896196629843635`, 0.009119454650815238}, {
          0.026311815690076613`, 0.009408661978564527}, {
          0.026611061413444353`, 0.009619571791006764}, {0.02689368237440277, 
          0.009820821798060946}, {0.027433155914585162`, 
          0.010210511426677019`}, {0.02762517192041281, 
          0.010350965916783729`}, {0.02794104240618987, 
          0.010584013708439347`}, {0.02829016241678557, 
          0.010844479097235666`}, {0.028606032902562625`, 
          0.011082745612908802`}, {0.028971777675567644`, 
          0.011361722672492714`}, {0.029271023398935385`, 
          0.011592438965673699`}, {0.029570269122303122`, 
          0.011825368004905587`}, {0.02995263865771746, 
          0.01212621468414516}, {0.03026850914349452, 
          0.012377456691124436`}, {0.0306010043916809, 
          0.012644572871415682`}, {0.030883625352639322`, 
          0.012873756212615195`}}], 
         LineBox[{{0.019994405974535417`, 0.005484756047952635}, {
          0.020293651697903155`, 0.005647624775446542}, {
          0.020958642194275914`, 0.006017812667749903}, {0.02129113744246229, 
          0.006207169107240703}, {0.02162363269064867, 
          0.006399361357049003}, {0.02190625365160709, 0.00656495115090929}, {
          0.02215479384962642, 0.006712261177947754}, {0.022730841867109313`, 
          0.007059750066214388}, {0.022986863208212825`, 
          0.00721690486216696}, {0.023286108931580562`, 
          0.007402706488670868}, {0.023618604179766942`, 
          0.007611821697425336}, {0.023917849903134683`, 
          0.007802423969241733}, {0.024210445721538694`, 
          0.00799098463420687}}]}, 
        Annotation[#, "Charting`Private`Tag$104263#3"]& ], 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         LineBox[{{0.03926250560693607, 0.0011871013826560705`}, {
          0.03957837609271313, 0.0012153979719794678`}, {
          0.040908357085458646`, 0.0013393670593339904`}, {
          0.041187772301649654`, 0.0013664169230243287`}, {
          0.04156032592323765, 0.0014030340739870375`}, {0.04183974113942865, 
          0.0014309126392890845`}, {0.04221229476101664, 
          0.0014686422838175576`}, {0.04246066384207532, 
          0.001494152009821797}, {0.04283321746366331, 
          0.0015329551792451338`}, {0.04308158654472199, 
          0.0015591851288033643`}, {0.04337652482847916, 
          0.0015907107841030986`}}], 
         LineBox[CompressedData["
1:eJwVjWk8lIsChydpHZElKSpLttKiRMeV/1STKbnlikJEHEIpidZTnQrpyilF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          "]], 
         LineBox[CompressedData["
1:eJwV0ns8lFkfAPB5Hmnc7bh0cauRRKjdWl7F9ju6iNqu7HpTZGw2UoOUpET1
khWtKMtkFbksyWWwTYlBLrW6iJEN6S0M5nnOChWVet8zf5zP+Xw/53x+53c5
fP+QnQE0h8OJIku5G5+IDf357giEy7li10IOei39xS+emKpPbN1F7LZgHV9V
OgIZkcUm3X9wkH5/dS7dNAJFA7sfPLnBQarRpz1XhY1C8WSKzX4tCnGKfMte
6ykgqHLpeIU3hVrYbuFVQwVwxu79yOymUNLXO5btmacAwWOtvkU+FJorWXez
y1QBuUn8Dal7KbSs1erGfSsF6DclJO/bR6E9QxMFpWsUkPmX9fP+QxS6zT+X
HXVAAcveCUOsYyl0WFSWrNeogMQht7O6uRS6NSM619hE4sn3W2pep9CMb/zp
w60KGJx/eVQ1j0LnFvkc7XiogOXMjSfT+RTKKtHwSe1WgEjycK6siELNdQG2
elgBvo52sX4VFJo3YNzGm8eA4sa/p59IKeSzgdvcYMSA0ePwoLJ6CuUWTtSF
mTKw18NzKrmBQrYHH4ifmjNg+Q8V5HaPQi7vIkQX7Rj4s9Y7R9xCoQPcjiDe
OgbkS3K273lEoVqbBDWekAHf/+bSs3oo5CCb+yg1lIGByojHt4nLTxZeNAhn
wCLk81NhL3nvUYvRvEgGYnFPzLM+CiWEqNotOMPA8WN9R7JeUmhn5ZkddukM
eNj7VNFDFBpeHS1yr2Pg+2UBuo5jFPIb0NrbVs/Ae354mYy453zWoi33GNg4
pR4X+oZCD/tqSrbfZ2DiZkp7/jiFxKc+1nl1MCDVXD08+y2FTjYeGwiQM1BD
y2ddn6YQb9Nh2zM6LMTMv5S2lqLRtQZdzdU8Fr57+K6tnfjrVTdHx/VZ+Dvv
f/q+NI22Wo0UCOaz0L+ivuOoCo0SZ/vyXSxY2G4xrCZSpdGse+5zOKtZqOGm
bqxWp1Ha6uG3t5xZSG+4E/atBo3Mxf/pDAEW9rvsKxYToxxpysv1LHBqx11L
NGkUHWOvKd3GgusT2uaSNo3eO/E5pwJY4J9N/NWBR6O4yrp++0AWQn8KzSwg
NrDZU4sPsBAnri031KPRSqPfonxCWTj70Z07Thw6rfXO+QQLC5w378wyoNFo
1fTopxQW5PYWO5rn0ijSNv1+ZRoLCSlJ1pbzaKSWt7IwOJ2FE3lbdeKJLdOE
+3qvkPt9v8+snU8j/7DB/jsFLOjkXDlQYUSjPrv2zuN3WejFzdF+pjS6yvCi
VaQsZC5vKC8h9i/ysExuYEFv+0mdaeJRi+7Iay2kP/Wf3ZPMSH3G/aat7Sxc
sJFKixfQiKfB7jcYYiH3aadIyqeRrNWOlz3MQuDx0vAvxBlxIXeWKEi+CZER
zuY0MqMmtZzGWDgzVfChmth2+kOF4AOZZw/1LnsRjVzl3JlSbQwDJR5Vbotp
pJ7nnu/4FQazaR3LKOKHgvNbG/UwrJCM1hcTe7zQyemaiyFz64MwdUsa+ckM
XWf4GGTTDXV3iS1SvcbiLDD4L9aIHCYe3paZobsEQ12TmjdvCY2EbSaMuS2G
qsi3v/kTn2hclOLugEHVUO/jR+I1sQGrOh0xjPiIpsysaESvKXy9xwmDTY7Q
dC1xwu2l9qEIg+vG5ldxxOnl3/Skb8LgJSjfrGJNo13C8LMLt2A4qGqWuJDY
xLbatngbhpUawW+cia8XOsbUemKINjv4bThxeTZYDPpiMDaLz+ginoya5AoE
GMIcd+UzxA5ehcyLnzBE9Gq85iylUY2ubmV3IIZXIFNYEX9hGtM9gzHcXvD0
TydidD8i6ukhDBubIsRbiFti+13aDmMwmIhzDCFW80ld7HYUQ6qZrPEU8eZV
rurNxzAE/XDpZDLxBcOPrEsU6XedJOAKcfv4zfa6kxjGhStP/UGs/1hQ5RSD
4XTw++Yq4h+LDTMkpzE45E861xP3+kfvFcdjSLDfJ5ERm8E365b/Qqxdc/cF
sZ/xkGXJeQzBFvpvhoivT2VoWF/AsJ7ruxMTyzu//yc/hcS3Sx6YJLYq53SY
pxFPX7z+gTg4qar66mUMn8Q+qV+ISwMDM00yMAhSXpXRNjR6s94kOlOE4XCJ
zowq8Up+u9+c3zFkaDyLUCOO+Hx2fdpVDJ6XrRZqEEue/8vqq1wMRaZTU0p/
qmY0k/Mw/Oq94ovSa1KvjqkXYnAb+WuF0rFCj874IgzPNlZcVsa7t4l7S6UE
g0t/l+Vs4tlLakSxpRj031rJlfm4q4Sc+lyO4VqVqFOZb9JLc/+oSlK/nfGY
sp7HNc82TFWT/7JF5PiWmJeRaH1EguHoILdc2Q/PI2u0x++Q81yPH+TE6dsn
3hyqxVA655BVP/Fz2wKZQophV9k66y5iE3Vvyf5GDJGSFq824r1D2lmDTeS9
3UOVyvnkNjTECFoxqGRf+K6a+P8kv3OI
          "]], 
         LineBox[CompressedData["
1:eJwV0X0s1HEcwPHzLcV5PnmePMuPkq6yavH5tqx5imqWuuUhOw815GGKyiEP
1TX0pM5jkzGJrjq6Htjd6lBb6UTYiGUel/v+tmpE4/r2x2efvf76bO+PU9y5
Y/GIw+EwdP7vClu7hKZFDfQZpU77MwiPLPYFuSxr4OaaIetMHSX1NbNf08C0
1rdkzgPhF4I/xmoOgalKaWYvtfGG14aF6wi4DoYnNlIrT/npzesRkJVKYqOp
nbkB2nZzAjY8vkS1BeGLHbqriZYERkfVsmrqgdjeFVsbAlcdnw2mUxfJgxfz
NxOot+90s6OeER7VhDIErsvLdeLcEfY3Nf+h9SKw8FZ9cAf1/TeDc8+9CZh3
RIi1bggH8k5MWe+i9z/VulRStyiiR6f8CSxNxBcqXRFOtU3+cDmCwDtF6/CE
M8I93dt6t0cSeGS88/ADaod0VjV5kkBS7UNVFLW6N0MZGEPAb+T2y2EnhPlZ
OfJNZwm0z8xKFY4IL30uaWzNI5ARIJbFbEb4yKXAhpgrBMa03nwT6mZ3bj2v
mMD5ni5plz3CgtzSmmwxgUNDnU1W1J2ed+8EVNAeK0iksEM4v7i+YKyFwK0v
gppxa4SNLmwMPt1GIK3/V3IRdVVSCm9GSsDgTKiAoZaF7G1g2wlwJsLEaVa0
l1m/CikIcNnxPb8tEA6p4+gxAwS6XKvvqXn0v+UJ6ravBHSY9RZJ1MKCjxL+
CO3Xyj5eM0NYJJQw+78RYEpNnRnqp54+IeGzBETzGe6ZJghbymPKsv4SeJXy
88CoAcINzd3HV1YJ1N0YdhBS+1R5OeRxWMiZzDNd4CIclLskvabLwvcyocey
PsJDqVHZRnos7N6qDBNRP5G9t0nTZyHCtjpyH/U/NOUkPA==
          "]], 
         LineBox[CompressedData["
1:eJwB0QEu/iFib1JlAgAAABwAAAACAAAAIPe30olJ7z/K8nNrtvsBQK3oHZsO
TO8/P64tliH7AUCInYVg3k7vPx9pB0N6+gFAZFLtJa5R7z8RBFqv0fkBQBy8
vLBNV+8/ZoE+wXz4AUCKj1vGjGLvP4JMc6PD9QFAaDaZ8Qp57z8Gf2IDE/AB
QETrALfae+8/FwM+81bvAUAfoGh8qn7vP2cm5oeZ7gFA1gk4B0qE7z9oZZOW
Gu0BQEXd1hyJj+8/STzDBAzqAUAihBRIB6bvP5nvhpyp4wFA/jh8Ddeo7z8g
ZfuN1uIBQNnt49Kmq+8/7Ox/8QHiAUCQV7NdRrHvP6h0n/tT4AFA/ypSc4W8
7z8Sf36F5NwBQNzRj54D0+8/68E+V7HVAUC4hvdj09XvPyfWJVfC1AFAlDtf
KaPY7z8j/mRE0dMBQEulLrRC3u8/9f6cpOjRAUC6eM3JgenvP0p7NiT7zQFA
li01j1Hs7z9ppNc5+cwBQHHinFQh7+8/1dBoYfTLAUAoTGzfwPTvP5iEW/Dg
yQFABAHUpJD37z/9hVCn0cgBQOC1O2pg+u8/epEy7r3HAUC8aqMvMP3vP+hX
ULukxgFAlx8L9f//7z9sGn0fg8UBQLvG4oM=
          "]], 
         LineBox[{{0.031465492036965456`, 0.0006183174802796085}, {
          0.03159849013624004, 0.0006260646284779005}, {0.031897735859607784`,
           0.0006437277740920755}, {0.03219033167801179, 
          0.000661311226335526}}], 
         LineBox[{{0.05674188600294873, 0.003488540020098692}, {
          0.05691263974617659, 0.0035192052735454043`}, {0.05748233632585491, 
          0.0036227739655760698`}, {0.05770431619205106, 
          0.0036636556625008684`}, {0.05798373140824207, 
          0.003715537068346444}, {0.058263146624433076`, 
          0.0037678904560716903`}}], 
         LineBox[{{0.028672531952199903`, 0.0004698379006380292}, {
          0.028938528150749005`, 0.0004828407297432031}, {
          0.029237773874116746`, 0.0004977487992488853}, {0.02927434835141724,
           0.0004995913485272401}}], 
         LineBox[{{0.020077529786582015`, 0.0001634313410191181}, {
          0.020293651697903155`, 0.0001687109151098662}, {
          0.020626146946089535`, 0.0001770510524509422}, {
          0.020858893619819997`, 0.00018304805183488255`}}], 
         LineBox[{{0.05124361547101248, 0.002591298834373712}, {
          0.051603750638547524`, 0.0026448569957114414`}, {
          0.051774504381775374`, 0.0026704996250996797`}, {
          0.052069442665532546`, 0.002715169895729815}}], 
         LineBox[{{0.0333274654268092, 0.0007326314763865203}, {
          0.03359346162535831, 0.0007500104268836541}, {0.03384283306149811, 
          0.0007665463817425779}, {0.03423767116871942, 
          0.0007932135080716336}}], 
         LineBox[{{0.02162363269064867, 0.00020369239869084873`}, {
          0.02193950317642573, 0.00021264816612274172`}}], 
         LineBox[{{0.046186200057955346`, 0.0019120464162485692`}, {
          0.04640352300388169, 0.0019385197194047017`}}]}, 
        Annotation[#, "Charting`Private`Tag$104263#4"]& ]}}, {}}, {
    DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
     AxesOrigin -> {0, 0}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {
       FormBox[
        StyleBox["\"e\"", FontSize -> 24, StripOnInput -> False], 
        TraditionalForm], 
       FormBox[
        StyleBox[
        "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(0, \
s\\)]\\)(1-e\\!\\(\\*SuperscriptBox[\\()\\), \\(3/2\\)]\\)\"", FontSize -> 24,
          StripOnInput -> False], TraditionalForm]}, AxesOrigin -> {0, 0}, 
     DisplayFunction :> Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None,
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& )}}, PlotLabel -> FormBox[
       StyleBox[
       "\"Removing the divergence as e\[Rule]1\"", FontSize -> 32, 
        StripOnInput -> False], TraditionalForm], 
     PlotRange -> {{0, 1}, {0., 6.283185114837192}}, PlotRangeClipping -> 
     True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(0, \
0\\)]\\)(1-e\\!\\(\\*SuperscriptBox[\\()\\), \\(3/2\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(0, \
1\\)]\\)(1-e\\!\\(\\*SuperscriptBox[\\()\\), \\(3/2\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(0, \
2\\)]\\)(1-e\\!\\(\\*SuperscriptBox[\\()\\), \\(3/2\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(0, \
3\\)]\\)(1-e\\!\\(\\*SuperscriptBox[\\()\\), \\(3/2\\)]\\)\""}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #4}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.37345400000000006`, 0.461046, 0.12992333333333334`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.560181`", ",", "0.691569`", ",", "0.194885`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.560181, 0.691569, 0.194885]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.560181, 0.691569, 0.194885], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.6150173333333333, 0.25708400000000003`, 
                    0.13945266666666667`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.922526`", ",", "0.385626`", ",", "0.209179`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.922526, 0.385626, 0.209179]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.922526, 0.385626, 0.209179], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{3.801255104019154*^9, 3.801837824500662*^9},
 CellLabel->"Out[8]=",ExpressionUUID->"9ed34be6-c8ba-4099-bb6d-c6c22361c12b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"e", ",", "0"}], "]"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"e", "^", "2"}]}], ")"}], "^", "1.5"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"e", ",", "1"}], "]"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"e", "^", "2"}]}], ")"}], "^", "1.5"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"e", ",", "2"}], "]"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"e", "^", "2"}]}], ")"}], "^", "1.5"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"e", ",", "3"}], "]"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"e", "^", "2"}]}], ")"}], "^", "1.5"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*SubscriptBox[\(p\), \(0, 0\)]\)(1-\!\(\*SuperscriptBox[\(e\), \
\(2\)]\)\!\(\*SuperscriptBox[\()\), \(3/2\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(0, \
1\)]\)(1-\!\(\*SuperscriptBox[\(e\), \(2\)]\)\!\(\*SuperscriptBox[\()\), \
\(3/2\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(0, \
2\)]\)(1-\!\(\*SuperscriptBox[\(e\), \(2\)]\)\!\(\*SuperscriptBox[\()\), \
\(3/2\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(0, \
3\)]\)(1-\!\(\*SuperscriptBox[\(e\), \(2\)]\)\!\(\*SuperscriptBox[\()\), \
\(3/2\)]\)\>\""}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"Style", "[", 
     RowBox[{"\"\<Removing the divergence as e\[Rule]1\>\"", ",", 
      RowBox[{"FontSize", "\[Rule]", "32"}]}], "]"}]}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"\"\<e\>\"", ",", 
        RowBox[{"FontSize", "\[Rule]", "24"}]}], "]"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{
       "\"\<\!\(\*SubscriptBox[\(p\), \(0, s\)]\)(1-e\!\(\*SuperscriptBox[\()\
\), \(3/2\)]\)\>\"", ",", 
        RowBox[{"FontSize", "\[Rule]", "24"}]}], "]"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.801849783107911*^9, 3.801849796595339*^9}, {
  3.801849835015348*^9, 3.801849861779235*^9}},
 CellLabel->"In[17]:=",ExpressionUUID->"ae86124e-0989-4510-b85a-e8c25b7c67bf"],

Cell[BoxData[
 TemplateBox[{
  "NIntegrate", "ncvb", 
   "\"NIntegrate failed to converge to prescribed accuracy after \
\\!\\(\\*RowBox[{\\\"9\\\"}]\\) recursive bisections in \
\\!\\(\\*RowBox[{\\\"u\\\"}]\\) near \\!\\(\\*RowBox[{\\\"{\\\", \\\"u\\\", \
\\\"}\\\"}]\\) = \\!\\(\\*RowBox[{\\\"{\\\", \
\\\"6.28318519448951320385675257047976413268819406710008479421958327293`65.\
954589770191\\\", \\\"}\\\"}]\\). NIntegrate obtained \
\\!\\(\\*RowBox[{\\\"1.7669199436909366`*^-13\\\", \\\"-\\\", \
RowBox[{\\\"2.7755575615628914`*^-17\\\", \\\" \\\", \
\\\"\[ImaginaryI]\\\"}]}]\\) and \
\\!\\(\\*RowBox[{\\\"1.3678797854282469`*^-12\\\"}]\\) for the integral and \
error estimates.\"", 2, 17, 2, 33279163220748034681, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.801849801431422*^9, 3.801849864498519*^9},
 CellLabel->
  "During evaluation of \
In[17]:=",ExpressionUUID->"2d6ae9db-ba9b-4fe6-8bf2-77e0d0997f58"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{{{}, {}, 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.368417, 0.506779, 0.709798], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJxF03lQE3cUB/CAlEM0EECOAGIo1uFspUonUHwISAClHTkcnUGoWhBopQpY
h1QrINDKoe00RQaERgsUoRBsOYqgUMigct+ChgAhJIEkHFVwKEhaZh/rHzs7
n3mz+9u37/sYp78KjFCnUChn/r827v4Rsr7mmZADuxy9g1cZZh7cHZ+mZ5il
wqaTtf/cc92MAxbo3DG2V816Ieigj5+4w1tYLAKBA2Hn32maFtplUIzWVSWH
snbyIB0dUnqrI377H9CP3n10TtaaWQ02ToS79YyMnDzqoH0v4UvdTMh9VQ9f
Mwmz/i6mdrEbIcqHsEk1Taim1gTB3oRPhZWcLBU2k99fK/Lq7Pm4BazQjSUL
8RxOK+xEt8QUmJ9Q8MESLfA9t2OLYxuYo5fec9erOPeY9NrNV3qfP30CZmj1
lXJ9893tYIS2uJx+pi66A/TQLqrPaoMqO0Ebrdbi75mt6AIV9t+Zuq+7za4H
XqI9Z1KqND17YQpt9YN85d5cL/Si3+FHKJpu9sEDtPz1uHDog37gon0Xu4Lj
xvshCV0029BOvTEAp9Cj1/aOJTIHwQtNtfxtXiweBEd0gJdTeUvqENiis6Jr
Irk2w+CKPhhSVazRPwzfoJc9ysVRV5+Reaipr+sExgj8g05w5lcbt45A1PuE
y85770qIGwURzne8kp/Zx3gOzB8HAjeszOr86U3Xc7B0I+qrMYP5tuwXsORJ
2HBYeeQJXQBW7oTtD2qtRzYIYCvOv/4CxzkreoycP+su4+x9EyE57/HwZm+/
B0Jy3pcsw60nQ8fJfMjYabdZa+Nk3UERovssYIKsc99YZwQUTZDvM9Rb0Ob/
O0Get016SBB/eJKsazTl8969PUnm5a/Ecn7Oy0mgo7/Y1zCqc1gEpmjdJqq7
mCsCA3S532nuo2URbEX35h043u8zBZTNfMrp+pKcKXiN8xiyuq/zUDkFEnRN
EGsLx1tM7hv9k8ijRT+LoQ591Tftl2qJGHLQvQYyNweXaYhDM8b8R35Nm4ZD
aKeMs7XCF9NAQ7t+lMoxc5bAhD3hjjLbx9kpEmhGh+7sWVEbkEAnujTBKZZp
JwVnfH6pPVt0PlkKQdhPm/Ri+WS/FAowL7kaYQmBNjJQfUj42OL1TLsEGdRj
PgyFNXfV+TIwQWdV5K8W0GeggoX7ciU5mHlhBvQ399VwQY3a8taUe2E8kcEs
UNH1jO8K2TFvHZfHyzZomQUa2nTKvINmKodt6If232vTYuWggZa6XsnzeySH
ZeyP5h/nkEJVkPu77MagfBuhgEy0wLF3ILFRAVS0j0RrrXK7EnLxf1UVgo04
TAlsrGvuachLqlRCyH7CJ3kuNMt1JRjj+bH0L59eDp4j85OUdidZUDYH+9HG
deE3Lq7OwTF0hcwyn3pkHq7ZEbZONfLVKpkHa6zfstJdUqnmIXZJEbTh/wDQ
/5Yw
          "]]}, Annotation[#, "Charting`Private`Tag$2014963#1"]& ], 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.880722, 0.611041, 0.142051], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAAm6kTEecZ8D6UH8aJAPgiPwRDGnDf
GTQ/BQfLnlauZz8zn5icsxlEP8KjFNMirnc/S83Xsp0ZVD+tYxRaCK6HP1dk
972SGWQ/H2EC0fitlz/dL4dDjRl0P6cCONrnrac/oBVPhooZhD9qFPSVuq23
P4EIsyeJGZQ/jFdK0hCtxz9YWaGv8PGkP3dUPW7sqNg/C/+BXEcerz8hA0A+
B07iPyVR7ujDi7Q/d+qrE48l6D93zjk/mPS5P3jeHXzXde4/F7QR3gEBvz8c
+aNtnSnyP7biQ8zPPMI/EABQMIxS9T/Cap0bWezEP5jdCM1HZ/g/9SY9D61t
xz/TiXWeckH7PwL5qxAbJco/Tx6z0mdS/j82/2C2U67MP/6PPlERlABAzIQ0
zsYqzz9d6/9qKvQBQB+Q6/mp7tA/wKOPjshtA0Dr99/e1TDSP/jd1v+ryQRA
pOq7yg6O0z/JZKv6jD0GQA4dp+/k5NQ/TQGOa/6kB0CMabVmoCTWP6/GF0zf
7ghA6kCtiAsq1j9M4qSlavQIQEcYpap2L9Y/kvy1mPX5CEACx5TuTDrWP35C
CksKBQlAeSR0dvlP1j/UEQbeLhsJQGbfMoZSe9Y/1sWoqWRHCUDEtiqovYDW
PzUn8JDpTAlAIo4iyiiG1j+ktFQQblIJQN08Eg7/kNY/XOAb13VdCUBUmvGV
q6bWP2S9MIKAcwlAsnHptxas1j80tO8nAnkJQA9J4dmBsdY/WCEZZYN+CUCM
2hJHl7LWP8egkjGdfwlAJTcQbg==
          "]], 
         LineBox[CompressedData["
1:eJwBAQL+/SFib1JlAgAAAB8AAAACAAAA0KszMbRR2j+ftF6U1RQNQFLlBu49
Uto/k4x8DFoVDUBDJEdOn1faPwYKBX2GGg1AJKLHDmJi2j892Uv93SQNQOad
yI/nd9o/WxtzeIc5DUDtjMyT/c3aP9qxCmrjiw1A+2rUmyl62z/HA8EQNC8O
QCtBB/5mu9w/OpoEP8xaD0BHoiFnsRfeP+lZmKXrSxBAdx1fIuFc3z+BCIW2
I9wQQCzsVQvXTeA/OJAq3tplEUATD/AIxPrgPx/WdnUD9xFABL+bryOc4T+l
9dCNX3oSQGs0u9kJS+I/bAI5RyQEE0CrSWKgvvbiP7ZZa/+chhNA9esaEOaW
4z96fJy77fsTQLVTRwOUROQ/nWTwOkN2FEB/SIWftObkP8BADe7E4xRAId1K
2KOF5T8499Q+okoVQDo3hJQZMuY/1R/Q8CG1FUBcHs/5AdPmP9JcgkibExZA
9cqN4nCB5z86DzddmHQWQJgEXnRSJOg/b45uDfvJFkD+Yxc10SboP8V0ddU/
yxZAZMPQ9U8p6D/oelRPhMwWQDCCQ3dNLug/7aOIWAzPFkDI/yh6SDjoP/Gh
ScAY1BZA9/rzfz5M6D8tvjDhIt4WQFbxiYsqdOg/6OuvSPzxFkC8UENMqXbo
Pwj45UI38xZAq7uWvMh36D84PZzmxPMWQKUQ6JQ=
          "]], 
         LineBox[CompressedData["
1:eJwVzn801Xccx/Eb+TG/bn51v19LF/0YlVKWOOL9EalddwszTk352bpJmms1
GpV05fe1k27DdCxjubpRxESYKYUOZhOF7HLk4n4/uGTjYJ/98Tqv8/jvaRl6
zvekGovF8iL7/9/X9b+RaCrAa645Z4sjB20T2LDuaSnAnb75VQlxiWT6dbCO
AkodonePO3FQgepSdhtbAZkP0mUR+zkoQ5a/VGCmgD77EtczbhykkZDo5xSt
gBs+Oe35Ag5ilZ4olxtNwKjioKhNxkHCvPJMo+YJiM1679Y/y0FPtqdoG0ZN
QnfHA8i2o5AhT7jjqsEUaFSqCn4Ip9CAbVdPXP0UGM6jjl4JhSpuw+bRE0pI
utYobG2kkOqiSiskRAmGE+tcApso5BDwy+RgmBIEp7zLponr2OzKVwIlxFgE
xFDNFHp2ZcitXagEU/ey8rAWCr0JTQh6mKyEcW/PtvHnFNL8qC7vyn0lXD2y
T0vWTaHj5Q6G5itKeJ/gaUnLKVR97B+DLhYDGt6hk4XEBpqP9ZLUGdDNeXXA
eoRCTYEu2gptBvz83XL3jlLISsdjtcqYgUW+1TBvjEJj4T5Kvg0DKgfBo6AJ
CkWZRb6I92NgNNI8bPcs6Xtq27orgIFQ34cZUmJuNG6RH2VAZ/lr100qCnW1
CpsOBzHA8y12Mp6j0J7zcTUmEQxcXwxMVc5TaKEzufjeZQaO1kqC0v+l0BXR
T4kDUgaqJ4yPRLBopP+tFi9ExoCn/m9qL4nzBGeNxsoZ6ExLP7RrDY0qvZyK
cBUD72KTk2aJxwy7W9QaGag9faghRp1GXrdZ2jY9DJxKrNAI0aTR+pqgrPNL
DHhkBg+O6tKo6O5T/8VlBhIeSmyd9Ghkl7ede5mFwY5/ViOT+JOEhfIUDQwj
/As8e30axbuLu/PZGOyrZzZeNKCRvLPBpHkTBrnY+8b0OhrJxs3zDfgYykSl
7gmmNEopEAUPfYZBmhcufkEc7qvcct8Hg943IjvT9TTaUF9f8WkAhvxnc1FS
4jTxl88yQjFYXBhs6ODQSOCQO6MTh0GWtu8OpmnkMcmqef0dhjaXnXV2ZjTi
FgripZcwOAq+N40m7v3AUYt3DUNvMScFEx8c7N2QKsbwpJptP/IhjayumRzW
KsHgt+5Yf5E5jVYc4/Vf3cWg3n6E20fcrxz5o6QMQ5Z/aJLuRhplB1Qe93yA
YeuQZu454tVtvjGiegy1wcM3d3Bp9PptreMXjRgGauD0UeLqHMuVzc0YCi/e
cBYRR61Mp7S0YriayXveTzzQLb6t3oNBXyrsO29Bo1+TF8J6/sKwn124lEuc
4xxkU9SHQdtJ+109sVfxzqoDQxgCkqemVoi3HpPEGf2NgWOdic0taaTGXnGV
j2B4+vtQqjPx49iXLxIVGO6cy0NCYontXrHPFAajmKo96cTR8h/9LDGGMx93
nbxDzL+11mxmBoNpl0tNDbE1P/Jt0xyGknBqsY147Zo/f85ewLA5VW/mDfHw
I+eI4EUM7SEqNEFcH1G0y24ZQ4u0wGue+BZXd351lfS3Tn2+RPwfeYYq8g==

          "]]}, Annotation[#, "Charting`Private`Tag$2014963#2"]& ], 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.560181, 0.691569, 0.194885], 
          AbsoluteThickness[1.6]], 
         LineBox[CompressedData["
1:eJwV0nk0lfsXBnBDJDKmvMctOiJJSZo0Pt+UFCqhVIRQyY0GdStDUkhXohLJ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          "]], 
         LineBox[{{0.025297705183108157`, 0.009043236633865373}, {
          0.025613575668885218`, 0.009270368914503979}, {
          0.025896196629843635`, 0.009475976993004417}, {
          0.026311815690076613`, 0.009782432488288698}, {
          0.026611061413444353`, 0.01000609562866013}, {0.02689368237440277, 
          0.010219650735947428`}, {0.027433155914585162`, 
          0.010633539790678336`}, {0.02762517192041281, 
          0.01078283548969748}, {0.02794104240618987, 
          0.011030690601265146`}, {0.02829016241678557, 
          0.011307906723368904`}, {0.028606032902562625`, 
          0.01156168054879836}, {0.028971777675567644`, 
          0.011859035776498671`}, {0.029271023398935385`, 
          0.012105129439394607`}, {0.029570269122303122`, 
          0.012353745617091244`}, {0.02995263865771746, 
          0.012675092418987066`}, {0.03026850914349452, 
          0.012943658723855667`}, {0.0306010043916809, 0.01322939566991591}, {
          0.030883625352639322`, 0.013474719790000702`}}], 
         LineBox[{{0.019994405974535417`, 0.0056500722401015765`}, {
          0.020293651697903155`, 0.005820410445672536}, {
          0.020958642194275914`, 0.006207988285494328}, {0.02129113744246229, 
          0.006406457098744594}, {0.02162363269064867, 
          0.006608045588325389}, {0.02190625365160709, 
          0.006781848505787918}, {0.02215479384962642, 
          0.006936555276954789}, {0.022730841867109313`, 
          0.007301823912687297}, {0.022986863208212825`, 
          0.0074671704560792555`}, {0.023286108931580562`, 
          0.007662776315929814}, {0.023618604179766942`, 
          0.00788307870249341}, {0.023917849903134683`, 
          0.008084016970005594}, {0.024210445721538694`, 
          0.008282932015405952}}]}, 
        Annotation[#, "Charting`Private`Tag$2014963#3"]& ], 
       TagBox[{
         Directive[
          Opacity[1.], 
          RGBColor[0.922526, 0.385626, 0.209179], 
          AbsoluteThickness[1.6]], 
         LineBox[{{0.03926250560693607, 0.0012576960575030106`}, {
          0.03957837609271313, 0.0012882624946859399`}, {
          0.040908357085458646`, 0.0014223889069484765`}, {
          0.041187772301649654`, 0.001451699812634961}, {0.04156032592323765, 
          0.0014914024824529664`}, {0.04183974113942865, 
          0.0015216490503359966`}, {0.04221229476101664, 
          0.0015626089810598048`}, {0.04246066384207532, 
          0.0015903191837514877`}, {0.04283321746366331, 
          0.0016324945556662781`}, {0.04308158654472199, 
          0.0016610209199292253`}, {0.04337652482847916, 
          0.001695324417559616}}], 
         LineBox[CompressedData["
1:eJwVxXk8lAkDB/Ch2pSjTHTpcETZlLKifMrvYa2rUkkHKzcjNUqhtrsYEcVb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          "]], 
         LineBox[CompressedData["
1:eJwBoQJe/SFib1JlAgAAACkAAAACAAAAG3uAcGa86D/1CVWAaKgTQOK/iWCG
vOg/elWPoI+oE0BIH0MhBb/oP8UF9N6dqxNAE961ogLE6D9psN/JuLETQAV9
gVQ5cek/Kcnk7EiAFEAAqV6v4hLqP4sPtbLFNhVAcpqvjRLC6j94d7GZ1O8V
QL0riAgRbus/7deN1TuXFkARSnIsgg7sP02b+htoJRdA3C3Q03m87D+yUt/o
Ba8XQLCePyTkXu0/ibBbGdAeGEDzevMHYWHtP5HTEOBkIBhANlen691j7T+f
WGyd+CEYQLsPD7PXaO0/m4gF+xwlGEDGgN5By3LtP2XfQzpZKxhA22J9X7KG
7T9Wt7CMnzcYQAYnu5qAru0/XSXOmGFPGEBdrzYRHf7tPwNyZYKrexhAtlr4
DtAA7j+fTsJFGH0YQA4GugyDA+4/i5sxu4N+GEDAXD0I6QjuP5CnqLpWgRhA
IgpE/7QT7j/4WIQA7YYYQOZkUe1MKe4/xUqOStqRGEBuGmzJfFTuP2Ojs8y0
phhAxsUtxy9X7j9E4oL+9qcYQB9x78TiWe4/rDpC1DepGEDQx3LASF/uP+SH
mWm1qxhAMnV5txRq7j/x3K0toLAYQPfPhqWsf+4/c+sTqDO6GECAhaGB3Kru
P38RbYtOzBhADXcHSmGt7j8DjvWrUc0YQJpobRLmr+4/7pu8jVPOGECzSzmj
77TuPxvp3JJT0BhA5hHRxAK/7j8/a+2TRNQYQEueAAgp0+4/F4sT8OnbGEAW
t1+OdfvuPz5D+6A96hhAo6jFVvr97j8fH/a6F+sYQDCaKx9/AO8/CVIrgfDr
GEBJffeviAXvP+Mc+Q6e7RhA1m5deA0I7z+qYuPUcu4YQK6zyBlwCe8/LtAi
SefuGEDaqjk1
          "]], 
         LineBox[CompressedData["
1:eJwVz2tI02EYxuF5KC1LwwR7619zQ6Ncqz5YLASfl3BRm0Wuhpa4zAqXjiIS
yyZGMYcrYYPEJVOrLSUqp3Za2SCJDg6SSs1UzJnLTJo8jspZza23Dzc/ro+3
oPCk4lg4j8cTsv1vkt/Ra9iFsHB5hkwcTmjrt9WW2CyEsCL3mRHm6saqgtE9
CFNjHfKmCEKPKqZT7NkIN0q+yFWRhHJOZ/vuHIS0yp7uwQWEXjLmvaopRJjI
C5Q6oglVb633LS5H6BtQ5pNYQjO/8xzDWgRRo+Sdk5l/XV1xuxIhcL4kUxVH
6MAiSZRMh9BZZBZalhEq/TTAGYwIjVyqPBBPqFCXsDOqBcEdq1HnJhIalFQs
/XgL4eLlFN8Q89C0p7flDsLvTov4wApCTTn383d0IDR8TW3eSwgNpSpOVzkR
QFRhF64idNj9RKJ8hvDWMDFrYn5UKwgmP0dInNvWGmA+EZypfvEa4dpdc9ob
jtCR98amiD6ENuX8BtkaQh/r/Uf6PiCoOG2Rlbk2/dB62yDC7EzCFT+zvHnj
g+2jCDXdrvyrfELXHqwrj/+McO9c/UsPc3hcMGPcg6DpUtpFSYR2nu1xXZhi
f+xPD7cz14m3GLO9CEukOpeX+dR4w34BIkQnaieTBYRmmSNX+nwIc9bQ8Vzm
dVkad9dPhNIyblLPHBnWf9PkR1ArbD1tzGMP04sL/iD8cHDSXmZnsW3T5nmE
soC138ts5sf8CoUQYvTefX+Z/wE2/QF8
          "]], 
         LineBox[{{0.031465492036965456`, 0.0006477293542431303}, {
          0.03159849013624004, 0.000655971867598958}, {0.031897735859607784`, 
          0.0006747722855296675}, {0.03219033167801179, 
          0.0006934985789542483}}], 
         LineBox[{{0.05674188600294873, 0.0037896324655683346`}, {
          0.05691263974617659, 0.003823871040480145}, {0.05748233632585491, 
          0.003939589042999984}, {0.05770431619205106, 
          0.003985300407374018}, {0.05798373140824207, 
          0.004043338330173596}, {0.058263146624433076`, 
          0.004101935022637608}}], 
         LineBox[{{0.028672531952199903`, 0.0004901892267459013}, {
          0.028938528150749005`, 0.0005039506873270468}, {
          0.029237773874116746`, 0.0005197371925975542}, {0.02927434835141724,
           0.0005216889442292457}}], 
         LineBox[{{0.020077529786582015`, 0.00016837791052325195`}, {
          0.020293651697903155`, 0.00017387252369768073`}, {
          0.020626146946089535`, 0.00018255702421652787`}, {
          0.020858893619819997`, 0.00018880508469808717`}}], 
         LineBox[{{0.05124361547101248, 0.0027930104235557233`}, {
          0.051603750638547524`, 0.0028522026877382894`}, {
          0.051774504381775374`, 0.002880557043279655}, {
          0.052069442665532546`, 0.0029299730104529616`}}], 
         LineBox[{{0.0333274654268092, 0.0007695600831625066}, {
          0.03359346162535831, 0.0007881192423936031}, {0.03384283306149811, 
          0.0008057869325628355}, {0.03423767116871942, 
          0.0008342969006144389}}], 
         LineBox[{{0.02162363269064867, 0.00021033484147005204`}, {
          0.02193950317642573, 0.00021968450325513832`}}], 
         LineBox[{{0.046186200057955346`, 0.002046029595763855}, {
          0.04640352300388169, 0.002075004356781772}}]}, 
        Annotation[#, "Charting`Private`Tag$2014963#4"]& ]}}, {}}, {
    DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
     AxesOrigin -> {0, 0}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {
       FormBox[
        StyleBox["\"e\"", FontSize -> 24, StripOnInput -> False], 
        TraditionalForm], 
       FormBox[
        StyleBox[
        "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(0, \
s\\)]\\)(1-e\\!\\(\\*SuperscriptBox[\\()\\), \\(3/2\\)]\\)\"", FontSize -> 24,
          StripOnInput -> False], TraditionalForm]}, AxesOrigin -> {0, 0}, 
     DisplayFunction :> Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> None,
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& )}}, PlotLabel -> FormBox[
       StyleBox[
       "\"Removing the divergence as e\[Rule]1\"", FontSize -> 32, 
        StripOnInput -> False], TraditionalForm], 
     PlotRange -> {{0, 1}, {0., 6.28318530718563}}, PlotRangeClipping -> True,
      PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
      "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(0, \
0\\)]\\)(1-\\!\\(\\*SuperscriptBox[\\(e\\), \
\\(2\\)]\\)\\!\\(\\*SuperscriptBox[\\()\\), \\(3/2\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(0, \
1\\)]\\)(1-\\!\\(\\*SuperscriptBox[\\(e\\), \
\\(2\\)]\\)\\!\\(\\*SuperscriptBox[\\()\\), \\(3/2\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(0, \
2\\)]\\)(1-\\!\\(\\*SuperscriptBox[\\(e\\), \
\\(2\\)]\\)\\!\\(\\*SuperscriptBox[\\()\\), \\(3/2\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(0, \
3\\)]\\)(1-\\!\\(\\*SuperscriptBox[\\(e\\), \
\\(2\\)]\\)\\!\\(\\*SuperscriptBox[\\()\\), \\(3/2\\)]\\)\""}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #4}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.368417`", ",", "0.506779`", ",", "0.709798`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.880722`", ",", "0.611041`", ",", "0.142051`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.37345400000000006`, 0.461046, 0.12992333333333334`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.560181`", ",", "0.691569`", ",", "0.194885`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.560181, 0.691569, 0.194885]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.560181, 0.691569, 0.194885], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> 
                    RGBColor[
                    0.6150173333333333, 0.25708400000000003`, 
                    0.13945266666666667`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0.922526`", ",", "0.385626`", ",", "0.209179`"}],
                     "]"}], NumberMarks -> False]], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.922526, 0.385626, 0.209179]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.922526, 0.385626, 0.209179], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{3.801849809888603*^9, 3.801849878476413*^9},
 CellLabel->"Out[17]=",ExpressionUUID->"9fb53cda-91ec-4499-9e78-5aa5570c06ef"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"e", ",", "100"}], "]"}], "*", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"e", "^", "2"}]}], ")"}], "^", "1.5"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"Style", "[", 
     RowBox[{
     "\"\<\!\(\*SubscriptBox[\(p\), \(0, \
100\)]\)(1-\!\(\*SuperscriptBox[\(e\), \(2\)]\)\!\(\*SuperscriptBox[\()\), \
\(3/2\)]\)\>\"", ",", 
      RowBox[{"FontSize", "\[Rule]", "32"}]}], "]"}]}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"\"\<e\>\"", ",", 
        RowBox[{"FontSize", "\[Rule]", "24"}]}], "]"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{
       "\"\<\!\(\*SubscriptBox[\(p\), \(0, \
100\)]\)(1-\!\(\*SuperscriptBox[\(e\), \(2\)]\)\!\(\*SuperscriptBox[\()\), \
\(3/2\)]\)\>\"", ",", 
        RowBox[{"FontSize", "\[Rule]", "24"}]}], "]"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.801851471766518*^9, 3.801851500561705*^9}, {
   3.801851553654378*^9, 3.8018516088111963`*^9}, 3.8018516752639027`*^9, {
   3.8018518069899063`*^9, 3.801851808278778*^9}, {3.801851920506735*^9, 
   3.801851923168681*^9}, {3.801851967235634*^9, 3.801851993009708*^9}, {
   3.801852058869484*^9, 3.8018520611450987`*^9}},
 CellLabel->"In[25]:=",ExpressionUUID->"58dc1d30-a8bb-489e-95c5-7dc8845fe7e2"],

Cell[BoxData[
 TemplateBox[{
  "NIntegrate", "slwcon", 
   "\"Numerical integration converging too slowly; suspect one of the \
following: singularity, value of the integration is 0, highly oscillatory \
integrand, or WorkingPrecision too small.\"", 2, 25, 16, 33279163220748034681,
    "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.801851501378216*^9, 3.8018516447157516`*^9, 3.801851675929305*^9, 
   3.801851810228915*^9, 3.8018519253351183`*^9, {3.80185196924897*^9, 
   3.801851994026156*^9}, 3.8018520621764393`*^9},
 CellLabel->
  "During evaluation of \
In[25]:=",ExpressionUUID->"acd712c9-9142-44cc-8523-db46a07dbfb8"],

Cell[BoxData[
 TemplateBox[{
  "NIntegrate", "ncvb", 
   "\"NIntegrate failed to converge to prescribed accuracy after \
\\!\\(\\*RowBox[{\\\"9\\\"}]\\) recursive bisections in \
\\!\\(\\*RowBox[{\\\"u\\\"}]\\) near \\!\\(\\*RowBox[{\\\"{\\\", \\\"u\\\", \
\\\"}\\\"}]\\) = \\!\\(\\*RowBox[{\\\"{\\\", \
\\\"6.28318530013645666773726079921922200435466243639837102819001302123`65.\
954589770191\\\", \\\"}\\\"}]\\). NIntegrate obtained \
\\!\\(\\*RowBox[{RowBox[{\\\"-\\\", \\\"6.331740687315346`*^-16\\\"}], \
\\\"-\\\", RowBox[{\\\"2.237793284010081`*^-16\\\", \\\" \\\", \\\"\
\[ImaginaryI]\\\"}]}]\\) and \
\\!\\(\\*RowBox[{\\\"8.414550254184856`*^-14\\\"}]\\) for the integral and \
error estimates.\"", 2, 25, 17, 33279163220748034681, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.801851501378216*^9, 3.8018516447157516`*^9, 3.801851675929305*^9, 
   3.801851810228915*^9, 3.8018519253351183`*^9, {3.80185196924897*^9, 
   3.801851994026156*^9}, 3.801852062260187*^9},
 CellLabel->
  "During evaluation of \
In[25]:=",ExpressionUUID->"338ca20b-a19b-42d4-9c36-a4a3a9acb3c1"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwB0QEu/iFib1JlAgAAABwAAAACAAAA2NntOGsr6z/dDGF8auMKwEH1dpqR
Les/OkpOJqnDCsBqB9JpEUPrP699AsBGiAnAvSuICBFu6z+RSEVaXx0HwBFK
ciyCDuw/XDDC0ylL/b/cLdDTebzsP3VjgVyL6+m/n+sRfQO/7D+AnMAK0nnp
v2KpUyaNwew/ZteS21YI6b/pJNd4oMbsPzjm5SIbJui/9hveHcfQ7D9Oin//
j2TmvxEK7GcU5ew/Yf+c/jjt4r9G5gf8rg3tPyeBsAP8W9i/CaRJpTgQ7T+u
lejqUYjXv8xhi07CEu0/WlKPXCi11r9T3Q6h1RftP0Jv03ZXENW/YNQVRvwh
7T8otXW6wszRvySSV++FJO0/RNO4JiH90L/nT5mYDyftPwjsGlMBLtC/qg3b
QZkp7T+F+ODOxr7Ov4sbc28CLO0/A3eTSyU3zb/x2NMK9C7tP66DfFQwWsu/
uqbzNHcx7T95Q00AN8TJv7gE4ua/M+0/1U2n2wNUyL+YEnoUKTbtPynb1c1B
0Ma/ITAPtfM47T/owuFAbRDFvwI+p+JcO+0/6vz6N6mOw7/iSz8Qxj3tPypm
AvrRDcK/po24GU5A7T/hFwHuu3rAvyFg6Zo=
       "]], LineBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAAN+6SmITq6j/SraE8gbQOwMW+ZSwS
7eo/D5LiBGWNDsAKIVEmwu/qP/ECRRJJZA7AUIM8IHLy6j+FrXO/PDsOwJXl
Jxoi9eo/0A21DUASDsD//FxGOfjqP9fVf8gw4w3AH6r+DYL66j9ZaZmSdcAN
wBueAm5U/eo/L2AQ652VDcCpbtUB4v/qP4syZKvpbg3A7tDA+5EC6z8YWJEy
O0YNwDMzrPVBBes/P6G5YpwdDcB4lZfv8QfrPwt6OT0N9QzAvveC6aEK6z+R
hHDDjcwMwN+g0HvbDes/AoFQfAmcDMBIvFndARDrP5uqkti9ewzARbBdPdQS
6z9pDTvOaVEMwNOAMNFhFes/aFNdrSwrDMBhUQNl7xfrPwiicLf9BAzAy2g4
kQYb6z+XzwfV19YLwKKn8r5xHes/th3/rMiyC8AweMVS/x/rP9X+xnzGjAvA
LNNilK0i6z94tkwP7WQLwKRrry0=
       "]], LineBox[CompressedData["
1:eJwB0QEu/iFib1JlAgAAABwAAAACAAAARciXtQ6t7z+3Vuhttav8P7SiS5h2
ru8/NTzMwySx/D+QV7NdRrHvPwmmEY3Mu/w/bAwbIxa07z+fQJ7bKsb8P0jB
gujltu8/LP/8UD/Q/D//KlJzhbzvPwU0kSaJ4/w/2t+5OFW/7z+Jgrm4vez8
P7aUIf4kwu8/unOB1Kb1/D9u/vCIxMfvP48tHNeUBv0/SrNYTpTK7z849ZPE
mA79PyVowBNkze8/57WmRk8W/T8AHSjZM9DvP9Crjsq3Hf0/hqhVfo/U7z8G
7e3Jlyj9P7iG92PT1e8/BuWPTpwr/T+UO18po9jvP2Ox/+IWMv0/cPDG7nLb
7z8cVPWaQDj9P0ulLrRC3u8/9zIPiBg+/T8mWpZ5EuHvP66zt5qdQ/0/Ag/+
PuLj7z8wnBGZzkj9P7p4zcmB6e8/InLITS5S/T+WLTWPUezvP9gwhS9ZVv0/
ceKcVCHv7z+kn1gSKFr9P0yXBBrx8e8/6NO1h5dd/T8oTGzfwPTvP9c8teqi
YP0/BAHUpJD37z9jXQyRQ2P9P+C1O2pg+u8/GcNnBG9l/T+8aqMvMP3vP/9w
2/gRZ/0/lx8L9f//7z/xMwvI8Wf9Pw2+9Fg=
       "]], 
      LineBox[{{0.8378635560632468, -4.039764429407757}, {
       0.8381588034383205, -4.021405725723634}, {
       0.8384868560772912, -4.001035383362778}, {
       0.8388477139801591, -3.97866232291423}, {
       0.8391429613552327, -3.96038383925452}, {
       0.8394710139942034, -3.940102654837087}, {
       0.8397990666331742, -3.9198512072087026`}, {
       0.8400943140082477, -3.901650336637819}}], 
      LineBox[{{0.9163774176343282, -0.03903928524632224}, {
       0.9167491567315694, -0.024560338366639664`}, {
       0.9169040480220871, -0.018540913360684072`}, {
       0.9169814936673465, -0.015534174629739491`}}]},
     Annotation[#, "Charting`Private`Tag$2174831#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     StyleBox["\"e\"", FontSize -> 24, StripOnInput -> False], 
     TraditionalForm], 
    FormBox[
     StyleBox[
     "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(0, \
100\\)]\\)(1-\\!\\(\\*SuperscriptBox[\\(e\\), \
\\(2\\)]\\)\\!\\(\\*SuperscriptBox[\\()\\), \\(3/2\\)]\\)\"", FontSize -> 24, 
      StripOnInput -> False], TraditionalForm]},
  AxesOrigin->{0, -4.039764429407757},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Part[#, 1], 
      Exp[
       Part[#, 2]]}& ), "CopiedValueFunction" -> ({
      Part[#, 1], 
      Exp[
       Part[#, 2]]}& )},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Quiet[
      Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& , 
     Charting`ScaledFrameTicks[{Log, Exp}]}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->{944.69140625, Automatic},
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None},
  PlotLabel->FormBox[
    StyleBox[
    "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(0, \
100\\)]\\)(1-\\!\\(\\*SuperscriptBox[\\(e\\), \
\\(2\\)]\\)\\!\\(\\*SuperscriptBox[\\()\\), \\(3/2\\)]\\)\"", FontSize -> 32, 
     StripOnInput -> False], TraditionalForm],
  PlotRange->{{0, 1}, {-4.039764429407757, 1.8378770651063372`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->FrontEndValueCache[{Automatic, Quiet[
      Charting`ScaledTicks[{Log, Exp}][#, #2, {6, 6}]]& }, {
    Automatic, {{-2.995732273553991, 
       FormBox[
        TagBox[
         InterpretationBox["\"0.05\"", 0.05, AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 2}]& ], TraditionalForm], {0.01, 
       0.}}, {-2.3025850929940455`, 
       FormBox[
        TagBox[
         InterpretationBox["\"0.10\"", 0.1, AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 2}]& ], TraditionalForm], {0.01, 
       0.}}, {-0.6931471805599453, 
       FormBox[
        TagBox[
         InterpretationBox["\"0.50\"", 0.5, AutoDelete -> True], 
         NumberForm[#, {
           DirectedInfinity[1], 2}]& ], TraditionalForm], {0.01, 0.}}, {0., 
       FormBox["1", TraditionalForm], {0.01, 0.}}, {1.6094379124341003`, 
       FormBox["5", TraditionalForm], {0.01, 0.}}, {-4.605170185988091, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-3.912023005428146, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-3.506557897319982, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-3.2188758248682006`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.8134107167600364`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.659260036932778, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.5257286443082556`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-2.4079456086518722`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-1.6094379124341003`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-1.2039728043259361`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.916290731874155, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.5108256237659907, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.35667494393873245`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.2231435513142097, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}, {-0.10536051565782628`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      0.6931471805599453, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.0986122886681098`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.3862943611198906`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.791759469228055, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      1.9459101490553132`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.0794415416798357`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.1972245773362196`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.302585092994046, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.3978952727983707`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.4849066497880004`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.5649493574615367`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.6390573296152584`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.70805020110221, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.772588722239781, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.833213344056216, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
      2.8903717578961645`, 
       FormBox[
        TemplateBox[{0., 0.}, "Spacer2"], TraditionalForm], {0.005, 
       0.}}}}]]], "Output",
 CellChangeTimes->{
  3.8018515263896847`*^9, {3.801851670230095*^9, 3.801851699969112*^9}, 
   3.80185182713035*^9, 3.8018519329056168`*^9, {3.8018519864496593`*^9, 
   3.801852009424493*^9}, 3.8018520789315443`*^9},
 CellLabel->"Out[25]=",ExpressionUUID->"bd350d19-74ef-432f-a02a-ad086ebea7e8"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"g", "[", 
  RowBox[{"0.8", ",", "100"}], "]"}]], "Input",
 CellChangeTimes->{{3.801852635082081*^9, 3.801852643417201*^9}},
 CellLabel->"In[26]:=",ExpressionUUID->"e3320e51-f07c-4ac2-9005-ca59fe87b333"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"g", "[", 
     RowBox[{
      RowBox[{"1", "-", "x"}], ",", "0"}], "]"}], "*", 
    RowBox[{"x", "^", 
     RowBox[{"(", 
      RowBox[{"3", "/", "2"}], ")"}]}]}], ",", 
   RowBox[{"x", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.801254452738415*^9, 3.801254465969502*^9}, {
  3.801254701408291*^9, 3.801254704267601*^9}, {3.801254901264468*^9, 
  3.801254912006572*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"918e703d-4181-47da-83b0-a542929c326d"],

Cell[BoxData["Indeterminate"], "Output",
 CellChangeTimes->{3.801254665696734*^9, 3.80125476857864*^9, 
  3.8012549845754128`*^9, 3.801837935173044*^9},
 CellLabel->"Out[9]=",ExpressionUUID->"97cb9001-5339-43a4-96ce-b48358e7aee2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"e", ",", "0"}], "]"}], "*", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "e"}], ")"}], "^", 
     RowBox[{"(", 
      RowBox[{"3", "/", "2"}], ")"}]}]}], ",", 
   RowBox[{"e", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8012548572714243`*^9, 3.8012548877934637`*^9}, {
  3.8018377036951857`*^9, 3.8018377114647913`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"0e80f533-5430-40f8-aa28-1edf6a699d84"],

Cell[BoxData[
 RowBox[{
  UnderscriptBox["\[Limit]", 
   RowBox[{"e", "\[Rule]", "1"}]], 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", "e"}], ")"}], 
    RowBox[{"3", "/", "2"}]], " ", 
   RowBox[{"f", "[", 
    RowBox[{"e", ",", "0"}], "]"}]}]}]], "Output",
 CellChangeTimes->{{3.8012548733488073`*^9, 3.8012548882660503`*^9}, 
   3.801837712691361*^9},
 CellLabel->"Out[1]=",ExpressionUUID->"c8c4e301-f6cb-4928-8462-9f3e60369b02"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"1", "-", "x"}], ",", "0"}], "]"}], "*", 
   RowBox[{"x", "^", 
    RowBox[{"(", 
     RowBox[{"3", "/", "2"}], ")"}]}]}], "/.", 
  RowBox[{"x", "\[Rule]", "0.000001"}]}]], "Input",
 CellChangeTimes->{{3.801837903362648*^9, 3.8018379094423847`*^9}, {
  3.8018381004873743`*^9, 3.80183810059095*^9}},
 CellLabel->"In[11]:=",ExpressionUUID->"305000e5-2b21-4a3d-a8f9-d55dd9c1824e"],

Cell[BoxData[
 RowBox[{"2.2214431351613255`", "\[VeryThinSpace]", "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellChangeTimes->{3.8018379513264103`*^9, 3.801838114695572*^9},
 CellLabel->"Out[11]=",ExpressionUUID->"b38ab465-f810-4d0d-8b6a-edc2695ac305"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", "x", "]"}], "*", 
       RowBox[{
        RowBox[{"Exp", "[", 
         RowBox[{"-", "y"}], "]"}], "/", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"Cos", "[", "x", "]"}], "+", 
           RowBox[{
            RowBox[{"Exp", "[", 
             RowBox[{"-", "y"}], "]"}], "*", 
            RowBox[{"Cos", "[", "x", "]"}]}]}], ")"}], "^", "3"}]}]}], ",", 
      " ", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", 
        RowBox[{"2", "*", "\[Pi]"}]}], "}"}]}], "]"}], "/", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"Cos", "[", "x", "]"}], "+", 
          RowBox[{
           RowBox[{"Exp", "[", 
            RowBox[{"-", "y"}], "]"}], "*", 
           RowBox[{"Cos", "[", "x", "]"}]}]}], ")"}], "^", "2"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", 
        RowBox[{"2", "*", "\[Pi]"}]}], "}"}]}], "]"}]}], ",", " ", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Element", "[", 
       RowBox[{"y", ",", "Reals"}], "]"}], ",", " ", 
      RowBox[{"y", ">", "0"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8018392091399517`*^9, 3.801839252882083*^9}, {
  3.8018395687528973`*^9, 3.801839577350173*^9}, {3.801840281084714*^9, 
  3.801840362705765*^9}, {3.801840492565118*^9, 3.80184051988372*^9}, {
  3.801840701624695*^9, 3.801840729662125*^9}, {3.801840761400642*^9, 
  3.801840764807026*^9}, {3.801840811457424*^9, 3.8018408195994577`*^9}, {
  3.8018408592826443`*^9, 3.801840898288241*^9}, {3.801842720792747*^9, 
  3.80184275752995*^9}, {3.801842818741206*^9, 3.8018428493479424`*^9}, {
  3.801842936703084*^9, 3.801842961788927*^9}},
 CellLabel->"In[38]:=",ExpressionUUID->"ad8f2157-75e7-4788-bf08-b8a7ad2083b4"],

Cell[BoxData[
 FractionBox[
  RowBox[{"3", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["\[ExponentialE]", "y"]}], ")"}]}], 
  RowBox[{
   RowBox[{"-", "2"}], "+", 
   RowBox[{"4", " ", 
    SuperscriptBox["\[ExponentialE]", "y"]}]}]]], "Output",
 CellChangeTimes->{{3.801839232727981*^9, 3.801839253351218*^9}, {
   3.8018395705478163`*^9, 3.801839577798442*^9}, {3.8018402953553247`*^9, 
   3.801840310496726*^9}, 3.801840351663866*^9, 3.801840616164163*^9, 
   3.8018407495352163`*^9, 3.801840784977932*^9, 3.801840839581943*^9, 
   3.8018408811257153`*^9, 3.801840917994673*^9, 3.80184277807185*^9, 
   3.801842840788878*^9, 3.8018428744184227`*^9, 3.801843263834341*^9},
 CellLabel->"Out[38]=",ExpressionUUID->"4cac1253-9464-44b7-9ec5-301972510b28"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArcSec", "[", "0.99", "]"}]], "Input",
 CellChangeTimes->{{3.8018409289446363`*^9, 3.8018409918410254`*^9}, {
  3.801842785245187*^9, 3.8018428123380327`*^9}},
 CellLabel->"In[35]:=",ExpressionUUID->"1923dbe7-66b4-4983-81f7-8eb58ff756f8"],

Cell[BoxData[
 RowBox[{"0.`", "\[VeryThinSpace]", "+", 
  RowBox[{"0.1420144407460776`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellChangeTimes->{{3.801840936915473*^9, 3.8018409922194653`*^9}, {
  3.801842788573241*^9, 3.801842812755649*^9}},
 CellLabel->"Out[35]=",ExpressionUUID->"7c378fa3-fcb7-4bde-9224-470a752eaa83"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"y", "*", 
         RowBox[{"Cos", "[", "x", "]"}]}]}], ")"}], "^", "2"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", 
      RowBox[{"2", "*", "\[Pi]"}]}], "}"}], ",", 
    RowBox[{"Assumptions", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Element", "[", 
        RowBox[{"y", ",", "Reals"}], "]"}], " ", "&&", " ", 
       RowBox[{"y", ">", "0"}], " ", "&&", " ", 
       RowBox[{"y", "<", "1"}]}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.801840734357514*^9, 3.801843633670538*^9, {3.801843781640771*^9, 
   3.8018437982214603`*^9}, {3.8018441436105213`*^9, 3.801844156221025*^9}, {
   3.801847342323443*^9, 
   3.801847347223022*^9}},ExpressionUUID->"871df097-0e04-40a8-abfc-\
b029507642e6"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", "\[Pi]"}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "-", 
     SuperscriptBox["y", "2"]}], ")"}], 
   RowBox[{"3", "/", "2"}]]]], "Output",
 CellChangeTimes->{3.801843672379925*^9, 3.801843809864032*^9, 
  3.801844171163397*^9},
 CellLabel->"Out[41]=",ExpressionUUID->"2a9269b9-8d9f-4eac-b2ae-68168463b9f7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g", "[", 
  RowBox[{"y", ",", "0"}], "]"}]], "Input",
 CellChangeTimes->{{3.80184438788757*^9, 3.801844390446959*^9}},
 CellLabel->"In[12]:=",ExpressionUUID->"3c870b4e-68a3-4fcd-81f7-6dd9a0aa22ec"],

Cell[BoxData[
 TemplateBox[{
   FractionBox[
    RowBox[{"2", " ", "\[Pi]"}], 
    SuperscriptBox[
     RowBox[{"(", 
       RowBox[{"1", "-", 
         SuperscriptBox["y", "2"]}], ")"}], 
     RowBox[{"3", "/", "2"}]]], 
   RowBox[{"y", "<", "1"}]},
  "ConditionalExpression"]], "Output",
 CellChangeTimes->{3.801844441485594*^9, 3.8018449094302177`*^9},
 CellLabel->"Out[12]=",ExpressionUUID->"e49d4be9-063f-4d66-ba18-efbc4b7de510"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g", "[", 
  RowBox[{"y", ",", "1"}], "]"}]], "Input",
 CellChangeTimes->{{3.801844940567895*^9, 3.801844942925753*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"41c40bd7-bbc2-4fca-80bb-17ff7a355f1a"],

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   FractionBox[
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{"u", "-", 
        RowBox[{"y", " ", 
         RowBox[{"Sin", "[", "u", "]"}]}]}], ")"}]}]], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"y", " ", 
        RowBox[{"Cos", "[", "u", "]"}]}]}], ")"}], "2"]], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", " ", "\[Pi]"}]}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"y", "\[Element]", 
       TemplateBox[{},
        "Reals"]}], ",", 
      RowBox[{"y", ">", "0"}]}], "}"}]}]}], "]"}]], "Output",
 CellChangeTimes->{3.801847482809567*^9},
 CellLabel->"Out[13]=",ExpressionUUID->"13d0c0c7-c8d5-4229-a28e-08e011d1ece7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2", "*", 
  RowBox[{"\[Pi]", "/", 
   RowBox[{"2", "^", "1.5"}]}]}]], "Input",
 CellChangeTimes->{{3.80184940478268*^9, 3.801849416717037*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"d66e576e-10f0-4d6e-aa5a-9c2733fedc46"],

Cell[BoxData["2.221441469079183`"], "Output",
 CellChangeTimes->{3.80184941740769*^9},
 CellLabel->"Out[14]=",ExpressionUUID->"7390973a-ca6b-4e8e-9db2-6c1bfec321bd"]
}, Open  ]]
},
WindowSize->{2560, 1395},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"12.1 for Mac OS X x86 (64-bit) (March 18, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"6d911ef7-d19c-4050-9e62-0de40286e40d"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 1105, 23, 38, "Text",ExpressionUUID->"4025eb12-2a83-4555-9516-d9ab96160d14"],
Cell[1666, 45, 779, 22, 30, "Input",ExpressionUUID->"501e030c-1be2-4e11-b6db-114503de5ab5"],
Cell[2448, 69, 621, 14, 37, "Text",ExpressionUUID->"ce8e4104-be6d-46a8-aa91-271e74cd07a0"],
Cell[3072, 85, 921, 27, 30, "Input",ExpressionUUID->"83fc1049-75da-4b3e-ac58-d5200eee6010"],
Cell[3996, 114, 2199, 49, 33, "Input",ExpressionUUID->"f6c40af6-bcfd-4b97-a97e-01e7dae00d8c"],
Cell[6198, 165, 1244, 36, 30, "Input",ExpressionUUID->"b6f2c8d7-28b4-4cba-b778-b4a1c5fa07fb"],
Cell[CellGroupData[{
Cell[7467, 205, 577, 16, 30, "Input",ExpressionUUID->"ee56e455-8401-4c5b-9259-c5e89aa795c4"],
Cell[8047, 223, 1037, 27, 54, "Output",ExpressionUUID->"0335c0c6-b84c-4b8a-a2be-011aab2a1ec2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9121, 255, 1043, 28, 33, "Input",ExpressionUUID->"fec6af7a-eaf9-46ab-a7c3-f061c6bb9323"],
Cell[CellGroupData[{
Cell[10189, 287, 484, 14, 27, "Print",ExpressionUUID->"6f9f1050-16ee-463f-a507-b7cbccd89572"],
Cell[10676, 303, 1481, 40, 43, "Print",ExpressionUUID->"b1993beb-aa65-469c-9efc-98a9c5654dd7"],
Cell[12160, 345, 1562, 42, 43, "Print",ExpressionUUID->"1d906aca-1c9c-4ffd-a2ab-4a77077f6e8e"],
Cell[13725, 389, 1440, 39, 43, "Print",ExpressionUUID->"f6123323-ba47-4de3-8561-b262d4886f77"],
Cell[15168, 430, 1430, 39, 43, "Print",ExpressionUUID->"945d66ca-aa9f-48c5-8e79-590a2d128ec6"],
Cell[16601, 471, 1293, 36, 43, "Print",ExpressionUUID->"a19d7af9-5de1-448c-8c46-5b09c2e1ce73"],
Cell[17897, 509, 1294, 36, 43, "Print",ExpressionUUID->"d2ea917d-e546-4f69-a5fa-fd7ee3e7701f"],
Cell[19194, 547, 1135, 33, 43, "Print",ExpressionUUID->"6abb7eb8-3bf4-49e4-9be5-117e7c9cf867"],
Cell[20332, 582, 1124, 31, 43, "Print",ExpressionUUID->"6c15587f-144d-4464-975f-f5b26aaf66d9"],
Cell[21459, 615, 953, 28, 43, "Print",ExpressionUUID->"983b6d48-1b8e-4b57-bce6-6cd73faefe57"],
Cell[22415, 645, 942, 26, 43, "Print",ExpressionUUID->"a29b7084-83ec-42a3-9f7f-a19e21162425"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23406, 677, 980, 27, 33, "Input",ExpressionUUID->"d657667b-1937-47f2-8679-8ad4f7962366"],
Cell[CellGroupData[{
Cell[24411, 708, 435, 13, 27, "Print",ExpressionUUID->"a2939ec3-dc48-422a-8c30-758e9e00c97b"],
Cell[24849, 723, 1628, 44, 43, "Print",ExpressionUUID->"cc625cd4-bf73-4c5c-9ffe-e21c5ecc86a9"],
Cell[26480, 769, 1696, 46, 43, "Print",ExpressionUUID->"8f4cee34-0ade-42b2-b333-8d2c93c7c710"],
Cell[28179, 817, 1771, 46, 43, "Print",ExpressionUUID->"a34c908f-0cec-450a-aa0b-d9011b831d48"],
Cell[29953, 865, 1751, 46, 43, "Print",ExpressionUUID->"22afe477-6bc8-4508-bf32-7b7bcf06cf50"],
Cell[31707, 913, 1865, 48, 43, "Print",ExpressionUUID->"d99bd015-73e3-4eff-971f-589d1c588861"],
Cell[33575, 963, 1822, 48, 43, "Print",ExpressionUUID->"0ce0a05e-6058-4469-91f9-740ceb39ec06"],
Cell[35400, 1013, 1967, 49, 43, "Print",ExpressionUUID->"6b8d1d5c-a6cb-438c-8475-b130f5820537"],
Cell[37370, 1064, 1904, 48, 43, "Print",ExpressionUUID->"e2740cd7-bdd9-4bc2-bf7f-85a549d76a7c"],
Cell[39277, 1114, 2058, 50, 43, "Print",ExpressionUUID->"379093c9-50db-4c9a-861f-d2e46cf56f56"],
Cell[41338, 1166, 1974, 49, 43, "Print",ExpressionUUID->"945b8e2c-d537-47b4-9b7e-84ba0dafd59d"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[43361, 1221, 1043, 24, 33, "Input",ExpressionUUID->"8ae4c4f8-bcf5-462e-b047-2036e485c79b"],
Cell[CellGroupData[{
Cell[44429, 1249, 481, 14, 27, "Print",ExpressionUUID->"d7633835-163d-455f-a9b4-dd466ad92af9"],
Cell[44913, 1265, 1577, 44, 49, "Print",ExpressionUUID->"5c032676-9f61-46a3-90ba-4c4cc4e8ddb7"]
}, Open  ]],
Cell[46505, 1312, 203, 3, 34, "Output",ExpressionUUID->"6349911c-fde0-4af1-80de-0553315a299d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[46745, 1320, 2130, 53, 33, "Input",ExpressionUUID->"70dad235-308f-4ed3-846d-08706ae5f7bb"],
Cell[48878, 1375, 35306, 692, 287, "Output",ExpressionUUID->"e8219c85-3289-484a-a178-e54c088dc904"]
}, Open  ]],
Cell[84199, 2070, 637, 13, 32, "Input",ExpressionUUID->"9e17e15d-468c-49cd-b422-3b58a8237c6c"],
Cell[CellGroupData[{
Cell[84861, 2087, 559, 16, 52, "Input",ExpressionUUID->"ffdbfb07-c5f5-41ee-a1a7-13f8a5ce8eb2"],
Cell[85423, 2105, 169, 3, 50, "Output",ExpressionUUID->"0bcd098b-faff-4967-a55b-3516b0d5274a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[85629, 2113, 2297, 61, 56, "Input",ExpressionUUID->"08fc819a-8ae0-4d8c-ad46-9e217ae72a81"],
Cell[87929, 2176, 941, 18, 26, "Message",ExpressionUUID->"f80cb757-9c23-4347-9f6c-1b2f57f5be75"],
Cell[88873, 2196, 45833, 864, 278, "Output",ExpressionUUID->"9ed34be6-c8ba-4099-bb6d-c6c22361c12b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[134743, 3065, 2468, 67, 56, "Input",ExpressionUUID->"ae86124e-0989-4510-b85a-e8c25b7c67bf"],
Cell[137214, 3134, 941, 18, 26, "Message",ExpressionUUID->"2d6ae9db-ba9b-4fe6-8bf2-77e0d0997f58"],
Cell[138158, 3154, 37920, 729, 278, "Output",ExpressionUUID->"9fb53cda-91ec-4499-9e78-5aa5570c06ef"]
}, Open  ]],
Cell[CellGroupData[{
Cell[176115, 3888, 1494, 37, 33, "Input",ExpressionUUID->"58dc1d30-a8bb-489e-95c5-7dc8845fe7e2"],
Cell[177612, 3927, 656, 14, 24, "Message",ExpressionUUID->"acd712c9-9142-44cc-8523-db46a07dbfb8"],
Cell[178271, 3943, 1108, 21, 26, "Message",ExpressionUUID->"338ca20b-a19b-42d4-9c36-a4a3a9acb3c1"],
Cell[179382, 3966, 9723, 225, 639, "Output",ExpressionUUID->"bd350d19-74ef-432f-a02a-ad086ebea7e8"]
}, Open  ]],
Cell[189120, 4194, 226, 4, 30, "Input",ExpressionUUID->"e3320e51-f07c-4ac2-9005-ca59fe87b333"],
Cell[CellGroupData[{
Cell[189371, 4202, 538, 14, 30, "Input",ExpressionUUID->"918e703d-4181-47da-83b0-a542929c326d"],
Cell[189912, 4218, 230, 3, 34, "Output",ExpressionUUID->"97cb9001-5339-43a4-96ce-b48358e7aee2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[190179, 4226, 523, 14, 30, "Input",ExpressionUUID->"0e80f533-5430-40f8-aa28-1edf6a699d84"],
Cell[190705, 4242, 458, 13, 42, "Output",ExpressionUUID->"c8c4e301-f6cb-4928-8462-9f3e60369b02"]
}, Open  ]],
Cell[CellGroupData[{
Cell[191200, 4260, 461, 12, 30, "Input",ExpressionUUID->"305000e5-2b21-4a3d-a8f9-d55dd9c1824e"],
Cell[191664, 4274, 270, 4, 34, "Output",ExpressionUUID->"b38ab465-f810-4d0d-8b6a-edc2695ac305"]
}, Open  ]],
Cell[CellGroupData[{
Cell[191971, 4283, 2010, 51, 30, "Input",ExpressionUUID->"ad8f2157-75e7-4788-bf08-b8a7ad2083b4"],
Cell[193984, 4336, 796, 17, 55, "Output",ExpressionUUID->"4cac1253-9464-44b7-9ec5-301972510b28"]
}, Open  ]],
Cell[CellGroupData[{
Cell[194817, 4358, 262, 4, 30, "Input",ExpressionUUID->"1923dbe7-66b4-4983-81f7-8eb58ff756f8"],
Cell[195082, 4364, 321, 5, 34, "Output",ExpressionUUID->"7c378fa3-fcb7-4bde-9224-470a752eaa83"]
}, Open  ]],
Cell[CellGroupData[{
Cell[195440, 4374, 910, 25, 30, "Input",ExpressionUUID->"871df097-0e04-40a8-abfc-b029507642e6"],
Cell[196353, 4401, 367, 10, 57, "Output",ExpressionUUID->"2a9269b9-8d9f-4eac-b2ae-68168463b9f7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[196757, 4416, 221, 4, 30, "Input",ExpressionUUID->"3c870b4e-68a3-4fcd-81f7-6dd9a0aa22ec"],
Cell[196981, 4422, 434, 12, 67, "Output",ExpressionUUID->"e49d4be9-063f-4d66-ba18-efbc4b7de510"]
}, Open  ]],
Cell[CellGroupData[{
Cell[197452, 4439, 222, 4, 30, "Input",ExpressionUUID->"41c40bd7-bbc2-4fca-80bb-17ff7a355f1a"],
Cell[197677, 4445, 861, 26, 58, "Output",ExpressionUUID->"13d0c0c7-c8d5-4229-a28e-08e011d1ece7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[198575, 4476, 246, 5, 30, "Input",ExpressionUUID->"d66e576e-10f0-4d6e-aa5a-9c2733fedc46"],
Cell[198824, 4483, 165, 2, 34, "Output",ExpressionUUID->"7390973a-ca6b-4e8e-9db2-6c1bfec321bd"]
}, Open  ]]
}
]
*)

