(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   2043190,      39076]
NotebookOptionsPosition[   2014777,      38275]
NotebookOutlinePosition[   2015121,      38290]
CellTagsIndexPosition[   2015078,      38287]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Function Definitions", "Section",
 CellChangeTimes->{{3.804249707395234*^9, 3.8042497128711557`*^9}}],

Cell["Don\[CloseCurlyQuote]t forget that there\[CloseCurlyQuote]s also an \
omega floating around", "Text",
 CellChangeTimes->{{3.8042498313032227`*^9, 3.8042498390280557`*^9}}],

Cell[CellGroupData[{

Cell["For m = 0", "Subsection",
 CellChangeTimes->{{3.804249894695382*^9, 3.8042498963048887`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"const1", "=", 
  RowBox[{"1", "/", 
   RowBox[{"(", 
    RowBox[{"2", "*", "Pi"}], ")"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8042498093016453`*^9, 3.804249818121458*^9}, 
   3.804249965516646*^9, 3.8042512786847644`*^9}],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"2", " ", "\[Pi]"}]]], "Output",
 CellChangeTimes->{3.8042509230129004`*^9, 3.804251279311183*^9, 
  3.8044441790749702`*^9, 3.804509439710074*^9, 3.8048666164478817`*^9, 
  3.804948517729862*^9, 3.8050252716506824`*^9, 3.8050362001948843`*^9, 
  3.805112242488683*^9, 3.8051969333252935`*^9, 3.8054589376177826`*^9, 
  3.80554757315653*^9, 3.8056293041772103`*^9, 3.8060646531274424`*^9, 
  3.806148420875233*^9, 3.8062350188062053`*^9, 3.807015015128883*^9, 
  3.811260354658983*^9, 3.8142749530184946`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"p0", "[", 
   RowBox[{"e_", ",", "s_"}], "]"}], ":=", 
  RowBox[{"const1", "*", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Exp", "[", 
       RowBox[{"I", "*", "s", "*", 
        RowBox[{"(", 
         RowBox[{"u", "-", 
          RowBox[{"e", "*", 
           RowBox[{"Sin", "[", "u", "]"}]}]}], ")"}]}], "]"}], " ", "/", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"e", "*", 
          RowBox[{"Cos", "[", "u", "]"}]}]}], ")"}], "^", "2"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", 
       RowBox[{"2", "*", "Pi"}]}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Element", "[", 
         RowBox[{"e", ",", "Reals"}], "]"}], ",", 
        RowBox[{"e", ">", "0"}]}], "}"}]}]}], "]"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8042497417593374`*^9, 3.804249742971213*^9}, {
   3.804249823209738*^9, 3.804249825638482*^9}, 3.8042504083645954`*^9, {
   3.8045983989477015`*^9, 3.8045984024803524`*^9}, {3.804868511524465*^9, 
   3.804868512198599*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Np0", "[", 
   RowBox[{"e_", ",", "s_"}], "]"}], ":=", 
  RowBox[{"const1", "*", 
   RowBox[{"NIntegrate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Exp", "[", 
       RowBox[{"I", "*", "s", "*", 
        RowBox[{"(", 
         RowBox[{"u", "-", 
          RowBox[{"e", "*", 
           RowBox[{"Sin", "[", "u", "]"}]}]}], ")"}]}], "]"}], " ", "/", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"e", "*", 
          RowBox[{"Cos", "[", "u", "]"}]}]}], ")"}], "^", "2"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", 
       RowBox[{"2", "*", "Pi"}]}], "}"}]}], "]"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8042658667510514`*^9, 3.804265877173378*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"p0NoPole", "[", 
   RowBox[{"e_", ",", "s_"}], "]"}], ":=", 
  RowBox[{"const1", "*", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"e", "^", "2"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"3", "/", "2"}], ")"}]}], "*", 
      RowBox[{
       RowBox[{"Exp", "[", 
        RowBox[{"I", "*", "s", "*", 
         RowBox[{"(", 
          RowBox[{"u", "-", 
           RowBox[{"e", "*", 
            RowBox[{"Sin", "[", "u", "]"}]}]}], ")"}]}], "]"}], " ", "/", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"e", "*", 
           RowBox[{"Cos", "[", "u", "]"}]}]}], ")"}], "^", "2"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", 
       RowBox[{"2", "*", "Pi"}]}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"e", "\[GreaterEqual]", "0"}], ",", 
        RowBox[{"e", "\[LessEqual]", "1"}], ",", 
        RowBox[{"Element", "[", 
         RowBox[{"s", ",", "Integers"}], "]"}]}], "}"}]}]}], 
    "]"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.804249761345158*^9, 3.8042497632833605`*^9}, 
   3.804250412363885*^9, {3.804251048540388*^9, 3.8042510511909294`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Np0NoPole", "[", 
   RowBox[{"e_", ",", "s_"}], "]"}], ":=", 
  RowBox[{"const1", "*", 
   RowBox[{"NIntegrate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"e", "^", "2"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"3", "/", "2"}], ")"}]}], "*", 
      RowBox[{
       RowBox[{"Exp", "[", 
        RowBox[{"I", "*", "s", "*", 
         RowBox[{"(", 
          RowBox[{"u", "-", 
           RowBox[{"e", "*", 
            RowBox[{"Sin", "[", "u", "]"}]}]}], ")"}]}], "]"}], " ", "/", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"e", "*", 
           RowBox[{"Cos", "[", "u", "]"}]}]}], ")"}], "^", "2"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", 
       RowBox[{"2", "*", "Pi"}]}], "}"}]}], "]"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.804265380225936*^9, 3.804265383557848*^9}, 
   3.804265501784275*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["For m = 2", "Subsection",
 CellChangeTimes->{{3.804249904113641*^9, 3.8042499063096046`*^9}}],

Cell["\<\
There\[CloseCurlyQuote]s also an Exp[phi_not]
Apparently that\[CloseCurlyQuote]s actually handled in POET, never mind\
\>", "Text",
 CellChangeTimes->{{3.8042499424590483`*^9, 3.8042499548365602`*^9}, {
  3.8045092907088766`*^9, 3.8045093028715887`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"const2", "=", "1"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8042499566628637`*^9, 3.804249979544628*^9}, {
  3.804444005606981*^9, 3.8044440078359118`*^9}, {3.804444052392553*^9, 
  3.8044440527172546`*^9}}],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{3.804250923263668*^9, 3.8044440097880993`*^9, 
  3.80444405327074*^9, 3.80444417973635*^9, 3.804509440000804*^9, 
  3.8048666166806884`*^9, 3.8049485179616475`*^9, 3.805025271830516*^9, 
  3.805036200340717*^9, 3.8051122426495347`*^9, 3.8051969334641666`*^9, 
  3.805458937796173*^9, 3.805547573614107*^9, 3.8056293044049654`*^9, 
  3.8060646532767086`*^9, 3.806148421001119*^9, 3.806235018940081*^9, 
  3.807015015302722*^9, 3.811260355106659*^9, 3.8142749531673555`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sub integrals", "Subsubsection",
 CellChangeTimes->{{3.804250033439602*^9, 3.804250035291881*^9}}],

Cell["Symbolic integration", "Text",
 CellChangeTimes->{{3.8054584410289364`*^9, 3.805458450531994*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"pTwoA", "[", 
   RowBox[{"e_", ",", "s_"}], "]"}], ":=", 
  RowBox[{"const1", "*", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"e", "^", "2"}]}], ")"}], "*", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Exp", "[", 
        RowBox[{"I", "*", "s", "*", 
         RowBox[{"(", 
          RowBox[{"u", "-", 
           RowBox[{"e", "*", 
            RowBox[{"Sin", "[", "u", "]"}]}]}], ")"}]}], "]"}], " ", "/", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"e", "*", 
           RowBox[{"Cos", "[", "u", "]"}]}]}], ")"}], "^", "4"}]}], ")"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", 
       RowBox[{"2", "*", "Pi"}]}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Element", "[", 
         RowBox[{"e", ",", "Reals"}], "]"}], ",", 
        RowBox[{"e", ">", "0"}]}], "}"}]}]}], "]"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.804250040670888*^9, {3.8042501766047144`*^9, 3.804250180610001*^9}, {
   3.804250227662328*^9, 3.8042502362513533`*^9}, {3.8045983112338076`*^9, 
   3.804598327552512*^9}, 3.8048739263243513`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"pTwoB", "[", 
   RowBox[{"e_", ",", "s_"}], "]"}], ":=", 
  RowBox[{"const1", "*", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"e", "^", "2"}]}], ")"}], "*", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Exp", "[", 
         RowBox[{"I", "*", "s", "*", 
          RowBox[{"(", 
           RowBox[{"u", "-", 
            RowBox[{"e", "*", 
             RowBox[{"Sin", "[", "u", "]"}]}]}], ")"}]}], "]"}], " ", "/", 
        " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"e", "*", 
            RowBox[{"Cos", "[", "u", "]"}]}]}], ")"}], "^", "4"}]}], ")"}], 
      "*", 
      RowBox[{"Cos", "[", 
       RowBox[{"2", "*", "u"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", 
       RowBox[{"2", "*", "Pi"}]}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Element", "[", 
         RowBox[{"e", ",", "Reals"}], "]"}], ",", 
        RowBox[{"e", ">", "0"}]}], "}"}]}]}], "]"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.8042500524669437`*^9, 3.8042501965571966`*^9, {3.804250240331566*^9, 
   3.8042502567683086`*^9}, 3.8045983416954765`*^9, 3.804873934788295*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"pTwoC", "[", 
   RowBox[{"e_", ",", "s_"}], "]"}], ":=", 
  RowBox[{"const1", "*", "I", "*", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"e", "^", "2"}]}], ")"}], "]"}], "*", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Exp", "[", 
         RowBox[{"I", "*", "s", "*", 
          RowBox[{"(", 
           RowBox[{"u", "-", 
            RowBox[{"e", "*", 
             RowBox[{"Sin", "[", "u", "]"}]}]}], ")"}]}], "]"}], " ", "/", 
        " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"e", "*", 
            RowBox[{"Cos", "[", "u", "]"}]}]}], ")"}], "^", "4"}]}], ")"}], 
      "*", 
      RowBox[{"Sin", "[", 
       RowBox[{"2", "*", "u"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", 
       RowBox[{"2", "*", "Pi"}]}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Element", "[", 
         RowBox[{"e", ",", "Reals"}], "]"}], ",", 
        RowBox[{"e", ">", "0"}]}], "}"}]}]}], "]"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.804250123974566*^9, 3.8042501980737896`*^9, {3.8042502750073767`*^9, 
   3.804250317539899*^9}, 3.8045983591945066`*^9, 3.8048739439690704`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"pTwoD", "[", 
   RowBox[{"e_", ",", "s_"}], "]"}], ":=", 
  RowBox[{"const1", "*", "I", "*", "2", "*", "e", "*", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"e", "^", "2"}]}], ")"}], "]"}], "*", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Exp", "[", 
         RowBox[{"I", "*", "s", "*", 
          RowBox[{"(", 
           RowBox[{"u", "-", 
            RowBox[{"e", "*", 
             RowBox[{"Sin", "[", "u", "]"}]}]}], ")"}]}], "]"}], " ", "/", 
        " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"e", "*", 
            RowBox[{"Cos", "[", "u", "]"}]}]}], ")"}], "^", "4"}]}], ")"}], 
      "*", 
      RowBox[{"Sin", "[", "u", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", 
       RowBox[{"2", "*", "Pi"}]}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Element", "[", 
         RowBox[{"e", ",", "Reals"}], "]"}], ",", 
        RowBox[{"e", ">", "0"}]}], "}"}]}]}], "]"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8042503495232115`*^9, 3.804250368877252*^9}, 
   3.804598367837075*^9, 3.8048739477889547`*^9}],

Cell["Numeric integration", "Text",
 CellChangeTimes->{{3.805458457435115*^9, 3.805458460242817*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NpTwoA", "[", 
   RowBox[{"e_", ",", "s_"}], "]"}], ":=", 
  RowBox[{"const1", "*", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"e", "^", "2"}]}], ")"}], "*", 
   RowBox[{"NIntegrate", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Exp", "[", 
        RowBox[{"I", "*", "s", "*", 
         RowBox[{"(", 
          RowBox[{"u", "-", 
           RowBox[{"e", "*", 
            RowBox[{"Sin", "[", "u", "]"}]}]}], ")"}]}], "]"}], " ", "/", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"e", "*", 
           RowBox[{"Cos", "[", "u", "]"}]}]}], ")"}], "^", "4"}]}], ")"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", 
       RowBox[{"2", "*", "Pi"}]}], "}"}]}], "]"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.804250040670888*^9, {3.8042501766047144`*^9, 3.804250180610001*^9}, {
   3.804250227662328*^9, 3.8042502362513533`*^9}, {3.8042658133805904`*^9, 
   3.804265825686167*^9}, 3.8042658973736267`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NpTwoB", "[", 
   RowBox[{"e_", ",", "s_"}], "]"}], ":=", 
  RowBox[{"const1", "*", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"e", "^", "2"}]}], ")"}], "*", 
   RowBox[{"NIntegrate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Exp", "[", 
         RowBox[{"I", "*", "s", "*", 
          RowBox[{"(", 
           RowBox[{"u", "-", 
            RowBox[{"e", "*", 
             RowBox[{"Sin", "[", "u", "]"}]}]}], ")"}]}], "]"}], " ", "/", 
        " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"e", "*", 
            RowBox[{"Cos", "[", "u", "]"}]}]}], ")"}], "^", "4"}]}], ")"}], 
      "*", 
      RowBox[{"Cos", "[", 
       RowBox[{"2", "*", "u"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", 
       RowBox[{"2", "*", "Pi"}]}], "}"}]}], "]"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.8042500524669437`*^9, 3.8042501965571966`*^9, {3.804250240331566*^9, 
   3.8042502567683086`*^9}, {3.8042658153887234`*^9, 3.804265826907036*^9}, 
   3.8042659057668347`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NpTwoC", "[", 
   RowBox[{"e_", ",", "s_"}], "]"}], ":=", 
  RowBox[{"const1", "*", "I", "*", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"e", "^", "2"}]}], ")"}], "]"}], "*", 
   RowBox[{"NIntegrate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Exp", "[", 
         RowBox[{"I", "*", "s", "*", 
          RowBox[{"(", 
           RowBox[{"u", "-", 
            RowBox[{"e", "*", 
             RowBox[{"Sin", "[", "u", "]"}]}]}], ")"}]}], "]"}], " ", "/", 
        " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"e", "*", 
            RowBox[{"Cos", "[", "u", "]"}]}]}], ")"}], "^", "4"}]}], ")"}], 
      "*", 
      RowBox[{"Sin", "[", 
       RowBox[{"2", "*", "u"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", 
       RowBox[{"2", "*", "Pi"}]}], "}"}]}], "]"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.804250123974566*^9, 3.8042501980737896`*^9, {3.8042502750073767`*^9, 
   3.804250317539899*^9}, {3.8042658162848916`*^9, 3.8042658285185375`*^9}, 
   3.8042659124256573`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NpTwoD", "[", 
   RowBox[{"e_", ",", "s_"}], "]"}], ":=", 
  RowBox[{"const1", "*", "I", "*", "2", "*", "e", "*", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"e", "^", "2"}]}], ")"}], "]"}], "*", 
   RowBox[{"NIntegrate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Exp", "[", 
         RowBox[{"I", "*", "s", "*", 
          RowBox[{"(", 
           RowBox[{"u", "-", 
            RowBox[{"e", "*", 
             RowBox[{"Sin", "[", "u", "]"}]}]}], ")"}]}], "]"}], " ", "/", 
        " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"e", "*", 
            RowBox[{"Cos", "[", "u", "]"}]}]}], ")"}], "^", "4"}]}], ")"}], 
      "*", 
      RowBox[{"Sin", "[", "u", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "0", ",", 
       RowBox[{"2", "*", "Pi"}]}], "}"}]}], "]"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8042503495232115`*^9, 3.804250368877252*^9}, {
   3.8042658170551767`*^9, 3.804265830173004*^9}, 3.804265915996343*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Main Coefficients", "Subsubsection",
 CellChangeTimes->{{3.804250393279598*^9, 3.804250396836296*^9}}],

Cell["\<\
I\[CloseCurlyQuote]m not sure why I\[CloseCurlyQuote]m dividing by const1, \
but I don\[CloseCurlyQuote]t believe it\[CloseCurlyQuote]s causing any issues \
w/ regard to behavior, so I\[CloseCurlyQuote]m just going to leave it for now
10/9/2020 got rid of const1 b/c it was causing issues w/ regard to behavior\
\>", "Text",
 CellChangeTimes->{{3.805027866337372*^9, 3.8050279142431445`*^9}, {
  3.81126029325657*^9, 3.8112603100606813`*^9}}],

Cell["Symbolic", "Text",
 CellChangeTimes->{{3.805458475398411*^9, 3.8054584771563425`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"pPlus2", "[", 
   RowBox[{"e_", ",", "s_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"1", "*", "const2"}], ")"}]}], ")"}], "*", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"p0", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "-", 
     RowBox[{"pTwoA", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "+", 
     RowBox[{"pTwoB", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "-", 
     RowBox[{"pTwoC", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "+", 
     RowBox[{"pTwoD", "[", 
      RowBox[{"e", ",", "s"}], "]"}]}], ")"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8042503993529625`*^9, 3.8042505653888483`*^9}, 
   3.811260312900523*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"pMinus2", "[", 
   RowBox[{"e_", ",", "s_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"const2", "/", "1"}], ")"}], "*", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"p0", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "-", 
     RowBox[{"pTwoA", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "+", 
     RowBox[{"pTwoB", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "+", 
     RowBox[{"pTwoC", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "-", 
     RowBox[{"pTwoD", "[", 
      RowBox[{"e", ",", "s"}], "]"}]}], ")"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.804250597517028*^9, 3.8042506447082243`*^9}, 
   3.805458504844121*^9, 3.811260315943576*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"pPlus2Ltd", "[", 
   RowBox[{"e_", ",", "s_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"1", "*", "const2"}], ")"}]}], ")"}], "*", 
   RowBox[{"(", 
    RowBox[{"0", "-", 
     RowBox[{"pTwoA", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "+", 
     RowBox[{"pTwoB", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "-", 
     RowBox[{"pTwoC", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "+", 
     RowBox[{"pTwoD", "[", 
      RowBox[{"e", ",", "s"}], "]"}]}], ")"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8051122209196835`*^9, 3.8051122276684265`*^9}, 
   3.8112603167132535`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"pMinus2Ltd", "[", 
   RowBox[{"e_", ",", "s_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"const2", "/", "1"}], ")"}], "*", 
   RowBox[{"(", 
    RowBox[{"0", "-", 
     RowBox[{"pTwoA", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "+", 
     RowBox[{"pTwoB", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "+", 
     RowBox[{"pTwoC", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "-", 
     RowBox[{"pTwoD", "[", 
      RowBox[{"e", ",", "s"}], "]"}]}], ")"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.805458364198971*^9, 3.805458371217493*^9}, 
   3.811260318222804*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"pPlus2NP", "[", 
   RowBox[{"e_", ",", "s_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"e", "^", "2"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"3", "/", "2"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"1", "*", "const2"}], ")"}]}], ")"}], "*", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"p0", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "-", 
     RowBox[{"pTwoA", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "+", 
     RowBox[{"pTwoB", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "-", 
     RowBox[{"pTwoC", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "+", 
     RowBox[{"pTwoD", "[", 
      RowBox[{"e", ",", "s"}], "]"}]}], ")"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8042503993529625`*^9, 3.8042505653888483`*^9}, {
   3.8054585847594767`*^9, 3.8054586051447563`*^9}, 3.8112603211198277`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"pMinus2NP", "[", 
   RowBox[{"e_", ",", "s_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"e", "^", "2"}]}], ")"}], "^", 
    RowBox[{"(", 
     RowBox[{"3", "/", "2"}], ")"}]}], "*", 
   RowBox[{"(", 
    RowBox[{"const2", "/", "1"}], ")"}], "*", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"p0", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "-", 
     RowBox[{"pTwoA", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "+", 
     RowBox[{"pTwoB", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "+", 
     RowBox[{"pTwoC", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "-", 
     RowBox[{"pTwoD", "[", 
      RowBox[{"e", ",", "s"}], "]"}]}], ")"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.804250597517028*^9, 3.8042506447082243`*^9}, 
   3.805458504844121*^9, {3.8054585882842417`*^9, 3.80545861372351*^9}, 
   3.811260322930511*^9}],

Cell["Numeric", "Text",
 CellChangeTimes->{{3.805458483187949*^9, 3.8054584849238605`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NpPlus2", "[", 
   RowBox[{"e_", ",", "s_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"1", "*", "const2"}], ")"}]}], ")"}], "*", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Np0", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "-", 
     RowBox[{"NpTwoA", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "+", 
     RowBox[{"NpTwoB", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "-", 
     RowBox[{"NpTwoC", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "+", 
     RowBox[{"NpTwoD", "[", 
      RowBox[{"e", ",", "s"}], "]"}]}], ")"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8042503993529625`*^9, 3.8042505653888483`*^9}, {
   3.804265818224097*^9, 3.8042658582539387`*^9}, 3.8112603253572664`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NpMinus2", "[", 
   RowBox[{"e_", ",", "s_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"const2", "/", "1"}], ")"}], "*", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Np0", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "-", 
     RowBox[{"NpTwoA", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "+", 
     RowBox[{"NpTwoB", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "+", 
     RowBox[{"NpTwoC", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "-", 
     RowBox[{"NpTwoD", "[", 
      RowBox[{"e", ",", "s"}], "]"}]}], ")"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.804250597517028*^9, 3.8042506447082243`*^9}, 
   3.804265819043331*^9, {3.804265849802784*^9, 3.8042658603619843`*^9}, 
   3.8112603273836308`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NpPlus2Ltd", "[", 
   RowBox[{"e_", ",", "s_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"1", "*", "const2"}], ")"}]}], ")"}], "*", 
   RowBox[{"(", 
    RowBox[{"0", "-", 
     RowBox[{"NpTwoA", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "+", 
     RowBox[{"NpTwoB", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "-", 
     RowBox[{"NpTwoC", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "+", 
     RowBox[{"NpTwoD", "[", 
      RowBox[{"e", ",", "s"}], "]"}]}], ")"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8042503993529625`*^9, 3.8042505653888483`*^9}, {
   3.804265818224097*^9, 3.8042658582539387`*^9}, {3.8054585518729987`*^9, 
   3.805458565324188*^9}, 3.8112603285753045`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NpMinus2Ltd", "[", 
   RowBox[{"e_", ",", "s_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"const2", "/", "1"}], ")"}], "*", 
   RowBox[{"(", 
    RowBox[{"0", "-", 
     RowBox[{"NpTwoA", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "+", 
     RowBox[{"NpTwoB", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "+", 
     RowBox[{"NpTwoC", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "-", 
     RowBox[{"NpTwoD", "[", 
      RowBox[{"e", ",", "s"}], "]"}]}], ")"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.804250597517028*^9, 3.8042506447082243`*^9}, 
   3.804265819043331*^9, {3.804265849802784*^9, 3.8042658603619843`*^9}, {
   3.805458556854947*^9, 3.805458569002513*^9}, 3.811260329886806*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NpPlus2NP", "[", 
   RowBox[{"e_", ",", "s_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"e", "^", "2"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"3", "/", "2"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"1", "*", "const2"}], ")"}]}], ")"}], "*", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Np0", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "-", 
     RowBox[{"NpTwoA", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "+", 
     RowBox[{"NpTwoB", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "-", 
     RowBox[{"NpTwoC", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "+", 
     RowBox[{"NpTwoD", "[", 
      RowBox[{"e", ",", "s"}], "]"}]}], ")"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8042705087263603`*^9, 3.8042705123370066`*^9}, {
   3.8042705460567083`*^9, 3.8042705631588335`*^9}, 3.811260334967751*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NpMinus2NP", "[", 
   RowBox[{"e_", ",", "s_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"e", "^", "2"}]}], ")"}], "^", 
     RowBox[{"(", 
      RowBox[{"3", "/", "2"}], ")"}]}], ")"}], "*", 
   RowBox[{"(", 
    RowBox[{"const2", "/", "1"}], ")"}], "*", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Np0", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "-", 
     RowBox[{"NpTwoA", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "+", 
     RowBox[{"NpTwoB", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "+", 
     RowBox[{"NpTwoC", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "-", 
     RowBox[{"NpTwoD", "[", 
      RowBox[{"e", ",", "s"}], "]"}]}], ")"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8045107895808163`*^9, 3.804510807983709*^9}, 
   3.8112603376746635`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NpPlus2NPLtd", "[", 
   RowBox[{"e_", ",", "s_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"e", "^", "2"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"3", "/", "2"}], ")"}]}], "/", 
     RowBox[{"(", 
      RowBox[{"1", "*", "const2"}], ")"}]}], ")"}], "*", 
   RowBox[{"(", 
    RowBox[{"0", "-", 
     RowBox[{"NpTwoA", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "+", 
     RowBox[{"NpTwoB", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "-", 
     RowBox[{"NpTwoC", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "+", 
     RowBox[{"NpTwoD", "[", 
      RowBox[{"e", ",", "s"}], "]"}]}], ")"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8042705087263603`*^9, 3.8042705123370066`*^9}, {
   3.8042705460567083`*^9, 3.8042705631588335`*^9}, {3.805460062645707*^9, 
   3.8054600752485704`*^9}, 3.811260339336923*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NpMinus2NPLtd", "[", 
   RowBox[{"e_", ",", "s_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"e", "^", "2"}]}], ")"}], "^", 
     RowBox[{"(", 
      RowBox[{"3", "/", "2"}], ")"}]}], ")"}], "*", 
   RowBox[{"(", 
    RowBox[{"const2", "/", "1"}], ")"}], "*", 
   RowBox[{"(", 
    RowBox[{"0", "-", 
     RowBox[{"NpTwoA", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "+", 
     RowBox[{"NpTwoB", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "+", 
     RowBox[{"NpTwoC", "[", 
      RowBox[{"e", ",", "s"}], "]"}], "-", 
     RowBox[{"NpTwoD", "[", 
      RowBox[{"e", ",", "s"}], "]"}]}], ")"}]}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8045107895808163`*^9, 3.804510807983709*^9}, {
   3.8054600688215837`*^9, 3.8054600805000863`*^9}, 3.8112603412175875`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Verifying Values", "Section",
 CellChangeTimes->{{3.8042509111678934`*^9, 3.8042509160723443`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p0", "[", 
  RowBox[{"e", ",", "0"}], "]"}]], "Input",
 CellChangeTimes->{{3.804250978897027*^9, 3.8042509817164106`*^9}}],

Cell[BoxData[
 RowBox[{"ConditionalExpression", "[", 
  RowBox[{
   FractionBox["1", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["e", "2"]}], ")"}], 
     RowBox[{"3", "/", "2"}]]], ",", 
   RowBox[{"e", "<", "1"}]}], "]"}]], "Output",
 CellChangeTimes->{3.804250998578761*^9, 3.8042512998681064`*^9, 
  3.811260369321168*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p0NoPole", "[", 
  RowBox[{"e", ",", "0"}], "]"}]], "Input",
 CellChangeTimes->{{3.804251025443828*^9, 3.804251031301385*^9}, {
  3.8042510804897313`*^9, 3.8042510964978724`*^9}}],

Cell[BoxData[
 RowBox[{"ConditionalExpression", "[", 
  RowBox[{"1", ",", 
   RowBox[{"0", "<", "e", "<", "1"}]}], "]"}]], "Output",
 CellChangeTimes->{{3.8042510362378073`*^9, 3.8042511011945133`*^9}, 
   3.804251307614911*^9, 3.8112603757199287`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pPlus2", "[", 
  RowBox[{"e", ",", "0"}], "]"}]], "Input",
 CellChangeTimes->{{3.8042511050079737`*^9, 3.804251108324895*^9}}],

Cell[BoxData[
 RowBox[{"ConditionalExpression", "[", 
  RowBox[{
   RowBox[{
    FractionBox[
     RowBox[{"5", " ", 
      SuperscriptBox["e", "2"]}], 
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         SuperscriptBox["e", "2"]}], ")"}], 
       RowBox[{"5", "/", "2"}]]}]], "+", 
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["e", "2"]}], ")"}], 
      RowBox[{"3", "/", "2"}]]], "-", 
    FractionBox[
     RowBox[{"2", "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["e", "2"]}]}], 
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         SuperscriptBox["e", "2"]}], ")"}], 
       RowBox[{"5", "/", "2"}]]}]]}], ",", 
   RowBox[{"e", "<", "1"}]}], "]"}]], "Output",
 CellChangeTimes->{3.8042511481739044`*^9, 3.8042513254004025`*^9, 
  3.811260432657257*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"ConditionalExpression", "[", 
   RowBox[{
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       FractionBox[
        RowBox[{"5", " ", 
         SuperscriptBox["e", "2"]}], 
        RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SuperscriptBox["e", "2"]}], ")"}], 
          RowBox[{"5", "/", "2"}]]}]], "+", 
       FractionBox["1", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", 
           SuperscriptBox["e", "2"]}], ")"}], 
         RowBox[{"3", "/", "2"}]]], "-", 
       FractionBox[
        RowBox[{"2", "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["e", "2"]}]}], 
        RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "-", 
            SuperscriptBox["e", "2"]}], ")"}], 
          RowBox[{"5", "/", "2"}]]}]]}], ")"}], " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "2"}], " ", "\[ImaginaryI]"}]], " ", "\[Pi]"}], ",", 
    RowBox[{"0", "<", "e", "<", "1"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.8042511549755917`*^9, 3.804251164229006*^9}, 
   3.8042513392065887`*^9}],

Cell[BoxData[
 RowBox[{"ConditionalExpression", "[", 
  RowBox[{"0", ",", 
   RowBox[{"0", "<", "e", "<", "1"}]}], "]"}]], "Output",
 CellChangeTimes->{3.804251164856419*^9, 3.804251340349527*^9, 
  3.8112604327831483`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"pMinus2", "[", 
   RowBox[{"e", ",", "0"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.8042511746223574`*^9, 3.80425118249205*^9}}],

Cell[BoxData[
 RowBox[{"ConditionalExpression", "[", 
  RowBox[{"0", ",", 
   RowBox[{"e", "<", "1"}]}], "]"}]], "Output",
 CellChangeTimes->{3.8042511966019535`*^9, 3.8042513613220634`*^9, 
  3.8112604617782516`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["p_0s behavior", "Section",
 CellChangeTimes->{{3.805458131978506*^9, 3.8054581378470683`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Np0NoPole", "[", 
    RowBox[{"e", ",", "1"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8042568276925163`*^9, 3.8042568381737823`*^9}, {
  3.8042653935607243`*^9, 3.804265403430563*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
    1.], LineBox[CompressedData["
1:eJwBgQJ+/SFib1JlAgAAACcAAAACAAAA03gmpeOFOD/xFKmramRCP0DQMlj6
GkU/GLGrMXeoTz+5vn5sdyZOP7hb7RjZnFY/5Me88kvZUz84qi/Z8MVdP5KX
GK7us1k/VkgX2PFGYz+vQMSZVudeP56qhex+LWc/UWPJuGGWYT+MhCqYj2Fq
PzrQM7CSGWQ/Sudcklcmbj/Am8M1jRl0P0di8/hBJn4/g4GLeIoZhD9Yj1BW
CCaOP2R07xmJGZQ/UoPCLzAlnj8IlEmh8PGkP9v/HBTdZa8/t9AyR0cerz9J
YJewb063P1iD3NrDi7Q/0LaF25q+vj9vsXMtmPS5P56iYpFCZMM/8pDWyAEB
vz9BgZfJEiDHP8jBxr/PPMI/EQ5o1Akmyz9peUkNWezEPy/LDcNIEs8/wQky
/6xtxz+xkGkj+1nRP6ajxP4aJco/xYm/XrNN0z9AFr2iU67MP2gsbuy2G9U/
LcfcuMYqzz+Ea1gKBdzWP9RAU+6p7tA/PaihR9G82D9sCmvS1TDSP1vAr0fD
d9o/y9hXvQ6O0z+V2KTtQFHcP1NGWOHk5NQ/oJdXK+ka3j82oItXoCTWP3w5
49Dsvt8/sMF/eQsq1j9fAfz8+8XfPyvjc5t2L9Y/HxKYpgrN3z8gJlzfTDrW
P/6R53Em298/C6wsZ/lP1j+OKsPlV/ffP+C3zXZSe9Y/m722FNEX4D9b2cGY
vYDWP8SUKpBUG+A/1vq1uiiG1j9coXvJ1x7gP8s9nv7+kNY/rWh8dd0l4D+2
w26Gq6bWP9pTarHlM+A/MOViqBas1j8NcjkaZzfgP6sGV8qBsdY/ggB0QOg6
4D8m2oc3l7LWP74dgaabO+A/ZBY6YQ==
     "]], LineBox[CompressedData["
1:eJwBAQL+/SFib1JlAgAAAB8AAAACAAAAGswtH7RR2j+fZclOh4PiP0qnANw9
Uto/KP/oo9uD4j8GNz08n1faP+2E/80mh+I/fla2/GFi2j/IyJRBvI3iP22V
qH3nd9o/wPrypOOa4j8qkXGB/c3aP8iIdxlSz+I/pYgDiSl62z/bpxtQSjfj
P/VjWupmu9w/MLz2nQT24z8LRIZSsRfeP3458p3av+Q/fBDlDOFc3z8MIVW0
enflPwy+KwDXTeA/2YEQ9tIm5j89dk/9w/rgP6+1cUul3+Y/nKSMoyOc4T8n
Lzrq5YbnP15VNM0JS+I/nZ3/ck826D+11WWTvvbiP40f8JBu3Og/OcywAuaW
4z+Ju65uzXHpPyBFZvWTROQ/t5rcG5AN6j81NDWRtObkP8Hobrn9mOo/3/KN
yaOF5T9s0v1X9hvrP+wzUYUZMuY/7KU9j4+j6z8m6y3qAdPmP2/Ki0vZG+w/
xCR10nCB5z8ng/2pVpfsP4/U1WNSJOg/RlIFAw4E7T+Mfo0k0SboPwkgSomr
Be0/iihF5U8p6D/rHAysSAftP4V8tGZNLug//2PwxoEK7T97JJNpSDjoP712
l1HvEO0/Z3RQbz5M6D8v/Uq1tx3tPz8Uy3oqdOg/Omitjf027T88voI7qXbo
P1uGWZiOOO0/WGTVq8h36D+F0abvQjntP/8TAnI=
     "]], LineBox[CompressedData["
1:eJwV03lQ1GUYB3DEBEE5vJFBQTREMJcAKRX4omQpSAqCZBKXeSFmaGSgA7Kc
1YZrCuaCRhyLHLEIG+NBLJeBJKKciwMGqMku/H4PihwhSK9/vPPMZ975vTPP
83x/K4KPex3Q1NDQcGfnbbWXlDWkaqkg0CtL9RJz+DVpFhVoq9BuG5Q2yizt
argbqKtCnOzwbvHPHORxPtENBipE6j/3q07h8KA1RH3FWAWvrQ9bzdI5lPgs
ct0QpkK4qUmh1n0OWY2xV/rmqxExW1RgYsFjrM7v9PxqNexLY4d0onj0nFeM
GH41gA3t6R1X7vEYfbhpqVB/ENbzXLq79QlfXzSvjCgfxJF1ljHtnxKWNJob
PvXnsGV7a9+okPDhSOtwYBAHh84hb3ks4bNliR3d+zms/aTFMyyOIDk2cLXj
MAcbrZQBVTxhub78vb9PcPC7XZLelkSw2LnVvSSBA/Xo9qUmE9Y/PJRwtohD
/JDpnsrLhN1thZMmbzhUnrxulVdEiMoNnWjS4BG9ws5gj4xwLWLtuHAmj97E
W0GaxYTJZYXD/bN5hLZa7Np7nSA9WKCWL+BhKDvhoSEnTIzlKXes4RFT6JBh
e5OQaZwrP+PNIyDT0Xl1DeHe4MESgS8P058MY6uYxyosivv28thcsVOwr5aw
Y7+0YFsAj6ZvFvwpukMYLcjJXBjCo0N9VdpfR3BzyhYXRvNw/Cvr29h7hJcB
v4V25fNo31ul6dpGGLk0a33Q7zzOpl0oqmQebzoy9UzGI7PHodGpnTAN22SS
s+9tyoMcOghzzWpkmgoeM0RL/zHrJLzb8/SlZQuP5Svt+x51sXkHWkaEv+Zh
05wW3fOEsO8X0eaJKR5L/ojudH9K8H8wpBOtQSjSNZOUMR9wuSlhEYO2ntTj
h2eEE2Zu5WkGrE9JxXGr5wRRz9HpqpUEp62rLD3UBEWgLF5/B0Er8p3FRkOE
W02h7o9ZDoZ7r22MYC5ztppX5Emo9VuU0MlcaJKT7uFLaDOwEl16wfavlJSK
ggnGbpECnWFC+K6EXt0IQoZdfUzVCMuXwjX30WmC7lyfLxeOEkLXzTiWH0U4
FLXJ+yBz8Nwz49tZjoQJdbu1xwi76sMMvj9HcNULuOA0TrB2+cJJW0qITGp8
8N0Ey5PMeGbHNdZXiFvAbWbz5cp6aQHhv43W9yeZjSa9vD++/vZ9heOZ16yv
G9uOxpcTHP29u0MnCZqrtd73URCaUj8aymGeSqkZXVVNyO4cvN3N/Oqks7CW
7dk2pT94+xShV2B/eWYL4aS6bInhG0LX1Rf+LWyvQvsyY2dmpZ5sVZaS7aVT
IQ5hvj+wpnjLY0KizVhGBXPD58/D5/ey/+rHWpN/me/czd7Ux/Z4zq6pcc40
oTzXtC5Gxeb8rP6UJ/ONxd0iz0F2b6TcGMZcGi/xWkGER7V3apOZi175Gr1g
cz+ffUiVx5y/f9HjylcEtfDi8WrmnObmLDGbY6ngAx0lc8Zm8ZFANpcnVS5b
1MzpxR4CG9bX4a5tnuPMl0znjEyzeuqGePpt/R+Nq5Pj
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{"DefaultBoundaryStyle" -> Automatic, "ScalingFunctions" -> None},
  PlotRange->{{0, 1}, {0., 0.9999999991903356}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.804264747086096*^9, 3.804265405827338*^9, 
  3.804265515069939*^9, 3.811260465818224*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Re", "[", 
      RowBox[{"Np0", "[", 
       RowBox[{"e", ",", "0"}], "]"}], "]"}], ",", 
     RowBox[{"Re", "[", 
      RowBox[{"Np0", "[", 
       RowBox[{"e", ",", "1"}], "]"}], "]"}], ",", 
     RowBox[{"Re", "[", 
      RowBox[{"Np0", "[", 
       RowBox[{"e", ",", "2"}], "]"}], "]"}], ",", 
     RowBox[{"Re", "[", 
      RowBox[{"Np0", "[", 
       RowBox[{"e", ",", "3"}], "]"}], "]"}], ",", 
     RowBox[{"Re", "[", 
      RowBox[{"Np0", "[", 
       RowBox[{"e", ",", "4"}], "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*SubscriptBox[\(p\), \(0, 0\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(0, 1\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(0, 2\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(0, 3\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(0, 4\)]\)\>\""}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", "\"\<Divergence Not Removed\>\""}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.8051969227740726`*^9, 3.8051969581068897`*^9}, {
  3.8054594489204783`*^9, 3.8054594619072833`*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] recursive bisections in \[NoBreak]\\!\\(u\\)\
\[NoBreak] near \[NoBreak]\\!\\({u}\\)\[NoBreak] = \
\[NoBreak]\\!\\({6.\
28318519448951320385675257047976413268819406710008479421958327293`65.\
954589770191}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(1.7695567233744214`*^-13 + \\(\\(4.163336342344337`*^-17\\\\ \
\[ImaginaryI]\\)\\)\\)\[NoBreak] and \
\[NoBreak]\\!\\(1.367876784470429`*^-12\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.805196964450637*^9, 3.8054594748424463`*^9, 
  3.811260466647023*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] recursive bisections in \[NoBreak]\\!\\(u\\)\
\[NoBreak] near \[NoBreak]\\!\\({u}\\)\[NoBreak] = \
\[NoBreak]\\!\\({1.1269007302813904`*^-7}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(\\(\\(-6.591949208711867`*^-16\\)\\) + \
\\(\\(4.163336342344337`*^-16\\\\ \[ImaginaryI]\\)\\)\\)\[NoBreak] and \
\[NoBreak]\\!\\(1.507415993203266`*^-12\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.805196964450637*^9, 3.8054594748424463`*^9, 
  3.8112604667089663`*^9}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{{{}, {}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.368417, 0.506779, 0.709798], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwV1Ac0l98fB3CRlZHN18ieZRQqI59bZBUp9MuIECKFjLKzypb1LdmJIlkp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        "]]}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.880722, 0.611041, 0.142051], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwVk2k41YkfxSXZ9yWuJUs3W0TZovh+K0uKVEaZBtm3KWsaexOpkWVGdpVs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        "]]}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.560181, 0.691569, 0.194885], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwVlXc81fsDxqVklhEiCcfIFtEwzvNpkNzISGjIyEiEREiEXGUl65plRbmV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        "]]}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.922526, 0.385626, 0.209179], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwVl2c8lg8DhUX8ZWVnlJVdRqGh3OdOqJRsLYlsyQoZlcySEUIRygwpkp0t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        "]]}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.528488, 0.470624, 0.701351], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwVV2c01o8flRQqkmTLyIqQQiW+99sgSsmoyPgZmRlFicgosmUlJImQkZmR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        "]]}}}, {
    DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, DisplayFunction :> 
     Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, "ScalingFunctions" -> None}, 
     PlotLabel -> FormBox["\"Divergence Not Removed\"", TraditionalForm], 
     PlotRange -> {{0, 1}, {-1.0822720791091134`*^-16, 12.48936271243782}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}],FormBox[
    FormBox[
     TemplateBox[{
      "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(0, 0\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(0, 1\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(0, 2\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(0, 3\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(0, 4\\)]\\)\""}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #4}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #5}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.368417, 0.506779, 0.709798]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.880722, 0.611041, 0.142051]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.37345400000000006`, 0.461046, 0.12992333333333334`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.560181, 0.691569, 0.194885]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.560181, 0.691569, 0.194885]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.560181, 0.691569, 0.194885], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.6150173333333333, 0.25708400000000003`, 
                    0.13945266666666667`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.922526, 0.385626, 0.209179]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.922526, 0.385626, 0.209179]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.922526, 0.385626, 0.209179], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.3523253333333333, 0.3137493333333333, 
                    0.46756733333333333`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.528488, 0.470624, 0.701351]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.528488, 0.470624, 0.701351]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.528488, 0.470624, 0.701351], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{3.80519699945335*^9, 3.8054595209121556`*^9, 
  3.811260512740672*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"2", "*", "Pi", "*", 
     RowBox[{"p0", "[", 
      RowBox[{"e", ",", "1"}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"e", "^", "2"}]}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"3", "/", "2"}], ")"}]}], ")"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"e", ",", "0", ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.80486830753169*^9, 3.8048683806553345`*^9}, 
   3.804868460337556*^9, {3.8048685952882805`*^9, 3.804868595511749*^9}, 
   3.8048686472099457`*^9, {3.804873045848398*^9, 3.8048730737891445`*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Refine", "::", "fas"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Warning: one or more assumptions evaluated to False. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/fas\\\", \
ButtonNote -> \\\"Refine::fas\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8048737432930417`*^9, 3.811262333316372*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Refine", "::", "fas"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Warning: one or more assumptions evaluated to False. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/fas\\\", \
ButtonNote -> \\\"Refine::fas\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8048737432930417`*^9, 3.8112623333763146`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Refine", "::", "fas"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Warning: one or more assumptions evaluated to False. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/fas\\\", \
ButtonNote -> \\\"Refine::fas\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8048737432930417`*^9, 3.8112623334422536`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \[NoBreak]\\!\\(\\*StyleBox[\\(Refine :: \
fas\\), \\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during this \
calculation. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/stop\\\", ButtonNote -> \
\\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8048737432930417`*^9, 3.8112623334912148`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Integrate", "::", "idiv"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Integral of \[NoBreak]\\!\\(\[ExponentialE]\\^\\(\
\[ImaginaryI]\\\\ \\(\\((u - \\(\\(e\\\\ \
\\(\\(Sin[u]\\)\\)\\)\\))\\)\\)\\)\\/\\((\\(\\(-1\\)\\) + \\(\\(e\\\\ \
\\(\\(Cos[u]\\)\\)\\)\\))\\)\\^2\\)\[NoBreak] does not converge on \[NoBreak]\
\\!\\({0, \\(\\(2\\\\ \[Pi]\\)\\)}\\)\[NoBreak]. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Integrate/idiv\\\", ButtonNote -> \
\\\"Integrate::idiv\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8048737432930417`*^9, 3.811262333972904*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"3", " ", "\[Pi]", " ", "e"}], "-", 
   FractionBox[
    RowBox[{"9", " ", "\[Pi]", " ", 
     SuperscriptBox["e", "3"]}], "8"], "+", 
   FractionBox[
    RowBox[{"9", " ", "\[Pi]", " ", 
     SuperscriptBox["e", "5"]}], "64"], "-", 
   FractionBox[
    RowBox[{"19", " ", "\[Pi]", " ", 
     SuperscriptBox["e", "7"]}], "3072"], "-", 
   FractionBox[
    RowBox[{"133", " ", "\[Pi]", " ", 
     SuperscriptBox["e", "9"]}], "81920"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "e", "]"}], "11"],
    SeriesData[$CellContext`e, 0, {}, 1, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`e, 0, {
   3 Pi, 0, Rational[-9, 8] Pi, 0, Rational[9, 64] Pi, 0, Rational[-19, 3072] 
    Pi, 0, Rational[-133, 81920] Pi}, 1, 11, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.804868367851924*^9, 3.80486839153905*^9}, 
   3.8048684703823*^9, 3.804868549196122*^9, 3.8048686007402196`*^9, 
   3.8048697638237305`*^9, 3.804872733132324*^9, 3.804873066638072*^9, 
   3.804873853293836*^9, 3.811262455402872*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Re", "[", 
      RowBox[{"Np0NoPole", "[", 
       RowBox[{"e", ",", "0"}], "]"}], "]"}], ",", 
     RowBox[{"Re", "[", 
      RowBox[{"Np0NoPole", "[", 
       RowBox[{"e", ",", "1"}], "]"}], "]"}], ",", 
     RowBox[{"Re", "[", 
      RowBox[{"Np0NoPole", "[", 
       RowBox[{"e", ",", "2"}], "]"}], "]"}], ",", 
     RowBox[{"Re", "[", 
      RowBox[{"Np0NoPole", "[", 
       RowBox[{"e", ",", "3"}], "]"}], "]"}], ",", 
     RowBox[{"Re", "[", 
      RowBox[{"Np0NoPole", "[", 
       RowBox[{"e", ",", "4"}], "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*SubscriptBox[\(p\), \(0, 0\)]\)(1-\!\(\*SuperscriptBox[\(e\), \
\(2\)]\)\!\(\*SuperscriptBox[\()\), \(3/2\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(0, \
1\)]\)(1-\!\(\*SuperscriptBox[\(e\), \(2\)]\)\!\(\*SuperscriptBox[\()\), \
\(3/2\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(0, \
2\)]\)(1-\!\(\*SuperscriptBox[\(e\), \(2\)]\)\!\(\*SuperscriptBox[\()\), \
\(3/2\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(0, \
3\)]\)(1-\!\(\*SuperscriptBox[\(e\), \(2\)]\)\!\(\*SuperscriptBox[\()\), \
\(3/2\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(0, \
4\)]\)(1-\!\(\*SuperscriptBox[\(e\), \(2\)]\)\!\(\*SuperscriptBox[\()\), \
\(3/2\)]\)\>\""}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", "\"\<Divergence Removed\>\""}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.8063233488516035`*^9, 3.806323398730692*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] recursive bisections in \[NoBreak]\\!\\(u\\)\
\[NoBreak] near \[NoBreak]\\!\\({u}\\)\[NoBreak] = \
\[NoBreak]\\!\\({1.1269007302813904`*^-7}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(1.7655321649101552`*^-13 + \\(\\(6.938893903907228`*^-16\\\\ \
\[ImaginaryI]\\)\\)\\)\[NoBreak] and \[NoBreak]\\!\\(1.3677552771139446`*^-12\
\\)\[NoBreak] for the integral and error estimates. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.806323402309922*^9, 3.8112624571699753`*^9, 
  3.814275061436864*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "slwcon"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Numerical integration converging too slowly; suspect one \
of the following: singularity, value of the integration is 0, highly \
oscillatory integrand, or WorkingPrecision too small. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/slwcon\\\", ButtonNote -> \
\\\"NIntegrate::slwcon\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.806323402309922*^9, 3.8112624571699753`*^9, 
  3.8142750615097904`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] recursive bisections in \[NoBreak]\\!\\(u\\)\
\[NoBreak] near \[NoBreak]\\!\\({u}\\)\[NoBreak] = \
\[NoBreak]\\!\\({4.700019483074162`}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(\\(\\(-6.522560269672795`*^-16\\)\\) - \
\\(\\(2.940356291780688`*^-16\\\\ \[ImaginaryI]\\)\\)\\)\[NoBreak] and \
\[NoBreak]\\!\\(1.1433377659527205`*^-15\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.806323402309922*^9, 3.8112624571699753`*^9, 
  3.814275061555812*^9}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{{{}, {}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.368417, 0.506779, 0.709798], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJxF1A1Qk3UYAPANMEE+JC+hUZoQeITMCBQPUx9KhAOFFCSoI1wSGGbyIXaN
8AoR5FPkILJEDx1+tDg+bAQVML5OELYD5gaIi7ExvrYxkDm8AkbQ++zfe/fe
/3733P/jfZ7n/zqeTAiNNaHRaKzVd20Mip3qb5kOP7COtvbMQUZ63te5jEtg
9Gcps4wcRgmYoPeGvLezznATNCtrzyyYlwTemntWATw0y/PA89fMuXAWXd/n
GRCwtRoOoYf1e/nnrB8AFx2ZIR1uz+PBL8b9HFzNdvrWw7IJ5YTac8xrz38H
xXrKHo4ui4LURthiS3n+6kAXnc6HbhvK29YxQu+PtJDzd7U+5PfuawMz9LUt
2XElJe0kHs8OtP5I00HirRaeK5VfdoIpmvfhoiHmURes4HnvcjoMDi7dsIjW
SVuO1sf3wALa167pdliVgOTnN62AWaARggLN7JQ2PHTrBRF6t4h156X3+6AJ
LfYN0/6s7QMOutzlxCi/sB+y0Gc2fCGSeIjgFLosSR6QLBOBL7pnKKLJ5spj
sEMXbozsZfuIYc5AOcw/Uq5UikGC9tMllbVdkoAA7V2eF1HuPABKdF7vxlIz
0QDswfVGDcXiz78dBC36ZMU7jeA4BLmYr/HAXo5d+xCw6ZS7kwZtUpKfgJUp
5ZofZex+x2HYV+lmWJvvVpSUviwcBo05Fb+TbZrzVupTUFtTDl6o8ulykMKe
DZT1MR+r4v6UwnWsN+144tb8+L9IvSz9skJr7UeI/bh1bwf+MULqm2Y7biWP
kpH6B/nfzApYkpG4VfMO2mDwKPH+rz5Ybv9nlKxXVpHPebNMTrycxmoo1cmB
jo4O3yW0OKyAJcxP7uZgD2W5gvRHnSS2uHlBQfL34qjlYZH/GCjRPoIak4nS
MRhAV2ZbLjXOjEEretuhOH2xn5L0B7cx+GDF90rIMPbTrt1FvAklRBn3L/6U
6e49Du5o2XzBI07mOMxjfeOKE+6NPB2HGrTG61gmw3MCktE5hfz6gosTEILe
rmaq6I8nIAKtv3ws2sdtEp6gO5zPixLTJ2E75oOb5nJdLpqEn7AfCsWSmFDn
KYgxowyv9KS6pUxBiAXl2bCWIpOOKVBhP/SJT6tuOEzDM7zvD8I3H/RJmoa/
jd9fdGTOum2a5JcjzLih2KQiFgYl5qee/t8vOqO+2dSmIvM17lcaXn5VDTpj
fxfx9bZn1aBGq2svXA5sVpP7utD/LuOijQbuo728qjUXYjUQgk4scWphN2rg
V2M+apymqqxnwB5tL3SyVUbPgLexXv2nsr6rmgGqIecgTFK59Lphhpz3tsM9
XtpxLem3+RO3zki5WrBER7Jc2ecXteCK5rOqM22OrN77JWr+Dt9P9q+/u/pf
wfV+eMNSvzZm6q7+538BZTlOTQ==
        "]]}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.880722, 0.611041, 0.142051], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwV03s0VXkbB3CXboSk65EJpVNR8UrmJXx1FVLuuhiJKCWm1DRMi0FUQ2hU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        "]]}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.560181, 0.691569, 0.194885], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwVlXk01esXxsU1lLHxIhFxXGUMt65yHtxopEimEInMJUOmWxkbDAmRoZKT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        "]]}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.922526, 0.385626, 0.209179], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwV1mc81m8bBnCjMlMRIUVCVEaiv4zfIVqKFAoVEZGMIikq3BkllBVChOw9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        "]]}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.528488, 0.470624, 0.701351], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwVl3c41m8bxhGloomQjJJSSCRSvqeUMiubXyojo4xskUL2zIqKMh5UdpQt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        "]]}}}, {
    DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, DisplayFunction :> 
     Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, "ScalingFunctions" -> None}, 
     PlotLabel -> FormBox["\"Divergence Removed\"", TraditionalForm], 
     PlotRange -> {{0, 1}, {-1.358361895208377*^-16, 1.000000000000963}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}],FormBox[
    FormBox[
     TemplateBox[{
      "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(0, \
0\\)]\\)(1-\\!\\(\\*SuperscriptBox[\\(e\\), \
\\(2\\)]\\)\\!\\(\\*SuperscriptBox[\\()\\), \\(3/2\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(0, \
1\\)]\\)(1-\\!\\(\\*SuperscriptBox[\\(e\\), \
\\(2\\)]\\)\\!\\(\\*SuperscriptBox[\\()\\), \\(3/2\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(0, \
2\\)]\\)(1-\\!\\(\\*SuperscriptBox[\\(e\\), \
\\(2\\)]\\)\\!\\(\\*SuperscriptBox[\\()\\), \\(3/2\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(0, \
3\\)]\\)(1-\\!\\(\\*SuperscriptBox[\\(e\\), \
\\(2\\)]\\)\\!\\(\\*SuperscriptBox[\\()\\), \\(3/2\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(0, \
4\\)]\\)(1-\\!\\(\\*SuperscriptBox[\\(e\\), \
\\(2\\)]\\)\\!\\(\\*SuperscriptBox[\\()\\), \\(3/2\\)]\\)\""}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #4}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #5}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.368417, 0.506779, 0.709798]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.880722, 0.611041, 0.142051]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.37345400000000006`, 0.461046, 0.12992333333333334`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.560181, 0.691569, 0.194885]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.560181, 0.691569, 0.194885]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.560181, 0.691569, 0.194885], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.6150173333333333, 0.25708400000000003`, 
                    0.13945266666666667`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.922526, 0.385626, 0.209179]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.922526, 0.385626, 0.209179]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.922526, 0.385626, 0.209179], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.3523253333333333, 0.3137493333333333, 
                    0.46756733333333333`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.528488, 0.470624, 0.701351]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.528488, 0.470624, 0.701351]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.528488, 0.470624, 0.701351], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{3.8063234155720525`*^9, 3.8112624803705807`*^9, 
  3.8142750730685987`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Chebysehv", "Subsubsection",
 CellChangeTimes->{{3.806323286324854*^9, 3.806323287980101*^9}}],

Cell["\<\
I mean, if it does work well then that will be convenient later\
\>", "Text",
 CellChangeTimes->{{3.8063232912389984`*^9, 3.8063233067667084`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Zc1", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Re", "[", 
     RowBox[{
      FractionBox["2", "\[Pi]"], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"NIntegrate", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Np0NoPole", "[", 
            RowBox[{"x", ",", "1"}], "]"}], "*", 
           FractionBox[
            RowBox[{"ChebyshevT", "[", 
             RowBox[{"n", ",", "x"}], "]"}], 
            SqrtBox[
             RowBox[{"1", "-", 
              SuperscriptBox["x", "2"]}]]]}], ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
          RowBox[{"PrecisionGoal", "\[Rule]", "2"}]}], "]"}], "-", 
        RowBox[{"NIntegrate", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Np0NoPole", "[", 
            RowBox[{
             RowBox[{"-", "x"}], ",", "1"}], "]"}], "*", 
           FractionBox[
            RowBox[{"ChebyshevT", "[", 
             RowBox[{"n", ",", "x"}], "]"}], 
            SqrtBox[
             RowBox[{"1", "-", 
              SuperscriptBox["x", "2"]}]]]}], ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", 
            RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
          RowBox[{"PrecisionGoal", "\[Rule]", "2"}]}], "]"}]}], ")"}]}], 
     "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.806323312620392*^9, 3.806323325729785*^9}, {
  3.8063234341475983`*^9, 3.8063234477655926`*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "inumr"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"The integrand \[NoBreak]\\!\\(\\(\[ExponentialE]\\^\\(\
\[ImaginaryI]\\\\ \\(\\((u - \\(\\(x\\\\ \\(\\(Sin[u]\\)\\)\\)\\))\\)\\)\\)\\\
\\ \\((1 - x\\^2)\\)\\^\\(3/2\\)\\)\\/\\((1 - \\(\\(x\\\\ \
\\(\\(Cos[u]\\)\\)\\)\\))\\)\\^2\\)\[NoBreak] has evaluated to non-numerical \
values for all sampling points in the region with boundaries \
\[NoBreak]\\!\\({\\({0, 6.283185307179586`}\\)}\\)\[NoBreak]. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/NIntegrate/inumr\\\", \
ButtonNote -> \\\"NIntegrate::inumr\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8063234636319995`*^9, 3.81126248070063*^9, 
  3.814275098093593*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "inumr"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"The integrand \[NoBreak]\\!\\(\\(\[ExponentialE]\\^\\(\
\[ImaginaryI]\\\\ \\(\\((u - \\(\\(x\\\\ \\(\\(Sin[u]\\)\\)\\)\\))\\)\\)\\)\\\
\\ \\((1 - x\\^2)\\)\\^\\(3/2\\)\\)\\/\\((1 - \\(\\(x\\\\ \
\\(\\(Cos[u]\\)\\)\\)\\))\\)\\^2\\)\[NoBreak] has evaluated to non-numerical \
values for all sampling points in the region with boundaries \
\[NoBreak]\\!\\({\\({0, 6.283185307179586`}\\)}\\)\[NoBreak]. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/NIntegrate/inumr\\\", \
ButtonNote -> \\\"NIntegrate::inumr\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8063234636319995`*^9, 3.81126248070063*^9, 
  3.814275098132559*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "inumr"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"The integrand \[NoBreak]\\!\\(\\(\[ExponentialE]\\^\\(\
\[ImaginaryI]\\\\ \\(\\((u - \\(\\(x\\\\ \\(\\(Sin[u]\\)\\)\\)\\))\\)\\)\\)\\\
\\ \\((1 - x\\^2)\\)\\^\\(3/2\\)\\)\\/\\((1 - \\(\\(x\\\\ \
\\(\\(Cos[u]\\)\\)\\)\\))\\)\\^2\\)\[NoBreak] has evaluated to non-numerical \
values for all sampling points in the region with boundaries \
\[NoBreak]\\!\\({\\({0, 6.283185307179586`}\\)}\\)\[NoBreak]. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/NIntegrate/inumr\\\", \
ButtonNote -> \\\"NIntegrate::inumr\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8063234636319995`*^9, 3.81126248070063*^9, 
  3.8142750981785154`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \
\[NoBreak]\\!\\(\\*StyleBox[\\(NIntegrate :: inumr\\), \
\\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during this calculation. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/stop\\\", \
ButtonNote -> \\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8063234636319995`*^9, 3.81126248070063*^9, 
  3.8142750985455904`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] recursive bisections in \[NoBreak]\\!\\(x\\)\
\[NoBreak] near \[NoBreak]\\!\\({x}\\)\[NoBreak] = \
\[NoBreak]\\!\\({0.\
99999998148123782572526190025430478831858227550810624961741268635`65.\
954589770191}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(\\(\\(-0.0004373798525546619`\\)\\) + \
\\(\\(4.112762758606063`*^-15\\\\ \[ImaginaryI]\\)\\)\\)\[NoBreak] and \
\[NoBreak]\\!\\(7.012191633141564`*^-6\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8063234636319995`*^9, 3.81126248070063*^9, 
  3.814275140580612*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] recursive bisections in \[NoBreak]\\!\\(x\\)\
\[NoBreak] near \[NoBreak]\\!\\({x}\\)\[NoBreak] = \
\[NoBreak]\\!\\({\\(-0.\
99999998148123782572526190025430478831858227550810624961741268635`65.\
954589770191\\)}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(\\(\\(0.0004373798525546619` \[VeryThinSpace]\\)\\) - \
\\(\\(4.112762758606063`*^-15\\\\ \[ImaginaryI]\\)\\)\\)\[NoBreak] and \
\[NoBreak]\\!\\(7.012191633134625`*^-6\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8063234636319995`*^9, 3.81126248070063*^9, 
  3.8142751484665456`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] recursive bisections in \[NoBreak]\\!\\(x\\)\
\[NoBreak] near \[NoBreak]\\!\\({x}\\)\[NoBreak] = \
\[NoBreak]\\!\\({0.\
99999998118326507805163705891701481261180095572171921958215534687`65.\
954589770191}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(\\(\\(-0.0002295818303110502`\\)\\) + \
\\(\\(7.694544576611617`*^-15\\\\ \[ImaginaryI]\\)\\)\\)\[NoBreak] and \
\[NoBreak]\\!\\(4.843510575015782`*^-6\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8063234636319995`*^9, 3.81126248070063*^9, 
  3.8142751606702366`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \
\[NoBreak]\\!\\(\\*StyleBox[\\(NIntegrate :: ncvb\\), \\\"MessageName\\\"]\\)\
\[NoBreak] will be suppressed during this calculation. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/stop\\\", \
ButtonNote -> \\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8063234636319995`*^9, 3.81126248070063*^9, 
  3.8142751607022057`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1.4135798584282297`*^-16"}], ",", "1.1185833876936992`", ",", 
   RowBox[{"-", "3.533949646070574`*^-17"}], ",", 
   RowBox[{"-", "0.12105272122275804`"}], ",", 
   RowBox[{"-", "1.766974823035287`*^-17"}], ",", "0.003184038388699598`", 
   ",", 
   RowBox[{"-", "1.766974823035287`*^-17"}], ",", 
   RowBox[{"-", "0.0005568893243430304`"}], ",", 
   RowBox[{"-", "3.975693351829396`*^-17"}], ",", 
   RowBox[{"-", "0.0002923126651047246`"}], ",", "1.766974823035287`*^-17"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.80632354140171*^9, 3.8112625714453983`*^9, 
  3.8142751741187744`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", " ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Re", "[", 
      RowBox[{"Np0NoPole", "[", 
       RowBox[{"x", ",", "1"}], "]"}], "]"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        RowBox[{"First", "[", "Zc1", "]"}]}], "/", "2"}], "+", 
      RowBox[{"Evaluate", "[", 
       RowBox[{"Zc1", " ", ".", " ", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"ChebyshevT", "[", 
           RowBox[{
            RowBox[{"n", "-", "1"}], ",", "x"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", 
            RowBox[{"Length", "[", "Zc1", "]"}]}], "}"}]}], "]"}]}], 
       "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.806323583269031*^9, 3.8063236006890554`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
    1.], LineBox[CompressedData["
1:eJwV03s0VXkbB3CXboSk65EJpVNR8UrmJXx1FVLuuhiJKCWm1DRMi0FUQ2hU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     "]]}, 
   {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
    1.], LineBox[CompressedData["
1:eJwV03s4VFsfB3DxlkpJTqUZd0nHkS5KF6d8VcollyLp9pZcQklJKqWUQq4p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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{"DefaultBoundaryStyle" -> Automatic, "ScalingFunctions" -> None},
  PlotRange->{{0, 1}, {0., 0.9999999991903356}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.8063236049516115`*^9, 3.8112625729774914`*^9, 
  3.81427517598961*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Zc2", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Re", "[", 
     RowBox[{
      FractionBox["2", "\[Pi]"], "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"NIntegrate", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Np0NoPole", "[", 
            RowBox[{"x", ",", "2"}], "]"}], "*", 
           FractionBox[
            RowBox[{"ChebyshevT", "[", 
             RowBox[{"n", ",", "x"}], "]"}], 
            SqrtBox[
             RowBox[{"1", "-", 
              SuperscriptBox["x", "2"]}]]]}], ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
          RowBox[{"PrecisionGoal", "\[Rule]", "2"}]}], "]"}], "-", 
        RowBox[{"NIntegrate", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Np0NoPole", "[", 
            RowBox[{
             RowBox[{"-", "x"}], ",", "2"}], "]"}], "*", 
           FractionBox[
            RowBox[{"ChebyshevT", "[", 
             RowBox[{"n", ",", "x"}], "]"}], 
            SqrtBox[
             RowBox[{"1", "-", 
              SuperscriptBox["x", "2"]}]]]}], ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", 
            RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
          RowBox[{"PrecisionGoal", "\[Rule]", "2"}]}], "]"}]}], ")"}]}], 
     "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.806323672202285*^9, 3.806323680181575*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "inumr"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"The integrand \
\[NoBreak]\\!\\(\\(\[ExponentialE]\\^\\(2\\\\ \[ImaginaryI]\\\\ \\(\\((u - \
\\(\\(x\\\\ \\(\\(Sin[u]\\)\\)\\)\\))\\)\\)\\)\\\\ \\((1 - x\\^2)\\)\\^\\(3/2\
\\)\\)\\/\\((1 - \\(\\(x\\\\ \\(\\(Cos[u]\\)\\)\\)\\))\\)\\^2\\)\[NoBreak] \
has evaluated to non-numerical values for all sampling points in the region \
with boundaries \[NoBreak]\\!\\({\\({0, 6.283185307179586`}\\)}\\)\[NoBreak]. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/NIntegrate/inumr\\\", \
ButtonNote -> \\\"NIntegrate::inumr\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8063237222436085`*^9, 3.8112625730602365`*^9, 
  3.814275176077297*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "inumr"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"The integrand \
\[NoBreak]\\!\\(\\(\[ExponentialE]\\^\\(2\\\\ \[ImaginaryI]\\\\ \\(\\((u - \
\\(\\(x\\\\ \\(\\(Sin[u]\\)\\)\\)\\))\\)\\)\\)\\\\ \\((1 - x\\^2)\\)\\^\\(3/2\
\\)\\)\\/\\((1 - \\(\\(x\\\\ \\(\\(Cos[u]\\)\\)\\)\\))\\)\\^2\\)\[NoBreak] \
has evaluated to non-numerical values for all sampling points in the region \
with boundaries \[NoBreak]\\!\\({\\({0, 6.283185307179586`}\\)}\\)\[NoBreak]. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/NIntegrate/inumr\\\", \
ButtonNote -> \\\"NIntegrate::inumr\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8063237222436085`*^9, 3.8112625730602365`*^9, 
  3.814275176122261*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "inumr"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"The integrand \
\[NoBreak]\\!\\(\\(\[ExponentialE]\\^\\(2\\\\ \[ImaginaryI]\\\\ \\(\\((u - \
\\(\\(x\\\\ \\(\\(Sin[u]\\)\\)\\)\\))\\)\\)\\)\\\\ \\((1 - x\\^2)\\)\\^\\(3/2\
\\)\\)\\/\\((1 - \\(\\(x\\\\ \\(\\(Cos[u]\\)\\)\\)\\))\\)\\^2\\)\[NoBreak] \
has evaluated to non-numerical values for all sampling points in the region \
with boundaries \[NoBreak]\\!\\({\\({0, 6.283185307179586`}\\)}\\)\[NoBreak]. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/NIntegrate/inumr\\\", \
ButtonNote -> \\\"NIntegrate::inumr\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8063237222436085`*^9, 3.8112625730602365`*^9, 
  3.8142751761622195`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \
\[NoBreak]\\!\\(\\*StyleBox[\\(NIntegrate :: inumr\\), \
\\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during this calculation. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/stop\\\", \
ButtonNote -> \\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8063237222436085`*^9, 3.8112625730602365`*^9, 
  3.814275176201187*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] recursive bisections in \[NoBreak]\\!\\(x\\)\
\[NoBreak] near \[NoBreak]\\!\\({x}\\)\[NoBreak] = \
\[NoBreak]\\!\\({0.\
99999998148123782572526190025430478831858227550810624961741268635`65.\
954589770191}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(\\(\\(-0.0005938990022790599`\\)\\) - \
\\(\\(9.947992083087819`*^-16\\\\ \[ImaginaryI]\\)\\)\\)\[NoBreak] and \
\[NoBreak]\\!\\(7.033154232043879`*^-6\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8063237222436085`*^9, 3.8112625730602365`*^9, 
  3.814275222703094*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] recursive bisections in \[NoBreak]\\!\\(x\\)\
\[NoBreak] near \[NoBreak]\\!\\({x}\\)\[NoBreak] = \
\[NoBreak]\\!\\({\\(-0.\
99999998148123782572526190025430478831858227550810624961741268635`65.\
954589770191\\)}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(\\(\\(-0.0005938990022790877`\\)\\) - \
\\(\\(9.947992083087817`*^-16\\\\ \[ImaginaryI]\\)\\)\\)\[NoBreak] and \
\[NoBreak]\\!\\(7.03315423203694`*^-6\\)\[NoBreak] for the integral and error \
estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\
\\\", ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\
\", ButtonNote -> \\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8063237222436085`*^9, 3.8112625730602365`*^9, 
  3.81427522966864*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] recursive bisections in \[NoBreak]\\!\\(x\\)\
\[NoBreak] near \[NoBreak]\\!\\({x}\\)\[NoBreak] = \
\[NoBreak]\\!\\({0.\
99999998118326507805163705891701481261180095572171921958215534687`65.\
954589770191}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(\\(\\(-0.00022673135678407107`\\)\\) - \
\\(\\(7.910011250873007`*^-16\\\\ \[ImaginaryI]\\)\\)\\)\[NoBreak] and \
\[NoBreak]\\!\\(6.878853382899465`*^-6\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8063237222436085`*^9, 3.8112625730602365`*^9, 
  3.8142752407523637`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \
\[NoBreak]\\!\\(\\*StyleBox[\\(NIntegrate :: ncvb\\), \\\"MessageName\\\"]\\)\
\[NoBreak] will be suppressed during this calculation. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/stop\\\", \
ButtonNote -> \\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8063237222436085`*^9, 3.8112625730602365`*^9, 
  3.8142752407963257`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "7.067899292141149`*^-17"}], ",", "1.028407868226908`", ",", 
   "0.`", ",", "0.030296241764091885`", ",", "0.`", ",", 
   RowBox[{"-", "0.07604681846604443`"}], ",", 
   RowBox[{"-", "1.766974823035287`*^-17"}], ",", "0.024291693596887886`", 
   ",", "1.766974823035287`*^-17", ",", 
   RowBox[{"-", "0.009911263401888314`"}], ",", "0.`"}], "}"}]], "Output",
 CellChangeTimes->{3.806323801477196*^9, 3.811262679590665*^9, 
  3.8142752472313595`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", " ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Re", "[", 
      RowBox[{"Np0NoPole", "[", 
       RowBox[{"x", ",", "2"}], "]"}], "]"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        RowBox[{"First", "[", "Zc2", "]"}]}], "/", "2"}], "+", 
      RowBox[{"Evaluate", "[", 
       RowBox[{"Zc2", " ", ".", " ", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"ChebyshevT", "[", 
           RowBox[{
            RowBox[{"n", "-", "1"}], ",", "x"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", 
            RowBox[{"Length", "[", "Zc2", "]"}]}], "}"}]}], "]"}]}], 
       "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.806323832597313*^9, 3.806323839597243*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
    1.], LineBox[CompressedData["
1:eJwVlXk01esXxsU1lLHxIhFxXGUMt65yHtxopEimEInMJUOmWxkbDAmRoZKT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     "]]}, 
   {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
    1.], LineBox[CompressedData["
1:eJwV1Hk8VekfB3BLk0qrQa4pJKQakaRM5UORkSWubNVIdqVN9KMaLSL7ElKo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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{"DefaultBoundaryStyle" -> Automatic, "ScalingFunctions" -> None},
  PlotRange->{{0, 1}, {0., 0.9999999991891096}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.8063238426390705`*^9, 3.811262681729639*^9, 
  3.8142752492680626`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell["p_+/-2s behavior", "Section",
 CellChangeTimes->{{3.8054581533195257`*^9, 3.805458162279744*^9}}],

Cell[CellGroupData[{

Cell[TextData[StyleBox["What do these things do without the p_0s?", \
"Subsection"]], "Section",
 CellChangeTimes->{{3.8049538816291246`*^9, 3.8049538975434093`*^9}, {
  3.804954043742614*^9, 3.804954043856517*^9}}],

Cell["i did not make a mistake i thought i made, sweet", "Text",
 CellChangeTimes->{{3.804953913922624*^9, 3.80495393183086*^9}, {
  3.8049540338510437`*^9, 3.8049540406785684`*^9}}],

Cell[CellGroupData[{

Cell[TextData[StyleBox["W/o the factor", "Subsubsection"]], "Subsection",
 CellChangeTimes->{{3.8050252884611263`*^9, 3.805025290748004*^9}}],

Cell["hi", "Text",
 CellChangeTimes->{{3.805025304287435*^9, 3.805025304465273*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Re", "[", 
      RowBox[{"NpPlus2Ltd", "[", 
       RowBox[{"e", ",", "0"}], "]"}], "]"}], ",", 
     RowBox[{"Re", "[", 
      RowBox[{"NpPlus2Ltd", "[", 
       RowBox[{"e", ",", "1"}], "]"}], "]"}], ",", 
     RowBox[{"Re", "[", 
      RowBox[{"NpPlus2Ltd", "[", 
       RowBox[{"e", ",", "2"}], "]"}], "]"}], ",", 
     RowBox[{"Re", "[", 
      RowBox[{"NpPlus2Ltd", "[", 
       RowBox[{"e", ",", "3"}], "]"}], "]"}], ",", 
     RowBox[{"Re", "[", 
      RowBox[{"NpPlus2Ltd", "[", 
       RowBox[{"e", ",", "4"}], "]"}], "]"}], ",", 
     RowBox[{"Re", "[", 
      RowBox[{"NpPlus2Ltd", "[", 
       RowBox[{"e", ",", "10"}], "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*SubscriptBox[\(p\), \(\(+2\), \
0\)]\)-\!\(\*SubscriptBox[\(p\), \(0, 0\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(\(+2\), \
1\)]\)-\!\(\*SubscriptBox[\(p\), \(0, 1\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(\(+2\), \
2\)]\)-\!\(\*SubscriptBox[\(p\), \(0, 2\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(\(+2\), \
3\)]\)-\!\(\*SubscriptBox[\(p\), \(0, 3\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(\(+2\), \
4\)]\)-\!\(\*SubscriptBox[\(p\), \(0, 4\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(\(+2\), 10\)]\)-\!\(\*SubscriptBox[\(p\
\), \(0, 10\)]\)\>\""}], "}"}]}], ",", 
   RowBox[{
   "PlotLabel", "\[Rule]", 
    "\"\<\!\(\*SubscriptBox[\(p\), \(\(+2\), s\)]\)-\!\(\*SubscriptBox[\(p\), \
\(0, s\)]\)\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.805036875569254*^9, {3.8050369437035904`*^9, 3.8050369442308836`*^9}, {
   3.8050369785019803`*^9, 3.8050370412833834`*^9}, {3.805459577737806*^9, 
   3.805459670989234*^9}, {3.805459713580452*^9, 3.8054598122368937`*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] recursive bisections in \[NoBreak]\\!\\(u\\)\
\[NoBreak] near \[NoBreak]\\!\\({u}\\)\[NoBreak] = \
\[NoBreak]\\!\\({0.000024185766477748702`}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(-2.49366499671666`*^-16\\)\[NoBreak] and \
\[NoBreak]\\!\\(1.5939906358846744`*^-15\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8050370691434174`*^9, 3.8054598287971773`*^9, 
  3.811262683137398*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "slwcon"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Numerical integration converging too slowly; suspect one \
of the following: singularity, value of the integration is 0, highly \
oscillatory integrand, or WorkingPrecision too small. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/slwcon\\\", ButtonNote -> \
\\\"NIntegrate::slwcon\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8050370691434174`*^9, 3.8054598287971773`*^9, 
  3.8112626832188473`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] recursive bisections in \[NoBreak]\\!\\(u\\)\
\[NoBreak] near \[NoBreak]\\!\\({u}\\)\[NoBreak] = \
\[NoBreak]\\!\\({4.503669942224799`}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(1.734723475976807`*^-17\\)\[NoBreak] and \
\[NoBreak]\\!\\(3.820404467573641`*^-16\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8050370691434174`*^9, 3.8054598287971773`*^9, 
  3.8112626832593384`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] recursive bisections in \[NoBreak]\\!\\(u\\)\
\[NoBreak] near \[NoBreak]\\!\\({u}\\)\[NoBreak] = \
\[NoBreak]\\!\\({5.325883644531503`}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(4.8452214462813`*^-13 + \\(\\(2.185751579730777`*^-16\\\\ \
\[ImaginaryI]\\)\\)\\)\[NoBreak] and \
\[NoBreak]\\!\\(1.046037959204861`*^-15\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8050370691434174`*^9, 3.8054598287971773`*^9, 
  3.811262683421387*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \
\[NoBreak]\\!\\(\\*StyleBox[\\(NIntegrate :: ncvb\\), \\\"MessageName\\\"]\\)\
\[NoBreak] will be suppressed during this calculation. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/stop\\\", \
ButtonNote -> \\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8050370691434174`*^9, 3.8054598287971773`*^9, 
  3.811262683461739*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "slwcon"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Numerical integration converging too slowly; suspect one \
of the following: singularity, value of the integration is 0, highly \
oscillatory integrand, or WorkingPrecision too small. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/slwcon\\\", ButtonNote -> \
\\\"NIntegrate::slwcon\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8050370691434174`*^9, 3.8054598287971773`*^9, 
  3.811262683714438*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "slwcon"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Numerical integration converging too slowly; suspect one \
of the following: singularity, value of the integration is 0, highly \
oscillatory integrand, or WorkingPrecision too small. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/slwcon\\\", ButtonNote -> \
\\\"NIntegrate::slwcon\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8050370691434174`*^9, 3.8054598287971773`*^9, 
  3.811262683823578*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \
\[NoBreak]\\!\\(\\*StyleBox[\\(NIntegrate :: slwcon\\), \
\\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during this calculation. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/stop\\\", \
ButtonNote -> \\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8050370691434174`*^9, 3.8054598287971773`*^9, 
  3.811262683856004*^9}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{{{}, {}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.368417, 0.506779, 0.709798], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwV1Ak0VtsXAHDx9BEyy6fMs4xFg2QTSYoUXqREhSghQ6aUKTMlvlJmJeQh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        "]]}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.880722, 0.611041, 0.142051], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwVTnk4lQkflbJFlmvp3kSWy2BCRX1Zfy2WrBVJ06Oyk7FlaSQyWWqyNNlH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        "]]}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.560181, 0.691569, 0.194885], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwV1Ak0lPsbB3BxlZBrz4x9TLZCZSvk4SbJlqIsqWvJEiqlxVLKehMpTHOz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        "]]}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.922526, 0.385626, 0.209179], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwV13k8VN8bB3CJUvYlIRRflTXZCsUnLbZSEqVCWYsiUYhUhGSpREpSkqSS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        "]]}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.528488, 0.470624, 0.701351], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwVl3k0Ve8XxqWSSJkSQuahhERJ5amUKERECqGkJJkqQyJzQhKKFFFI0mBI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        "]]}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.772079, 0.431554, 0.102387], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwVl3c8le8bxyXZFUJ2trK/QsJ5LkIhI6usZCdkZWRlRJS9t4SsKGQl49h7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        "]]}}}, {
    DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, DisplayFunction :> 
     Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, "ScalingFunctions" -> None}, 
     PlotLabel -> 
     FormBox["\"\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(+2\\), \
s\\)]\\)-\\!\\(\\*SubscriptBox[\\(p\\), \\(0, s\\)]\\)\"", TraditionalForm], 
     PlotRange -> {{0, 1}, {-12.859647664883504`, 1.4258985419233414`}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}],FormBox[
    FormBox[
     TemplateBox[{
      "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(+2\\), \
0\\)]\\)-\\!\\(\\*SubscriptBox[\\(p\\), \\(0, 0\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(+2\\), \
1\\)]\\)-\\!\\(\\*SubscriptBox[\\(p\\), \\(0, 1\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(+2\\), \
2\\)]\\)-\\!\\(\\*SubscriptBox[\\(p\\), \\(0, 2\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(+2\\), \
3\\)]\\)-\\!\\(\\*SubscriptBox[\\(p\\), \\(0, 3\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(+2\\), \
4\\)]\\)-\\!\\(\\*SubscriptBox[\\(p\\), \\(0, 4\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(+2\\), \
10\\)]\\)-\\!\\(\\*SubscriptBox[\\(p\\), \\(0, 10\\)]\\)\""}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #4}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #5}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #6}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.368417, 0.506779, 0.709798]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.880722, 0.611041, 0.142051]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.37345400000000006`, 0.461046, 0.12992333333333334`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.560181, 0.691569, 0.194885]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.560181, 0.691569, 0.194885]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.560181, 0.691569, 0.194885], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.6150173333333333, 0.25708400000000003`, 
                    0.13945266666666667`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.922526, 0.385626, 0.209179]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.922526, 0.385626, 0.209179]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.922526, 0.385626, 0.209179], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.3523253333333333, 0.3137493333333333, 
                    0.46756733333333333`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.528488, 0.470624, 0.701351]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.528488, 0.470624, 0.701351]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.528488, 0.470624, 0.701351], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.5147193333333333, 0.28770266666666666`, 
                    0.06825800000000001], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.772079, 0.431554, 0.102387]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.772079, 0.431554, 0.102387]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.772079, 0.431554, 0.102387], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5, ",", #6}], "}"}], 
           ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{3.805037587063797*^9, 3.8054603066252403`*^9, 
  3.8112630896899705`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Re", "[", 
      RowBox[{"NpMinus2Ltd", "[", 
       RowBox[{"e", ",", "0"}], "]"}], "]"}], ",", 
     RowBox[{"Re", "[", 
      RowBox[{"NpMinus2Ltd", "[", 
       RowBox[{"e", ",", "1"}], "]"}], "]"}], ",", 
     RowBox[{"Re", "[", 
      RowBox[{"NpMinus2Ltd", "[", 
       RowBox[{"e", ",", "2"}], "]"}], "]"}], ",", 
     RowBox[{"Re", "[", 
      RowBox[{"NpMinus2Ltd", "[", 
       RowBox[{"e", ",", "3"}], "]"}], "]"}], ",", 
     RowBox[{"Re", "[", 
      RowBox[{"NpMinus2Ltd", "[", 
       RowBox[{"e", ",", "4"}], "]"}], "]"}], ",", 
     RowBox[{"Re", "[", 
      RowBox[{"NpMinus2Ltd", "[", 
       RowBox[{"e", ",", "10"}], "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*SubscriptBox[\(p\), \(\(-2\), \
0\)]\)-\!\(\*SubscriptBox[\(p\), \(0, 0\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(\(-2\), \
1\)]\)-\!\(\*SubscriptBox[\(p\), \(0, 1\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(\(-2\), \
2\)]\)-\!\(\*SubscriptBox[\(p\), \(0, 2\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(\(-2\), \
3\)]\)-\!\(\*SubscriptBox[\(p\), \(0, 3\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(\(-2\), \
4\)]\)-\!\(\*SubscriptBox[\(p\), \(0, 4\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(\(-2\), 10\)]\)-\!\(\*SubscriptBox[\(p\
\), \(0, 10\)]\)\>\""}], "}"}]}], ",", 
   RowBox[{
   "PlotLabel", "\[Rule]", 
    "\"\<\!\(\*SubscriptBox[\(p\), \(\(-2\), s\)]\)-\!\(\*SubscriptBox[\(p\), \
\(0, s\)]\)\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8050370552997017`*^9, 3.8050370573772554`*^9}, {
  3.8054598883475375`*^9, 3.8054599406988635`*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] recursive bisections in \[NoBreak]\\!\\(u\\)\
\[NoBreak] near \[NoBreak]\\!\\({u}\\)\[NoBreak] = \
\[NoBreak]\\!\\({0.000024185766477748702`}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(-2.49366499671666`*^-16\\)\[NoBreak] and \
\[NoBreak]\\!\\(1.5939906358846744`*^-15\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8050375918025913`*^9, 3.8054603075981236`*^9, 
  3.8112630907429705`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "slwcon"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Numerical integration converging too slowly; suspect one \
of the following: singularity, value of the integration is 0, highly \
oscillatory integrand, or WorkingPrecision too small. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/slwcon\\\", ButtonNote -> \
\\\"NIntegrate::slwcon\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8050375918025913`*^9, 3.8054603075981236`*^9, 
  3.81126309079221*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] recursive bisections in \[NoBreak]\\!\\(u\\)\
\[NoBreak] near \[NoBreak]\\!\\({u}\\)\[NoBreak] = \
\[NoBreak]\\!\\({4.503669942224799`}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(1.734723475976807`*^-17\\)\[NoBreak] and \
\[NoBreak]\\!\\(3.820404467573641`*^-16\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8050375918025913`*^9, 3.8054603075981236`*^9, 
  3.8112630908246794`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] recursive bisections in \[NoBreak]\\!\\(u\\)\
\[NoBreak] near \[NoBreak]\\!\\({u}\\)\[NoBreak] = \
\[NoBreak]\\!\\({5.325883644531503`}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(4.8452214462813`*^-13 + \\(\\(2.185751579730777`*^-16\\\\ \
\[ImaginaryI]\\)\\)\\)\[NoBreak] and \
\[NoBreak]\\!\\(1.046037959204861`*^-15\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8050375918025913`*^9, 3.8054603075981236`*^9, 
  3.8112630909868293`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \
\[NoBreak]\\!\\(\\*StyleBox[\\(NIntegrate :: ncvb\\), \\\"MessageName\\\"]\\)\
\[NoBreak] will be suppressed during this calculation. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/stop\\\", \
ButtonNote -> \\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8050375918025913`*^9, 3.8054603075981236`*^9, 
  3.8112630910273237`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "slwcon"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Numerical integration converging too slowly; suspect one \
of the following: singularity, value of the integration is 0, highly \
oscillatory integrand, or WorkingPrecision too small. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/slwcon\\\", ButtonNote -> \
\\\"NIntegrate::slwcon\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8050375918025913`*^9, 3.8054603075981236`*^9, 
  3.8112630912809353`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "slwcon"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Numerical integration converging too slowly; suspect one \
of the following: singularity, value of the integration is 0, highly \
oscillatory integrand, or WorkingPrecision too small. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/slwcon\\\", ButtonNote -> \
\\\"NIntegrate::slwcon\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8050375918025913`*^9, 3.8054603075981236`*^9, 
  3.8112630913827667`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \
\[NoBreak]\\!\\(\\*StyleBox[\\(NIntegrate :: slwcon\\), \
\\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during this calculation. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/stop\\\", \
ButtonNote -> \\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8050375918025913`*^9, 3.8054603075981236`*^9, 
  3.8112630914231977`*^9}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{{{}, {}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.368417, 0.506779, 0.709798], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwV1Ak0Vd0XAHDDp0fILE+ZZxmLBskmkhQpFCnRQJSQIUMpU2ZKvCJjSkhI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        "]]}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.880722, 0.611041, 0.142051], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwVkmk81IsbxZHKMjEGjZElTLZLC6W0eCpLJUokqa5EFLciS0XayBJS1pIl
Wbpxu6JbUbl+j33fJlt0xwhjll9Elkrp7//ifM7nvDjn++ZouPnYe4iJiIjc
WdD/3dqD14F8RzN/2X0Zdj6u5aOFh9wGGOvBN9Jtd5u2GbFcuivuH4YFbNEt
04vT3kesNlXIy2AchHp6RI2Ptguxud24KIFxEjj9/eClfY7AtKoNtxkBQKmZ
L4zSvkqE3Yi5FM24CfI5WUZaOnHEyYBxxi1GEvwIj+Cn6WUSEkl7Hn2eyIXY
HWI2I0HPiJJ2o1271J5BimvPTSefEuJw2Ie+qpgXQM55Uu9IEYRPsb/h/anX
kFuUX6NYXEVM3u2uFxUl4HRq28uInDqivqKWaNtaCerD21wNfjYRXkF7ljmT
1UBtMugPN2gnKiSNfj09Wwc2jVJHG7aziMc51fPKqxoBKYc+CO52EtuX/5vt
UNgMseaF8ayGbsKw7kNprX4bUINzxgmJ90Tndoex/LF2UJs8FO4V10+ckfqD
1bWWBQ/CRJuoImyiqdfpX5m4d+D3bukGvxMcwsHq8ODwcCdcHX+m2dA8SJhk
xThlMbvBkp+5xXDtEMGZT+w8fa0HdI//dU+idpgY2dOWs7yqF7Y2tV8JOsQl
ilIHgjo0+kCTbTOjpcUj8qIW3dIL7gd+UeSvTUsExLT7EYHn2w+gXJMWY8ET
EtIWEfbFdDbs1VdulFYeI0KoI5TBYwPQGjnR7KD7maCU/ybSY8uBEE97JeLg
BLHtwv6fVd850Hk/2eh7ySSRnhubo5U+CCtM/7rhpTVFuDiub5Hc+xE0RPPp
zO5p4mWXR2L5zEdQfXH/Z0nxLGHaXCTGTRmCdTq8v+mPvhErLT2nEy2GQWGc
JiM1P0dsWL8h/gV3GDjB7Dn/a/PEwOTthpzwETDvzcvl5IkgaXwgnGHEBd8H
tsaDnmKoLTQUiL7jAuvSt/qLduJIkWjLe9vFhWZanKOfszh+YfqeCOzlgput
/EZ/N3FEl+e9vP+40MreLB8VII5HWCZ1bTwuLFKe48/fF8e4hatkzC/0zZ7P
aw+J43TkARdT/VE4+LZWJSFkMVYzA1m+N0bhgHrZ/us1SzDszzeHf4SNAnf4
fntC2xLcqS8yEBkxCoUXWm49fb8EK9bECDNjRqGJcrlq+tMSLN/8SLwleRQu
sNv1OMuXYoldi4lewSiUz8wlrvBeigUhq9IGWaMg+uZeisdyCbzT2eVuz+RB
jn1GpXGUJMZevc3s0ObB5KKgr4wkSYzWtRzZr8eDiPSqXZJZkhge8sLTdjUP
Kl5LH11UKomXmYleuzfxwI087ufJk8RTAXY+ZjY8iLO9dXPCWgpBoSlYP4AH
LqaPTp2iS+O4A8aLVfPAweSp1R/tFJz5M/xMSS0PstXY3w04FJyfs951poEH
+4zbZn+MU5CS2/Wjq5UH51LLltfLLkPdKcGp/Pc8MH/sOEexW4auSYpmduM8
8GULXdzeLcP2Tm9BhjIfPGMvJjSOyGCP7toae1U+iDTk0kJmZZAdMv1w6Uo+
1HrY+JtJyiLJvO54fhUf7K40G80YyKJEYDJarOUD04i7dX2gLO5QxBShJR+8
+yparolT8bmjornpeT4s6ljdsfMhFRNkr/EI/4X9jV4vUp5Q0a+Bd9vqAh9C
+z4c/lJMxXXbynodLvNBLztfoa6aikVM93Pnwvng82Hi8XsBFQu/FKXmpPLB
YM+9qZeb5LAg3ubzsko+FNSfLMvrl8Pova+Sk6r5INbI3qnPlUPvxSu3rKjj
A8VnevXrz3KoF/QlXLeZDxyW0G9mMQ2fuD5YYd7NB/fOuzaf19Lw8Rqe1SUB
H74GtL4ai6JhTktYxkeaAAJGJqYid8hj7Lq5Yw8VBeAlU06/tE8eLyT7qRxT
EsCRx8X/XTgqj7t/P5HWpSqAssqR4qxAeRwjzVLrdQVg8edutScF8riJ8j2p
0EwA5W36tWl0BWyx9o0N9hZA46ajsW0/FfBV4ejejWcFEPGaO1lDUcQs2nHp
KR8BMKPZR1tXKKJfn2302UAB5Df/KlLcrIhK3r9FuV4XgMjQ474bFxXR7RY3
zCplgb/apZCcVsTZumOXaZUCcDax/PlLlI5qDlaBldUCUJmiXtWWp6MVe42P
X50A9A//ke3GpGPKlJg7q1kAT00enlfZRcf1GvnWCT0C8JF6ff3BbTr6BU8z
aJ8EsO2Qg+2wmhKSBnGlckpC2Miqqv3owECF0ovPK5SFcNqB6kc9zcAt5iee
nlcVAqun1NU5hIHRzuuzOjSF0MjR69uWx0C9iL7IeEMhFL5pozt9ZaDngLaT
nLkQLGpOHJjLUUZOPDFNPScEE8OyyL9pKsgJtX2T4CuEIxaD2Yp6Kjjo339V
wV8IN5b9UEkHFfzoOLtU6ZIQNAKclRafVcEhxhpl9VAhzPpW/mPboILcR5lm
hilCOHjI7/l4pCoKi69E7ikXglp6sqm1ujqS2dI2TSiEN7tVvedMF3JiKtW2
Sgiv6Lnh7w4u5MCXqXb1QnBbY4vfotVxzPTTX04sIXzdNWGp800dP1cca/fg
CiH0W3L1k3MrcaZjCyNUhoTGZM2oV+4aKHK2Z9ZUjoR0mXtF6wI1UErCv3tC
ngT4dx82RmigmllB4gkGCRHdO0udCjTQskBJZgeTBPuNJWtGJjUwKXRaTGQz
Ca3BZ27QojUxUzV+sGQrCcEVhNrdDE18UmqAPkCCdz4vfW2xJpaNuV8ZsFjg
sZ0y+3s1cfgIa7Z8Pwm9hMmTIT0tNDZ+Rl7xIOGkvp2b7Dst3Npq3bTh9MLe
zWb5UZ4WWnlx8z95kxAzpFs+Oq+FRx6qnvrdl4Tfg6See/zGxFDp2MGtl0m4
fHyls2sEE1lDp7vn7pLATKH1lVisQt8kTQwqIyGtX+7STa422ie7eS0iSNh+
M/NtvIgObkjJpt2uIGEf2Pt3KOvg93uaHlm1JOjzi70E+3XQIlYs07CdhF8P
qB06r3TwfyPml3A=
        "]]}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.560181, 0.691569, 0.194885], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwV1Ak01csfAPAfKUJZkuxbCIVsJZWvyhIh2aLQlew7KfuaFFLWFLKnPEme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        "]]}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.922526, 0.385626, 0.209179], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwV1nk4Vd0XB/CToptSxkzJfEMZKg2IpUQpQ5lSSaRECSGhwUXmeXxTmbuJ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        "]]}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.528488, 0.470624, 0.701351], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwV13c81d8fB/APlRTKDikjOyQrSb2lSKJhl9KVyAohMsouWVlJksiIJhIK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        "]]}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.772079, 0.431554, 0.102387], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwV13c8V98fB/CPkagUQmSGkF1JQg6SFSVRlAoh2YTQINkkMhKyV6KQhD73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        "]]}}}, {
    DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, DisplayFunction :> 
     Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, "ScalingFunctions" -> None}, 
     PlotLabel -> 
     FormBox["\"\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(-2\\), \
s\\)]\\)-\\!\\(\\*SubscriptBox[\\(p\\), \\(0, s\\)]\\)\"", TraditionalForm], 
     PlotRange -> {{0, 1}, {-11.855772527005227`, 8.186951741944077*^-17}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}],FormBox[
    FormBox[
     TemplateBox[{
      "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(-2\\), \
0\\)]\\)-\\!\\(\\*SubscriptBox[\\(p\\), \\(0, 0\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(-2\\), \
1\\)]\\)-\\!\\(\\*SubscriptBox[\\(p\\), \\(0, 1\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(-2\\), \
2\\)]\\)-\\!\\(\\*SubscriptBox[\\(p\\), \\(0, 2\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(-2\\), \
3\\)]\\)-\\!\\(\\*SubscriptBox[\\(p\\), \\(0, 3\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(-2\\), \
4\\)]\\)-\\!\\(\\*SubscriptBox[\\(p\\), \\(0, 4\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(-2\\), \
10\\)]\\)-\\!\\(\\*SubscriptBox[\\(p\\), \\(0, 10\\)]\\)\""}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #4}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #5}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #6}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.368417, 0.506779, 0.709798]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.880722, 0.611041, 0.142051]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.37345400000000006`, 0.461046, 0.12992333333333334`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.560181, 0.691569, 0.194885]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.560181, 0.691569, 0.194885]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.560181, 0.691569, 0.194885], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.6150173333333333, 0.25708400000000003`, 
                    0.13945266666666667`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.922526, 0.385626, 0.209179]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.922526, 0.385626, 0.209179]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.922526, 0.385626, 0.209179], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.3523253333333333, 0.3137493333333333, 
                    0.46756733333333333`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.528488, 0.470624, 0.701351]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.528488, 0.470624, 0.701351]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.528488, 0.470624, 0.701351], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.5147193333333333, 0.28770266666666666`, 
                    0.06825800000000001], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.772079, 0.431554, 0.102387]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.772079, 0.431554, 0.102387]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.772079, 0.431554, 0.102387], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5, ",", #6}], "}"}], 
           ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{3.805038177057421*^9, 3.8054608643270254`*^9, 
  3.8112634632067575`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["W/ the factor", "Subsubsection"]], "Subsection",
 CellChangeTimes->{{3.805025299257105*^9, 3.805025301332178*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Re", "[", 
      RowBox[{"NpPlus2NPLtd", "[", 
       RowBox[{"e", ",", "0"}], "]"}], "]"}], ",", 
     RowBox[{"Re", "[", 
      RowBox[{"NpPlus2NPLtd", "[", 
       RowBox[{"e", ",", "1"}], "]"}], "]"}], ",", 
     RowBox[{"Re", "[", 
      RowBox[{"NpPlus2NPLtd", "[", 
       RowBox[{"e", ",", "2"}], "]"}], "]"}], ",", 
     RowBox[{"Re", "[", 
      RowBox[{"NpPlus2NPLtd", "[", 
       RowBox[{"e", ",", "3"}], "]"}], "]"}], ",", 
     RowBox[{"Re", "[", 
      RowBox[{"NpPlus2NPLtd", "[", 
       RowBox[{"e", ",", "4"}], "]"}], "]"}], ",", 
     RowBox[{"Re", "[", 
      RowBox[{"NpPlus2NPLtd", "[", 
       RowBox[{"e", ",", "10"}], "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<(\!\(\*SubscriptBox[\(p\), \(\(+2\), \
0\)]\)-\!\(\*SubscriptBox[\(p\), \(0, 0\)]\))(1-\!\(\*SuperscriptBox[\(e\), \
\(2\)]\)\!\(\*SuperscriptBox[\()\), \(3/2\)]\)\>\"", ",", 
      "\"\<(\!\(\*SubscriptBox[\(p\), \(\(+2\), 1\)]\)-\!\(\*SubscriptBox[\(p\
\), \(0, 1\)]\))(1-\!\(\*SuperscriptBox[\(e\), \
\(2\)]\)\!\(\*SuperscriptBox[\()\), \(3/2\)]\)\>\"", ",", 
      "\"\<(\!\(\*SubscriptBox[\(p\), \(\(+2\), 2\)]\)-\!\(\*SubscriptBox[\(p\
\), \(0, 2\)]\))(1-\!\(\*SuperscriptBox[\(e\), \
\(2\)]\)\!\(\*SuperscriptBox[\()\), \(3/2\)]\)\>\"", ",", 
      "\"\<(\!\(\*SubscriptBox[\(p\), \(\(+2\), 3\)]\)-\!\(\*SubscriptBox[\(p\
\), \(0, 3\)]\))(1-\!\(\*SuperscriptBox[\(e\), \
\(2\)]\)\!\(\*SuperscriptBox[\()\), \(3/2\)]\)\>\"", ",", 
      "\"\<(\!\(\*SubscriptBox[\(p\), \(\(+2\), 4\)]\)-\!\(\*SubscriptBox[\(p\
\), \(0, 4\)]\))(1-\!\(\*SuperscriptBox[\(e\), \
\(2\)]\)\!\(\*SuperscriptBox[\()\), \(3/2\)]\)\>\"", ",", 
      "\"\<(\!\(\*SubscriptBox[\(p\), \(\(+2\), \
10\)]\)-\!\(\*SubscriptBox[\(p\), \(0, 10\)]\))(1-\!\(\*SuperscriptBox[\(e\), \
\(2\)]\)\!\(\*SuperscriptBox[\()\), \(3/2\)]\)\>\""}], "}"}]}], ",", 
   RowBox[{
   "PlotLabel", "\[Rule]", 
    "\"\<(\!\(\*SubscriptBox[\(p\), \(\(+2\), \
s\)]\)-\!\(\*SubscriptBox[\(p\), \(0, s\)]\))(1-\!\(\*SuperscriptBox[\(e\), \
\(2\)]\)\!\(\*SuperscriptBox[\()\), \(3/2\)]\)\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.805025352384062*^9, 3.80502535912181*^9}, {
  3.8050254022506227`*^9, 3.8050254807137656`*^9}, {3.805460177177692*^9, 
  3.805460239443971*^9}, {3.805460277901495*^9, 3.805460300678523*^9}, {
  3.805460368400174*^9, 3.805460423945162*^9}, {3.80546046709612*^9, 
  3.8054604719844723`*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] recursive bisections in \[NoBreak]\\!\\(u\\)\
\[NoBreak] near \[NoBreak]\\!\\({u}\\)\[NoBreak] = \
\[NoBreak]\\!\\({0.000024185766477748702`}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(-2.49366499671666`*^-16\\)\[NoBreak] and \
\[NoBreak]\\!\\(1.5939906358846744`*^-15\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.80502549095426*^9, 3.805460865334343*^9, 
  3.811263464095975*^9, 3.8142752827338142`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "slwcon"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Numerical integration converging too slowly; suspect one \
of the following: singularity, value of the integration is 0, highly \
oscillatory integrand, or WorkingPrecision too small. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/slwcon\\\", ButtonNote -> \
\\\"NIntegrate::slwcon\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.80502549095426*^9, 3.805460865334343*^9, 
  3.811263464095975*^9, 3.8142752827787743`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] recursive bisections in \[NoBreak]\\!\\(u\\)\
\[NoBreak] near \[NoBreak]\\!\\({u}\\)\[NoBreak] = \
\[NoBreak]\\!\\({4.503669942224799`}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(1.734723475976807`*^-17\\)\[NoBreak] and \
\[NoBreak]\\!\\(3.820404467573641`*^-16\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.80502549095426*^9, 3.805460865334343*^9, 
  3.811263464095975*^9, 3.814275282818739*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] recursive bisections in \[NoBreak]\\!\\(u\\)\
\[NoBreak] near \[NoBreak]\\!\\({u}\\)\[NoBreak] = \
\[NoBreak]\\!\\({5.325883644531503`}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(4.8452214462813`*^-13 + \\(\\(2.185751579730777`*^-16\\\\ \
\[ImaginaryI]\\)\\)\\)\[NoBreak] and \
\[NoBreak]\\!\\(1.046037959204861`*^-15\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.80502549095426*^9, 3.805460865334343*^9, 
  3.811263464095975*^9, 3.814275282956607*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \
\[NoBreak]\\!\\(\\*StyleBox[\\(NIntegrate :: ncvb\\), \\\"MessageName\\\"]\\)\
\[NoBreak] will be suppressed during this calculation. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/stop\\\", \
ButtonNote -> \\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.80502549095426*^9, 3.805460865334343*^9, 
  3.811263464095975*^9, 3.814275282995571*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "slwcon"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Numerical integration converging too slowly; suspect one \
of the following: singularity, value of the integration is 0, highly \
oscillatory integrand, or WorkingPrecision too small. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/slwcon\\\", ButtonNote -> \
\\\"NIntegrate::slwcon\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.80502549095426*^9, 3.805460865334343*^9, 
  3.811263464095975*^9, 3.814275283215371*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "slwcon"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Numerical integration converging too slowly; suspect one \
of the following: singularity, value of the integration is 0, highly \
oscillatory integrand, or WorkingPrecision too small. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/slwcon\\\", ButtonNote -> \
\\\"NIntegrate::slwcon\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.80502549095426*^9, 3.805460865334343*^9, 
  3.811263464095975*^9, 3.81427528331028*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \
\[NoBreak]\\!\\(\\*StyleBox[\\(NIntegrate :: slwcon\\), \
\\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during this calculation. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/stop\\\", \
ButtonNote -> \\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.80502549095426*^9, 3.805460865334343*^9, 
  3.811263464095975*^9, 3.814275283347247*^9}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{{{}, {}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.368417, 0.506779, 0.709798], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwt1Qk0lFscAHD7OqReykjEo0WNLXlJ+qs8GtIrsvV65SWKFqTpZGlBRAiP
lB6eteQ4SAqFsRUVYXzDJNsw9jETWcr6mu9+95zvfOd37v/+7/3uvd/5q5/x
snUTERISuvXzEbyt3EZaq0bt94kJCdpXekhQ5PV75DsgQfjsVT45gpwAwyuC
xqfvObJf5+VyKtgTlkqgpn+dzALvZWQXg33TG6RyIYJwSYuBpaVqAdgLo3yd
M3vovnJFYC6F7BTS1VkbWQzWJGI+5a1iOmYlkE2M93ruS3k0XQapS8h66loL
jf7lcG8ReSq2vUFYmA7FC8ibxMm2OT1V8JZwQ/U7evPeGhAi8j3aGO6ekFAL
c8R6PPyocs7cOmiVRH5QbSohSnkHUwrI1dIGK3mX6qFaFbnYYWHZ9X0DOBgi
P8msW1bW+gDytsjfuqqOlnh8hAkastm6igy7/EZoT0d+xWukRHObYKUNmVLf
VfpOuxnOyArj3sVwyZY40AI0KjJmZsd7xmuBimDkNK3TffSYVqjIRb4oc4HB
1GNAehlysg/b8kovA3iPkT+yHCvk77fBrD5y4FBH0GhpGxhJI1OmHS3qBtrA
5zNaj8TCwxz9H21QWYncI8yS+U8eg18ykK3Ev7+xJ2Pw4x/ie6SULpE0MXAO
ESLWk/P23DYMHAKQNUi7VWt1MND3RWbJNVxTNcRgzBM5ZpVTs58xBuGpVXOC
87FYPbKFuQ8DhVe5uBfXXL+tZ47B3mMovmit1OdIKgZnDyGfX/dIf/gIBp6A
jJFL+1OcMZCkEPu/kRV//CwGJGVkJU2l2Wo/DCI56D5Majs56cZgoBSLnLGb
pSLzGgNR5jJuOwsnNoeDgak4svk3n+SaO0w4rDaP2ygt0jFNsx0cb0/jjmxe
lSjGaIeYDVzcfcvx2PlbHZBX1of7TJZ+OaizILqbgXuQ2py5rpYFv/1ZjfuD
T4f81SufYVXBM9yFSb1+reqdkBQXhVs7zidoqakTmBaeuLPDRSO2+X8Bk60H
cNvM5hs3KHfBWNp63DOuJ8bc33RBdNnIssBCx71Vozy6wUunCLeseZjt8/U9
UCfjj9s896Uu9XUPVByyxB2oMEhin+wFhVm0P1YWqWGWi70gTPw/pMrtQh02
fUCSRdZ8XHHTJqsPXFWQTa/9sVQ73wc8I+J+yF1u8bVmQ+sJ5OSsqMxfk9mQ
EIW8FOhSmviNDdbtyKfsDZukrfvhtDG6r/cUbfQ4af2gWIr8kukWXznbDzxH
EdxzR2WtGRYD0EESxW3cWCgylDgA+3uR88JlF8snBoDVLYZ70+/uM/HmHLgw
JI47t9zmYNYDDjg0SKD/0XBXXPEQB8rcJNH88X9TdhgNgiMNuXcq+n1m6CCk
xKJ493ivpz1fBkGRgebj7jwWSjYYAuvNi/j+RcTQS6KDhyBAbRT35nHKmHDb
ENBCP6DzunvslLH2MGx6kYi7TpPG8A4aBiOGJe7cQK1/2YxhWNHsxs8nBmO6
2mqOwN0tVNyw9qO/9tURyHsVtiQw364qTqRuBIK/RC4K3IJ5jqUoj4J6qvGC
wEX2igeNfUahIrTwB54/7vBXuZqf/TdNvguc2RSS0r9mDPRNYvH4JivvKH/P
MZhUSMI9V38yYE3NGJgQ94G7437paqVxGBBB7oujzyhcHgdfceTx5zfuUivH
QUUaebbVhBwsz4VPcsg7dxZwb7hxIWY1sneCRpVfORdOiiLXFWqM5MtNAI2o
T+ubNBQ4pybAmfCu1nNht/MnYIqoT3bMvEWV5QnQJJyh/LQ48DgPJon4qdPp
F7tyeRAkQ9Qjl61+tAUedASgeLpLQaj8YT6QiXja0TC2jB8f4oh8283+MpV8
wocuor5IlB66EFrOhwGiXrF1DZNE2/igSIz/NL6t8EAPH8SJ+lX+VK0+aJQP
C0T/i9DHtup8PjQT9SvXVbGnavpnvnnkbAYjM3aOD0eI8Wn7Yz1c5vmQQ6w/
udBGV2+JD8r1qP+hmuzMzzdIy2zcsHull/4/OLwv+A==
        "]]}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.880722, 0.611041, 0.142051], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwV1nk0VV0UAHCeSpFIyFPGkCGREiLbUBIpQvo0GVI0KaVSyqySypQyVESU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        "]]}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.560181, 0.691569, 0.194885], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwV2Hk4VF0cB3BL2kSSbC9hEsmWoij8eJWQNXtFltJiJ8pWKZReyZYi+5ol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        "]]}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.922526, 0.385626, 0.209179], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwV1nk4VO8XAHBr2ZIUkVImhEhZ+hXlUJIsZSsqLbYsUaiQlChSlviSslR2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        "]]}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.528488, 0.470624, 0.701351], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwV13k8VF0YB3BR2hRRoiyRpBIKhfBQCCEhS0WyZE3Jki1b6CUkpEiypuxE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        "]]}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.772079, 0.431554, 0.102387], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwV13c8Vf8fB3AhI4WEUEqRlfU1SnLPG4VCZI9kRUM07FFWZmRkhiQrZO+s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        "]]}}}, {
    DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, DisplayFunction :> 
     Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, "ScalingFunctions" -> None}, 
     PlotLabel -> 
     FormBox["\"(\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(+2\\), \
s\\)]\\)-\\!\\(\\*SubscriptBox[\\(p\\), \\(0, \
s\\)]\\))(1-\\!\\(\\*SuperscriptBox[\\(e\\), \
\\(2\\)]\\)\\!\\(\\*SuperscriptBox[\\()\\), \\(3/2\\)]\\)\"", 
       TraditionalForm], 
     PlotRange -> {{0, 1}, {-1.0176076215946466`, 0.9999999999999978}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}],FormBox[
    FormBox[
     TemplateBox[{
      "\"(\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(+2\\), \
0\\)]\\)-\\!\\(\\*SubscriptBox[\\(p\\), \\(0, \
0\\)]\\))(1-\\!\\(\\*SuperscriptBox[\\(e\\), \
\\(2\\)]\\)\\!\\(\\*SuperscriptBox[\\()\\), \\(3/2\\)]\\)\"", 
       "\"(\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(+2\\), \
1\\)]\\)-\\!\\(\\*SubscriptBox[\\(p\\), \\(0, \
1\\)]\\))(1-\\!\\(\\*SuperscriptBox[\\(e\\), \
\\(2\\)]\\)\\!\\(\\*SuperscriptBox[\\()\\), \\(3/2\\)]\\)\"", 
       "\"(\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(+2\\), \
2\\)]\\)-\\!\\(\\*SubscriptBox[\\(p\\), \\(0, \
2\\)]\\))(1-\\!\\(\\*SuperscriptBox[\\(e\\), \
\\(2\\)]\\)\\!\\(\\*SuperscriptBox[\\()\\), \\(3/2\\)]\\)\"", 
       "\"(\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(+2\\), \
3\\)]\\)-\\!\\(\\*SubscriptBox[\\(p\\), \\(0, \
3\\)]\\))(1-\\!\\(\\*SuperscriptBox[\\(e\\), \
\\(2\\)]\\)\\!\\(\\*SuperscriptBox[\\()\\), \\(3/2\\)]\\)\"", 
       "\"(\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(+2\\), \
4\\)]\\)-\\!\\(\\*SubscriptBox[\\(p\\), \\(0, \
4\\)]\\))(1-\\!\\(\\*SuperscriptBox[\\(e\\), \
\\(2\\)]\\)\\!\\(\\*SuperscriptBox[\\()\\), \\(3/2\\)]\\)\"", 
       "\"(\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(+2\\), \
10\\)]\\)-\\!\\(\\*SubscriptBox[\\(p\\), \\(0, \
10\\)]\\))(1-\\!\\(\\*SuperscriptBox[\\(e\\), \
\\(2\\)]\\)\\!\\(\\*SuperscriptBox[\\()\\), \\(3/2\\)]\\)\""}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #4}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #5}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #6}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.368417, 0.506779, 0.709798]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.880722, 0.611041, 0.142051]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.37345400000000006`, 0.461046, 0.12992333333333334`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.560181, 0.691569, 0.194885]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.560181, 0.691569, 0.194885]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.560181, 0.691569, 0.194885], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.6150173333333333, 0.25708400000000003`, 
                    0.13945266666666667`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.922526, 0.385626, 0.209179]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.922526, 0.385626, 0.209179]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.922526, 0.385626, 0.209179], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.3523253333333333, 0.3137493333333333, 
                    0.46756733333333333`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.528488, 0.470624, 0.701351]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.528488, 0.470624, 0.701351]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.528488, 0.470624, 0.701351], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.5147193333333333, 0.28770266666666666`, 
                    0.06825800000000001], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.772079, 0.431554, 0.102387]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.772079, 0.431554, 0.102387]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.772079, 0.431554, 0.102387], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5, ",", #6}], "}"}], 
           ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{3.8050259964663343`*^9, 3.8054613015485134`*^9, 
  3.8112637736692305`*^9, 3.8142755512707944`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"pPlus2", "[", 
      RowBox[{"e", ",", "0"}], "]"}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{"const1", "*", "const2"}], ")"}]}], ")"}], "*", 
      RowBox[{"p0", "[", 
       RowBox[{"e", ",", "0"}], "]"}]}]}], ")"}], "*", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"e", "^", "2"}]}], ")"}], "^", 
    RowBox[{"(", 
     RowBox[{"3", "/", "2"}], ")"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.805027032101775*^9, 3.8050270456692543`*^9}, {
  3.8050273662600846`*^9, 3.8050274202417727`*^9}}],

Cell[BoxData[
 RowBox[{"ConditionalExpression", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], " ", "\[Pi]"}], ",", 
   RowBox[{"e", "<", "1"}]}], "]"}]], "Output",
 CellChangeTimes->{3.80502736043194*^9, 3.805027484394595*^9, 
  3.811263824389903*^9}]
}, Open  ]],

Cell["\<\
So yes, they do just equal -2Pi, which of course they needed to in order to \
cancel out p_0s.\
\>", "Text",
 CellChangeTimes->{{3.8050279459021215`*^9, 3.8050279675478277`*^9}, {
  3.8050366157657347`*^9, 3.805036621467852*^9}, {3.8050388180739207`*^9, 
  3.805038818522628*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"pPlus2", "[", 
      RowBox[{"e", ",", "1"}], "]"}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{"const1", "*", "const2"}], ")"}]}], ")"}], "*", 
      RowBox[{"p0", "[", 
       RowBox[{"e", ",", "1"}], "]"}]}]}], ")"}], "*", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"e", "^", "2"}]}], ")"}], "^", 
    RowBox[{"(", 
     RowBox[{"3", "/", "2"}], ")"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.805038827858985*^9, 3.805038830830711*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Refine", "::", "fas"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Warning: one or more assumptions evaluated to False. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/fas\\\", \
ButtonNote -> \\\"Refine::fas\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8112651908009353`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Refine", "::", "fas"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Warning: one or more assumptions evaluated to False. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/fas\\\", \
ButtonNote -> \\\"Refine::fas\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8112651908608785`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Refine", "::", "fas"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Warning: one or more assumptions evaluated to False. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/fas\\\", \
ButtonNote -> \\\"Refine::fas\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.811265190924819*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \[NoBreak]\\!\\(\\*StyleBox[\\(Refine :: \
fas\\), \\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during this \
calculation. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/stop\\\", ButtonNote -> \
\\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8112651909617844`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Integrate", "::", "idiv"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Integral of \[NoBreak]\\!\\(\[ExponentialE]\\^\\(\
\[ImaginaryI]\\\\ \\(\\((u - \\(\\(e\\\\ \
\\(\\(Sin[u]\\)\\)\\)\\))\\)\\)\\)\\/\\((\\(\\(-1\\)\\) + \\(\\(e\\\\ \
\\(\\(Cos[u]\\)\\)\\)\\))\\)\\^2\\)\[NoBreak] does not converge on \[NoBreak]\
\\!\\({0, \\(\\(2\\\\ \[Pi]\\)\\)}\\)\[NoBreak]. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Integrate/idiv\\\", ButtonNote -> \
\\\"Integrate::idiv\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8112651914313517`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"pPlus2", "[", 
   RowBox[{"e", ",", "0"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.8051125024552774`*^9, 3.805112506291727*^9}}],

Cell[BoxData[
 RowBox[{"ConditionalExpression", "[", 
  RowBox[{"0", ",", 
   RowBox[{"e", "<", "1"}]}], "]"}]], "Output",
 CellChangeTimes->{3.805112531696164*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"pPlus2Ltd", "[", 
   RowBox[{"e", ",", "0"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.805112444963586*^9, 3.8051124481326475`*^9}}],

Cell[BoxData[
 RowBox[{"ConditionalExpression", "[", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", " ", "\[Pi]"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["e", "2"]}], ")"}], 
      RowBox[{"3", "/", "2"}]]]}], ",", 
   RowBox[{"e", "<", "1"}]}], "]"}]], "Output",
 CellChangeTimes->{{3.805112438876229*^9, 3.805112454428809*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"pPlus2Ltd", "[", 
       RowBox[{"e", ",", "1"}], "]"}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"e", "^", "2"}]}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"3", "/", "2"}], ")"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"e", ",", "0", ",", "5"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.8050407917103357`*^9, 3.805040801633654*^9}, {
  3.805112289684921*^9, 3.8051123044102664`*^9}, {3.805112661030239*^9, 
  3.805112661732588*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Refine", "::", "fas"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Warning: one or more assumptions evaluated to False. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/fas\\\", \
ButtonNote -> \\\"Refine::fas\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.805114739580423*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Refine", "::", "fas"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Warning: one or more assumptions evaluated to False. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/fas\\\", \
ButtonNote -> \\\"Refine::fas\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8051147395834217`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Refine", "::", "fas"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Warning: one or more assumptions evaluated to False. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/fas\\\", \
ButtonNote -> \\\"Refine::fas\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8051147395854206`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \[NoBreak]\\!\\(\\*StyleBox[\\(Refine :: \
fas\\), \\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during this \
calculation. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/stop\\\", ButtonNote -> \
\\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8051147397182965`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Integrate", "::", "idiv"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Integral of \[NoBreak]\\!\\(\[ExponentialE]\\^\\(\
\[ImaginaryI]\\\\ \\(\\((u - \\(\\(e\\\\ \
\\(\\(Sin[u]\\)\\)\\)\\))\\)\\)\\)\\/\\((\\(\\(-1\\)\\) + \\(\\(e\\\\ \
\\(\\(Cos[u]\\)\\)\\)\\))\\)\\^4\\)\[NoBreak] does not converge on \[NoBreak]\
\\!\\({0, \\(\\(2\\\\ \[Pi]\\)\\)}\\)\[NoBreak]. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Integrate/idiv\\\", ButtonNote -> \
\\\"Integrate::idiv\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8051147482943535`*^9}]
}, Open  ]],

Cell["What about the negatives? Probably.", "Text",
 CellChangeTimes->{3.8050388157548733`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Re", "[", 
      RowBox[{"NpMinus2NPLtd", "[", 
       RowBox[{"e", ",", "0"}], "]"}], "]"}], ",", 
     RowBox[{"Re", "[", 
      RowBox[{"NpMinus2NPLtd", "[", 
       RowBox[{"e", ",", "1"}], "]"}], "]"}], ",", 
     RowBox[{"Re", "[", 
      RowBox[{"NpMinus2NPLtd", "[", 
       RowBox[{"e", ",", "2"}], "]"}], "]"}], ",", 
     RowBox[{"Re", "[", 
      RowBox[{"NpMinus2NPLtd", "[", 
       RowBox[{"e", ",", "3"}], "]"}], "]"}], ",", 
     RowBox[{"Re", "[", 
      RowBox[{"NpMinus2NPLtd", "[", 
       RowBox[{"e", ",", "4"}], "]"}], "]"}], ",", 
     RowBox[{"Re", "[", 
      RowBox[{"NpMinus2NPLtd", "[", 
       RowBox[{"e", ",", "10"}], "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<(\!\(\*SubscriptBox[\(p\), \(\(-2\), \
0\)]\)-\!\(\*SubscriptBox[\(p\), \(0, 0\)]\))(1-\!\(\*SuperscriptBox[\(e\), \
\(2\)]\)\!\(\*SuperscriptBox[\()\), \(3/2\)]\)\>\"", ",", 
      "\"\<(\!\(\*SubscriptBox[\(p\), \(\(-2\), 1\)]\)-\!\(\*SubscriptBox[\(p\
\), \(0, 1\)]\))(1-\!\(\*SuperscriptBox[\(e\), \
\(2\)]\)\!\(\*SuperscriptBox[\()\), \(3/2\)]\)\>\"", ",", 
      "\"\<(\!\(\*SubscriptBox[\(p\), \(\(-2\), 2\)]\)-\!\(\*SubscriptBox[\(p\
\), \(0, 2\)]\))(1-\!\(\*SuperscriptBox[\(e\), \
\(2\)]\)\!\(\*SuperscriptBox[\()\), \(3/2\)]\)\>\"", ",", 
      "\"\<(\!\(\*SubscriptBox[\(p\), \(\(-2\), 3\)]\)-\!\(\*SubscriptBox[\(p\
\), \(0, 3\)]\))(1-\!\(\*SuperscriptBox[\(e\), \
\(2\)]\)\!\(\*SuperscriptBox[\()\), \(3/2\)]\)\>\"", ",", 
      "\"\<(\!\(\*SubscriptBox[\(p\), \(\(-2\), 4\)]\)-\!\(\*SubscriptBox[\(p\
\), \(0, 4\)]\))(1-\!\(\*SuperscriptBox[\(e\), \
\(2\)]\)\!\(\*SuperscriptBox[\()\), \(3/2\)]\)\>\"", ",", 
      "\"\<(\!\(\*SubscriptBox[\(p\), \(\(-2\), \
10\)]\)-\!\(\*SubscriptBox[\(p\), \(0, 10\)]\))(1-\!\(\*SuperscriptBox[\(e\), \
\(2\)]\)\!\(\*SuperscriptBox[\()\), \(3/2\)]\)\>\""}], "}"}]}], ",", 
   RowBox[{
   "PlotLabel", "\[Rule]", 
    "\"\<(\!\(\*SubscriptBox[\(p\), \(\(-2\), \
s\)]\)-\!\(\*SubscriptBox[\(p\), \(0, s\)]\))(1-\!\(\*SuperscriptBox[\(e\), \
\(2\)]\)\!\(\*SuperscriptBox[\()\), \(3/2\)]\)\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8050366533290844`*^9, 3.8050366784273643`*^9}, {
  3.8054605796019983`*^9, 3.805460618334186*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] recursive bisections in \[NoBreak]\\!\\(u\\)\
\[NoBreak] near \[NoBreak]\\!\\({u}\\)\[NoBreak] = \
\[NoBreak]\\!\\({0.000024185766477748702`}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(-2.49366499671666`*^-16\\)\[NoBreak] and \
\[NoBreak]\\!\\(1.5939906358846744`*^-15\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8050381784905453`*^9, 3.805461304642646*^9, 
  3.8142757244814367`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "slwcon"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Numerical integration converging too slowly; suspect one \
of the following: singularity, value of the integration is 0, highly \
oscillatory integrand, or WorkingPrecision too small. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/slwcon\\\", ButtonNote -> \
\\\"NIntegrate::slwcon\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8050381784905453`*^9, 3.805461304642646*^9, 
  3.81427572453239*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] recursive bisections in \[NoBreak]\\!\\(u\\)\
\[NoBreak] near \[NoBreak]\\!\\({u}\\)\[NoBreak] = \
\[NoBreak]\\!\\({4.503669942224799`}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(1.734723475976807`*^-17\\)\[NoBreak] and \
\[NoBreak]\\!\\(3.820404467573641`*^-16\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8050381784905453`*^9, 3.805461304642646*^9, 
  3.8142757245713577`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] recursive bisections in \[NoBreak]\\!\\(u\\)\
\[NoBreak] near \[NoBreak]\\!\\({u}\\)\[NoBreak] = \
\[NoBreak]\\!\\({5.325883644531503`}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(4.8452214462813`*^-13 + \\(\\(2.185751579730777`*^-16\\\\ \
\[ImaginaryI]\\)\\)\\)\[NoBreak] and \
\[NoBreak]\\!\\(1.046037959204861`*^-15\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8050381784905453`*^9, 3.805461304642646*^9, 
  3.814275724718218*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \
\[NoBreak]\\!\\(\\*StyleBox[\\(NIntegrate :: ncvb\\), \\\"MessageName\\\"]\\)\
\[NoBreak] will be suppressed during this calculation. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/stop\\\", \
ButtonNote -> \\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8050381784905453`*^9, 3.805461304642646*^9, 
  3.81427572475519*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "slwcon"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Numerical integration converging too slowly; suspect one \
of the following: singularity, value of the integration is 0, highly \
oscillatory integrand, or WorkingPrecision too small. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/slwcon\\\", ButtonNote -> \
\\\"NIntegrate::slwcon\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8050381784905453`*^9, 3.805461304642646*^9, 
  3.814275725037922*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "slwcon"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Numerical integration converging too slowly; suspect one \
of the following: singularity, value of the integration is 0, highly \
oscillatory integrand, or WorkingPrecision too small. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/slwcon\\\", ButtonNote -> \
\\\"NIntegrate::slwcon\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8050381784905453`*^9, 3.805461304642646*^9, 
  3.8142757251348324`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \
\[NoBreak]\\!\\(\\*StyleBox[\\(NIntegrate :: slwcon\\), \
\\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during this calculation. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/stop\\\", \
ButtonNote -> \\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8050381784905453`*^9, 3.805461304642646*^9, 
  3.8142757251718006`*^9}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{{{}, {}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.368417, 0.506779, 0.709798], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwt1Qk0lFscAHD7OqReykjEo0WNLXlJ+qs8GtIrsvV65SWKFqTpZGlBRAiP
lB6eteQ4SAqFsRUVYXzDJNsw9jETWcr6mu9+95zvfOd37v/+7/3uvd/5q5/x
snUTERISuvXzEbyt3EZaq0bt94kJCdpXekhQ5PV75DsgQfjsVT45gpwAwyuC
xqfvObJf5+VyKtgTlkqgpn+dzALvZWQXg33TG6RyIYJwSYuBpaVqAdgLo3yd
M3vovnJFYC6F7BTS1VkbWQzWJGI+5a1iOmYlkE2M93ruS3k0XQapS8h66loL
jf7lcG8ReSq2vUFYmA7FC8ibxMm2OT1V8JZwQ/U7evPeGhAi8j3aGO6ekFAL
c8R6PPyocs7cOmiVRH5QbSohSnkHUwrI1dIGK3mX6qFaFbnYYWHZ9X0DOBgi
P8msW1bW+gDytsjfuqqOlnh8hAkastm6igy7/EZoT0d+xWukRHObYKUNmVLf
VfpOuxnOyArj3sVwyZY40AI0KjJmZsd7xmuBimDkNK3TffSYVqjIRb4oc4HB
1GNAehlysg/b8kovA3iPkT+yHCvk77fBrD5y4FBH0GhpGxhJI1OmHS3qBtrA
5zNaj8TCwxz9H21QWYncI8yS+U8eg18ykK3Ev7+xJ2Pw4x/ie6SULpE0MXAO
ESLWk/P23DYMHAKQNUi7VWt1MND3RWbJNVxTNcRgzBM5ZpVTs58xBuGpVXOC
87FYPbKFuQ8DhVe5uBfXXL+tZ47B3mMovmit1OdIKgZnDyGfX/dIf/gIBp6A
jJFL+1OcMZCkEPu/kRV//CwGJGVkJU2l2Wo/DCI56D5Majs56cZgoBSLnLGb
pSLzGgNR5jJuOwsnNoeDgak4svk3n+SaO0w4rDaP2ygt0jFNsx0cb0/jjmxe
lSjGaIeYDVzcfcvx2PlbHZBX1of7TJZ+OaizILqbgXuQ2py5rpYFv/1ZjfuD
T4f81SufYVXBM9yFSb1+reqdkBQXhVs7zidoqakTmBaeuLPDRSO2+X8Bk60H
cNvM5hs3KHfBWNp63DOuJ8bc33RBdNnIssBCx71Vozy6wUunCLeseZjt8/U9
UCfjj9s896Uu9XUPVByyxB2oMEhin+wFhVm0P1YWqWGWi70gTPw/pMrtQh02
fUCSRdZ8XHHTJqsPXFWQTa/9sVQ73wc8I+J+yF1u8bVmQ+sJ5OSsqMxfk9mQ
EIW8FOhSmviNDdbtyKfsDZukrfvhtDG6r/cUbfQ4af2gWIr8kukWXznbDzxH
EdxzR2WtGRYD0EESxW3cWCgylDgA+3uR88JlF8snBoDVLYZ70+/uM/HmHLgw
JI47t9zmYNYDDjg0SKD/0XBXXPEQB8rcJNH88X9TdhgNgiMNuXcq+n1m6CCk
xKJ493ivpz1fBkGRgebj7jwWSjYYAuvNi/j+RcTQS6KDhyBAbRT35nHKmHDb
ENBCP6DzunvslLH2MGx6kYi7TpPG8A4aBiOGJe7cQK1/2YxhWNHsxs8nBmO6
2mqOwN0tVNyw9qO/9tURyHsVtiQw364qTqRuBIK/RC4K3IJ5jqUoj4J6qvGC
wEX2igeNfUahIrTwB54/7vBXuZqf/TdNvguc2RSS0r9mDPRNYvH4JivvKH/P
MZhUSMI9V38yYE3NGJgQ94G7437paqVxGBBB7oujzyhcHgdfceTx5zfuUivH
QUUaebbVhBwsz4VPcsg7dxZwb7hxIWY1sneCRpVfORdOiiLXFWqM5MtNAI2o
T+ubNBQ4pybAmfCu1nNht/MnYIqoT3bMvEWV5QnQJJyh/LQ48DgPJon4qdPp
F7tyeRAkQ9Qjl61+tAUedASgeLpLQaj8YT6QiXja0TC2jB8f4oh8283+MpV8
wocuor5IlB66EFrOhwGiXrF1DZNE2/igSIz/NL6t8EAPH8SJ+lX+VK0+aJQP
C0T/i9DHtup8PjQT9SvXVbGnavpnvnnkbAYjM3aOD0eI8Wn7Yz1c5vmQQ6w/
udBGV2+JD8r1qP+hmuzMzzdIy2zcsHull/4/OLwv+A==
        "]]}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.880722, 0.611041, 0.142051], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwV0Hk41Xkbx3HLFMaaytK0KZSMaizzlMqtiQmDsnUi29giDEKTkq7ClCfE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        "]]}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.560181, 0.691569, 0.194885], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwVz3k0FPr7B3CXb6ioFK6REqHcEKJQenRFVzFZxi7Xki1KkoqkO5bKkiRZ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        "]]}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.922526, 0.385626, 0.209179], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwV1nc01w8XB3BRGUWFrMwyKyPlVxS3UCGbSEZESiiUlIpsMkJWIiuUyIgI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        "]]}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.528488, 0.470624, 0.701351], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwVzmc4lg8bBnBRkqRJRCGigSIapAshCmVTkhESiWwNm+z1UDIyQlZGhfDc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        "]]}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.772079, 0.431554, 0.102387], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwVV3c81/8TR0JFSWYJRZQSZWadklWoKFHILDPJigiFrGTLzF6RvT/v98se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        "]]}}}, {
    DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, DisplayFunction :> 
     Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, "ScalingFunctions" -> None}, 
     PlotLabel -> 
     FormBox["\"(\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(-2\\), \
s\\)]\\)-\\!\\(\\*SubscriptBox[\\(p\\), \\(0, \
s\\)]\\))(1-\\!\\(\\*SuperscriptBox[\\(e\\), \
\\(2\\)]\\)\\!\\(\\*SuperscriptBox[\\()\\), \\(3/2\\)]\\)\"", 
       TraditionalForm], 
     PlotRange -> {{0, 1}, {-1.0000000001085334`, 8.186656025875297*^-17}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}],FormBox[
    FormBox[
     TemplateBox[{
      "\"(\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(-2\\), \
0\\)]\\)-\\!\\(\\*SubscriptBox[\\(p\\), \\(0, \
0\\)]\\))(1-\\!\\(\\*SuperscriptBox[\\(e\\), \
\\(2\\)]\\)\\!\\(\\*SuperscriptBox[\\()\\), \\(3/2\\)]\\)\"", 
       "\"(\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(-2\\), \
1\\)]\\)-\\!\\(\\*SubscriptBox[\\(p\\), \\(0, \
1\\)]\\))(1-\\!\\(\\*SuperscriptBox[\\(e\\), \
\\(2\\)]\\)\\!\\(\\*SuperscriptBox[\\()\\), \\(3/2\\)]\\)\"", 
       "\"(\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(-2\\), \
2\\)]\\)-\\!\\(\\*SubscriptBox[\\(p\\), \\(0, \
2\\)]\\))(1-\\!\\(\\*SuperscriptBox[\\(e\\), \
\\(2\\)]\\)\\!\\(\\*SuperscriptBox[\\()\\), \\(3/2\\)]\\)\"", 
       "\"(\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(-2\\), \
3\\)]\\)-\\!\\(\\*SubscriptBox[\\(p\\), \\(0, \
3\\)]\\))(1-\\!\\(\\*SuperscriptBox[\\(e\\), \
\\(2\\)]\\)\\!\\(\\*SuperscriptBox[\\()\\), \\(3/2\\)]\\)\"", 
       "\"(\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(-2\\), \
4\\)]\\)-\\!\\(\\*SubscriptBox[\\(p\\), \\(0, \
4\\)]\\))(1-\\!\\(\\*SuperscriptBox[\\(e\\), \
\\(2\\)]\\)\\!\\(\\*SuperscriptBox[\\()\\), \\(3/2\\)]\\)\"", 
       "\"(\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(-2\\), \
10\\)]\\)-\\!\\(\\*SubscriptBox[\\(p\\), \\(0, \
10\\)]\\))(1-\\!\\(\\*SuperscriptBox[\\(e\\), \
\\(2\\)]\\)\\!\\(\\*SuperscriptBox[\\()\\), \\(3/2\\)]\\)\""}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #4}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #5}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #6}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.368417, 0.506779, 0.709798]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.880722, 0.611041, 0.142051]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.37345400000000006`, 0.461046, 0.12992333333333334`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.560181, 0.691569, 0.194885]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.560181, 0.691569, 0.194885]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.560181, 0.691569, 0.194885], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.6150173333333333, 0.25708400000000003`, 
                    0.13945266666666667`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.922526, 0.385626, 0.209179]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.922526, 0.385626, 0.209179]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.922526, 0.385626, 0.209179], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.3523253333333333, 0.3137493333333333, 
                    0.46756733333333333`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.528488, 0.470624, 0.701351]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.528488, 0.470624, 0.701351]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.528488, 0.470624, 0.701351], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.5147193333333333, 0.28770266666666666`, 
                    0.06825800000000001], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.772079, 0.431554, 0.102387]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.772079, 0.431554, 0.102387]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.772079, 0.431554, 0.102387], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5, ",", #6}], "}"}], 
           ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{3.8050385520974846`*^9, 3.8054616533595324`*^9, 
  3.814275933411826*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"pMinus2", "[", 
      RowBox[{"e", ",", "0"}], "]"}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{"const1", "*", "const2"}], ")"}]}], ")"}], "*", 
      RowBox[{"p0", "[", 
       RowBox[{"e", ",", "0"}], "]"}]}]}], ")"}], "*", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"e", "^", "2"}]}], ")"}], "^", 
    RowBox[{"(", 
     RowBox[{"3", "/", "2"}], ")"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8050387331345353`*^9, 3.8050387337569695`*^9}}],

Cell[BoxData[
 RowBox[{"ConditionalExpression", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], " ", "\[Pi]"}], ",", 
   RowBox[{"e", "<", "1"}]}], "]"}]], "Output",
 CellChangeTimes->{3.805038781691003*^9}]
}, Open  ]],

Cell["Yeet.", "Text",
 CellChangeTimes->{{3.805038787014943*^9, 3.805038788444131*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Are the last two integrals ever not not partly real?", "Subsection",
 CellChangeTimes->{{3.806324121400833*^9, 3.806324155049063*^9}, {
  3.806324850259924*^9, 3.806324863928026*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "4"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.80632461702213*^9, 3.80632465858255*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
    1.], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQ7ZX64uKBl6F2DGDwwb65sbuiS7LFHsZPKXkv2Sk5
Bc7nmOK58MPHJXD+9gtG7u5y6+H8iOY7tw53b4Hz8zcW6874shPO/zTh2glG
xv1w/omDx/aftzkE52dWevJGvjkC5x/kNPq/Jvc4nL9s8ZF/Uqqn4HwHsb2L
gtedgfN1j9/ZcUzrPJx/xSH43cp3F+D8HK7sS1cNLsH5p2+E7+XruwznB7tF
PHzy5Aqcb7agO3yByjU4/8G/yVcy6q/D+U89zy8WO3wDzt8w837lRcVbcP7S
DuZOzarbcP7X5KhXabvvwPncLm1BG8Xvwfk1Ak95Hsbch/N59mkzXPd9AOfb
lvn/PfwLwZ+zpGex8pyHcH5cqMlZTu9HcP7Wq6mT931D8C3PbGB6Nu0xnK/g
mvZ1sssTON/UxHTilmcI/v1PvScXtz6F898YB7ZKGj2D89Ve675ivIzgH1Ep
vVTQ+BzO779yNTlI5QWc/z74wESmIwj+plBRZ8vCl3D+4rPNcx8JvYLzvx+P
qRY6hOA/mLj/q0Deazj/20VrySa+N3B+wRSlA5V7EHzxs0oCT+LeIuL36po/
Mv8Q/E/xC3PurHoH5+9PWN/K5/Meztd2iLVlX4bgT5fn/vr/P4IPAG/FGY8=

     "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQ7ZX64uKBl6F2DBDg0NzYXdEl2WIP46eUvJfslJwC
53NM8Vz44eMSOH/7BSN3d7n1cH5E851bh7u3wPn5G4t1Z3zZCed/mnDtBCPj
fjj/xMFj+8/bHILzMys9eSPfHIHzD3Ia/V+TexzOX7b4yD8p1VNwvoPY3kXB
687A+brH7+w4pnUezr/iEPxu5bsLcH4OV/alqwaX4PzTN8L38vVdhvOD3SIe
PnlyBc43W9AdvkDlGpz/4N/kKxn11+H8p57nF4sdvgHnb5h5v/Ki4i04f2kH
c6dm1W04/2ty1Ku03XfgfG6XtqCN4vfg/BqBpzwPY+7D+Tz7tBmu+z6A823L
/P8e/oXgz1nSs1h5zkM4Py7U5Cyn9yM4f+vV1Mn7viH4lmc2MD2b9hjOV3BN
+zrZ5Qmcb2piOnHLMwT//qfek4tbn8L5b4wDWyWNnsH5aq91XzFeRvCPqJRe
Kmh8Duf3X7maHKTyAs5/H3xgItMRBH9TqKizZeFLOH/x2ea5j4Rewfnfj8dU
Cx1C8B9M3P9VIO81nP/torVkE98bOL9gitKByj0IvvhZJYEncW8R8Xt1zR+Z
fwj+p/iFOXdWvYPz9yesb+XzeQ/nazvE2rIvQ/Cny3N//f8fwQcAqsfo9A==

     "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQ7ZX64uKBl6F2DGDA4dDc2F3RJdliD+OnlLyX7JSc
AudzTPFc+OHjEjh/+wUjd3e59XB+RPOdW4e7t8D5+RuLdWd82Qnnf5pw7QQj
4344/8TBY/vP2xyC8zMrPXkj3xyB8w9yGv1fk3sczl+2+Mg/KdVTcL6D2N5F
wevOwPm6x+/sOKZ1Hs6/4hD8buW7C3B+Dlf2pasGl+D80zfC9/L1XYbzg90i
Hj55cgXON1vQHb5A5Rqc/+Df5CsZ9dfh/Kee5xeLHb4B52+Yeb/youItOH9p
B3OnZtVtOP9rctSrtN134Hxul7agjeL34Pwagac8D2Puw/k8+7QZrvs+gPNt
y/z/Hv6F4M9Z0rNYec5DOD8u1OQsp/cjOH/r1dTJ+74h+JZnNjA9m/YYzldw
Tfs62eUJnG9qYjpxyzME//6n3pOLW5/C+W+MA1sljZ7B+WqvdV8xXkbwj6iU
XipofA7n91+5mhyk8gLOfx98YCLTEQR/U6ios2XhSzh/8dnmuY+EXsH534/H
VAsdQvAfTNz/VSDvNZz/7aK1ZBPfGzi/YIrSgco9CL74WSWBJ3FvEfF7dc0f
mX8I/qf4hTl3Vr2D8/cnrG/l83kP52s7xNqyL0Pwp8tzf/3/H8EHAEU06pQ=

     "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQ7ZX64uKBl6F2DGAg4NDc2F3RJdliD+OnlLyX7JSc
AudzTPFc+OHjEjh/+wUjd3e59XB+RPOdW4e7t8D5+RuLdWd82Qnnf5pw7QQj
4344/8TBY/vP2xyC8zMrPXkj3xyB8w9yGv1fk3sczl+2+Mg/KdVTcL6D2N5F
wevOwPm6x+/sOKZ1Hs6/4hD8buW7C3B+Dlf2pasGl+D80zfC9/L1XYbzg90i
Hj55cgXON1vQHb5A5Rqc/+Df5CsZ9dfh/Kee5xeLHb4B52+Yeb/youItOH9p
B3OnZtVtOP9rctSrtN134Hxul7agjeL34Pwagac8D2Puw/k8+7QZrvs+gPNt
y/z/Hv6F4M9Z0rNYec5DOD8u1OQsp/cjOH/r1dTJ+74h+JZnNjA9m/YYzldw
Tfs62eUJnG9qYjpxyzME//6n3pOLW5/C+W+MA1sljZ7B+WqvdV8xXkbwj6iU
XipofA7n91+5mhyk8gLOfx98YCLTEQR/U6ios2XhSzh/8dnmuY+EXsH534/H
VAsdQvAfTNz/VSDvNZz/7aK1ZBPfGzi/YIrSgco9CL74WSWBJ3FvEfF7dc0f
mX8I/qf4hTl3Vr2D8/cnrG/l83kP52s7xNqyL0Pwp8tzf/3/H8EHAN+S7DQ=

     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0.9},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{"DefaultBoundaryStyle" -> Automatic, "ScalingFunctions" -> None},
  PlotRange->{{0, 1}, {1., 4.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.806324660291873*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"NpTwoC", "[", 
       RowBox[{"e", ",", "n"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "4"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8063241719125085`*^9, 3.8063241762765694`*^9}, {
  3.806324221826468*^9, 3.8063242944203167`*^9}, {3.8063244638611927`*^9, 
  3.806324467882474*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
    1.], LineBox[CompressedData["
1:eJwVz3k01fkbB/B7Kdn37RbKTUZJIUTF00y2hEzSNibbENm3VpUYCpGtQipZ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     "]], LineBox[CompressedData["
1:eJwV1Xc4Vv0fB3Ajue09bpukhZ6MbJ+SUcqICiUZ2TtRCRUhQsbNk1FEiBYi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     "]], LineBox[CompressedData["
1:eJwVjns01Hkfx6UtpHWdYUZuMy67NjaKLUs+ksuT8ISsZdl1v4VcUmF1IRVh
E00JrUtW5BFR1K6+X5eDdhAycmlzHzO/3y9FmEJazx/v8z6v8zrvc94sv+Mu
geJiYmLRG/l/2wcK+rDQzSKC79RwWd//6Wz1D35jTGMwibMsKeUcQErSvKw6
pjX0zMZ3J3Gc0bemtLJC5lFon7N6EM7xRd/37qm5xgwAvoer7zFONML5rSaZ
zBMw+eHmvUuc8yjl/JXT6cwLUFzlWih1IxsFnHjLTGPmwuo5q2lmXjGSzD1U
/G7+Dkz1fNQ19HmAGnp329mp3wcn7yPW5/3/RD+mvBppvVIPZyroBRy9FnS8
Ntbg5uJjaOR+4cChd6CFq4OdmzYh0OGWlxu1cVFnczt6bt4C7ENVoqKEXhQa
f+hLD6oNYtZXf5VnvkDNUrs/V0V0wJx0axCrkIf+KG1bV9H5G0L1lXN5kUPI
UqmpxLW6C/YGfyHjpDeKDDpeNbZ/8xwkpgKSPr/9Bw1Yus5VzPWCFbsYP00b
R+HbjvXzDPtBWzl310n5ScQdcm+SyXoByhKVn6J7ppCr7Y8T09MDoGNWsM68
NYO+K7riXqQ9CEFmYTwb71k0vp4zEHL2JQCrklbnK0Qzh56XKrUOQfM9V7um
X0hUkzcW38cagexQpqth5RtUdnlzml7CKGieG/wklHiHlvw9iaA/X0G2TfN5
Yt88kra+6FKr/BqoBr2vfG4toF/lZrZPeI1BauHQxe/W3qPtT3eKvXQch/+R
hLNc1BLaf/K/n1pXxmHcypk9yBahgjsZpVoFE1C1L4fWNvwB/exm3C11eBLQ
N3tU7r9eQQ95gTlPlyfBYXS/CSn1CZl21YjzOVMgvkv/tcjyM9K0CVrKsZ6G
nc6n9mq8F8MmxibZ9fxpQOZd9THO4nhsIfNZaeoMBFR4eNT2bMbUHudU5m4+
WMekW47f3oJ1SQNi0ws+WLqH6e9Ik8Bt2nH9UedngfitdNxQKIV/G+D5u2gL
IOCUZUpxwnb81hVni7cJQOE1N58TKouXy1PDG9oFMBJ3fd73lCxeX7W3C38m
ACldmtHeVFm8/Q5vjdezsXfryvtcJIu/XiSCK4YFkLOs6iQ1LIt9cukWR94K
wHAhyCBVRw73DoQRhSpCcDI90nwlXw4/cKMfNI0WgnTd5U5Wnjy+JntWgGKF
MMRNowmK5HHMM0Gm7Ukh+Lqd3Vl/Vx4b7f9ryDVRCDuM9HnejfK4Rts/MjJV
CH9TjEHRS3lc/b4mrzRPCNTupTIHhgKuzHZ492WLEHSG72ZUFSrg0u6UwkkF
AqgftAa3NiniDKNVr9/pBLTEvdpp16GIT16PUfVibPAY58nVPkX8H2/ffJ4a
AW5Jlx4BXxHPURZ5nV8TsCgUXJeRo+F921dyqy0IyM2erEkMpOFu+6iMhDAC
SO5U7bIyHT+qnj28N4KAm8Piq6e16LhI4RfpxeMEeChqHd66i45jRhzTI+II
UCtrP2BlS8eMsJ2Xfc4RoJ/q4XEgjo790vgptpwNf1ZK9xiPjkUdXokKLQSs
Ddh+S91WwuqutnEtbQTs6/Orq7+nhG1f7zoe00EAKhMppDcqYc6iuH9/FwH8
WYfan/qVsDGrwv7aSwKeeEmWFGxVxjEJS0yFNwQEHl7ML49WxpR+VqM8g4Sb
otFbSS4MTGs89aBZhYTQujEPaV8GNjvoWxWtRkLwYlfn3eMMnO5hXNTHJkEn
PVFdMZOB9S6OXMo2IEE2MiXrbicDB43pussfJAEaEqPnrJh4PBstyUWS0BT7
aO2BtQoeT3Z8ci2KBKsrVkmOR1XwROzoGVosCbFZ/IkP/ip40k0kwThNwh+P
H3ckp6jgKeYuFY1kEpSm1XSCWlUwv/i2hQGHhIfdNz5csN2BydqkS4eeklBp
mD342VMVUyXSDlxMQoE9zWQhfINz8uQcWzf+tSWc+Xhmg+Me5h3pJOFTp3Ow
XakqnjN9c8+9n4SxmpAn05Qqftfs1RvIJ6F/8atxuwtqeLnPjJksQ8HKiHbZ
UJs6Fot4KTKVp6B8ovpS4qg63iYZOzivSIGknzBg/4I6VreozPFlUiAy61HQ
0NTANpUMmQPaFJyZeZvom6SBc5OXxMW+p+BOAzdeVkMT79lzn0oKpECre9LH
5o0mNu+x55qEUHDSk1vftaKJbUP5FW/CKKjekukZIsnCnr+rBXtHUcBqFbn9
o8XCydIZE+aJFAzPnrBu/YmF+6dCBlevUpConV9T+ZyFo3LZOP4vCmx8hJHB
z9jY5bpf6GZEwQ7jQsv2ITY24ZQoZDZTIHMAUeYCNl65wQ4saqfAZXLiYYyE
Fk7NZ2/r6KWgeH3rz1vttPCtEvZR2gwFH+dPb9nM1cKSlMbywBwFl2+tSZ2V
1cb/As0tqJ4=
     "]], LineBox[CompressedData["
1:eJwVj3c4FXwfh6WEjCTk2MeK5GgoEr49lVm2xBNF9sqKirJXlJ0nOtkjUkay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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{"DefaultBoundaryStyle" -> Automatic, "ScalingFunctions" -> None},
  PlotRange->{{0, 1}, {-10.030266105733304`, 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.8063242706529655`*^9, 3.8063245685350657`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"NpTwoD", "[", 
       RowBox[{"e", ",", "n"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "4"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{3.8063244813510914`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] recursive bisections in \[NoBreak]\\!\\(u\\)\
\[NoBreak] near \[NoBreak]\\!\\({u}\\)\[NoBreak] = \
\[NoBreak]\\!\\({4.700019483074162`}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(3.122502256758253`*^-17 + \\(\\(3.4365999629359933`*^-13\\\\ \
\[ImaginaryI]\\)\\)\\)\[NoBreak] and \
\[NoBreak]\\!\\(8.651414122278267`*^-16\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8063246784334354`*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
    1.], LineBox[CompressedData["
1:eJwlkHk01fsaxjdK5tjGTWTspEimSsmrS4moc1CpS6Yk3cxD0kBIoURINBgb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     "]], LineBox[CompressedData["
1:eJwVkXk0FHwfxVFJtuwZ+wwGhRQKlW8qilAhW+qxNCg7kVBZouxroykhokjI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     "]], LineBox[CompressedData["
1:eJwVync41f3/wHGJyMiIONaxEkVkFMJLGZkNpLqLbCkr2Skhe3OSnR0iQriN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     "]], LineBox[CompressedData["
1:eJwVyXc4lv/fgHHJitIwctvKqHxRRjLyLkW2SCIUWSGrMlOypewVmd0oI3tl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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{"DefaultBoundaryStyle" -> Automatic, "ScalingFunctions" -> None},
  PlotRange->{{0, 1}, {-10.47448875189707, 7.085366198873957*^-25}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.806324793511828*^9}]
}, Open  ]],

Cell["\<\
So, yeah, I guess they\[CloseCurlyQuote]re not not partly real most of the \
time\
\>", "Text",
 CellChangeTimes->{{3.8063248054070525`*^9, 3.8063248115329127`*^9}, {
  3.8063248717070584`*^9, 3.8063248774375567`*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Shape of m=+2 feat. Ed Sheeran", "Subsection"]], \
"Section",
 CellChangeTimes->{{3.8042512100145044`*^9, 3.80425122042684*^9}, {
  3.8045105059687233`*^9, 3.8045105220822697`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Multicolumn", "[", 
  RowBox[{
   RowBox[{"Flatten", "[", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*SubscriptBox[\(p\), \(2, 1\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(2, 2\)]\)\>\"", ",", 
      RowBox[{"Re", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"With", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"e", "=", ".1"}], "}"}], ",", 
           RowBox[{"NpPlus2", "[", 
            RowBox[{"e", ",", "1"}], "]"}]}], "]"}], ",", 
         RowBox[{"With", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"e", "=", ".1"}], "}"}], ",", 
           RowBox[{"NpPlus2", "[", 
            RowBox[{"e", ",", "2"}], "]"}]}], "]"}], ",", 
         RowBox[{"With", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"e", "=", ".5"}], "}"}], ",", 
           RowBox[{"NpPlus2", "[", 
            RowBox[{"e", ",", "1"}], "]"}]}], "]"}], ",", 
         RowBox[{"With", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"e", "=", ".5"}], "}"}], ",", 
           RowBox[{"NpPlus2", "[", 
            RowBox[{"e", ",", "2"}], "]"}]}], "]"}], ",", 
         RowBox[{"With", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"e", "=", ".9"}], "}"}], ",", 
           RowBox[{"NpPlus2", "[", 
            RowBox[{"e", ",", "1"}], "]"}]}], "]"}], ",", 
         RowBox[{"With", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"e", "=", ".9"}], "}"}], ",", 
           RowBox[{"NpPlus2", "[", 
            RowBox[{"e", ",", "2"}], "]"}]}], "]"}]}], "}"}], "]"}]}], "}"}], 
    "]"}], ",", "4"}], "]"}]], "Input",
 CellChangeTimes->{{3.805458864923042*^9, 3.8054589307997527`*^9}}],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"\\!\\(\\*SubscriptBox[\\(p\\), \\(2, 1\\)]\\)\"\>", 
     RowBox[{"-", "0.3137673893133078`"}], 
     RowBox[{"-", "1.5247413386423725`"}], 
     RowBox[{"-", "2.6595700487981055`"}]},
    {"\<\"\\!\\(\\*SubscriptBox[\\(p\\), \\(2, 2\\)]\\)\"\>", 
     "6.1266154191760025`", "2.6630130613042873`", 
     RowBox[{"-", "3.6177875183708226`"}]}
   },
   AutoDelete->False,
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{3.8054589416116943`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Re", "[", 
      RowBox[{"NpPlus2", "[", 
       RowBox[{"e", ",", "0"}], "]"}], "]"}], ",", 
     RowBox[{"Re", "[", 
      RowBox[{"NpPlus2", "[", 
       RowBox[{"e", ",", "1"}], "]"}], "]"}], ",", 
     RowBox[{"Re", "[", 
      RowBox[{"NpPlus2", "[", 
       RowBox[{"e", ",", "2"}], "]"}], "]"}], ",", 
     RowBox[{"Re", "[", 
      RowBox[{"NpPlus2", "[", 
       RowBox[{"e", ",", "3"}], "]"}], "]"}], ",", 
     RowBox[{"Re", "[", 
      RowBox[{"NpPlus2", "[", 
       RowBox[{"e", ",", "4"}], "]"}], "]"}], ",", 
     RowBox[{"Re", "[", 
      RowBox[{"NpPlus2", "[", 
       RowBox[{"e", ",", "10"}], "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*SubscriptBox[\(p\), \(\(+2\), 0\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(\(+2\), 1\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(\(+2\), 2\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(\(+2\), 3\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(\(+2\), 4\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(\(+2\), 10\)]\)\>\""}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", "\"\<Divergence Not Removed\>\""}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.8045100356035676`*^9, 3.8045101033535337`*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] recursive bisections in \[NoBreak]\\!\\(u\\)\
\[NoBreak] near \[NoBreak]\\!\\({u}\\)\[NoBreak] = \
\[NoBreak]\\!\\({0.000024185766477748702`}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(-2.49366499671666`*^-16\\)\[NoBreak] and \
\[NoBreak]\\!\\(1.5939906358846744`*^-15\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8045100653221345`*^9, 3.8045101059880857`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "slwcon"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Numerical integration converging too slowly; suspect one \
of the following: singularity, value of the integration is 0, highly \
oscillatory integrand, or WorkingPrecision too small. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/slwcon\\\", ButtonNote -> \
\\\"NIntegrate::slwcon\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8045100653221345`*^9, 3.80451010605203*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] recursive bisections in \[NoBreak]\\!\\(u\\)\
\[NoBreak] near \[NoBreak]\\!\\({u}\\)\[NoBreak] = \
\[NoBreak]\\!\\({4.503669942224799`}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(1.734723475976807`*^-17\\)\[NoBreak] and \
\[NoBreak]\\!\\(3.820404467573641`*^-16\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8045100653221345`*^9, 3.804510106112974*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] recursive bisections in \[NoBreak]\\!\\(u\\)\
\[NoBreak] near \[NoBreak]\\!\\({u}\\)\[NoBreak] = \
\[NoBreak]\\!\\({6.\
28318519448951320385675257047976413268819406710008479421958327293`65.\
954589770191}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(1.7695567233744214`*^-13 + \\(\\(4.163336342344337`*^-17\\\\ \
\[ImaginaryI]\\)\\)\\)\[NoBreak] and \
\[NoBreak]\\!\\(1.367876784470429`*^-12\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8045100653221345`*^9, 3.8045101063587437`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \
\[NoBreak]\\!\\(\\*StyleBox[\\(NIntegrate :: ncvb\\), \\\"MessageName\\\"]\\)\
\[NoBreak] will be suppressed during this calculation. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/stop\\\", \
ButtonNote -> \\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8045100653221345`*^9, 3.804510106421692*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "slwcon"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Numerical integration converging too slowly; suspect one \
of the following: singularity, value of the integration is 0, highly \
oscillatory integrand, or WorkingPrecision too small. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/slwcon\\\", ButtonNote -> \
\\\"NIntegrate::slwcon\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8045100653221345`*^9, 3.804510106795339*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "slwcon"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Numerical integration converging too slowly; suspect one \
of the following: singularity, value of the integration is 0, highly \
oscillatory integrand, or WorkingPrecision too small. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/slwcon\\\", ButtonNote -> \
\\\"NIntegrate::slwcon\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8045100653221345`*^9, 3.804510106928217*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \
\[NoBreak]\\!\\(\\*StyleBox[\\(NIntegrate :: slwcon\\), \
\\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during this calculation. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/stop\\\", \
ButtonNote -> \\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8045100653221345`*^9, 3.8045101069891586`*^9}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{{{}, {}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.368417, 0.506779, 0.709798], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwsVnc419/7FpFZiLIySkgZlSS8Xg+RKGSPkqxEoYzIyCoRsskmK6GMkHDe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        "]]}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.880722, 0.611041, 0.142051], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwlkHs4lHkfh52amUdCKjVWTk2titU7zJaNvpJNDpMoKRtNRGyEyovWi0RR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        "]]}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.560181, 0.691569, 0.194885], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwl0mk4lVsbB3BDhkTJZu9nhwyhHGPiKMm9NKlkno8SlSSUITI1UOoYMuXI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        "]]}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.922526, 0.385626, 0.209179], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwl1nk8VN8bB3BLiWwhc5mEKQottPiWJc+pFNIiVMqSbFGSCmXJrkiLpBKS
UEpElpLCxaTVvsxqGUsKzW1BWtTv9Pr9Na/3697XnHvveZ7PeRhuR209xURE
RFRERUT+/W7x/NBKftxlVv5WLm+7eqbZ8MPdbr2qq6Ez5K5oZVYo0KQ7L5aq
moNYXNmdsKxEWG40985NVXvY+dps9r6sdDBuWVWcrOoBgovZEkZZD4BMrze8
oBoAaZK3Cj/eegYxUYmnzqnGwrVPJXkNmW/BI4BSTVBNga9qxV8t0nggmWJ1
+/OXXDjTFBWV/XAMnrSstLBQL4K1SzY83PzfBDjE8Ln1iWWwSv1Mow3rFxx9
dGJZ6vhTOC6y/WP1UVH0NanrlahoDaRPuIJs1gz0qrahptm0Dq7rzc5pmJiF
fIKtZPeOMeG+j3b8XUIa1Uqt/Ftw5CW06DqWjPbIors5zD907TfATA5/1rJv
DkK0qmy7h+/gfbcCc951BbTsJb+iQa8ZlDQyJEbLFVEHshPeF7bg9Sttl7Uq
Id/Zh9s6Ddpgg93SkvSquegte0+V3MV2qNjCC62/qYyiucPKh660A+Uh3iHM
UkZr+Sf9XqS2g+m1cDmVXGWU23tdIyynHfJY/Toe+coo7D0r6mNFO+g6pH/o
f6yMlo3v2cwcaIf99rJmIc3K6JK8Q3OwUQcMbupMk/2rjOw2OwgGBzsgWSPe
p2QPDVUqrWge+NgBu07EzVu0j4YWCKSq+oUd4PVaKLjuRENfQ5+l9k11wLel
g/mBB2go6ZG6DV+mE6ZWndSmH6ahd2pD1e2rO+HEWGK4RDgNmX87llEX2wlO
7jKth7JpqIDccq42oRM4qllnsnJpSOniwlPkxU5wbmqy6LhLQ/06nXbVqZ3w
Q2R01PABDUW6rJWuLOgE8v2dUkEpDVW9/hP8qKMTbPqYM3lMGvovK3FPllYX
6LeN9toO0VBxbUSwtF4XfIx/O3FimIaWDJxID9Lvgm8O+uXJH2lIc5FT71bj
LtBYbKT/+hMNSRcsPfhjRxecUHCYRZ+kob4njUG2oV2Q+tdDxFqCQInN8tdm
tHXBS6U7A8NaBJL4Il5xlNUFHf07LlQtIlCk4hSHy+8CA53IriQdAgXt6pv/
aLgLJDJNNxssJZArr/iO83QXnAqrSbZdRaD/hneWP9ZhwXD99pta6wnU9+dK
h3cEC1Klb/v+3kcgmbGWxJOxLOB7xjgcdiLQWo7sxjMJLPBZvEqP7UygpNKz
j3KusCC5WyH8gSuBkHfoxZ48FhQ5BwjWehHodqubpX0LC7zCwj2E/gRyy13x
HBhs+AbzWupiCXTxst+J7YvY4BG8ZZYwjkCV4Q/0nJewwcsL5hNnCaS4V/tG
iCEbkjdlD7olEKheVjWo3IoN2zRHuX0XCKR1UsRgyXE2rOP0GwVdI9CQVXMO
rZ4N/+V37Zh5F19PXHzp8is2mPxNWfwX2+NdRIhMExvO0qNPTuYRqH+7wU4x
Dhuis0bDu+8TqMfu8p9PQjaUG83TvlBIILaz3d4XdA5c3xaTeryMQMStB+ZI
kwOyuiOdG8sJtLtP3OCZNgfCbG6fVXxMoA63MolHBhzwPiRvce8JgVoPKpdl
bOZA4WVn/fJKAr05xpILOM4Br+nxY/YkgaRK9X8KT3IA1UWzf2Nbjp8d8jnN
gRpGSVF2LYFeBq19vj+eA7uvzCl6X0cgZugNH+tMDvR8Tx7d8YJA4lVf7Bty
8P9PfW0ZwN7wxwqtv8+BXyb62oENBCIjf9LWlHGg2N9ZNeklgariHJkL3nBg
sW+UXt5rAv1uKC262cyBWKnSyEVvCGQqKZOu0smBPRmzzHOwK889PybXx4Hp
JKRw9S2BHl+ar/FzggNjjTLk3kYCTbQEzg78ha/zjwYzsVcrNk1QIlwIzrPM
XNpEoNKU8HdD0lyY9I7XncAuvtEb3Mrgwlq5M+hgC4F8ddW4KxdzQeZQLvMZ
ts5TB+OUpVzY/insjWwrgW6xW3/uXsMFE9+0ffnY+7zlHCtMuZDHCR8cx6ZN
bXmmuoELCrZOlGkbrieCGcrfyoWONRvPvsDekifCX2fLBeXIT0oS7bhf1qwz
vbWHC0oJbZrm2OG7H/8+4MaFubFJlRXYxu+/OtUf5EJ4pbQFhT0ZqF+ldYQL
3sYSdgs7CHTk6r3Twye5YHS55kMMto72ULflaS4coC04Xow9WMYwy4/mQvl6
6xAudpa5S6Z0PBfiHGVFxToJ5NSR9sf3AhcOcowlFmOreLBcmpK5sM/lboIV
dsc3pRr9VC7crlyQ6IOdFGOjcfkmF16PRs8+i71V6ULE12wuNKmlzcrGlsx5
3Wt3jwsz75pEV2IzV0qg8kIu/JUxCWnBjqzbkEUr5ULzDF9qANvENkLkVAUX
xo5kC8axJwXPXDlVXFi1u8RGvItAJcemSON6LrRNHTWVx/YTNWRkvOJCVHVR
rgq23uVjUdONXNi7bnOCBvZ7zYcCl3Yu9K6VHFmInV08sp5kc0E3+02DNrYL
WpzN6OFC8XU3jX+mt7iLxQxwwcbzzjcGdtf+LLfBD1zIiPXeqIadTPHrNgm5
cCojSm4u9vYI1YV53/D3j2qwl8KWkt8dI/kDr28oS/v9730zkwd8/uD9Hl5i
O/bvfZc3b3wrzoNfE1OSXGzTauncpVI8ODCyxfgF9tQ2yxkX5Xigf3pqqBC7
rDvWg1LigWEKWzoF2/9ILdNGlQfVG+oenMT+cN44TkmLBx3X5feuwc5VOzkU
oMuDeVYLvJSwXQtKN3Ut54FTXsbYGN5v1tulEjeMeGAZpOOZip3s6OP104wH
xS4juw9hbx+90+BozoMXAwG1RtgNszXOqu/gAf/+ZpFWXG/RaY7DEfY8UGyB
jlRsM71UC8FeHhx29tR0wX5spSCZ68GDG37pmgJc33fixRN0Q3iwqDzu+Svc
D4qD8eHLI3iQbtEbHYUdCXIBq2J5oOziPnftv/6ZVNm/7iIPsvyOp2bifpP3
WG64M5sHq+gHGTubCRRWU6q3O48Hvzub1k3hfh2hG2k6FvDAwPqE1k1sZutG
ac/HPDCd82dHH+73YNgrOPWGB5ru42pb3+F6SOvpOt3Mg5hd9HgBzgv7Sfd3
0R08uD10/XkA9vJCvyfne/5ZNyoF58sAPfZC1lceNBrcDnz6ikDbJh8avaLz
wThedjyVifNn52r9Rg0+WOt3Dc/G1il8qtWmxYeAXZtzQuoJJObBlOcv5wOT
W+5vh/PxSStniNrAB48LEu4jNQRiFM5IJg7zwW7V2UuFOH8vSp47q+bPh4LZ
k19+PcX55y5/mhHIh/OaEXRL7C463XtJBB/0wqOqODi/E+P1zeAKH74IKiz7
cf5PuO8b8XrGBx2F8f3xD/H5qvRLiU3ywa09Ruo2Pi8m69LXWTXwoTEyTOlJ
ATajO2lJKx9EXU0sefm4/nr3r/n8ng+z6dMrZuDz56ejZ2ywYjco5WVSrEwC
hUhLPBwhuvE8Z3+l4SaBflXeZTnO7waHK+1XSzLw86p+0DPT6QbRH02Po9MI
NM061Cpm1g0e1XQvcXz+idj7q5/36YaI15WeZ87j/RdXsJz264YTegqjWxIJ
JFr66JhfQDdMDdY1ypzD30/xG9MmohuCPAfy4/F5K94SeFj5ajec0m2pdY3G
ebk1tCKT7IaxijKb5JMEkjY/Y/uI6AHx6oijP/fj/qo5qtCg1gO9VY+IOBec
F8Z7W7iMHogKfX1MFs8HbQZLt89Y2gPWpadMCDxPpM1vs9qDesC8NmahvD3e
z+/z109794DY+ErTJAsCmeeX61tV9kBTcPVmFp5XgrRvCZ1resD1pQ9NZQmB
7mXFFx5n9oC9U/m13br4ea47Lslo6oH0vXL332nj9WJEF1P9PXAra1Lppjru
T+dt6lele+FByuXfTfK4vucMyQiceiF4QvZz0Gca0uOWIP6BXmDaMKROCWmI
kxMZwPLqhdp63Y9BY3ieW6PGb/TvhRpVuT9HPtDQZ2e7B5WxvWBH44Ss76Mh
9we1VikF+P7C89Wnm2loy+bMMxa/eyEpUsrLuoCGZKqXiLC29cHGCz8OmOyn
oU9bNcvO2fSBduBUURCeX5t4c73N7Pog2T/DtWgvDV36Md18x6EP+sU+f1Sx
pyFFw5ZbAe590Bx57eY7SxpSKQgAxeA+cJsWTXq8goa00qrCt+X2QX3YxECK
KA2tC9oxXf+zD7Ysypg8fUMZTR76EGo13QfnjD+ztl5TRsX7o342/cX3L14Y
qHpFGS2wKv3OmSGACh+3gQfnlZGkGvGVkhOAwfqppPIIZdRR2/N+3kIBeLdE
mTl5KiNfWb+WE9YCWHnMdN/35cooI/d8zsIMAawLUSG9n81FLrtWN0pZ98O+
oBWXGNlKqLzT80r1ZD9EstwCAjwVkdG7YrH31wZgcvzKx0i6AtLc5DVxxXwQ
bvUaT62dJ48MVxteLns/CA7ywpn5n6VR79cLr3PihuBKsCSz6pokGlu1M051
5XtYLa3jtapoBlo0umxEtP099Ar3mCS9E0FMrcA2/6hh6G1Y7d2bPwWXOjrd
bbU+QMKvH5bN1RRQduRlMeYHOMMIbyxz4UHJLuWNRsc+wtOm3Zqr1d7W5DTG
3OxXHAGLH7k+jPsjNd9fOoUq1o3AnuROYVjsVE3f5ZqJOX6jsP6tLkt0QpSc
bDVRjZYbA2Lzxm9qQbNI/5QFZPDzMei713LfNE+WJBoXzBl0+QS/BNmV+1kK
pF1nwW+1P5+gUVFo2fZtLvl1/21ffr4QrhpuOkimqZAT12caHigUwppTfg0r
7quQU80+00NFQuhX/NaV/0SF/AsrL1JlQhg96nG8rEOFlNGsLxKrEcKdWcdP
68irktp9g1912oVworx8YWGcKungqhMc+EsI9AWCAiKETjqmnl//c1oI62p/
aVQl0EmXls9SESIUmHR/ave7QSc90dO0+JkUCO/S2r5X0Mnjmluep8tTkD7I
sbg7RSfP9x3+W7uQgsM11gcfhMwja1yL4uS2UoBS212CEtXIymZf657tFJzz
Z52DW2rkYzM9hYc7KUgp1fLTLlUjC9TuZGzbQ8FWv2entvDUyDR2Wul5N7z+
n3Z3hWXzyUCbM4LZwRTMzbyWGMCaT/rXbMzjhlLw1NrVP+zTfNJ3ueiR/HAK
xg9EvCgRVyfdZMKmrGIpoH0o2/XIQJ20eXVMPuESBfUvXU4uuaBOLkHO62bd
pcBR8txvHVsNclERXZx1jwJR63Ue2r4a5AJ19qu7Dyi4pz5xIOyMBqny29Z+
8yMKeosdB7c91yAlKiwPxz2noFvirGsyTZMUWyyxYlcNBT84IU1btTXJ6av1
k1p1FDwvsHixY7UmOX7CLJr5koLona095naapEB/9Q3xdgri2LYlhVc1SX7m
F5f2TgqsUsz9fPM0SbZskVYOm4JZT7RtKp5qkk2jusUbeii4TPfzNu7TJN/s
Gw5UFFA4j40S0sY1yRevc036B/D7cWZl9kgxyOd5Gi+jPlLgU52ZULCGQVbQ
us/vHKNgTbIaZNswyNK4NFsGRcFJJ7TC9TCDfDi+R+XLFwrsSz9buMYzyHx3
5R5yHO/nhbM853sM8k5bW07SdwqWZY/np7xjkFnrk3xcf1KQ6ley7Mh3BplR
vE3fYJoCEckwWYb+AtL70f89nWoxzKYZoP8BiQZ0Cg==
        "]]}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.528488, 0.470624, 0.701351], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwl13c8Vf//AHCjKKNC1r1HtqKMRKR4vVF8JLIaZK8SSnaRlJVkjzIqK7JC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        "]]}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.772079, 0.431554, 0.102387], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwVl3c81d8fx0UKKULfENmbS0UK9/P+JFvDLGTvJCJZJZkJyc7eO7L3uvbO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        "]], 
       LineBox[{{0.9996567653556984, -12.14395775594916}, {0.9996567653557238,
         16.08924718378056}}]}}}, {
    DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, DisplayFunction :> 
     Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, "ScalingFunctions" -> None}, 
     PlotLabel -> FormBox["\"Divergence Not Removed\"", TraditionalForm], 
     PlotRange -> {{0, 1}, {-12.14395775594916, 16.08924718378056}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}],FormBox[
    FormBox[
     TemplateBox[{
      "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(+2\\), 0\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(+2\\), 1\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(+2\\), 2\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(+2\\), 3\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(+2\\), 4\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(+2\\), 10\\)]\\)\""}, 
      "LineLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #4}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #5}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #6}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.368417, 0.506779, 0.709798]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.880722, 0.611041, 0.142051]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.37345400000000006`, 0.461046, 0.12992333333333334`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.560181, 0.691569, 0.194885]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.560181, 0.691569, 0.194885]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.560181, 0.691569, 0.194885], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.6150173333333333, 0.25708400000000003`, 
                    0.13945266666666667`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.922526, 0.385626, 0.209179]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.922526, 0.385626, 0.209179]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.922526, 0.385626, 0.209179], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.3523253333333333, 0.3137493333333333, 
                    0.46756733333333333`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.528488, 0.470624, 0.701351]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.528488, 0.470624, 0.701351]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.528488, 0.470624, 0.701351], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.5147193333333333, 0.28770266666666666`, 
                    0.06825800000000001], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.772079, 0.431554, 0.102387]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.772079, 0.431554, 0.102387]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.772079, 0.431554, 0.102387], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5, ",", #6}], "}"}], 
           ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{3.804510066001502*^9, 3.804510545294339*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"pPlus2", "[", 
    RowBox[{"e", ",", "1"}], "]"}], ",", 
   RowBox[{"e", "\[Rule]", "1"}], ",", 
   RowBox[{"Direction", "\[Rule]", "\"\<FromBelow\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.804518915038018*^9, 3.804518969420539*^9}, {
   3.8045189999402113`*^9, 3.8045190098330264`*^9}, {3.8045191084085293`*^9, 
   3.804519110972151*^9}, 3.8045213191649885`*^9, {3.804591333495635*^9, 
   3.8045913344800406`*^9}, {3.804591381929338*^9, 3.8045913843784075`*^9}, {
   3.8049512316514273`*^9, 3.804951234431384*^9}, 3.804951319239684*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Refine", "::", "fas"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Warning: one or more assumptions evaluated to False. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/fas\\\", \
ButtonNote -> \\\"Refine::fas\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{{3.804518943451646*^9, 3.8045189702058105`*^9}, 
   3.804519011654339*^9, 3.8045191114317245`*^9, 3.804525277930222*^9, 
   3.8045953344096327`*^9, 3.8046031823013773`*^9, 3.8049527141131077`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Refine", "::", "fas"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Warning: one or more assumptions evaluated to False. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/fas\\\", \
ButtonNote -> \\\"Refine::fas\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{{3.804518943451646*^9, 3.8045189702058105`*^9}, 
   3.804519011654339*^9, 3.8045191114317245`*^9, 3.804525277930222*^9, 
   3.8045953344096327`*^9, 3.8046031823013773`*^9, 3.804952714186039*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Refine", "::", "fas"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Warning: one or more assumptions evaluated to False. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/fas\\\", \
ButtonNote -> \\\"Refine::fas\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{{3.804518943451646*^9, 3.8045189702058105`*^9}, 
   3.804519011654339*^9, 3.8045191114317245`*^9, 3.804525277930222*^9, 
   3.8045953344096327`*^9, 3.8046031823013773`*^9, 3.8049527142639685`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \[NoBreak]\\!\\(\\*StyleBox[\\(Refine :: \
fas\\), \\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during this \
calculation. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/stop\\\", ButtonNote -> \
\\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{{3.804518943451646*^9, 3.8045189702058105`*^9}, 
   3.804519011654339*^9, 3.8045191114317245`*^9, 3.804525277930222*^9, 
   3.8045953344096327`*^9, 3.8046031823013773`*^9, 3.8049527143129253`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Integrate", "::", "idiv"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Integral of \[NoBreak]\\!\\(\[ExponentialE]\\^\\(\
\[ImaginaryI]\\\\ \\(\\((u - \\(\\(e\\\\ \
\\(\\(Sin[u]\\)\\)\\)\\))\\)\\)\\)\\/\\((\\(\\(-1\\)\\) + \\(\\(e\\\\ \
\\(\\(Cos[u]\\)\\)\\)\\))\\)\\^2\\)\[NoBreak] does not converge on \[NoBreak]\
\\!\\({0, \\(\\(2\\\\ \[Pi]\\)\\)}\\)\[NoBreak]. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Integrate/idiv\\\", ButtonNote -> \
\\\"Integrate::idiv\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{{3.804518943451646*^9, 3.8045189702058105`*^9}, 
   3.804519011654339*^9, 3.8045191114317245`*^9, 3.804525277930222*^9, 
   3.8045953344096327`*^9, 3.8046031823013773`*^9, 3.8049527149175563`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Integrate", "::", "idiv"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Integral of \[NoBreak]\\!\\(\[ExponentialE]\\^\\(\
\[ImaginaryI]\\\\ \\(\\((u - \\(\\(e\\\\ \
\\(\\(Sin[u]\\)\\)\\)\\))\\)\\)\\)\\/\\((\\(\\(-1\\)\\) + \\(\\(e\\\\ \
\\(\\(Cos[u]\\)\\)\\)\\))\\)\\^4\\)\[NoBreak] does not converge on \[NoBreak]\
\\!\\({0, \\(\\(2\\\\ \[Pi]\\)\\)}\\)\[NoBreak]. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Integrate/idiv\\\", ButtonNote -> \
\\\"Integrate::idiv\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{{3.804518943451646*^9, 3.8045189702058105`*^9}, 
   3.804519011654339*^9, 3.8045191114317245`*^9, 3.804525277930222*^9, 
   3.8045953344096327`*^9, 3.8046031823013773`*^9, 3.804954603087755*^9}],

Cell[BoxData["$Aborted"], "Output",
 CellChangeTimes->{{3.8045189446075716`*^9, 3.80451897068037*^9}, 
   3.804519099395895*^9, 3.804520963824106*^9, 3.8045386693517113`*^9, 
   3.804598288232232*^9, 3.804623348103205*^9, 3.804980827800487*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Multicolumn", "[", 
  RowBox[{
   RowBox[{"Flatten", "[", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*SubscriptBox[\(p\), \(2, 1\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(2, 2\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(2, 3\)]\)\>\"", ",", 
      RowBox[{"Re", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"With", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"e", "=", ".9"}], "}"}], ",", 
           RowBox[{"NpPlus2", "[", 
            RowBox[{"e", ",", "1"}], "]"}]}], "]"}], ",", 
         RowBox[{"With", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"e", "=", ".9"}], "}"}], ",", 
           RowBox[{"NpPlus2", "[", 
            RowBox[{"e", ",", "2"}], "]"}]}], "]"}], ",", 
         RowBox[{"With", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"e", "=", ".9"}], "}"}], ",", 
           RowBox[{"NpPlus2", "[", 
            RowBox[{"e", ",", "3"}], "]"}]}], "]"}], ",", 
         RowBox[{"With", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"e", "=", ".99"}], "}"}], ",", 
           RowBox[{"NpPlus2", "[", 
            RowBox[{"e", ",", "1"}], "]"}]}], "]"}], ",", 
         RowBox[{"With", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"e", "=", ".99"}], "}"}], ",", 
           RowBox[{"NpPlus2", "[", 
            RowBox[{"e", ",", "2"}], "]"}]}], "]"}], ",", 
         RowBox[{"With", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"e", "=", ".99"}], "}"}], ",", 
           RowBox[{"NpPlus2", "[", 
            RowBox[{"e", ",", "3"}], "]"}]}], "]"}], ",", 
         RowBox[{"With", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"e", "=", ".999"}], "}"}], ",", 
           RowBox[{"NpPlus2", "[", 
            RowBox[{"e", ",", "1"}], "]"}]}], "]"}], ",", 
         RowBox[{"With", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"e", "=", ".999"}], "}"}], ",", 
           RowBox[{"NpPlus2", "[", 
            RowBox[{"e", ",", "2"}], "]"}]}], "]"}], ",", 
         RowBox[{"With", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"e", "=", ".999"}], "}"}], ",", 
           RowBox[{"NpPlus2", "[", 
            RowBox[{"e", ",", "3"}], "]"}]}], "]"}], ",", 
         RowBox[{"With", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"e", "=", ".9999"}], "}"}], ",", 
           RowBox[{"NpPlus2", "[", 
            RowBox[{"e", ",", "1"}], "]"}]}], "]"}], ",", 
         RowBox[{"With", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"e", "=", ".9999"}], "}"}], ",", 
           RowBox[{"NpPlus2", "[", 
            RowBox[{"e", ",", "2"}], "]"}]}], "]"}], ",", 
         RowBox[{"With", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"e", "=", ".9999"}], "}"}], ",", 
           RowBox[{"NpPlus2", "[", 
            RowBox[{"e", ",", "3"}], "]"}]}], "]"}], ",", 
         RowBox[{"With", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"e", "=", ".99999"}], "}"}], ",", 
           RowBox[{"NpPlus2", "[", 
            RowBox[{"e", ",", "1"}], "]"}]}], "]"}], ",", 
         RowBox[{"With", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"e", "=", ".99999"}], "}"}], ",", 
           RowBox[{"NpPlus2", "[", 
            RowBox[{"e", ",", "2"}], "]"}]}], "]"}], ",", 
         RowBox[{"With", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"e", "=", ".99999"}], "}"}], ",", 
           RowBox[{"NpPlus2", "[", 
            RowBox[{"e", ",", "3"}], "]"}]}], "]"}], ",", 
         RowBox[{"With", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"e", "=", ".999999"}], "}"}], ",", 
           RowBox[{"NpPlus2", "[", 
            RowBox[{"e", ",", "1"}], "]"}]}], "]"}], ",", 
         RowBox[{"With", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"e", "=", ".999999"}], "}"}], ",", 
           RowBox[{"NpPlus2", "[", 
            RowBox[{"e", ",", "2"}], "]"}]}], "]"}], ",", 
         RowBox[{"With", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"e", "=", ".999999"}], "}"}], ",", 
           RowBox[{"NpPlus2", "[", 
            RowBox[{"e", ",", "3"}], "]"}]}], "]"}]}], "}"}], "]"}]}], "}"}], 
    "]"}], ",", "7"}], "]"}]], "Input",
 CellChangeTimes->{{3.8048666498250537`*^9, 3.804866655502659*^9}, {
  3.8048666901606593`*^9, 3.8048667304500246`*^9}, {3.8048667740261574`*^9, 
  3.8048667785429173`*^9}, {3.804867046611473*^9, 3.804867065395094*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] recursive bisections in \[NoBreak]\\!\\(u\\)\
\[NoBreak] near \[NoBreak]\\!\\({u}\\)\[NoBreak] = \
\[NoBreak]\\!\\({0.019241423161113744`}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(3.6906124272875`*^10 + \\(\\(4.68328609241232`*^7\\\\ \
\[ImaginaryI]\\)\\)\\)\[NoBreak] and \
\[NoBreak]\\!\\(2.2177103155216227`*^13\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.804866741341329*^9, 3.8048667857275577`*^9, 
  3.804867067930422*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] recursive bisections in \[NoBreak]\\!\\(u\\)\
\[NoBreak] near \[NoBreak]\\!\\({u}\\)\[NoBreak] = \
\[NoBreak]\\!\\({0.019241423161113744`}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(1.84529940014375`*^10 + \\(\\(2.341689776577314`*^7\\\\ \
\[ImaginaryI]\\)\\)\\)\[NoBreak] and \
\[NoBreak]\\!\\(1.1088559869769982`*^13\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.804866741341329*^9, 3.8048667857275577`*^9, 
  3.804867068051319*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] recursive bisections in \[NoBreak]\\!\\(u\\)\
\[NoBreak] near \[NoBreak]\\!\\({u}\\)\[NoBreak] = \
\[NoBreak]\\!\\({0.019241423161113744`}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(3.6906124273`*^10 + \\(\\(9.366572214403899`*^7\\\\ \
\[ImaginaryI]\\)\\)\\)\[NoBreak] and \
\[NoBreak]\\!\\(2.217710315521614`*^13\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.804866741341329*^9, 3.8048667857275577`*^9, 
  3.8048670682741284`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \
\[NoBreak]\\!\\(\\*StyleBox[\\(NIntegrate :: ncvb\\), \\\"MessageName\\\"]\\)\
\[NoBreak] will be suppressed during this calculation. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/stop\\\", \
ButtonNote -> \\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.804866741341329*^9, 3.8048667857275577`*^9, 
  3.8048670683330803`*^9}],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"\\!\\(\\*SubscriptBox[\\(p\\), \\(2, 1\\)]\\)\"\>", 
     RowBox[{"-", "2.6595700487981055`"}], 
     RowBox[{"-", "3.116824529718508`"}], 
     RowBox[{"-", "3.2857348803967557`"}], 
     RowBox[{"-", "3.3448305086308046`"}], 
     RowBox[{"-", "3.3630212347847075`"}], "1.3884009747282822`*^15"},
    {"\<\"\\!\\(\\*SubscriptBox[\\(p\\), \\(2, 2\\)]\\)\"\>", 
     RowBox[{"-", "3.6177875183708226`"}], 
     RowBox[{"-", "5.621276507077562`"}], 
     RowBox[{"-", "6.153195600849409`"}], 
     RowBox[{"-", "6.322470066890371`"}], 
     RowBox[{"-", "6.375538721612853`"}], "1.3884009757739368`*^15"},
    {"\<\"\\!\\(\\*SubscriptBox[\\(p\\), \\(2, 3\\)]\\)\"\>", 
     RowBox[{"-", "3.7809364193040014`"}], 
     RowBox[{"-", "7.903843622915214`"}], 
     RowBox[{"-", "8.906196626795282`"}], 
     RowBox[{"-", "9.2127146490241`"}], 
     RowBox[{"-", "9.309314632766881`"}], "1.388400976819587`*^15"}
   },
   AutoDelete->False,
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{3.804866742136607*^9, 3.804866786466484*^9, 
  3.8048670692972593`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Multicolumn", "[", 
  RowBox[{
   RowBox[{"Flatten", "[", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*SubscriptBox[\(p\), \(2, 1\)]\)/Pi\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(2, 2\)]\)/2Pi\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(2, 3\)]\)/3Pi\>\"", ",", 
      RowBox[{"Re", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"With", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"e", "=", ".9999"}], "}"}], ",", 
            RowBox[{"NpPlus2", "[", 
             RowBox[{"e", ",", "1"}], "]"}]}], "]"}], "/", "Pi"}], ",", 
         RowBox[{
          RowBox[{"With", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"e", "=", ".9999"}], "}"}], ",", 
            RowBox[{"NpPlus2", "[", 
             RowBox[{"e", ",", "2"}], "]"}]}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"2", "*", "Pi"}], ")"}]}], ",", 
         RowBox[{
          RowBox[{"With", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"e", "=", ".9999"}], "}"}], ",", 
            RowBox[{"NpPlus2", "[", 
             RowBox[{"e", ",", "3"}], "]"}]}], "]"}], "/", 
          RowBox[{"(", 
           RowBox[{"3", "*", "Pi"}], ")"}]}]}], "}"}], "]"}]}], "}"}], "]"}], 
   ",", "2"}], "]"}]], "Input",
 CellChangeTimes->{{3.804866824916457*^9, 3.8048669366087914`*^9}, {
  3.8048672981965246`*^9, 3.8048673030612073`*^9}}],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"\\!\\(\\*SubscriptBox[\\(p\\), \\(2, 1\\)]\\)/Pi\"\>", 
     RowBox[{"-", "1.0646926185063421`"}]},
    {"\<\"\\!\\(\\*SubscriptBox[\\(p\\), \\(2, 2\\)]\\)/2Pi\"\>", 
     RowBox[{"-", "1.0062523636961487`"}]},
    {"\<\"\\!\\(\\*SubscriptBox[\\(p\\), \\(2, 3\\)]\\)/3Pi\"\>", 
     RowBox[{"-", "0.9774993837915342`"}]}
   },
   AutoDelete->False,
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{3.804866889840887*^9, 3.80486693813233*^9, 
  3.8048673043257113`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Re", "[", 
      RowBox[{"NpPlus2", "[", 
       RowBox[{"e", ",", "0"}], "]"}], "]"}], ",", 
     RowBox[{"Re", "[", 
      RowBox[{
       RowBox[{"NpPlus2", "[", 
        RowBox[{"e", ",", "1"}], "]"}], "/", "Pi"}], "]"}], ",", 
     RowBox[{"Re", "[", 
      RowBox[{
       RowBox[{"NpPlus2", "[", 
        RowBox[{"e", ",", "2"}], "]"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "Pi"}], ")"}]}], "]"}], ",", 
     RowBox[{"Re", "[", 
      RowBox[{
       RowBox[{"NpPlus2", "[", 
        RowBox[{"e", ",", "3"}], "]"}], "/", 
       RowBox[{"(", 
        RowBox[{"3", "*", "Pi"}], ")"}]}], "]"}], ",", 
     RowBox[{"Re", "[", 
      RowBox[{
       RowBox[{"NpPlus2", "[", 
        RowBox[{"e", ",", "4"}], "]"}], "/", 
       RowBox[{"(", 
        RowBox[{"4", "*", "Pi"}], ")"}]}], "]"}], ",", 
     RowBox[{"Re", "[", 
      RowBox[{
       RowBox[{"NpPlus2", "[", 
        RowBox[{"e", ",", "10"}], "]"}], "/", 
       RowBox[{"(", 
        RowBox[{"10", "*", "Pi"}], ")"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*SubscriptBox[\(p\), \(\(+2\), 0\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(\(+2\), 1\)]\)/\[CapitalPi]\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(\(+2\), 2\)]\)/2\[CapitalPi]\>\"", 
      ",", "\"\<\!\(\*SubscriptBox[\(p\), \(\(+2\), 3\)]\)/3\[CapitalPi]\>\"",
       ",", "\"\<\!\(\*SubscriptBox[\(p\), \(\(+2\), \
4\)]\)/4\[CapitalPi]\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(\(+2\), 10\)]\)/10\[CapitalPi]\>\""}], 
     "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", "\"\<This s*Pi Thing, Though\>\""}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.80494846102381*^9, 3.804948508392808*^9}, {
  3.804949654580203*^9, 3.8049497232350903`*^9}, {3.8050280570662527`*^9, 
  3.80502808734648*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] recursive bisections in \[NoBreak]\\!\\(u\\)\
\[NoBreak] near \[NoBreak]\\!\\({u}\\)\[NoBreak] = \
\[NoBreak]\\!\\({0.000024185766477748702`}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(-2.49366499671666`*^-16\\)\[NoBreak] and \
\[NoBreak]\\!\\(1.5939906358846744`*^-15\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.804948524587081*^9, {3.804949711406044*^9, 3.804949730801689*^9}, 
   3.805028090397651*^9, 3.805036234288172*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "slwcon"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Numerical integration converging too slowly; suspect one \
of the following: singularity, value of the integration is 0, highly \
oscillatory integrand, or WorkingPrecision too small. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/slwcon\\\", ButtonNote -> \
\\\"NIntegrate::slwcon\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.804948524587081*^9, {3.804949711406044*^9, 3.804949730801689*^9}, 
   3.805028090397651*^9, 3.8050362343580875`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] recursive bisections in \[NoBreak]\\!\\(u\\)\
\[NoBreak] near \[NoBreak]\\!\\({u}\\)\[NoBreak] = \
\[NoBreak]\\!\\({4.503669942224799`}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(1.734723475976807`*^-17\\)\[NoBreak] and \
\[NoBreak]\\!\\(3.820404467573641`*^-16\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.804948524587081*^9, {3.804949711406044*^9, 3.804949730801689*^9}, 
   3.805028090397651*^9, 3.8050362344729986`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] recursive bisections in \[NoBreak]\\!\\(u\\)\
\[NoBreak] near \[NoBreak]\\!\\({u}\\)\[NoBreak] = \
\[NoBreak]\\!\\({6.\
28318519448951320385675257047976413268819406710008479421958327293`65.\
954589770191}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(1.7695567233744214`*^-13 + \\(\\(4.163336342344337`*^-17\\\\ \
\[ImaginaryI]\\)\\)\\)\[NoBreak] and \
\[NoBreak]\\!\\(1.367876784470429`*^-12\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.804948524587081*^9, {3.804949711406044*^9, 3.804949730801689*^9}, 
   3.805028090397651*^9, 3.805036234651759*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \
\[NoBreak]\\!\\(\\*StyleBox[\\(NIntegrate :: ncvb\\), \\\"MessageName\\\"]\\)\
\[NoBreak] will be suppressed during this calculation. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/stop\\\", \
ButtonNote -> \\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.804948524587081*^9, {3.804949711406044*^9, 3.804949730801689*^9}, 
   3.805028090397651*^9, 3.805036234764633*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "slwcon"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Numerical integration converging too slowly; suspect one \
of the following: singularity, value of the integration is 0, highly \
oscillatory integrand, or WorkingPrecision too small. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/slwcon\\\", ButtonNote -> \
\\\"NIntegrate::slwcon\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.804948524587081*^9, {3.804949711406044*^9, 3.804949730801689*^9}, 
   3.805028090397651*^9, 3.8050362350733557`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "slwcon"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Numerical integration converging too slowly; suspect one \
of the following: singularity, value of the integration is 0, highly \
oscillatory integrand, or WorkingPrecision too small. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/slwcon\\\", ButtonNote -> \
\\\"NIntegrate::slwcon\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.804948524587081*^9, {3.804949711406044*^9, 3.804949730801689*^9}, 
   3.805028090397651*^9, 3.8050362351663027`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \
\[NoBreak]\\!\\(\\*StyleBox[\\(NIntegrate :: slwcon\\), \
\\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during this calculation. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/stop\\\", \
ButtonNote -> \\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.804948524587081*^9, {3.804949711406044*^9, 3.804949730801689*^9}, 
   3.805028090397651*^9, 3.8050362352252693`*^9}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{{{}, {}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.368417, 0.506779, 0.709798], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwsVnc419/7FpFZiLIySkgZlSS8Xg+RKGSPkqxEoYzIyCoRsskmK6GMkHDe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        "]]}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.880722, 0.611041, 0.142051], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwtjnk4lXkbxw/eVDJ2ckyKRsqYEqWmMfxUZnKyJEuWkSXLTENDxZQyiSyJ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        "]]}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.560181, 0.691569, 0.194885], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwl1gk0VdsbAHDDCxUllSIlEnqZUl4a9F3/4jUSMtySDJlCUVE0GXuVOfK4
riE31M14qS7JvqJMyRwyz+7gHoRI8Xbrf9Y666zf2vvsvc/5vj0o2F8xdRQS
EBBg4Pv387jjWCOLbX7ox9Lvi4DRHAv7Xpk9UP3xbcBvS69sjSiQOQI3mN9F
FrGLSu+631A2AsWegsgFbI1969KTZM7Ad8OJTXPYAmvZMUvyZNAWy375DbuR
9y7QTtkGVPU4h/jYJg7VTLs4O9gv+rx1FHt/w+68xzIXYSh85Eof9ja95Mxy
qhM8W0yXaMcWp4ulTMu7gkz4SM5n7Gnpa3HbaW7AvfrcrAK7O6g73EL5MvQQ
3AUmtsMc7X35GU94fSw/Mwu7TYN8yDrOC+w+zVmkYLMSy3XCZa7Dz4TVrADs
PU0387ef84ZVib2+XtgvxDTUS6k+oLhr915b7Mfe8UqEvC841zqV7McWyTqV
+o+dH5Be/x2sjO03ICS3lXYLbgvnGK/53b+xx1oT5bug0yo+ObhIQHuIYiTb
+R5wPUUqa7GVe9yWlZ3xh3tJ/6QysCnrFALIcQHgILvN5g52UEDozUcywdC0
ulFYFLtUzum1RXEw2FyXmR35RcDcG9K04rkQEOHwuR+w3fkzV95S74PawSMD
/thnztk68+QfQsvevHnOTwIiZvenM1kPgfP6plg5dlX0+sFgu0fQdqJVloKt
V1Vjs5kWCh+zjI4bYCvr6FgYKUdAqMWFlsgFAmwbVsfKVkbAZsfhpQvYiW6c
xhHnSIiXEtPUxBZrrM9AZ6JAUkg1vuYHAbdFQxSt4qIhOnz6ycw8ARevEzIP
ZWJBc+0oSW6OgN3Cj/0YnrEwH83Sb/tOgNDjPZ2dlbFAj1sjG42dkutL1fB5
Al9VFE0Esb9yhOVbmuKAP/9XR/MMAcZ2G5XkwxLA+PwGM/1vBGyZKA4+OpgA
sW6un9hTBPDunh/22k8BlWcWm6OxH1HTMirGKHA3Tdywa5KAija1HZcMqHBc
XLPg4gTOPyN9jVeLyRDQQF/UG8ff0z0Y0WOeAhVB/KlmHs4ft/uEaHYK2DjO
l7pgF1c4WmWrp4JPh2dPBJcAqwG6jEBXKjg76B2oY+N82axDTddNA297+StS
I7i92GNPJyafQR2YtJd2E7Cg27/wVDYdDC1GjPdh87tvWpgdTof8RMoHRhcB
zSrPV76OTQepBY+XaZ0EJL8V8bm1NwOUnLbY+XTgfB0sPy5yJxOMorNvjLfg
+Ggfmt4kRofA26vdZGsJMGtrNarTogN9o1f29RoCDG97vLhLpsPd/S78umoC
dn6k2vTT6TAZqOJ+p4qAWfJCVcapl+BTYGPZ8IGAsABm0q6YLOhkuUwYsAh4
06D9999bcuEPG8GTnoU4n9i8o2qGuXDvScGpnAICnIQyj6+5nAvqxiFWXAZe
L/ZsMup8lwvWFQkP7fMJeFsbQH+jkQdLZ5efNcghYJPmpfwTn/NA9MFOZlcm
ju/MfnRNggHL4iZCTSl4vEIbSU4KDEibni72SiCAsWqGZaXDAJu6N98i43E8
VXLf651nQLZpRGB1HI4fedtH0WwGJDLXS++KISChZGVd4skCuHyJLNMUiuMT
1PW1PLQQ+m7oM8/dJkCyT1nN+WkhqKNwb8NbBFQf9Lqz4k0hbPqLt0bLD7c3
u2yryUAh3ClZHF26gcfrqunYo/sKJLTMVzy+RkCPUSAxN/wKxrWKNfwv4fyW
Vf1Dg/QG3FCSZrAlAVfyr6nHTxeB94muGTUNHN+D/c3VYsUQaLlzzaganq9V
Rn4LcsVwdqBIO3UnAS69OyptDIohXu3Vg9U7cDwl+my3xxUDiy8cMLCNgNOu
J2MZe98Cp1mSTpYhQEth+8InvxJIlKJsCBcmYCrqS5WgIAJZrWL9Fa18qCr7
iOoPvoeUlnfB8/Z8cPU9JkHmVUDH04L7Af3jULZceynLoxKudum/NSGPQwat
YlF2ew1ImA99lnzFA5L0uzSznE8g8qcv1VmcB+qVXcyPf9ZDFTNMZdqKCy0k
M/4LfgMkD0o/K7vPAfcVbk2tWk0Q4uH87GIhG2rbLd+timiG62Tzed2yMTAz
tOofGmqBlMIYlZjyUfgrNdQyVekLHK1MHpaqGYG+xZgWl3ttQPENdP+QPQzD
x+pp0uXtUGsg2zj37xDkJfT6Nip8hayMk9TB84OQ/kD44Q6/ThCfT1jeKDcA
Mw5nOU5vu+CkQ4q9y0gfrDxy3zR/Qw8kX/pGlljfC7clh8X7rXvB6cIXS9Ub
XSBeulOg7VQf2OzzsrVu6QA9H+Nf5T/6oETwwlX14S9AfRZG20btB12ydRxp
QwvYmO+pW35iAKIY0k29Cw3wqtUxpnR2ADq8dsV7vKuFfZ/yhEbiBkG31bmX
3PwBtho4zcQcGQLB67Rv1tRS0NmjE104MgSkU5Lwi8SA3qnwalrIMJBml+SY
4/8Cb7dJiIz2CAikz+2aXEhCylx1jmDzCPhr1tAmdApRhZJ3k2fAKEwYVXit
XVOGIltaHUyVxiB/nVVoUWolIsxY0UIVY+ClJPju6ObPiGG+/vA+LzZEFaVZ
D1OaEK0uKGlAigM7ond9FZ9qRd8rrW9JveeAf/W9msGEDtQXjWYkL3NhQvzS
z6kD3Wi28YBM4CoeMPmPAt0t+pBnrCLLt4QHUeb2seRDA2hDnaLkkM04kAwE
dFPXDSGz1qyfcovj4M/cIK87N4ymLjx176Lz4WlY9jxbewzN/LtMxy6bD6mP
JvJqDoyhuXrXX8O5fJiYbqvJOzKGlkA7gijkA4nucjXcYgyJby3PFUJ8EMiz
LHrkN4a29w1NqTbj9nhq9ZnlY8jKVtXXewGXBz2WkzvHRufiw/R//OIDa7d9
/ZeLbGTTMLH8ngAB+qHJQLnMRo6kIsqDZfhcsvnL1IFANrq69XhJ4moC+jre
byFesFFYn9tSGZ5nqSUK6gcX2AjZ5oasOonPCeWbRH5lcFBxvfuJHiMCFK41
WgYVcNDrQ3+uyTHB7U2Qz2xhcVCWXDr1FJ73JB8UGdvBQZR2SkGYPX5/1c0j
MRJc5H36fv8KX1wedP6PO35c5IkOZ37F605ZatH5pw+4yF1D0IN+lwB/My2t
0Tgushe/PXcsGI//sTfRWcBFp6u8Vj+MxP3RF6qiCC7aSTqvJ5pBQAB1mXTm
FR5SzpUVbnuOyyvo29L9eUhxS3tVxktsML86FM1DG3+anjHE67C/TriYzise
EmEedQspwSa57H6yxENCKiK7zBGuv8F1TmrtOPr1pHxW6T22sbfivPI4mr52
KLCiEtenbUrafHoc9WvuSRBuxuUB1g+6n4+jruRJm+ZWbAH5tQzWOGqXyFWi
tWPny90w6RhHn7k78v7Xg61k2nlago9qzo56S/VjT97L4Kny0YfqZwcGBrFD
dUbqDfioJFO+MgDvo4K0tN6jwXzElO4OM8H7rkA7ZadvBh8VhFBMFQhsp1sD
e2v5KGfacuMk3tcFtnrQdn/jI7rD+h7WNPbs4eqb8gRKb2qiRX3//X9E/WtN
CJSqH+Vqi88pAvHK0cnhBKLmndLUwucmQd2ErM5OAqnm/98XkuyOsLf+hP8A
J6nlcA==
        "]]}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.922526, 0.385626, 0.209179], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwl13k8VN8bB3BLKVkqIvrKUiohyleR4lFRSUQoZSu0KGuWQqFoJbK0KVGW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        "]]}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.528488, 0.470624, 0.701351], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwl1nk4Fl8bB3A7UbZWa3YiaygqN5GS7BLKVoQsKUshopBS9pBkXwpFIUsy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        "]]}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.772079, 0.431554, 0.102387], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwll3c41e/7wI1ERTIqVEJCZmUVzvtGdsimsiURyh7JFtk7O3vv7HXsvfc8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        "]]}}}, {
    DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, DisplayFunction :> 
     Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, "ScalingFunctions" -> None}, 
     PlotLabel -> FormBox["\"This s*Pi Thing, Though\"", TraditionalForm], 
     PlotRange -> {{0, 1}, {-1.0571574273799342`, 1.7580349608559442`}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}],FormBox[
    FormBox[
     TemplateBox[{
      "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(+2\\), 0\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(+2\\), \
1\\)]\\)/\[CapitalPi]\"", 
       "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(+2\\), \
2\\)]\\)/2\[CapitalPi]\"", 
       "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(+2\\), \
3\\)]\\)/3\[CapitalPi]\"", 
       "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(+2\\), \
4\\)]\\)/4\[CapitalPi]\"", 
       "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(+2\\), \
10\\)]\\)/10\[CapitalPi]\""}, "LineLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #4}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #5}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #6}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.368417, 0.506779, 0.709798]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.880722, 0.611041, 0.142051]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.37345400000000006`, 0.461046, 0.12992333333333334`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.560181, 0.691569, 0.194885]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.560181, 0.691569, 0.194885]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.560181, 0.691569, 0.194885], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.6150173333333333, 0.25708400000000003`, 
                    0.13945266666666667`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.922526, 0.385626, 0.209179]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.922526, 0.385626, 0.209179]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.922526, 0.385626, 0.209179], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.3523253333333333, 0.3137493333333333, 
                    0.46756733333333333`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.528488, 0.470624, 0.701351]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.528488, 0.470624, 0.701351]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.528488, 0.470624, 0.701351], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.5147193333333333, 0.28770266666666666`, 
                    0.06825800000000001], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.772079, 0.431554, 0.102387]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.772079, 0.431554, 0.102387]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.772079, 0.431554, 0.102387], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5, ",", #6}], "}"}], 
           ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{3.8050367674264603`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"e", "=", "1"}], "}"}], ",", 
   RowBox[{"NpPlus2", "[", 
    RowBox[{"e", ",", "2"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{3.804511601923304*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] recursive bisections in \[NoBreak]\\!\\(u\\)\
\[NoBreak] near \[NoBreak]\\!\\({u}\\)\[NoBreak] = \
\[NoBreak]\\!\\({6.\
28318530717957354878316699074673427449610937361525670786805558565`65.\
954589770191}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(9.080334667093475`*^46 - \\(\\(40.912255050643104`\\\\ \
\[ImaginaryI]\\)\\)\\)\[NoBreak] and \
\[NoBreak]\\!\\(6.721426510726194`*^45\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.804511602989315*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "slwcon"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Numerical integration converging too slowly; suspect one \
of the following: singularity, value of the integration is 0, highly \
oscillatory integrand, or WorkingPrecision too small. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/slwcon\\\", ButtonNote -> \
\\\"NIntegrate::slwcon\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.804511603076232*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] recursive bisections in \[NoBreak]\\!\\(u\\)\
\[NoBreak] near \[NoBreak]\\!\\({u}\\)\[NoBreak] = \
\[NoBreak]\\!\\({6.\
28318530717957354878316699074673427449610937361525670786805558565`65.\
954589770191}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(4.304855103136426`*^109 - \\(\\(3.70411269175969`*^62\\\\ \
\[ImaginaryI]\\)\\)\\)\[NoBreak] and \
\[NoBreak]\\!\\(8.184449145379744`*^108\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8045116031441708`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "inumri"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"The integrand \
\[NoBreak]\\!\\(\\(\[ExponentialE]\\^\\(2\\\\ \[ImaginaryI]\\\\ \\(\\((u - \
\\(\\(Sin[u]\\)\\))\\)\\)\\)\\\\ \\(\\(Cos[\\(\\(2\\\\ \
u\\)\\)]\\)\\)\\)\\/\\((1 - \\(\\(Cos[u]\\)\\))\\)\\^4\\)\[NoBreak] has \
evaluated to Overflow, Indeterminate, or Infinity for all sampling points in \
the region with boundaries \[NoBreak]\\!\\({\\({0.`, \
1.3518575992650391`*^-14}\\)}\\)\[NoBreak]. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/NIntegrate\\\", ButtonNote -> \
\\\"NIntegrate::inumri\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.804511603268057*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "slwcon"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Numerical integration converging too slowly; suspect one \
of the following: singularity, value of the integration is 0, highly \
oscillatory integrand, or WorkingPrecision too small. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/slwcon\\\", ButtonNote -> \
\\\"NIntegrate::slwcon\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8045116033649673`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] recursive bisections in \[NoBreak]\\!\\(u\\)\
\[NoBreak] near \[NoBreak]\\!\\({u}\\)\[NoBreak] = \
\[NoBreak]\\!\\({6.\
28318530717957354878316699074673427449610937361525670786805558565`65.\
954589770191}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(\\(\\(-2.4615141850671613`*^94\\)\\) + \
\\(\\(2.421422577891593`*^47\\\\ \[ImaginaryI]\\)\\)\\)\[NoBreak] and \
\[NoBreak]\\!\\(3.404728094520719`*^93\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8045116034388967`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \
\[NoBreak]\\!\\(\\*StyleBox[\\(NIntegrate :: ncvb\\), \\\"MessageName\\\"]\\)\
\[NoBreak] will be suppressed during this calculation. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/stop\\\", \
ButtonNote -> \\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8045116034738655`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "slwcon"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Numerical integration converging too slowly; suspect one \
of the following: singularity, value of the integration is 0, highly \
oscillatory integrand, or WorkingPrecision too small. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/slwcon\\\", ButtonNote -> \
\\\"NIntegrate::slwcon\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.804511603549799*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \
\[NoBreak]\\!\\(\\*StyleBox[\\(NIntegrate :: slwcon\\), \
\\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during this calculation. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/stop\\\", \
ButtonNote -> \\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8045116036207266`*^9}],

Cell[BoxData[
 RowBox[{"9.080334667093475`*^46", "-", 
  RowBox[{"40.912255050643104`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellChangeTimes->{3.8045116036247225`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"e", "=", "1"}], "}"}], ",", 
   RowBox[{"NpPlus2NP", "[", 
    RowBox[{"e", ",", "2"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{3.8045115797159176`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] recursive bisections in \[NoBreak]\\!\\(u\\)\
\[NoBreak] near \[NoBreak]\\!\\({u}\\)\[NoBreak] = \
\[NoBreak]\\!\\({6.\
28318530717957354878316699074673427449610937361525670786805558565`65.\
954589770191}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(9.080334667093475`*^46 - \\(\\(40.912255050643104`\\\\ \
\[ImaginaryI]\\)\\)\\)\[NoBreak] and \
\[NoBreak]\\!\\(6.721426510726194`*^45\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8045115801065555`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "slwcon"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Numerical integration converging too slowly; suspect one \
of the following: singularity, value of the integration is 0, highly \
oscillatory integrand, or WorkingPrecision too small. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/slwcon\\\", ButtonNote -> \
\\\"NIntegrate::slwcon\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.804511580191474*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] recursive bisections in \[NoBreak]\\!\\(u\\)\
\[NoBreak] near \[NoBreak]\\!\\({u}\\)\[NoBreak] = \
\[NoBreak]\\!\\({6.\
28318530717957354878316699074673427449610937361525670786805558565`65.\
954589770191}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(4.304855103136426`*^109 - \\(\\(3.70411269175969`*^62\\\\ \
\[ImaginaryI]\\)\\)\\)\[NoBreak] and \
\[NoBreak]\\!\\(8.184449145379744`*^108\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.804511580267404*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "inumri"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"The integrand \
\[NoBreak]\\!\\(\\(\[ExponentialE]\\^\\(2\\\\ \[ImaginaryI]\\\\ \\(\\((u - \
\\(\\(Sin[u]\\)\\))\\)\\)\\)\\\\ \\(\\(Cos[\\(\\(2\\\\ \
u\\)\\)]\\)\\)\\)\\/\\((1 - \\(\\(Cos[u]\\)\\))\\)\\^4\\)\[NoBreak] has \
evaluated to Overflow, Indeterminate, or Infinity for all sampling points in \
the region with boundaries \[NoBreak]\\!\\({\\({0.`, \
1.3518575992650391`*^-14}\\)}\\)\[NoBreak]. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/NIntegrate\\\", ButtonNote -> \
\\\"NIntegrate::inumri\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8045115803992815`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "slwcon"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Numerical integration converging too slowly; suspect one \
of the following: singularity, value of the integration is 0, highly \
oscillatory integrand, or WorkingPrecision too small. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/slwcon\\\", ButtonNote -> \
\\\"NIntegrate::slwcon\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8045115805071836`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] recursive bisections in \[NoBreak]\\!\\(u\\)\
\[NoBreak] near \[NoBreak]\\!\\({u}\\)\[NoBreak] = \
\[NoBreak]\\!\\({6.\
28318530717957354878316699074673427449610937361525670786805558565`65.\
954589770191}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(\\(\\(-2.4615141850671613`*^94\\)\\) + \
\\(\\(2.421422577891593`*^47\\\\ \[ImaginaryI]\\)\\)\\)\[NoBreak] and \
\[NoBreak]\\!\\(3.404728094520719`*^93\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8045115805821133`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \
\[NoBreak]\\!\\(\\*StyleBox[\\(NIntegrate :: ncvb\\), \\\"MessageName\\\"]\\)\
\[NoBreak] will be suppressed during this calculation. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/stop\\\", \
ButtonNote -> \\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.804511580619079*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "slwcon"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Numerical integration converging too slowly; suspect one \
of the following: singularity, value of the integration is 0, highly \
oscillatory integrand, or WorkingPrecision too small. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/slwcon\\\", ButtonNote -> \
\\\"NIntegrate::slwcon\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8045115806910114`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \
\[NoBreak]\\!\\(\\*StyleBox[\\(NIntegrate :: slwcon\\), \
\\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during this calculation. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/stop\\\", \
ButtonNote -> \\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8045115807319727`*^9}],

Cell[BoxData[
 RowBox[{"0.`", "\[VeryThinSpace]", "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 CellChangeTimes->{3.8045115807359686`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Re", "[", 
      RowBox[{"NpPlus2NP", "[", 
       RowBox[{"e", ",", "0"}], "]"}], "]"}], ",", 
     RowBox[{"Re", "[", 
      RowBox[{"NpPlus2NP", "[", 
       RowBox[{"e", ",", "1"}], "]"}], "]"}], ",", 
     RowBox[{"Re", "[", 
      RowBox[{"NpPlus2NP", "[", 
       RowBox[{"e", ",", "2"}], "]"}], "]"}], ",", 
     RowBox[{"Re", "[", 
      RowBox[{"NpPlus2NP", "[", 
       RowBox[{"e", ",", "3"}], "]"}], "]"}], ",", 
     RowBox[{"Re", "[", 
      RowBox[{"NpPlus2NP", "[", 
       RowBox[{"e", ",", "4"}], "]"}], "]"}], ",", 
     RowBox[{"Re", "[", 
      RowBox[{"NpPlus2NP", "[", 
       RowBox[{"e", ",", "10"}], "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*SubscriptBox[\(p\), \(\(+2\), \
0\)]\)(1-\!\(\*SuperscriptBox[\(e\), \(2\)]\)\!\(\*SuperscriptBox[\()\), \
\(3/2\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(\(+2\), 1\)]\)(1-\!\(\*SuperscriptBox[\
\(e\), \(2\)]\)\!\(\*SuperscriptBox[\()\), \(3/2\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(\(+2\), 2\)]\)(1-\!\(\*SuperscriptBox[\
\(e\), \(2\)]\)\!\(\*SuperscriptBox[\()\), \(3/2\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(\(+2\), 3\)]\)(1-\!\(\*SuperscriptBox[\
\(e\), \(2\)]\)\!\(\*SuperscriptBox[\()\), \(3/2\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(\(+2\), 4\)]\)(1-\!\(\*SuperscriptBox[\
\(e\), \(2\)]\)\!\(\*SuperscriptBox[\()\), \(3/2\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(\(+2\), \
10\)]\)(1-\!\(\*SuperscriptBox[\(e\), \(2\)]\)\!\(\*SuperscriptBox[\()\), \
\(3/2\)]\)\>\""}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", "\"\<Divergence Removed?\>\""}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.8044481983378005`*^9, 3.804448248120593*^9}, {
  3.804509700697852*^9, 3.8045097963639774`*^9}, {3.804509844945094*^9, 
  3.804509862729232*^9}, {3.8045099076948223`*^9, 3.804509915787315*^9}, {
  3.804510009776622*^9, 3.804510026222278*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] recursive bisections in \[NoBreak]\\!\\(u\\)\
\[NoBreak] near \[NoBreak]\\!\\({u}\\)\[NoBreak] = \
\[NoBreak]\\!\\({0.000024185766477748702`}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(-2.49366499671666`*^-16\\)\[NoBreak] and \
\[NoBreak]\\!\\(1.5939906358846744`*^-15\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.804448256142144*^9, 3.804510547533259*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "slwcon"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Numerical integration converging too slowly; suspect one \
of the following: singularity, value of the integration is 0, highly \
oscillatory integrand, or WorkingPrecision too small. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/slwcon\\\", ButtonNote -> \
\\\"NIntegrate::slwcon\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.804448256142144*^9, 3.804510547623185*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], ":", 
  " ", "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] recursive bisections in \[NoBreak]\\!\\(u\\)\
\[NoBreak] near \[NoBreak]\\!\\({u}\\)\[NoBreak] = \
\[NoBreak]\\!\\({4.503669942224799`}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(1.734723475976807`*^-17\\)\[NoBreak] and \
\[NoBreak]\\!\\(3.820404467573641`*^-16\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.804448256142144*^9, 3.8045105477080984`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], ":", 
  " ", "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] recursive bisections in \[NoBreak]\\!\\(u\\)\
\[NoBreak] near \[NoBreak]\\!\\({u}\\)\[NoBreak] = \
\[NoBreak]\\!\\({6.\
28318519448951320385675257047976413268819406710008479421958327293`65.\
954589770191}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(1.7695567233744214`*^-13 + \\(\\(4.163336342344337`*^-17\\\\ \
\[ImaginaryI]\\)\\)\\)\[NoBreak] and \
\[NoBreak]\\!\\(1.367876784470429`*^-12\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.804448256142144*^9, 3.8045105480278015`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \
\[NoBreak]\\!\\(\\*StyleBox[\\(NIntegrate :: ncvb\\), \\\"MessageName\\\"]\\)\
\[NoBreak] will be suppressed during this calculation. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/stop\\\", \
ButtonNote -> \\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.804448256142144*^9, 3.8045105481127224`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "slwcon"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Numerical integration converging too slowly; suspect one \
of the following: singularity, value of the integration is 0, highly \
oscillatory integrand, or WorkingPrecision too small. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/slwcon\\\", ButtonNote -> \
\\\"NIntegrate::slwcon\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.804448256142144*^9, 3.8045105486452265`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "slwcon"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Numerical integration converging too slowly; suspect one \
of the following: singularity, value of the integration is 0, highly \
oscillatory integrand, or WorkingPrecision too small. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/slwcon\\\", ButtonNote -> \
\\\"NIntegrate::slwcon\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.804448256142144*^9, 3.8045105488290577`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \
\[NoBreak]\\!\\(\\*StyleBox[\\(NIntegrate :: slwcon\\), \
\\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during this calculation. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/stop\\\", \
ButtonNote -> \\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.804448256142144*^9, 3.804510548921973*^9}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{{{}, {}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.368417, 0.506779, 0.709798], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwUl3c8lu8Xx22i8TVTCSErUUYD931QRpIZoYRsouyVWQpFCGVkJ6syI1xP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        "]]}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.880722, 0.611041, 0.142051], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwV1ndcTe8fAPAGMkpcoykaSJSQVOiTUYS0UwhFKiUNK31JFCKlJZWR0tBQ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        "]]}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.560181, 0.691569, 0.194885], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwV13k4Fe8XAHBrFEWS7kW2EJVUlhbLmb6VJEJ2SiSKqBAhJUK2hCRESNbK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        "]]}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.922526, 0.385626, 0.209179], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwV1nk8lF8XAHBEG8mM8kNIkiypiArlPNYiUiIqSpYsUUpIVCiKVBRKspQQ
yVJItouIQsxuy5ZlzAxTokXRe9+/ns/382z3nnvuOXed61lbDyEBAYEaQQGB
/18tPdiUugl7w6JW8dz9CumG44WHXQdkdMCdurvubWYoSIky7ryWMQW7dOnM
0MxbsFlvVXaajB0ctfz83T4zFfQ7txXfk3GHkxtMXqpmvoC61He6t2UuwI/t
qyyeZ1TBtYhbF2NlrgNnTcu6+rRWcL/Al4mRSQQ3m40p2sm9sDTR4snXb89g
Sd3iad3HPHjTqb1nj0IR/H53UXKH9Cw4XuvreXerFNzstBTj7/2BsyUBmg9n
3oKpyDJtaQ1BYjqe2SIoiGDMdOGDzSZhoqX+PerY1QA3VHX2ThssIbxDLFYc
4TUC6cGqmpuLlhP1y7T/Ffg1Q/TU3ZChk2JETlbjguyGjxDwqDdBpkicIKRq
nh4qbINyn+lI070ShHDS6rNmFW3wh317oGifBNEiecZgR0MbNHfcWydjI0HY
kNbSZZltIDN82G7UXoI4LhYhMjzfBtnK1j7ubhJEqJCZl791OxgZ6YjMX5Yg
yqfaNG/z2sFssPB8UokEodncV/FevQMUYWbjATKJkJo6PRmv2wFJ9jm1/qtJ
hMDqP+uOER1gErlQf0eaRNBdZW7x7TugSEd5xTsFEhG2YO8sHdEBj8tn88U0
SESbboegD6sD9vt+er3ehEToUl2yFxt3QlZyZ9zxcyQi3+M5Or2nEz6UTi/d
dIFEKPzmd3dadcJBzfqxH0EkYqniVfFUh07Y36L8/noYiejzSwve4tcJt8P9
RCNukIjry3osHB92wtKOHt8/j/F4iENTeVOdcLmu69ZsE4mYy/iS9up7Jyy6
s8ndtIVErPsXYF31qxO8q8Qn4z+SiDM1iQVtQhTgLylaub6DRCzRZ/rwpSjg
5v3xnkYXidDfdmRcByhQVLXIo32CRGRuODGI7lIgOMVw2laUTLy/zr/bkkiB
mnW6Vx1WkInJL1eBkkKBvntz5UdWkgn9p5npw1kUcP1ySMVBkkzQFIadRCoo
YPZSUGD7GjKxWNqj23KQAvrhD69cUycTvstPUxlbqUBa4v7GaQ+ZyKmRKrfc
TgWBAwa2BhZkYsC/IQUZUOHgqK/6f/vIhC1L5mSeORV84u3uvd9PJnY+a+GH
OVFhz4Zbu4QPkwlhQ5UVyjepsNZPcGDOjUw8Pje05/wA/l7x01T6ZTLBVL6t
MT5ChQhu3/OjV8nEyq6dK504VJAxUv76OZxMRBrGM81mqSD+NHFT3zUy4SUK
HjKiNPhkuu3YmxgyoZP9OLJuOw0uN41GshPJRGuXQ434HRpstTxdqpuH3+8Z
X+1znwaDLmv8nfPx+PqCzzQ9pMHE2otXIl+QiWcDD9aGZdEgXHXH/caXZCJs
jBUxUUEDudsjj1VfkQnNGQfzxi806Gv33eZfSSZGZsfT107QIMBoVNavikw8
+hn889IUDdyWmdh7VuN4/nnwXOs3/v7JTw2HaslEv2DX8gxxOjjPK0SKNZCJ
uysdO0L06LDNfUPqfAuZMCexNzIM6WCwpKKs4wOZ+Eu+GL7VlA7DmRPrMz7i
+Uo91BrfT4cDjd5/dNvIBCHfdd/OnQ4yxyofmnSQiR8KXrwibzqcqpK3Fegk
EwWKv0xFz9Ihy+zliUpsaWXpH/UhdNAReRKsQiUT39QdHbfcpUNJjmpaP51M
PN/ELo5NpIO92Y65KAaZOL754rKxFDpMRq4tUGeSiY9aDysfP6NDoepncV8W
mXi6s0tueSUdPgW2Uj91k4lD5o5DIyN0qBAS913VTyYqJbU6vkzQQTS+p/Mm
ttLQsprhKTosXj83Moc9HVr1cPAXHex8H63pGiAT8SUKB/rEGCB3wropaIhM
/Lryc3cviQGEcVpuF/YJq06NHikGjOrK6u8cJhObxyOWdCkyAN1d6f8Vu01u
tJamw4AT6zXWm43gfODUFFD1GOD1Y31sInbqm+RHFEMGWBC7ng5h+9juDerY
y4CB7H1jF0bJBHXtOvdP1gy4zr1GrsLWm/x9sN2WAew/zl8XsJfefKHZ6sSA
3f8u118dIxP+9tfXfDzJgHiVpWXV2Cwl52UfTjHgaET10Z9j/98v4qPv/Rnw
x3Nrjcc4mRC/NU5tCmSAvvaOSynYgY51dY2XGFBV8GPiI7bp93OPG64z4LaT
9rAKG69fnWVsfQwDvnT/8jmILXln/cW6OwzwfSCWG4J96dhfD3SfAWIF95Mz
sIdVGYdqHzKg6W6p3jtsyx8vjWrSGFC+Jjl+BLvkXfSW6qcMkIo9kbpoAudD
wgn5qlwGaATtPKqIHX58p2hlAQPs+va262OzNUi/K0oYsCDzdsYW2+b3xNib
cgYkTZZ0emGXv2+gl1cx4GaQ08kwbIXE1IayOvy+7nDObezokxeKS5sY4Czq
9+Qx9tRm6/TXHxlAMth4MA/78N8Nca86GNDgaVD+Grvmw0JICR3HI4neWYWt
/IDlWdzNACV1hSf12HHuxfZF/QwQ55psbMKe0YoxKfzCAL9/59zeYzv9O6n1
ks2A5Xy6/f/vN7bpry2YxOvzNGXh/+9rPJJc8WKaAZ5uk87V2Pc8eXN5PxnQ
0zsfUIo9p9PEfv6XAZ+lfhP52K5C6cxcQSaYha9oSsP+0BHUmLOYCfdHvAXu
Ym9Ns3mVLcoEwXO7v1/GfuijmvlMggkXX79J88EW2Cl4J2s1Ex48Wipgj+0p
0hP6VJYJaYEusruxP1FfeT9ZywSfGT5PCXt75i2HTGUmXNvIDl6MXVx/NURU
nQm9DUJLRvH6aXwJSA3awgThp2R2HXaOsFfNkA4TVg86rHmErajiNGClz4RX
8pJP/LFT9xwQrAAmrI+ICjHFlvI2Xb/ejAlLyr8+W40tWrDJ87cNE472V84W
4fyLbleMcbdnwpHGjDUh2AL8VS86jjKhzyUmCbB/aM1PZXsw4ZRzWHQjzu/B
N+1BtqFMqGeHuBfi/XGsu/5hTTgTFrvKaLtiM+fKKlWjmfDMccpeErt1d/rC
QjwTNIWOPfHD+6/83ZnoFzlMOLfDykboC47nqOtzqQImnJnIZGbi/fxiscPH
iBImLKy9XL4LO9MCxB2r8Xx/L4T74npwq2NlsjCVCR5n8ywKcP1Y/G1RxVkW
ExzevknTxQ4n/+ru6WOCXmWdVTWuN0H2g/Il40yYs15cU/+ZTLj0Fmc7zzMh
JduOX9BLJnr/PmtuEWIB+6ua8jrswwopE9uWsoCid6f8Xg+Z2HcyQnO5JAuu
lTrM+uF6t338YFm5Kgs2lx0eEcb1sHipOWvdZhYIvV260h3XSw11/d9x21gw
+XchpQ7XU0U/pd1uhizwfCFHPYfrrej36caVdiygbvlFL6XgeC7cp3tdZcEN
dmVgTSuZEON13gq+zgLeqiR3Aeyd3StMomNYUGdhvNII94P41zdKsu6zoH2F
bUoV7h+EV+id/lwWbDwvFJPURCaeUFz32nWyYHr0vfxn3H8+1Wb8c2Ww4Jxc
If9PDc73F33l53pYULY1OlIa2zb68Ia7IywIH3XmWeJ+JmRgKfTxFwuK8iR7
Et/g/fBMqxrWdcHmLXI+NUVk4k7CmYD9Kl3weQMloKIQ1/srL9SdNbpgqelP
kxLcP8lHNqRc0u2Cr77Ceo9xf323QiaozKIL6ps7rzrk4v0dLLBV43wXbPzj
RndLJxOjFh1ZUu+6IGTzLj1mLL5/a+PdhJYuyGUIz5/B/d297eolsU9dcCjI
WVvkJq53+7ceFOrugjUX27+rReH+eihhYXKqC/K0NAft8Pmhy/nQkSbZbnBH
9fStAbh/nWOJXzjfDaqL+38IHyETy15vmZsK7gbbmphZKwcysXfmxqj35W7o
O7o9+J49mWgO2ll94mY3GEUMi0jZ4noSmuK9L70b2kzoLv8scb2KOtao9LEb
DkVrJxzbhdc/ZSCEsq4HJos+SBnK4/OTmlyP9sYeKE6SWGWEz1eqbx31Ezf1
gMN3yVojGTKR0UWZO7yjByR7q2V3rcbx/K8xtM+qByos8pesxuc3v6Tnl8eD
eyBSb5m+418SoZ5wLmK+vQcCV5l6q3aTiOybi2LULvWCw+mUglVxJII8cvPK
5qu9kJ2n3/Q6hkSEg/iFbdd74cGt+L8H8Pn06A/pE7vv9AJDqfBDVCSJWOm+
Wffg0174T158qusiiQiBI0MXP/ZC336nLxs8SIT1j0K9Ftk+cIX+4uO7SMSs
21HOqao+UPnv4KkzoxKEqGm0bcl//TBhrrXvKUmCCJMYFRtyGoB8mtz8WTdx
QqxWQ4BlPQgxj4uz0yPEiN1BNvPv5gaB19SRmrJ/OfH4WVzW+sdD0Ki+e8MX
paXEcXud9mX7hsEnccAtoFiEKGN43K/9MQwXHhw2sdZfROi1FQuNJX+BMfvB
3sAJAULR7NTsfdMRWCVl4hJO/wu6OroJpWMjEBPz+sxf418wMH37Q1bUKNh0
Kfm6TH0H3raDUTLaY/Bq4gyJPDkFKlxNjiBtDMKfpP6nu34cGpUDqf4R43C8
gsij0PrhLp3hZqvMhuQ1SRNWMxSIu3JbmaLChs1d/UXLmigQq2o2aqPGhqNO
VI3BJApEhZWest7MhhTLWa+eHRQIVb7vvXcnG5SjTs4IX+4EzwsHzhpasUHN
4uXNEOlPAKtaL6lfYIPFf56TLWEtwD9UlyDUyAYH0bL2wfYq+JEb5fvmPRsc
09Y49spXwcIfyz2+H9gw8uxJtOOZShB7xvjL+MSGgzdi3Xol3oLqDMczr5sN
e59UrlniVA4uiasND/DZ8HOhlLdatAQ66T6cNNkJ0D08mCymkwos1a1NtvIT
YBz54NqR8ofQHzabsURxArjrBuQa9JOBpxxuf27DBMymMPeyLRJgaWBSnenW
CRCXDZd3XHwFjFbXJXPNJmCaRrplaHsDvbJfbaJ3bgIid6pX07Seo3srr7JR
wAT0d+qjOIM8dP4D+7Z50ATYncq5ZWeaj7R2V3cdCsUOKO1beagAFSu7nTkT
NQG1s2WXHmoXo8LvxSlZKRMwWse0n9csRfkJVl9XNExAi+2larsPVSh2X3lS
YuMEZHVbCfw2rEY+IooGa5onoK8u3U2ptBqphXyPUm2bAK20KEvhtBr03OXR
GhPmBGxzLpkS8kYoZwvb/CJnAl5vnHThX6hHWe3X0obJHNBW8th5tLkRxWn9
ccpYzYFUIxnN0oVGFJR0Xs5JmgNHgh1EmnSb0F7nk6kMeQ58WmJlLprVhKZ4
hiktqhyw6k4/onbpPdopNpdYaMiB7blp2TmyLajd0j/ukg8HwinF8teUW1F5
4fi+HX4cWIuQTJFtK8oknxCdOcuBuIevXRPCW9H5HutYv0AOiM6WdF7sbUXS
Pho3XcI50HF/ppt6uw25xoxdM0/mgGnByPeSkXb0s9kplNzAgf46+85YzU6k
cMg8sKGRA7L7Zt0KoROZ9285e76ZAwEie70KD3ai5BkhN2obB7xW8ZtMAjuR
zro8y3ssDuxmbZx8V9mJzl+alSFPcsDAS2hQFijokciAZAOfA4EjH36K2FBQ
fXzLivPTHNDhWN9vP05BErmpgtSfHKiJeuA0fZmCimhGEwlCXOgWWep3r5KC
eJvuVJCkuSBlJeW+WZOKVlUEv6qX5cKQZNrLYX0qMjA5WXBOnguUva/SA/ZS
UewRnUyKEhc661iRGm5UpBbdcyNBkwu11pI535Op6NSAigPJhAsu+y+qs39S
0R0fiYP1Zlx4bP7B3WsRDZXN/rY8t5cLQnenQpvEaUhYrN2QYs2F1m1hB6Q2
0FDWzgCVBEcuvK0SF5E8QEODCWhW4gwXjmzjnA7LwI60rrznzwVUF+Cj+ZyG
hgJ6r6wK4EJxbLBkXTENDdv/XCJ9kQs/3ocGxtbT0BeZLbJrI7lwsTLi6+sh
GhpZXtOfeZ0Lq55de3t+AvuPZZbSDS6MhCfaSH7D/nxqk0ocFwiGyezvfzQ0
9iTdUDOZC19i8/Od5eho7N6mRUUPuRCVmHRCYz32tcrmralcyH7bsaRXjY7G
PZgHdDK5YBzuaz64nY7YauJuBvlcmDXdtuKaDbbs4401BVw47C4z6WJPRxOi
6jzDIi6E7N/PUTxGR5xJs0DjUi58rG2y3XOKjrgll29Y1OL76dqXNofSEe+p
qFVrHReO5Z4elg/Hvp8iYf2OCwkDzUn869iBZSkHWrhQMP5nVu8OHU3pTb5w
oHJB8rTJ3tMZ2Oqh/t10LuRdlSnzy8Jes0z3GIsLsn8p6ba5dMSfV6493seF
MA81qcZCOvpa79TpMYbnNz7fZ1aN/YqTOM7mwnVVFscJ0dG3rItHvLk4Xsft
XxxuoKPpqMRh369cMFBzcJluxg5Syp2a5oIIsdIt8SO2Z/Fp/1kuyB1h6Mi0
09F3i7aZgDkucCbyXVspdDSjf/Tt7F8umNcHtP+iYWuwLwf/44JJcI3yMia2
XJDxb0EeDBWJ+/9lYa8QXhIqzIP/hhfKqd3YCwmtfxfzoPXSdsG4Xjqa5a+N
v7KMB9lDZw6rfqajH4Mv7QTEeGARdL42tx+bYiATKc4DZSRntHyQjgT8WD/1
SDzwac9f6jNER8uXBjC/SfLAdtEjTu4wHa3KEi/Lk+LBdbVt3959oSMFw/z7
J2V4sFyQpVI7Qkeq3WbnZeR4cNVoISl5lI60LwwdoCjw4HejnoX1GB3tWnl5
S8w6HqTEae8bxjbLlxY3UuaBVWdejv04He03K+X9UuHBGe2QU7nYjoM2rcVq
PLj19l4SC9s1lJvntYkHzjwBGMP2lbpxU3ELD/K+jvnRsINKlDy7tHgQ+Sxc
MwM73KrWLF6HB7ufKMVYYMeOH1HeuwOP/6R+HBX/PzFyVkhAnwe/ju831sdO
l08YerOLBzTZhfJwPP7nFZvqzgIPoncK/cjG83t1qCV9ozEPPmRsEs3H86+e
crs8YIp9xUvoNo7P+5h/xx7s4YH01crx/Th+ncqp+jaWOH4fiWb+AB31oO0y
S6x5kKy27eVZHP+Ro9SftTY8UFj9JftTH87HWT9mkC0PbvdV1Yjh9fsVv6xs
sz3+f7mxoDpeX7Fm4nz6UR4o3fu2W4hBR1KufQcOO/PAzD/nQA2VjhTng7eI
u/Cg0XR9g0MnHW3bVsS77MED71PFs+qtOP6fLFt1vXhQ9FmR6tZCR+beY3mT
PjxIo8kYhzXR0dEMeU9nf5w/f26RrXB+u+u/NVsdwINMwV13FuH8P8OwU24P
5IGe5zDtUQUdRYrGDe0K5QFL8cWMVwkdxeVsrJu5zIN/J/u5GS/pKNnoXXpB
OA/sN6uPlufRUX7w3DG5aB4Mn3D+L+oJHVG/eDH/xPNAqzCG9OwuHfVdES57
fZ8Hi4+tKe6LxfVFJvP+6WQetNNM3s9G0dGcDetAbyoPxvR0kj/gerCu2qy1
MocHKneHL/z2oCP/RKW6kGq8nq06Ejd16Mg2ydV7EcLrUcOvMN5MR7rJT8m3
63mg7xTbOLwRf++Bkkfmexy/aLYBTZaOolKVljd38sAhY4duMK5/j54q2a0a
5YHsm61fWe9oKCzLdT5tnAfa1iGX+FU0dOLZ05yNHB545L44MPmahpRzlH7r
83mg0eKn8DiLhorylNJP/uZBTo3jTHMEDTUWK7ELV0yCYK5o9Ck9GsopcU3Y
KTEJ852/d3G20FDMq6f6DeRJkHm/0thehYb2lyrdZvw3CS3CY5eGyDTU/UZJ
+++6SWg8mBtL51DRVK1SmMX2SdC+wUzRwf3nv3YliZHjk5BhvHjD8V4K2jlL
/+5ychIunDNL0OygIEf5G6zPbpMgrTYWOd6A+6cfN53lNQnOY89N1+RTkIJ4
qWbr+UnY4n3a73owBanYmO17FT0JG8xg1VlxCtKleEaHF07CnS1HvPRxPz/E
KPgrt4CfP22+/IZnG7qS6zvXITAFLn3JnmzjNvQ8ZNOvyEVTYJn5ft8GhTb0
V77gO3vpFDjNfaRp01tRzqkXnFLJKVD/s2FztmErmvuZ12WlNgXzJmmmGis+
oqeyuaVhdlMQIFh3feFeM5o+8cS3L38Kusz3b1l7uAHNPhDRPflyCtgt9xi/
NBvQrw7v+dGiKej5ZFTfLNKA/oH2HX7pFDCq/y3eU1aPxBTfFQmhKTg2lcFk
StajDYMj06q0KRB+/TtlewZCji6qIYF/piA8UtN8PKYSHXsYZzQ3PwU/pN4E
5+6sRMc7vy67KsCHa0IbH/mPv0UexNtHN0X4MD10y0jJ7C06r2hZnbqSD8rG
qoPrBStQ3ODpf/Xr+fDhTlbL67AyhFyKosSt+FD7L6E89VYxquzw3de/nw8G
a5xcBHWLUbmhOqnwIB+KHm6nHK4pQgVy2Y+tHfigdNxm5KVHIXrU9eh1nCsf
FITzXYpqXqDAA9FDy0P4cE8tPkc9Pgf5I5PcnlD8/LfopG1T2ch3s6Bf/hU+
GMqOLFO1zkauYmG/LK7zYeCkkuH0imfoQMu5lTF3+SDnJXLrW+oTpEE4716S
w4d/qb/KAr6kIJUi2UWs53yoMH/x50jTQ6Sk0NWS84IP68K8xuzzHyDpv7Z2
5iV8SBGYc5u/nIQWV+w9HVXNhx1OzDBXmwQktHGxlj3iw/ikibm5dTyaT3r3
Q7mBD29dpVi30++gmQDDyMZmPiwJnlNPrItFQ1t0UhbR8Py5zfFBwddQX/q3
4zQGHu8/mW8VKAJ1rShSzurC8znuUZ8rGY4+cdWKjfv5wLvR91mrIQR9PDoe
SB7ig0VNktn6iiDU9OGZwfAXPojvbotzbA1A1blrmyMm+KDynLWmNssXVUh9
jjvI44Pu/qa2sERP9Drqke06Ph8cFJdXBdNdUeGMg/S3b3yQX9lvXMlyQvlu
q/vrZvhwSavmlc9HO5RNpWbF/+SDdw6KMDbYhzKN4r1d5vjQdfhlb+vUbvS4
2HrL1nk+QLN+aInfBvRgrejsv398qMx95PtQaRnxP8UZN38=
        "]]}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.528488, 0.470624, 0.701351], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwVl3c81H8cx6WSSNylQbIS2YoKlfe3X5Ed0RBKZGVkhGREJCtFKCOhkJFd
Zj5mRsJd2XdnS+fONYwS+n376x7Px+sen897vz9fMesbZ23Z2djY5texsf37
1bWdIdV/Pachen87m+h3/uNfCs9bjwioAN+P1gskYq/GDu7emDKBU2AfxLXq
SVzQqKoLdPaRNIRNG5e0n5VvAgU1/qxnAqbw/NG0EkbcDmzbvj7+K2IGy/+F
RB7xFgUS493dq5KXIUidY71zuRQY27RXXk28Cp2avogqpgTqPcrFcQLXYEm5
q4tAPAR7j6flNKXawdtGs56ePHXYksf5fF7EESaXCClbvDGY3+GZuO+FEzzs
KcmYp58Eagj1wXlJV7i5GQsTKT8NNr9eNDaZuoHkt/tHo0l60K9gpmGR6A4F
/D5dqWJGUJ/SdOiBwE2IVzMufEU4ByrkWyX7zL1g/89LgZS2C5DLqSBfl+oN
esVq0/J5lyDO66kES8QXUj01RR57WQFHgUH6/au34YWvRJXtPmu4Pc4uJPrC
D7x/q1lr0m3A5ozLNmPJQAjczTYlXWYPA/fEH361vwM5D2NK5CscQZLmtLHB
NAiORPB6HutxgmR+sWCzxGC4LSp7vFbUDUKCo25FCoSC6dELznJ8XlAnZPf2
fHUocCyqXTK284ZfFdi8uPk9GCBsEfr93gec5xZu1KSGQZ9r9aPunNtgam5l
zxCJAPW1Mvv3nkEQs6ieVVkfAY4TisE07WBoi90+EXo1Eo5GM00O770Lx9s6
Lu95EQUStrsPvPwSApKHDp03lIwBm3mBTvei+2DVwxsv2BoDydGlNUGF4ZDi
RCdN2z8E867g8x9LI4CT1J2NTB9Bwn0+J+EPUeC/6Z74xcRY+NiOpvT2PIJr
N1kCEQLxUH9yF2bElQDK6+Nul7rFw/B5Pzu+xgRgj1MZHm6Nh4SIhZkx/0R4
XuSbquCdAFo+cjyVf57AEH29yGdyIhi99f0iLZwCZ67ukhCJToKbygPp88vp
IPytOlR7IgkcNC2VjG5kACPQcspdPRl+NY3pHJzKgMjUzOzmmWSQLnMKiujN
hOZ+OenrmqnwbVIx+07bS1A3PKHwZi0NukPG79stvQJO6kQM7dxz2GYwFr8z
NBf6ncJYm14/B7Uzh8L1iXlQ3Wx78bV8OhTExNmfUM6Hi+N5AmyUdNh/16rX
+P5riNtzKDVLNRNUOjbu+n60BDjjdTK+fX8JUQJborNr38If1bE/GYJZULO7
zaGZvwLmqLfOm5zMguxkO5dwlwr4JPWK+218FihzzIezi1VCWg2Ht9+RbDhg
F6dW+7AKVCaadDkCciD3VoO9QnQtWB3UmN/NmQfnnlY17gtqAJP+XsOPSnlg
nmo17f+2AbT8XXIDzfIgO73MfB+zAWTfp14ey8sD5/n5FUfzRlg0+9OWbZAP
d6t+Xqk/2gTRwZXPDjwugGdLF6Ifc7dARc/B06eFi0CNn/rF8ksbxHxlaMtp
FYGk1MoJP8l2sGPP0SW4FoFGoE7NpG077FDZbTj8rggeBpBaUqbaoeZDcF6F
QjEEp5QbPp3pgN2K10v0uoqBT/94dM1KJwwtqCNPnlKY2SZbEF/YAxdDKENN
UeXQxb+4KB3QC3yjknL2GeWwydl61T63F9qPuQdwVZRD7EUpWndvL6gvbhQ1
Hi8HXpLugpBiH+x2VLSlqb4B/2nmZN5EH9AM77J+Tb0BT8vx+XDTAbgmuH+D
AlYBHQfE3SZNh+FGiaf80/kq8I4dFTGeHoUfj/ra1q1DoFX9Jm3s7Rdoa3iP
uo81gu+3y4ufeb+Bo68OjxmjGR5y/zCUSp+Hhs0H/xa4tILL+QcKvUq/IftF
85rgvg4o7hje3Hx1DbAd7zJNCjuBXSe2zrhwHSbfSql8L9MN5teyMvv2bsA+
YyZzuXM9IC/wZkCglQNz5nIi9yqRQVRAbL5bejP2YeDCu60xn+DN108Gjs+4
MROti2OTk5/B6b3/xi+9PNjh9KgL6RJ9wM0MFe8v5cWKG+74csv0QQh3/Sfn
al5MdsIzxRuPS0ogdctaAy8mKmkxoq/eB0YZP7i3kXgx7gI5+99n+mCPsdoP
DhYvNlrx0fusXx8kZBZu4NrOh0V18yZuIPfB0oGbgRcN+bDRtcefHe70Q++1
3rayKj5sC6Mnyie0HyoN5DcX1fJhqoM8J8Mi+uHlkyG+V4gPe1R2v+TF437Y
/Pu6x+MWPgxz8Iuh5fRDrc+KzRkSH5ZBstY27ekHs4zXiuYzfJj1ywO1IDYA
gzY//9bwE7CYWFdPQ8kBcNofZuW6k4BVB+bLWMoOwG/KaSdhQQJGNNuXdPvQ
AHAZUf18RAhYE4+A9xudAcgc2OXOI0PAJHzYlGQ9BmBnvDKjVYOATel0v9jR
NABTFxR13e1wPUrqYWzbAOi1twRzORKwa513bm/pGoB1f/ZS0p0I2LihkjH7
IK63HlpodiNgNJPYNebcANQf7kul3yZgA5YmZi2Cg+DZdW46L4aAdbj3b73p
MQjj9JqSX2UEbHOZ4vKczyBILUrZqLwlYNrz96ccAwYhrFNAwKWSgLV6q9Ze
CR+ENTrHw95aAtbsl+SolzYIJwTDIu+2ELB398ybxTsGwXy/7l+9PgJWnDTi
SxIbgpApd54nCwTMWVpo6KDUEFhvU+J1XCJg+6suqsfLDcEgLXmn6m8C9nyA
tHz+yBC0BD1R+7iCx3Nnsx9FfwhOmukWflpPxFwSXgV88RkCR430OiMCEdu/
b4qqHTAEDnHr+38QidhkuZhG3t0haMrlmI3lJ2IWn5PXnB8MAclFd33rTiKm
v+3BnR+ZQyBjHTe+RZiIycS6B69+HAIptsyPHDJEbFq0cOzypyFg28FrckuW
iGUW00/UDwzB7zsbO6bliJhgjw17yMQQRHTLRFYrErHNvOdDOH8PQXhX73/H
DxGxmWj1e9skhqHq+zB/ERCxl0I+Uzelh8E2V8OFhRExq4IyzT6FYQhe2Voo
9x8R6/8gx5GkNgxPD3yefnaKiL3nErkvfGYYtnyWkTTXIWJZ4esjpG8PgxxN
1BE7S8SIk+GBCneGIaO1bPmYCRELgq03lUOH4fcz08+HTYnYpcVdV47HDMOv
vMOXxc8TMd5rCoeMM4dB+spUw4AZEfMFs7FbHcMwwFHj3WiF+5tM6wvoHoac
4FyLx1eJmOmiTefdz8NgeWMw9Ko1EVN47VoRTRsGw3tZyQs2RGxCMPRB+o9h
+KJSQl6xI2IGi4VqbYIUyNZXlb/vTMSqjVUUP4pQ4JdIGJ+cC56f11USZAkK
MEV4D3ThzH6tmZeiQAFF24L9XDeIWAVpcIr1HwWcZVToVu5ETEL+yvD8aQq8
5vEuYuEcFz7Z81ufAp7ra4r8PIiYM7Bq1l+gwB/OE1ZRnkRM7PWGuJ1OFEjq
5rkd4UXEYjgj7wu5UWBtlzIfuzcRW7HhDRDzosD1mnMjPjj3CQo6yN6hwJ4D
z6XMfYhYVLiiBjymQNnJZjM2XyL2a6Jc+dRTCvQpGpVY42wH6tI6zyiwYM6B
NeKMLZ7iN8mhgM/KDnbf20RsweYS3a6GApqvVogtfkTMe9ufbQP1FNjoUnpt
pz8RW2xMOa7zngKEmXBXu38sRn0kS6KAQH5m7jLO3qSA6tQ+CuRyuQ5BABFb
ChKe5KFQYJ3R9cZgnH+NXDnybZoCdycIFX9wvvWQ7epVBgWixAyblANxXSMj
kvwdt2cf9Z4DzrfmTpSfXMLvl4tcS8L597NxavkKBcgPxOTbcL5tELJJkp0K
bsiN8BPn5ZW9B55sokKQsVa+4B1cL2i+xMlDhbVv7ssaOC+b24b6EqkA9s1r
V/7p3ByF9J1UEEnmrQzA+U91dr/5HiqoR0tKPsXZ//rpdR/FqfDHgqpdhPOK
wIyMxn4q9GtvFm36p7eHmxbJU0EzNyj/0z/9lnSgqDIVBBcEZ0f/6fs7cmJV
cXvqi2l0nFf7r5PYNaig9G532HecA+9z//E8SYWE6sNj8zivHS6QmNKmwmAW
lfWPA6f1Dc8bUoEQySz59/+1BKZPqwkVQh6dkpr9p2vGZKiaUSGUrfHMGM5/
5xU+5F6mQi9oyX7GOehl97zgNSo8JJdW/bOXzdRNONqRCrfM6cv//AlaT9Be
daXCckrP3D9/15WVuLvepMLZm7oJgTjftT6bMuJLhaqJ43NWOLMTfzYb3aGC
C2fcb/inNzyeawilwpiIYsXuf7q7yi7lSCr0hK1JzuP5WN/j5bQ9gQrnTEaE
UnAOvbMjISyZCl942zMdcd6gWFG39BzPR0fCkMo/jvlFGMqjAutkwpUGvD5C
jycd1SumgoZZbsFdnDcy1Wxr31DBdZdNPoYzh75fZVo9FVBm4rtSvP7C/uwe
531PhYPvl3v+1SdHfi138AcqnDk1mPCvfjdxrV226aPCPodp5Rt4fYdXpYV/
HqYCyYmTZwfOnI5QqjlGBcWwqCdVeD9wtgVt3M+ggprkq/pFvF/CfcQUk75T
cdc1rjzCebNU40WuJSp8HZcvksSZK2x9AWMdDdqdRW10bhEx7lNhZ0t20oBr
/5vd9ni/HkM3CO+FaKBtkTg7h/e3q7pZz5AYDdjuPxj0xJmsJGe4QY4GkcQR
Xq+bRCx5D1nnAkaDXyH7v5ji86LzaQ2nsyYN4EvnqxZ8nqxty2oN0qXBHcPR
cGWcr3Ld0swzpYEkMfYlhxs+r5b2nFh1oMGXvQt6kfi8uuSxiY3oSoMTJtPs
k/h8i2Z+q5P0pMGpD30D6jizJpqOGQXQYEh06/jIdSL2tsdR9UUsDfSfeThv
ciBip/LeKOpU4+cf/HCrE5+v3vuez1kiGnikD8v+wufvq/Tw1x7NNBCilPwV
xZn7iblsahcNll8B1/XLuH8h66RY4zQ4ksRWNHgJ3x+WBsIJ3CPAR2ZdUsTn
f9zAYWou3wi8keGQl8f3Q7OJaGrd9hGQjAkT329MxKR0fwrMiIzAPmr0re1n
iNjc4aTtR1VG4OBG076Puni/8U1tGbMYgVyXtvA3J/B9OFSKUa6OQEyadm4U
vq8GXwTd7Lcbgb/mW3mu4Pvs8BEhyke3ETCPu/R89RgR+2Zpkl8dOgJ3r5Ut
CKgSMZv8Bp34ghFQM/mZ0S1PxHS10sJOr4zArPeeL0r4/l3ZdNgyg20UDpyp
+Vm0nYh9ZggtCa8fhVn5bH05fF/ffUuXEeQchc3hVZNC+H6n6YTF8RFHgV/u
agWVi4g9dXt3dXXfKDRVZB+irRKwLXWybP0Go6BC9TtCHSNgTH3R8kijUfgz
VOpBGyFgXcP8Dhomo3Ak/3QMhUrAHv5e7c66OApbBhsdugfx99ihnuc3bUaB
HtpS/ZBEwHYV3ASi7ygct39v6lePv7eS3wUavByFlKjAV+ypBGyjdOnBdTmj
ILTLYGdGEgGbrsieLs8dhYZTRrePPSFgOb0PDYWKRsHKolLkehwBkyFYC89W
jcI5rZw/6eEETCmcoy68exTS2fWeBtwkYMe9z6w2LeP6RPrzJR0Ctnh9xk9n
dRR81P87ansafz9dCV7u+jsKvKjrVM8pAiauU7Y0uGEMXrJffJkGBIxTaOcP
1tYxiLkj8kroEAH73ECb3r13DIYFWi3S8PelM49rj6feGGRzV3m/+8GHpb6M
frE3dQzq+sj0+Fg+7MpJ5WMjaWNQUHrkgEgMHyY+Pvg5OWMMNHRtC7Ij+bBX
IlIcxJwx2PMsTPN1CB9WntzgwFY6Bk+z+cSTvPiwzkeL8tTWMTidqhDMuMiH
rfpbVSb+HIP4LayFiD182OVzKh83643Dxti3wm3HebE3vbaP6xbHgT67mfZx
Gw+m1lnMPp04AbIL6bF1n7gwUU27hcenJuGhjHdCmAIndkjlUGz59CQcD3C3
C4vdiI38eND+4t4UUM912qFZdoyhbHxP4OA0BI+/RwHsbJjkrDx93adpiNKV
iXJOX4ZmCS+yW/AXaF7qVJD9OQ8PP/fanJWYgTLz6O+WAyxgmdTHsjfPAO1E
hkZj+TSUntt+Us39K1w+zTbZlTYMcbx3ZpDnV/Dv8vo6azUMHu0zD7S8v0Kp
UdIRub3DcOB47YCJ31eI3Z+zuuPVEBRL2Li63vsKtRFEiydlg1D4szjpRdJX
EH87FGNK6oe8WP1vPI1fYfKh6tnT+z/Di48hz8aJdGBVHLwu8agDog/8sXi+
nQ5eeXJ8dsId4J3gIWSxiw6err4nNr5uB23Lqym9e+hw38aebvGhDeYYGklt
++nwsfBLu9eWVlDdshxfqEGHIjfLVrf0Jvio6xZ9+zodtpTrnlEWq4a3hV/0
jrjQYUBpLL3kXBWkE69wz9+gQ9dP1yfzkZXgMWQQ6eJFB8WcnVHtS29h13XZ
cKsgOqTv9thdMVQG1hHTIVqJdLjURlipiMqHpVYLP2Ijbp/e2ruAp8EgbKLl
1dhMB/2Xqsd5NW6BFk3xhkcrHeT7eEUZhdchcZ7dhtxJB2pwe6RThhVSEcvV
jeunw1/DrSS9sAjkcXtBgMikg8DyydillnTEkIupJOyahVs7M2JmlUoRf6VP
aYPgLPAZUbZvby1FR09eLXDfMwtSOx0SPS3KUKSZSjpJfBbMv2VOd4WWI+mw
ofux8rOwb/H74+UPb5HdiOQFwslZuFzoI8+hUoNGY9ECn+ssyIp/Hl//pgGN
3jWojnObha8ecU67WQ1ozHM4kN9zFo5VkMYH9jei8XNLm3bdmoVn+gbemimN
aEJAUVDkLn6+jZPCpF8Tms5I05BPnAXrawruSnItaDpObn3R01lwP/W+JdMK
55DqVqWUWZAWvnevOr4FfbHtM1JJnwW9pCS5oT8taEZ6q83RvFlIBqcbgy3v
0WxJwH2dullY0vKU/KTdhhiZ3Pof6mfB04QZm+SD8+MkPoOmWdiVxNy1MRtn
rzdJRm14fI7OOH9Y147m1Jj5F8izwCYROcr/ph19a7DosZ3G79MN1Eni+oAW
SUcF7m5lQMqenmg794+IzaV/SY3AgKDUO5bvn3xEXJyefd+3MSCid51ZzbuP
SFgj7/FVAQZ8PcE1dY2zC2nm7dp6QoIBegnHfr592oXi7y6ws6kzIJoWzWOZ
1Y3S9sSOVRxjAPnnSgaxpRu9qpSrvwEMOPIXDVpOdqPaOZuAkVMMoOY8Lhzi
60GTl8hLdWcYIFa1bbFcrwcpKxcxAmwZ8JOCuG5X9KBjXbofDjkwwPbt9foN
zT1Iy3E6l3mdAWpNQ0WXenrQped77C3dGHBY2sjCYaYH3eWOHjvmx4C0xMp+
7h0kFJ0tVT8fwIBbUu5a30VJKPFEU1pBEG6f+n8qmbIklOezbC4UxgDXE1fK
7DASIk849P15xACeSy7n/OxJiBK44U3ZYwbUr9wnvXMjoWmB9MdOiQz4Hb+2
p9OXhJbP9BsNpzAg/EOsqX4UCYnVan6ozmYAdwv9FiWfhGQujOV65DKAksZW
GVhGQio//MNlChjg9ffAPmY1CWnvL9dMLmFApV9IrUI7CbnFi9f71jIguNFF
X2uChM4mWDuuRwxAOhl50zMkdCgxk/iggQFuRdrql+bw+5+I26a/Z0DnGUyo
5hcJUZ9ab5VpZwC/mEzYq1USqk/KrCj7wICVdaVGjuxkdC9FnKu1hwHy6x+q
2nKTkUOqdZnRJzy+l5td03nJSPdZpsVQLwNe08yOFG0jI77n4kXMIfz8+X1l
p3eT0Y/n1hd9qAw4qxMZRBImo970zHXrRhlQcjibX1GcjJIzxU35pxhw/Ypc
q+1+MvJ/Yb367AsDAl3514EsGV15mZktRcfjp1SsypAno/+yxs+UMBhgGSDt
76JERhLZ4r/VWQwwMOodbDxIRptyrDObvzOg4LeyFUOFjOg5mXqG8wzIPvx9
D/0wGXW+Gp/vX2SAVfCkWK0qGRXliqdd/c2A/F0EP2t1MorLsz49+4cBwvbZ
qtSjZHQzP/PbzTUGpHKxXZc7TkYXCsaT1tiYcGhbtrCRBhmpvxY/Gb6eCYVg
YKcNZCRUaM0gcDDBSaTfaDtGRn8LMxNSOJlANjk79xbn8aJxjX3cTFhtWzaU
P0FGzcXiM4U8TKjvUQu5hXN2iXWsKh8TtHyyU57iHFGaqd5IxPX8jbkPcHYu
G5/Q286EDY66tRdwNiwXf9C7kwmhGxKnF/HzD7yxPnxFkAnfrFXVnHDmf5s5
MiOE389T3FKO27f4djzcQ4QJJ7Lznn3C7R+sED+4IobrIxs+teL+1VZaD9+T
YELdYodP7DEySqvKDOWVYkJcmWqaEh6P4Opx+SRpJmh3VF3MUiOjazXi/eJy
TDi4mV7FOkJGWrXWQQUKTAiKS/jMi8db+l2m9OEDTPhPpqpmI56PuTpxf53D
THiSfOaYpyIZ9SDrfZ9UmeCyWrxClyOjsvrMLoujTDCfte9XlSGjW43iYm4Y
E+x9e2UvSJDRpSbrjt//MeEK1+YuKTEyOt6c6RmiyYSByOjhrj1kxP5e/H2i
LhMe++VFpe8go8n31jdEDZgwFXHx4gciGbW2Zu7KO8OEhsOBk51bySi6Xdzp
nSmej8xHsaYcZLTzozjf5GUm9Bozsm/9JCHVhc8/ra4y4VkI94IX3j8X99zv
p9owYcQ4RFv/Kwklu8ym9TswQcBT6EIojYSEt5bLf/Bgwp+gayESrSQEh+0I
2l5MiP9q7sSoJyGry7sWmn2YUOyxkycG7+fMQv/aOn8m8PRPD19+TUKSZzT1
SsOYsC2865RaLAmd9llSUIxgwlqI9RNSBAk5PM8lFkTh9TF+1PbUXXwesXiG
sh7h8WAP7a/yICGFR30OSclM2Fr7bWLaGO9/kn1YUCETNEr3NlptJqHzvwWu
rxYzYeP11i2v//Ygb7FOg9tlTOA9dO9O70IPqnRX2n6zkgm27Q+MasbweUr8
/cK+Ea/n4j+fqfh8PWUS2WDYh8d3S3bfU8seZOt3LOvDABNmz+ZkvTHuQWEv
5sK1h5mg8uB8WLFmD2r7edbov1EmvCoUYDsh34P043ePHKIzQSw0cCl9oRuZ
9BasCK0xYVPSpisPRbpRYI7zcjfbHFjnvM7SWYfvA1+5X3fXz4FZ3NeDVeNd
aGVPwc8Zzjm49MD/edXLLpRtl08v3zYHh6N4bXX3daHlpdwBfek5OFe1nL5e
4CPKFMwp9zedg7D4Y2UtHztQJ8OuVPHCHNhcMxX8md2Bluoki8fN5sDCOyJ4
4k4H0rfJzte+MgdjQhYGvAc60GJ+Vib/9TnQ8vjKmfGoHekef/mo4M4cPIN7
CeKabejHlQxnSt4cyJ96siP2fgtaeLLx0NXXc9Dmr8ShatmCfnU7rk4VzUEO
b+OXqoMt6C8cjGGVz4FPcOpbI2oz2iLaVMSO8PNFePSHlJrRvtHJH/s/zcHd
dIUHo6RGdNFqv6/XnzkwiEdHZNnqkfnT6BPLq7j9ffLODS8RutzzbfMdNhZY
iLvt3KKDkC1WlRy+kQUcwiMtWrF1yENUtzaFlwXbufrqA0XfoehRp78Ne1kw
uqnsntfRaoSsiu5t1WfBgFXETJVbOarudtajGbLgffai/5fN5eithgyh0JgF
xYH0pqMvylCBUFaqwQUWnLJxKLTrK0XJA8ll0dYscGqsVFaAEuRlFDbG5cuC
v8VbhcSOFSA3dDJnyI8FB+K5XDh88pGzwjqXvEAWlDS4FdeX5iHrLf6/dEJx
+15/46fJ5SKjNnfeiIcscEt4nL8gl41kMcvjm7JZkP+m8UGWfTqSLBJc3/+K
BRls+p1iTs+RuPBAW3Y+C3KPfr9hwpWGdq2cNdUqYYH3ip6UpUkK4qjUdrpX
y4KlGxlbo/kTEbsUx4FziAU3O2KflnbHo9WEpkWJRhYkSiw/SXz4GM17atxt
bmUBTVW0xl84Fo0pqiSt/4Rz3V7Fb3/DESXt++VPvSx4U6WbdKUnDA3wFEm8
wL8TbK+GNkwVhqKuWeni/2gsqGv1HUtNCkIdl754EcdY8LQk43PgmQDU0v7y
6PgEC9bqd9/reuiLanNEWoO/ssAqpd8t7r4HqtxBjTZmsCD+jWuLa5QrKruX
fFaMxYKZT987lZ0cUOH8hV3fv7Og5qe7P1ZljfJsttPq51mw45nZj28c5iiL
TH7xaIkF4QHGT1yqjFH6iUeOVsss6FvtcLwYchKlFhsoKq2y4FLzpXneNVn0
RIR74e9fFshKF1x8Kr4Z+x/kIoQH
        "]]}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.772079, 0.431554, 0.102387], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwVl3c8Vf8fxyWVIuOmQrKzKiSj5J73aREhISMlMyQlSaQysvfeSfbeex17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        "]]}}}, {
    DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, DisplayFunction :> 
     Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, "ScalingFunctions" -> None}, 
     PlotLabel -> FormBox["\"Divergence Removed?\"", TraditionalForm], 
     PlotRange -> {{0, 1}, {-0.9909172326134527, 6.283185307179577}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}],FormBox[
    FormBox[
     TemplateBox[{
      "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(+2\\), \
0\\)]\\)(1-\\!\\(\\*SuperscriptBox[\\(e\\), \
\\(2\\)]\\)\\!\\(\\*SuperscriptBox[\\()\\), \\(3/2\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(+2\\), \
1\\)]\\)(1-\\!\\(\\*SuperscriptBox[\\(e\\), \
\\(2\\)]\\)\\!\\(\\*SuperscriptBox[\\()\\), \\(3/2\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(+2\\), \
2\\)]\\)(1-\\!\\(\\*SuperscriptBox[\\(e\\), \
\\(2\\)]\\)\\!\\(\\*SuperscriptBox[\\()\\), \\(3/2\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(+2\\), \
3\\)]\\)(1-\\!\\(\\*SuperscriptBox[\\(e\\), \
\\(2\\)]\\)\\!\\(\\*SuperscriptBox[\\()\\), \\(3/2\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(+2\\), \
4\\)]\\)(1-\\!\\(\\*SuperscriptBox[\\(e\\), \
\\(2\\)]\\)\\!\\(\\*SuperscriptBox[\\()\\), \\(3/2\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(+2\\), \
10\\)]\\)(1-\\!\\(\\*SuperscriptBox[\\(e\\), \
\\(2\\)]\\)\\!\\(\\*SuperscriptBox[\\()\\), \\(3/2\\)]\\)\""}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #4}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #5}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #6}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], "\[InvisibleSpace]"}], 
                    "RGBColor[0.368417, 0.506779, 0.709798]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], "\[InvisibleSpace]"}], 
                    "RGBColor[0.880722, 0.611041, 0.142051]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.37345400000000006`, 0.461046, 0.12992333333333334`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], "\[InvisibleSpace]"}], 
                    "RGBColor[0.560181, 0.691569, 0.194885]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.560181, 0.691569, 0.194885]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.560181, 0.691569, 0.194885], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.6150173333333333, 0.25708400000000003`, 
                    0.13945266666666667`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], "\[InvisibleSpace]"}], 
                    "RGBColor[0.922526, 0.385626, 0.209179]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.922526, 0.385626, 0.209179]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.922526, 0.385626, 0.209179], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.3523253333333333, 0.3137493333333333, 
                    0.46756733333333333`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], "\[InvisibleSpace]"}], 
                    "RGBColor[0.528488, 0.470624, 0.701351]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.528488, 0.470624, 0.701351]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.528488, 0.470624, 0.701351], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.5147193333333333, 0.28770266666666666`, 
                    0.06825800000000001], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], "\[InvisibleSpace]"}], 
                    "RGBColor[0.772079, 0.431554, 0.102387]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.772079, 0.431554, 0.102387]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.772079, 0.431554, 0.102387], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5, ",", #6}], "}"}], 
           ",", 
           RowBox[{"LegendMarkers", "\[Rule]", "None"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{3.8044490178821125`*^9, 3.804511130512868*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Re", "[", 
      RowBox[{"NpPlus2NP", "[", 
       RowBox[{"e", ",", "0"}], "]"}], "]"}], ",", 
     RowBox[{"Re", "[", 
      RowBox[{"NpPlus2NP", "[", 
       RowBox[{"e", ",", "1"}], "]"}], "]"}], ",", 
     RowBox[{"Re", "[", 
      RowBox[{"NpPlus2NP", "[", 
       RowBox[{"e", ",", "2"}], "]"}], "]"}], ",", 
     RowBox[{"Re", "[", 
      RowBox[{"NpPlus2NP", "[", 
       RowBox[{"e", ",", "3"}], "]"}], "]"}], ",", 
     RowBox[{"Re", "[", 
      RowBox[{"NpPlus2NP", "[", 
       RowBox[{"e", ",", "4"}], "]"}], "]"}], ",", 
     RowBox[{"Re", "[", 
      RowBox[{"NpPlus2NP", "[", 
       RowBox[{"e", ",", "10"}], "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\!\(\*SubscriptBox[\(p\), \(\(+2\), \
0\)]\)(1-\!\(\*SuperscriptBox[\(e\), \(2\)]\)\!\(\*SuperscriptBox[\()\), \
\(3/2\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(\(+2\), 1\)]\)(1-\!\(\*SuperscriptBox[\
\(e\), \(2\)]\)\!\(\*SuperscriptBox[\()\), \(3/2\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(\(+2\), 2\)]\)(1-\!\(\*SuperscriptBox[\
\(e\), \(2\)]\)\!\(\*SuperscriptBox[\()\), \(3/2\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(\(+2\), 3\)]\)(1-\!\(\*SuperscriptBox[\
\(e\), \(2\)]\)\!\(\*SuperscriptBox[\()\), \(3/2\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(\(+2\), 4\)]\)(1-\!\(\*SuperscriptBox[\
\(e\), \(2\)]\)\!\(\*SuperscriptBox[\()\), \(3/2\)]\)\>\"", ",", 
      "\"\<\!\(\*SubscriptBox[\(p\), \(\(+2\), \
10\)]\)(1-\!\(\*SuperscriptBox[\(e\), \(2\)]\)\!\(\*SuperscriptBox[\()\), \
\(3/2\)]\)\>\""}], "}"}]}], ",", 
   RowBox[{
   "PlotLabel", "\[Rule]", 
    "\"\<Divergence Removed? but this time better constants?\>\""}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.8142760702536974`*^9, 3.8142760774346304`*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] recursive bisections in \[NoBreak]\\!\\(u\\)\
\[NoBreak] near \[NoBreak]\\!\\({u}\\)\[NoBreak] = \
\[NoBreak]\\!\\({0.000024185766477748702`}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(-2.49366499671666`*^-16\\)\[NoBreak] and \
\[NoBreak]\\!\\(1.5939906358846744`*^-15\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8142760795337253`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "slwcon"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Numerical integration converging too slowly; suspect one \
of the following: singularity, value of the integration is 0, highly \
oscillatory integrand, or WorkingPrecision too small. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/slwcon\\\", ButtonNote -> \
\\\"NIntegrate::slwcon\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8142760795836782`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] recursive bisections in \[NoBreak]\\!\\(u\\)\
\[NoBreak] near \[NoBreak]\\!\\({u}\\)\[NoBreak] = \
\[NoBreak]\\!\\({4.503669942224799`}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(1.734723475976807`*^-17\\)\[NoBreak] and \
\[NoBreak]\\!\\(3.820404467573641`*^-16\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.81427607962364*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] recursive bisections in \[NoBreak]\\!\\(u\\)\
\[NoBreak] near \[NoBreak]\\!\\({u}\\)\[NoBreak] = \
\[NoBreak]\\!\\({6.\
28318519448951320385675257047976413268819406710008479421958327293`65.\
954589770191}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(1.7695567233744214`*^-13 + \\(\\(4.163336342344337`*^-17\\\\ \
\[ImaginaryI]\\)\\)\\)\[NoBreak] and \
\[NoBreak]\\!\\(1.367876784470429`*^-12\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.814276079810466*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \
\[NoBreak]\\!\\(\\*StyleBox[\\(NIntegrate :: ncvb\\), \\\"MessageName\\\"]\\)\
\[NoBreak] will be suppressed during this calculation. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/stop\\\", \
ButtonNote -> \\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8142760798484535`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "slwcon"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Numerical integration converging too slowly; suspect one \
of the following: singularity, value of the integration is 0, highly \
oscillatory integrand, or WorkingPrecision too small. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/slwcon\\\", ButtonNote -> \
\\\"NIntegrate::slwcon\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.81427608017313*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "slwcon"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Numerical integration converging too slowly; suspect one \
of the following: singularity, value of the integration is 0, highly \
oscillatory integrand, or WorkingPrecision too small. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/slwcon\\\", ButtonNote -> \
\\\"NIntegrate::slwcon\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8142760802760425`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \
\[NoBreak]\\!\\(\\*StyleBox[\\(NIntegrate :: slwcon\\), \
\\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during this calculation. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/stop\\\", \
ButtonNote -> \\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.8142760803279905`*^9}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{{{}, {}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.368417, 0.506779, 0.709798], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwUl3c8198Xx62QWVaEyApZZVR4vw9C2XtVMktJdhRlFCUiWVkhhKSyCdee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        "]]}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.880722, 0.611041, 0.142051], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwV1nk0Vd8XAHBTEUlIhpRImlMqlYYtTcg8NBAh9U1RhMpQyBAllCSUCiVK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        "]]}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.560181, 0.691569, 0.194885], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwV2Gk8VG8bB3C0EEqJGJQISdmKCuXSQsqSfYlkCSnJkhLiT9aSnSLZ9/WM
UCg3UbQoSyLZw8wc05yylBKe88yb8/m+uc819++6rzlzJByvmThzsLGxObKz
sf3/esaZ3t3MMNecX/3/hwBapYXjKEUF5OGP6v+9jacv9gnlJAz2zPb/I13f
FOR+U8YQzGeZU4ukFdQECh5TzODzH9qFOdJsWxlJq+LWEHB5UptJupv5ItRB
xg508IkH30gbO7155pDqAGInJ82/kFbvOoAlUi7CW1dGcCfpXUczi1ozXGDR
bU6wmTRvKVfWvLgbHA5bI0wlPb/NJ1U67wosC4hGZJMevjN830LGA3KyNOxj
STst5r1sNfMEk/cuhf6k+xWsNW1TveDIpUwrZ9LNj1pV71OuQ+SgOvtB0io9
flRpG19IWpP/W5R0CZeCfFPGDaAckzzHRjrR96EUIX4L6lQuObWtELC+3CA7
0sEfbl9U5c4n7T/BIbYzLwDUMyS3h5J2Ont1q7FMEOSUu0WqkR4Il4xjuAYD
j8zbEX7SMiNX1rWY/QcE3TIXXyYgXUAixDo1BPZJcnukkL4Tcs/vLiUMHpmr
CQ/8I6BJzKXOoiEMvHh8uvNJLz7Vmpe0CYeym0u/rpF2Zy1ca8yIAItpnkh2
0mY29q5M8Wi4adzYuGWJgNhf6gXPmqPhzvc//d1/CehIEPwW5nAXjk1S7eNJ
H+14a7c97x7I/Ch4ykVaRlXVwlAmFroWDAOnFwmw7+JLFmmPhetfOJfTSD+6
gndPu8ZB6OxVXI80V/fHQmQWD2IedjxlvwkI5AyXtEpNgGb1HBeLXwRcvE5Q
oinJUHizPNphjoADaxL9qz2Tgbny6vDcLAEciSpfv7YnQzbms+kO6ayqWxkK
N1Ig/Xuj/OOfBAzia8Q/9aTCrNP5o40EAWcdhKXEY9LgQPbN8swZAnb8aAjT
/ZYGBxNob/lJM4POT3mpp8N2kbbN4TgBdzNyC9vo6dC0usp/kUFAW/++PZe1
M2AuUm2Oh0b2n+ExhdqVTNCx3ai8ZoL8PsPfYkfMs0BNtb/TepzsnysRBGdF
FhztEk6qHCOgoc3ZqkI+G2zXGjwwGSXAaqKUwjaUDQ+Co6LChsh+2a6aUXA4
F548viwe/5lcL/l0zo+f+VBjoFSt84aApcPjSzkiBXDD62O1VwcBrGE/C9MT
BZD0rkjkUTsBvbuLeeqSC4CRY7aT8YqAzMb1NwIOFYINNrjO+yXZr99az6y/
XQQPCub1DjWS+ezXnBflKgWxAuEL8WUEmPb3GXYqlYK6U6VnVCkBOoFXS4Ks
SyFU9gwzqISAva8z7MZLSwE7/1vCtYiAX9ZLHYUGZfCinxEtlUdATMizx8pJ
5eDGqnM0TSfgadf+U6d2VMFWnz9zIZFkPzGYuvt0qsD8tFexQQQBLhxFZ7Z4
VEGt5u8vQuHkvFARNfz6ogokVR7XFIUS0PgupPSpAgbri1z0am8TIKp4mar3
AYNyBq9wlA+Z74I68tlYDe9Gq5d57ch6OYS1XCSqYQflYUyxLQHVmxaarVRJ
y+llHLch89xd9fLo+WoYHX6k6W1F5me96zVnRTUUuNxIRCYEpD3n6Xyk/wSO
UBaT+E+R+dwZGmy9VwNRy8HMdAUCNo/J7HPNqYGOSnrY5D4C3hzxus39tAaq
BG9d2LeXXO/Xup3GEzWg8+bd17rdZL1uis4jh2uBFmb3q24nASOGocTiVC2o
unMMO/GT/S0iu1ZB6ykUy6l3eM2z4BrVR/7hfD38WLfH0+0JC1hHxnvfcDVA
d+fLNjcqC9w7DP2XxBqgecgz+1IVCy6N7mm3026AocT27w5lLLDfOGYvndoA
p2weTB3PY4GRm35y9aFGcG2Z9WlKZIGShPTSe//ncCTg7MXHniyYjf/cwc6O
wP722Nt1sizoaHmNPh55CXuinpoa3PwObrdOb7RmtgErws52EWNCy4b9q+VX
2yEzTaKNmJiBwry2FRHpt5CzZPzz73cctLa9yDWtfA9msnqBgb8YIN8+9Oy1
3EdQo2SEF8/R4ZOWKauE1QUWnvteOL+lgTv3lZ4+pR6w6ttvaVg0De8GLF9s
iu2Fy3+u1/TYTYGpjtX45OQn+M3akGq7ZRIOZt+zzJb6DGI0tp6wngkYW0n6
dCm4H6QVv8Qae4/D1OmPedtaB2DwmfJYgfQYYGmjt7olBgFGA6x9bwxDQdSa
6D3+X4HbcC6voGoQFpzO4S6NQyBioNsWtn0AeE5GmFCFRkCiIraE3a4PAjdP
8Y7bjkJwmsaJ1sEe4G3ay9ZvMAaMDwMW9de74OiNs8utf8egtrtwKHHiHWTk
x+TtyhgHRXmz9NdO7WBnrtK5QW8C2NsDDPe2voTaPuekpl8ToHzTpclh5Tmo
vcc4plO/gcNAWFRbci3s1HZZSDo5Cc/WHu5n2pWDqopqQs30JLjVLabdfZIF
o7P33+SFTwGHmibHBec7wDxgHE7ZPw2y1/rSDS9HoDeFkzKPVaZhp9OFmxf+
RqBCil/HzkPTELVUZyh0NxLZr2byyB6Zhk8fqt8EFEeh3rfMhIM60+ChSv+1
bfwuanCIyjQ9Nw1pm7ijY4/Foeg49PR+6DTobOXmzB9NQjIz8jh77zT4Uad5
d3x+hHi5PhY09k2DiUvmGTbhDDQn5engOzANtpEBkhXWGajZrnqAPjwNdGJ/
ostQBjrXc7D9I30aLtjEbLIafYxi6yH/8co02CddDt3/NQstRBrbqcnRYLOb
1FvLvhw0lD9LmdtHg7+1Hq7EbA562ZLUV65Ig2RPIwn3zbkodqlPf6cqDXjU
hKYF9HKR7LVzGpxaNLjbcjNpF8pFthZOwn3mNKgUN49Ryc1DbVK+PZ4hNJja
5X9rh1kBulPUYPXvDg2y7AsXH7kXoONybKORETRodD35nT28ALUo3pvJvEeD
IWNe1cjaAtSknrO2M4UGM9vkDtwULERPjToP7imlQUnvmzRmVyEqDZR+NN5D
g726OZ3yB4uR2+pliat9NNi9X9GjXq8YyYZiRYv9NKj+U3Bb3qEYFUZq1PAN
0+BkbBzjw71ilJdo3HmURgPMd+Pir9FilFF8ezVtiQavD+lvHbpTguI+9TmZ
SNEhekVZ8199KYoJui/VLUOHC3zVvGrvS9FdWe2ps3voUHiZT/PCSCkKD6xx
MVCggyBX3jtXjjIUIJXkpnuYDh+U+nPdTpch1+tG1zT16bB0Z9Mnpd4yBALv
/OWu06FBqPpEV185OtIUqlFygw4yM8of1afKkfol9X+7b9Fhcda5P3a+HKk+
L7ktHUSH61uOOM7xV6C9F6P+2xlFh3cG7f9VGlYgoRrtiG0ZdOjVDaJ/b6lA
hGlzAkcbHfhvegemP6hEv4rC3Z++pkPZ6j+fUwWVaGXpzCn3N+T9A9glBqsr
EW9+37++D3S4V4HysM5KJDuPu5Z8oYPBO5tISY4qZJ8sqGlE0GH7l5xaUZcq
5EofFF43Swc/l+kN0t5VyONI9lz9PB1m6fcPCQRVocBJuZJdf+mAv/oim59S
hR6qaAn8XssAt+sJJXdbq1DXp8v4YxEGDB3qVVHfiKF+WaVXJtsZcCZzzUkP
fgyNBC5kce5kwOeP/8xShDDElPrP3EuaAULaqyHPJTDE5ZvSfFKJAcYLP5Su
qWLomGBz6ow2AzRlU/a7nsOQrlu4V7YuAxQmTDe/t8OQ0Ysz+uZ6DOhy3Msl
5YQhO+c+dmTEAL77ZfoVVzDkX4u7J9owoHC9jaV0IIaqzQVPqHkx4Hhm88/y
dAwl8gXTkQ8DInzMTDgzMeT9hn5f5wYDOPiexFrkYEj56PMB0wAGXC95n91b
hCFMysnDI5wBybI0M90aDMWPvN+6EMmAzUMqTaefYsjz4cH6gLsMeLUhmk+r
AUOKvNxro+MYsGiQ7MnTjKHKOSwtL40BjviC1fZ3GIqtEAG5DAaEZkkpvu7E
kIdr2CSWyYA9Gkf/OnVhSP6rpWJTHgOW5Lp8g/owVP5ypW2gggF+2rHKiqMY
Kk3Q/7HxJQOMRFuPhPzA0F29upTkNgYITJgq+M9i6PK6nRqi7QwY505VujSP
oT235sJl3zNg7+Fgj12LGCq2Txc98ZkBGYtP1gitYihKZG3LmwGynvh7lc/Y
qOjSp6suRl8ZcC982e8sBxXt1j1GPT/GAK2H1tdt11FRoSJdxw9ngJ6fvMY8
NxVFMIyZK0wGUD+sCgMvFbnkNSaEEwwIlOaUCd5IRdJCcUOJ8wwo8njaN8JH
RWu7F0MovxkQ23wpcGUzFU3eddyd/Ye83+cL57byU1H+iqp3xQqZp+rZNjEB
Kgp7liWkwo5DlXPazS2CVHTRe8OLhjU4vH9ifGqJtNT0EGcHFw5reUoqKoXI
9bN1Kgx5cBBmD9L1EybXt8ZM+jbicHzq2N5DFCrK67zzeIIfB75lie5kESqK
UV6yzRLEwX7llLOWKBXdSPEWsxXGge29wdVR0hf+ML4Ki+JAKfwz4yVGRbrn
HR71bceB653g5G/S+1sGziXuxEE71NPKazsViUobiZzdhUP19iG9EdJro9u/
8MjgUL+o0KK5g4pYTM20DlkcTvufaEwk3W9UZxW+F4c7YotHBkk318gLH1fA
4Zqr4mlBcSoqFS7oX1HCIf7Px4kTpJMCxR40HsBhLqKN14V04FiShd9BHLq/
Lr0JIO1ykmebqhoO+qOXtoeTPlsc2vdTA4e4hxzcoaQP8/5NrtTEgSXXluhN
WsLTy+zKMRx6B8sbLEhzf6JvlT2Jg7lwc5gC6flD9r2TOjgc9Fo3/4esb/hR
f2LOaRxu5Ubx1JN+vWpoYqePw1iC9YcrpDGn11tEz+IQbBED/KTT2o929xvj
YKWs5lhO7kfo3tr4ZDMc0ONANXXS7nH7jIwtcSjTu9nRSO6n+Vwe36ZzOLwT
NeRXJq1pKfrxrS0OvspyIulkHrKNibGRF3Booh/+9ovMb4s4t+FJRxzuD5d5
niL9NzRkI7szDs+JZ6/ukXl3nvGM8b+MQ4NGbC9B9kddJU3v0FUcDFP6E/lI
Z/Nf4Jm/hsNF/Rcyu7ZRkfegwd2rvmSejnFfpMn+s9V8dVrODwdFS/FVga1U
pJ17ZAPNHweL7fOyi1uoSPjy3ij7/3Aw2BWMp5H9zf4h99T2OziUeqWWWW2i
IlxZhHMwHAduexFbHvI8vPjDFWF6Dwehdqk0ffL8OEZP39FJJfO0dJrUXEtF
et/Pn1iTRu5P7ljIY/L8qRj3cTQ/Ivdzsk7uB3k+OSltIWo5ZH+L1Jd7LZPz
oTgneF85DtsmRPunFjCUyksBRiUOnkdOq0zNYSjYM36lgIqDdchg/cBPDJkc
Dr4t/hSHv4/XGmR8x9DvdtsA/pdk/8sE/EuZxNAOUx3fl204tHvfUTo+gSGd
EcVr3u1k/dQbQt/I+ZM6z+HU8x6HHwr1vGu+YkhFouRMYj95vg6NLTWS88vb
f4HCTz7Xzn6pVhEk52H6utGtLwkcTl2qsNhEzsuW+I6N3rM4KCiuuP57gqHN
RY/Ye36T9d+3vvS0AkNVvccYCRwzYCKzaFiSTf5e7It9tkV4BhatcPX/wjAk
8OxmdYvIDJgfUD/w9j8MaZxwKPfaPgMD2j02G26T89BaJbtbcgb4eBoNXX3J
+RcxGJkgPwMbtdP25zpjyGVUxnLLiRk4fiSnUegkhsYS0MJmjxk4UPNS7fhs
FRoLNWhI9JwBt+7ab2P0KjTu8zVIwGcGXh28+fTqaBWaMP/NKew3A5ZrepaM
31ehbxRFEfHQGTi3NbdPu6AKTedkasqnzsCyHKNv3LQKzVBvR55umgGM6/h6
6fxKxMzl0X/XPAPKQRPPHz4knZS22aB1BrxqHYqXYkj71qYZdcyAu+TDY3G+
lYil9r3MsmcGDDOF/FjalehHi22X8/QMvMiyZyZ/q0C/ujUooZuYsJmIv9dK
Pk+wXe3/rbaFCZ4R5/m411Ygbi6fzz+3MsHQVERNc6Ec7dAsTXKgMMFK5g31
Wn850i4V3nRMignWBS9zF9PLUXLoAgebOhOMsq5xVu4oRwcOVDFvOzNhONNm
fh2lDHkmSzbfes4Ee9XCGylDxcgkxdFtDWICHmlsv/C2GKmm5vLfb2FC8IPq
IN36YvT3gaRz9msmrJMJie9IKUbhjyS527uYsNVCKEbZsBil50qaCUwx4apY
kPKT50WoDZOkV278Dk0flrsH4wuRUKfk5km77xAdenhhByUfmfaV/xNb+Q7F
jlt+Rnc8RrMXctyHSllA2fin/jlXIlp4sE7VoYIFAsOp4SbDCWjxo9vyFPm/
r/fQWsosNQGtwv5YooYFhYpN42dtEhDvztYqDsQCwZP2SnGV8Uh6bHJWtpcF
DR9HnXoqY5GVvewt3yUWFGzeZKF1ORrZPIw59neZBRXHPwloCUUju64fG4LZ
CNB4lVd1pS0KOWvVp0etI6AefydxRjwKee888/wRHwFUoyUdzf4IFDN2ZbVl
FwH7n9T9HTMKQ8i+KnyTPgEGYwLnUqeCUMNHd70RQwL86tiSdx4NQnWaclsq
jQnY8K8u43rKbVQuVpBhYEnAz7u/2e/pBqL0gfQnMY4ElF3iHGc+u4V8jSLG
uW8RsKSh8KH59XXkiU4UDQYQcEO+MllM/jpyV2C/WhpEwBxRq5GU7IMceQMX
T4cRkEgzv4e7eCOjDi++6DgChuMSGlcpnmiv1vmjnIUELLvumuEKcUUyVSJr
+osJWG2poQj6uSDJHQMdhWUEvA3Jyrf3dkbC/0zMdKgEmP8NZ/J7OaH1z3Sv
hD8nINDjSc/lAxcQx+71yuaIAEvBwcVNNufRckrrL6mXBLQadp1n3bVB8z6a
oW3tBCTEVT4LWWuFxhVV0tb0EvCjqTVC5pIxGsr8adfbR8DVAeXU67Vn0cDG
Kqm8AQJYHD4Lc5g++jCzBzs+QkBO9ak/NoQOenuO5ss/ToBW2Cb1dpWT6NWb
fI2Jb+R+1+XrZ6UcQ8+LxNtDGATs0uXdF+Sghp5tG44xZhJwbUNW3usRFfQk
PN1EgiAgUzU8/nW+EqqctxT++ZOADtYZJSnfPajUSXCkeZ6Azi2EQaKJJCro
6cmL/01Ao6KEu+WCEMo+Fu9m/5cA5qsxw7e63CgDM1BUWv7/e5tI/9BXs00P
xHkW/v/e95YM+7wT2xj8D1QdlKg=
        "]]}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.922526, 0.385626, 0.209179], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwV1nc8ld8fAHA0kBkRvspIkZmSkvg0EKJhlKYZpYyIlFFkRnYySva4KSMh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        "]]}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.528488, 0.470624, 0.701351], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwVl3k4lc8bxoXkm1atZE+0SFlKUe5UZCktCpUoUlIpewnJloTsIcl6TiQq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        "]]}, {
       Directive[
        Opacity[1.], 
        RGBColor[0.772079, 0.431554, 0.102387], 
        AbsoluteThickness[1.6]], 
       LineBox[CompressedData["
1:eJwVlnc8V/8Xx6VhtI2ifCPZMjJK8rlHRFayQ0iJsjJLIntm75H1MTOyste1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        "]]}}}, {
    DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, DisplayFunction :> 
     Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, "ScalingFunctions" -> None}, 
     PlotLabel -> 
     FormBox["\"Divergence Removed? but this time better constants?\"", 
       TraditionalForm], 
     PlotRange -> {{0, 1}, {-0.1577093757653725, 0.9999999999999987}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}],FormBox[
    FormBox[
     TemplateBox[{
      "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(+2\\), \
0\\)]\\)(1-\\!\\(\\*SuperscriptBox[\\(e\\), \
\\(2\\)]\\)\\!\\(\\*SuperscriptBox[\\()\\), \\(3/2\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(+2\\), \
1\\)]\\)(1-\\!\\(\\*SuperscriptBox[\\(e\\), \
\\(2\\)]\\)\\!\\(\\*SuperscriptBox[\\()\\), \\(3/2\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(+2\\), \
2\\)]\\)(1-\\!\\(\\*SuperscriptBox[\\(e\\), \
\\(2\\)]\\)\\!\\(\\*SuperscriptBox[\\()\\), \\(3/2\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(+2\\), \
3\\)]\\)(1-\\!\\(\\*SuperscriptBox[\\(e\\), \
\\(2\\)]\\)\\!\\(\\*SuperscriptBox[\\()\\), \\(3/2\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(+2\\), \
4\\)]\\)(1-\\!\\(\\*SuperscriptBox[\\(e\\), \
\\(2\\)]\\)\\!\\(\\*SuperscriptBox[\\()\\), \\(3/2\\)]\\)\"", 
       "\"\\!\\(\\*SubscriptBox[\\(p\\), \\(\\(+2\\), \
10\\)]\\)(1-\\!\\(\\*SuperscriptBox[\\(e\\), \
\\(2\\)]\\)\\!\\(\\*SuperscriptBox[\\()\\), \\(3/2\\)]\\)\""}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #4}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.528488, 0.470624, 0.701351], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #5}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    Opacity[1.], 
                    RGBColor[0.772079, 0.431554, 0.102387], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #6}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.368417, 0.506779, 0.709798]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.880722, 0.611041, 0.142051]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.37345400000000006`, 0.461046, 0.12992333333333334`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.560181, 0.691569, 0.194885]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.560181, 0.691569, 0.194885]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.560181, 0.691569, 0.194885], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"Opacity", "[", "1.`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    RowBox[{
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.6150173333333333, 0.25708400000000003`, 
                    0.13945266666666667`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "\[InvisibleSpace]"}], 
                    "RGBColor[0.922526, 0.385626, 0.209179]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInit