rm(list=ls(all=TRUE)) # clears variables1 
def.par<-par(no.readonly=TRUE) # default graphical parameters

Sys.setlocale("LC_TIME", "en_IN") #use English for dates

#Sys.setlocale("LC_TIME", "fr_FR.utf8") #use French for dates


library('tidyverse')
library('nnet') # for multinomial model

library('mixdist') # for Weibull distribution
library("drc") # for dose response curve model

library("texreg") # conversion to TeX
library("Hmisc") # for summary tables

library("raster")
library("ggmap")
library("sf")
library("maps")
library("mapproj")
library("zoo")

library('ggsci')       # for nice color palettes

library("car")
library("lme4") 
library('emmeans')
library("ggpubr")

library(stargazer) # to export nice tables



Sys.setlocale("LC_TIME", "en_IN") #use English for dates




#### Reading the data

setwd("/home/samuel/Documents/Hote-parasite/COVID-2019/Ct/VOC/Omicron/")


data<-read.csv2(file="data_EID2.csv")

data<-as_tibble(data)


data$date = as.Date(data$date)
data$date_labo = as.Date(data$date_labo)
max_date<-max(data$date_labo)
min_date<-min(data$date_labo)

dim(data)
quantile(data$age,c(0.025,0.5,0.975))
table(data$location_sampling)/dim(data)[1]
table(data$variant)/dim(data)[1]
table(data$REGION)
  

#save the data just in case
Df_stored<-data 




##########################
#### Generic Plots



Df <- ungroup(data) %>% group_by(REGION) %>% dplyr::mutate(n_REGION=n())
Df <- Df %>% dplyr::mutate(region2=ifelse(n_REGION>1500,as.character(REGION),"autres"))
Df$region2<-as.factor(Df$region2)
Df = within(Df, region2 <- relevel(region2,ref='Ile-de-France'))

Df$variant <- factor(Df$variant, 
                     levels = levels(Df$variant)[c(3,2,4,1,5:7)])


# ggplot(dplyr::filter(drop_na(Df,region2,variant),
#                      #date_labo>=max_date-28,
#                      variant!="other?"))+
#   geom_bar(aes(x=date_labo,fill=variant),position="fill")+
#   labs(x="",y="Proportion des tests")+
#   facet_wrap(.~region2,ncol=3,scale="free_y")+
#   #  scale_y_continuous(trans = 'log10')+
#   theme(axis.text.x=element_text(angle = -45, hjust = 0))+
#   scale_fill_jama()+
#   theme_classic()

# 
# ggsave(paste("proportion_data_per_region_",max_date,".pdf",sep=""),
#        width = 22,height = 16,units = "cm")


ggplot(dplyr::filter(drop_na(Df,region2,variant),
                     date_labo>=min_date,
                     variant!="other"))+
  geom_bar(aes(x=date_labo,fill=variant))+
  facet_wrap(.~region2,ncol=3,scale="free_y")+
  labs(x="",y="Number of tests",fill="")+
  #  scale_y_continuous(trans = 'log10')+
  theme(axis.text.x=element_text(angle = -45, hjust = 0))+
  scale_fill_jama() +
  theme_classic()

ggsave(paste("raw_numbers_per_region",max_date,".pdf",sep=""),
       width = 20,height = 16,units = "cm")




ggplot(dplyr::filter(drop_na(Df,region2,variant),
                     date_labo>=min_date,
                     variant!="other"))+
  geom_bar(aes(x=date_labo,fill=variant),position="fill")+
  labs(x="",y="Proportion of tests",fill="")+
  #  scale_y_continuous(trans = 'log10')+
  scale_x_date(date_labels = "%b %d",date_breaks = "2 weeks")+
  theme(axis.text.x=element_text(angle = -45, hjust = 0))+
  scale_fill_jama() +
  theme_classic()

ggsave(paste("proportions_",max_date,".pdf",sep=""),
       width = 13,height = 7,units = "cm")





##################
## Multinomial model
#############""""""

Df <- ungroup(Df_stored) %>% group_by(REGION) %>% dplyr::mutate(n_REGION=n())


Df <- Df %>% dplyr::mutate(region2=ifelse(n_REGION>1000,as.character(REGION),"other"))
Df$region2<-as.factor(Df$region2)
Df = within(Df, region2 <- relevel(region2,ref='Ile-de-France'))


Df$variant<-as.factor(as.character(Df$variant))
Df$variant<-droplevels(Df$variant)


#centering and scaling variables
Df$age_scale <- scale(Df$age)
Df$date_scale<-scale(as.numeric(Df$date_labo))

Df$location_sampling<-as.factor(Df$location_sampling)
Df = within(Df, location_sampling <- relevel(location_sampling,ref='non-hospital')) # reference is the covid3 test (latest)



data_multinom <- dplyr::filter(Df,
                               date_labo>=min_date,
                               date_labo<=min_date+54,
                               #date_labo<=max_date-54,
                               #     COV1K_02 %in% c("covid3","covti2")
)

data_multinom <- ungroup(data_multinom) %>% group_by(variant) %>% dplyr::mutate(n_variant=n())


data_multinom$variant_old<-data_multinom$variant

data_multinom <- data_multinom %>% 
  dplyr::mutate(variant=ifelse(n_variant>50,as.character(variant_old),"other"))

data_multinom$variant<-as.factor(data_multinom$variant)
data_multinom$variant<-droplevels(data_multinom$variant)

data_multinom$age_scale <- scale(data_multinom$age)
data_multinom$date_scale <- scale(as.numeric(data_multinom$date))



data_multinom = within(data_multinom, variant <- relevel(variant,ref='A0B9C1D0')) # reference is Omicron


data_multinom$location_sampling<-relevel(data_multinom$location_sampling,ref="non-hospital")
data_multinom$location_sampling<-as.factor(data_multinom$location_sampling)



test <- multinom(variant ~ age_scale +location_sampling +  date_scale:REGION, data = data_multinom)



z <- summary(test)$coefficients/summary(test)$standard.errors
p <- (1 - pnorm(abs(z), 0, 1)) * 2
results_significant<-(p<=0.05)*exp(coef(test))
(p<=0.05)*p

t(round(results_significant,2))

ConfidInt<-signif(exp(confint(test)),2) # calculating the 95% CI for the RRR

# write.csv2(cbind(t(round(results_significant,2))[,1],ConfidInt[,,1]),file=paste("multinomial_A0B9C0D0_",max_date,".csv",sep=""))
# write.csv2(cbind(t(round(results_significant,2))[,2],ConfidInt[,,2]),file=paste("multinomial_A0B9C0D1_",max_date,".csv",sep=""))
# write.csv2(cbind(t(round(results_significant,2))[,3],ConfidInt[,,3]),file=paste("multinomial_A0B9C1D1_",max_date,".csv",sep=""))
# write.csv2(cbind(t(round(results_significant,2))[,4],ConfidInt[,,4]),file=paste("multinomial_other_",max_date,".csv",sep=""))


# write.csv2(t(round(results_significant,2)),file=paste("output_multinomial_model_",max_date,".csv",sep=""))




##########################################
### Coinfections
##########################################

library("glm.predict")


data_multinom <- dplyr::filter(Df,
                               date_labo>=min_date+4,
                               date_labo<=min_date+25,
                               #date_labo<=max_date-54,
                               #     COV1K_02 %in% c("covid3","covti2")
)

data_multinom$REGION<-as.factor(data_multinom$REGION)

data_multinom<-dplyr::filter(data_multinom,is.na(REGION)==0)

# define relative time (in days)
Day0 = min(data_multinom$date_labo)

data_multinom$day<-data_multinom$date_labo-Day0
data_multinom$day<-as.numeric(data_multinom$day)

test <- multinom(variant ~ age_scale +location_sampling + day*REGION, data = data_multinom)


# extracting residuals and fitted values
data_multinom$res1 = residuals(test) 

data_multinom_fitted <- dplyr::bind_cols(data_multinom,as_tibble(fitted.values(test)))

data_multinom_fitted$deltacron<-data_multinom_fitted$A0B9C1D0*data_multinom_fitted$A0B9C0D1

ggplot(data_multinom_fitted)+
  geom_smooth(aes(x=date_labo,y=A0B9C1D1))+
  geom_smooth(aes(x=date_labo,y=A0B9C0D1),col="red")+
  geom_smooth(aes(x=date_labo,y=A0B9C1D0),col="black")+
  # scale_y_continuous(trans='log10')+
  scale_x_date(date_labels = "%b %d",date_breaks = "2 days")+
  labs(x="date",y="frequency")+
  theme_classic()




# ggsave(last_plot(),paste("coinfections_",max_date,".pdf",sep=""),
#        width = 10,height = 6,units = "cm")




###########################
# map regions
####################



data_regions_omicron<- ungroup(data_multinom_fitted)  %>% group_by(REGION) %>% 
  dplyr::filter(date_labo>="2021-12-20",date_labo<="2021-12-26") %>% dplyr::summarise(mean(A0B9C0D1),mean(A0B9C1D0),mean(A0B9C1D1))

names(data_regions_omicron)<-c("region","omicron","delta","coinfection")

data_regions_omicron$region<-as.character(data_regions_omicron$region)

data_regions_omicron$region = replace(data_regions_omicron$region,
                                      which(data_regions_omicron$region == "Ile-de-France"),
                                      "Île-de-France")
data_regions_omicron$region<-as.factor(data_regions_omicron$region)

Reg.Fr = raster::getData(name="GADM", country="FRA", level=2) 

regions_target<-Reg.Fr$NAME_1
regions_target<-as.data.frame(regions_target)
names(regions_target)<-c("region")
values_target<-left_join(regions_target,data_regions_omicron,by="region")


# matching region indices

# adding the number of tests, last infered frequency
# and mean overcontagiosity to each mapped region
Reg.Fr$omicron <- 100*as.numeric(values_target$omicron)
Reg.Fr$delta <- 100*as.numeric(values_target$delta)
Reg.Fr$coinfection <- 100*as.numeric(values_target$coinfection)


# specifying custom colors
custom.cols1 <- colorRampPalette(c('white','darkgoldenrod2'))
custom.cols2 <- colorRampPalette(c('white','darkslategrey'))
custom.cols3 <- colorRampPalette(c('white','dodgerblue'))


# spatial plots
plot1<-raster::spplot(Reg.Fr, 'omicron',col.regions=custom.cols1(20),
                      main=list(label="% A0B9C0D1"),
                      par.settings = list(fontsize = list(text = 10)),
                      margins=F,frame.plot=F,lwd=0.2)
plot2<-raster::spplot(Reg.Fr, 'delta',col.regions=custom.cols2(20),
                      main=list(label="% A0B9C1D0"),
                      par.settings = list(fontsize = list(text = 10)),
                      margins=F,frame.plot=F,lwd=0.2)
plot3<-raster::spplot(Reg.Fr, 'coinfection',col.regions=custom.cols3(20),
                      main=list(label="% A0B9C1D1"),
                      par.settings = list(fontsize = list(text = 10)),
                      margins=F,frame.plot=F,lwd=0.2)


# layout
ggarrange(plot1,plot2,plot3,
#          labels = c("A", "B","C"),
          ncol = 3, nrow = 1,
          font.label = list(size = 9))

# ggsave("maps_variants_coinfection.pdf",
#        width = 18,height = 6,
#        units = "cm",dpi = 300)
# 
# 
# ggsave("maps_variants_coinfection.png",
#        width = 18,height = 6,
#        units = "cm",dpi = 300)




##########################################
### Ct differences
##########################################



Df <- ungroup(Df_stored) %>% group_by(REGION) %>% dplyr::mutate(n_REGION=n())


Df <- Df %>% dplyr::mutate(region2=ifelse(n_REGION>1000,as.character(REGION),"other"))
Df$region2<-as.factor(Df$region2)
Df = within(Df, region2 <- relevel(region2,ref='Ile-de-France'))


Df$variant<-as.factor(as.character(Df$variant))
Df$variant<-droplevels(Df$variant)


#centering and scaling variables
Df$age_scale <- scale(Df$age)
Df$date_scale<-scale(as.numeric(Df$date_labo))

Df$location_sampling<-as.factor(Df$location_sampling)
Df = within(Df, location_sampling <- relevel(location_sampling,ref='non-hospital')) # reference is the covid3 test (latest)



Df$Ct<-as.numeric(as.character(gsub(",", ".",Df$COVU5_02...CT.N.RDRP.ID4)))

Df$Ct_452R<-as.numeric(as.character(gsub(",", ".",Df$COVU5_04...CT.L452R.IDS4)))
Df$Ct_417N<-as.numeric(as.character(gsub(",", ".",Df$COVU5_05...CT.K417N.IDS4)))
Df$Ct_484K<-as.numeric(as.character(gsub(",", ".",Df$COVU5_03...CT.E484K.IDS4)))


#data_Ct<-Df %>% dplyr::filter(Ct>0,Ct<=50)
data_Ct<-Df %>% dplyr::filter(Ct>0,Ct<=28)

data_Ct$variant<-as.factor(data_Ct$variant)
# data_Ct$variant<-relevel(data_Ct$variant,ref="A0B0C1")

data_Ct <- ungroup(data_Ct) %>% group_by(variant) %>% dplyr::mutate(n_variant=n())


data_Ct$variant_old<-data_Ct$variant

data_Ct <- data_Ct %>% 
  dplyr::mutate(variant=ifelse(n_variant>50,as.character(variant_old),"other"))


#data_Ct$assay<-relevel(data_Ct$COV1K_02,ref="covid3") #only the Perkins assay

data_Ct = within(data_Ct, region2 <- relevel(REGION,ref='Ile-de-France'))
table(data_Ct$location_sampling)

data_Ct$variant<-as.factor(data_Ct$variant)
data_Ct = within(data_Ct, variant <- relevel(variant,ref='A0B9C0D1')) # reference is Omicron


data_Ct<-dplyr::filter(data_Ct,variant!="other")
data_Ct<-data_Ct %>% drop_na(location_sampling,region2)

mod0 = lm(Ct ~ age_scale + location_sampling + date_scale*region2,
          data=data_Ct)
mod1 = lm(Ct ~ age_scale + location_sampling + date_scale*region2 + variant,
          data=data_Ct)

anova(mod0,mod1)

Anova(mod1) # type II ANOVA
summary(mod1) # type II ANOVA


stargazer(mod1)



data_Ct$fitted_Ct<-predict(mod1,data=data_Ct)



plot_residuals<-ggplot(as.data.frame(residuals(mod1)))+
  geom_density(aes(residuals(mod1)),size=0.3)+
  theme_light()+
  labs(x="linear model Ct residual",y="density")


# ggsave(
#   filename="residuals_lm.pdf",
#   plot = plot_residuals,
#   width = 6,
#   height = 4,
#   units = c("cm"),
#   dpi = 300,
# )




# write.csv2(Anova(mod1),file=paste("anova_Ct_",max_date,".csv",sep=""))
# write(summary(mod1),file=paste("linear_model_Ct_",max_date,".txt",sep=""))



em1 = emmeans(mod1,~variant,opt.digits=F,digits=4)



n_fun <- function(x){
  return(data.frame(y = median(x), label = paste0("n=",length(x))))
}

n_fun2 <- function(x){
  return(data.frame(y = median(x), label = median(x)))
}

#dataMedian <- summarise(group_by(Df, variant), MD = median(Ct))
dataMedian<-cbind(as.character(summary(em1)[,1]),as.numeric(summary(em1)[,2]))
dataMedian<-as.data.frame(summary(em1)[,c(1,2)])


data_Ct<-as.data.frame(data_Ct)
data_Ct$variant<-as.factor(data_Ct$variant)
data_Ct$Ct<-as.numeric(as.character(data_Ct$Ct))


data_Ct$variant <- factor(data_Ct$variant, levels = levels(data_Ct$variant)[c(1,4,2,3,5)])


ggplot(data_Ct, 
       aes(x = variant, y = fitted_Ct))+
  geom_violin(aes(fill = variant), trim = T) + 
  geom_boxplot(width = 0.2)+
  stat_compare_means(label = "p.signif", method = "t.test",
                     ref.group = "A0B9C0D1", hide.ns = TRUE) +
  stat_summary(aes(x=as.factor(variant),y=18),
               fun.data = n_fun,
               geom = "text",
               #           hjust = 0.5,
               #          vjust = 0.9,
               size=3
  )+
  theme_light()+
  scale_fill_jama() +
  theme(legend.position = "none") +
  xlab("") +
  ylab("Ct N") 



ggsave(
  filename="fitted_Ct_VOC_covid4.pdf",
  plot = last_plot(),
  width = 12,
  height = 7,
  units = c("cm"),
  dpi = 300,
)


data_417N<-dplyr::filter(data_Ct,variant %in% c("A0B9C0D1","A0B9C1D1"),Ct_417N>0,Ct_417N<=28)

data_417N$variant<-droplevels(data_417N$variant)

mod_417N = lm(Ct_417N ~ age_scale + location_sampling + date_scale*region2 + variant,
          data=data_417N)

#summary(mod_417N)

em417 = emmeans(mod_417N,~variant,opt.digits=F,digits=4)
dataMedian417<-cbind(as.character(summary(em417)[,1]),as.numeric(summary(em417)[,2]))
dataMedian417<-as.data.frame(summary(em417)[,c(1,2)])



data_417N$fitted_Ct_417N<-predict(mod_417N,data=data_417N)

ggplot(data_417N, 
       aes(x = variant, y = fitted_Ct_417N))+
  geom_violin(aes(fill = variant), trim = T) + 
  geom_boxplot(width = 0.2)+
  stat_compare_means(label = "p.signif", method = "t.test",
                     ref.group = "A0B9C0D1", hide.ns = TRUE) +
  stat_summary(aes(x=as.factor(variant),y=22),
               fun.data = n_fun,
               geom = "text",
               #           hjust = 0.5,
               #          vjust = 0.9,
               size=3
  )+
  geom_text(data = dataMedian417, aes(variant, emmean, label = round(emmean,digits = 1)),
            position = position_dodge(width = 0.8), size = 3, vjust = -1) +
  theme_light()+
  #theme_pubr()+
  theme(legend.position = "none") +
  xlab("") +
  ylab("Ct 417N") 


ggsave(
  filename="Ct_417N_covid4.pdf",
  plot = last_plot(),
  width = 7,
  height = 7,
  units = c("cm"),
  dpi = 300,
)



data_452R<-dplyr::filter(data_Ct,variant %in% c("A0B9C1D0","A0B9C1D1"),Ct_452R>0,Ct_452R<=28)

data_452R$variant<-droplevels(data_452R$variant)

mod_452R = lm(Ct_452R ~ age_scale + location_sampling + date_scale*region2 + variant,
              data=data_452R)

#summary(mod_452R)

em452 = emmeans(mod_452R,~variant,opt.digits=F,digits=4)
dataMedian452<-cbind(as.character(summary(em452)[,1]),as.numeric(summary(em452)[,2]))
dataMedian452<-as.data.frame(summary(em452)[,c(1,2)])

?predict

data_452R$fitted_Ct_452R<-predict(mod_452R,data=data_452R)

ggplot(data_452R, 
       aes(x = variant, y = fitted_Ct_452R))+
  geom_violin(aes(fill = variant), trim = T) + 
  geom_boxplot(width = 0.2)+
  stat_compare_means(label = "p.signif", method = "t.test",
                     ref.group = "A0B9C1D0", hide.ns = TRUE) +
  stat_summary(aes(x=as.factor(variant),y=21),
               fun.data = n_fun,
               geom = "text",
               #           hjust = 0.5,
               #          vjust = 0.9,
               size=3
  )+
  geom_text(data = dataMedian452, aes(variant, emmean, label = round(emmean,digits = 1)),
            position = position_dodge(width = 0.8), size = 3, vjust = -1) +
  theme_light()+
  #theme_pubr()+
  theme(legend.position = "none") +
  xlab("") +
  ylab("Ct 452R") 



ggsave(
  filename="Ct_452R_covid4.pdf",
  plot = last_plot(),
  width = 7,
  height = 7,
  units = c("cm"),
  dpi = 300,
)





##########################################"
### Transmission advantage caclulation




## functions for transmission advantage


# serial interval distribution parameters
MEAN = 4.8 ; SD = 2.3
# Nishiura et al. (2020) IJID https://doi.org/10.1016/j.ijid.2020.02.060
WP.chosen = weibullpar(MEAN,SD)
# transform into Weibull shape and scale parameters

# serival interval distribution
is=function(x){
  dweibull(x,WP.chosen$shape,WP.chosen$scale)
}

# Euler-Lotka integrand
EL_integrand = function(x__,r__, R__) {
  signr = -1
  if(R__ < 1){R__ = 1/R__}
  exp(signr * r__ * x__)*R__*is(x__)
}

# Euler-Lotka integral
euler_lotka = function(r_,R_){
  integrate(EL_integrand,0,Inf,r__=r_,R__=R_)$value - 1
}

# Eulter-Lotka equation solution
# (estimation of exponential growth rate given R and the
# serial interval)
rate.calc = function(R){
  if(R == 1){res = 0}
  else {
    interv = c(0,100)
    res = uniroot(euler_lotka,interval=interv,R_=R)$root
    if(R < 1){res = -res}
  }
  return(res)
}

# the function to cancel in overcontagiosityf
overcontagiosityfoo = function(x,A,R_0){
  A - rate.calc(x) + rate.calc(R_0)
}

# final calculation of the overcontagiosity
# mean and associated 95-% confidence interval
# on the reproduction number scale
overcontagiosityf = function(modl,R_0_){
  Coefs = cbind(modl$coefficients,confint(modl))
  Coefs = -Coefs[1,]
  c(uniroot(overcontagiosityfoo,A=Coefs[1],R_0=R_0_,interval=c(.2,5))$root,
    uniroot(overcontagiosityfoo,A=Coefs[3],R_0=R_0_,interval=c(.2,5))$root,
    uniroot(overcontagiosityfoo,A=Coefs[2],R_0=R_0_,interval=c(.2,5))$root)/R_0_-1
}



# logistic growth function maker
lgfm = function(lgm,given.tau = F) {
  coefs = cbind(lgm$coefficients,confint(lgm))
  if(given.tau){coefs[1,] = coefs[1,1]}
  # set tau to its mean value
  lgf = function(x){
    # define logistic growth function
    c(1/(1+exp(coefs[1,1]*(x-coefs[2,1]))),
      1/(1+exp(coefs[1,2]*(x-coefs[2,2]))),
      1/(1+exp(coefs[1,3]*(x-coefs[2,3]))))
  }
  lgf = Vectorize(lgf)
  return(lgf)
}




### Transmission advantage of omicron vs. delta variants in France

Dt = Df_stored



Dt<-Dt %>% dplyr::filter(
  date_labo>=min_date,date_labo<=max_date,
  COV1K_02=="covid4")


Dt <- ungroup(Dt) %>% group_by(departement) %>% dplyr::mutate(n_departement=n())



Day0 = min(Dt$date_labo)
max(Dt$date_labo)

Dt$day<-Dt$date_labo-Day0
Dt$day<-as.numeric(Dt$day)


# delta against the alpha
Dt$souche_bin<-NA
Dt$souche_bin = replace(Dt$souche_bin,
                        which(Dt$variant == "A0B9C0D1"),
                        1)
Dt$souche_bin = replace(Dt$souche_bin,
                        which(Dt$variant == "A0B9C1D0"),
                        0)

dim(Dt)



Dt<-drop_na(Dt,souche_bin,day,age,REGION)



# GLM to generate residuals


nonhosp = T # remove hospital samples


if(nonhosp){
  Dt <- dplyr::filter(Dt,location_sampling == 'non-hospital')
  modr = glm(souche_bin~day+age+REGION,
             data=Dt,family="binomial")
} else {
  modr = glm(souche_bin~day+age+location_sampling+REGION,
             data=Dt,family="binomial")
}




# extracting residuals and fitted values
Dt$res1 = residuals(modr) ;
Dt$fit1 = fitted.values(modr)

# logistic growth fitting and display -------------------------------------



Df = Dt


# calculate daily souche frequencies


Df <- Df %>% group_by(day) %>%
  dplyr::summarise(ie = sum((souche_bin))/n(),
                   ir = sum(res1)/n(),
                   iF = sum(fit1)/n())


# logistic curve fitting
mL <- drm(iF ~ day, data = Df,
          fct = logistic(fixed = c(NA,0,1,NA,1)),
          type='continuous')

# overcontagiosity calculations
lgf = lgfm(mL,given.tau=T)

scv<-c(0,0,0)

scv = signif(overcontagiosityf(mL,1)*100,3)

scv


# plotting the output


pdf(paste("omicron_delta_France_",max_date,"_fr.pdf",sep=""),
    width=6,height=6,pointsize=15)

par(mfrow=c(1,1))

main.title = paste("transmission advantage:","\n +",scv[1]," [",scv[2],
                   " - ",scv[3],"]%",sep='')


# logistic curve plot
# logistic curve plot
time.window = seq(min(Df$day)-3,max(Df$day)+4,by=1)
Xlim = c(min(time.window),max(time.window))
ticks.at = seq(Xlim[1],Xlim[2],length.out = 10)

plot(Df$day,Df$iF,xlim=Xlim,ylim=c(0,1.000),axes=F,
     #     xlab='',ylab = 'beta/gamma/eta frequency vs. others',
     xlab='',ylab = 'frequency of A0B9C0D1 vs. A0B9C1D0',
     pch=17,col=rgb(0,134,139,130,maxColorValue = 255))
par(new=T)
plot(time.window,lgf(time.window)[1,],
     type='l',xlim=Xlim,ylim=c(0,1.000),axes=F,
     col=c('darkblue','lightblue','lightblue'),lwd=2,
     lty=c(1,3,3),main=main.title,xlab='',
     ylab='')
par(new=T)
polygon(c(time.window,rev(time.window)),
        c(lgf(time.window)[2,],rev(lgf(time.window)[3,])),
        col = rgb(28,134,238,50,max=255),lty=0)
abline(v=as.Date("2020-07-01")-Day0,
       col=rgb(.8,.2,0,.5))
abline(h=0.5,lty=2)
axis(2,ylim=c(0,1.000))
axis(1,at = ticks.at,
     labels = format(Day0+ticks.at,"%d %b"))
par(new=F)

dev.off()





