library(plot3D)

with_log <- FALSE

# just to remember the parameter combinations
# all_k <- c(rep(2,9),rep(5,9),rep(8,9))
# all_lambda <- rep(c(0.001,0.001,0.001,0.01,0.01,0.01,0.05,0.05,0.05),3)
# all_mu <- rep(c(1,0.5,0.2),9)
# all_gamma <- rep(2,27)

make_figure <- "extinction_real" # "deltaR"  "richness"  "sackin"  
                              #"skew"  "speciationBD"  "extinctionBD" "extinction_real"

use_manual_table <- FALSE # it will come from "stats_manualTable_for3D.R"

number_parameter_combinations <- 27





shapes <- c(rep(15,number_parameter_combinations),rep(16,number_parameter_combinations),rep(17,number_parameter_combinations))



if(use_manual_table == FALSE){
  # to give same distance

all_k <- c(rep(1,9),rep(2,9),rep(3,9))
all_lambda <- rep(c(1,1,1,2,2,2,3,3,3),3)
all_mu <- rep(c(3,2,1),9)



table_for_plot <- data.frame(lambda=all_lambda,
                             mu=all_mu,
                             k=all_k,
                             scena=c(rep("merge",number_parameter_combinations)))
table_for_plot <- rbind(table_for_plot,
                        data.frame(lambda=all_lambda + 0.2,
                                   mu=all_mu,
                                   k=all_k,
                                   scena=c(rep("mergeplit",number_parameter_combinations))))
table_for_plot <- rbind(table_for_plot,
                        data.frame(lambda=all_lambda - 0.2,
                                   mu=all_mu,
                                   k=all_k,
                                   scena=c(rep("solid",number_parameter_combinations))))

if(make_figure == "extinction_real"){
  all_extinction_real <- NULL
  for(i in 1:number_parameter_combinations){
    my_data <- read.csv(paste0("output_extinction_real_pars_",i,".csv"))[-1]
    all_extinction_real <- c(all_extinction_real, median(my_data$merge_extinction_real))
  }
  for(i in 1:number_parameter_combinations){
    my_data <- read.csv(paste0("output_extinction_real_pars_",i,".csv"))[-1]
    all_extinction_real <- c(all_extinction_real,  median(my_data$mergesplit_extinction_real))
  }  
  
  for(i in 1:number_parameter_combinations){
    my_data <- read.csv(paste0("output_extinction_real_pars_",i,".csv"))[-1]
    all_extinction_real <- c(all_extinction_real,   median (my_data$solid_extinction_real))
  }  
  
  table_for_plot <- cbind(table_for_plot,extinction_real = all_extinction_real)
}

if(make_figure == "deltaR"){
  all_deltaR <- NULL
  for(i in 1:number_parameter_combinations){
    my_data <- read.csv(paste0("output_pars_",i,".csv"))[-1]
    all_deltaR <- c(all_deltaR, median(my_data$merge_deltaR))
  }
  for(i in 1:number_parameter_combinations){
    my_data <- read.csv(paste0("output_pars_",i,".csv"))[-1]
    all_deltaR <- c(all_deltaR,  median(my_data$mergesplit_deltaR))
  }  
  
  for(i in 1:number_parameter_combinations){
    my_data <- read.csv(paste0("output_pars_",i,".csv"))[-1]
    all_deltaR <- c(all_deltaR,   median (my_data$solid_deltaR))
  }  
  
  table_for_plot <- cbind(table_for_plot,deltaR = all_deltaR)
}

if(make_figure == "richness"){
  all_richness <- NULL
  for(i in 1:number_parameter_combinations){
    my_data <- read.csv(paste0("output_pars_",i,".csv"))[-1]
    all_richness <- c(all_richness, median(my_data$merge_richness))
  }
  for(i in 1:number_parameter_combinations){
    my_data <- read.csv(paste0("output_pars_",i,".csv"))[-1]
    all_richness <- c(all_richness, median(my_data$mergesplit_richness))
  }  
  
  for(i in 1:number_parameter_combinations){
    my_data <- read.csv(paste0("output_pars_",i,".csv"))[-1]
    all_richness <- c(all_richness, median(my_data$solid_richness))
  }  
  
  table_for_plot <- cbind(table_for_plot,richness = all_richness)
}


if(make_figure == "sackin"){
  all_sackin <- NULL
  for(i in 1:number_parameter_combinations){
    my_data <- read.csv(paste0("output_pars_",i,".csv"))[-1]
    all_sackin <- c(all_sackin, median(my_data$merge_sackin))
  }
  for(i in 1:number_parameter_combinations){
    my_data <- read.csv(paste0("output_pars_",i,".csv"))[-1]
    all_sackin <- c(all_sackin, median(my_data$mergesplit_sackin))
  }  
  
  for(i in 1:number_parameter_combinations){
    my_data <- read.csv(paste0("output_pars_",i,".csv"))[-1]
    all_sackin <- c(all_sackin, median(my_data$solid_sackin))
  }  
  
  table_for_plot <- cbind(table_for_plot,sackin=all_sackin)
}

if(make_figure == "skew"){
  all_skew <- NULL
  for(i in 1:number_parameter_combinations){
    my_data <- read.csv(paste0("output_pars_",i,".csv"))[-1]
    all_skew <- c(all_skew, median(my_data$merge_skew))
  }
  for(i in 1:number_parameter_combinations){
    my_data <- read.csv(paste0("output_pars_",i,".csv"))[-1]
    all_skew <- c(all_skew, median(my_data$mergesplit_skew))
  }  
  
  for(i in 1:number_parameter_combinations){
    my_data <- read.csv(paste0("output_pars_",i,".csv"))[-1]
    all_skew <- c(all_skew, median(my_data$solid_skew))
  }  
  
  table_for_plot <- cbind(table_for_plot,skew=all_skew)
}

if(make_figure == "speciationBD"){
  all_speciationBD <- NULL
  for(i in 1:number_parameter_combinations){
    my_data <- read.csv(paste0("output_pars_",i,".csv"))[-1]
    all_speciationBD <- c(all_speciationBD, median(my_data$merge_speciationBD))
  }
  for(i in 1:number_parameter_combinations){
    my_data <- read.csv(paste0("output_pars_",i,".csv"))[-1]
    all_speciationBD <- c(all_speciationBD, median(my_data$mergesplit_speciationBD))
  }  
  
  for(i in 1:number_parameter_combinations){
    my_data <- read.csv(paste0("output_pars_",i,".csv"))[-1]
    all_speciationBD <- c(all_speciationBD, median(my_data$solid_speciationBD))
  }  
  
  table_for_plot <- cbind(table_for_plot,speciationBD=all_speciationBD)
}

if(make_figure == "extinctionBD"){
  all_extinctionBD <- NULL
  for(i in 1:number_parameter_combinations){
    my_data <- read.csv(paste0("output_pars_",i,".csv"))[-1]
    all_extinctionBD <- c(all_extinctionBD, median(my_data$merge_extinctionBD))
  }
  for(i in 1:number_parameter_combinations){
    my_data <- read.csv(paste0("output_pars_",i,".csv"))[-1]
    all_extinctionBD <- c(all_extinctionBD, median(my_data$mergesplit_extinctionBD))
  }  
  
  for(i in 1:number_parameter_combinations){
    my_data <- read.csv(paste0("output_pars_",i,".csv"))[-1]
    all_extinctionBD <- c(all_extinctionBD, median(my_data$solid_extinctionBD))
  }  
  
  table_for_plot <- cbind(table_for_plot,extinctionBD=all_extinctionBD)
}

if(with_log == TRUE){
  table_for_plot[,5] <- log(table_for_plot[,5])
}
} else {


  table_for_plot <- table_manual
  

}  


if(make_figure == "extinction_real"){
  x <- table_for_plot$lambda
  y <- table_for_plot$mu
  z <- table_for_plot$k
  zz <- table_for_plot$extinction_real
}

if(make_figure == "deltaR"){
  x <- table_for_plot$lambda
  y <- table_for_plot$mu
  z <- table_for_plot$k
  zz <- table_for_plot$deltaR
}


if(make_figure == "richness"){
  x <- table_for_plot$lambda
  y <- table_for_plot$mu
  z <- table_for_plot$k
  zz <- table_for_plot$richness
}
if(make_figure == "sackin"){
  x <- table_for_plot$lambda
  y <- table_for_plot$mu
  z <- table_for_plot$k
  zz <- table_for_plot$sackin
}
if(make_figure == "skew"){
  x <- table_for_plot$lambda
  y <- table_for_plot$mu
  z <- table_for_plot$k
  zz <- table_for_plot$skew
}
if(make_figure == "speciationBD"){
  x <- table_for_plot$lambda
  y <- table_for_plot$mu
  z <- table_for_plot$k
  zz <- table_for_plot$speciationBD
}
if(make_figure == "extinctionBD"){
  x <- table_for_plot$lambda
  y <- table_for_plot$mu
  z <- table_for_plot$k
  zz <- table_for_plot$extinctionBD
}

par(mar=c(1,1,1,2))

scatter3D(x, y, z,colvar = zz,add = FALSE, cex=1.6,pch=shapes, bty="g",type="h",expand=1,
          xlab ="Speciation",ylab="Range Evolution",zlab="CarryingCapacity",
          theta = 60, phi = 40, main=make_figure,log="zz",
          col= ramp.col(c("blue","deepskyblue", "chartreuse4","yellow","orangered1","red4")),
          xlim=c(0.8,3.2),ylim=c(0.8,3.2),zlim=c(0.8,3.2),
          cex.lab=1.6,
                 nticks=3)


legend("bottomright", inset = 0,
       legend=c("Single connection", "Double connection","Unchanged"),
       col=c("black"), cex=1.1,pch=c(15,16,17))
