UNmerge_distributions <- function(map1_trimmed,map2_trimmed,merged_species,border1,border2,join_point){
 
        new_species1 <- list()
        new_species2 <- list()
        alivespecies1 <- NULL
        alivespecies2 <- NULL
        rangeSize1 <- NULL
        rangeSize2 <- NULL

  if(join_point == "north"){


    for(i in 1:length(merged_species)){
      species_to_convert <-  merged_species[[i]]
      if(class(species_to_convert)!="character"){ #it will be an extinct species
        one_species_rangeSize <- matrix(0,ncol=2,nrow = 1)    
        one_species_map1 <- NULL
        one_species_map2 <- NULL

        
        for(ii in 1:nrow(species_to_convert)){
           one_position_species <- matrix(0,ncol=2,nrow = 1)
           one_position_species[1,1] <- species_to_convert[ii,1]
           one_position_species[1,2] <- species_to_convert[ii,2]
          if(one_position_species[1,1] <= nrow(map2_trimmed)){ # it is the top of the merged map: Map2

            one_species_map2 <- rbind(one_species_map2,one_position_species)
          } else {
            one_position_species[1,1] <- (one_position_species[1,1] - nrow(map2_trimmed)) + (border1 - 1)   # because Map 1 is the bottom part of the map
            one_species_map1 <- rbind(one_species_map1,one_position_species)  
            
          }
        }
        if(length(one_species_map1) != 0){
          new_species1[[i]] <- one_species_map1
          alivespecies1 <- c(alivespecies1,i)
          one_species_rangeSize [1,1] <- i
          one_species_rangeSize [1,2] <- nrow(one_species_map1)
          rangeSize1 <- rbind(rangeSize1,one_species_rangeSize)
        } else{
          new_species1[[i]] <- "living in Map2"
        }

        if(length(one_species_map2) != 0){
          new_species2[[i]] <- one_species_map2
          alivespecies2 <- c(alivespecies2,i)
          one_species_rangeSize [1,1] <- i
          one_species_rangeSize [1,2] <- nrow(one_species_map2)
          rangeSize2 <- rbind(rangeSize2,one_species_rangeSize)
        } else{
          new_species2[[i]] <- "living in Map1"
        }  
      } else {
        new_species1[[i]] <- "RIP"
        new_species2[[i]] <- "RIP"
      }
    }
    
    
  }
  
  if(join_point == "east"){
    
    
    for(i in 1:length(merged_species)){
      species_to_convert <-  merged_species[[i]]
      if(class(species_to_convert)!="character"){ #it will be an extinct species
        one_species_rangeSize <- matrix(0,ncol=2,nrow = 1)  
        one_species_map1 <- NULL
        one_species_map2 <- NULL
        
        for(ii in 1:nrow(species_to_convert)){
          one_position_species <- matrix(0,ncol=2,nrow = 1)
          one_position_species[1,1] <- species_to_convert[ii,1]
          one_position_species[1,2] <- species_to_convert[ii,2]
          if(one_position_species[1,2] >= ncol(map1_trimmed)){ # it is at the east part the merged map: Map2
            one_position_species[1,2] <- (one_position_species[1,2] - ncol(map1_trimmed)) + (border2 - 1)# because Map 1 is the East part of the map
            one_species_map2 <- rbind(one_species_map2,one_position_species)
          } else {

            one_species_map1 <- rbind(one_species_map1,one_position_species)  
            
          }

        }
        if(length(one_species_map1) != 0){
          new_species1[[i]] <- one_species_map1
          alivespecies1 <- c(alivespecies1,i)
          one_species_rangeSize [1,1] <- i
          one_species_rangeSize [1,2] <- nrow(one_species_map1)
          rangeSize1 <- rbind(rangeSize1,one_species_rangeSize)
        } else{
          new_species1[[i]] <- "living in Map2"
        }
        
        if(length(one_species_map2) != 0){
          new_species2[[i]] <- one_species_map2
          alivespecies2 <- c(alivespecies2,i)
          one_species_rangeSize [1,1] <- i
          one_species_rangeSize [1,2] <- nrow(one_species_map2)
          rangeSize2 <- rbind(rangeSize2,one_species_rangeSize)
        } else{
          new_species2[[i]] <- "living in Map1"
        }  
      } else {
        new_species1[[i]] <- "RIP"
        new_species2[[i]] <- "RIP"
      }
    }
    
    
  }

   return(list(new_species1=new_species1,
               new_species2=new_species2,
               alivespecies1=alivespecies1,
               alivespecies2=alivespecies2,
               rangeSize1=rangeSize1,
               rangeSize2=rangeSize2))
}

####

#testing:

testing_UNmerging <- function(simulation_whole,new_species1,new_species2,merged_species,alivespecies1,alivespecies2,
                              rangeSize1,rangeSize2){

if(length(new_species1) != length(new_species2)){
  stop("splitting failed")
}
  
if(length(new_species1) != length(merged_species)){
  stop("splitting failed")
}  


aliveFROM_distribution <- NULL
for(i in 1: length(new_species1)){
  if(class(new_species1[[i]])!="character"){
  aliveFROM_distribution <- c(aliveFROM_distribution,i)
  }
}

if(all(aliveFROM_distribution == alivespecies1) != TRUE){
  stop("splitting failed")
}
  

aliveFROM_distribution <- NULL
for(i in 1: length(new_species2)){
  if(class(new_species2[[i]])!="character"){
    aliveFROM_distribution <- c(aliveFROM_distribution,i)
  }
}

if(all(aliveFROM_distribution == alivespecies2) != TRUE){
  stop("splitting failed")
}

if(sum(simulation_whole$rangeSize[,2]) != (sum(rangeSize1[,2]) + sum(rangeSize2[,2]) )){

    stop("splitting failed")

}
}


#####






# testing_UNmerging <- function(map1,map2,L1,L2,new_L,new_species,new_rangeSize,new_map){
#   
#   L1_aliveSpecies_from_Ltable<- L1[-L1[,4]==0,,drop=F][,1]
#   L2_aliveSpecies_from_Ltable<- L2[-L2[,4]==0,,drop=F][,1]
#   survivors_separated_maps <- length(L1_aliveSpecies_from_Ltable) + length(L2_aliveSpecies_from_Ltable)
#   aliveSpecies_from_Ltable <- new_L[-new_L[,4]==0,,drop=F][,1]
#   
#   aliveSpecies_from_distribution <- NULL
#   for(i in 1:length(new_species)){
#     if(class(new_species[[i]])!="character"){
#       aliveSpecies_from_distribution <- c(aliveSpecies_from_distribution,i)
#     }
#   }
#   
#   if(length(aliveSpecies_from_Ltable)!= survivors_separated_maps){
#     stop("problem when merging")
#   }
#   if(any(aliveSpecies_from_distribution != aliveSpecies_from_Ltable)==TRUE){
#     stop("problem when merging")
#   }
#   if(length(new_species) != nrow(new_L)){
#     stop("problem when merging")
#   }
#   
#   ranges_from_distribution <- NULL
#   for(i in 1:length(new_species)){
#     if(class(new_species[[i]])!="character"){
#       ranges_from_distribution <- c(ranges_from_distribution, nrow(new_species[[i]]))
#     } 
#   }
#   
#   if(any(ranges_from_distribution != new_rangeSize[,2])==TRUE){
#     stop("problem when merging")
#   }
#   
#   available_cells_original <- length(which(map1!=-9)) + length(which(map2!=-9))
#   available_cells_new<- length(which(new_map!=-9)) 
#   if( available_cells_new != available_cells_new){
#     stop("problem when merging, check the map")
#   }
# }
