simulate_process <- function(k,
                             cycles,
                             lambda,
                             mu,
                             gamma,
                             survival_crown_lineages,
                             set_simulated_time,
                             the_map,
                             map_merging_time,
                             num_time_slices,
                             forced_crown_age,
                             starting_from_eve = "yes"){
  
  cat("__Available cells:", length(which(the_map==0)), "maximum regional richness",length(which(the_map==0))*k,"\n")
  start<-Sys.time()
  
  cycl <- 1
  numExtirp <- 1
  colnames(the_map) <- NULL
  rownames(the_map) <- NULL
  the_map <- ifelse(the_map == -9,-9,0) # get rid of non -9 cells
  map_col <- ncol(the_map)
  map_row <- nrow(the_map)
  
  if(class(starting_from_eve)!="list"){
    aliveSpecies <- 1
    species <- list()
    timeStep <- 0
    L <- matrix(c(1,timeStep,0,0),ncol = 4)
    colnames(L) <- c("id","birthTime","parent","deathTime")
    rangeSize <- matrix(c(1,1),ncol = 2)
    Eve <- place_Eve(map_col,map_row,the_map)
    species[[1]] <- Eve$prima
  }
  
  
  if(class(starting_from_eve)=="list"){
    L <- starting_from_eve[[1]]
    aliveSpecies <- starting_from_eve[[4]]
    species <- starting_from_eve[[2]]
    timeStep <- map_merging_time
    rangeSize <- starting_from_eve[[3]]
  }
  
  
  
  
  
  # a suite of metrics that will be measure at certain points in time
  total_saturation_overtime <- NULL
  mean_range_overtime <- NULL
  upper_range_overtime <- NULL
  skew_range_overtime <- NULL
  variance_range_overtime <- NULL
  betaSIM_overtime <- NULL
  betaSNE_overtime <- NULL
  beta_overtime <- NULL
  deltaR_overtime <- NULL
  alive_species_overtime <- NULL
  sackinInd_overtime <- NULL
  per_lineage_lambda_overtime <- NULL
  per_lineage_mu_overtime <- NULL
  oldest_lineage_age_overtime <-NULL
  mean_lineage_age_overtime <- NULL
  
  mean_phylo_age_overtime <- NULL
  oldest_phylo_age_overtime <- NULL
  mean_branch_overtime <- NULL
  max_branch_overtime <- NULL
  
  meanPSC_overtime <- NULL
  meanPSV_overtime <- NULL
  betaSOR_overtime <- NULL
  blom_K_overtime <- NULL    
  timeslices <- NULL
  shiftDone <- 0
  see_console_times <- seq(0,set_simulated_time,by = set_simulated_time/num_time_slices )# to print the progress of simulation
  
  inform_parent1 <- 0
  inform_parent2 <- 0
  
  
  while(cycl < cycles &&  any(aliveSpecies != 0)  && timeStep < set_simulated_time) {
    
    if(any(see_console_times == round(timeStep,1))){ 
      mean_range_overtime <- c(mean_range_overtime, median(rangeSize[,2],na.rm = TRUE))
      upper_range_overtime <- c(upper_range_overtime,max(rangeSize[,2],na.rm = TRUE))
      skew_range_overtime <- c(skew_range_overtime,skewness(rangeSize[,2],na.rm = TRUE))
      variance_range_overtime <- c(variance_range_overtime,var(rangeSize[,2],na.rm = TRUE))
      total_saturation <- sum(rangeSize[,2])
      total_saturation_overtime <-c(total_saturation_overtime,total_saturation)
      alive_species_overtime <- c(alive_species_overtime,length(aliveSpecies))
      timeslices <- c(timeslices,timeStep)
      
      eveSize <- rangeSize[which(rangeSize[,1]==1),2]
      aliveSpecies_from_Ltable<- L[-L[,4]==0,,drop=F][,1]
      lineage_age <- timeStep - L[aliveSpecies_from_Ltable,2]
      oldest_lineage_age <- max(lineage_age)
      mean_lineage_age <- mean(lineage_age)
      
      
      oldest_lineage_age_overtime <- c(oldest_lineage_age_overtime,oldest_lineage_age)
      mean_lineage_age_overtime <- c(mean_lineage_age_overtime,mean_lineage_age)
      
      sackinInd <- NA
      deltaR <- NA
      per_lineage_lambda <- NA
      per_lineage_mu <- NA
      mean_phylo_age <- NA
      oldest_phylo_age <- NA
      max_branch <- NA
      mean_branch <- NA
      blom_K <- NA
      
      if(length(aliveSpecies) > 5){ # community has a decent size, with a tree and all
        # metrics <- compute_community_metrics_timeSlice(L,timeStep,species,the_map,aliveSpecies,rangeSize,forced_crown_age)
        # betaSIM_overtime <- c(betaSIM_overtime,metrics$betaSIM)
        # beta_overtime <- c(beta_overtime, metrics$beta)
        # betaSNE_overtime <- c(betaSNE_overtime,metrics$betaSNE)
        # 
        # betaSOR_overtime <- c(betaSOR_overtime,metrics$betaSOR)
        # meanPSC_overtime <- c(meanPSC_overtime,metrics$meanPSC)
        # meanPSV_overtime <- c(meanPSV_overtime,metrics$meanPSV)
        # 
        # deltaR <- round(metrics$deltaR,digits = 3)
        # deltaR_overtime <- c(deltaR_overtime,metrics$deltaR)
        # sackinInd <- round(metrics$sackinInd,digits = 3)
        # sackinInd_overtime <-c(sackinInd_overtime,sackinInd)
        # per_lineage_lambda <- round(metrics$per_lineage_lambda,digits = 3)
        # per_lineage_mu <- round(metrics$per_lineage_mu,digits = 3)
        # per_lineage_lambda_overtime <- c(per_lineage_lambda_overtime,per_lineage_lambda)
        # per_lineage_mu_overtime <- c(per_lineage_mu_overtime,per_lineage_mu)
        # 
        # mean_phylo_age <-round(metrics$mean_phylo_age,digits = 2)
        # oldest_phylo_age <- round(metrics$oldest_phylo_age,digits = 2)
        # mean_phylo_age_overtime <- c(mean_phylo_age_overtime,mean_phylo_age)
        # oldest_phylo_age_overtime <- c(oldest_phylo_age_overtime,oldest_phylo_age)
        # 
        # mean_branch <- round(metrics$mean_branch,digits = 2)
        # max_branch <- round(metrics$max_branch,digits = 2)
        # max_branch_overtime <- c(max_branch_overtime,max_branch)
        # mean_branch_overtime <- c(mean_branch_overtime,mean_branch)
        # blom_K <- round(metrics$blom_K,digits = 4)
        # blom_K_overtime <- c(blom_K_overtime,blom_K)
        # 
        # phy_field <- metrics$phy_field
        # spp_divfields <- metrics$spp_divfields
        # 
        # mean_range_richness <- as.numeric(spp_divfields[,2]/spp_divfields[,1])
        # 
        # total_richness <- length(aliveSpecies)
        # total_grids <- length(which(the_map==0))
        # 
        # proportional_range_size <- as.numeric(spp_divfields[,1])/total_grids
        # proportional_range_richness <- as.numeric(mean_range_richness/total_richness)
        # 
        # psv_sp <- phy_field[,1]
        # psc_sp <- phy_field[,2]
        # proportinal_mean_richness_phylo <- phy_field[,4]/total_richness
        # phy_residual <- abs(psv_sp-psc_sp)
        # 
        
        
        
        # plot(proportinal_mean_richness_phylo,
        #      psc_sp,xlab="within range richness",
        #      ylab="PSV",main=round(timeStep,1),xlim=c(0,1),ylim=c(0,1))
        # if(var(psc_sp)!=0 || var(proportinal_mean_richness_phylo)!=0){
        #   abline(lm(psc_sp ~ proportinal_mean_richness_phylo))
        # }
        
        
        # RD_plot<- data.frame(psv_sp,proportinal_mean_richness_phylo)
        # d <- ggplot(RD_plot, aes(y = phy_residual, x = proportinal_mean_richness_phylo)) +
        #   xlim(0,1) + ylim(0,1) +
        #   geom_bin2d() +
        #   geom_vline(xintercept=mean(proportinal_mean_richness_phylo)) +
        #   ggtitle(paste0(round(timeStep,1)))
        # print(d)
        
        
        
        # RD_plot<- data.frame(proportional_range_size,proportional_range_richness)
        # d <- ggplot(RD_plot, aes(y = proportional_range_size, x = proportional_range_richness)) +
        #   xlim(0,1) + ylim(0,1) +
        #   geom_bin2d() +
        #   ggtitle(paste0(round(timeStep,1))) +
        #   geom_vline(xintercept=mean(proportional_range_richness))
        # print(d)
        # 
        
        
      } else {
        sackinInd <- NA
        deltaR <- NA
        per_lineage_lambda <- NA
        per_lineage_mu <- NA
        mean_phylo_age <- NA
        oldest_phylo_age <- NA
        max_branch <- NA
        mean_branch <- NA
        blom_K <- NA
        betaSOR_overtime <- c(betaSOR_overtime,NA)
        meanPSC_overtime <- c(meanPSC_overtime,NA)
        meanPSV_overtime <- c(meanPSV_overtime,NA)
        betaSIM_overtime <- c(betaSIM_overtime,NA)
        beta_overtime <- c(beta_overtime, NA)
        betaSNE_overtime <- c(betaSNE_overtime,NA)
        deltaR_overtime <- c(deltaR_overtime,deltaR)
        sackinInd_overtime <-c(sackinInd_overtime,sackinInd)
        per_lineage_lambda_overtime <- c(per_lineage_lambda_overtime,per_lineage_lambda)
        per_lineage_mu_overtime <- c(per_lineage_mu_overtime,per_lineage_mu)
        mean_phylo_age_overtime <- c(mean_phylo_age_overtime,mean_phylo_age)
        oldest_phylo_age_overtime <- c(oldest_phylo_age_overtime,oldest_phylo_age)
        
        blom_K_overtime <- c(blom_K_overtime,blom_K)
        max_branch_overtime <- c(max_branch_overtime,max_branch)
        mean_branch_overtime <- c(mean_branch_overtime,mean_branch)
      }
      
      # cat("cicles:",cycl,"  Time:",round(timeStep,1)," speciesalive:",length(aliveSpecies),
      #    "  tot_abu:",total_saturation,"deltaR",deltaR,"\n")
      
      # cat("cicles:",cycl,"  Time:",round(timeStep,1)," speciesalive:",length(aliveSpecies),
      #     "  tot_abu:",total_saturation,"deltaR",deltaR,"sackin",sackinInd,"\n")
      
      
      
      cat("t",round(timeStep,1),"species",length(aliveSpecies),
          "  tot_abu:",total_saturation,"eveSize",eveSize,"skew",skewness(rangeSize[,2],na.rm = TRUE),"\n")
      
      # hist(rangeSize[,2])
      see_console_times <- see_console_times[-which(see_console_times == round(timeStep,1))]
      #see_console_times <- see_console_times[-1]
    }
    # End of code to save partial output
    #Gillespie part
    SpeciaRate <- rangeSize[,2] * lambda 
    ExtirRate <- rangeSize[,2] * mu  
    ColoRate <- rangeSize[,2] * gamma 
    totalRate <- sum(SpeciaRate,ExtirRate,ColoRate)
    timeElapsed <- rexp(1, rate = totalRate)
    timeStep <- timeStep + timeElapsed
    
    #  this allows that the very first species expands a bit before having 
    # local extinction or speciation. It might be equivalent to start the first species 
    # with more than one cell occupied
    if (cycl < 3){ 
      event <- 3
    }else{
      event <- sample(c(1,2,3),1,prob=c(lambda,mu,gamma))  
    }
    
    
    if(timeStep >= set_simulated_time){
      cat("simulation is complete \n")
      break  
    }
    
    if(length(aliveSpecies) >= 10000){
      stop("simulation has produced more than 10000 species,I better start over \n")
      
    }
    
    ##
    
    if(any(aliveSpecies == 1)==FALSE & inform_parent1==0){
      cat("parental species 1 died \n")
      inform_parent1 <- 1   
    }
    if(length(aliveSpecies) > 5){
      if(any(aliveSpecies == 2)==FALSE &  inform_parent2==0){
        cat("parental species 2 died \n")
        inform_parent2 <- 1
        
      }
    }
    
    ##
    if(survival_crown_lineages == TRUE){
      if(any(aliveSpecies == 1)==FALSE){
        cat("parental species 1 died \n")
        break  
      }
      if(length(aliveSpecies) > 5){
        if(any(aliveSpecies == 2)==FALSE){
          cat("parental species 2 died \n")
          break  
        }
      }
    }
    
    
    d <- richness_matriz(species,map_col,map_row,the_map,aliveSpecies)
    
    # to select a species
    if(length(aliveSpecies) == 1){ # because sample () misbehaves when length(x)=1
      chosenSpecies <- aliveSpecies
    } else { # NOTE the differential prob of being sampled given the range size
      chosenSpecies <- sample(aliveSpecies,1,prob = rangeSize[,2])
    }
    inic1 <- species[[chosenSpecies ]] # WHich species will enter to the scene?
    
    # events taking place
    if(event==1){
      specia <- happening_speciation(L,
                                     k, 
                                     timeStep,
                                     inic1,
                                     species,
                                     aliveSpecies,
                                     chosenSpecies)
      L <- specia$L
      aliveSpecies <- specia$aliveSpecies
      species <- specia$species
    }
    if(event==2){
      contrac <- happening_contraction(inic1,
                                       numExtirp,species,
                                       chosenSpecies,
                                       aliveSpecies,
                                       L,
                                       timeStep)
      species <- contrac$species
      L <- contrac$L
      aliveSpecies <- contrac$aliveSpecies
    } 
    if (event==3){ 
      species <- happening_expansion(the_map,
                                     k,
                                     d,
                                     chosenSpecies,
                                     inic1,
                                     species)
    }
    # measure the range size of all species after the previous event
    # this can be optimized by only adding or substracting 1 to focal species. Or not...
    rangeSize <- matrix(NA,nrow = length(aliveSpecies), ncol = 2) 
    if(any(aliveSpecies != 0)){
      for(iii in 1:nrow(rangeSize)){
        rangeSize [iii,2] <- nrow(species[[aliveSpecies[iii]]])
        rangeSize [iii,1] <- aliveSpecies[iii]
      }
    }
    cycl <- cycl + 1 
  }
  
  end<-Sys.time()
  timeTakenForSimulation <- end-start
  
  return(list(cycl=cycl,L=L,species=species,
              rangeSize=rangeSize,timeStep=timeStep,
              timeTakenForSimulation=timeTakenForSimulation,
              total_saturation_overtime=total_saturation_overtime,
              mean_range_overtime=mean_range_overtime,
              upper_range_overtime=upper_range_overtime,
              skew_range_overtime=skew_range_overtime,
              variance_range_overtime=variance_range_overtime,
              betaSIM_overtime=betaSIM_overtime,
              betaSNE_overtime=betaSNE_overtime,
              beta_overtime=beta_overtime,
              deltaR_overtime=deltaR_overtime,
              alive_species_overtime =alive_species_overtime,
              sackinInd_overtime=sackinInd_overtime,
              per_lineage_lambda_overtime=per_lineage_lambda_overtime,
              per_lineage_mu_overtime=per_lineage_mu_overtime,
              oldest_lineage_age_overtime=oldest_lineage_age_overtime,
              mean_lineage_age_overtime=mean_lineage_age_overtime,
              mean_phylo_age_overtime=mean_phylo_age_overtime,
              oldest_phylo_age_overtime= oldest_phylo_age_overtime,
              max_branch_overtime = max_branch_overtime,
              mean_branch_overtime = mean_branch_overtime,
              blom_K_overtime = blom_K_overtime,
              meanPSC_overtime = meanPSC_overtime,
              betaSOR_overtime = betaSOR_overtime,
              meanPSV_overtime = meanPSV_overtime,
              timeslices=timeslices
  ))
}

