place_Eve <- function(map_col,
                      map_row,
                      the_map){
  non_suitable <- TRUE
  while(non_suitable == TRUE){
    prima <- matrix(0,1,2)
    prima[1,1] <- sample(1:map_row,1,replace=F)
    prima[1,2] <- sample(1:map_col,1,replace=F)
    non_suitable <- the_map[prima[1],prima[2]] == -9
  }
    # 
    # prima <- matrix(0,1,2)
    # prima[1,1] <- map_row/2
    # prima[1,2] <- map_col/2
  return(list(prima = prima))
}

richness_matriz <- function(species,
                            map_col,
                            map_row,
                            the_map,
                            aliveSpecies){
  d <- the_map
  for(a in 1:length(aliveSpecies)){  ## to build the richness matrix, 1's =presenc
    toGrid <- species[[aliveSpecies[a]]]
    presen <- the_map
    for (aa in 1:nrow(toGrid)){
      presen[toGrid[aa,][1],toGrid[aa,][2]] <- 1
    }
    d <- d + presen
  }
  d[which(d < 0)] <- -9
  return(d)  
}

happening_expansion <- function(the_map,
                                k,
                                d,
                                chosenSpecies,
                                inic1,
                                species){
  focal_distr <- the_map
  focal_distr[which(focal_distr == 0 )] <- 1 
  toGrid <- inic1
  for (ii in 1:nrow(toGrid)){ # I put a 0 for presence 
    focal_distr[toGrid[ii,][1],toGrid[ii,][2]] <- 0
  }
  periphery <- ifelse(neighbours(focal_distr,state=1)!= 0 & focal_distr == 0,0,1)
  avoidBorder <- ifelse(periphery == 1,0,9)# the function misbehaves at the border 
  outerRing <- ifelse(neighbours(avoidBorder,state=9) & focal_distr!= 0,0,1 )
  availToExpand <- ifelse(outerRing == 0 & d < k,0,1) #diversity dependence
  availToExpand [which(focal_distr == -9)] <- 1# with the -9 from real maps
  availToExpand <- which(availToExpand == 0, arr.ind = T)
  coloniz <- availToExpand [sample(nrow(availToExpand),1),,drop = F]
  newRangeExpan <- rbind(inic1,coloniz)
  species[[chosenSpecies]] <- newRangeExpan
  return(species)
}

happening_contraction <- function(inic1,
                                  numExtirp,
                                  species,
                                  chosenSpecies,
                                  aliveSpecies,
                                  L,
                                  timeStep){
  
  numExtirp <- 1
  if(nrow(inic1) == 1 & length(aliveSpecies) == 1){ # global catastrophe
    cat("the last population of the last/only species, died \n")
    species[[chosenSpecies]] <-"RIP"
    L[L[,1] == chosenSpecies,4] <- timeStep
    aliveSpecies <- 0
  } else {  
    if(nrow(inic1) == 1){ # extinction???
      species[[chosenSpecies]] <- "RIP"
      aliveSpecies <- aliveSpecies[-which(aliveSpecies == chosenSpecies),drop = F]
      L[L[,1] == chosenSpecies,4] <- timeStep
    } else {
      extirp <- inic1[sample(nrow(inic1),numExtirp),]
      newRangeContrac <- inic1[-which(inic1[,1]== extirp[1] & inic1[,2] == extirp[2]),,drop = FALSE]
      species[[chosenSpecies]] <- newRangeContrac
    } 
  }
  return(list(species=species,L=L,aliveSpecies=aliveSpecies))
}

happening_speciation <- function (L,
                                  k,
                                  timeStep,
                                  inic1,
                                  species,
                                  aliveSpecies,
                                  chosenSpecies){
  
  if(nrow(inic1) == 1){ ##extinction because the parental species dies giving birth
    aliveSpecies <- aliveSpecies[-which(aliveSpecies == chosenSpecies)]
    L <- rbind(L,matrix(c(length(species) + 1,timeStep,chosenSpecies,0),ncol = 4))
    L[L[,1] == chosenSpecies,4] <- timeStep
    newBorn <- inic1      
    species[[length(species) + 1]] <- newBorn
    species[[chosenSpecies]] <- "RIP"
    aliveSpecies <- c(aliveSpecies,length(species))
  } else {
    aliveSpecies <- c(aliveSpecies,length(species) + 1)
    L <- rbind(L, matrix(c(length(species) + 1,timeStep,chosenSpecies,0),ncol=4))
    newBorn <- inic1[sample(nrow(inic1),1),,drop=FALSE]
    species[[chosenSpecies]]<- inic1[-which(inic1[,1] == newBorn[1] & inic1[,2] == newBorn[2]),
                                     ,drop = FALSE]
    species[[length(species) + 1]] <- newBorn
  }
  return(list(L=L,species=species,aliveSpecies=aliveSpecies))
}

adjust_map_shift <- function(species,
                             map2,
                             aliveSpecies,
                             L,
                             shift_time){
  the_map <- map2
  aliveSpecies_surviving_geology <- NULL
  species_surviving_geology <- NULL
  # I need to see what populations survive after map 2 starts. Some species will have
  # range reduction but other might die altogether
  for(a in 1:length(aliveSpecies)){  
    focal_species <- aliveSpecies[a]
    toGrid <- species[[focal_species]]
    new_distribution_species <- NULL
    count_cell_surviving_cells <- 0
    for (ii in 1:nrow(toGrid)){ # to check what populations of the focal specie survive
      if(the_map[toGrid[ii,][1],toGrid[ii,][2]] == 0){
        new_distribution<- matrix(0,1,2)
        new_distribution [1,1] <- toGrid[ii,1]
        new_distribution [1,2] <- toGrid[ii,2]
        count_cell_surviving_cells <- count_cell_surviving_cells + 1
        new_distribution_species <- rbind(new_distribution_species,new_distribution)
      } 
    }
    if( count_cell_surviving_cells == 0){ # all the populations of the species disappear?
      species[[focal_species]] <- "RIP due to geology"  
      cat("RIP due to geology \n")
      L[L[,1] == focal_species,4] <- shift_time
    } else {
      aliveSpecies_surviving_geology <- c(aliveSpecies_surviving_geology,focal_species)
      species[[focal_species]] <- new_distribution_species
    }
  }
  return(list(the_map=the_map,species=species,aliveSpecies_surviving_geology=aliveSpecies_surviving_geology,L=L))
}
