do_things <- function(i){
  library(simecol)
  library(vegan)
  library(apTreeshape)
  library(picante)
  library(DDD)
  library(geiger)
  library(moments)
  library(phytools)
  library(betapart)
  
  map_medium <- as.matrix(read.delim("map_medium.txt",header = FALSE))
  source("mini_maps.R")
  source("simulation_main.R")
  source("simulation_functions.R")
  source("output_functions.R")
  source("merging_functions.R")
  source("splitting_functions.R")
  source("land_split_main.R")
  source("land_merge_main.R")
  source("land_mergesplit_main.R")
 # source("post.R")
  
  
  scenario_to_run <- "merge" #  "mergesplit" merge"  "split" "solid"
  all_k <- c(rep(2,9),rep(5,9),rep(8,9))
  all_lambda <- rep(c(0.001,0.001,0.001,0.01,0.01,0.01,0.05,0.05,0.05),3)
  all_mu <- rep(c(1,0.5,0.2),9)
  all_gamma <- rep(2,27)
  
  time_first_land_merge <- 10
  time_land_split  <- 20
  time_second_land_merge <- 30 # this is the parameter when there is only one merging event
  time_total_simulation <- 70
  
  #maps <- list(mini_map2,mini_map1)
  maps <- list(map_medium,map_medium)
  join_point <- "east"
  num_time_slices <- 100
  
  forced_crown_age <- FALSE # Either false or a number
  cycles <- 1E15
  survival_crown_lineages <- FALSE
  plotting <- FALSE
  
  
  cat("running the scenario:",scenario_to_run, "\n")
  time_start <-Sys.time()
  if(length(all_k)!=length(all_lambda) && length(all_mu)!=length(all_gamma)&& length(all_lambda)!=length(all_gamma)){
    stop("you need to provide the same number of ks, mus, lambdas and gammas")
  }
  for(ii in 1: length(all_k)){
    
    
    k <- all_k[ii]
    lambda <- all_lambda[ii]
    mu <- all_mu[ii]
    gamma <- all_gamma[ii]
    
    if(scenario_to_run == "mergesplit"){
      mergesplit <- do_simulation_mergesplit(k, 
                                             lambda, 
                                             mu, 
                                             gamma, 
                                             time_first_land_merge,
                                             time_land_split,  
                                             time_second_land_merge, 
                                             time_total_simulation,
                                             maps,
                                             join_point, 
                                             num_time_slices, 
                                             forced_crown_age,  
                                             cycles, 
                                             survival_crown_lineages )
    }
    
    if(scenario_to_run == "split"){
      split <- do_simulation_split (k, lambda, mu,
                                    gamma,
                                    set_simulated_time = time_total_simulation ,
                                    map_merging_time = time_land_split,
                                    maps,
                                    join_point,
                                    num_time_slices,
                                    forced_crown_age,
                                    cycles,
                                    survival_crown_lineages)
    }
    
    if(scenario_to_run == "merge"){
      merge <- do_simulation_merge(k,
                                   lambda,
                                   mu,
                                   gamma,
                                   set_simulated_time = time_total_simulation,
                                   map_merging_time = time_second_land_merge,
                                   maps,
                                   join_point,
                                   num_time_slices,
                                   forced_crown_age,
                                   cycles,
                                   survival_crown_lineages)
    }
    
    
    ####  simulation of the land with a fixed area
    if(scenario_to_run == "solid"){
      cat("your parameters: k",k,"lambda", lambda,"mu",mu,"gamma",gamma,"\n")
      merged_maps <- merge_maps(maps[[1]],maps[[2]],join_point)
      the_map <- merged_maps$new_map
      sucess <- FALSE
      while(sucess == FALSE){
        simulation_whole <- simulate_process(k,
                                             cycles,
                                             lambda,
                                             mu,
                                             gamma,
                                             survival_crown_lineages,
                                             set_simulated_time = time_total_simulation,
                                             the_map,
                                             map_merging_time = time_second_land_merge,
                                             num_time_slices,
                                             forced_crown_age,
                                             starting_from_eve = "yes")
        sucess <- any(simulation_whole$L[,4]==0)
      }
      
    }
    time_end <-Sys.time()
    cat("simulation took:",time_end-time_start)
    
    if(plotting == TRUE){
      do_plottin()
    }

    
    ####
    if(scenario_to_run == "mergesplit"){
      saveRDS(mergesplit,file=paste0("pars_",ii,"_",scenario_to_run,"_replicate_",i,".RDS"))
    }
    if(scenario_to_run == "split"){
      saveRDS(split,file=paste0("pars_",ii,"_",scenario_to_run,"_replicate_",i,".RDS"))
    }
    if(scenario_to_run == "merge"){
      saveRDS(merge,file=paste0("pars_",ii,"_",scenario_to_run,"_replicate_",i,".RDS"))
    }
    if(scenario_to_run == "solid"){
      saveRDS(simulation_whole,file=paste0("pars_",ii,"_",scenario_to_run,"_replicate_",i,".RDS"))
    }
    
  }
  
}

