
total_simulations <- 20
figure_numb <- 4
pars <- 1
my_ylim <- c(-4,10)


for(i in 1:total_simulations){
  if(i == 1){
    launch_plot <- TRUE  
  } else {
    launch_plot <- FALSE
  }
  the_plots <- do_plotting(figure_numb,
                           scenario_to_run,
                           time_first_land_merge,
                           time_land_split,
                           time_second_land_merge, # this is the parameter when there is only one merging event
                           time_total_simulation,
                           pars,
                           num_time_slices,
                           launch_plot,
                           my_ylim)
}



do_plotting <- function(figure_numb,
                        scenario_to_run,
                        time_first_land_merge,
                        time_land_split,
                        time_second_land_merge, # this is the parameter when there is only one merging event
                        time_total_simulation,
                        pars,
                        num_time_slices,
                        launch_plot,
                        my_ylim = NULL){
  ii <- pars
  
  
  if(scenario_to_run == "merge"){
    merge <- readRDS(file=paste0("pars_",ii,"_",scenario_to_run,"_replicate_",i,".RDS"))
    
    merge$simulation_merged$skew_range_overtime
    merge$simulation1$skew_range_overtime
    merge$simulation2$skew_range_overtime
    
    if(figure_numb != 4){
      Ltable_to_do <-  merge$simulation_merged$L  
      metrics_phylo_merged <- phylo_metrics_finalLtable(time_for_Ltable = time_total_simulation ,
                                                        num_time_slices,
                                                        Ltable_to_do,
                                                        forced_crown_age)
      
      Ltable_to_do <-  merge$simulation1$L  
      metrics_phylo_sim1 <- phylo_metrics_finalLtable(time_for_Ltable = time_second_land_merge ,
                                                      num_time_slices,
                                                      Ltable_to_do,
                                                      forced_crown_age)
      Ltable_to_do <-  merge$simulation2$L  
      metrics_phylo_sim2 <- phylo_metrics_finalLtable(time_for_Ltable = time_second_land_merge ,
                                                      num_time_slices,
                                                      Ltable_to_do,
                                                      forced_crown_age)
    }
    if(figure_numb == 1){
      if(launch_plot == TRUE){
        plot(metrics_phylo_merged$timeslices,metrics_phylo_merged$deltaR_overtime,
             xlim=c(0,time_total_simulation),ylim=my_ylim,
             xlab="time",main=paste0("diversification slowdown"),ylab="DeltaR",
             col = "darkgoldenrod1",pch = 19)
        
        launch_plot <- FALSE
      } else {
        points(metrics_phylo_merged$timeslices,metrics_phylo_merged$deltaR_overtime,
               xlim=c(0,time_total_simulation),ylim=c(-1,0),
               xlab="time",main=paste0("diversification slowdown"),ylab="DeltaR",
               col = "darkgoldenrod1",pch = 19)
      }
      
      
      points(metrics_phylo_sim1$timeslices,metrics_phylo_sim1$deltaR_overtime,
             xlim=c(0,time_second_land_merge),
             col = "firebrick1",pch = 19)
      
      points(metrics_phylo_sim2$timeslices,metrics_phylo_sim2$deltaR_overtime,
             xlim=c(0,time_second_land_merge),
             col = "darkgreen",pch = 19)
      abline(h = 0,lty = 20)
      abline(v = time_second_land_merge,lty = 20,col="blue")
    }
    
    #
    if(figure_numb == 2){
      if(launch_plot == TRUE){
        plot(metrics_phylo_merged$timeslices,metrics_phylo_merged$alive_species_overtime,
             xlim=c(0,time_total_simulation),ylim = my_ylim,
             xlab="time",main=paste0("Regional richness. Do not mind first part of yellow line"),ylab="No. Species",
             col = "darkgoldenrod1",pch = 19)
        launch_plot <- FALSE
      } else {
        points(metrics_phylo_merged$timeslices,metrics_phylo_merged$alive_species_overtime,
               xlab="time",main=paste0("Regional richness. Do not mind first part of yellow line"),ylab="No. Species",
               col = "darkgoldenrod1",pch = 19) 
      }
      points(metrics_phylo_sim1$timeslices,metrics_phylo_sim1$alive_species_overtime,
             xlim=c(0,time_second_land_merge),
             col = "firebrick1",pch = 19)
      
      points(metrics_phylo_sim2$timeslices,metrics_phylo_sim2$alive_species_overtime,
             xlim=c(0,time_second_land_merge),
             col = "darkgreen",pch = 19)
      
      abline(v = time_second_land_merge,lty = 20,col="blue")
    }
    #
    if(figure_numb == 3){
      if(launch_plot == TRUE){
        plot(metrics_phylo_merged$timeslices,metrics_phylo_merged$sackinInd_overtime,
             xlim=c(0,time_total_simulation),ylim = my_ylim,
             xlab="time",main=paste0("Shape of tree, imbalance"),ylab="sackin",
             col = "darkgoldenrod1",pch = 19)
        launch_plot <- FALSE
      } else {
        points(metrics_phylo_merged$timeslices,metrics_phylo_merged$sackinInd_overtime,
               xlim=c(0,time_total_simulation),ylim=c(-1,2),
               xlab="time",main=paste0("Shape of tree, imbalance"),ylab="sackin",
               col = "darkgoldenrod1",pch = 19)
      }
      
      points(metrics_phylo_sim1$timeslices,metrics_phylo_sim1$sackinInd_overtime,
             xlim=c(0,time_second_land_merge),
             col = "firebrick1",pch = 19)
      
      points(metrics_phylo_sim2$timeslices,metrics_phylo_sim2$sackinInd_overtime,
             xlim=c(0,time_second_land_merge),
             col = "darkgreen",pch = 19)
      abline(h = 0,lty = 20)
      abline(v = time_second_land_merge,lty = 20,col="blue")
    }
    #
    if(figure_numb == 4){
      if(launch_plot == TRUE){
        plot(merge$simulation_merged$timeslices,merge$simulation_merged$skew_range_overtime,
             xlim=c(0,time_total_simulation),ylim = my_ylim,
             xlab="time",main=paste0("range size"),ylab="Skewness",
             col = "darkgoldenrod1",pch = 19)
        
        launch_plot <- FALSE
      } else {
        points(merge$simulation_merged$timeslices,merge$simulation_merged$skew_range_overtime,
               xlim=c(0,time_total_simulation),
               col = "darkgoldenrod1",pch = 19)
      }
      
      points(merge$simulation1$timeslices,merge$simulation1$skew_range_overtime,
             xlim=c(0,time_total_simulation),
             col = "firebrick1",pch = 19)
      
      
      points(merge$simulation2$timeslices,merge$simulation2$skew_range_overtime,
             xlim=c(0,time_second_land_merge),
             col = "darkgreen",pch = 19)
      
      abline(v = time_second_land_merge,lty = 20,col="blue")
      abline(h = 0,lty = 20)
    }
    
  }
  
  if(scenario_to_run == "split"){
    split <- readRDS(file=paste0("pars_",ii,"_",scenario_to_run,"_replicate_",i,".RDS"))
    
    split$simulation_whole$timeslices
    split$simulation1$timeslices
    split$simulation1$alive_species_overtime
    split$simulation2$alive_species_overtime
    
    split$alive_species_overtime
    if(figure_numb != 4){
      Ltable_to_do <- split$LTable_complete
      metrics_phylo_asRegion <- phylo_metrics_finalLtable(time_for_Ltable = time_total_simulation ,
                                                          num_time_slices,
                                                          Ltable_to_do,
                                                          forced_crown_age)
      
      Ltable_to_do <-  split$simulation_whole$L  
      metrics_phylo_merged <- phylo_metrics_finalLtable(time_for_Ltable = time_land_split ,
                                                        num_time_slices,
                                                        Ltable_to_do,
                                                        forced_crown_age)
      
      Ltable_to_do <-  split$simulation1$L  
      metrics_phylo_sim1 <- phylo_metrics_finalLtable(time_for_Ltable = time_total_simulation ,
                                                      num_time_slices,
                                                      Ltable_to_do,
                                                      forced_crown_age)
      Ltable_to_do <-  split$simulation2$L  
      metrics_phylo_sim2 <- phylo_metrics_finalLtable(time_for_Ltable = time_total_simulation ,
                                                      num_time_slices,
                                                      Ltable_to_do,
                                                      forced_crown_age)
    }
    if(figure_numb == 1){
      if(launch_plot == TRUE){
        
        plot(metrics_phylo_asRegion$timeslices,metrics_phylo_asRegion$deltaR_overtime,
             xlim=c(0,time_total_simulation),ylim = my_ylim,
             xlab="time",main=paste0("diversification slowdown"),ylab="DeltaR",
             col = "darkgoldenrod1",pch = 19)
        launch_plot <- FALSE
      }  else {
        points(metrics_phylo_asRegion$timeslices,metrics_phylo_asRegion$deltaR_overtime,
               xlim=c(0,time_total_simulation),
               xlab="time",main=paste0("diversification slowdown"),ylab="DeltaR",
               col = "darkgoldenrod1",pch = 19)
        
      }  
      points(metrics_phylo_sim1$timeslices,metrics_phylo_sim1$deltaR_overtime,
             xlim=c(0,time_second_land_merge),
             col = "firebrick1",pch = 19)
      
      points(metrics_phylo_sim2$timeslices,metrics_phylo_sim2$deltaR_overtime,
             xlim=c(0,time_second_land_merge),
             col = "darkgreen",pch = 19)
      points(metrics_phylo_merged$timeslices,metrics_phylo_merged$deltaR_overtime,
             xlim=c(0,time_total_simulation),
             col = "darkgoldenrod1",pch = 19) 
      abline(h = 0,lty = 20)
      abline(v = time_land_split,lty = 20,col="black")
    }
    #
    if(figure_numb == 2){
      if(launch_plot == TRUE){
        plot(metrics_phylo_asRegion$timeslices,metrics_phylo_asRegion$alive_species_overtime,
             xlim=c(0,time_total_simulation),ylim = my_ylim,
             xlab="time",main=paste0("Regional richness"),ylab="No. Species",
             col = "darkgoldenrod1",pch = 19)
        launch_plot <- FALSE
      } else {
        points(metrics_phylo_asRegion$timeslices,metrics_phylo_asRegion$alive_species_overtime,
               xlim=c(0,time_total_simulation),
               xlab="time",main=paste0("Regional richness"),ylab="No. Species",
               col = "darkgoldenrod1",pch = 19)  
      }
      points(metrics_phylo_sim1$timeslices,metrics_phylo_sim1$alive_species_overtime,
             xlim=c(0,time_second_land_merge),
             col = "firebrick1",pch = 19)
      points(metrics_phylo_sim2$timeslices,metrics_phylo_sim2$alive_species_overtime,
             xlim=c(0,time_second_land_merge),
             col = "darkgreen",pch = 19)
      points(metrics_phylo_merged$timeslices,metrics_phylo_merged$alive_species_overtime,
             xlim=c(0,time_total_simulation),
             col = "darkgoldenrod1",pch = 19) 
      abline(v = time_land_split,lty = 20,col="black")
    }
    #
    if(figure_numb == 3){
      if(launch_plot == TRUE){
        plot(metrics_phylo_asRegion$timeslices,metrics_phylo_asRegion$sackinInd_overtime,
             xlim=c(0,time_total_simulation),ylim = my_ylim,
             xlab="time",main=paste0("Shape of tree, imbalance"),ylab="sackin",
             col = "darkgoldenrod1",pch = 19)
        launch_plot <- FALSE  
      } else {
        points(metrics_phylo_asRegion$timeslices,metrics_phylo_asRegion$sackinInd_overtime,
               xlim=c(0,time_total_simulation),
               xlab="time",main=paste0("Shape of tree, imbalance"),ylab="sackin",
               col = "darkgoldenrod1",pch = 19)
        
      }
      points(metrics_phylo_sim1$timeslices,metrics_phylo_sim1$sackinInd_overtime,
             xlim=c(0,time_second_land_merge),
             col = "firebrick1",pch = 19)
      
      points(metrics_phylo_sim2$timeslices,metrics_phylo_sim2$sackinInd_overtime,
             xlim=c(0,time_second_land_merge),
             col = "darkgreen",pch = 19)
      points(metrics_phylo_merged$timeslices,metrics_phylo_merged$sackinInd_overtime,
             xlim=c(0,time_total_simulation),
             col = "darkgoldenrod1",pch = 19)
      abline(h = 0,lty = 20)
      abline(v = time_land_split,lty = 20,col="black")
    }
    #
    if(figure_numb == 4){
      if(launch_plot == TRUE){
        plot(split$simulation_whole$timeslices,split$simulation_whole$skew_range_overtime,
             xlim=c(0,time_total_simulation),ylim = my_ylim,
             xlab="time",main=paste0("range size"),ylab="Skewness",
             col = "darkgoldenrod1",pch = 19)
        
        launch_plot <- FALSE
      } else {
        points(split$simulation_whole$timeslices,split$simulation_whole$skew_range_overtime,
               xlim=c(0,time_total_simulation),
               col = "darkgoldenrod1",pch = 19)
      }
      
      points(split$simulation1$timeslices,split$simulation1$skew_range_overtime,
             xlim=c(0,time_total_simulation),
             col = "firebrick1",pch = 19)
      
      
      points(split$simulation2$timeslices,split$simulation2$skew_range_overtime,
             xlim=c(0,time_second_land_merge),
             col = "darkgreen",pch = 19)
      
      abline(v = time_land_split,lty = 20,col="blue")
      abline(h = 0,lty = 20)
    }
  }
  
  if(scenario_to_run == "mergesplit"){
    
    mergesplit <- readRDS(file=paste0("pars_",ii,"_",scenario_to_run,"_replicate_",i,".RDS"))
    
    if(figure_numb != 4){
      Ltable_to_do <- mergesplit$simulation_current_land$L
      metrics_phylo_asRegion <- phylo_metrics_finalLtable(time_for_Ltable = time_total_simulation ,
                                                          num_time_slices,
                                                          Ltable_to_do,
                                                          forced_crown_age)
    }
    if(figure_numb == 1){
      if(launch_plot == TRUE){
        plot(metrics_phylo_asRegion$timeslices,metrics_phylo_asRegion$deltaR_overtime,
             xlim=c(0,time_total_simulation),ylim = my_ylim,
             xlab="time",main=paste0("diversification slowdown"),ylab="DeltaR",
             col = "darkgoldenrod1",pch = 19)
        launch_plot <- FALSE
      } else {
        points(metrics_phylo_asRegion$timeslices,metrics_phylo_asRegion$deltaR_overtime,
               xlim=c(0,time_total_simulation),
               xlab="time",main=paste0("diversification slowdown"),ylab="DeltaR",
               col = "darkgoldenrod1",pch = 19)
        
      }
      abline(h = 0,lty = 20)
      abline(v = time_first_land_merge,lty = 20,col="blue")
      abline(v = time_land_split,lty = 20,col="black")
      abline(v = time_second_land_merge,lty = 20,col="blue")
    }
    #
    if(figure_numb == 2){
      if(launch_plot == TRUE){
        plot(metrics_phylo_asRegion$timeslices,metrics_phylo_asRegion$alive_species_overtime,
             xlim=c(0,time_total_simulation),ylim = my_ylim,
             xlab="time",main=paste0("Regional richness"),ylab="No. Species",
             col = "darkgoldenrod1",pch = 19)
      } else {
        points(metrics_phylo_asRegion$timeslices,metrics_phylo_asRegion$alive_species_overtime,
               xlim=c(0,time_total_simulation),
               xlab="time",main=paste0("Regional richness"),ylab="No. Species",
               col = "darkgoldenrod1",pch = 19)
      }
      abline(v = time_first_land_merge,lty = 20,col="blue")
      abline(v = time_land_split,lty = 20,col="black")
      abline(v = time_second_land_merge,lty = 20,col="blue")
    }
    #
    if(figure_numb == 3){
      if(launch_plot == TRUE){
        plot(metrics_phylo_asRegion$timeslices,metrics_phylo_asRegion$sackinInd_overtime,
             xlim=c(0,time_total_simulation),ylim = my_ylim,
             xlab="time",main=paste0("Shape of tree, imbalance"),ylab="sackin",
             col = "darkgoldenrod1",pch = 19)
      } else {
        points(metrics_phylo_asRegion$timeslices,metrics_phylo_asRegion$sackinInd_overtime,
               xlim=c(0,time_total_simulation),
               xlab="time",main=paste0("Shape of tree, imbalance"),ylab="sackin",
               col = "darkgoldenrod1",pch = 19)  
      }
      abline(h = 0,lty = 20)
      abline(v = time_first_land_merge,lty = 20,col="blue")
      abline(v = time_land_split,lty = 20,col="black")
      abline(v = time_second_land_merge,lty = 20,col="blue")
    }
    #
    if(figure_numb == 4){
      if(launch_plot == TRUE){
        plot(mergesplit$simulation_current_land$timeslices,mergesplit$simulation_current_land$skew_range_overtime,
             xlim=c(0,time_total_simulation),ylim = my_ylim,
             xlab="time",main=paste0("range size"),ylab="Skewness",
             col = "darkgoldenrod1",pch = 19)
        
        launch_plot <- FALSE
      } else {
        points(mergesplit$simulation_current_land$timeslices,mergesplit$simulation_current_land$skew_range_overtime,
             xlim=c(0,time_total_simulation),
             col = "darkgoldenrod1",pch = 19)
      }
      abline(v = time_first_land_merge,lty = 20,col="blue")
      abline(v = time_land_split,lty = 20,col="black")
      abline(v = time_second_land_merge,lty = 20,col="blue")
      abline(h = 0,lty = 20)
    }
    #
  }
  
  if(scenario_to_run == "solid"){
    simulation_whole <- readRDS(file=paste0("pars_",ii,"_",scenario_to_run,"_replicate_",i,".RDS"))
    
    simulation_whole$alive_species_overtime
    if(figure_numb != 4){
      Ltable_to_do <- simulation_whole$L
      metrics_phylo_asRegion <- phylo_metrics_finalLtable(time_for_Ltable = time_total_simulation ,
                                                          num_time_slices,
                                                          Ltable_to_do,
                                                          forced_crown_age)
    }
    if(figure_numb == 1){
      if(launch_plot == TRUE){
        plot(metrics_phylo_asRegion$timeslices,metrics_phylo_asRegion$deltaR_overtime,
             xlim=c(0,time_total_simulation),ylim = my_ylim,
             xlab="time",main=paste0("diversification slowdown"),ylab="DeltaR",
             col = "darkgoldenrod1",pch = 19)
      } else {
        points(metrics_phylo_asRegion$timeslices,metrics_phylo_asRegion$deltaR_overtime,
               xlim=c(0,time_total_simulation),
               xlab="time",main=paste0("diversification slowdown"),ylab="DeltaR",
               col = "darkgoldenrod1",pch = 19)
      }
      abline(h = 0,lty = 20)
    }
    #
    if(figure_numb == 2){
      if(launch_plot == TRUE){
        
        plot(metrics_phylo_asRegion$timeslices,metrics_phylo_asRegion$alive_species_overtime,
             xlim=c(0,time_total_simulation),ylim = my_ylim,
             xlab="time",main=paste0("Regional richness"),ylab="No. Species",
             col = "darkgoldenrod1",pch = 19)
      } else {
        
        points(metrics_phylo_asRegion$timeslices,metrics_phylo_asRegion$alive_species_overtime,
               xlim=c(0,time_total_simulation),
               xlab="time",main=paste0("Regional richness"),ylab="No. Species",
               col = "darkgoldenrod1",pch = 19) 
      }
      # points(simulation_whole$timeslices,simulation_whole$alive_species_overtime,
      #      xlim=c(0,time_total_simulation),
      #      col = "blue",pch = 19)
      #
    }
    if(figure_numb == 3){
      if(launch_plot == TRUE){
        plot(metrics_phylo_asRegion$timeslices,metrics_phylo_asRegion$sackinInd_overtime,
             xlim=c(0,time_total_simulation),ylim = my_ylim,
             xlab="time",main=paste0("Shape of tree, imbalance"),ylab="sackin",
             col = "darkgoldenrod1",pch = 19)
      } else {
        points(metrics_phylo_asRegion$timeslices,metrics_phylo_asRegion$sackinInd_overtime,
               xlim=c(0,time_total_simulation),
               xlab="time",main=paste0("Shape of tree, imbalance"),ylab="sackin",
               col = "darkgoldenrod1",pch = 19)
      }
      abline(h = 0,lty = 20)
      
    }
    #
    if(figure_numb == 4){
      if(launch_plot == TRUE){
        plot(simulation_whole$timeslices,simulation_whole$skew_range_overtime,
             xlim=c(0,time_total_simulation),ylim = my_ylim,
             xlab="time",main=paste0("range size"),ylab="Skewness",
             col = "darkgoldenrod1",pch = 19)
        
        launch_plot <- FALSE
      } else {
        points(simulation_whole$timeslices,simulation_whole$skew_range_overtime,
             xlim=c(0,time_total_simulation),
             col = "darkgoldenrod1",pch = 19)
      }
      abline(h = 0,lty = 20)
    }
  }
}
