phylo_metrics_finalLtable <- function(time_for_Ltable,
                                      num_time_slices,
                                      Ltable_to_do,
                                      forced_crown_age){

sackinInd_overtime <- NULL
deltaR_overtime <- NULL
alive_species_overtime <- NULL

time_to_divide <- seq(0,time_for_Ltable,by = time_for_Ltable/num_time_slices )[-1]
for(i in 1:length(time_to_divide)){
  sackinInd <- NA
  deltaR <- NA
  
  #row_counting <- 1
  #time_one_row <- 0
  #while(time_one_row <= time_to_divide[i] ){
  #row_counting <- row_counting + 1
  
  row_counting <-  which(Ltable_to_do[,2] <= time_to_divide[i])
  # time_one_row <- LTable_complete [row_counting,2]    
  #}
  LTable <- Ltable_to_do[row_counting,]
  
  if(class(LTable)=="matrix"){
    # Check whether any death did not happen within the time frame
    if(any(LTable[,4] > time_to_divide[i]) == TRUE){
      LTable[which(LTable[,4] > time_to_divide[i]),4] <- 0 # as was alive withiin time frame
    }       
    alive_species_overtime <- c(alive_species_overtime,length(which(LTable[,4] == 0)))       
    
    if(length(which(LTable[,4] == 0)) > 5 ){ # Tree of okish size at least
      
      L <- LTable
      
      age <- time_to_divide[i]
      # age <- max(c(LTable[,1],LTable[,4]))
      tableConver <- L
      tableConver[tableConver[,4]==0,4] <- -1 # to go with Rampal's notation
      LTable <- matrix(c(tableConver[,2],tableConver[,3],tableConver[,1],tableConver[,4]),ncol=4)
      #age <- max(c(LTable[,1],LTable[,4]))
      LTable[,1] <- age - c(LTable[,1])
      notmin1 <- which(LTable[,4] != -1)
      LTable[notmin1,4] <- age - c(LTable[notmin1,4])
      LTable[which(LTable[,4] == age + 1),4] <- -1
      phyloTree <- L2phylo(LTable[,1:4],dropextinct = T)
      if(forced_crown_age != FALSE){
        phyloTree <- rescaleTree(phyloTree,forced_crown_age) # Rescalete tree
      }  
      
      forBalanceCalcu <- as.treeshape(phyloTree)
      sackinInd <- sackin(forBalanceCalcu,norm="yule")
      crown_age <- max(ape::branching.times(phyloTree))
      ar<-phyloTree # for deltaR
      tro<-ltt.plot.coords(ar)
      tro[,1]<-round(tro[,1],digits = 6)
      halfWay<-trunc(crown_age/2) ##
      tips<-as.numeric(tro[nrow(tro),2]) ##
      linaHalf<-max(tro[which(abs(tro[,1])>=halfWay),2]) #
      r1<-(log(linaHalf))-(log(1))
      r2<-(log(tips))-(log(linaHalf))
      deltaR <- (r2-r1)/(r1+r2)
    } 
    
    
  } else{
    alive_species_overtime <- c(alive_species_overtime, 1)
    
  }
  
  sackinInd_overtime <- c(sackinInd_overtime,sackinInd)
  deltaR_overtime <-c(deltaR_overtime,deltaR)
}
return(list(sackinInd_overtime=sackinInd_overtime,
            deltaR_overtime=deltaR_overtime,
            alive_species_overtime=alive_species_overtime,
            timeslices=time_to_divide))
}

divfield_pams <- function(pam_obs){
  
  sppnames<-colnames(pam_obs)
  spp_divfields <- matrix(NA,nrow=ncol(pam_obs),ncol=3)
  rownames(spp_divfields) <- sppnames
  colnames(spp_divfields) <- c("RangeSize","TotalRich", "MeanRich")
  
  RangeSize<- as.matrix(colSums(pam_obs))
  SpeciesRichness<- as.matrix(rowSums(pam_obs))
  D_Volume<- t(pam_obs)%*%SpeciesRichness
  RangeRichness<- D_Volume/RangeSize
  
  for (i in 1:ncol(pam_obs)){
    
    sp_sites <- which(pam_obs[,i]==1)
    
    if(length(sp_sites)>1){
      
      sp_pam <- pam_obs[sp_sites,which(colSums(pam_obs[sp_sites,])!=0)]
      
    } else {sp_pam <- pam_obs[sp_sites,which(pam_obs[sp_sites,]!=0)]
    }
    
    if(is.null(colnames(sp_pam)) & is.null(names(sp_pam))){
      
      spp_divfields[i,1] <- RangeSize[i]
      spp_divfields[i,2] <- 1
      spp_divfields[i,3] <- RangeRichness[i]
      i<-i+1
      
    }	else {
      
      spp_divfields[i,1] <- RangeSize[i]
      
      if(is.null(dim(sp_pam))){
        spp_divfields[i,2] <- length(sp_pam)
      }else{spp_divfields[i,2] <- ncol(sp_pam)}
      
      spp_divfields[i,3] <- RangeRichness[i]
      
      #write.table(sp_pam, paste(sppnames[i],'.txt', sep=""), sep="\t")
    }
  }
  return(spp_divfields)
}

phylodivfield_pams <- function(pam_obs,tree){
  sppnames<-colnames(pam_obs)
  phylo_fields <- matrix(0,nrow=length(sppnames), ncol=4)
  colnames(phylo_fields) <- c("PSV","PSC","SppRichness","mean_richness")
  rownames(phylo_fields) <- sppnames
  for (i in 1:ncol(pam_obs)){
    sp_sites <- which(pam_obs[,i]==1)
    if(length(sp_sites)>1){
      sp_pam <- pam_obs[sp_sites,which(colSums(pam_obs[sp_sites,])!=0)]
    } else {
      sp_pam <- pam_obs[sp_sites,which(pam_obs[sp_sites,]!=0)]
    }
    
    if(class(sp_pam)!="numeric"){
      living_with_focal <- names(which(colSums(sp_pam)!=0))
      
    } else{
      living_with_focal <-names(sp_pam)
    }
    subset_pam <- matrix(0,ncol=length(sppnames), nrow=2)
    colnames(subset_pam) <- sppnames
    
    for(ii in 1:length(living_with_focal)){
      position_subset_pam <- which(living_with_focal[ii] == sppnames)
      subset_pam[1,position_subset_pam] <- 1
      subset_pam[2,position_subset_pam] <- 1
      
    }
    phylo_fields[i,1] <- psv(subset_pam,tree)[1,1]
    phylo_fields[i,2] <- psc(subset_pam,tree)[1,1]
    phylo_fields[i,3] <- length(living_with_focal)
    
    if(class(sp_pam)=="numeric"){
      phylo_fields[i,4] <- length(living_with_focal)/ 1 # divided by the range size
    } else {
      phylo_fields[i,4] <- length(living_with_focal)/nrow(sp_pam) # divided by the range size
    }
  }
  return(phylo_fields)
}



treeANDLtable<- function(L,timeStep,forced_crown_age){
  age <- timeStep
  # age <- max(c(LTable[,1],LTable[,4]))
  tableConver <- L
  tableConver[tableConver[,4]==0,4] <- -1 # to go with Rampal's notation
  LTable <- matrix(c(tableConver[,2],tableConver[,3],tableConver[,1],tableConver[,4]),ncol=4)
  #age <- max(c(LTable[,1],LTable[,4]))
  LTable[,1] <- age - c(LTable[,1])
  notmin1 <- which(LTable[,4] != -1)
  LTable[notmin1,4] <- age - c(LTable[notmin1,4])
  LTable[which(LTable[,4] == age + 1),4] <- -1
  phyloTree <- L2phylo(LTable[,1:4],dropextinct = T)
  if(forced_crown_age != FALSE){
  phyloTree <- rescaleTree(phyloTree,forced_crown_age) # Rescalete tree
  }
  #plot(phyloTree,main=round(timeStep,1))
  return(list(LTable=LTable,phyloTree=phyloTree))
}

rescaleTree<-function(tree,scale){ # Revell's function
  tree$edge.length<-
    tree$edge.length/max(nodeHeights(tree)[,2]) * scale
  return(tree)
}

phyloStructANDcommuMatriz <- function(map2,aliveSpecies,phyloTree,species_distribution){
  communities_available <- which(map2==0)
  communityMatrix <-matrix(0,ncol=length(aliveSpecies),nrow=length(communities_available)  )
  rownames(communityMatrix) <-communities_available
  for( ii in 1:length(aliveSpecies)){ # to place 0's or 1's to build the presec-abs matrix  
    selected <- aliveSpecies[ii]
    selected <- species_distribution[[selected]]
    for (iii in 1:nrow(selected)){
      map2[selected[iii,1],selected[iii,2]] <- 99999
      communityMatrix[which(communities_available == (which(map2==99999))),ii] <- 1
      map2[selected[iii,1],selected[iii,2]] <- 0 # to make it as good as new
    }
  }
  
  # there is a problem with function sort() when working with species id of the shape "t33"  
  id_species_withT <- phyloTree$tip.label
  species_id_numbersOnly <- NULL
  for(i in 1:length(aliveSpecies)){
    
    all_species_id <- strsplit(id_species_withT,split="t")
    species_id_numbersOnly <- c(species_id_numbersOnly,as.numeric(all_species_id[[i]][2]))
  }
  species_id_new <- NULL
  for(i in 1:length(aliveSpecies)){
    species_id_new <- c(species_id_new, paste0("t",sort(species_id_numbersOnly)[i]))
  }
  
  colnames(communityMatrix) <- species_id_new
  # phyloSpeciesVariab <-  psv(communityMatrix,phyloTree)[,1]
  # betaSIM <- mean(phyloSpeciesVariab,na.rm = TRUE)
  # betaSNE <- var(phyloSpeciesVariab,na.rm = TRUE)
  # 
  # 
  phyloSpeciesVariab <-  psc(communityMatrix,phyloTree)[,1]
  meanPSV <- mean(psv(communityMatrix,phyloTree)[,1])
  meanPSC <- mean(phyloSpeciesVariab,na.rm = TRUE)
    # betaSOR <- var(phyloSpeciesVariab,na.rm = TRUE)
  
  
  phylo_beta <- phylo.beta.multi(communityMatrix, phyloTree, index.family="sor")
  betaSIM <- phylo_beta$phylo.beta.SIM
  betaSNE <- phylo_beta$phylo.beta.SNE
  betaSOR <- phylo_beta$phylo.beta.SOR
  
  return(list(betaSIM=betaSIM,communityMatrix=communityMatrix,
              betaSNE=betaSNE,meanPSC=meanPSC,meanPSV=meanPSV,betaSOR=betaSOR))
}




balance <- function(phyloTree){
  forBalanceCalcu <- as.treeshape(phyloTree)
  sackinIndex <- sackin(forBalanceCalcu,norm="yule")
  return(sackinIndex=sackinIndex)
}


distFocalSpe <- function(d,species,speciesToSee,timeStep,cycl){
  distrib <- which(d >= 0, arr.ind = T)
  distrib <- cbind(distrib,rep(0,nrow(distrib))) 
  for (aa in 1:nrow(species[[speciesToSee]])){ 
    distrib[which(distrib[,1]==species[[speciesToSee]][aa,1]
                  & distrib[,2]==species[[speciesToSee]][aa,2]),3] <- 1
  }
  distrib <- as.data.frame(distrib)
  colnames(distrib) <- c("x","y","presence")
  print(ggplot(distrib, aes(distrib$x,distrib$y))
        +geom_raster(aes(fill = distrib$presence))
        +xlab("x")+ylab("y")
        +ggtitle(paste("simulatedTime=",round(timeStep,3),
                       "distr of species labeled=",speciesToSee,"cicle=",cycl)))
  readline("Lets try, press the Enter key") 
}


diversityMap <- function(d,timeStep,cycl){
  #if (max(slice)!=floor(timeStep) && visuaFreqRichne !=0){
  #if( cycl %% visuaFreqRichne ==0 && visuaFreqRichne !=0){  
  richnes <- which( d>= 0, arr.ind = T)
  richnes <- as.data.frame(cbind(richnes,as.vector(d)))
  colnames(richnes) <- c("x","y","richness")
  print(ggplot(richnes, aes(richnes$x,richnes$y))
        +geom_raster(aes(fill = richnes$richness))
        +xlab("x")+ylab("y")
        +ggtitle(paste("simulatedTime=",round(timeStep,3),"cicle=",cycl))
  )
  
  readline("Lets try, press the Enter key")
}


compute_community_metrics_timeSlice <- function(L,timeStep,species,the_map,aliveSpecies,rangeSize,forced_crown_age){
  phy_stuff <- treeANDLtable(L,timeStep,forced_crown_age)
  phyloTree <- phy_stuff$phyloTree
  species_distribution <- species
  LTable <- phy_stuff$LTable
  community_analisis<-phyloStructANDcommuMatriz (the_map,aliveSpecies,phyloTree,species_distribution)
  communityMatrix_forBeta <-community_analisis$communityMatrix
  beta_matrix <- betadiver(communityMatrix_forBeta, "sor")
  crown_age <- max(ape::branching.times(phyloTree))
  
  ar<-phyloTree # for deltaR
  tro<-ltt.plot.coords(ar)
  tro[,1]<-round(tro[,1],digits = 6)
  halfWay<-trunc(crown_age/2) ##
  tips<-as.numeric(tro[nrow(tro),2]) ##
  linaHalf<-max(tro[which(abs(tro[,1])>=halfWay),2]) #
  r1<-(log(linaHalf))-(log(1))
  r2<-(log(tips))-(log(linaHalf))
  deltaR <- (r2-r1)/(r1+r2)
  
  forBalanceCalcu <- as.treeshape(phyloTree)
  #collessInd<-c(collessInd,colless(forBalanceCalcu))
  sackinInd <- sackin(forBalanceCalcu,norm="yule")
  invisible(capture.output(bd_estimates <-bd_ML(brts = ape::branching.times(phyloTree) )))
  
  per_lineage_lambda <-  bd_estimates$lambda0
  per_lineage_mu <-  bd_estimates$mu0
  betaSIM <- community_analisis$betaSIM
  beta <- mean(beta_matrix,na.rm = TRUE)
  betaSNE <- community_analisis$betaSNE
  
  meanPSC <- community_analisis$meanPSC
  meanPSV <- community_analisis$meanPSV
  betaSOR <- community_analisis$betaSOR
  
  mean_branch <- mean(sort(phyloTree$edge.length))
  max_branch <- max(sort(phyloTree$edge.length))
  
  mean_phylo_age <-mean(ape::branching.times(phyloTree))
  oldest_phylo_age <-max(ape::branching.times(phyloTree))
  
  #print(L)
  lineage_age <- timeStep - L[-L[,4]==0,,drop=F][,2]
  #lineage_age <- timeStep - L[aliveSpecies_from_Ltable,2]
  oldest_lineage_age <- max(lineage_age)
  mean_lineage_age <- mean(lineage_age)
  
  shape_index <- (sum(max_branch-phyloTree$edge.length))/length(phyloTree$edge.length)
  shape_index <-shape_index/oldest_phylo_age
  shape_index<-  var(sort(phyloTree$edge.length)[1:4])
  # 
  # plot.phylo(phyloTree,
  #            main=shape_index)
  # add.scale.bar()
  
  # Phylogenetic signal
  id_species_withT <- phyloTree$tip.label
  species_id_numbersOnly <- NULL
  for(i in 1:length(aliveSpecies)){
    all_species_id <- strsplit(id_species_withT,split="t")
    species_id_numbersOnly <- c(species_id_numbersOnly,as.numeric(all_species_id[[i]][2]))
  }
  range_sorted_phylo <- NULL
  for(i in 1:length(species_id_numbersOnly)){
    which(rangeSize [,1]== species_id_numbersOnly[i])
    species_range <-rangeSize[which(rangeSize [,1]== species_id_numbersOnly[i]),2]
    range_sorted_phylo <- c(range_sorted_phylo,species_range)
  }  
  
 # invisible(capture.output( blom_K <- phylosig(phyloTree,range_sorted_phylo,method="lambda",test=TRUE)$lambda ))
  blom_K <- 0
  
  #PhyloField
  
  phy_field <- phylodivfield_pams(community_analisis$communityMatrix,phyloTree)
  spp_divfields <- divfield_pams(community_analisis$communityMatrix)
  
  return(list(
    deltaR=deltaR,
    betaSIM=betaSIM,
    beta=beta,
    betaSNE=betaSNE,
    betaSOR=betaSOR,
    meanPSC = meanPSC,
    meanPSV=meanPSV,
    sackinInd=sackinInd,
    per_lineage_lambda=per_lineage_lambda,
    per_lineage_mu=per_lineage_mu,
    mean_phylo_age=mean_phylo_age,
    oldest_phylo_age=oldest_phylo_age,
    mean_branch=mean_branch,
    max_branch=max_branch,
    blom_K=blom_K,
    phy_field = phy_field,
    spp_divfields=spp_divfields
    
  ))
}

