
testing_merging <- function(map1,map2,L1,L2,new_L,new_species,new_rangeSize,new_map){
  
  L1_aliveSpecies_from_Ltable<- L1[-L1[,4]==0,,drop=F][,1]
  L2_aliveSpecies_from_Ltable<- L2[-L2[,4]==0,,drop=F][,1]
  survivors_separated_maps <- length(L1_aliveSpecies_from_Ltable) + length(L2_aliveSpecies_from_Ltable)
  aliveSpecies_from_Ltable <- new_L[-new_L[,4]==0,,drop=F][,1]
  
  aliveSpecies_from_distribution <- NULL
  for(i in 1:length(new_species)){
    if(class(new_species[[i]])!="character"){
      aliveSpecies_from_distribution <- c(aliveSpecies_from_distribution,i)
    }
  }
  # if(length(aliveSpecies_from_Ltable)!= survivors_separated_maps){
  #   stop("problem when merging")
  # }
  if(any(aliveSpecies_from_distribution != aliveSpecies_from_Ltable)==TRUE){
    stop("problem when merging")
  }
  if(length(new_species) != nrow(new_L)){
    stop("problem when merging")
  }
  
  ranges_from_distribution <- NULL
  for(i in 1:length(new_species)){
    if(class(new_species[[i]])!="character"){
      ranges_from_distribution <- c(ranges_from_distribution, nrow(new_species[[i]]))
    } 
  }
  
  if(sum(ranges_from_distribution)!=sum(new_rangeSize[,2])){
    stop("problem when merging")
  }
  
  available_cells_original <- length(which(map1!=-9)) + length(which(map2!=-9))
  available_cells_new<- length(which(new_map!=-9)) 
  if( available_cells_new != available_cells_new){
    stop("problem when merging, check the map")
  }
}


merge_rangeSize <- function(rangeSize1,rangeSize2,L1){
  first_id <- max(L1[,1]) + 1
  new_rangeSize1 <- rangeSize1
  new_rangeSize2 <- rangeSize2
  new_rangeSize1[,1] <- rangeSize1[,1] + 1
  new_rangeSize2[,1] <- rangeSize2[,1] + first_id
  new_rangeSize <- rbind(new_rangeSize1,new_rangeSize2)
  return(new_rangeSize)
}



merge_L <- function(L1,L2){
  new_L1 <- L1
  new_L2 <- L2
  new_L1[,1] <- new_L1[,1] + 1 
  new_L1[,3] <- new_L1[,3] + 1 
  first_id <- max(new_L1[,1])
  new_L2[,1] <- new_L2[,1] + first_id
  new_L2[,3] <- new_L2[,3] + first_id
  #new_L2[,1] <- new_L2[,1] + 1 
  #new_L2[,3] <- new_L2[,3] + 1 
  new_L2[1,3] <- 1
  new_L1[1,2] <- 0.000001
  new_L2[1,2] <- 0.000002
  merged_L <- rbind(c(1,0,0,0.000003),
                    new_L1,
                    new_L2)
  new_L <- merged_L
  return (new_L)
}

merge_maps <- function(map1,map2,join_point){
  # join_point means where the map 2 will be attached: North of map 1
  if(join_point == "north"){
    border2 <- nrow(map2)  
    while( all(map2[border2,]==-9)){
      border2 <- border2 - 1
    }
    map2_trimmed <- map2[1:border2,1:ncol(map2)]
    
    border1 <- 1  
    while( all(map1[border1,]==-9)){
      border1 <- border1 + 1
    }
    map1_trimmed <- map1[border1:nrow(map1),1:ncol(map1)]
    new_map <- rbind(map2_trimmed,map1_trimmed)
  }
  
  if(join_point == "east"){
    border2 <- 1 
    while( all(map2[,border2]==-9)){
      border2 <- border2 + 1
    }
    map2_trimmed <- map2[1:nrow(map2),border2:ncol(map2)]
    
    border1 <- ncol(map1)  
    while( all(map1[,border1]==-9)){
      border1 <- border1 - 1
    }
    map1_trimmed <- map1[1:nrow(map1),1:border1]
    new_map <- cbind(map1_trimmed,map2_trimmed)
  }
  return(list(new_map = new_map,
              border1 = border1,
              border2 = border2,
              map1_trimmed = map1_trimmed,
              map2_trimmed = map2_trimmed)) 
}

merge_distributions <- function(map1_trimmed,map2_trimmed,species1,species2,border1,border2,join_point){
  new_species <- list()
  # it has the position " + 1" as we added the ancester of both clades, and we
  # disappear it later. That ancester is species id 1
  new_species [[1]] <- "RIP" 
  if(join_point == "north"){
    # summing: the size of map2_trimmed but considering
    # the border we removed from original map 1
    sum_new_coordinate_sp1 <- nrow(map2_trimmed) - (border1 - 1) 
    for(i in 1:length(species1)){
      species_to_convert <- species1[[i]]
      if(class(species_to_convert)!="character"){ #it will be an extinct species
        one_species <- matrix(0,ncol=2,nrow = nrow(species_to_convert))
        for(ii in 1:nrow(species_to_convert)){
          one_species[ii,1]  <- species_to_convert[ii,1] + sum_new_coordinate_sp1
          one_species[ii,2]  <- species_to_convert[ii,2] 
        }
        # it has the position " + 1" as we added the ancester of both clades, and we
        # disappear it later. That ancester is species id 1
        new_species[[i + 1]] <- one_species
      } else {
        new_species[[i + 1]] <- "RIP"
      }
    }
    
    for(i in 1:length(species2)){
      species_to_convert <- species2[[i]]
      if(class(species_to_convert)!="character"){ #it will be an extinct species
        one_species <- matrix(0,ncol=2,nrow = nrow(species_to_convert))
        for(ii in 1:nrow(species_to_convert)){
          one_species[ii,1]  <- species_to_convert[ii,1] 
          one_species[ii,2]  <- species_to_convert[ii,2] 
        }
        # it has the position " + 1" as we added the ancester of both clades, and we
        # disappear it later. That ancester is species id 1
        new_species[[i + length(species1) + 1]] <- one_species
      } else {
        new_species[[i + length(species1) + 1]] <- "RIP"
      }
    }
  }
  if(join_point == "east"){
    # summing: the size of map2_trimmed but considering
    # the border we removed from original map 1
    sum_new_coordinate_sp2 <- ncol(map1_trimmed) - (border2 - 1) 
    for(i in 1:length(species1)){
      species_to_convert <- species1[[i]]
      if(class(species_to_convert)!="character"){ #it will be an extinct species
        one_species <- matrix(0,ncol=2,nrow = nrow(species_to_convert))
        for(ii in 1:nrow(species_to_convert)){
          one_species[ii,1]  <- species_to_convert[ii,1] 
          one_species[ii,2]  <- species_to_convert[ii,2] 
        }
        # it has the position " + 1" as we added the ancester of both clades, and we
        # disappear it later. That ancester is species id 1
        new_species[[i +  1]] <- one_species
      } else {
        new_species[[i +  1]] <- "RIP"
      }
    }
    for(i in 1:length(species2)){
      species_to_convert <- species2[[i]]
      if(class(species_to_convert)!="character"){ #it will be an extinct species
        one_species <- matrix(0,ncol=2,nrow = nrow(species_to_convert))
        for(ii in 1:nrow(species_to_convert)){
          one_species[ii,1]  <- species_to_convert[ii,1] 
          one_species[ii,2]  <- species_to_convert[ii,2] + sum_new_coordinate_sp2
        }
        # it has the position " + 1" as we added the ancester of both clades, and we
        # disappear it later. That ancester is species id 1
        new_species[[i + length(species1) + 1]] <- one_species
      } else {
        new_species[[i + length(species1) + 1]] <- "RIP"
      }
    }
  }
  return(new_species)
}


merge_distributions2 <- function(map1_trimmed,map2_trimmed,species1,species2,
                                border1,border2,join_point,
                                 independent_aftersplit_L1,
                                 independent_aftersplit_L2,
                                 adjusted_mergedL){
  sum_new_coordinate_sp1 <- nrow(map2_trimmed) - (border1 - 1)
  sum_new_coordinate_sp2 <- ncol(map1_trimmed) - (border2 - 1)   
  new_species <- list()
  # first part, the regions share the first species
  number_share_L <- nrow(adjusted_mergedL)
  if(join_point == "north"){
    # summing: the size of map2_trimmed but considering
    # the border we removed from original map 1 
    
    for( i in 1: number_share_L){
      if(class(species1[[i]]) =="character" && class(species2[[i]]) =="character"){ # species extinct from both regions
        new_species[[i]] <- "RIP"
      } else {
        # if alive in region 1, place it in the new_species list
        species_to_convert <- species1[[i]]
        alive_in_1 <- FALSE
        if(class(species_to_convert)!="character"){ #alive in region1
          alive_in_1 <- TRUE
          one_species <- matrix(0,ncol=2,nrow = nrow(species_to_convert))
          for(ii in 1:nrow(species_to_convert)){
            one_species[ii,1]  <- species_to_convert[ii,1] + sum_new_coordinate_sp1
            one_species[ii,2]  <- species_to_convert[ii,2] 
          }
          new_species[[i]] <- one_species
        } 
        
        # if alive in region 2, place it in the new_species list
        species_to_convert <- species2[[i]]
        if(class(species_to_convert)!="character"){ #alive in region2
          one_species <- matrix(0,ncol=2,nrow = nrow(species_to_convert))
          for(ii in 1:nrow(species_to_convert)){
            one_species[ii,1]  <- species_to_convert[ii,1] 
            one_species[ii,2]  <- species_to_convert[ii,2] 
          }
          if(alive_in_1){ # it means that new_species[[i]] is not empty
            new_species[[i]] <- rbind(one_species,new_species[[i]])
          } else {
            new_species[[i]] <- one_species
          }
          
        } 
      }
    }
    # now the part where the regions are independent from one another
    
    for(i in (number_share_L + 1):length(species1)){
      species_to_convert <- species1[[i]]
      if(class(species_to_convert)!="character"){ #it will be an extinct species
        one_species <- matrix(0,ncol=2,nrow = nrow(species_to_convert))
        for(ii in 1:nrow(species_to_convert)){
          one_species[ii,1]  <- species_to_convert[ii,1] + sum_new_coordinate_sp1
          one_species[ii,2]  <- species_to_convert[ii,2] 
        }
        new_species[[i]] <- one_species
      } else {
        new_species[[i]] <- "RIP"
      }
    }
    
    for(i in (number_share_L + 1):length(species2)){
      species_to_convert <- species2[[i]]
      if(class(species_to_convert)!="character"){ #it will be an extinct species
        one_species <- matrix(0,ncol=2,nrow = nrow(species_to_convert))
        for(ii in 1:nrow(species_to_convert)){
          one_species[ii,1]  <- species_to_convert[ii,1] 
          one_species[ii,2]  <- species_to_convert[ii,2] 
        }
        # I have to consider that that ID of species in region 2 depends on the last ID in region1
        new_species[[ length(new_species) + 1]] <- one_species
      } else {
        new_species[[ length(new_species) + 1]] <- "RIP"
      }
    }
    
  } # end of join_point
  
  if(join_point == "east"){
    # summing: the size of map2_trimmed but considering
    # the border we removed from original map 1 
    
    for( i in 1: number_share_L){
      if(class(species1[[i]]) =="character" && class(species2[[i]]) =="character"){ # species extinct from both regions
        new_species[[i]] <- "RIP"
      } else {
        # if alive in region 1, place it in the new_species list
        species_to_convert <- species1[[i]]
        alive_in_1 <- FALSE
        if(class(species_to_convert)!="character"){ #alive in region1
          alive_in_1 <- TRUE
          one_species <- matrix(0,ncol=2,nrow = nrow(species_to_convert))
          for(ii in 1:nrow(species_to_convert)){
            one_species[ii,1]  <- species_to_convert[ii,1] 
            one_species[ii,2]  <- species_to_convert[ii,2] 
          }
          new_species[[i]] <- one_species
        } 
        
        # if alive in region 2, place it in the new_species list
        species_to_convert <- species2[[i]]
        if(class(species_to_convert)!="character"){ #alive in region2
          one_species <- matrix(0,ncol=2,nrow = nrow(species_to_convert))
          for(ii in 1:nrow(species_to_convert)){
            one_species[ii,1]  <- species_to_convert[ii,1] 
            one_species[ii,2]  <- species_to_convert[ii,2] + sum_new_coordinate_sp2
          }
          if(alive_in_1){ # it means that new_species[[i]] is not empty
            new_species[[i]] <- rbind(one_species,new_species[[i]])
          } else {
            new_species[[i]] <- one_species
          }
          
        } 
      }
    }
    # now the part where the regions are independent from one another
    
    for(i in (number_share_L + 1):length(species1)){
      species_to_convert <- species1[[i]]
      if(class(species_to_convert)!="character"){ #it will be an extinct species
        one_species <- matrix(0,ncol=2,nrow = nrow(species_to_convert))
        for(ii in 1:nrow(species_to_convert)){
          one_species[ii,1]  <- species_to_convert[ii,1]
          one_species[ii,2]  <- species_to_convert[ii,2] 
        }
        new_species[[i]] <- one_species
      } else {
        new_species[[i]] <- "RIP"
      }
    }
    
    for(i in (number_share_L + 1):length(species2)){
      species_to_convert <- species2[[i]]
      if(class(species_to_convert)!="character"){ #it will be an extinct species
        one_species <- matrix(0,ncol=2,nrow = nrow(species_to_convert))
        for(ii in 1:nrow(species_to_convert)){
          one_species[ii,1]  <- species_to_convert[ii,1] 
          one_species[ii,2]  <- species_to_convert[ii,2] + sum_new_coordinate_sp2
        }
        # I have to consider that that ID of species in region 2 depends on the last ID in region1
        new_species[[ length(new_species) + 1]] <- one_species
      } else {
        new_species[[ length(new_species) + 1]] <- "RIP"
      }
    }
    
  } # end of join_point
  
  return(new_species)
}


