do_simulation_split <- function(k,
                                             lambda,
                                             mu,
                                             gamma,
                                             set_simulated_time,
                                             map_merging_time,
                                             maps,
                                             join_point,
                                             num_time_slices,
                                             forced_crown_age,
                                             cycles,
                                             survival_crown_lineages){
  
  cat("your parameters: k",k,"lambda", lambda,"mu",mu,"gamma",gamma,"\n")
  time_start <-Sys.time()
  cat("\n\n\n\n")
  cat("___________ merged map \n")
  
  merged_maps <- merge_maps(maps[[1]],maps[[2]],join_point)
  the_map <- merged_maps$new_map
  sucess <- FALSE
  while(sucess == FALSE){
    simulation_whole <- simulate_process(k,
                                         cycles,
                                         lambda,
                                         mu,
                                         gamma,
                                         survival_crown_lineages,
                                         set_simulated_time = map_merging_time,
                                         the_map,
                                         map_merging_time,
                                         num_time_slices,
                                         forced_crown_age,
                                         starting_from_eve = "yes")
    sucess <- any(simulation_whole$L[,4]==0)
  }
  
  merged_species <- simulation_whole$species
  
  map2_trimmed <- merged_maps$map2_trimmed
  map1_trimmed <- merged_maps$map1_trimmed
  border1 <- merged_maps$border1
  border2 <- merged_maps$border2
  
  
  split_regions <- UNmerge_distributions(map1_trimmed,map2_trimmed,
                                         merged_species,border1,border2,join_point)
  
  new_species1 <- split_regions$new_species1
  new_species2 <- split_regions$new_species2
  alivespecies1 <- split_regions$alivespecies1
  alivespecies2 <- split_regions$alivespecies2
  rangeSize1 <- split_regions$rangeSize1
  rangeSize2 <- split_regions$rangeSize2
  
  testing_UNmerging(simulation_whole,new_species1,new_species2,merged_species,alivespecies1,alivespecies2,
                    rangeSize1,rangeSize2)
  
  cat("___________ splitting map \n")
  cat("___________ first map \n")
  ######
  mergedL <-  simulation_whole$L
  starting_from_eve <- list()
  starting_from_eve[[1]] <- mergedL
  starting_from_eve[[2]] <- new_species1
  starting_from_eve[[3]] <- rangeSize1
  starting_from_eve[[4]] <- alivespecies1
  the_map <- maps[[1]]
  sucess <- FALSE
  while(sucess == FALSE){
    simulation1 <- simulate_process(k,
                                    cycles,
                                    lambda,
                                    mu,
                                    gamma,
                                    survival_crown_lineages,
                                    set_simulated_time = set_simulated_time,
                                    the_map,
                                    map_merging_time,
                                    num_time_slices,
                                    forced_crown_age,
                                    starting_from_eve = starting_from_eve)
    sucess <- any(simulation1$L[,4]==0)
  }
  cat("\n\n\n\n")
  Ltable1 <- simulation1$L
  
  #####
  mergedL <-  simulation_whole$L
  starting_from_eve <- list()
  starting_from_eve[[1]] <- mergedL
  starting_from_eve[[2]] <- new_species2
  starting_from_eve[[3]] <- rangeSize2
  starting_from_eve[[4]] <- alivespecies2
  
  cat("___________ second map \n")
  the_map <- maps[[2]]
  sucess <- FALSE
  while(sucess == FALSE){
    simulation2 <- simulate_process(k,
                                    cycles,
                                    lambda,
                                    mu,
                                    gamma,
                                    survival_crown_lineages,
                                    set_simulated_time = set_simulated_time,
                                    the_map,
                                    map_merging_time,
                                    num_time_slices,
                                    forced_crown_age,
                                    starting_from_eve = starting_from_eve)
    sucess <- any(simulation2$L[,4]==0)
  }
  
  Ltable2 <- simulation2$L
  # The species have the same ID in the different regions. So, first species born in
  # region 2 after the splitting will have the same ID than the first species born in region 1
  # which cannot be. The following lines take care of it.
  
  last_ID_merged <- max(mergedL[,1])
  last_ID_Ltable1 <- max(Ltable1)
  
  for(i in 1:nrow(Ltable2)){
    if(Ltable2[i,1] > last_ID_merged){
      Ltable2[i,1] <- Ltable2[i,1] + (last_ID_Ltable1 - last_ID_merged)     
    } 
    if(Ltable2[i,3] > last_ID_merged){
      Ltable2[i,3] <- Ltable2[i,3] +  (last_ID_Ltable1 - last_ID_merged)    
    } 
  }
  
  cat("All phylogenetic metrics at this point, are meaningless, as both regions need to be considered.
A bit later, there will be a function that put them together. \n") 

  a <- Ltable1
  b <- Ltable2       
  # COnsider  the part of L table that is common for both lists
  
  if(nrow(mergedL)==1){
    independent_aftersplit_L1 <- a[(nrow(mergedL) + 1):nrow(a),] 
    independent_aftersplit_L2  <- b[(nrow(mergedL) +1):nrow(b),] 
    LTable_complete <-rbind(mergedL,independent_aftersplit_L1,independent_aftersplit_L2)
  } else {
    head_a <- a[1:nrow(mergedL),] 
    head_b <- b[1:nrow(mergedL),] 
    independent_aftersplit_L1 <- a[(nrow(mergedL) + 1):nrow(a),] 
    independent_aftersplit_L2  <- b[(nrow(mergedL) +1):nrow(b),] 
    adjusted_mergedL <- mergedL
    # During the time the regions were apart, some of the first species might have died, the next
    # lines account for that
    
    if(all(head_a[,4] == head_b[,4])==FALSE){ 
      mistmach <- which(head_a[,4] != head_b[,4])
      for(ii in 1: length(mistmach)){
        if(any(c(head_a[mistmach[ii],4],head_b[mistmach[ii],4])==0)){ # it survived in one region
          adjusted_mergedL[mistmach[ii],4] <- 0     
        } else{
          cat(ii,"\n")
          adjusted_mergedL[mistmach[ii],4] <-max(c(head_a[mistmach[ii],4],head_b[mistmach[ii],4]) )
        }
      }
      
    }
    LTable_complete <- rbind(adjusted_mergedL,independent_aftersplit_L1,independent_aftersplit_L2)
    
  }
  
  if(any(LTable_complete[,1] == unique(LTable_complete[,1])) == FALSE){
    stop("problem putting L tables together")        
  }

  return(list(simulation_whole = simulation_whole,
              simulation1 = simulation1,
              simulation2 = simulation2,
              LTable_complete = LTable_complete
              )
  )
  
}
