do_simulation_mergesplit <- function(k, 
                                                  lambda, 
                                                  mu, 
                                                  gamma, 
                                                  time_first_land_fusion,
                                                  time_land_split,  
                                                  time_second_land_fusion, 
                                                  time_total_simulation,
                                                  maps,
                                                  join_point, 
                                                  num_time_slices, 
                                                  forced_crown_age,  
                                                  cycles, 
                                                  survival_crown_lineages ){
  cat("your parameters: k",k,"lambda", lambda,"mu",mu,"gamma",gamma,"\n")
  simulation_land_change <- 
    do_simulation_merge(k,
                                  lambda,
                                  mu,
                                  gamma,
                                  set_simulated_time = time_land_split,
                                  map_merging_time = time_first_land_fusion,
                                  maps,
                                  join_point,
                                  num_time_slices,
                                  forced_crown_age,
                                  cycles,
                                  survival_crown_lineages)
  
  simulation_merged <- simulation_land_change$simulation_merged
  simulation1_first <- simulation_land_change$simulation1
  simulation2_first <-simulation_land_change$simulation2
  
  
  # What it has happened:
  # 1) two maps that started out independently then
  # 2) got into contact
  # 3) this merged land continued for a while
  # 
  # now, it is time to separate them
  
  
  
  # some tools to know some features of the maps so we can do the splitting thing
  merged_maps <- merge_maps(maps[[1]],maps[[2]],join_point)
  merged_species <- simulation_merged$species
  
  map2_trimmed <- merged_maps$map2_trimmed
  map1_trimmed <- merged_maps$map1_trimmed
  border1 <- merged_maps$border1
  border2 <- merged_maps$border2
  
  
  split_regions <- UNmerge_distributions(map1_trimmed,map2_trimmed,
                                         merged_species,border1,border2,join_point)
  
  new_species1 <- split_regions$new_species1
  new_species2 <- split_regions$new_species2
  alivespecies1 <- split_regions$alivespecies1
  alivespecies2 <- split_regions$alivespecies2
  rangeSize1 <- split_regions$rangeSize1
  rangeSize2 <- split_regions$rangeSize2
  
  testing_UNmerging(simulation_merged,new_species1,new_species2,merged_species,alivespecies1,alivespecies2,
                    rangeSize1,rangeSize2)
  
  cat("___________ splitting map \n")
  cat("___________ first map \n")
  ######
  mergedL <-  simulation_merged$L
  
  ## adjust Ltable, to the species living at that region
  
  
  
  # mergedL[alivespecies1,4] <- 0 # all the species in alivespecies are alive in Ltable
  # i <- 1
  
  
  # alivespecies1
  
  starting_from_eve <- list()
  starting_from_eve[[1]] <- mergedL
  starting_from_eve[[2]] <- new_species1
  starting_from_eve[[3]] <- rangeSize1
  starting_from_eve[[4]] <- alivespecies1
  the_map <- maps[[1]]
  sucess <- FALSE
  while(sucess == FALSE){
    simulation1_second <- simulate_process(k,
                                           cycles,
                                           lambda,
                                           mu,
                                           gamma,
                                           survival_crown_lineages,
                                           set_simulated_time = time_second_land_fusion,
                                           the_map,
                                           map_merging_time = time_land_split,
                                           num_time_slices,
                                           forced_crown_age,
                                           starting_from_eve = starting_from_eve)
    sucess <- any(simulation1_second$L[,4]==0)
  }
  cat("\n\n\n\n")
  
  
  #####
  mergedL <-  simulation_merged$L
  starting_from_eve <- list()
  starting_from_eve[[1]] <- mergedL
  starting_from_eve[[2]] <- new_species2
  starting_from_eve[[3]] <- rangeSize2
  starting_from_eve[[4]] <- alivespecies2
  
  cat("___________ second map \n")
  the_map <- maps[[2]]
  sucess <- FALSE
  while(sucess == FALSE){
    simulation2_second <- simulate_process(k,
                                           cycles,
                                           lambda,
                                           mu,
                                           gamma,
                                           survival_crown_lineages,
                                           set_simulated_time = time_second_land_fusion,
                                           the_map,
                                           map_merging_time = time_land_split,
                                           num_time_slices,
                                           forced_crown_age,
                                           starting_from_eve = starting_from_eve)
    sucess <- any(simulation2_second$L[,4]==0)
  }
  
  
  species1 <- simulation1_second$species
  species2 <- simulation2_second$species
  
  aliveSpecies_from_distribution_1 <- NULL
  for(i in 1:length(species1)){
    if(class(species1[[i]])!="character"){
      aliveSpecies_from_distribution_1 <- c(aliveSpecies_from_distribution_1,i)
    }
  }
  
  aliveSpecies_from_distribution_2 <- NULL
  for(i in 1:length(species2)){
    if(class(species2[[i]])!="character"){
      aliveSpecies_from_distribution_2 <- c(aliveSpecies_from_distribution_2,i)
    }
  }
  
  
  Ltable1 <- simulation1_second$L
  Ltable2 <- simulation2_second$L
  
  
  # The species have the same ID in the different regions. So, first species born in
  # region 2 after the splitting will have the same ID than the first species born in region 1
  # which cannot be. The following lines take care of it.
  last_ID_merged <- max(mergedL[,1])
  last_ID_Ltable1 <- max(Ltable1)
  
  for(i in 1:nrow(Ltable2)){
    if(Ltable2[i,1] > last_ID_merged){
      Ltable2[i,1] <- Ltable2[i,1] + (last_ID_Ltable1 - last_ID_merged)     
    } 
    if(Ltable2[i,3] > last_ID_merged){
      Ltable2[i,3] <- Ltable2[i,3] +  (last_ID_Ltable1 - last_ID_merged)    
    } 
  }
  a <- Ltable1
  b <- Ltable2
  # Consider  the part of L table that is common for both lists
  if(nrow(mergedL)==1){
    independent_aftersplit_L1 <- a[(nrow(mergedL) + 1):nrow(a),] 
    independent_aftersplit_L2  <- b[(nrow(mergedL) +1):nrow(b),] 
    LTable_complete <-rbind(mergedL,independent_aftersplit_L1,independent_aftersplit_L2)
  } else {
    head_a <- a[1:nrow(mergedL),] 
    head_b <- b[1:nrow(mergedL),] 
    independent_aftersplit_L1 <- a[(nrow(mergedL) + 1):nrow(a),] 
    independent_aftersplit_L2  <- b[(nrow(mergedL) +1):nrow(b),] 
  }
  # During the time the regions were apart, some of the first species might have died, the next
  # lines account for that
  
  adjusted_mergedL <- mergedL
  for(i in 1:nrow(adjusted_mergedL)){
    
    if(Ltable1[i,4] != 0 && Ltable2[i,4] != 0){ # it is  dead
      
      if(all(adjusted_mergedL[i,1] != c(aliveSpecies_from_distribution_1,aliveSpecies_from_distribution_2))){ #Real dead
        adjusted_mergedL[i,4] <- max(c(Ltable1[i,4],Ltable2[i,4]))
      }
      
    } else {
      
      if(any(adjusted_mergedL[i,1] == c(aliveSpecies_from_distribution_1,aliveSpecies_from_distribution_2))){ #alive in distribution
        adjusted_mergedL[i,4] <- 0
      } else {
        adjusted_mergedL[i,4] <- max(c(Ltable1[i,4],Ltable2[i,4]))
      }
      
    }
    
  }
  
  # if(all(head_a[,4] == head_b[,4])==FALSE){ 
  #   mistmach <- which(head_a[,4] != head_b[,4])
  #   for(ii in 1: length(mistmach)){
  #     if(any(c(head_a[mistmach[ii],4],head_b[mistmach[ii],4])==0)){ # it survived in one region
  #       adjusted_mergedL[mistmach[ii],4] <- 0     
  #     } else{
  #       cat(ii,"\n")
  #       adjusted_mergedL[mistmach[ii],4] <-max(c(head_a[mistmach[ii],4],head_b[mistmach[ii],4]) )
  #     }
  #   }
  #   
  # }
  LTable_complete <- rbind(adjusted_mergedL,independent_aftersplit_L1,independent_aftersplit_L2)
  # I have now two regions again, I need to put them together and
  # let them run for a moment. Different from the first part of the process,
  # this time the regions do not start from scratch. 
  
  merged_maps <- merge_maps(maps[[1]],maps[[2]],join_point)
  new_map <- merged_maps$new_map
  border1 <- merged_maps$border1
  border2 <- merged_maps$border2
  map1_trimmed <- merged_maps$map1_trimmed
  map2_trimmed <- merged_maps$map2_trimmed
  
  rangeSize1 <- simulation1_second$rangeSize
  rangeSize2 <- simulation2_second$rangeSize
  #L1 <- simulation1_second$L
  #L2 <- simulation2_second$L
  L1 <- rbind(adjusted_mergedL,independent_aftersplit_L1)
  L2 <- rbind(adjusted_mergedL,independent_aftersplit_L2)
  
  
  #new_L <- merge_L(L1,L2)
  
  
  new_species <- merge_distributions2(map1_trimmed,map2_trimmed,species1,species2,
                                      border1,border2,join_point,
                                      independent_aftersplit_L1,
                                      independent_aftersplit_L2,
                                      adjusted_mergedL)
  
  pre_new_rangeSize <- merge_rangeSize(rangeSize1,rangeSize2,L1)
  
  testing_merging(maps[[1]],maps[[2]],L1,L2,
                  LTable_complete,new_species,pre_new_rangeSize,new_map)
  
  
  
  new_rangeSize <- NULL
  for(i in 1:length(new_species)){
    range_one_species <- matrix(c(0,0),ncol = 2)
    if(class(new_species[[i]])!="character"){
      range_one_species[1,1] <- i
      range_one_species[1,2] <- nrow(new_species[[i]]) 
      new_rangeSize <- rbind(new_rangeSize,range_one_species)
    }
    
  }
  
  
  testing_merging(maps[[1]],maps[[2]],L1,L2,
                  LTable_complete,new_species,pre_new_rangeSize,new_map)
  
  
  aliveSpecies_new <- LTable_complete[-LTable_complete[,4]==0,,drop=F][,1]
  
  starting_from_eve <- list()
  starting_from_eve[[1]] <- LTable_complete
  starting_from_eve[[2]] <- new_species
  starting_from_eve[[3]] <- new_rangeSize
  starting_from_eve[[4]] <- aliveSpecies_new
  
  cat("___________ Merging maps at:",time_second_land_fusion,"\n")
  the_map <- new_map
  sucess <- FALSE
  while(sucess == FALSE){
    simulation_current_land <- simulate_process(k,
                                                cycles,
                                                lambda,
                                                mu,
                                                gamma,
                                                survival_crown_lineages,
                                                set_simulated_time = time_total_simulation ,
                                                the_map,
                                                map_merging_time = time_second_land_fusion,
                                                num_time_slices,
                                                forced_crown_age,
                                                starting_from_eve = starting_from_eve)
    sucess <- any(simulation_current_land$L[,4]==0)
  }
  
  
return(list(
  simulation_current_land = simulation_current_land
  
))

}