do_simulation_merge <- function(k,
                                          lambda,
                                          mu,
                                          gamma,
                                          set_simulated_time,
                                          map_merging_time,
                                          maps,
                                          join_point,
                                          num_time_slices,
                                          forced_crown_age,
                                          cycles,
                                          survival_crown_lineages){

cat("your parameters: k",k,"lambda", lambda,"mu",mu,"gamma",gamma,"\n")
time_start <-Sys.time()
cat("\n\n\n\n")
cat("___________ first map \n")
the_map <-maps[[1]]
sucess <- FALSE


while(sucess == FALSE){
        simulation1 <- simulate_process(k,
                                        cycles,
                                        lambda,
                                        mu,
                                        gamma,
                                        survival_crown_lineages,
                                        set_simulated_time = map_merging_time,
                                        the_map,
                                        map_merging_time,
                                        num_time_slices,
                                        forced_crown_age,
                                        starting_from_eve = "yes")
        sucess <- any(simulation1$L[,4]==0)
}
cat("\n\n\n\n")
cat("___________ second map \n")
the_map <-maps[[2]]
sucess <- FALSE
while(sucess == FALSE){
        simulation2 <- simulate_process(k,
                                        cycles,
                                        lambda,
                                        mu,
                                        gamma,
                                        survival_crown_lineages,
                                        set_simulated_time = map_merging_time,
                                        the_map,
                                        map_merging_time,
                                        num_time_slices,
                                        forced_crown_age,
                                        starting_from_eve = "yes")
        sucess <- any(simulation2$L[,4]==0)
}

# Merging simulation1 and simulation2

merged_maps <- merge_maps(maps[[1]],maps[[2]],join_point)
new_map <- merged_maps$new_map
border1 <- merged_maps$border1
border2 <- merged_maps$border2
map1_trimmed <- merged_maps$map1_trimmed
map2_trimmed <- merged_maps$map2_trimmed

rangeSize1 <- simulation1$rangeSize
rangeSize2 <- simulation2$rangeSize
L1 <- simulation1$L
L2 <- simulation2$L
new_rangeSize <- merge_rangeSize(rangeSize1,rangeSize2,L1)

new_L <- merge_L(L1,L2)

species1 <- simulation1$species
species2 <- simulation2$species

new_species <- merge_distributions(map1_trimmed,map2_trimmed,
                                   species1,species2,border1,border2,join_point)

testing_merging(the_map[[1]],the_map[[2]],L1,L2,
                 new_L,new_species,new_rangeSize,new_map)

aliveSpecies_new <- new_L[-new_L[,4]==0,,drop=F][,1]

starting_from_eve <- list()
starting_from_eve[[1]] <- new_L
starting_from_eve[[2]] <- new_species
starting_from_eve[[3]] <- new_rangeSize
starting_from_eve[[4]] <- aliveSpecies_new

cat("___________ Merging maps at:",map_merging_time,"\n")
the_map <- new_map
sucess <- FALSE
while(sucess == FALSE){
        simulation_merged <- simulate_process(k,
                                        cycles,
                                        lambda,
                                        mu,
                                        gamma,
                                        survival_crown_lineages,
                                        set_simulated_time,
                                        the_map,
                                        map_merging_time,
                                        num_time_slices,
                                        forced_crown_age,
                                        starting_from_eve = starting_from_eve)
        sucess <- any(simulation_merged$L[,4]==0)
}


#saveRDS(simulation,file = "expansion.RDS")
return(list(simulation1 = simulation1,
            simulation2 = simulation2,
            simulation_merged = simulation_merged))
}