## TFSA-2022-040: Null dereference in `GetInitOp`

### CVE Number
CVE-2022-23577

### Impact
The [implementation of `GetInitOp`](https://github.com/tensorflow/tensorflow/blob/a1320ec1eac186da1d03f033109191f715b2b130/tensorflow/cc/saved_model/loader_util.cc#L31-L61) is vulnerable to a crash caused by dereferencing a null pointer:

```cc
const auto& init_op_sig_it =
    meta_graph_def.signature_def().find(kSavedModelInitOpSignatureKey);
if (init_op_sig_it != sig_def_map.end()) {
  *init_op_name = init_op_sig_it->second.outputs()
                      .find(kSavedModelInitOpSignatureKey)
                      ->second.name();
  return Status::OK();
}
```

Here, we have a nested map and we assume that if the first `.find` succeeds then so would be the search in the internal map. However, the maps are built based on the `SavedModel` protobuf format and a malicious user can alter that on disk before loading to cause the second `.find` to return `nullptr`.

### Patches
We have patched the issue in GitHub commit [4f38b1ac8e42727e18a2f0bde06d3bee8e77b250](https://github.com/tensorflow/tensorflow/commit/4f38b1ac8e42727e18a2f0bde06d3bee8e77b250).

The fix will be included in TensorFlow 2.8.0. We will also cherrypick this commit on TensorFlow 2.7.1, TensorFlow 2.6.3, and TensorFlow 2.5.3, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.
