## TFSA-2022-032: Heap OOB write in Grappler

### CVE Number
CVE-2022-23566

### Impact
TensorFlow is vulnerable to a heap OOB write in [Grappler](https://github.com/tensorflow/tensorflow/blob/a1320ec1eac186da1d03f033109191f715b2b130/tensorflow/core/grappler/costs/graph_properties.cc#L1132-L1141):

```cc
Status SetUnknownShape(const NodeDef* node, int output_port) {
  shape_inference::ShapeHandle shape =
      GetUnknownOutputShape(node, output_port);
  InferenceContext* ctx = GetContext(node);
  if (ctx == nullptr) {
    return errors::InvalidArgument("Missing context");
  }
  ctx->set_output(output_port, shape);
  return Status::OK();
}
```

The [`set_output`](https://github.com/tensorflow/tensorflow/blob/a1320ec1eac186da1d03f033109191f715b2b130/tensorflow/core/framework/shape_inference.h#L394) function writes to an array at the specified index:

```cc
void set_output(int idx, ShapeHandle shape) { outputs_.at(idx) = shape; }
```

Hence, this gives a malicious user a write primitive.

### Patches
We have patched the issue in GitHub commit [97282c6d0d34476b6ba033f961590b783fa184cd](https://github.com/tensorflow/tensorflow/commit/97282c6d0d34476b6ba033f961590b783fa184cd).

The fix will be included in TensorFlow 2.8.0. We will also cherrypick this commit on TensorFlow 2.7.1, TensorFlow 2.6.3, and TensorFlow 2.5.3, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.
