# Load packages -----------------------------------------------------------

library(tidyverse)
library(ggplot2)
library(ggrepel)
library(cowplot)
library(grid)
library(gridExtra)

# Read in Bayenv outputs --------------------------------------------------

Run1.100k<-read_delim(file="bf_environ.pox_100_000_run1.txt", col_names = FALSE , delim="\t")
Run2.100k<-read_delim(file="bf_environ.pox_100_000_run2.txt", col_names = FALSE , delim="\t")
Run3.100k<-read_delim(file="bf_environ.pox_100_000_run3.txt", col_names = FALSE , delim="\t")
Run4.100k<-read_delim(file="bf_environ.pox_100_000_run4.txt", col_names = FALSE , delim="\t")
Run5.100k<-read_delim(file="bf_environ.pox_100_000_run5.txt", col_names = FALSE , delim="\t")

Run1.200k<-read_delim(file="bf_environ.pox_200_000_run1.txt", col_names = FALSE , delim="\t")
Run2.200k<-read_delim(file="bf_environ.pox_200_000_run2.txt", col_names = FALSE , delim="\t")
Run3.200k<-read_delim(file="bf_environ.pox_200_000_run3.txt", col_names = FALSE , delim="\t")
Run4.200k<-read_delim(file="bf_environ.pox_200_000_run4.txt", col_names = FALSE , delim="\t")
Run5.200k<-read_delim(file="bf_environ.pox_200_000_run5.txt", col_names = FALSE , delim="\t")

Run1.500k<-read_delim(file="bf_environ.pox_500_000_run1.txt", col_names = FALSE , delim="\t")
Run2.500k<-read_delim(file="bf_environ.pox_500_000_run2.txt", col_names = FALSE , delim="\t")
Run3.500k<-read_delim(file="bf_environ.pox_500_000_run3.txt", col_names = FALSE , delim="\t")
Run4.500k<-read_delim(file="bf_environ.pox_500_000_run4.txt", col_names = FALSE , delim="\t")
Run5.500k<-read_delim(file="bf_environ.pox_500_000_run5.txt", col_names = FALSE , delim="\t")


# Convert Spearman's and Pearson's coefficients to absolute values --------

Run1.100k[,c(3,4)]<-abs(Run1.100k[,c(3,4)])
Run2.100k[,c(3,4)]<-abs(Run2.100k[,c(3,4)])
Run3.100k[,c(3,4)]<-abs(Run3.100k[,c(3,4)])
Run4.100k[,c(3,4)]<-abs(Run4.100k[,c(3,4)])
Run5.100k[,c(3,4)]<-abs(Run5.100k[,c(3,4)])

Run1.200k[,c(3,4)]<-abs(Run1.200k[,c(3,4)])
Run2.200k[,c(3,4)]<-abs(Run2.200k[,c(3,4)])
Run3.200k[,c(3,4)]<-abs(Run3.200k[,c(3,4)])
Run4.200k[,c(3,4)]<-abs(Run4.200k[,c(3,4)])
Run5.200k[,c(3,4)]<-abs(Run5.200k[,c(3,4)])

Run1.500k[,c(3,4)]<-abs(Run1.500k[,c(3,4)])
Run2.500k[,c(3,4)]<-abs(Run2.500k[,c(3,4)])
Run3.500k[,c(3,4)]<-abs(Run3.500k[,c(3,4)])
Run4.500k[,c(3,4)]<-abs(Run4.500k[,c(3,4)])
Run5.500k[,c(3,4)]<-abs(Run5.500k[,c(3,4)])


# Add loci names and create a dataframe with all five runs for each number of iterations ----------------------------------------------------------

loci<-read_delim(file="loci.txt", col_names=FALSE, delim=" ")

Iterations.100k<-bind_cols(loci, Run1.100k, Run2.100k, Run3.100k, Run4.100k, Run5.100k)
Iterations.200k<-bind_cols(loci, Run1.200k, Run2.200k, Run3.200k, Run4.200k, Run5.200k)
Iterations.500k<-bind_cols(loci, Run1.500k, Run2.500k, Run3.500k, Run4.500k, Run5.500k)


# Explore run-to-run variability between replicates of the same number of iterations --------

# Are Bayes factors correlated across the different runs
Iterations100k.Bayes <- Iterations.100k %>% select(3,8,13,18,23)
names(Iterations100k.Bayes)[names(Iterations100k.Bayes) == "X2...3"] <- "Run1"
names(Iterations100k.Bayes)[names(Iterations100k.Bayes) == "X2...8"] <- "Run2"
names(Iterations100k.Bayes)[names(Iterations100k.Bayes) == "X2...13"] <- "Run3"
names(Iterations100k.Bayes)[names(Iterations100k.Bayes) == "X2...18"] <- "Run4"
names(Iterations100k.Bayes)[names(Iterations100k.Bayes) == "X2...23"] <- "Run5"
Iterations100kBayes.cor <-cor(Iterations100k.Bayes)

Iterations200k.Bayes <- Iterations.200k %>% select(3,8,13,18,23)
names(Iterations200k.Bayes)[names(Iterations200k.Bayes) == "X2...3"] <- "Run1"
names(Iterations200k.Bayes)[names(Iterations200k.Bayes) == "X2...8"] <- "Run2"
names(Iterations200k.Bayes)[names(Iterations200k.Bayes) == "X2...13"] <- "Run3"
names(Iterations200k.Bayes)[names(Iterations200k.Bayes) == "X2...18"] <- "Run4"
names(Iterations200k.Bayes)[names(Iterations200k.Bayes) == "X2...23"] <- "Run5"
Iterations200kBayes.cor <-cor(Iterations200k.Bayes)

Iterations500k.Bayes <- Iterations.500k %>% select(3,8,13,18,23)
names(Iterations500k.Bayes)[names(Iterations500k.Bayes) == "X2...3"] <- "Run1"
names(Iterations500k.Bayes)[names(Iterations500k.Bayes) == "X2...8"] <- "Run2"
names(Iterations500k.Bayes)[names(Iterations500k.Bayes) == "X2...13"] <- "Run3"
names(Iterations500k.Bayes)[names(Iterations500k.Bayes) == "X2...18"] <- "Run4"
names(Iterations500k.Bayes)[names(Iterations500k.Bayes) == "X2...23"] <- "Run5"
Iterations500kBayes.cor <-cor(Iterations500k.Bayes)

Bayes.cor.100k <- pairs(Iterations100k.Bayes[,1:5], pch =3, lower.panel = NULL)
Bayes.cor.200k <- pairs(Iterations200k.Bayes[,1:5], pch =3, lower.panel = NULL)
Bayes.cor.500k <- pairs(Iterations500k.Bayes[,1:5], pch =3, lower.panel = NULL)

# Are Spearman's coefficients correlated across the different runs
Iterations100k.Spearmans <- Iterations.100k %>% select(4,9,14,19,24)
names(Iterations100k.Spearmans)[names(Iterations100k.Spearmans) == "X3...4"] <- "Run1"
names(Iterations100k.Spearmans)[names(Iterations100k.Spearmans) == "X3...9"] <- "Run2"
names(Iterations100k.Spearmans)[names(Iterations100k.Spearmans) == "X3...14"] <- "Run3"
names(Iterations100k.Spearmans)[names(Iterations100k.Spearmans) == "X3...19"] <- "Run4"
names(Iterations100k.Spearmans)[names(Iterations100k.Spearmans) == "X3...24"] <- "Run5"
Iterations100kSpearmans.cor <-cor(Iterations100k.Spearmans)

Iterations200k.Spearmans <- Iterations.200k %>% select(4,9,14,19,24)
names(Iterations200k.Spearmans)[names(Iterations200k.Spearmans) == "X3...4"] <- "Run1"
names(Iterations200k.Spearmans)[names(Iterations200k.Spearmans) == "X3...9"] <- "Run2"
names(Iterations200k.Spearmans)[names(Iterations200k.Spearmans) == "X3...14"] <- "Run3"
names(Iterations200k.Spearmans)[names(Iterations200k.Spearmans) == "X3...19"] <- "Run4"
names(Iterations200k.Spearmans)[names(Iterations200k.Spearmans) == "X3...24"] <- "Run5"
Iterations200kSpearmans.cor <-cor(Iterations200k.Spearmans)

Iterations500k.Spearmans <- Iterations.500k %>% select(4,9,14,19,24)
names(Iterations500k.Spearmans)[names(Iterations500k.Spearmans) == "X3...4"] <- "Run1"
names(Iterations500k.Spearmans)[names(Iterations500k.Spearmans) == "X3...9"] <- "Run2"
names(Iterations500k.Spearmans)[names(Iterations500k.Spearmans) == "X3...14"] <- "Run3"
names(Iterations500k.Spearmans)[names(Iterations500k.Spearmans) == "X3...19"] <- "Run4"
names(Iterations500k.Spearmans)[names(Iterations500k.Spearmans) == "X3...24"] <- "Run5"
Iterations500kSpearmans.cor <-cor(Iterations500k.Spearmans)

Spearmans.cor.100k <- pairs(Iterations100k.Spearmans[,1:5], pch =3, lower.panel = NULL)
Spearmans.cor.200k <- pairs(Iterations200k.Spearmans[,1:5], pch =3, lower.panel = NULL)
Spearmans.cor.500k <- pairs(Iterations500k.Spearmans[,1:5], pch =3, lower.panel = NULL)


# Average estimates across runs as advised by Blair et al. (2014) ---------

Iterations100k.av<-bind_cols(loci, (rowMeans(Iterations100k.Bayes)), (rowMeans(Iterations100k.Spearmans)))
names(Iterations100k.av)[names(Iterations100k.av) == "X1"] <- "Locus"
names(Iterations100k.av)[names(Iterations100k.av) == "...2"] <- "BF"
names(Iterations100k.av)[names(Iterations100k.av) == "...3"] <- "Spearmans"

Iterations200k.av<-bind_cols(loci, (rowMeans(Iterations200k.Bayes)), (rowMeans(Iterations200k.Spearmans)))
names(Iterations200k.av)[names(Iterations200k.av) == "X1"] <- "Locus"
names(Iterations200k.av)[names(Iterations200k.av) == "...2"] <- "BF"
names(Iterations200k.av)[names(Iterations200k.av) == "...3"] <- "Spearmans"

Iterations500k.av<-bind_cols(loci, (rowMeans(Iterations500k.Bayes)), (rowMeans(Iterations500k.Spearmans)))
names(Iterations500k.av)[names(Iterations500k.av) == "X1"] <- "Locus"
names(Iterations500k.av)[names(Iterations500k.av) == "...2"] <- "BF"
names(Iterations500k.av)[names(Iterations500k.av) == "...3"] <- "Spearmans"


# Is there evidence that the number of iterations increases the stability --------

cor(Iterations100k.av$BF,Iterations200k.av$BF)
cor(Iterations200k.av$BF,Iterations500k.av$BF)
cor(Iterations100k.av$Spearmans,Iterations200k.av$Spearmans)
cor(Iterations200k.av$Spearmans,Iterations500k.av$Spearmans)

Iterations.av<-bind_cols(Iterations100k.av, Iterations200k.av, Iterations500k.av) # combine all iterations into one dataframe

Bayes100kvs200k <- ggplot(Iterations.av,aes(x = Iterations.av$BF...2, y = Iterations.av$BF...5))+ geom_point(col = grey(0.2))+
  theme_bw()+
  ylab(expression(paste("Bayes Factor 200K Iterations")))+ xlab(expression(paste("Bayes Factor 100k Iterations")))+ xlim(0,1)+
  ylim(0,1)
Bayes100kvs200k

Bayes200kvs500k <- ggplot(Iterations.av,aes(x = Iterations.av$BF...5, y = Iterations.av$BF...8))+ geom_point(col = grey(0.2))+
  theme_bw()+
  ylab(expression(paste("Bayes Factor 500K Iterations")))+ xlab(expression(paste("Bayes Factor 200k Iterations")))+ xlim(0,1)+
  ylim(0,1)
Bayes200kvs500k

Spearmans100kvs200k <- ggplot(Iterations.av,aes(x = Iterations.av$Spearmans...3, y = Iterations.av$Spearmans...6))+ geom_point(col = grey(0.2))+
  theme_bw()+
  ylab(expression(paste("Spearmans 200K Iterations")))+ xlab(expression(paste("Spearmans 100k Iterations")))+ xlim(0,1)+
  ylim(0,1)
Spearmans100kvs200k

Spearmans200kvs500k <- ggplot(Iterations.av,aes(x = Iterations.av$Spearmans...6, y = Iterations.av$Spearmans...9))+ geom_point(col = grey(0.2))+
  theme_bw()+
  ylab(expression(paste("Spearmans 500K Iterations")))+ xlab(expression(paste("Spearmans 200k Iterations")))+ xlim(0,1)+
  ylim(0,1)
Spearmans200kvs500k


# Identifying candidate SNPs from 500k iterations ------------------------

top.Bayes.500k <- filter(Iterations500k.av, BF > quantile(Iterations500k.av$BF,0.99)) # Identify SNPs where average BF ranked in the highest 1% (BF > 7.4) 
top.Spearmans.500k <- filter(Iterations500k.av,Spearmans > quantile(Iterations500k.av$Spearmans,0.90)) # Identify SNPs where average absolute value of Spearman’s ρ ranked in the highest 10%
candidateSNPS.500k <- top.Bayes_500k[(top.Bayes.500k$Locus %in% top.Spearman.500k$Locus),] # Identify SNPs that meet both criteria (our candidates)


# Plot Bayes factor values vs. absolute Spearman’s rank correlation coefficients (Fig 3) --------

pdf("Bayenv_Figure3.pdf")
options(ggrepel.max.overlaps = Inf)
Bayenvpox <- ggplot(Iterations500k.av,aes(x = Iterations500k.av$BF, y = Iterations500k.av$Spearmans))+
  xlim(0,100)+
  labs(x=" Bayes Factor")+
  labs(y=expression("Absolute Spearman's rank correlation coefficient " (rho)))+
  theme_classic()+
  theme(
    axis.text=element_text(size=9),
    axis.title.x = element_text(size=9),
    axis.title.y = element_text(size=9, vjust = 4),
    plot.margin = unit(c(0.5, 0.3, 0.1, 0.5), "cm"))+
  scale_y_continuous(expand = c(0,0), limit = c(0,0.61))+
  geom_hline(yintercept = quantile(Iterations500k.av$Spearmans,0.90), size = 0.3,
             color = "red")+
  geom_vline(xintercept = quantile(Iterations500k.av$BF,0.99), size = 0.3,
             color = "red")+
  geom_text_repel(aes(label=ifelse(Iterations500k.av$BF>(quantile(Iterations500k.av$BF,0.99)) & Iterations500k.av$Spearmans>(quantile(Iterations500k.av$Spearmans,0.90)), as.character(Iterations500k.av$Locus),''))
                  , min.segment.length=0, segment.size = 0.3, size= 2.8)+ geom_point(col = ifelse(Iterations500k.av$BF > (quantile(Iterations500k.av$BF,0.99)) & Iterations500k.av$Spearmans>(quantile(Iterations500k.av$Spearmans,0.90)), "red", "black"))
Bayenvpox
dev.off()
ggsave("Bayenv_Figure3.pdf", plot=Bayenvpox, device='pdf',  height=100, width=169, units="mm", dpi=500)


# Visually investigate the allele frequency structure of candidate SNPs across populations (Fig 4) --------

# Read in minor allele frequency data
MAF_pox <- read_csv("MAF_pox_candidateSNPs.csv")

# Plot the allele frequency structure of each candidate SNP across populations

Pox_SNP_444s109 <- MAF_pox %>%
  mutate(Population = fct_relevel(Population, 
                              "GRA", "LZ", "FV", "GC", "TEID", "TF", "GOM", "LP", "EH",  "DG", "M", "PS", "SG"),
         Population = recode(Population, GRA = "GRA *", LP = "LP *", EH = "EH *", DG = "DG *", M = "M *", SG = "SG *")) %>%
  ggplot(aes(x = reorder(Population, -Pox_Prevalence), y = SNP_444s109)) +
  geom_bar(stat="identity", width = 0.5)+
  ylab(NULL)+
  xlab(NULL)+
  ggtitle(expression(atop("444s109", atop(italic("HSPA8"), ""))))+
  theme_classic()+
  theme(plot.title = element_text(hjust = 0.5, vjust = -10, size=8),
        axis.text.x=element_text(angle=90, size=6),
        axis.text.y=element_text(size=6),
        panel.spacing = unit(0.5, "lines"),
        strip.text.x = element_text(size = 5, margin = margin( b = 1.5, t = 1)),
        strip.background = element_rect(fill = "lightblue", colour = "black", size = 0.1)
  )+
  scale_y_continuous(expand = c(0.01,0), limit = c(0,1))+
  facet_grid(. ~ Archipelago, scales = "free_x", space= "free_x", switch ="x")
Pox_SNP_444s109

Pox_SNP_1941s110 <- MAF_pox %>%
  mutate(Population = fct_relevel(Population, 
                              "GRA", "LZ", "FV", "GC", "TEID", "TF", "GOM", "LP", "EH",  "DG", "M", "PS", "SG"),
         Population = recode(Population, GRA = "GRA *", LP = "LP *", EH = "EH *", DG = "DG *", M = "M *", SG = "SG *")) %>%
  ggplot(aes(x = reorder(Population, -Pox_Prevalence), y = SNP_1941s110)) +
  geom_bar(stat="identity", width = 0.5)+
  ylab(NULL)+
  xlab(NULL)+
  ggtitle(expression(atop("1941s110", atop(italic("MTHFD1L"), ""))))+
  theme_classic()+
  theme(plot.title = element_text(hjust = 0.5, vjust = -10, size=8),
        axis.text.x=element_text(angle=90, size=6),
        axis.text.y=element_text(size=6),
        panel.spacing = unit(0.5, "lines"),
        strip.text.x = element_text(size = 5, margin = margin( b = 1.5, t = 1)),
        strip.background = element_rect(fill = "lightblue", colour = "black", size = 0.1)
  )+
  scale_y_continuous(expand = c(0.01,0.01), limit = c(0,1))+
  facet_grid(. ~ Archipelago, scales = "free_x", space= "free_x", switch ="x")
Pox_SNP_1941s110

Pox_SNP_2177s14 <- MAF_pox %>%
  mutate(Population = fct_relevel(Population, 
                              "GRA", "LZ", "FV", "GC", "TEID", "TF", "GOM", "LP", "EH",  "DG", "M", "PS", "SG"),
         Population = recode(Population, GRA = "GRA *", LP = "LP *", EH = "EH *", DG = "DG *", M = "M *", SG = "SG *")) %>%
  ggplot(aes(x = reorder(Population, -Pox_Prevalence), y = SNP_2177s14)) +
  geom_bar(stat="identity", width = 0.5)+
  ylab(NULL)+
  xlab(NULL)+
  ggtitle(expression(atop("2177s14", atop(italic("ABLIM3"), ""))))+
  theme_classic()+
  theme(plot.title = element_text(hjust = 0.5, vjust = -10, size=8),
        axis.text.x=element_text(angle=90, size=6),
        axis.text.y=element_text(size=6),
        panel.spacing = unit(0.5, "lines"),
        strip.text.x = element_text(size = 5, margin = margin( b = 1.5, t = 1)),
        strip.background = element_rect(fill = "lightblue", colour = "black", size = 0.1)
  )+
  scale_y_continuous(expand = c(0.01,0.01), limit = c(0,1))+
  facet_grid(. ~ Archipelago, scales = "free_x", space= "free_x", switch ="x")
Pox_SNP_2177s14

Pox_SNP_909s118 <- MAF_pox %>%
  mutate(Population = fct_relevel(Population, 
                              "GRA", "LZ", "FV", "GC", "TEID", "TF", "GOM", "LP", "EH",  "DG", "M", "PS", "SG"),
         Population = recode(Population, GRA = "GRA *", LP = "LP *", EH = "EH *", DG = "DG *", M = "M *", SG = "SG *")) %>%
  ggplot(aes(x = reorder(Population, -Pox_Prevalence), y = SNP_909s118)) +
  geom_bar(stat="identity", width = 0.5)+
  ylab(NULL)+
  xlab(NULL)+
  ggtitle(expression(atop("909s118", atop(italic(""), ""))))+
  theme_classic()+
  theme(plot.title = element_text(hjust = 0.5, vjust = -10, size=8),
        axis.text.x=element_text(angle=90, size=6),
        axis.text.y=element_text(size=6),
        panel.spacing = unit(0.5, "lines"),
        strip.text.x = element_text(size = 5, margin = margin( b = 1.5, t = 1)),
        strip.background = element_rect(fill = "lightblue", colour = "black", size = 0.1)
  )+
  scale_y_continuous(expand = c(0.01,0.01), limit = c(0,1))+
  facet_grid(. ~ Archipelago, scales = "free_x", space= "free_x", switch ="x")
Pox_SNP_909s118

Pox_SNP_1063s41 <- MAF_pox %>%
  mutate(Population = fct_relevel(Population, 
                              "GRA", "LZ", "FV", "GC", "TEID", "TF", "GOM", "LP", "EH",  "DG", "M", "PS", "SG"),
         Population = recode(Population, GRA = "GRA *", LP = "LP *", EH = "EH *", DG = "DG *", M = "M *", SG = "SG *")) %>%
  ggplot(aes(x = reorder(Population, -Pox_Prevalence), y = SNP_1063s41)) +
  geom_bar(stat="identity", width = 0.5)+
  ylab(NULL)+
  xlab(NULL)+
  ggtitle(expression(atop("1063s41", atop(italic("UBE2H"), ""))))+
  theme_classic()+
  theme(plot.title = element_text(hjust = 0.5, vjust = -10, size=8),
        axis.text.x=element_text(angle=90, size=6),
        axis.text.y=element_text(size=6),
        panel.spacing = unit(0.5, "lines"),
        strip.text.x = element_text(size = 5, margin = margin( b = 1.5, t = 1)),
        strip.background = element_rect(fill = "lightblue", colour = "black", size = 0.1)
  )+
  scale_y_continuous(expand = c(0.01,0.01), limit = c(0,1))+
  facet_grid(. ~ Archipelago, scales = "free_x", space= "free_x", switch ="x")
Pox_SNP_1063s41

Pox_SNP_3493s67 <- MAF_pox %>%
  mutate(Population = fct_relevel(Population, 
                              "GRA", "LZ", "FV", "GC", "TEID", "TF", "GOM", "LP", "EH",  "DG", "M", "PS", "SG"),
         Population = recode(Population, GRA = "GRA *", LP = "LP *", EH = "EH *", DG = "DG *", M = "M *", SG = "SG *")) %>%
  ggplot(aes(x = reorder(Population, -Pox_Prevalence), y = SNP_3493s67)) +
  geom_bar(stat="identity", width = 0.5)+
  ylab(NULL)+
  xlab(NULL)+
  ggtitle(expression(atop("3493s67", atop(italic(""), ""))))+
  theme_classic()+
  theme(plot.title = element_text(hjust = 0.5, vjust = -10, size=8),
        axis.text.x=element_text(angle=90, size=6),
        axis.text.y=element_text(size=6),
        panel.spacing = unit(0.5, "lines"),
        strip.text.x = element_text(size = 5, margin = margin( b = 1.5, t = 1)),
        strip.background = element_rect(fill = "lightblue", colour = "black", size = 0.1)
  )+
  scale_y_continuous(expand = c(0.01,0.01), limit = c(0,1))+
  facet_grid(. ~ Archipelago, scales = "free_x", space= "free_x", switch ="x")
Pox_SNP_3493s67

Pox_SNP_2862s117 <- MAF_pox %>%
  mutate(Population = fct_relevel(Population, 
                              "GRA", "LZ", "FV", "GC", "TEID", "TF", "GOM", "LP", "EH",  "DG", "M", "PS", "SG"),
         Population = recode(Population, GRA = "GRA *", LP = "LP *", EH = "EH *", DG = "DG *", M = "M *", SG = "SG *")) %>%
  ggplot(aes(x = reorder(Population, -Pox_Prevalence), y = SNP_2862s117)) +
  geom_bar(stat="identity", width = 0.5)+
  ylab(NULL)+
  xlab(NULL)+
  ggtitle(expression(atop("2862s117", atop(italic("MLYCD"), ""))))+
  theme_classic()+
  theme(plot.title = element_text(hjust = 0.5, vjust = -10, size=8),
        axis.text.x=element_text(angle=90, size=6),
        axis.text.y=element_text(size=6),
        panel.spacing = unit(0.5, "lines"),
        strip.text.x = element_text(size = 5, margin = margin( b = 1.5, t = 1)),
        strip.background = element_rect(fill = "lightblue", colour = "black", size = 0.1)
  )+
  scale_y_continuous(expand = c(0.01,0.01), limit = c(0,1))+
  facet_grid(. ~ Archipelago, scales = "free_x", space= "free_x", switch ="x")
Pox_SNP_2862s117

Pox_SNP_1796s91 <- MAF_pox %>%
  mutate(Population = fct_relevel(Population, 
                              "GRA", "LZ", "FV", "GC", "TEID", "TF", "GOM", "LP", "EH",  "DG", "M", "PS", "SG"),
         Population = recode(Population, GRA = "GRA *", LP = "LP *", EH = "EH *", DG = "DG *", M = "M *", SG = "SG *")) %>%
  ggplot(aes(x = reorder(Population, -Pox_Prevalence), y = SNP_1796s91)) +
  geom_bar(stat="identity", width = 0.5)+
  ylab(NULL)+
  xlab(NULL)+
  ggtitle(expression(atop("1796s91", atop(italic("SMAD2"), ""))))+
  theme_classic()+
  theme(plot.title = element_text(hjust = 0.5, vjust = -10, size=8),
        axis.text.x=element_text(angle=90, size=6),
        axis.text.y=element_text(size=6),
        panel.spacing = unit(0.5, "lines"),
        strip.text.x = element_text(size = 5, margin = margin( b = 1.5, t = 1)),
        strip.background = element_rect(fill = "lightblue", colour = "black", size = 0.1)
  )+
  scale_y_continuous(expand = c(0.01,0.01), limit = c(0,1))+
  facet_grid(. ~ Archipelago, scales = "free_x", space= "free_x", switch ="x")
Pox_SNP_1796s91

Pox_SNP_3400s90 <- MAF_pox %>%
  mutate(Population = fct_relevel(Population, 
                              "GRA", "LZ", "FV", "GC", "TEID", "TF", "GOM", "LP", "EH",  "DG", "M", "PS", "SG"),
         Population = recode(Population, GRA = "GRA *", LP = "LP *", EH = "EH *", DG = "DG *", M = "M *", SG = "SG *")) %>%
  ggplot(aes(x = reorder(Population, -Pox_Prevalence), y = SNP_3400s90)) +
  geom_bar(stat="identity", width = 0.5)+
  ylab(NULL)+
  xlab(NULL)+
  ggtitle(expression(atop("3400s90", atop(italic("IQSEC1"), ""))))+
  theme_classic()+
  theme(plot.title = element_text(hjust = 0.5, vjust = -10, size=8),
        axis.text.x=element_text(angle=90, size=6),
        axis.text.y=element_text(size=6),
        panel.spacing = unit(0.5, "lines"),
        strip.text.x = element_text(size = 5, margin = margin( b = 1.5, t = 1)),
        strip.background = element_rect(fill = "lightblue", colour = "black", size = 0.1)
  )+
  scale_y_continuous(expand = c(0.01,0.01), limit = c(0,1))+
  facet_grid(. ~ Archipelago, scales = "free_x", space= "free_x", switch ="x")
Pox_SNP_3400s90 

Pox_SNP_1425s80 <- MAF_pox %>%
  mutate(Population = fct_relevel(Population, 
                              "GRA", "LZ", "FV", "GC", "TEID", "TF", "GOM", "LP", "EH",  "DG", "M", "PS", "SG"),
         Population = recode(Population, GRA = "GRA *", LP = "LP *", EH = "EH *", DG = "DG *", M = "M *", SG = "SG *")) %>%
  ggplot(aes(x = reorder(Population, -Pox_Prevalence), y = SNP_1425s80)) +
  geom_bar(stat="identity", width = 0.5)+
  ylab(NULL)+
  xlab(NULL)+
  ggtitle(expression(atop("1425s80", atop(italic(""), ""))))+
  theme_classic()+
  theme(plot.title = element_text(hjust = 0.5, vjust = -10, size=8),
        axis.text.x=element_text(angle=90, size=6),
        axis.text.y=element_text(size=6),
        panel.spacing = unit(0.5, "lines"),
        strip.text.x = element_text(size = 5, margin = margin( b = 1.5, t = 1)),
        strip.background = element_rect(fill = "lightblue", colour = "black", size = 0.1)
  )+
  scale_y_continuous(expand = c(0.01,0.01), limit = c(0,1))+
  facet_grid(. ~ Archipelago, scales = "free_x", space= "free_x", switch ="x")
Pox_SNP_1425s80

Pox_SNP_4301s71 <- MAF_pox %>%
  mutate(Population = fct_relevel(Population, 
                              "GRA", "LZ", "FV", "GC", "TEID", "TF", "GOM", "LP", "EH",  "DG", "M", "PS", "SG"),
         Population = recode(Population, GRA = "GRA *", LP = "LP *", EH = "EH *", DG = "DG *", M = "M *", SG = "SG *")) %>%
  ggplot(aes(x = reorder(Population, -Pox_Prevalence), y = SNP_4301s71)) +
  geom_bar(stat="identity", width = 0.5)+
  ylab(NULL)+
  xlab(NULL)+
  ggtitle(expression(atop("4301s71", atop(italic("OAT"), ""))))+
  theme_classic()+
  theme(plot.title = element_text(hjust = 0.5, vjust = -10, size=8),
        axis.text.x=element_text(angle=90, size=6),
        axis.text.y=element_text(size=6),
        panel.spacing = unit(0.5, "lines"),
        strip.text.x = element_text(size = 5, margin = margin( b = 1.5, t = 1)),
        strip.background = element_rect(fill = "lightblue", colour = "black", size = 0.1)
  )+
  scale_y_continuous(expand = c(0.01,0.01), limit = c(0,1))+
  facet_grid(. ~ Archipelago, scales = "free_x", space= "free_x", switch ="x")
Pox_SNP_4301s71

Pox_SNP_3439s47 <- MAF_pox %>%
  mutate(Population = fct_relevel(Population, 
                              "GRA", "LZ", "FV", "GC", "TEID", "TF", "GOM", "LP", "EH",  "DG", "M", "PS", "SG"),
         Population = recode(Population, GRA = "GRA *", LP = "LP *", EH = "EH *", DG = "DG *", M = "M *", SG = "SG *")) %>%
  ggplot(aes(x = reorder(Population, -Pox_Prevalence), y = SNP_3439s47)) +
  geom_bar(stat="identity", width = 0.5)+
  ylab(NULL)+
  xlab(NULL)+
  ggtitle(expression(atop("3439s47", atop(italic("MFSD2A / MYCL"), ""))))+
  theme_classic()+
  theme(plot.title = element_text(hjust = 0.5, vjust = -10, size=8),
        axis.text.x=element_text(angle=90, size=6),
        axis.text.y=element_text(size=6),
        panel.spacing = unit(0.5, "lines"),
        strip.text.x = element_text(size = 5, margin = margin( b = 1.5, t = 1)),
        strip.background = element_rect(fill = "lightblue", colour = "black", size = 0.1)
  )+
  scale_y_continuous(expand = c(0.01,0.01), limit = c(0,1))+
  facet_grid(. ~ Archipelago, scales = "free_x", space= "free_x", switch ="x")
Pox_SNP_3439s47

Pox_SNP_1526s83 <- MAF_pox %>%
  mutate(Population = fct_relevel(Population, 
                              "GRA", "LZ", "FV", "GC", "TEID", "TF", "GOM", "LP", "EH",  "DG", "M", "PS", "SG"),
         Population = recode(Population, GRA = "GRA *", LP = "LP *", EH = "EH *", DG = "DG *", M = "M *", SG = "SG *")) %>%
  ggplot(aes(x = reorder(Population, -Pox_Prevalence), y = SNP_1526s83)) +
  geom_bar(stat="identity", width = 0.5)+
  ylab(NULL)+
  xlab(NULL)+
  ggtitle(expression(atop("1526s83", atop(italic("AKAP13"), ""))))+
  theme_classic()+
  theme(plot.title = element_text(hjust = 0.5, vjust = -10, size=8),
        axis.text.x=element_text(angle=90, size=6),
        axis.text.y=element_text(size=6),
        panel.spacing = unit(0.5, "lines"),
        strip.text.x = element_text(size = 5, margin = margin( b = 1.5, t = 1)),
        strip.background = element_rect(fill = "lightblue", colour = "black", size = 0.1)
  )+
  scale_y_continuous(expand = c(0.01,0.01), limit = c(0,1))+
  facet_grid(. ~ Archipelago, scales = "free_x", space= "free_x", switch ="x")
Pox_SNP_1526s83

Pox_SNP_1916s23 <- MAF_pox %>%
  mutate(Population = fct_relevel(Population, 
                              "GRA", "LZ", "FV", "GC", "TEID", "TF", "GOM", "LP", "EH",  "DG", "M", "PS", "SG"),
         Population = recode(Population, GRA = "GRA *", LP = "LP *", EH = "EH *", DG = "DG *", M = "M *", SG = "SG *")) %>%
  ggplot(aes(x = reorder(Population, -Pox_Prevalence), y = SNP_1916s23)) +
  geom_bar(stat="identity", width = 0.5)+
  ylab(NULL)+
  xlab(NULL)+
  ggtitle(expression(atop("1916s23", atop(italic("CWC27"), ""))))+
  theme_classic()+
  theme(plot.title = element_text(hjust = 0.5, vjust = -10, size=8),
        axis.text.x=element_text(angle=90, size=6),
        axis.text.y=element_text(size=6),
        panel.spacing = unit(0.5, "lines"),
        strip.text.x = element_text(size = 5, margin = margin( b = 1.5, t = 1)),
        strip.background = element_rect(fill = "lightblue", colour = "black", size = 0.1)
  )+
  scale_y_continuous(expand = c(0.01,0.01), limit = c(0,1))+
  facet_grid(. ~ Archipelago, scales = "free_x", space= "free_x", switch ="x")
Pox_SNP_1916s23


y.grob <- textGrob("MAF", 
                   gp=gpar(col="black", fontsize=8), rot=90)

x.grob <- textGrob("Population", 
                   gp=gpar(col="black", fontsize=8))


Pox_One_Three_SNPs <- cowplot::plot_grid(Pox_SNP_444s109, Pox_SNP_1941s110, Pox_SNP_2177s14, labels = c("",""),
                                         nrow = 1,
                                         ncol = 3,
                                         rel_heights = c(1,1,1),
                                         rel_widths = c(1,1,1))
Pox_One_Three_SNPs


Pox_Four_Six_SNPs <- cowplot::plot_grid(Pox_SNP_909s118, Pox_SNP_1063s41, Pox_SNP_3493s67, labels = c("",""),
                                        nrow = 1,
                                        ncol = 3,
                                        rel_heights = c(1,1,1),
                                        rel_widths = c(1,1,1))
Pox_Four_Six_SNPs


Pox_Seven_Nine_SNPs <- cowplot::plot_grid(Pox_SNP_2862s117, Pox_SNP_1796s91, Pox_SNP_3400s90, labels = c("",""),
                                          nrow = 1,
                                          ncol = 3,
                                          rel_heights = c(1,1,1),
                                          rel_widths = c(1,1,1))
Pox_Seven_Nine_SNPs

Pox_Ten_Twelve_SNPs <- cowplot::plot_grid(Pox_SNP_1425s80, Pox_SNP_4301s71, Pox_SNP_3439s47, labels = c("",""),
                                          nrow = 1,
                                          ncol = 3,
                                          rel_heights = c(1,1,1),
                                          rel_widths = c(1,1,1))
Pox_Ten_Twelve_SNPs


Pox_Thirteen_Fourteen_SNPs <- cowplot::plot_grid(Pox_SNP_1526s83, Pox_SNP_1916s23, NULL, labels = c("",""),
                                                 nrow = 1,
                                                 ncol = 3,
                                                 rel_heights = c(1,1,1),
                                                 rel_widths = c(1,1,1))
Pox_Thirteen_Fourteen_SNPs



pdf("MAF_Figure4.pdf")
Pox_MAFplots <- cowplot::plot_grid(Pox_One_Three_SNPs, NULL, Pox_Four_Six_SNPs, NULL, Pox_Seven_Nine_SNPs, NULL, Pox_Ten_Twelve_SNPs, NULL, Pox_Thirteen_Fourteen_SNPs,
                                     nrow = 9,
                                     ncol = 1,
                                     rel_heights = c(1,0,1,0,1,0,1,0,1),
                                     rel_widths = c(1,1,1,1,1,1,1,1,1))


Pox_MAFplots <- grid.arrange(arrangeGrob(Pox_MAFplots, left = y.grob, bottom = x.grob))

Pox_MAFplots

dev.off()
ggsave("MAF_Figure4.pdf", plot=Pox_MAFplots, device='pdf',  height=246, width=169, units="mm", dpi=500)

