# load packages

library(tidyverse)


# Obtaining the final, single covariance matrix ---------------------------

# Read in the last matrices of the ten independent runs 
A<-read.table("matrix_single1.txt")
B<-read.table("matrix_single2.txt")
C<-read.table("matrix_single3.txt")
D<-read.table("matrix_single4.txt")
E<-read.table("matrix_single5.txt")
F<-read.table("matrix_single6.txt")
G<-read.table("matrix_single7.txt")
H<-read.table("matrix_single8.txt")
I<-read.table("matrix_single9.txt")
J<-read.table("matrix_single10.txt")

# Average the 10 matrices
my.list<-list(A,B,C,D,E,F,G,H,I,J)
meanm<-Reduce("+", my.list) / length(my.list)
write.table(meanm,"mean_matrix.txt",sep="\t",col.names=FALSE,row.names=FALSE)


# Check the equivalent correlation matrix (Table S3) -------------------------------

K = as.matrix(read.table(file="mean_matrix.txt"))
mat_cor = round(cov2cor(K),3)

upper.tri(mat_cor, diag = TRUE)
upper<-mat_cor
upper[upper.tri(mat_cor, diag=TRUE)]<-""
upper<-as.data.frame(upper)
rownames(upper) <- c("GRA", "LZ", "FV", "GC", "TF", "TEID", "GOM", "LP", "EH", "SG", "M", "PS", "DG")
colnames(upper) <- c("GRA", "LZ", "FV", "GC", "TF", "TEID", "GOM", "LP", "EH", "SG", "M", "PS", "DG")


# Calculate pox prevalence for each population (Table S4) ----------------------------

# Read in the data 
Field.data <- read_csv("Pipit_sample_information.csv")

# Correct pox status (Y? or ?) - all signs of pox lesions/scars/deformities
Field.data$Pox[Field.data$Pox=="?"] <- "Y"
Field.data$Pox[Field.data$Pox=="Y?"] <- "Y"

# Calculate pox prevalence
pox.status.counts <- count(Field.data,Pox,Population)
infected.counts <- filter(pox.status.counts, Pox == "Y")
sampled.individuals <- count(Field.data,Population) 
pox.prevalence <- left_join(sampled.individuals, infected.counts, by = c("Population"))
names(pox.prevalence)[names(pox.prevalence)=="n.x"] <- "Individuals_sampled" 
names(pox.prevalence)[names(pox.prevalence)=="n.y"] <- "Number_infected"
pox.prevalence$Pox <- NULL
pox.prevalence$Number_infected[is.na(pox.prevalence$Number_infected)] = 0 
pox.prevalence$Pox_prevalence <- (pox.prevalence$Number_infected/pox.prevalence$Individuals_sampled)*100 

# Standardise prevalence estimates 
pox.prevalence$Standardised_prevalence <- NA 
pox.prevalence$Standardised_prevalence <- scale(pox.prevalence$Pox_prevalence)


