##################################
# 8.3 Model selection based on AIC
##################################

library(ggplot2)
library(patchwork)

load(file = "BM_PC1_COR.RData")
load(file = "PG_PC1_COR.RData")
load(file = "BM_PC2_COR.RData")
load(file = "PG_PC2_COR.RData")
load(file = "BM_PC3_COR.RData")
load(file = "PG_PC3_COR.RData")
load(file = "BM_PC4_COR.RData")
load(file = "PG_PC4_COR.RData")

load(file = "BM_PC1_CONN.RData")
load(file = "PG_PC1_CONN.RData")
load(file = "BM_PC2_CONN.RData")
load(file = "PG_PC2_CONN.RData")
load(file = "BM_PC3_CONN.RData")
load(file = "PG_PC3_CONN.RData")
load(file = "BM_PC4_CONN.RData")
load(file = "PG_PC4_CONN.RData")

load(file = "BM_PC1_STYL.RData")
load(file = "PG_PC1_STYL.RData")
load(file = "BM_PC2_STYL.RData")
load(file = "PG_PC2_STYL.RData")
load(file = "BM_PC3_STYL.RData")
load(file = "PG_PC3_STYL.RData")
load(file = "BM_PC4_STYL.RData")
load(file = "PG_PC4_STYL.RData")

DAT <- data.frame(delta_AIC = c(BM_PC1_COR$aic - PG_PC1_COR$aic, 
                                BM_PC2_COR$aic - PG_PC2_COR$aic,
                                BM_PC3_COR$aic - PG_PC3_COR$aic,
                                BM_PC4_COR$aic - PG_PC4_COR$aic,
                                BM_PC1_CONN$aic - PG_PC1_CONN$aic,
                                BM_PC2_CONN$aic - PG_PC2_CONN$aic,
                                BM_PC3_CONN$aic - PG_PC3_CONN$aic,
                                BM_PC4_CONN$aic - PG_PC4_CONN$aic,
                                BM_PC1_STYL$aic - PG_PC1_STYL$aic,
                                BM_PC2_STYL$aic - PG_PC2_STYL$aic,
                                BM_PC3_STYL$aic - PG_PC3_STYL$aic,
                                BM_PC4_STYL$aic - PG_PC4_STYL$aic),
                  class = c(rep("PC1_COR", 11000),
                            rep("PC2_COR", 11000),
                            rep("PC3_COR", 11000),
                            rep("PC4_COR", 11000),
                            rep("PC1_CONN", 11000),
                            rep("PC2_CONN", 11000),
                            rep("PC3_CONN", 11000),
                            rep("PC4_CONN", 11000),
                            rep("PC1_STYL", 11000),
                            rep("PC2_STYL", 11000),
                            rep("PC3_STYL", 11000),
                            rep("PC4_STYL", 11000)),
                  trait = c(rep("corolla", 44000),
                            rep("connective", 44000),
                            rep("style", 44000)))
ggplot(DAT, aes(x = class, y = delta_AIC, fill = class)) + geom_violin() + facet_grid(trait~.)

# all differences are positive
# PAGEL MODELS ARE BETTER

#################################################
# 8.4 Distribution of contrasts and significance
#################################################

# 8.4.1 corolla. Figure S1
p.cor1 <- round(length(na.omit(PG_PC1_COR$bee_f_bird_P[PG_PC1_COR$bee_f_bird_P<0.05]))/
                  length(na.omit(PG_PC1_COR$bee_f_bird_P)), 3)
g1 <- ggplot(PG_PC1_COR, aes(bee_f_bird_coeff, fill = bee_f_bird_P<0.05)) +
  geom_histogram() +
  scale_fill_viridis_d(option = "cividis") +
  theme(legend.position = "none") +
  xlab("group 1 - group 2") + ylab("count") +
  annotate("text", x=quantile(PG_PC1_COR$bee_f_bird_coeff, 0.99, na.rm = T), 
           y=2000, label= paste(p.cor1*100, "%", sep = " "))

p.cor2 <- round(length(na.omit(PG_PC1_COR$bird_P[PG_PC1_COR$bird_P<0.05]))/
                  length(na.omit(PG_PC1_COR$bird_P)), 3)
g2 <- ggplot(PG_PC1_COR, aes(bird_coeff, fill = bird_P<0.05)) +
  geom_histogram() +
  scale_fill_viridis_d(option = "cividis") +
  theme(legend.position = "none") +
  xlab("group 1 - group 3") + ylab("count") +
  annotate("text", x=quantile(PG_PC1_COR$bird_coeff, 0.99, na.rm = T), 
           y=2000, label= paste(p.cor2*100, "%", sep = " "))

p.cor3 <- round(length(na.omit(PG_PC1_COR$inter_P[PG_PC1_COR$inter_P<0.05]))/
                  length(na.omit(PG_PC1_COR$inter_P)), 3)
g3 <- ggplot(PG_PC1_COR, aes(inter_coeff, fill = inter_P<0.05)) +
  geom_histogram() +
  scale_fill_viridis_d(option = "cividis") +
  theme(legend.position = "none") +
  xlab("group 1 - group 4") + ylab("count") +
  annotate("text", x=quantile(PG_PC1_COR$inter_coeff, 0.99, na.rm = T), 
           y=3000, label= paste(p.cor3*100, "%", sep = " "))

p.cor4 <- round(length(na.omit(PG_PC2_COR$bee_f_bird_P[PG_PC2_COR$bee_f_bird_P<0.05]))/
                  length(na.omit(PG_PC2_COR$bee_f_bird_P)), 3)
g4 <- ggplot(PG_PC2_COR, aes(bee_f_bird_coeff, fill = bee_f_bird_P<0.05)) +
  geom_histogram() +
  scale_fill_viridis_d(option = "cividis") +
  theme(legend.position = "none") +
  xlab("group 1 - group 2") + ylab("count") +
  annotate("text", x=quantile(PG_PC2_COR$bee_f_bird_coeff, 0.99, na.rm = T), 
           y=2000, label= paste(p.cor4*100, "%", sep = " "))

p.cor5 <- round(length(na.omit(PG_PC2_COR$bird_P[PG_PC2_COR$bird_P<0.05]))/
                  length(na.omit(PG_PC2_COR$bird_P)), 3)
g5 <- ggplot(PG_PC2_COR, aes(bird_coeff, fill = bird_P<0.05)) +
  geom_histogram() +
  scale_fill_viridis_d(option = "cividis") +
  theme(legend.position = "none") +
  xlab("group 1 - group 3") + ylab("count") +
  annotate("text", x=quantile(PG_PC2_COR$bird_coeff, 0.99, na.rm = T), 
           y=2000, label= paste(p.cor5*100, "%", sep = " "))

p.cor6 <- round(length(na.omit(PG_PC2_COR$inter_P[PG_PC2_COR$inter_P<0.05]))/
                  length(na.omit(PG_PC2_COR$inter_P)), 3)
g6 <- ggplot(PG_PC2_COR, aes(inter_coeff, fill = inter_P<0.05)) +
  geom_histogram() +
  scale_fill_viridis_d(option = "cividis") +
  theme(legend.position = "none") +
  xlab("group 1 - group 4") + ylab("count") +
  annotate("text", x=quantile(PG_PC2_COR$inter_coeff, 0.99, na.rm = T), 
           y=2000, label= paste(p.cor6*100, "%", sep = " "))

p.cor7 <- round(length(na.omit(PG_PC3_COR$bee_f_bird_P[PG_PC3_COR$bee_f_bird_P<0.05]))/
                  length(na.omit(PG_PC3_COR$bee_f_bird_P)), 3)
g7 <- ggplot(PG_PC3_COR, aes(bee_f_bird_coeff, fill = bee_f_bird_P<0.05)) +
  geom_histogram() +
  scale_fill_viridis_d(option = "cividis") +
  theme(legend.position = "none") +
  xlab("group 1 - group 2") + ylab("count") +
  annotate("text", x=quantile(PG_PC3_COR$bee_f_bird_coeff, 0.99, na.rm = T), 
           y=1750, label= paste(p.cor7*100, "%", sep = " "))

p.cor8 <- round(length(na.omit(PG_PC3_COR$bird_P[PG_PC3_COR$bird_P<0.05]))/
                  length(na.omit(PG_PC3_COR$bird_P)), 3)
g8 <- ggplot(PG_PC3_COR, aes(bird_coeff, fill = bird_P<0.05)) +
  geom_histogram() +
  scale_fill_viridis_d(option = "cividis") +
  theme(legend.position = "none") +
  xlab("group 1 - group 3") + ylab("count") +
  annotate("text", x=quantile(PG_PC3_COR$bird_coeff, 0.99, na.rm = T), 
           y=1750, label= paste(p.cor8*100, "%", sep = " "))

p.cor9 <- round(length(na.omit(PG_PC3_COR$inter_P[PG_PC3_COR$inter_P<0.05]))/
                  length(na.omit(PG_PC3_COR$inter_P)), 3)
g9 <- ggplot(PG_PC3_COR, aes(inter_coeff, fill = inter_P<0.05)) +
  geom_histogram() +
  scale_fill_viridis_d(option = "cividis") +
  theme(legend.position = "none") +
  xlab("group 1 - group 4") + ylab("count") +
  annotate("text", x=quantile(PG_PC3_COR$inter_coeff, 0.99, na.rm = T), 
           y=2000, label= paste(p.cor9*100, "%", sep = " "))

p.cor10 <- round(length(na.omit(PG_PC4_COR$bee_f_bird_P[PG_PC4_COR$bee_f_bird_P<0.05]))/
                  length(na.omit(PG_PC4_COR$bee_f_bird_P)), 3)
g10 <- ggplot(PG_PC4_COR, aes(bee_f_bird_coeff, fill = bee_f_bird_P<0.05)) +
  geom_histogram() +
  scale_fill_viridis_d(option = "cividis") +
  theme(legend.position = "none") +
  xlab("group 1 - group 2") + ylab("count") +
  annotate("text", x=quantile(PG_PC4_COR$bee_f_bird_coeff, 0.99, na.rm = T), 
           y=1500, label= paste(p.cor10*100, "%", sep = " "))

p.cor11 <- round(length(na.omit(PG_PC4_COR$bird_P[PG_PC4_COR$bird_P<0.05]))/
                  length(na.omit(PG_PC4_COR$bird_P)), 3)
g11 <- ggplot(PG_PC4_COR, aes(bird_coeff, fill = bird_P<0.05)) +
  geom_histogram() +
  scale_fill_viridis_d(option = "cividis") +
  theme(legend.position = "none") +
  xlab("group 1 - group 3") + ylab("count") +
  annotate("text", x=quantile(PG_PC4_COR$bird_coeff, 0.99, na.rm = T), 
           y=1750, label= paste(p.cor11*100, "%", sep = " "))

p.cor12 <- round(length(na.omit(PG_PC4_COR$inter_P[PG_PC4_COR$inter_P<0.05]))/
                  length(na.omit(PG_PC4_COR$inter_P)), 3)
g12 <- ggplot(PG_PC4_COR, aes(inter_coeff, fill = inter_P<0.05)) +
  geom_histogram() +
  scale_fill_viridis_d(option = "cividis") +
  theme(legend.position = "none") +
  xlab("group 1 - group 4") + ylab("count") +
  annotate("text", x=quantile(PG_PC4_COR$inter_coeff, 0.99, na.rm = T), 
           y=2000, label= paste(p.cor12*100, "%", sep = " "))

g12

#---------------------------------------
svg("Fig S1.svg", width = 8, heigh = 10)
(g1 + g2 + g3) / (g4 + g5 + g6) / (g7 + g8 + g9) / (g10 + g11 + g12)
dev.off()
#---------------------------------------

## 8.4.2 Connectives. Figure S2
p.con1 <- round(length(na.omit(PG_PC1_CONN$bee_f_bird_P[PG_PC1_CONN$bee_f_bird_P<0.05]))/
                  length(na.omit(PG_PC1_CONN$bee_f_bird_P)), 3)
h1 <- ggplot(PG_PC1_CONN, aes(bee_f_bird_coeff, fill = bee_f_bird_P<0.05)) +
  geom_histogram() +
  scale_fill_viridis_d(option = "cividis") +
  theme(legend.position = "none") +
  xlab("group 1 - group 2") + ylab("count") +
  annotate("text", x=quantile(PG_PC1_CONN$bee_f_bird_coeff, 0.99, na.rm = T), 
           y=4000, label= paste(p.con1*100, "%", sep = " "))

p.con2 <- round(length(na.omit(PG_PC1_CONN$bird_P[PG_PC1_CONN$bird_P<0.05]))/
                  length(na.omit(PG_PC1_CONN$bird_P)), 3)
h2 <- ggplot(PG_PC1_CONN, aes(bird_coeff, fill = bird_P<0.05)) +
  geom_histogram() +
  scale_fill_viridis_d(option = "cividis") +
  theme(legend.position = "none") +
  xlab("group 1 - group 3") + ylab("count") +
  annotate("text", x=quantile(PG_PC1_CONN$bird_coeff, 0.99, na.rm = T), 
           y=4000, label= paste(p.con2*100, "%", sep = " "))

p.con3 <- round(length(na.omit(PG_PC1_CONN$inter_P[PG_PC1_CONN$inter_P<0.05]))/
                  length(na.omit(PG_PC1_CONN$inter_P)), 3)
h3 <- ggplot(PG_PC1_CONN, aes(inter_coeff, fill = inter_P<0.05)) +
  geom_histogram() +
  scale_fill_viridis_d(option = "cividis") +
  theme(legend.position = "none") +
  xlab("group 1 - group 4") + ylab("count") +
  annotate("text", x=quantile(PG_PC1_CONN$inter_coeff, 0.99, na.rm = T), 
           y=4000, label= paste(p.con3*100, "%", sep = " "))

p.con4 <- round(length(na.omit(PG_PC2_CONN$bee_f_bird_P[PG_PC2_CONN$bee_f_bird_P<0.05]))/
                  length(na.omit(PG_PC2_CONN$bee_f_bird_P)), 3)
h4 <- ggplot(PG_PC2_CONN, aes(bee_f_bird_coeff, fill = bee_f_bird_P<0.05)) +
  geom_histogram() +
  scale_fill_viridis_d(option = "cividis") +
  theme(legend.position = "none") +
  xlab("group 1 - group 2") + ylab("count") +
  annotate("text", x=quantile(PG_PC2_CONN$bee_f_bird_coeff, 0.99, na.rm = T), 
           y=4000, label= paste(p.con4*100, "%", sep = " "))

p.con5 <- round(length(na.omit(PG_PC2_CONN$bird_P[PG_PC2_CONN$bird_P<0.05]))/
                  length(na.omit(PG_PC2_CONN$bird_P)), 3)
h5 <- ggplot(PG_PC2_CONN, aes(bird_coeff, fill = bird_P<0.05)) +
  geom_histogram() +
  scale_fill_viridis_d(option = "cividis") +
  theme(legend.position = "none") +
  xlab("group 1 - group 3") + ylab("count") +
  annotate("text", x=quantile(PG_PC2_CONN$bird_coeff, 0.99, na.rm = T), 
           y=4500, label= paste(p.con5*100, "%", sep = " "))

p.con6 <- round(length(na.omit(PG_PC2_CONN$inter_P[PG_PC2_CONN$inter_P<0.05]))/
                  length(na.omit(PG_PC2_CONN$inter_P)), 3)
h6 <- ggplot(PG_PC2_CONN, aes(inter_coeff, fill = inter_P<0.05)) +
  geom_histogram() +
  scale_fill_viridis_d(option = "cividis") +
  theme(legend.position = "none") +
  xlab("group 1 - group 4") + ylab("count") +
  annotate("text", x=quantile(PG_PC2_CONN$inter_coeff, 0.99, na.rm = T), 
           y=5500, label= paste(p.con6*100, "%", sep = " "))


p.con7 <- round(length(na.omit(PG_PC3_CONN$bee_f_bird_P[PG_PC3_CONN$bee_f_bird_P<0.05]))/
                  length(na.omit(PG_PC3_CONN$bee_f_bird_P)), 3)
h7 <- ggplot(PG_PC3_CONN, aes(bee_f_bird_coeff, fill = bee_f_bird_P<0.05)) +
  geom_histogram() +
  scale_fill_viridis_d(option = "cividis") +
  theme(legend.position = "none") +
  xlab("group 1 - group 2") + ylab("count") +
  annotate("text", x=quantile(PG_PC3_CONN$bee_f_bird_coeff, 0.99, na.rm = T), 
           y=2000, label= paste(p.con7*100, "%", sep = " "))

p.con8 <- round(length(na.omit(PG_PC3_CONN$bird_P[PG_PC3_CONN$bird_P<0.05]))/
                  length(na.omit(PG_PC3_CONN$bird_P)), 3)
h8 <- ggplot(PG_PC3_CONN, aes(bird_coeff, fill = bird_P<0.05)) +
  geom_histogram() +
  scale_fill_viridis_d(option = "cividis") +
  theme(legend.position = "none") +
  xlab("group 1 - group 3") + ylab("count") +
  annotate("text", x=quantile(PG_PC3_CONN$bird_coeff, 0.99, na.rm = T), 
           y=2500, label= paste(p.con8*100, "%", sep = " "))

p.con9 <- round(length(na.omit(PG_PC3_CONN$inter_P[PG_PC3_CONN$inter_P<0.05]))/
                  length(na.omit(PG_PC3_CONN$inter_P)), 3)
h9 <- ggplot(PG_PC3_CONN, aes(inter_coeff, fill = inter_P<0.05)) +
  geom_histogram() +
  scale_fill_viridis_d(option = "cividis") +
  theme(legend.position = "none") +
  xlab("group 1 - group 4") + ylab("count") +
  annotate("text", x=quantile(PG_PC3_CONN$inter_coeff, 0.99, na.rm = T), 
           y=2500, label= paste(p.con9*100, "%", sep = " "))

p.con10 <- round(length(na.omit(PG_PC4_CONN$bee_f_bird_P[PG_PC4_CONN$bee_f_bird_P<0.05]))/
                  length(na.omit(PG_PC4_CONN$bee_f_bird_P)), 3)
h10 <- ggplot(PG_PC4_CONN, aes(bee_f_bird_coeff, fill = bee_f_bird_P<0.05)) +
  geom_histogram() +
  scale_fill_viridis_d(option = "cividis") +
  theme(legend.position = "none") +
  xlab("group 1 - group 2") + ylab("count") +
  annotate("text", x=quantile(PG_PC3_CONN$bee_f_bird_coeff, 0.99, na.rm = T), 
           y=1250, label= paste(p.con10*100, "%", sep = " "))

p.con11 <- round(length(na.omit(PG_PC4_CONN$bird_P[PG_PC4_CONN$bird_P<0.05]))/
                  length(na.omit(PG_PC4_CONN$bird_P)), 3)
h11 <- ggplot(PG_PC4_CONN, aes(bird_coeff, fill = bird_P<0.05)) +
  geom_histogram() +
  scale_fill_viridis_d(option = "cividis") +
  theme(legend.position = "none") +
  xlab("group 1 - group 3") + ylab("count") +
  annotate("text", x=quantile(PG_PC4_CONN$bird_coeff, 0.99, na.rm = T), 
           y=1750, label= paste(p.con11*100, "%", sep = " "))

p.con12 <- round(length(na.omit(PG_PC4_CONN$inter_P[PG_PC4_CONN$inter_P<0.05]))/
                  length(na.omit(PG_PC4_CONN$inter_P)), 3)
h12 <- ggplot(PG_PC4_CONN, aes(inter_coeff, fill = inter_P<0.05)) +
  geom_histogram() +
  scale_fill_viridis_d(option = "cividis") +
  theme(legend.position = "none") +
  xlab("group 1 - group 4") + ylab("count") +
  annotate("text", x=quantile(PG_PC4_CONN$inter_coeff, 0.99, na.rm = T), 
           y=2000, label= paste(p.con12*100, "%", sep = " "))
h12


#---------------------------------------
svg("Fig S2.svg", width = 8, heigh = 10)
(h1 + h2 + h3) / (h4 + h5 + h6) / (h7 + h8 + h9) / (h10 + h11 + h12)
dev.off()
#---------------------------------------

# 8.4.3 Style. Figure S3
p.sty1 <- round(length(na.omit(PG_PC1_STYL$bee_f_bird_P[PG_PC1_STYL$bee_f_bird_P<0.05]))/
                  length(na.omit(PG_PC1_STYL$bee_f_bird_P)), 3)
i1 <- ggplot(PG_PC1_STYL, aes(bee_f_bird_coeff, fill = bee_f_bird_P<0.05)) +
  geom_histogram() +
  scale_fill_viridis_d(option = "cividis") +
  theme(legend.position = "none") +
  xlab("group 1 - group 2") + ylab("count") +
  annotate("text", x=quantile(PG_PC1_STYL$bee_f_bird_coeff, 0.99, na.rm = T), 
           y=1500, label= paste(p.sty1*100, "%", sep = " "))

p.sty2 <- round(length(na.omit(PG_PC1_STYL$bird_P[PG_PC1_STYL$bird_P<0.05]))/
                  length(na.omit(PG_PC1_STYL$bird_P)), 3)
i2 <- ggplot(PG_PC1_STYL, aes(bird_coeff, fill = bird_P<0.05)) +
  geom_histogram() +
  scale_fill_viridis_d(option = "cividis") +
  theme(legend.position = "none") +
  xlab("group 1 - group 3") + ylab("count") +
  annotate("text", x=quantile(PG_PC1_STYL$bird_coeff, 0.99, na.rm = T), 
           y=2000, label= paste(p.sty2*100, "%", sep = " "))

p.sty3 <- round(length(na.omit(PG_PC1_STYL$inter_P[PG_PC1_STYL$inter_P<0.05]))/
                  length(na.omit(PG_PC1_STYL$inter_P)), 3)
i3 <- ggplot(PG_PC1_STYL, aes(inter_coeff, fill = inter_P<0.05)) +
  geom_histogram() +
  scale_fill_viridis_d(option = "cividis") +
  theme(legend.position = "none") +
  xlab("group 1 - group 4") + ylab("count") +
  annotate("text", x=quantile(PG_PC1_STYL$inter_coeff, 0.99, na.rm = T), 
           y=2000, label= paste(p.sty3*100, "%", sep = " "))

p.sty4 <- round(length(na.omit(PG_PC2_STYL$bee_f_bird_P[PG_PC2_STYL$bee_f_bird_P<0.05]))/
                  length(na.omit(PG_PC2_STYL$bee_f_bird_P)), 3)
i4 <- ggplot(PG_PC2_STYL, aes(bee_f_bird_coeff, fill = bee_f_bird_P<0.05)) +
  geom_histogram() +
  scale_fill_viridis_d(option = "cividis") +
  theme(legend.position = "none") +
  xlab("group 1 - group 2") + ylab("count") +
  annotate("text", x=quantile(PG_PC2_STYL$bee_f_bird_coeff, 0.99, na.rm = T), 
           y=2500, label= paste(p.sty4*100, "%", sep = " "))

p.sty5 <- round(length(na.omit(PG_PC2_STYL$bird_P[PG_PC2_STYL$bird_P<0.05]))/
                  length(na.omit(PG_PC2_STYL$bird_P)), 3)
i5 <- ggplot(PG_PC2_STYL, aes(bird_coeff, fill = bird_P<0.05)) +
  geom_histogram() +
  scale_fill_viridis_d(option = "cividis") +
  theme(legend.position = "none") +
  xlab("group 1 - group 3") + ylab("count") +
  annotate("text", x=quantile(PG_PC2_STYL$bird_coeff, 0.99, na.rm = T), 
           y=2500, label= paste(p.sty5*100, "%", sep = " "))

p.sty6 <- round(length(na.omit(PG_PC2_STYL$inter_P[PG_PC2_STYL$inter_P<0.05]))/
                  length(na.omit(PG_PC2_STYL$inter_P)), 3)
i6 <- ggplot(PG_PC2_STYL, aes(inter_coeff, fill = inter_P<0.05)) +
  geom_histogram() +
  scale_fill_viridis_d(option = "cividis") +
  theme(legend.position = "none") +
  xlab("group 1 - group 4") + ylab("count") +
  annotate("text", x=quantile(PG_PC2_STYL$inter_coeff, 0.99, na.rm = T), 
           y=3500, label= paste(p.sty6*100, "%", sep = " "))

p.sty7 <- round(length(na.omit(PG_PC3_STYL$bee_f_bird_P[PG_PC3_STYL$bee_f_bird_P<0.05]))/
                  length(na.omit(PG_PC3_STYL$bee_f_bird_P)), 3)
i7 <- ggplot(PG_PC3_STYL, aes(bee_f_bird_coeff, fill = bee_f_bird_P<0.05)) +
  geom_histogram() +
  scale_fill_viridis_d(option = "cividis") +
  theme(legend.position = "none") +
  xlab("group 1 - group 2") + ylab("count") +
  annotate("text", x=quantile(PG_PC3_STYL$bee_f_bird_coeff, 0.99, na.rm = T), 
           y=3000, label= paste(p.sty7*100, "%", sep = " "))

p.sty8 <- round(length(na.omit(PG_PC3_STYL$bird_P[PG_PC3_STYL$bird_P<0.05]))/
                  length(na.omit(PG_PC3_STYL$bird_P)), 3)
i8 <- ggplot(PG_PC3_STYL, aes(bird_coeff, fill = bird_P<0.05)) +
  geom_histogram() +
  scale_fill_viridis_d(option = "cividis") +
  theme(legend.position = "none") +
  xlab("group 1 - group 3") + ylab("count") +
  annotate("text", x=quantile(PG_PC3_STYL$bird_coeff, 0.99, na.rm = T), 
           y=3000, label= paste(p.sty8*100, "%", sep = " "))

p.sty9 <- round(length(na.omit(PG_PC3_STYL$inter_P[PG_PC3_STYL$inter_P<0.05]))/
                  length(na.omit(PG_PC3_STYL$inter_P)), 3)
i9 <- ggplot(PG_PC3_STYL, aes(inter_coeff, fill = inter_P<0.05)) +
  geom_histogram() +
  scale_fill_viridis_d(option = "cividis") +
  theme(legend.position = "none") +
  xlab("group 1 - group 4") + ylab("count") +
  annotate("text", x=quantile(PG_PC3_STYL$inter_coeff, 0.99, na.rm = T), 
           y=3500, label= paste(p.sty9*100, "%", sep = " "))

p.sty10 <- round(length(na.omit(PG_PC4_STYL$bee_f_bird_P[PG_PC4_STYL$bee_f_bird_P<0.05]))/
                  length(na.omit(PG_PC4_STYL$bee_f_bird_P)), 3)
i10 <- ggplot(PG_PC4_STYL, aes(bee_f_bird_coeff, fill = bee_f_bird_P<0.05)) +
  geom_histogram() +
  scale_fill_viridis_d(option = "cividis") +
  theme(legend.position = "none") +
  xlab("group 1 - group 2") + ylab("count") +
  annotate("text", x=quantile(PG_PC4_STYL$bee_f_bird_coeff, 0.99, na.rm = T), 
           y=1500, label= paste(p.sty10*100, "%", sep = " "))

p.sty11 <- round(length(na.omit(PG_PC4_STYL$bird_P[PG_PC4_STYL$bird_P<0.05]))/
                  length(na.omit(PG_PC4_STYL$bird_P)), 3)
i11 <- ggplot(PG_PC4_STYL, aes(bird_coeff, fill = bird_P<0.05)) +
  geom_histogram() +
  scale_fill_viridis_d(option = "cividis") +
  theme(legend.position = "none") +
  xlab("group 1 - group 3") + ylab("count") +
  annotate("text", x=quantile(PG_PC4_STYL$bird_coeff, 0.99, na.rm = T), 
           y=1500, label= paste(p.sty11*100, "%", sep = " "))

p.sty12 <- round(length(na.omit(PG_PC4_STYL$inter_P[PG_PC4_STYL$inter_P<0.05]))/
                  length(na.omit(PG_PC4_STYL$inter_P)), 3)
i12 <- ggplot(PG_PC4_STYL, aes(inter_coeff, fill = inter_P<0.05)) +
  geom_histogram() +
  scale_fill_viridis_d(option = "cividis") +
  theme(legend.position = "none") +
  xlab("group 1 - group 4") + ylab("count") +
  annotate("text", x=quantile(PG_PC4_STYL$inter_coeff, 0.99, na.rm = T), 
           y=2500, label= paste(p.sty12*100, "%", sep = " "))

#---------------------------------------
svg("Fig S3.svg", width = 8, heigh = 10)
(i1 + i2 + i3) / (i4 + i5 + i6) / (i7 + i8 + i9) / (i10 + i11 + i12)
dev.off()
#---------------------------------------

##################################################
# 8.5 Average values obtained from PGLS contrasts
##################################################

# 8.5.1 Corolla PC1. 
N <- nrow(PG_PC1_COR)
cor1 <-data.frame(mean.values = c(PG_PC1_COR$bee_f_bee_coeff,
                                  PG_PC1_COR$bee_f_bee_coeff + PG_PC1_COR$bee_f_bird_coeff,
                                  PG_PC1_COR$bee_f_bee_coeff + PG_PC1_COR$bird_coeff,
                                  PG_PC1_COR$bee_f_bee_coeff + PG_PC1_COR$inter_coeff), 
                  class = c(rep("bee from bee", N), rep("bee from bird", N), 
                            rep("bird", N), rep("polymorphic", N)))
g1 <- ggplot(cor1, aes(x = class, y = mean.values)) + geom_violin(aes(fill = class)) +
  theme_linedraw() + xlab("group") + ylab("PC1 corolla") +
  scale_fill_viridis_d(option = "magma")+ 
  theme(axis.text.x=element_text(angle=90,hjust=1), legend.position = "none")
g1

# 8.5.2 Corolla PC2. 
cor2 <-data.frame(mean.values = c(PG_PC2_COR$bee_f_bee_coeff,
                                  PG_PC2_COR$bee_f_bee_coeff + PG_PC2_COR$bee_f_bird_coeff,
                                  PG_PC2_COR$bee_f_bee_coeff + PG_PC2_COR$bird_coeff,
                                  PG_PC2_COR$bee_f_bee_coeff + PG_PC2_COR$inter_coeff), 
                  class = c(rep("bee from bee", N), rep("bee from bird", N), 
                            rep("bird", N), rep("polymorphic", N)))
g2 <- ggplot(cor2, aes(x = class, y = mean.values)) + geom_violin(aes(fill = class)) +
  theme_linedraw() + xlab("group") + ylab("PC2 corolla") +
  scale_fill_viridis_d(option = "magma") + 
  theme(axis.text.x=element_text(angle=90,hjust=1), legend.position = "none")
g2

# 8.5.3 Connectives PC1. 
conn1 <-data.frame(mean.values = c(PG_PC1_CONN$bee_f_bee_coeff,
                                   PG_PC1_CONN$bee_f_bee_coeff + PG_PC1_CONN$bee_f_bird_coeff,
                                   PG_PC1_CONN$bee_f_bee_coeff + PG_PC1_CONN$bird_coeff,
                                   PG_PC1_CONN$bee_f_bee_coeff + PG_PC1_CONN$inter_coeff), 
                   class = c(rep("bee from bee", N), rep("bee from bird", N), 
                             rep("bird", N), rep("polymorphic", N)))
g3 <- ggplot(conn1, aes(x = class, y = mean.values)) + geom_violin(aes(fill = class)) +
  theme_linedraw() + xlab("group") + ylab("PC1 connectives") +
  scale_fill_viridis_d(option = "magma") + 
  theme(axis.text.x=element_text(angle=90,hjust=1), legend.position = "none")
g3

# 8.5.4 Connectives PC2. 
conn2 <-data.frame(mean.values = c(PG_PC2_CONN$bee_f_bee_coeff,
                                   PG_PC2_CONN$bee_f_bee_coeff + PG_PC2_CONN$bee_f_bird_coeff,
                                   PG_PC2_CONN$bee_f_bee_coeff + PG_PC2_CONN$bird_coeff,
                                   PG_PC2_CONN$bee_f_bee_coeff + PG_PC2_CONN$inter_coeff), 
                   class = c(rep("bee from bee", N), rep("bee from bird", N), 
                             rep("bird", N), rep("polymorphic", N)))
g4 <- ggplot(conn2, aes(x = class, y = mean.values)) + geom_violin(aes(fill = class)) +
  theme_linedraw() + xlab("group") + ylab("PC2 connectives") +
  scale_fill_viridis_d(option = "magma") + 
  theme(axis.text.x=element_text(angle=90,hjust=1), legend.position = "none")
g4

# 8.5.5 Style PC1. 
styl1 <-data.frame(mean.values = c(PG_PC1_STYL$bee_f_bee_coeff,
                                   PG_PC1_STYL$bee_f_bee_coeff + PG_PC1_STYL$bee_f_bird_coeff,
                                   PG_PC1_STYL$bee_f_bee_coeff + PG_PC1_STYL$bird_coeff,
                                   PG_PC1_STYL$bee_f_bee_coeff + PG_PC1_STYL$inter_coeff), 
                   class = c(rep("bee from bee", N), rep("bee from bird", N), 
                             rep("bird", N), rep("polymorphic", N)))
g5 <- ggplot(styl1, aes(x = class, y = mean.values)) + geom_violin(aes(fill = class)) +
  theme_linedraw() + xlab("group") + ylab("PC1 style") +
  scale_fill_viridis_d(option = "magma")+ 
  theme(axis.text.x=element_text(angle=90,hjust=1), legend.position = "none")
g5

# 8.5.6 Style PC2. Figure 3 L
styl2 <-data.frame(mean.values = c(PG_PC2_STYL$bee_f_bee_coeff,
                                   PG_PC2_STYL$bee_f_bee_coeff + PG_PC2_STYL$bee_f_bird_coeff,
                                   PG_PC2_STYL$bee_f_bee_coeff + PG_PC2_STYL$bird_coeff,
                                   PG_PC2_STYL$bee_f_bee_coeff + PG_PC2_STYL$inter_coeff), 
                   class = c(rep("bee from bee", N), rep("bee from bird", N), 
                             rep("bird", N), rep("polymorphic", N)))
g6 <- ggplot(styl2, aes(x = class, y = mean.values)) + geom_violin(aes(fill = class)) +
  theme_linedraw() + xlab("group") + ylab("PC2 style") +
  scale_fill_viridis_d(option = "magma") + 
  theme(axis.text.x=element_text(angle=90,hjust=1), legend.position = "none")
g6

#-----------------------------------------
svg("pgls.svg", width = 7.5, height = 5)
(g1 | g3 | g5)  / (g2 | g4 | g6)
dev.off()
#-----------------------------------------

#### PC3 and PC4 for supplementary material

# 8.5.7 Corolla PC3. 
N <- nrow(PG_PC3_COR)
cor3 <-data.frame(mean.values = c(PG_PC3_COR$bee_f_bee_coeff,
                                  PG_PC3_COR$bee_f_bee_coeff + PG_PC3_COR$bee_f_bird_coeff,
                                  PG_PC3_COR$bee_f_bee_coeff + PG_PC3_COR$bird_coeff,
                                  PG_PC3_COR$bee_f_bee_coeff + PG_PC3_COR$inter_coeff), 
                  class = c(rep("bee from bee", N), rep("bee from bird", N), 
                            rep("bird", N), rep("polymorphic", N)))
g7 <- ggplot(cor3, aes(x = class, y = mean.values)) + geom_violin(aes(fill = class)) +
  theme_linedraw() + xlab("group") + ylab("PC3 corolla") +
  scale_fill_viridis_d(option = "magma")+ 
  theme(axis.text.x=element_text(angle=90,hjust=1), legend.position = "none")
g7

# 8.5.8 Corolla PC4. 
cor4 <-data.frame(mean.values = c(PG_PC4_COR$bee_f_bee_coeff,
                                  PG_PC4_COR$bee_f_bee_coeff + PG_PC4_COR$bee_f_bird_coeff,
                                  PG_PC4_COR$bee_f_bee_coeff + PG_PC4_COR$bird_coeff,
                                  PG_PC4_COR$bee_f_bee_coeff + PG_PC4_COR$inter_coeff), 
                  class = c(rep("bee from bee", N), rep("bee from bird", N), 
                            rep("bird", N), rep("polymorphic", N)))
g8 <- ggplot(cor4, aes(x = class, y = mean.values)) + geom_violin(aes(fill = class)) +
  theme_linedraw() + xlab("group") + ylab("PC4 corolla") +
  scale_fill_viridis_d(option = "magma") + 
  theme(axis.text.x=element_text(angle=90,hjust=1), legend.position = "none")
g8

# 8.5.9 Connectives PC3. 
conn3 <-data.frame(mean.values = c(PG_PC3_CONN$bee_f_bee_coeff,
                                   PG_PC3_CONN$bee_f_bee_coeff + PG_PC3_CONN$bee_f_bird_coeff,
                                   PG_PC3_CONN$bee_f_bee_coeff + PG_PC3_CONN$bird_coeff,
                                   PG_PC3_CONN$bee_f_bee_coeff + PG_PC3_CONN$inter_coeff), 
                   class = c(rep("bee from bee", N), rep("bee from bird", N), 
                             rep("bird", N), rep("polymorphic", N)))
g9 <- ggplot(conn3, aes(x = class, y = mean.values)) + geom_violin(aes(fill = class)) +
  theme_linedraw() + xlab("group") + ylab("PC3 connectives") +
  scale_fill_viridis_d(option = "magma") + 
  theme(axis.text.x=element_text(angle=90,hjust=1), legend.position = "none")
g9

# 8.5.10 Connectives PC4. 
conn4 <-data.frame(mean.values = c(PG_PC4_CONN$bee_f_bee_coeff,
                                   PG_PC4_CONN$bee_f_bee_coeff + PG_PC4_CONN$bee_f_bird_coeff,
                                   PG_PC4_CONN$bee_f_bee_coeff + PG_PC4_CONN$bird_coeff,
                                   PG_PC4_CONN$bee_f_bee_coeff + PG_PC4_CONN$inter_coeff), 
                   class = c(rep("bee from bee", N), rep("bee from bird", N), 
                             rep("bird", N), rep("polymorphic", N)))
g10 <- ggplot(conn4, aes(x = class, y = mean.values)) + geom_violin(aes(fill = class)) +
  theme_linedraw() + xlab("group") + ylab("PC4 connectives") +
  scale_fill_viridis_d(option = "magma") + 
  theme(axis.text.x=element_text(angle=90,hjust=1), legend.position = "none")
g10

# 8.5.11 Style PC3. 
styl3 <-data.frame(mean.values = c(PG_PC3_STYL$bee_f_bee_coeff,
                                   PG_PC3_STYL$bee_f_bee_coeff + PG_PC3_STYL$bee_f_bird_coeff,
                                   PG_PC3_STYL$bee_f_bee_coeff + PG_PC3_STYL$bird_coeff,
                                   PG_PC3_STYL$bee_f_bee_coeff + PG_PC3_STYL$inter_coeff), 
                   class = c(rep("bee from bee", N), rep("bee from bird", N), 
                             rep("bird", N), rep("polymorphic", N)))
g11 <- ggplot(styl3, aes(x = class, y = mean.values)) + geom_violin(aes(fill = class)) +
  theme_linedraw() + xlab("group") + ylab("PC3 style") +
  scale_fill_viridis_d(option = "magma")+ 
  theme(axis.text.x=element_text(angle=90,hjust=1), legend.position = "none")
g11

# 8.5.12 Style PC4. 
styl4 <-data.frame(mean.values = c(PG_PC4_STYL$bee_f_bee_coeff,
                                   PG_PC4_STYL$bee_f_bee_coeff + PG_PC4_STYL$bee_f_bird_coeff,
                                   PG_PC4_STYL$bee_f_bee_coeff + PG_PC4_STYL$bird_coeff,
                                   PG_PC4_STYL$bee_f_bee_coeff + PG_PC4_STYL$inter_coeff), 
                   class = c(rep("bee from bee", N), rep("bee from bird", N), 
                             rep("bird", N), rep("polymorphic", N)))
g12 <- ggplot(styl4, aes(x = class, y = mean.values)) + geom_violin(aes(fill = class)) +
  theme_linedraw() + xlab("group") + ylab("PC4 style") +
  scale_fill_viridis_d(option = "magma") + 
  theme(axis.text.x=element_text(angle=90,hjust=1), legend.position = "none")
g12

#-----------------------------------------
svg("pgls_SUP.svg", width = 7.5, height = 5)
(g7 | g9 | g11)  / (g8 | g10 | g12)
dev.off()
#-----------------------------------------
