################################
# 8. Phylogenetic least squares
################################

library(ape)
library(geiger)
library(nlme)
library(beepr)
library(dplyr)
library(ggplot2)

###################
# 8.1 Data loading
###################

all_salvia <- read.csv("Salvia_flower_evol_May2020/Data/groups.csv", header=T)[, c("pollinator", "species")]
salvia_sp <- subset(all_salvia[, c("species", "pollinator")], all_salvia$pollinator != "sister")

load("pca_data.RData")
corolla_data <- as.data.frame(pca_corolla_sideview$x[, 1:10])
corolla_data$species <- row.names(corolla_data)
corolla_data <- merge(corolla_data, salvia_sp, by = "species")

connectives_data <- as.data.frame(pca_connectives$x[, 1:10])
connectives_data$species <- row.names(connectives_data)
connectives_data <- merge(connectives_data, salvia_sp, by = "species")

styles_data <- as.data.frame(pca_styles$x[, 1:10])
styles_data$species <- row.names(styles_data)
styles_data <- merge(styles_data, salvia_sp, by = "species")

# load trees
TREES <- list()
TREES[[1]] <- read.tree("Salvia_flower_evol_May2020/Phylogeny/Beast_Yule_MCC_newick.tre")
TREES[[2]] <- read.tree("Salvia_flower_evol_May2020/Phylogeny/tree_cluster_1.tre")
TREES[[3]] <- read.tree("Salvia_flower_evol_May2020/Phylogeny/tree_cluster_2.tre")
TREES[[4]] <- read.tree("Salvia_flower_evol_May2020/Phylogeny/tree_cluster_3.tre")
TREES[[5]] <- read.tree("Salvia_flower_evol_May2020/Phylogeny/tree_cluster_4.tre")
TREES[[6]] <- read.tree("Salvia_flower_evol_May2020/Phylogeny/tree_cluster_5.tre")
TREES[[7]] <- read.tree("Salvia_flower_evol_May2020/Phylogeny/tree_cluster_6.tre")
TREES[[8]] <- read.tree("Salvia_flower_evol_May2020/Phylogeny/tree_cluster_7.tre")
TREES[[9]] <- read.tree("Salvia_flower_evol_May2020/Phylogeny/tree_cluster_8.tre")
TREES[[10]] <- read.tree("Salvia_flower_evol_May2020/Phylogeny/tree_cluster_9.tre")
TREES[[11]] <- read.tree("Salvia_flower_evol_May2020/Phylogeny/tree_cluster_10.tre")

# load origins in each tree
#load("results_simmap&origin_mcc.RData"); rm(CLASSIF, simmap_mcctree, origins_mcc_01)
load("results_simmap_origin_t01.RData")
load("results_simmap_origin_t02.RData")
load("results_simmap_origin_t03.RData")
load("results_simmap_origin_t04.RData")
load("results_simmap_origin_t05.RData")
load("results_simmap_origin_t06.RData")
load("results_simmap_origin_t07.RData")
load("results_simmap_origin_t08.RData")
load("results_simmap_origin_t09.RData")
load("results_simmap_origin_t10.RData")
load("results_simmap_origin_t11.RData")

rm(origins_01, origins_02, origins_03, origins_04, origins_05, origins_06, 
   origins_07, origins_08, origins_09, origins_10, origins_11)
rm(simmap_t01, simmap_t02, simmap_t03, simmap_t04, simmap_t05, simmap_t06, 
   simmap_t07, simmap_t08, simmap_t09, simmap_t10, simmap_t11)
gc()

origins_t01$species <- rownames(origins_t01); origins_t02$species <- rownames(origins_t02) 
origins_t03$species <- rownames(origins_t03); origins_t04$species <- rownames(origins_t04)
origins_t05$species <- rownames(origins_t05); origins_t06$species <- rownames(origins_t06)
origins_t07$species <- rownames(origins_t07); origins_t08$species <- rownames(origins_t08)
origins_t09$species <- rownames(origins_t09); origins_t10$species <- rownames(origins_t10)
origins_t11$species <- rownames(origins_t11)

ORIGINS <- list(origins_t01, origins_t02, origins_t03, origins_t04, origins_t05, origins_t06, 
                origins_t07, origins_t08, origins_t09, origins_t10, origins_t11)

rm(origins_t01, origins_t02, origins_t03, origins_t04, origins_t05, origins_t06, 
   origins_t07, origins_t08, origins_t09, origins_t10, origins_t11)
gc()

######################
# 8.1.bis sample sizes
######################

# required functions
pgls_sample_size <- function(tree, data, origin, response){
  SP <- left_join(data.frame(species = data[, "species"]), 
                  data.frame(species = origin[, "species"]),
                  by = c("species" = "species"))
  rownames(SP) <- SP$species
  ntd <- name.check(tree, SP)
  tree <- drop.tip(tree, ntd$tree_not_data)
  ss_res <- vector(mode="list", ncol(origin)-1)
  for(i in 1:(ncol(origin)-1)){
    reduc_origins <- origin[, c(i, which(colnames(origin)=="species"))]
    colnames(reduc_origins) <- c("states", "species")
    prueba <- merge(reduc_origins, data, by = "species")
    prueba$pollinator2 <- prueba$pollinator
    prueba$pollinator2[prueba$pollinator == "bee" & prueba$states == "from_bee"] <- "bee_from_bee"
    prueba$pollinator2[prueba$pollinator == "bee" & prueba$states == "from_bird"] <- "bee_from_bird"
    prueba$pollinator2 <- as.factor(prueba$pollinator2)
    rownames(prueba) <- prueba$species
    if(length(unique(prueba$pollinator2)) < 4) ss_res[[i]] <- rep(NA, 4) else{
       ss_res[[i]] <- summary(prueba$pollinator2)
    }
  }
  ss_res <- do.call(rbind.data.frame, ss_res)
  colnames(ss_res) <- c("bee_f_bee", "bee_f_bird", "bird", "inter")
  return(ss_res)
}

# 8.1.bis.1 sample size corolla 
SS_PC1_COR <- vector(mode = "list", 11)
for(i in 1:11) SS_PC1_COR[[i]] <- pgls_sample_size(tree = TREES[[i]], data = corolla_data, 
                                             origin = ORIGINS[[i]], response = "PC1")
SS_PC1_COR <- do.call(rbind.data.frame, SS_PC1_COR)

mean(SS_PC1_COR$bee_f_bee, na.rm = TRUE)
sd(SS_PC1_COR$bee_f_bee, na.rm = TRUE)

mean(SS_PC1_COR$bee_f_bird, na.rm = TRUE)
sd(SS_PC1_COR$bee_f_bird, na.rm = TRUE)

# 8.1.bis.2 sample size connectives
SS_PC1_CON <- vector(mode = "list", 11)
for(i in 1:11) SS_PC1_CON[[i]] <- pgls_sample_size(tree = TREES[[i]], data = connectives_data, 
                                                   origin = ORIGINS[[i]], response = "PC1")
SS_PC1_CON <- do.call(rbind.data.frame, SS_PC1_CON)

mean(SS_PC1_CON$bee_f_bee, na.rm = TRUE)
sd(SS_PC1_CON$bee_f_bee, na.rm = TRUE)

mean(SS_PC1_CON$bee_f_bird, na.rm = TRUE)
sd(SS_PC1_CON$bee_f_bird, na.rm = TRUE)

# 8.1.bis.3 sample size style
SS_PC1_STY <- vector(mode = "list", 11)
for(i in 1:11) SS_PC1_STY[[i]] <- pgls_sample_size(tree = TREES[[i]], data = styles_data,
                                                   origin = ORIGINS[[i]], response = "PC1")
SS_PC1_STY <- do.call(rbind.data.frame, SS_PC1_STY)

mean(SS_PC1_STY$bee_f_bee, na.rm = TRUE)
sd(SS_PC1_STY$bee_f_bee, na.rm = TRUE)

mean(SS_PC1_STY$bee_f_bird, na.rm = TRUE)
sd(SS_PC1_STY$bee_f_bird, na.rm = TRUE)

#############################################
# 8.2 Phylogenetic Generalized Least Squares
#############################################

# required functions
pgls_pagel <- function(tree, data, origin, response, 
                       formula = as.formula(paste(response, "pollinator2", sep  = " ~ "))){
  
 # tree <- TREES[[1]]
 # data <- styles_data
  #origin <- ORIGINS[[1]][c(46, 1001)]
#  formula = as.formula(paste("PC3", "pollinator2", sep  = " ~ "))
  
  
  SP <- left_join(data.frame(species = data[, "species"]), 
                  data.frame(species = origin[, "species"]),
                  by = c("species" = "species"))
  rownames(SP) <- SP$species
  ntd <- name.check(tree, SP)
  tree <- drop.tip(tree, ntd$tree_not_data)
  pagel_res <- vector(mode="list", ncol(origin)-1)
  for(i in 1:(ncol(origin)-1)){
    reduc_origins <- origin[, c(i, which(colnames(origin)=="species"))]
    colnames(reduc_origins) <- c("states", "species")
    prueba <- merge(reduc_origins, data, by = "species")
    prueba$pollinator2 <- prueba$pollinator
    prueba$pollinator2[prueba$pollinator == "bee" & prueba$states == "from_bee"] <- "bee_from_bee"
    prueba$pollinator2[prueba$pollinator == "bee" & prueba$states == "from_bird"] <- "bee_from_bird"
    prueba$pollinator2 <- as.factor(prueba$pollinator2)
    rownames(prueba) <- prueba$species
    if(length(unique(prueba$pollinator2)) < 4) pagel_res[[i]] <- rep(NA, 13) else{
      pgls_pa <- try(gls(formula, data = prueba, correlation = corPagel(1, phy=tree, form =~species)), silent = TRUE)
      if(class(pgls_pa) == "try-error") pagel_res[[i]] <- rep(NA, 13) else{
      pagel_res[[i]] <- c(pgls_pa$coefficients, summary(pgls_pa)$tTable[, "Std.Error"],
                          summary(pgls_pa)$tTable[, "p-value"], summary(pgls_pa)$AIC)
      }
    }
  }
  pagel_res <- do.call(rbind.data.frame, pagel_res)
  colnames(pagel_res) <- c(paste(rep(c("bee_f_bee", "bee_f_bird", "bird", "inter"), 3),
                                 c(rep("coeff", 4), rep("SE", 4), rep("P", 4)), sep = "_"),"aic") 
  return(pagel_res)
}


pgls_bm <- function(tree, data, origin, response,
                    formula = as.formula(paste(response, "pollinator2", sep  = " ~ "))){
  SP <- left_join(data.frame(species = data[, "species"]), 
                  data.frame(species = origin[, "species"]),
                  by = c("species" = "species"))
  rownames(SP) <- SP$species
  ntd <- name.check(tree, SP)
  tree <- drop.tip(tree, ntd$tree_not_data)
  bm_res <- vector(mode="list", ncol(origin)-1)
  for(i in 1:(ncol(origin)-1)){
    reduc_origins <- origin[, c(i, which(colnames(origin)=="species"))]
    colnames(reduc_origins) <- c("states", "species")
    prueba <- merge(reduc_origins, data, by = "species")
    prueba$pollinator2 <- prueba$pollinator
    prueba$pollinator2[prueba$pollinator == "bee" & prueba$states == "from_bee"] <- "bee_from_bee"
    prueba$pollinator2[prueba$pollinator == "bee" & prueba$states == "from_bird"] <- "bee_from_bird"
    prueba$pollinator2 <- as.factor(prueba$pollinator2)
    rownames(prueba) <- prueba$species
    if(length(unique(prueba$pollinator2)) < 4) bm_res[[i]] <- rep(NA, 13) else{
      pgls_bm <- gls(formula, data = prueba, correlation = corBrownian(1, phy=tree, form =~species))
      bm_res[[i]] <- c(pgls_bm$coefficients, summary(pgls_bm)$tTable[, "Std.Error"],
                       summary(pgls_bm)$tTable[, "p-value"], summary(pgls_bm)$AIC)
    }
  }
  bm_res <- do.call(rbind.data.frame, bm_res)
  colnames(bm_res) <- c(paste(rep(c("bee_f_bee", "bee_f_bird", "bird", "inter"), 3),
                              c(rep("coeff", 4), rep("SE", 4), rep("P", 4)), sep = "_"),"aic") 
  return(bm_res)
}

#----------------------------------------------------------
# WARNING. Each section involves fitting 11000 PGLS models.
# THIS COULD TAKE A WHILE
#----------------------------------------------------------

# 8.2.1 PGLS PAGEL MCC tree PC1 corolla
PG_PC1_COR <- vector(mode = "list", 11)
for(i in 1:11) PG_PC1_COR[[i]] <- pgls_pagel(tree = TREES[[i]], data = corolla_data, 
                                             origin = ORIGINS[[i]], response = "PC1")
PG_PC1_COR <- do.call(rbind.data.frame, PG_PC1_COR)
save(PG_PC1_COR, file = "PG_PC1_COR.RData")
rm(PG_PC1_COR); gc()
beep(5)

# 8.2.2 PGLS PAGEL MCC tree PC2 corolla
PG_PC2_COR <- vector(mode = "list", 11)
for(i in 1:11) PG_PC2_COR[[i]] <- pgls_pagel(tree = TREES[[i]], data = corolla_data, 
                                             origin = ORIGINS[[i]], response = "PC2")
PG_PC2_COR <- do.call(rbind.data.frame, PG_PC2_COR)
save(PG_PC2_COR, file = "PG_PC2_COR.RData")
rm(PG_PC2_COR); gc()
beep(5)

# 8.2.3 PGLS PAGEL MCC tree PC3 corolla
PG_PC3_COR <- vector(mode = "list", 11)
for(i in 1:11) PG_PC3_COR[[i]] <- pgls_pagel(tree = TREES[[i]], data = corolla_data, 
                                             origin = ORIGINS[[i]], response = "PC3")
PG_PC3_COR <- do.call(rbind.data.frame, PG_PC3_COR)
save(PG_PC3_COR, file = "PG_PC3_COR.RData")
rm(PG_PC3_COR); gc()
beep(5)  

# 8.2.4 PGLS PAGEL MCC tree PC4 corolla
PG_PC4_COR <- vector(mode = "list", 11)
for(i in 1:11) PG_PC4_COR[[i]] <- pgls_pagel(tree = TREES[[i]], data = corolla_data, 
                                             origin = ORIGINS[[i]], response = "PC4")
PG_PC4_COR <- do.call(rbind.data.frame, PG_PC4_COR)
save(PG_PC4_COR, file = "PG_PC4_COR.RData")
rm(PG_PC4_COR); gc()
beep(5) 

# 8.2.5 PGLS PAGEL MCC tree PC1 connectives
PG_PC1_CONN <- vector(mode = "list", 11)
for(i in 1:11) PG_PC1_CONN[[i]] <- pgls_pagel(tree = TREES[[i]], data = connectives_data, 
                                              origin = ORIGINS[[i]], response = "PC1")
PG_PC1_CONN <- do.call(rbind.data.frame, PG_PC1_CONN)
save(PG_PC1_CONN, file = "PG_PC1_CONN.RData")
rm(PG_PC1_CONN); gc()
beep(5)

# 8.2.6 PGLS PAGEL MCC tree PC2 connectives
PG_PC2_CONN <- vector(mode = "list", 11)
for(i in 1:11) PG_PC2_CONN[[i]] <- pgls_pagel(tree = TREES[[i]], data = connectives_data, 
                                              origin = ORIGINS[[i]], response = "PC2")
PG_PC2_CONN <- do.call(rbind.data.frame, PG_PC2_CONN)
save(PG_PC2_CONN, file = "PG_PC2_CONN.RData")
rm(PG_PC2_CONN); gc()
beep(5)

# 8.2.7 PGLS PAGEL MCC tree PC3 connectives
PG_PC3_CONN <- vector(mode = "list", 11)
for(i in 1:11) PG_PC3_CONN[[i]] <- pgls_pagel(tree = TREES[[i]], data = connectives_data, 
                                              origin = ORIGINS[[i]], response = "PC3")
PG_PC3_CONN <- do.call(rbind.data.frame, PG_PC3_CONN)
save(PG_PC3_CONN, file = "PG_PC3_CONN.RData")
rm(PG_PC3_CONN); gc()
beep(5) 

# 8.2.8 PGLS PAGEL MCC tree PC4 connectives
PG_PC4_CONN <- vector(mode = "list", 11)
for(i in 1:11) PG_PC4_CONN[[i]] <- pgls_pagel(tree = TREES[[i]], data = connectives_data, 
                                              origin = ORIGINS[[i]], response = "PC4")
PG_PC4_CONN <- do.call(rbind.data.frame, PG_PC4_CONN)
save(PG_PC4_CONN, file = "PG_PC4_CONN.RData")
rm(PG_PC4_CONN); gc()
beep(5) 

# 8.2.9 PGLS PAGEL MCC tree PC1 styles
PG_PC1_STYL <- vector(mode = "list", 11)
for(i in 1:11) PG_PC1_STYL[[i]] <- pgls_pagel(tree = TREES[[i]], data = styles_data, 
                                              origin = ORIGINS[[i]], response = "PC1")
PG_PC1_STYL <- do.call(rbind.data.frame, PG_PC1_STYL)
save(PG_PC1_STYL, file = "PG_PC1_STYL.RData")
rm(PG_PC1_STYL); gc()
beep(5)

# 8.2.10 PGLS PAGEL MCC tree PC2 styles
PG_PC2_STYL <- vector(mode = "list", 11)
for(i in 1:11) PG_PC2_STYL[[i]] <- pgls_pagel(tree = TREES[[i]], data = styles_data, 
                                              origin = ORIGINS[[i]], response = "PC2")
PG_PC2_STYL <- do.call(rbind.data.frame, PG_PC2_STYL)
save(PG_PC2_STYL, file = "PG_PC2_STYL.RData")
rm(PG_PC2_STYL); gc()
beep(5)

# 8.2.11 PGLS PAGEL MCC tree PC3 styles
origin2 <- ORIGINS
origin2[[1]][46] <- "from_bird"

PG_PC3_STYL <- vector(mode = "list", 11)
for(i in 1:11) PG_PC3_STYL[[i]] <- pgls_pagel(tree = TREES[[i]], data = styles_data, 
                                              origin = ORIGINS[[i]], response = "PC3")
PG_PC3_STYL <- do.call(rbind.data.frame, PG_PC3_STYL)
save(PG_PC3_STYL, file = "PG_PC3_STYL.RData")
rm(PG_PC3_STYL); gc()
beep(5) 

# 8.2.12 PGLS PAGEL MCC tree PC4 styles
PG_PC4_STYL <- vector(mode = "list", 11)
for(i in 1:11) PG_PC4_STYL[[i]] <- pgls_pagel(tree = TREES[[i]], data = styles_data, 
                                              origin = ORIGINS[[i]], response = "PC4")
PG_PC4_STYL <- do.call(rbind.data.frame, PG_PC4_STYL)
save(PG_PC4_STYL, file = "PG_PC4_STYL.RData")
rm(PG_PC4_STYL); gc()
beep(5)

# 8.2.13 PGLS BROWNIAN MCC tree PC1 corolla
BM_PC1_COR <- vector(mode = "list", 11)
for(i in 1:11) BM_PC1_COR[[i]] <- pgls_bm(tree = TREES[[i]], data = corolla_data, 
                                          origin = ORIGINS[[i]], response = "PC1")
BM_PC1_COR <- do.call(rbind.data.frame, BM_PC1_COR)
save(BM_PC1_COR, file = "BM_PC1_COR.RData")
rm(BM_PC1_COR); gc()
beep(5)

# 8.2.14 PGLS BROWNIAN MCC tree PC2 corolla
BM_PC2_COR <- vector(mode = "list", 11)
for(i in 1:11) BM_PC2_COR[[i]] <- pgls_bm(tree = TREES[[i]], data = corolla_data, 
                                          origin = ORIGINS[[i]], response = "PC2")
BM_PC2_COR <- do.call(rbind.data.frame, BM_PC2_COR)
save(BM_PC2_COR, file = "BM_PC2_COR.RData")
rm(BM_PC2_COR); gc()
beep(5)

# 8.2.15 PGLS BROWNIAN MCC tree PC2 corolla
BM_PC3_COR <- vector(mode = "list", 11)
for(i in 1:11) BM_PC3_COR[[i]] <- pgls_bm(tree = TREES[[i]], data = corolla_data, 
                                          origin = ORIGINS[[i]], response = "PC3")
BM_PC3_COR <- do.call(rbind.data.frame, BM_PC3_COR)
save(BM_PC3_COR, file = "BM_PC3_COR.RData")
rm(BM_PC3_COR); gc()
beep(5)

# 8.2.16 PGLS BROWNIAN MCC tree PC2 corolla
BM_PC4_COR <- vector(mode = "list", 11)
for(i in 1:11) BM_PC4_COR[[i]] <- pgls_bm(tree = TREES[[i]], data = corolla_data, 
                                          origin = ORIGINS[[i]], response = "PC3")
BM_PC4_COR <- do.call(rbind.data.frame, BM_PC4_COR)
save(BM_PC4_COR, file = "BM_PC4_COR.RData")
rm(BM_PC4_COR); gc()
beep(5) #<-------------------------------------------------------------------

# 8.2.17 PGLS BROWNIAN MCC tree PC1 connectives
BM_PC1_CONN <- vector(mode = "list", 11)
for(i in 1:11) BM_PC1_CONN[[i]] <- pgls_bm(tree = TREES[[i]], data = connectives_data, 
                                           origin = ORIGINS[[i]], response = "PC1")
BM_PC1_CONN <- do.call(rbind.data.frame, BM_PC1_CONN)
save(BM_PC1_CONN, file = "BM_PC1_CONN.RData")
rm(BM_PC1_CONN); gc()
beep(5)

# 8.2.18 PGLS BROWNIAN MCC tree PC2 connectives
BM_PC2_CONN <- vector(mode = "list", 11)
for(i in 1:11) BM_PC2_CONN[[i]] <- pgls_bm(tree = TREES[[i]], data = connectives_data, 
                                           origin = ORIGINS[[i]], response = "PC2")
BM_PC2_CONN <- do.call(rbind.data.frame, BM_PC2_CONN)
save(BM_PC2_CONN, file = "BM_PC2_CONN.RData")
rm(BM_PC2_CONN); gc()
beep(5)

# 8.2.19 PGLS BROWNIAN MCC tree PC3 connectives
BM_PC3_CONN <- vector(mode = "list", 11)
for(i in 1:11) BM_PC3_CONN[[i]] <- pgls_bm(tree = TREES[[i]], data = connectives_data, 
                                           origin = ORIGINS[[i]], response = "PC3")
BM_PC3_CONN <- do.call(rbind.data.frame, BM_PC3_CONN)
save(BM_PC3_CONN, file = "BM_PC3_CONN.RData")
rm(BM_PC3_CONN); gc()
beep(5)

# 8.2.20 PGLS BROWNIAN MCC tree PC4 connectives
BM_PC4_CONN <- vector(mode = "list", 11)
for(i in 1:11) BM_PC4_CONN[[i]] <- pgls_bm(tree = TREES[[i]], data = connectives_data, 
                                           origin = ORIGINS[[i]], response = "PC4")
BM_PC4_CONN <- do.call(rbind.data.frame, BM_PC4_CONN)
save(BM_PC4_CONN, file = "BM_PC4_CONN.RData")
rm(BM_PC4_CONN); gc()
beep(5)

# 8.2.21 PGLS BROWNIAN MCC tree PC1 styles
BM_PC1_STYL <- vector(mode = "list", 11)
for(i in 1:11) BM_PC1_STYL[[i]] <- pgls_bm(tree = TREES[[i]], data = styles_data, 
                                           origin = ORIGINS[[i]], response = "PC1")
BM_PC1_STYL <- do.call(rbind.data.frame, BM_PC1_STYL)
save(BM_PC1_STYL, file = "BM_PC1_STYL.RData")
rm(BM_PC1_STYL); gc()
beep(5)

# 8.2.22 PGLS BROWNIAN MCC tree PC2 styles
BM_PC2_STYL <- vector(mode = "list", 11)
for(i in 1:11) BM_PC2_STYL[[i]] <- pgls_bm(tree = TREES[[i]], data = styles_data, 
                                           origin = ORIGINS[[i]], response = "PC2")
BM_PC2_STYL <- do.call(rbind.data.frame, BM_PC2_STYL)
save(BM_PC2_STYL, file = "BM_PC2_STYL.RData")
rm(BM_PC2_STYL); gc()
beep(5)

# 8.2.23 PGLS BROWNIAN MCC tree PC3 styles
BM_PC3_STYL <- vector(mode = "list", 11)
for(i in 1:11) BM_PC3_STYL[[i]] <- pgls_bm(tree = TREES[[i]], data = styles_data, 
                                           origin = ORIGINS[[i]], response = "PC3")
BM_PC3_STYL <- do.call(rbind.data.frame, BM_PC3_STYL)
save(BM_PC3_STYL, file = "BM_PC3_STYL.RData")
rm(BM_PC3_STYL); gc()
beep(5)

# 8.2.24 PGLS BROWNIAN MCC tree PC4 styles
BM_PC4_STYL <- vector(mode = "list", 11)
for(i in 1:11) BM_PC4_STYL[[i]] <- pgls_bm(tree = TREES[[i]], data = styles_data, 
                                           origin = ORIGINS[[i]], response = "PC4")
BM_PC4_STYL <- do.call(rbind.data.frame, BM_PC4_STYL)
save(BM_PC4_STYL, file = "BM_PC4_STYL.RData")
rm(BM_PC4_STYL); gc()
beep(5)
