############################
### PART 2. MORPHOSPACES ###
############################

library(magrittr)
library(reshape2)
library(tidyverse)
library(Momocs)
library(ape)


#################################
# 6. Data preparation
#################################

load("origin_summary.RData")

# import species data
all_salvia <- read.csv("Salvia_flower_evol_May2020/Data/groups.csv", header=T)
row.names(all_salvia) <- all_salvia$species

# Import distribution and pollinator data
groups_outlines <- read.csv("Salvia_flower_evol_May2020/Data/groups.csv")

# import phylogeny
all_salvia_tree <- read.tree("Salvia_flower_evol_May2020/Phylogeny/Beast_Yule_MCC_newick.tre")

# Corolla. Moddified from Kriebel et al. 2020
# Import side view add three landmarks each and save
corolla_sideview <- readRDS("Salvia_flower_evol_May2020/Outlines/imported/corolla_sideview_504_outlines_3ldks.rds")
# Get specimen name, join to grouping variables and assign groups to Out object
corolla_sideview_names <- corolla_sideview %>% names() %>% tibble() %>% setNames("image")
corolla_sideview_names <- colsplit(corolla_sideview_names$image,"_", c("genus","epithet","author"))
corolla_sideview_names$species <- paste0(corolla_sideview_names$genus,"_",corolla_sideview_names$epithet)
corolla_sideview_groups <- left_join(corolla_sideview_names, groups_outlines,"species")
corolla_sideview_groups[,4:9] <- lapply(corolla_sideview_groups[,4:9], factor)
corolla_sideview$fac <- corolla_sideview_groups # Assign groups to corollas

# Conectives. Moddified from Kriebel et al. 2020
# Import connective outlines and save
returns_connectives <- readRDS("Salvia_flower_evol_May2020/Outlines/imported/connective_456_outlines.rds")
connectives <- Out(returns_connectives)
# Get specimen name, join to grouping variables and assign groups to Out object
connectives_names <- connectives %>% names() %>% tibble() %>% setNames("image")
connectives_names <- colsplit(connectives_names$image,"_", c("genus","epithet","author"))
connectives_names$species <- paste0(connectives_names$genus,"_",connectives_names$epithet)
connectives_groups <- left_join(connectives_names, groups_outlines,"species")
connectives_groups[,4:9] <- lapply(connectives_groups[,4:9], factor)
connectives$fac <- connectives_groups # Assign groups to connectives
# Assign landmarks to connectives. We first scale them to help with a couple of tiny ones
connectives$coo <- lapply(connectives$coo, coo_interpolate, n=200)  
connectives <- coo_center(connectives) 
connectives$coo <- lapply(connectives$coo, FUN=function(x)(coo_scale(x, max(x[,2]/1000)))) 
connectives <- coo_scale(connectives, 1000) 
ldks2 <- vector("list", length=length(connectives$coo))
names(ldks2) <- names(connectives$coo)
coo_centpos(connectives) -> centroids
for (i in 1:length(connectives)) {
  ldk <- numeric(4)
  connectives$coo[[i]] -> x
  which.min(x[,1]) -> min.x
  which.max(x[,1]) -> max.x
  which.min(x[,2]) -> min.y
  which.max(x[,2]) -> max.y
  p <- c(centroids[i,1], min(x[,2]))
  l <- apply(x, 1, function(y) sqrt(sum((p - y)^2)))
  ldk[1] <- which.min(l)
  p <- c(centroids[i,1], max(x[,2]))
  l <- apply(x, 1, function(y) sqrt(sum((p - y)^2)))
  ldk[2] <- which.min(l)
  p <- c(min(x[,1]), centroids[i,2])
  l <- apply(x, 1, function(y) sqrt(sum((p - y)^2)))
  ldk[3] <- which.min(l)
  p <- c(max(x[,1]), centroids[i,2])
  l <- apply(x, 1, function(y) sqrt(sum((p - y)^2)))
  ldk[4] <- which.min(l)
  ldk -> ldks2[[i]]
}
connectives$ldk <- ldks2


# Styles. Moddified from Kriebel et al. 2020
# Import styles
returns_styles <- readRDS("Salvia_flower_evol_May2020/Outlines/imported/style_319_outlines.rds")
styles <- Out(returns_styles)
# Get specimen name, join to grouping variables and assign groups to Out object
styles_names <- styles %>% names() %>% tibble() %>% setNames("image")
styles_names <- colsplit(styles_names$image,"_", c("genus","epithet","author"))
styles_names$species <- paste0(styles_names$genus,"_",styles_names$epithet)
style_groups <- left_join(styles_names, groups_outlines,"species")
style_groups[,4:9] <- lapply(style_groups[,4:9], factor)
styles$fac <- style_groups # Assign groups to styles
# Assign landmarks to connectives
ldks2 <- vector("list", length=length(styles$coo))
names(ldks2) <- names(styles$coo)
coo_centpos(styles) -> centroids
for (i in 1:length(styles)) {
  ldk <- numeric(4)
  styles$coo[[i]] -> x
  which.min(x[,1]) -> min.x
  which.max(x[,1]) -> max.x
  which.min(x[,2]) -> min.y
  which.max(x[,2]) -> max.y
  p <- c(centroids[i,1], min(x[,2]))
  l <- apply(x, 1, function(y) sqrt(sum((p - y)^2)))
  ldk[1] <- which.min(l)
  p <- c(centroids[i,1], max(x[,2]))
  l <- apply(x, 1, function(y) sqrt(sum((p - y)^2)))
  ldk[2] <- which.min(l)
  p <- c(min(x[,1]), centroids[i,2])
  l <- apply(x, 1, function(y) sqrt(sum((p - y)^2)))
  ldk[3] <- which.min(l)
  p <- c(max(x[,1]), centroids[i,2])
  l <- apply(x, 1, function(y) sqrt(sum((p - y)^2)))
  ldk[4] <- which.min(l)
  ldk -> ldks2[[i]]
}
styles$ldk <- ldks2

# elliptic Fourier analysis COROLLA
# Slide and align
corolla_sideview <- readRDS("Salvia_flower_evol_May2020/rds/corolla_sideview_504_aligned.rds")
#calibrate_harmonicpower_efourier(corolla_sideview) # Check harmonic power
efou_corolla_sideview <- efourier(corolla_sideview, norm=F, nb.h=32, smooth.it=1) 
efou_corolla_sideview_mean <- MSHAPES(efou_corolla_sideview, 'species') # Calculate mean shapes by species
pca_corolla_sideview <- PCA(efou_corolla_sideview_mean$Coe)
pc_contributions_corolla_sideview <- summary(pca_corolla_sideview)

# elliptic Fourier analysis CONNECTIVES
# Slide and align
connectives <- readRDS("Salvia_flower_evol_May2020/rds/connectives_456_aligned.rds")
#calibrate_harmonicpower_efourier(connectives) # Check harmonic power
efou_connectives <- efourier(connectives, norm=T, nb.h=32, smooth.it=1) 
efou_connectives_mean <- MSHAPES(efou_connectives, 'species') # Calculate mean shapes by species
pca_connectives <- PCA(efou_connectives_mean$Coe)
pc_contributions_connectives <- summary(pca_connectives)

# elliptic Fourier analysis STYLES
styles <- readRDS("Salvia_flower_evol_May2020/rds/styles_319_aligned.rds")
# calibrate_harmonicpower_efourier(styles) # Check harmonic power
efou_styles <- efourier(styles, norm=T, nb.h=32, smooth.it=1) 
efou_styles_mean <- MSHAPES(efou_styles, 'species') # Calculate mean shapes by species
pca_styles <- PCA(efou_styles_mean$Coe)
pc_contributions_styles <- summary(pca_styles)

# Shape variation in each PC  
# Plot shape variation explained by each of the first two PCs 
# create plots
svg("pc_contrib_corolla.svg", width = 3.5, height = 3.5) 
PCcontrib(pca_corolla_sideview, nax=c(1:4), sd.r = c(-1.5, 0, 1.5))
dev.off()

svg("pc_contrib_connectives.svg", width = 3.5, height = 3.5) 
PCcontrib(pca_connectives, nax=c(1:4), sd.r = c(-1.5,0, 1.5))
dev.off()

svg("pc_contrib_style.svg", width = 3.5, height = 3.5) 
PCcontrib(pca_styles, nax=c(1:4), sd.r = c(-1.5,0, 1.5))
dev.off()

save(pca_corolla_sideview, pca_styles, pca_connectives, file = "pca_data.RData")

####################################################################
# 7. Morphospaces by pollinator with bee-from-bee and bee-from-bird 
####################################################################

# 7.1.1 COROLLA
corolla_fac <- pca_corolla_sideview$fac
corolla_fac <- left_join(corolla_fac, origin_state,"species")
pca_corolla_sideview_bee_separate <- pca_corolla_sideview
pca_corolla_sideview_bee_separate$fac <- corolla_fac

# plot corolla in ggplot2. FIGURE 3 D
CORO <- data.frame(PC1 = pca_corolla_sideview_bee_separate$x[,1], 
                   PC2 = pca_corolla_sideview_bee_separate$x[,2], 
                   PC3 = pca_corolla_sideview_bee_separate$x[,3], 
                   PC4 = pca_corolla_sideview_bee_separate$x[,4], 
                   birdness = pca_corolla_sideview_bee_separate$fac$birdness,
                   pollinator = pca_corolla_sideview_bee_separate$fac$pollinator, 
                   clade = pca_corolla_sideview_bee_separate$fac$clade)
CORO <- CORO %>% filter(pollinator != "sister") %>% droplevels()

#--------------------------------------------------------------------------------------
svg("corolla_new2.svg", width = 4.5, height = 8) 
df2 <- select(CORO, -pollinator)
highbird <- CORO %>% filter(pollinator == "bee" & birdness > 0.9) %>% droplevels()
ggplot(CORO, aes(x = PC1, y = PC2)) + 
  geom_point(data = df2, colour = "grey50", size = 0.33) +
  geom_point(aes(colour = birdness), size = 2) + 
  scale_color_viridis_c(option = "viridis", begin = 0, end = 1, limits = c(0, 1), na.value = "#928077") + 
  stat_ellipse(level = 0.95) +
  stat_ellipse(level = 0.95, data = highbird, linetype = 2) + 
  theme_bw() + 
  facet_wrap(~pollinator, ncol = 1) +
  guides(color = guide_colorbar(title = "bird-pollinated\nancestry", 
                                title.theme = element_text(size = 8),
                                barwidth = 0.75, barheight = 20))
dev.off()
#--------------------------------------------------------------------------------------


#7.1.2 Alternative: by clade instead of pollinator # FIGURE S4 D
CORO2 <- CORO %>% filter(clade %in% c("audibertia", "calosphace", "glutinaria", 
                                      "heterosphace", "salvia", "sclarea")) %>% droplevels()
#--------------------------------------------------------------------------------------
svg("corolla_clade.svg", width = 3, height = 10)
df3 <- select(CORO2, -clade)
ggplot(CORO2, aes(x = PC1, y = PC2)) + 
  geom_point(data = df3, colour = "grey50", size = 0.33) +
  geom_point(aes(colour = clade), size = 2) + 
  scale_color_viridis_d(option = "viridis", na.value = "#928077") + 
  stat_ellipse(level = 0.95) +
  theme_bw() + 
  theme(legend.position = "none") + 
  facet_wrap(~clade, ncol = 1)
dev.off()
#---------------------------------------------------------------------------------------

# 7.2.1 CONNECTIVE. Import new file with pollinator classification
connectives_fac <- pca_connectives$fac
connectives_fac <- left_join(connectives_fac, origin_state,"species")
pca_connectives_bee_separate <- pca_connectives
pca_connectives_bee_separate$fac <- connectives_fac

#  plot connectives in ggplot2. FIGURE 3 E
CONN <- data.frame(PC1 = pca_connectives_bee_separate$x[,1], 
                   PC2 = pca_connectives_bee_separate$x[,2], 
                   PC3 = pca_connectives_bee_separate$x[,3], 
                   PC4 = pca_connectives_bee_separate$x[,4], 
                   birdness = pca_connectives_bee_separate$fac$birdness,
                   pollinator = pca_connectives_bee_separate$fac$pollinator, 
                   clade = pca_connectives_bee_separate$fac$clade)
CONN <- CONN %>% filter(pollinator != "sister") %>% droplevels()

#--------------------------------------------------------------------------------------
svg("connectives_new.svg", width = 4.5, height = 8) 
df3 <- select(CONN, -pollinator)
highbird <- CONN %>% filter(pollinator == "bee" & birdness > 0.9) %>% droplevels()
ggplot(CONN, aes(x = PC1, y = PC2)) + 
  geom_point(data = df3, colour = "grey50", size = 0.33) +
  geom_point(aes(colour = birdness), size = 2) + 
  scale_color_viridis_c(option = "viridis", begin = 0, end = 1, limits = c(0, 1), na.value = "#928077") + 
  stat_ellipse(level = 0.95) +
  stat_ellipse(level = 0.95, data = highbird, linetype = 2) + 
  theme_bw() +  
  facet_wrap(~pollinator, ncol = 1) +
  guides(color = guide_colorbar(title = "bird-pollinated\nancestry", 
                                title.theme = element_text(size = 8),
                                barwidth = 0.75, barheight = 20))
dev.off()
#-------------------------------------------------------------------------------------------

# 7.2.2 Alternative: by clade instead of pollinator. FIGURE S4 E
CONN2 <- CONN %>% filter(clade %in% c("audibertia", "calosphace", "glutinaria", 
                                      "heterosphace", "salvia", "sclarea")) %>% droplevels()
#-------------------------------------------------------------------------------------------
svg("connectives_clade.svg", width = 3, height = 10)
df3 <- select(CONN2, -clade)
ggplot(CONN2, aes(x = PC1, y = PC2)) + 
  geom_point(data = df3, colour = "grey50", size = 0.33) +
  geom_point(aes(colour = clade), size = 2) + 
  scale_color_viridis_d(option = "viridis", na.value = "#928077") + 
  stat_ellipse(level = 0.95) +
  theme_bw() + 
  theme(legend.position = "none") + 
  facet_wrap(~clade, ncol = 1)
dev.off()
#-------------------------------------------------------------------------------------------

# 7.3.1 STYLES
styles_fac <- pca_styles$fac
styles_fac <- left_join(styles_fac, origin_state, "species")
pca_styles_bee_separate <- pca_styles
pca_styles_bee_separate$fac <- styles_fac

# plot connectives in ggplot2. FIGURE 3 F
STYL <- data.frame(PC1 = pca_styles_bee_separate$x[,1], 
                   PC2 = pca_styles_bee_separate$x[,2], 
                   PC3 = pca_styles_bee_separate$x[,3], 
                   PC4 = pca_styles_bee_separate$x[,4], 
                   birdness = pca_styles_bee_separate$fac$birdness,
                   pollinator = pca_styles_bee_separate$fac$pollinator,
                   clade = pca_styles_bee_separate$fac$clade)
STYL <- STYL %>% filter(pollinator != "sister") %>% droplevels()

#-----------------------------------------------------------------------------------------
svg("styles_new.svg", width = 4.5, height = 8) 
df4 <- select(STYL, -pollinator)
highbird <- STYL %>% filter(pollinator == "bee" & birdness > 0.9) %>% droplevels()
ggplot(STYL, aes(x = PC1, y = PC2)) + 
  geom_point(data = df4, colour = "grey50", size = 0.33) +
  geom_point(aes(colour = birdness), size = 2) + 
  scale_color_viridis_c(option = "viridis", begin = 0, end = 1, limits = c(0, 1), na.value = "#928077") + 
  stat_ellipse(level = 0.95) +
  stat_ellipse(level = 0.95, data = highbird, linetype = 2) + 
  theme_bw() +  
  facet_wrap(~pollinator, ncol = 1) +
  guides(color = guide_colorbar(title = "bird-pollinated\nancestry", 
                                title.theme = element_text(size = 8),
                                barwidth = 0.75, barheight = 20))
dev.off()
#-------------------------------------------------------------------------------------------

## alternative: by clade instead of pollinator. FIGURE S4 F
STYL2 <- STYL %>% filter(clade %in% c("audibertia", "calosphace", "glutinaria", 
                                      "heterosphace", "salvia", "sclarea")) %>% droplevels()
#-------------------------------------------------------------------------------------------
svg("styles_clade.svg", width = 3, height = 10)
df3 <- select(STYL2, -clade)
ggplot(CONN2, aes(x = PC1, y = PC2)) + 
  geom_point(data = df3, colour = "grey50", size = 0.33) +
  geom_point(aes(colour = clade), size = 2) + 
  scale_color_viridis_d(option = "viridis", na.value = "#928077") + 
  stat_ellipse(level = 0.95) +
  theme_bw() + 
  theme(legend.position = "none") + 
  facet_wrap(~clade, ncol = 1)
dev.off()
#--------------------------------------------------------------------------------------------

