#############################
# 5. Classify extant species
#############################

# Extant species (tips) were classified in a) bee from bee, b) bee from bird, 
# c) bird and d) polymorphic, according to their pollination history that 
# was taken from character states at the nodes in each simmap simulation.
# To sum up across all histories, we determined the number of simulations in which
# a given species ended in one state

library(dplyr)

load("results_simmap_origin_t01.RData")
load("results_simmap_origin_t02.RData")
load("results_simmap_origin_t03.RData")
load("results_simmap_origin_t04.RData")
load("results_simmap_origin_t05.RData")
load("results_simmap_origin_t06.RData")
load("results_simmap_origin_t07.RData")
load("results_simmap_origin_t08.RData")
load("results_simmap_origin_t09.RData")
load("results_simmap_origin_t10.RData")
load("results_simmap_origin_t11.RData")

# merge origins from mcc and 10 trees

mega_origins <- bind_cols(origins_t01, origins_t02, origins_t03, origins_t04,
                          origins_t05, origins_t06, origins_t07, origins_t08,
                          origins_t09, origins_t10, origins_t11)

rm(origins_t01, origins_t02, origins_t03, origins_t04,
   origins_t05, origins_t06, origins_t07, origins_t08,
   origins_t09, origins_t10, origins_t11)
gc()

mega_origins_01 <- apply(mega_origins, 2, function(x) as.numeric(gsub("from_bee", 0, gsub("from_bird", 1, x))))
rownames(mega_origins_01) <- rownames(mega_origins)

origin_state <- data.frame(
  birdness = rowSums(mega_origins_01)/11000,
  beeness = 1-rowSums(mega_origins_01)/11000,
  species = rownames(mega_origins_01)
)

#-------------------------------------------------------------------------------
save(mega_origins, mega_origins_01, origin_state, file = "origin_summary.RData")
#-------------------------------------------------------------------------------

