# Synthetic populations for regions of the World (SPW) | Florida
## Dataset information
A synthetic population of a region as provided here, captures the people of the region with selected demographic attributes, their organization into households, their assigned activities for a day, the locations where the activities take place and thus where interactions among population members happen (e.g., spread of epidemics).  
## License
[CC-BY-4.0](https://creativecommons.org/licenses/by/4.0/)
## Acknowledgment
This project was supported by the National Science Foundation under the NSF RAPID: COVID-19 Response Support: Building Synthetic Multi-scale Networks (PI: Madhav Marathe, Co-PIs: Henning Mortveit, Srinivasan Venkatramanan; Fund Number: OAC-2027541). 
## Contact information
Henning.Mortveit@virginia.edu

## Identifiers
|||
|-|-|
|Region name | Florida |
|Region ID   | usa_140002900 |
|Model       | coarse | 
|Version     | 0_9_0

## Statistics

| Name | Value |
|------|-------|
| Population | 18164740 | 
| Average age | 40.0 | 
| Households | 7364047 | 
| Average household size | 2.5 | 
| Residence locations | 7364047 | 
| Activity locations | 1971854 | 
| Average number of activities | 5.7 | 
| Average travel distance | 72.6 | 



## Sources

| Description | Name  | Version | Url  |
|-------------|-------|------| ----- |
| Activity template data | World Bank | 2021 | https://data.worldbank.org | 
| Administrative boundaries  | ADCW | 7.6 | https://www.adci.com/adc-worldmap | 
| Curated POIs based on OSM | SLIPO/OSM POIs |  | http://slipo.eu/?p=1551 https://www.openstreetmap.org/ | 
| Household data | IPUMS |  | https://international.ipums.org/international | 
| Population count with demographic attributes | GPW | v4.11 | https://sedac.ciesin.columbia.edu/data/set/gpw-v4-admin-unit-center-points-population-estimates-rev11 | 



## Files description
### Base data files (usa_140002900_data_v_0_9.zip)
| Filename | Description |
|----------|-------------|
| `usa_140002900_person_v_0_9.csv` | Data for each person including attributes such as age, gender, and household ID.  | 
| `usa_140002900_household_v_0_9.csv` | Data at household level. | 
| `usa_140002900_residence_locations_v_0_9.csv` | Data about residence locations | 
| `usa_140002900_activity_locations_v_0_9.csv` | Data about  activity locations, including what activity types are supported at these locations | 
| `usa_140002900_activity_location_assignment_v_0_9.csv` | For each person and for each of their activities, this file specifies the location where the activity takes place | 

### Derived data files
| Filename | Description |
|----------|-------------|
| `usa_140002900_contact_matrix_v_0_9.csv` | A POLYMOD-type contact matrix constructed from a network representation of the location assignment data and a within-location contact model. | 

### Validation and measures files
| Filename | Description |
|----------|-------------|
| `usa_140002900_household_grouping_validation_v_0_9.pdf` | Validation plots for household construction | 
| `usa_140002900_activity_durations_{adult,child}_v_0_9.pdf` | Comparison of time spent on generated activities with survey data | 
| `usa_140002900_activity_patterns_{adult,child}_v_0_9.pdf` | Comparison of generated activity patterns by the time of day with survey data | 
| `usa_140002900_location_construction_0_9.pdf` | Validation plots for location construction | 
| `usa_140002900_location_assignement_0_9.pdf` | Validation plots for location assignment, including travel distribution plots | 
| `usa_140002900_usa_140002900_ver_0_9_0_avg_travel_distance.pdf` | Choropleth map visualizing average travel distance | 
| `usa_140002900_usa_140002900_ver_0_9_0_travel_distr_combined.pdf` | Travel distance distribution | 
| `usa_140002900_usa_140002900_ver_0_9_0_num_activity_loc.pdf` | Choropleth map visualizing number of activity locations | 
| `usa_140002900_usa_140002900_ver_0_9_0_avg_age.pdf` | Choropleth map visualizing average age | 
| `usa_140002900_usa_140002900_ver_0_9_0_pop_density_per_sqkm.pdf` | Choropleth map visualizing population density | 
| `usa_140002900_usa_140002900_ver_0_9_0_pop_size.pdf` | Choropleth map visualizing population size | 


