# Performing PCA on the processed data

# packages
library(tidyverse)

# read data
df <- read_rds("processed_data/questionnaire_processed.rds")

# perform PCA
cor_mat <- cor(df, use = "pairwise.complete.obs")
pc <- princomp(covmat = cor_mat)

# store the analysis result as processed data
write_rds(pc, "processed_data/analysis_object.rds")
