# Creating visualisations on the processed data

# packages
library(tidyverse)

# read data
df <- read_rds("processed_data/questionnaire_processed.rds")

# visualize
df |> 
  ggplot(aes(x = Q1, y = Q2)) +
  geom_point(pch = 21, fill = "dark green", col = "white", 
             position = position_jitter(.1)) +
  labs(title = "Scatter plot of Q1 and Q2") +
  theme_minimal()

# save the plot
ggsave("img/plot.png", width = 5, height = 3.5, bg = "white")
