<a id="top"></a>
[<img src ="https://zenodo.org/badge/DOI/10.5281/zenodo.6502539.svg"/>](https://doi.org/10.5281/zenodo.6502539) 
![GitHub release (latest by date)](https://img.shields.io/github/v/release/ESIPFed/science-on-schema.org)
[![Twitter Follow](https://img.shields.io/twitter/follow/ScienceOnSchema.svg?style=social&label=Follow)](https://twitter.com/ScienceOnSchema)

![GitHub last commit](https://img.shields.io/github/last-commit/ESIPFed/science-on-schema.org)


<a id="guides"></a>
## Science On Schema.Org (SOSO) Guidance Documents ##

This repository provides guidance for repository operators and others to follow consistent conventions to provide schema.org markup in Dataset landing pages to improve data discovery through search engines. The main guides help describe Datasets and Data Repositories.

| Name | | Guideline | Examples | Issues |
| --:  | --- | :-: | :-: | :-: |
| __[Dataset](/guides/Dataset.md)__ | guidelines for schema.org for a scientific Dataset | [<img src="/assets/images/clipboard-list-solid.svg" height="25px"/>](/guides/Dataset.md) | [<img src="/assets/images/code-solid.svg" height="25px"/>](/examples/dataset) | [<img src="/assets/images/list-check-solid.svg" height="25px"/>](/issues?q=is%3Aissue+is%3Aopen+label%3ADataset) |
| __[Data Repository](/guides/DataRepository.md)__ | guidelines for schema.org for a research data repository | [<img src="/assets/images/clipboard-list-solid.svg" height="25px"/>](/guides/DataRepository.md) | [<img src="/assets/images/code-solid.svg" height="25px"/>](/examples/data-repository) | [<img src="/assets/images/list-check-solid.svg" height="25px"/>](/issues?q=is%3Aissue+is%3Aopen+label%3ADataRepository) |

* [Getting Started](/guides/GETTING-STARTED.md) - explains some useful techniques that will be common across all schema.org types
* [Experimental](/guides/Experimental.md) - some suggestions for more advanced dataset documentation, proposed for inclusion in future SOSO guidelines. 

## Citation

Science on Schema.org (SOSO) releases are archived on Zenodo, and the current release should be cited as:

>  Adam Shepherd, Matthew B. Jones, Stephen Richard,  Nicolas Jarboe, Dave Vieglais, Douglas Fils, Ruth Duerr, Chantelle Verhey, Melinda Minch, Bryce Mecum, Nokome Bentley. (2022). Science-on-Schema.org v1.3.0. Zenodo. https://doi.org/10.5281/zenodo.6502539

## Community 

This guidance has been created by members of the ESIP [science-on-schema.org cluster](http://wiki.esipfed.org/index.php/Schema.org_Cluster). The cluster will be seeking endorsement across all members of ESIP, and in the meantime is releasing a series of progressively more mature guidance documents for the community. Your feedback and contributions are welcome. The cluster meets twice monthly, and all are welcome:

- When: 
    - 1st Monday at 5pm ET
    - 4th Thursday, 2:30pm ET
- Where: Telecons via Zoom
    - Connection: https://us02web.zoom.us/j/84043422486?pwd=bGM4YkFyMkFGSW1FZG5yaFRNaGNvdz09
    - Phone Access: United States: +1 (786) 535-3211
    - Dial by your location (Find your local number: https://us02web.zoom.us/u/kcKljXMoF0)
- [Living Agenda](https://docs.google.com/document/d/1tIlDVnKeocO1E_SSbNaldv0avORfGFdmYDNk_3ub6ik/edit?ts=5d9ed12d)

## Version DOIs

| Version | DOI |
| ------------- | ------------- |
|[1.3.0](https://github.com/ESIPFed/science-on-schema.org/releases/tag/1.3.0)|[<img src="https://zenodo.org/badge/DOI/10.5281/zenodo.6502539.svg"/>](https://doi.org/10.5281/zenodo.6502539)|
|[1.2.0](https://github.com/ESIPFed/science-on-schema.org/releases/tag/1.2.0)|[<img src="https://zenodo.org/badge/DOI/10.5281/zenodo.4477164.svg"/>](https://doi.org/10.5281/zenodo.4477164)|
|[1.1.0](https://github.com/ESIPFed/science-on-schema.org/releases/tag/1.1.0)|[<img src="https://zenodo.org/badge/DOI/10.5281/zenodo.3736235.svg"/>](https://doi.org/10.5281/zenodo.3736235)|
|[1.0.0](https://github.com/ESIPFed/science-on-schema.org/releases/tag/1.0.0)|[<img src ="https://zenodo.org/badge/DOI/10.5281/zenodo.2628756.svg"/>](https://doi.org/10.5281/zenodo.2628756)|

## Contributors

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->
<table>
  <tr>
    <td align="center"><a href="https://www.whoi.edu/"><img src="https://avatars.githubusercontent.com/u/2117576?v=4?s=50" width="50px;" alt=""/><br /><sub><b>Adam Shepherd</b></sub></a><br /><a href="#design-ashepherd" title="Design">🎨</a> <a href="https://github.com/ESIPFed/science-on-schema/commits?author=ashepherd" title="Code">💻</a> <a href="#content-ashepherd" title="Content">🖋</a> <a href="https://github.com/ESIPFed/science-on-schema/commits?author=ashepherd" title="Documentation">📖</a> <a href="#eventOrganizing-ashepherd" title="Event Organizing">📋</a> <a href="#ideas-ashepherd" title="Ideas, Planning, & Feedback">🤔</a> <a href="#maintenance-ashepherd" title="Maintenance">🚧</a></td>
    <td align="center"><a href="http://matt.magisa.org/"><img src="https://avatars.githubusercontent.com/u/766407?v=4?s=50" width="50px;" alt=""/><br /><sub><b>Matt Jones</b></sub></a><br /><a href="#design-mbjones" title="Design">🎨</a> <a href="https://github.com/ESIPFed/science-on-schema/commits?author=mbjones" title="Code">💻</a> <a href="#content-mbjones" title="Content">🖋</a> <a href="https://github.com/ESIPFed/science-on-schema/commits?author=mbjones" title="Documentation">📖</a> <a href="#eventOrganizing-mbjones" title="Event Organizing">📋</a> <a href="#ideas-mbjones" title="Ideas, Planning, & Feedback">🤔</a> <a href="#maintenance-mbjones" title="Maintenance">🚧</a></td>
    <td align="center"><a href="http://lab.usgin.org/"><img src="https://avatars.githubusercontent.com/u/513380?v=4?s=50" width="50px;" alt=""/><br /><sub><b>Stephen Richard</b></sub></a><br /><a href="#design-smrgeoinfo" title="Design">🎨</a> <a href="https://github.com/ESIPFed/science-on-schema/commits?author=smrgeoinfo" title="Code">💻</a> <a href="#content-smrgeoinfo" title="Content">🖋</a> <a href="https://github.com/ESIPFed/science-on-schema/commits?author=smrgeoinfo" title="Documentation">📖</a> <a href="#eventOrganizing-smrgeoinfo" title="Event Organizing">📋</a> <a href="#ideas-smrgeoinfo" title="Ideas, Planning, & Feedback">🤔</a> <a href="#maintenance-smrgeoinfo" title="Maintenance">🚧</a></td>
    <td align="center"><a href="https://github.com/njarboe"><img src="https://avatars.githubusercontent.com/u/1278789?v=4?s=50" width="50px;" alt=""/><br /><sub><b>njarboe</b></sub></a><br /><a href="#design-njarboe" title="Design">🎨</a> <a href="https://github.com/ESIPFed/science-on-schema/commits?author=njarboe" title="Code">💻</a> <a href="#content-njarboe" title="Content">🖋</a> <a href="https://github.com/ESIPFed/science-on-schema/commits?author=njarboe" title="Documentation">📖</a> <a href="#eventOrganizing-njarboe" title="Event Organizing">📋</a> <a href="#ideas-njarboe" title="Ideas, Planning, & Feedback">🤔</a> <a href="#maintenance-njarboe" title="Maintenance">🚧</a></td>
  </tr>
  <tr>
    <td align="center"><a href="http://people.ku.edu/~vieglais"><img src="https://avatars.githubusercontent.com/u/605409?v=4?s=50" width="50px;" alt=""/><br /><sub><b>Dave Vieglais</b></sub></a><br /><a href="#design-datadavev" title="Design">🎨</a> <a href="https://github.com/ESIPFed/science-on-schema/commits?author=datadavev" title="Code">💻</a> <a href="#content-datadavev" title="Content">🖋</a> <a href="https://github.com/ESIPFed/science-on-schema/commits?author=datadavev" title="Documentation">📖</a> <a href="#eventOrganizing-datadavev" title="Event Organizing">📋</a> <a href="#ideas-datadavev" title="Ideas, Planning, & Feedback">🤔</a> <a href="#maintenance-datadavev" title="Maintenance">🚧</a></td>
    <td align="center"><a href="https://github.com/fils"><img src="https://avatars.githubusercontent.com/u/57170?v=4?s=50" width="50px;" alt=""/><br /><sub><b>Douglas Fils</b></sub></a><br /><a href="#design-fils" title="Design">🎨</a> <a href="https://github.com/ESIPFed/science-on-schema/commits?author=fils" title="Code">💻</a> <a href="#content-fils" title="Content">🖋</a> <a href="https://github.com/ESIPFed/science-on-schema/commits?author=fils" title="Documentation">📖</a> <a href="#eventOrganizing-fils" title="Event Organizing">📋</a> <a href="#ideas-fils" title="Ideas, Planning, & Feedback">🤔</a> <a href="#maintenance-fils" title="Maintenance">🚧</a></td>
    <td align="center"><a href="https://github.com/rduerr"><img src="https://avatars.githubusercontent.com/u/1544892?v=4?s=50" width="50px;" alt=""/><br /><sub><b>rduerr</b></sub></a><br /><a href="#design-rduerr" title="Design">🎨</a> <a href="https://github.com/ESIPFed/science-on-schema/commits?author=rduerr" title="Code">💻</a> <a href="#content-rduerr" title="Content">🖋</a> <a href="https://github.com/ESIPFed/science-on-schema/commits?author=rduerr" title="Documentation">📖</a> <a href="#eventOrganizing-rduerr" title="Event Organizing">📋</a> <a href="#ideas-rduerr" title="Ideas, Planning, & Feedback">🤔</a> <a href="#maintenance-rduerr" title="Maintenance">🚧</a></td>
    <td align="center"><a href="https://github.com/chantelleverhey"><img src="https://avatars.githubusercontent.com/u/70176780?v=4?s=50" width="50px;" alt=""/><br /><sub><b>Chantelle Verhey</b></sub></a><br /><a href="#content-chantelleverhey" title="Content">🖋</a> <a href="https://github.com/ESIPFed/science-on-schema/commits?author=chantelleverhey" title="Documentation">📖</a> <a href="#ideas-chantelleverhey" title="Ideas, Planning, & Feedback">🤔</a></td>
  </tr>
  <tr>
    <td align="center"><a href="http://melindaminch.com/"><img src="https://avatars.githubusercontent.com/u/547883?v=4?s=50" width="50px;" alt=""/><br /><sub><b>Melinda Minch</b></sub></a><br /><a href="#content-nein09" title="Content">🖋</a> <a href="https://github.com/ESIPFed/science-on-schema/commits?author=nein09" title="Documentation">📖</a></td>
    <td align="center"><a href="https://brycemecum.com/"><img src="https://avatars.githubusercontent.com/u/563?v=4?s=50" width="50px;" alt=""/><br /><sub><b>Bryce Mecum</b></sub></a><br /><a href="https://github.com/ESIPFed/science-on-schema/commits?author=amoeba" title="Code">💻</a> <a href="#content-amoeba" title="Content">🖋</a> <a href="https://github.com/ESIPFed/science-on-schema/commits?author=amoeba" title="Documentation">📖</a></td>
    <td align="center"><a href="https://github.com/nokome"><img src="https://avatars.githubusercontent.com/u/1152336?v=4?s=50" width="50px;" alt=""/><br /><sub><b>Nokome Bentley</b></sub></a><br /><a href="#content-nokome" title="Content">🖋</a> <a href="https://github.com/ESIPFed/science-on-schema/commits?author=nokome" title="Documentation">📖</a></td>
    <td align="center"><a href="http://people.apache.org/keys/committer/lewismc"><img src="https://avatars.githubusercontent.com/u/1165719?v=4?s=50" width="50px;" alt=""/><br /><sub><b>Lewis John McGibbney</b></sub></a><br /><a href="#content-lewismc" title="Content">🖋</a> <a href="https://github.com/ESIPFed/science-on-schema/commits?author=lewismc" title="Documentation">📖</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/charlesvardeman"><img src="https://avatars.githubusercontent.com/u/64625?v=4?s=50" width="50px;" alt=""/><br /><sub><b>Charles Vardeman</b></sub></a><br /><a href="#content-charlesvardeman" title="Content">🖋</a> <a href="https://github.com/ESIPFed/science-on-schema/commits?author=charlesvardeman" title="Documentation">📖</a></td>
    <td align="center"><a href="http://people.csiro.au/C/S/Simon-Cox"><img src="https://avatars.githubusercontent.com/u/608303?v=4?s=50" width="50px;" alt=""/><br /><sub><b>Simon Cox</b></sub></a><br /><a href="#content-dr-shorthair" title="Content">🖋</a> <a href="https://github.com/ESIPFed/science-on-schema/commits?author=dr-shorthair" title="Documentation">📖</a></td>
    <td align="center"><a href="https://danbri.org/"><img src="https://avatars.githubusercontent.com/u/170265?v=4?s=50" width="50px;" alt=""/><br /><sub><b>Dan Brickley</b></sub></a><br /><a href="#content-danbri" title="Content">🖋</a> <a href="https://github.com/ESIPFed/science-on-schema/commits?author=danbri" title="Documentation">📖</a></td>
    <td align="center"><a href="https://github.com/HPeat"><img src="https://avatars.githubusercontent.com/u/57996021?v=4?s=50" width="50px;" alt=""/><br /><sub><b>HPeat</b></sub></a><br /><a href="#content-HPeat" title="Content">🖋</a> <a href="https://github.com/ESIPFed/science-on-schema/commits?author=HPeat" title="Documentation">📖</a></td>
  </tr>
  <tr>
    <td align="center"><a href="http://www.linkedin.com/in/johngraybeal/"><img src="https://avatars.githubusercontent.com/u/1266896?v=4?s=50" width="50px;" alt=""/><br /><sub><b>John Graybeal</b></sub></a><br /><a href="#content-graybeal" title="Content">🖋</a> <a href="https://github.com/ESIPFed/science-on-schema/commits?author=graybeal" title="Documentation">📖</a></td>
    <td align="center"><a href="https://github.com/ChantelRidsdale"><img src="https://avatars.githubusercontent.com/u/75498385?v=4?s=50" width="50px;" alt=""/><br /><sub><b>ChantelRidsdale</b></sub></a><br /><a href="#content-ChantelRidsdale" title="Content">🖋</a> <a href="https://github.com/ESIPFed/science-on-schema/commits?author=ChantelRidsdale" title="Documentation">📖</a> <a href="#ideas-ChantelRidsdale" title="Ideas, Planning, & Feedback">🤔</a></td>
    <td align="center"><a href="https://github.com/mcorlando"><img src="https://avatars.githubusercontent.com/u/8259475?v=4?s=50" width="50px;" alt=""/><br /><sub><b>mcorlando</b></sub></a><br /><a href="#content-mcorlando" title="Content">🖋</a> <a href="#eventOrganizing-mcorlando" title="Event Organizing">📋</a></td>
    <td align="center"><a href="https://github.com/johardi"><img src="https://avatars.githubusercontent.com/u/5062950?v=4?s=50" width="50px;" alt=""/><br /><sub><b>Josef Hardi</b></sub></a><br /><a href="#ideas-johardi" title="Ideas, Planning, & Feedback">🤔</a></td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/steingod"><img src="https://avatars.githubusercontent.com/u/5928452?v=4?s=50" width="50px;" alt=""/><br /><sub><b>Øystein Godøy</b></sub></a><br /><a href="#ideas-steingod" title="Ideas, Planning, & Feedback">🤔</a></td>
    <td align="center"><a href="https://github.com/RichardWallis"><img src="https://avatars.githubusercontent.com/u/13315406?v=4?s=50" width="50px;" alt=""/><br /><sub><b>Richard Wallis</b></sub></a><br /><a href="#ideas-RichardWallis" title="Ideas, Planning, & Feedback">🤔</a></td>
    <td align="center"><a href="http://cires.colorado.edu/~khalsa/"><img src="https://avatars.githubusercontent.com/u/10770264?v=4?s=50" width="50px;" alt=""/><br /><sub><b>Siri Jodha S Khalsa</b></sub></a><br /><a href="#ideas-sjskhalsa" title="Ideas, Planning, & Feedback">🤔</a></td>
    <td align="center"><a href="https://github.com/mathiasbockwoldt"><img src="https://avatars.githubusercontent.com/u/8100468?v=4?s=50" width="50px;" alt=""/><br /><sub><b>Mathias Bockwoldt</b></sub></a><br /><a href="#ideas-mathiasbockwoldt" title="Ideas, Planning, & Feedback">🤔</a></td>
  </tr>
</table>

<!-- markdownlint-restore -->
<!-- prettier-ignore-end -->

<!-- ALL-CONTRIBUTORS-LIST:END -->
<!-- ALL-CONTRIBUTORS-LIST:END -->

## Resources

* ESIP and this group
  * [Learn about ESIP](https://www.esipfed.org/)
  * [Join ESIP Slack](https://esip-slack-invite.herokuapp.com/) for real time chat
  * Chat on the [`sci-schemaorg`](https://esip-all.slack.com/archives/sci-schemaorg) Slack channel
  * [`sci-schemaorg` mailing list](https://lists.esipfed.org/mailman/listinfo/esip-schema-dot-org)
  * [`sci-schemaorg` wiki](http://wiki.esipfed.org/index.php/Schema.org_Cluster)
* History
  * This guide is a continuation of the [P418 NSF EarthCube](https://github.com/earthcubearchitecture-project418/p418Vocabulary) vocabulary guidance which ended in April 2018.
* Broader Community
  * [Schema.org development](https://github.com/schemaorg/schemaorg)
  * [Schema.org archived history](https://www.w3.org/wiki/index.php?title=WebSchemas/SchemaDotOrgProposalsArchive#2011-2014_Proposals_for_Schema.org), can be helpful when determining intent
  * [Data Catalog Vocabulary](https://www.w3.org/TR/vocab-dcat/) (DCAT)
  * [Bioschemas](https://bioschemas.org/)
  * [Geoschemas](https://geoschemas.org/)
  * [Shape Constraint Language](https://www.w3.org/TR/shacl/) (SHACL)
  * [Comparison of SHACL tool implementations](https://w3c.github.io/data-shapes/data-shapes-test-suite/#validate-rdf-data-tests)
* Tools
  * [Gleaner](https://gleaner.io) EarthCube developed tools for working with structure data 
  * [`exstruct`](https://github.com/scrapinghub/extruct) python tool for extracting microdata
  * [Schema.org Validator](https://validator.schema.org/)
  * [Google Rich Results Tool](https://search.google.com/test/rich-results)
  * [Google dataset search](https://toolbox.google.com/datasetsearch)
  * TopQuadrant TopBraid [SHACL validator](https://github.com/TopQuadrant/shacl)
  * [pySHACL](https://github.com/RDFLib/pySHACL)
  * [SHACL playground](https://shacl.org/playground/)

## License

Copyright [2022] [Adam Shepherd, Matthew B. Jones, Stephen Richard,  Nicolas Jarboe, Dave Vieglais, Douglas Fils, Ruth Duerr, Chantelle Verhey, Melinda Minch, Bryce Mecum, Nokome Bentley]

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

