library(readxl)
library(tidyverse)
library(janitor)
library(ggpubr)
library(scales)
library(agricolae)

MPT <- read_excel("Data/MPT Master file slim.xlsx")
#make things factors
MPT$Stage <- as.factor(MPT$Stage)
MPT$Temp <- as.factor(MPT$Temp)
summary(MPT)

#Cyp19A1 expression
Cmodel<-aov(((MPT$`Cyp19A1 Normalized`)^(.5))~ MPT$Temp * MPT$Stage, data=MPT)
summary(Cmodel)
par(mfrow=c(2,2))
plot(Cmodel)
hist(resid(Cmodel))

cypMPT <- HSD.test(Cmodel, trt = "MPT$Stage", group = TRUE)
cypMPT
# 15 b
# 17 a
# 18 ab
# 19 ab
# 20 ab
#20+ a  
TukeyHSD(Cmodel)

#Dmrt1 expression
Dmodel<-aov(((MPT$`Dmrt1 Normalized`)^(.5))~ MPT$Temp * MPT$Stage, data=MPT)
summary(Dmodel)
par(mfrow=c(2,2))
plot(Dmodel)
hist(resid(Dmodel))

dmMPT <- HSD.test(Dmodel, trt = "MPT$Stage", group = TRUE)
dmMPT
# 15 c
# 17 bc
# 18 b
# 19 a
# 20 a
# 20+ a  
TukeyHSD(Dmodel)

#Kdm6BDown2 expression
Kmodel<-aov((log(MPT$`Kdm6BDown2 Normalized`))~ MPT$Temp * MPT$Stage, data=MPT)
summary(Kmodel)
par(mfrow=c(2,2))
plot(Kmodel)
hist(resid(Kmodel))

#Foxl2 expression
Fmodel<-aov((log(MPT$`Foxl2 Normalized`))~ MPT$Temp * MPT$Stage, data=MPT)
summary(Fmodel)
par(mfrow=c(2,2))
plot(Fmodel)
hist(resid(Fmodel))

#Sox9 expression
Smodel<-aov((log(MPT$`Sox9 Normalized`))~ MPT$Temp * MPT$Stage, data=MPT)
summary(Smodel)
par(mfrow=c(2,2))
plot(Smodel)
hist(resid(Smodel))

TukeyHSD(Smodel)
sMPT <- HSD.test(Smodel, trt = "MPT$Stage", group = TRUE)
sMPT

#Sox4 expression
fourmodel<-aov((log(MPT$`Sox4 Normalized`))~ MPT$Temp * MPT$Stage, data=MPT)
summary(fourmodel)
par(mfrow=c(2,2))
plot(fourmodel)
hist(resid(fourmodel))

TukeyHSD(fourmodel)
fourcom <- HSD.test(fourmodel, trt = "MPT$Stage", group = TRUE)
fourcom

# new way of pivoting data -  not sure I like it as its cumbersome
# ^ that's a note from Bill. This converts the data to long format
mpt_long.df <- MPT %>% 
  pivot_longer(
    cols = c(`Kdm6BDown2 Normalized`, `Cyp19A1 Normalized`, `Dmrt1 Normalized`, `Foxl2 Normalized`, `Sox9 Normalized`, `Sox4 Normalized`),
    names_to = "Gene",
    values_to = "Expression"
  )

#####
#graphing

#MPTs- Kdm6BD2 - doesn't have letters- no effect of stage
y_ju <- expression(paste("Mean Normalized ", italic("Kdm6BDown2"), " expression (+/- SE)"))
# ^ I have to do this to only make part of the axis label italic

mpt_long.df %>% 
  filter(Gene == "Kdm6BDown2 Normalized") %>% 
  ggplot(aes(x=Stage, y=Expression, linetype=Temp, group=Temp)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="line",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="point",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun.data = mean_se, na.rm = TRUE,
               geom = "errorbar",
               width = 0.2,
               linetype="solid",
               position = position_dodge(0.2)) +
  scale_linetype_manual(name = "Temperature", 
                        values = c("dotted",  "solid"),
                        labels = c("26 Constant", "26 Flux")) +
  labs(x = "Developmental Stage", y = y_ju, 
       colour = "Temperature")+
  scale_y_continuous(labels = comma) + theme(axis.line = element_line(linetype = "solid"), 
                                             panel.background = element_rect(fill = NA), 
                                             strip.text = element_text(colour = NA), 
                                             legend.key = element_rect(fill = NA), 
                                             legend.background = element_rect(fill = NA))

#MPTs- Cyp19A1- letters done
y_aro <- expression(paste("Mean Normalized ", italic("Cyp19A1"), " expression (+/- SE)"))

mpt_long.df %>% 
  filter(Gene == "Cyp19A1 Normalized") %>% 
  ggplot(aes(x=Stage, y=Expression, linetype=Temp, group=Temp)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="line",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="point",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun.data = mean_se, na.rm = TRUE,
               geom = "errorbar",
               width = 0.2,
               linetype="solid",
               position = position_dodge(0.2)) +
  scale_linetype_manual(name = "Temperature", 
                        values = c("dotted",  "solid"),
                        labels = c("26 Constant", "26 Flux")) +
  labs(x = "Developmental Stage", y = y_aro, 
       colour = "Temperature")+
  scale_y_continuous(labels = comma) + theme(axis.line = element_line(linetype = "solid"), 
                                             panel.background = element_rect(fill = NA), 
                                             strip.text = element_text(colour = NA), 
                                             legend.key = element_rect(fill = NA), 
                                             legend.background = element_rect(fill = NA)) +
  annotate("text", x = "15", y = .0004, label= "a", fontface = "bold", size = 4) +
  annotate("text", x = "17", y = .00095, label= "b", fontface = "bold", size = 4) +
  annotate("text", x = "18", y = .00095, label= "ab", fontface = "bold", size = 4) +
  annotate("text", x = "19", y = .00105, label= "ab", fontface = "bold", size = 4) +
  annotate("text", x = "20", y = .00095, label= "ab", fontface = "bold", size = 4) +
  annotate("text", x = "20+", y = .00125, label= "b", fontface = "bold", size = 4)

#MPTs- Dmrt1 -letters done
y_dmr <- expression(paste("Mean Normalized ", italic("Dmrt1"), " expression (+/- SE)"))

mpt_long.df %>% 
  filter(Gene == "Dmrt1 Normalized") %>% 
  ggplot(aes(x=Stage, y=Expression, linetype=Temp, group=Temp)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="line",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="point",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun.data = mean_se, na.rm = TRUE,
               geom = "errorbar",
               width = 0.2,
               linetype="solid",
               position = position_dodge(0.2)) +
  scale_linetype_manual(name = "Temperature", 
                        values = c("dotted",  "solid"),
                        labels = c("26 Constant", "26 Flux")) +
  labs(x = "Developmental Stage", y = y_dmr, 
       colour = "Temperature")+
  scale_y_continuous(labels = comma) + theme(axis.line = element_line(linetype = "solid"), 
                                             panel.background = element_rect(fill = NA), 
                                             strip.text = element_text(colour = NA), 
                                             legend.key = element_rect(fill = NA), 
                                             legend.background = element_rect(fill = NA)) +
  annotate("text", x = "15", y = .0001, label= "a", fontface = "bold", size = 4) +
  annotate("text", x = "17", y = .00028, label= "ab", fontface = "bold", size = 4) +
  annotate("text", x = "18", y = .00032, label= "b", fontface = "bold", size = 4) +
  annotate("text", x = "19", y = .00065, label= "c", fontface = "bold", size = 4) +
  annotate("text", x = "20", y = .00065, label= "c", fontface = "bold", size = 4) +
  annotate("text", x = "20+", y = .00087, label= "c", fontface = "bold", size = 4)

#MPTs- Foxl2
y_f <- expression(paste("Mean Normalized ", italic("Foxl2"), " expression (+/- SE)"))

mpt_long.df %>% 
  filter(Gene == "Foxl2 Normalized") %>% 
  ggplot(aes(x=Stage, y=Expression, linetype=Temp, group=Temp)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="line",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="point",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun.data = mean_se, na.rm = TRUE,
               geom = "errorbar",
               width = 0.2,
               linetype="solid",
               position = position_dodge(0.2)) +
  scale_linetype_manual(name = "Temperature", 
                        values = c("dotted",  "solid"),
                        labels = c("26 Constant", "26 Flux")) +
  labs(x = "Developmental Stage", y = y_f, 
       colour = "Temperature") +
  scale_y_continuous(labels = comma) + theme(axis.line = element_line(linetype = "solid"), 
                                             panel.background = element_rect(fill = NA), 
                                             strip.text = element_text(colour = NA), 
                                             legend.key = element_rect(fill = NA), 
                                             legend.background = element_rect(fill = NA))

#Sox9
y_so <- expression(paste("Mean Normalized ", italic("Sox9"), " expression (+/- SE)"))

mpt_long.df %>% 
  filter(Gene == "Sox9 Normalized") %>% 
  ggplot(aes(x=Stage, y=Expression, linetype=Temp, group=Temp)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="line",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="point",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun.data = mean_se, na.rm = TRUE,
               geom = "errorbar",
               width = 0.2,
               linetype="solid",
               position = position_dodge(0.2)) +
  scale_linetype_manual(name = "Temperature", 
                        values = c("dotted",  "solid"),
                        labels = c("26 Constant", "26 Flux")) +
  labs(x = "Developmental Stage", y = y_so, 
       colour = "Temperature")+
  scale_y_continuous(labels = comma) + theme(axis.line = element_line(linetype = "solid"), 
                                             panel.background = element_rect(fill = NA), 
                                             strip.text = element_text(colour = NA), 
                                             legend.key = element_rect(fill = NA), 
                                             legend.background = element_rect(fill = NA)) +
  annotate("text", x = "15", y = .00046, label= "ab", fontface = "bold", size = 4) +
  annotate("text", x = "17", y = .00026, label= "b", fontface = "bold", size = 4) +
  annotate("text", x = "18", y = .0004, label= "ab", fontface = "bold", size = 4) +
  annotate("text", x = "19", y = .00032, label= "ab", fontface = "bold", size = 4) +
  annotate("text", x = "20", y = .00046, label= "a", fontface = "bold", size = 4) +
  annotate("text", x = "20+", y = .00089, label= "ab", fontface = "bold", size = 4)

y_kitty <- expression(paste("Mean Normalized ", italic("Sox4"), " expression (+/- SE)"))
# ^ I have to do this to only make part of the axis label italic

mpt_long.df %>% 
  filter(Gene == "Sox4 Normalized") %>% 
  ggplot(aes(x=Stage, y=Expression, linetype=Temp, group=Temp)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="line",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="point",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun.data = mean_se, na.rm = TRUE,
               geom = "errorbar",
               width = 0.2,
               linetype="solid",
               position = position_dodge(0.2)) +
  scale_linetype_manual(name = "Temperature", 
                        values = c("dotted",  "solid"),
                        labels = c("26 Constant", "26 Flux")) +
  labs(x = "Developmental Stage", y = y_kitty, 
       colour = "Temperature")+
  scale_y_continuous(labels = comma) + theme(axis.line = element_line(linetype = "solid"), 
                                             panel.background = element_rect(fill = NA), 
                                             strip.text = element_text(colour = NA), 
                                             legend.key = element_rect(fill = NA), 
                                             legend.background = element_rect(fill = NA)) +
  annotate("text", x = "15", y = .0177, label= "a", fontface = "bold", size = 4) +
  annotate("text", x = "17", y = .01, label= "b", fontface = "bold", size = 4) +
  annotate("text", x = "18", y = .0123, label= "ab", fontface = "bold", size = 4) +
  annotate("text", x = "19", y = .0105, label= "b", fontface = "bold", size = 4) +
  annotate("text", x = "20", y = .009, label= "b", fontface = "bold", size = 4) +
  annotate("text", x = "20+", y = .008, label= "b", fontface = "bold", size = 4)

#FPTs
FPT <- read_excel("Data/FPT Master file slim copy.xlsx")

FPT$Stage <- as.factor(FPT$Stage)
FPT$Temp <- as.factor(FPT$Temp)

fpt_long.df <- FPT %>% 
  pivot_longer(
    cols = c(`Kdm6BDown2 Normalized`, `Cyp19A1 Normalized`, `Dmrt1 Normalized`, `Foxl2 Normalized`, `Sox9 Normalized`, `Sox4 Normalized`),
    names_to = "Gene",
    values_to = "Expression"
  )

Cymodel<-aov(((FPT$`Cyp19A1 Normalized`)^(.5))~ FPT$Temp * FPT$Stage, data=FPT)
summary(Cymodel)
par(mfrow=c(2,2))
plot(Cymodel)
hist(resid(Cymodel))

TukeyHSD(Cymodel)

cypFPT <- HSD.test(Cymodel, trt = "FPT$Stage", group = TRUE)
cypFPT

#FPTs- Cyp19A1- letters done
y_cy <- expression(paste("Mean Normalized ", italic("Cyp19A1"), " expression (+/- SE)"))

fpt_long.df %>% 
  filter(Gene == "Cyp19A1 Normalized") %>% 
  ggplot(aes(x=Stage, y=Expression, linetype=Temp, group=Temp)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="line",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="point",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun.data = mean_se, na.rm = TRUE,
               geom = "errorbar",
               width = 0.2,
               linetype="solid",
               position = position_dodge(0.2)) +
  scale_linetype_manual(name = "Temperature", 
                        values = c("dotted",  "solid"),
                        labels = c("31 Constant", "31 Flux")) +
  labs(x = "Developmental Stage", y = y_cy, 
       colour = "Temperature") +
  scale_y_continuous(labels = comma) + theme(axis.line = element_line(linetype = "solid"), 
                                             panel.background = element_rect(fill = NA), 
                                             strip.text = element_text(colour = NA), 
                                             legend.key = element_rect(fill = NA), 
                                             legend.background = element_rect(fill = NA)) +
  annotate("text", x = "17-18", y = .0015, label= "a", fontface = "bold", size = 4) +
  annotate("text", x = "20", y = .002, label= "ab", fontface = "bold", size = 4) +
  annotate("text", x = "22", y = .0023, label= "abc", fontface = "bold", size = 4) +
  annotate("text", x = "23", y = .004, label= "c", fontface = "bold", size = 4) +
  annotate("text", x = "24", y = .0033, label= "bc", fontface = "bold", size = 4)

#FPTs- Kdm6BD2- letters done
Kdmodel<-aov((log(FPT$`Kdm6BDown2 Normalized`))~ FPT$Temp * FPT$Stage, data=FPT)
summary(Kdmodel)
par(mfrow=c(2,2))
plot(Kdmodel)
hist(resid(Kdmodel))

TukeyHSD(Kdmodel)

kdFPT <- HSD.test(Kdmodel, trt = "FPT$Stage", group = TRUE)
kdFPT

y_kd <- expression(paste("Mean Normalized ", italic("Kdm6BDown2"), " expression (+/- SE)"))

fpt_long.df %>% 
  filter(Gene == "Kdm6BDown2 Normalized") %>% 
  ggplot(aes(x=Stage, y=Expression, linetype=Temp, group=Temp)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="line",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="point",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun.data = mean_se, na.rm = TRUE,
               geom = "errorbar",
               width = 0.2,
               linetype="solid",
               position = position_dodge(0.2)) +
  scale_linetype_manual(name = "Temperature", 
                        values = c("dotted",  "solid"),
                        labels = c("31 Constant", "31 Flux")) +
  labs(x = "Developmental Stage", y = y_kd, 
       colour = "Temperature") +
  scale_y_continuous(labels = comma) + theme(axis.line = element_line(linetype = "solid"), 
                                             panel.background = element_rect(fill = NA), 
                                             strip.text = element_text(colour = NA), 
                                             legend.key = element_rect(fill = NA), 
                                             legend.background = element_rect(fill = NA)) +
  annotate("text", x = "17-18", y = .0001, label= "ab", fontface = "bold", size = 4) +
  annotate("text", x = "20", y = .000137, label= "a", fontface = "bold", size = 4) +
  annotate("text", x = "22", y = .00007, label= "bc", fontface = "bold", size = 4) +
  annotate("text", x = "23", y = .00005, label= "c", fontface = "bold", size = 4) +
  annotate("text", x = "24", y = .000037, label= "c", fontface = "bold", size = 4)
  

#FPTs- Dmrt1- letters DONE
Dmmodel<-aov((log(FPT$`Dmrt1 Normalized`))~ FPT$Temp * FPT$Stage, data=FPT)
summary(Dmmodel)
par(mfrow=c(2,2))
plot(Dmmodel)
hist(resid(Dmmodel))

TukeyHSD(Dmmodel)

DmFPT <- HSD.test(Dmmodel, trt = "FPT$Stage", group = TRUE)
DmFPT

y_mon <- expression(paste("Mean Normalized ", italic("Dmrt1"), " expression (+/- SE)"))

fpt_long.df %>% 
  filter(Gene == "Dmrt1 Normalized") %>% 
  ggplot(aes(x=Stage, y=Expression, linetype=Temp, group=Temp)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="line",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="point",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun.data = mean_se, na.rm = TRUE,
               geom = "errorbar",
               width = 0.2,
               linetype="solid",
               position = position_dodge(0.2)) +
  scale_linetype_manual(name = "Temperature", 
                        values = c("dotted",  "solid"),
                        labels = c("31 Constant", "31 Flux")) +
  labs(x = "Developmental Stage", y = y_mon, 
       colour = "Temperature") +
  scale_y_continuous(labels = comma) + theme(axis.line = element_line(linetype = "solid"), 
                                             panel.background = element_rect(fill = NA), 
                                             strip.text = element_text(colour = NA), 
                                             legend.key = element_rect(fill = NA), 
                                             legend.background = element_rect(fill = NA)) +
  annotate("text", x = "17-18", y = .000072, label= "a", fontface = "bold", size = 4) +
  annotate("text", x = "20", y = .000047, label= "ab", fontface = "bold", size = 4) +
  annotate("text", x = "22", y = .000028, label= "b", fontface = "bold", size = 4) +
  annotate("text", x = "23", y = .00004, label= "b", fontface = "bold", size = 4) +
  annotate("text", x = "24", y = .000036, label= "b", fontface = "bold", size = 4)

#FPTs- Foxl2
fomodel<-aov((log(FPT$`Foxl2 Normalized`))~ FPT$Temp * FPT$Stage, data=FPT)
summary(fomodel)
par(mfrow=c(2,2))
plot(fomodel)
hist(resid(fomodel))

TukeyHSD(fomodel)
foxturk <- HSD.test(fomodel, trt = "FPT$Stage", group = TRUE)
foxturk

y_foxy <- expression(paste("Mean Normalized ", italic("Foxl2"), " expression (+/- SE)"))

fpt_long.df %>% 
  filter(Gene == "Foxl2 Normalized") %>% 
  ggplot(aes(x=Stage, y=Expression, linetype=Temp, group=Temp)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="line",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="point",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun.data = mean_se, na.rm = TRUE,
               geom = "errorbar",
               width = 0.2,
               linetype="solid",
               position = position_dodge(0.2)) +
  scale_linetype_manual(name = "Temperature", 
                        values = c("dotted",  "solid"),
                        labels = c("31 Constant", "31 Flux")) +
  labs(x = "Developmental Stage", y = y_foxy, 
       colour = "Temperature") +
  scale_y_continuous(labels = comma) + theme(axis.line = element_line(linetype = "solid"), 
                                             panel.background = element_rect(fill = NA), 
                                             strip.text = element_text(colour = NA), 
                                             legend.key = element_rect(fill = NA), 
                                             legend.background = element_rect(fill = NA)) +
  annotate("text", x = "17-18", y = .00025, label= "a", fontface = "bold", size = 4) +
  annotate("text", x = "20", y = .0011, label= "b", fontface = "bold", size = 4) +
  annotate("text", x = "22", y = .0005, label= "b", fontface = "bold", size = 4) +
  annotate("text", x = "23", y = .00075, label= "b", fontface = "bold", size = 4) +
  annotate("text", x = "24", y = .0005, label= "b", fontface = "bold", size = 4) 

# Sox9
Soxmodel<-aov((log(FPT$`Sox9 Normalized`))~ FPT$Temp * FPT$Stage, data=FPT)
summary(Soxmodel)
par(mfrow=c(2,2))
plot(Soxmodel)
hist(resid(Soxmodel))

y_soxy <- expression(paste("Mean Normalized ", italic("Sox9"), " expression (+/- SE)"))

fpt_long.df %>% 
  filter(Gene == "Sox9 Normalized") %>% 
  ggplot(aes(x=Stage, y=Expression, linetype=Temp, group=Temp)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="line",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="point",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun.data = mean_se, na.rm = TRUE,
               geom = "errorbar",
               width = 0.2,
               linetype="solid",
               position = position_dodge(0.2)) +
  scale_linetype_manual(name = "Temperature", 
                        values = c("dotted",  "solid"),
                        labels = c("31 Constant", "31 Flux")) +
  labs(x = "Developmental Stage", y = y_soxy, 
       colour = "Temperature") +
  scale_y_continuous(labels = comma) + theme(axis.line = element_line(linetype = "solid"), 
                                             panel.background = element_rect(fill = NA), 
                                             strip.text = element_text(colour = NA), 
                                             legend.key = element_rect(fill = NA), 
                                             legend.background = element_rect(fill = NA))

#Sox4 expression
katmodel<-aov((log(FPT$`Sox4 Normalized`))~ FPT$Temp * FPT$Stage, data=FPT)
summary(katmodel)
par(mfrow=c(2,2))
plot(katmodel)
hist(resid(katmodel))

TukeyHSD(katmodel)
katFPT <- HSD.test(katmodel, trt = "FPT$Stage", group = TRUE)
katFPT

y_big <- expression(paste("Mean Normalized ", italic("Sox4"), " expression (+/- SE)"))

fpt_long.df %>% 
  filter(Gene == "Sox4 Normalized") %>% 
  ggplot(aes(x=Stage, y=Expression, linetype=Temp, group=Temp)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="line",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="point",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun.data = mean_se, na.rm = TRUE,
               geom = "errorbar",
               width = 0.2,
               linetype="solid",
               position = position_dodge(0.2)) +
  scale_linetype_manual(name = "Temperature", 
                        values = c("dotted",  "solid"),
                        labels = c("31 Constant", "31 Flux")) +
  labs(x = "Developmental Stage", y = y_big, 
       colour = "Temperature") +
  scale_y_continuous(labels = comma) + theme(axis.line = element_line(linetype = "solid"), 
                                             panel.background = element_rect(fill = NA), 
                                             strip.text = element_text(colour = NA), 
                                             legend.key = element_rect(fill = NA), 
                                             legend.background = element_rect(fill = NA)) +
  annotate("text", x = "17-18", y = .0205, label= "a", fontface = "bold", size = 4) +
  annotate("text", x = "20", y = .0172, label= "a", fontface = "bold", size = 4) +
  annotate("text", x = "22", y = .012, label= "ab", fontface = "bold", size = 4) +
  annotate("text", x = "23", y = .0105, label= "bc", fontface = "bold", size = 4) +
  annotate("text", x = "24", y = .008, label= "c", fontface = "bold", size = 4)

comp <- read_excel("Data/compiled graphs.xlsx")
comp$Stage <- as.factor(comp$Stage)
comp$Temperature <- as.factor(comp$Temperature)

comp_long.df <- comp %>% 
  pivot_longer(
    cols = c(`Kdm6B`, `Cyp19A1`, `Dmrt1`, `Foxl2`, `Sox9`, `Sox4`),
    names_to = "Gene",
    values_to = "Expression"
  )

y_cy <- expression(paste("Mean Normalized ", italic("Cyp19A1"), " expression (± SE)"))
y_dmrt1 <- expression(paste("Mean Normalized ", italic("Dmrt1"), " expression (± SE)"))
y_kdm6b <- expression(paste("Mean Normalized ", italic("Kdm6b"), " expression (± SE)"))
y_foxl2 <- expression(paste("Mean Normalized ", italic("Foxl2"), " expression (± SE)"))
y_sox9 <- expression(paste("Mean Normalized ", italic("Sox9"), " expression (± SE)"))
y_sox4 <-expression(paste("Mean Normalized ", italic("Sox4"), " expression (± SE)"))

drop_na(comp_long.df) %>%
  filter(Gene == "Cyp19A1") %>% 
  ggplot(aes(x=Stage, y=Expression, linetype=Temperature, group=Temperature, color=Temperature, na.rm = TRUE)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="line",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="point",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun.data = mean_se, na.rm = TRUE,
               geom = "errorbar",
               width = 0.2,
               linetype="solid",
               position = position_dodge(0.2)) +
  scale_linetype_manual(name = "Temperature", 
                        values = c("solid",  "dashed", "solid", "dashed"),
                        labels = c("26 Constant", "26 Flux", "31 Constant", "31 Flux")) +
  scale_color_manual(breaks = c("26 Constant", "26 Flux", "31 Constant", "31 Flux"),
                     values=c("grey", "grey", "black", "black")) +
  labs(x = "Developmental Stage", y = y_cy, 
       colour = "Temperature") +
  scale_y_continuous(labels = comma) + theme(axis.line = element_line(linetype = "solid"), 
                                             panel.background = element_rect(fill = NA), 
                                             strip.text = element_text(colour = NA), 
                                             legend.key = element_rect(fill = NA), 
                                             legend.background = element_rect(fill = NA)) +
  annotate("text", x = "17-18", y = .0013, label= "a", fontface = "bold", size = 4) +
  annotate("text", x = "20", y = .0019, label= "ab", fontface = "bold", size = 4) +
  annotate("text", x = "22", y = .0023, label= "abc", fontface = "bold", size = 4) +
  annotate("text", x = "23", y = .004, label= "c", fontface = "bold", size = 4) +
  annotate("text", x = "24", y = .0033, label= "bc", fontface = "bold", size = 4)

drop_na(comp_long.df) %>% 
  filter(Gene == "Dmrt1") %>% 
  ggplot(aes(x=Stage, y=Expression, linetype=Temperature, group=Temperature, color=Temperature)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="line",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="point",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun.data = mean_se, na.rm = TRUE,
               geom = "errorbar",
               width = 0.2,
               linetype="solid",
               position = position_dodge(0.2)) +
  scale_linetype_manual(name = "Temperature", 
                        values = c("solid",  "dashed", "solid", "dashed"),
                        labels = c("26 Constant", "26 Flux", "31 Constant", "31 Flux")) +
  scale_color_manual(breaks = c("26 Constant", "26 Flux", "31 Constant", "31 Flux"),
                     values=c("black", "black", "grey", "grey")) +
  labs(x = "Developmental Stage", y = y_dmrt1, 
       colour = "Temperature")+
  scale_y_continuous(labels = comma) + theme(axis.line = element_line(linetype = "solid"), 
                                             panel.background = element_rect(fill = NA), 
                                             strip.text = element_text(colour = NA), 
                                             legend.key = element_rect(fill = NA), 
                                             legend.background = element_rect(fill = NA)) +
  annotate("text", x = "15", y = .0001, label= "a", fontface = "bold", size = 4) +
  annotate("text", x = "17", y = .00028, label= "ab", fontface = "bold", size = 4) +
  annotate("text", x = "18", y = .00032, label= "b", fontface = "bold", size = 4) +
  annotate("text", x = "19", y = .00065, label= "c", fontface = "bold", size = 4) +
  annotate("text", x = "20", y = .00065, label= "c", fontface = "bold", size = 4) +
  annotate("text", x = "20+", y = .00087, label= "c", fontface = "bold", size = 4)

drop_na(comp_long.df) %>% 
  filter(Gene == "Kdm6B") %>% 
  ggplot(aes(x=Stage, y=Expression, linetype=Temperature, group=Temperature, color=Temperature)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="line",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="point",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun.data = mean_se, na.rm = TRUE,
               geom = "errorbar",
               width = 0.2,
               linetype="solid",
               position = position_dodge(0.2)) +
  scale_linetype_manual(name = "Temperature", 
                        values = c("solid",  "dashed", "solid", "dashed"),
                        labels = c("26 Constant", "26 Flux", "31 Constant", "31 Flux")) +
  scale_color_manual(breaks = c("26 Constant", "26 Flux", "31 Constant", "31 Flux"),
                     values=c("black", "black", "grey", "grey")) +
  labs(x = "Developmental Stage", y = y_kdm6b, 
       colour = "Temperature")+
  scale_y_continuous(labels = comma) + theme(axis.line = element_line(linetype = "solid"), 
                                             panel.background = element_rect(fill = NA), 
                                             strip.text = element_text(colour = NA), 
                                             legend.key = element_rect(fill = NA), 
                                             legend.background = element_rect(fill = NA))

drop_na(comp_long.df) %>% 
  filter(Gene == "Foxl2") %>% 
  ggplot(aes(x=Stage, y=Expression, linetype=Temperature, group=Temperature, color=Temperature)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="line",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="point",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun.data = mean_se, na.rm = TRUE,
               geom = "errorbar",
               width = 0.2,
               linetype="solid",
               position = position_dodge(0.2)) +
  scale_linetype_manual(name = "Temperature", 
                        values = c("solid",  "dashed", "solid", "dashed"),
                        labels = c("26 Constant", "26 Flux", "31 Constant", "31 Flux")) +
  scale_color_manual(breaks = c("26 Constant", "26 Flux", "31 Constant", "31 Flux"),
                     values=c("grey", "grey", "black", "black")) +
  labs(x = "Developmental Stage", y = y_foxl2, 
       colour = "Temperature")+
  scale_y_continuous(labels = comma) + theme(axis.line = element_line(linetype = "solid"), 
                                             panel.background = element_rect(fill = NA), 
                                             strip.text = element_text(colour = NA), 
                                             legend.key = element_rect(fill = NA), 
                                             legend.background = element_rect(fill = NA)) +
  annotate("text", x = "17-18", y = .00025, label= "a", fontface = "bold", size = 4) +
  annotate("text", x = "20", y = .00128, label= "b", fontface = "bold", size = 4) +
  annotate("text", x = "22", y = .0005, label= "b", fontface = "bold", size = 4) +
  annotate("text", x = "23", y = .00075, label= "b", fontface = "bold", size = 4) +
  annotate("text", x = "24", y = .0005, label= "b", fontface = "bold", size = 4)

drop_na(comp_long.df) %>% 
  filter(Gene == "Sox9") %>% 
  ggplot(aes(x=Stage, y=Expression, linetype=Temperature, group=Temperature, color=Temperature)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="line",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="point",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun.data = mean_se, na.rm = TRUE,
               geom = "errorbar",
               width = 0.2,
               linetype="solid",
               position = position_dodge(0.2)) +
  scale_linetype_manual(name = "Temperature", 
                        values = c("solid",  "dashed", "solid", "dashed"),
                        labels = c("26 Constant", "26 Flux", "31 Constant", "31 Flux")) +
  scale_color_manual(breaks = c("26 Constant", "26 Flux", "31 Constant", "31 Flux"),
                     values=c("black", "black", "grey", "grey")) +
  labs(x = "Developmental Stage", y = y_sox9, 
       colour = "Temperature")+
  scale_y_continuous(labels = comma) + theme(axis.line = element_line(linetype = "solid"), 
                                             panel.background = element_rect(fill = NA), 
                                             strip.text = element_text(colour = NA), 
                                             legend.key = element_rect(fill = NA), 
                                             legend.background = element_rect(fill = NA)) +
  annotate("text", x = "15", y = .00046, label= "ab", fontface = "bold", size = 4) +
  annotate("text", x = "17", y = .00026, label= "b", fontface = "bold", size = 4) +
  annotate("text", x = "18", y = .0004, label= "ab", fontface = "bold", size = 4) +
  annotate("text", x = "19", y = .00032, label= "ab", fontface = "bold", size = 4) +
  annotate("text", x = "20", y = .00046, label= "a", fontface = "bold", size = 4) +
  annotate("text", x = "20+", y = .00089, label= "ab", fontface = "bold", size = 4)

drop_na(comp_long.df) %>% 
  filter(Gene == "Sox4") %>% 
  ggplot(aes(x=Stage, y=Expression, linetype=Temperature, group=Temperature, color=Temperature)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="line",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="point",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun.data = mean_se, na.rm = TRUE,
               geom = "errorbar",
               width = 0.2,
               linetype="solid",
               position = position_dodge(0.2)) +
  scale_linetype_manual(name = "Temperature", 
                        values = c("solid",  "dashed", "dotdash", "dotted"),
                        labels = c("26 Constant", "26 Flux", "31 Constant", "31 Flux")) +
  scale_color_manual(breaks = c("26 Constant", "26 Flux", "31 Constant", "31 Flux"),
                     values=c("black", "black", "black", "black")) +
  labs(x = "Developmental Stage", y = y_sox4, 
       colour = "Temperature")+
  scale_y_continuous(labels = comma) + theme(axis.line = element_line(linetype = "solid"), 
                                             panel.background = element_rect(fill = NA), 
                                             strip.text = element_text(colour = NA), 
                                             legend.key = element_rect(fill = NA), 
                                             legend.background = element_rect(fill = NA))

#IL samples
illa <- read_excel("Data/IL and LA samples.xlsx")
cflux <- read_excel("Data/IL samples.xlsx")
#make things factors
illa$Stage <- as.factor(illa$Stage)
illa$Treatment <- as.factor(illa$Treatment)
summary(labfield)

cflux$Population <- as.factor(cflux$Population)
cflux$Sday <- as.factor(cflux$Sday)

hist(cflux$`Cyp19A1 Normalized`)
hist(log(cflux$`Cyp19A1 Normalized`))
hist(cflux$`Dmrt1 Normalized`)
hist(log(cflux$`Dmrt1 Normalized`))

cfmodel<-aov((log(cflux$`Cyp19A1 Normalized`))~ cflux$Population * cflux$Sday, data=cflux)
summary(cfmodel)
par(mfrow=c(2,2))
plot(cfmodel)
hist(resid(cfmodel))

cfdmodel <- aov((log(cflux$`Dmrt1 Normalized`))~ cflux$Population * cflux$Sday, data = cflux)
summary(cfdmodel)
par(mfrow=c(2,2))
plot(cfdmodel)
hist(resid(cfdmodel))

illa %>% 
  ggplot(aes(x=Stage, y=`Cyp19A1 Normalized`, linetype=Treatment, group=Treatment, color=Treatment)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="line",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="point",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun.data = mean_se, na.rm = TRUE,
               geom = "errorbar",
               width = 0.2,
               linetype="solid",
               position = position_dodge(0.2)) +
  scale_linetype_manual(name = "Treatment", 
                        values = c("solid",  "dashed", "dotdash"),
                        labels = c("IL 26 Flux", "LA 26 Flux", "IL Field")) +
  scale_color_manual(breaks = c("IL 26 Flux", "LA 26 Flux", "IL Field"),
                     values=c("black", "black", "grey")) +
  labs(x = "Developmental Stage", y = "Mean Normalized Cyp19A1 Expression", 
       colour = "Treatment")+
  scale_x_continuous(breaks=c(12, 13, 14, 15, 16, 17, 18, 19, 20, 21),
                     labels = c(12, 13, 14, 15, 16, 17, 18, 19, 20, 21)) +
  scale_y_continuous(labels = comma) + theme(axis.line = element_line(linetype = "solid"), 
                                             panel.background = element_rect(fill = NA), 
                                             strip.text = element_text(colour = NA), 
                                             legend.key = element_rect(fill = NA), 
                                             legend.background = element_rect(fill = NA))

illa %>% 
  ggplot(aes(x=Stage, y=`Dmrt1 Normalized`, linetype=Treatment, group=Treatment, color=Treatment)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="line",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="point",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun.data = mean_se, na.rm = TRUE,
               geom = "errorbar",
               width = 0.2,
               linetype="solid",
               position = position_dodge(0.2)) +
  scale_linetype_manual(name = "Treatment", 
                        values = c("solid",  "dashed", "dotdash"),
                        labels = c("IL 26 Flux", "LA 26 Flux", "IL Field")) +
  scale_color_manual(breaks = c("IL 26 Flux", "LA 26 Flux", "IL Field"),
                     values=c("black", "black", "grey")) +
  labs(x = "Developmental Stage", y = "Mean Normalized Dmrt1 Expression", 
       colour = "Treatment")+
  scale_x_continuous(breaks=c(12, 13, 14, 15, 16, 17, 18, 19, 20, 21),
                     labels = c(12, 13, 14, 15, 16, 17, 18, 19, 20, 21)) +
  scale_y_continuous(labels = comma) + theme(axis.line = element_line(linetype = "solid"), 
                                             panel.background = element_rect(fill = NA), 
                                             strip.text = element_text(colour = NA), 
                                             legend.key = element_rect(fill = NA), 
                                             legend.background = element_rect(fill = NA))

#continuous x axis figures
library(tidyverse)
library(car)
library(lme4)
library(ggplot2)
library(readxl)
library(emmeans)
library(mvabund)

newmoda <- read_excel("Data/glmMPT.xlsx")
newmoda$Trt <- as.factor(newmoda$Trt)
newmoda$Stage <- as.factor(newmoda$Stage)

fptgener <- read_excel("Data/glmFPT.xlsx")
fptgener$Trt <- as.factor(fptgener$Trt)
fptgener$Stage <- as.factor(fptgener$Stage)

continuous <- read_excel("Data/contNO.xlsx")
continuous$Trt <- as.factor(continuous$Trt)

cont_long.df <- continuous %>% 
  pivot_longer(
    cols = c(`Kdm6b`, `Cyp19A1`, `Dmrt1`, `Foxl2`, `Sox9`, `Sox4`),
    names_to = "Gene",
    values_to = "Expression"
  )


glmkdm<-glm(Kdm6b~Trt + Stage + Trt*Stage, data = newmoda)
summary(glmkdm)
coef(glmkdm)
drop1(glmkdm, test = "Chisq")
Anova(glmkdm)
par(mfrow=c(2,2))
plot(glmkdm)

glmdmr<-glm(Dmrt1~Trt + Stage + Trt*Stage, data = newmoda)
summary(glmdmr)
coef(glmdmr)
drop1(glmdmr, test = "Chisq")
Anova(glmdmr)
par(mfrow=c(2,2))
plot(glmdmr)

glmsox<-glm(Sox9~Trt + Stage + Trt*Stage, data = newmoda)
summary(glmsox)
coef(glmsox)
drop1(glmsox, test = "Chisq")
Anova(glmsox)
par(mfrow=c(2,2))
plot(glmsox)

glmcyp<-glm(Cyp19A1~Trt + Stage + Trt*Stage, data = fptgener)
summary(glmcyp)
coef(glmcyp)
drop1(glmcyp, test = "Chisq")
Anova(glmcyp)
par(mfrow=c(2,2))
plot(glmcyp)

glmfox<-glm(Foxl2~Trt + Stage + Trt*Stage, data = fptgener)
summary(glmfox)
coef(glmfox)
drop1(glmfox, test = "Chisq")
Anova(glmfox)
par(mfrow=c(2,2))
plot(glmfox)


y_cy <- expression(paste("Mean Normalized ", italic("Cyp19A1"), " expression (± SE)"))
y_dmrt1 <- expression(paste("Mean Normalized ", italic("Dmrt1"), " expression (± SE)"))
y_kdm6b <- expression(paste("Mean Normalized ", italic("Kdm6b"), " expression (± SE)"))
y_foxl2 <- expression(paste("Mean Normalized ", italic("Foxl2"), " expression (± SE)"))
y_sox9 <- expression(paste("Mean Normalized ", italic("Sox9"), " expression (± SE)"))
y_sox4 <-expression(paste("Mean Normalized ", italic("Sox4"), " expression (± SE)"))

drop_na(cont_long.df) %>%
  filter(Gene == "Cyp19A1") %>% 
  ggplot(aes(x=Stage, y=Expression, linetype=Trt, group=Trt, color=Trt, na.rm = TRUE)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="line",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="point",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun.data = mean_se, na.rm = TRUE,
               geom = "errorbar",
               width = 0.2,
               linetype="solid",
               position = position_dodge(0.2)) +
  scale_linetype_manual(name = "Temperature", 
                        values = c("solid",  "dashed", "solid", "dashed"),
                        labels = c("26 Constant", "26 Flux", "31 Constant", "31 Flux")) +
  scale_color_manual(breaks = c("26 Constant", "26 Flux", "31 Constant", "31 Flux"),
                     values=c("royalblue2", "royalblue2", "dark orange", "dark orange")) +
  labs(x = "Developmental Stage", y = "Mean Normalized Expression (± SE)", 
       colour = "Temperature") +
  scale_y_continuous(labels = scales::scientific) +
  scale_x_continuous(breaks=c(15, 16, 17, 18, 19, 20, 21, 22, 23, 24),
                     labels = c(15, 16, 17, 18, 19, 20, 21, 22, 23, 24)) +
  theme(axis.line = element_line(linetype = "solid"), 
                                             panel.background = element_rect(fill = NA), 
                                             strip.text = element_text(colour = NA), 
                                             legend.key = element_rect(fill = NA), 
                                             legend.background = element_rect(fill = NA)) +
  #annotate("text", x = 17.5, y = .0013, label= "a", fontface = "bold", size = 4) +
  #annotate("text", x = 20, y = .0019, label= "ab", fontface = "bold", size = 4) +
  #annotate("text", x = 22, y = .0023, label= "abc", fontface = "bold", size = 4) +
  #annotate("text", x = 23, y = .004, label= "c", fontface = "bold", size = 4) +
  #annotate("text", x = 24, y = .0033, label= "bc", fontface = "bold", size = 4) + 
  theme(axis.title = element_text(size = 12), 
        axis.text = element_text(size = 11), 
        legend.text = element_text(size = 12), 
        legend.title = element_text(size = 12))
  #annotate("text", x = 16.5, y = .004, label=expression(paste(italic("Cyp19A1"))), size = 6) +
  #annotate("text", x = 18.18, y = .00346, parse = TRUE, size = 5,
  #         label = as.character(expression(paste(italic("F"[1][","][45]), " = 1.08, ", paste(italic("p"), " = 0.30"))))) +
  #annotate("text", x = 17.55, y = .00375, label="Constant vs. Flux", size = 5)

cyplabel <- as.character(expression(paste(italic("F"), "[1,45] = 1.08, ", paste(italic("p"), " = 0.30"))))

drop_na(cont_long.df) %>%
  filter(Gene == "Dmrt1") %>% 
  ggplot(aes(x=Stage, y=Expression, linetype=Trt, group=Trt, color=Trt, na.rm = TRUE)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="line",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="point",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun.data = mean_se, na.rm = TRUE,
               geom = "errorbar",
               width = 0.2,
               linetype="solid",
               position = position_dodge(0.2)) +
  scale_linetype_manual(name = "Temperature", 
                        values = c("solid",  "dashed", "solid", "dashed"),
                        labels = c("26 Constant", "26 Flux", "31 Constant", "31 Flux")) +
  scale_color_manual(breaks = c("26 Constant", "26 Flux", "31 Constant", "31 Flux"),
                     values=c("royalblue2", "royalblue2", "dark orange", "dark orange")) +
  labs(x = "Developmental Stage", y = "Mean Normalized Expression (± SE)", 
       colour = "Temperature") +
  scale_y_continuous(labels = scales::scientific) +
  scale_x_continuous(breaks=c(15, 16, 17, 18, 19, 20, 21, 22, 23, 24),
                     labels = c(15, 16, 17, 18, 19, 20, 21, 22, 23, 24)) +
  theme(axis.line = element_line(linetype = "solid"), 
        panel.background = element_rect(fill = NA), 
        strip.text = element_text(colour = NA), 
        legend.key = element_rect(fill = NA), 
        legend.background = element_rect(fill = NA)) +
  #annotate("text", x = 15, y = .0001, label= "a", fontface = "bold", size = 4) +
  #annotate("text", x = 17, y = .00028, label= "ab", fontface = "bold", size = 4) +
  #annotate("text", x = 18, y = .00032, label= "b", fontface = "bold", size = 4) +
  #annotate("text", x = 19, y = .00065, label= "c", fontface = "bold", size = 4) +
  #annotate("text", x = 20, y = .00065, label= "c", fontface = "bold", size = 4) +
  #annotate("text", x = 21, y = .00087, label= "c", fontface = "bold", size = 4) + 
  theme(axis.title = element_text(size = 12), 
        axis.text = element_text(size = 11), 
        legend.text = element_text(size = 12), 
        legend.title = element_text(size = 12))
  #annotate("text", x = 16, y = .00099, label=expression(paste(italic("Dmrt1"))), size = 6) +
  #annotate("text", x = 18.18, y = .00086, parse = TRUE, size = 5,
   #        label = as.character(expression(paste(italic("F"[1][","][52]), " = 0.16, ", paste(italic("p"), " = 0.69"))))) +
  #annotate("text", x = 17.55, y = .00093, label="Constant vs. Flux", size = 5)


drop_na(cont_long.df) %>%
  filter(Gene == "Kdm6b") %>% 
  ggplot(aes(x=Stage, y=Expression, linetype=Trt, group=Trt, color=Trt, na.rm = TRUE)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="line",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="point",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun.data = mean_se, na.rm = TRUE,
               geom = "errorbar",
               width = 0.2,
               linetype="solid",
               position = position_dodge(0.2)) +
  scale_linetype_manual(name = "Temperature", 
                        values = c("solid",  "dashed", "solid", "dashed"),
                        labels = c("26 Constant", "26 Flux", "31 Constant", "31 Flux")) +
  scale_color_manual(breaks = c("26 Constant", "26 Flux", "31 Constant", "31 Flux"),
                     values=c("royalblue2", "royalblue2", "dark orange", "dark orange")) +
  labs(x = "Developmental Stage", y = "Mean Normalized Expression (± SE)", 
       colour = "Temperature") +
  scale_y_continuous(labels = scales::scientific) +
  scale_x_continuous(breaks=c(15, 16, 17, 18, 19, 20, 21, 22, 23, 24),
                     labels = c(15, 16, 17, 18, 19, 20, 21, 22, 23, 24)) + 
  theme(axis.line = element_line(linetype = "solid"), 
        panel.background = element_rect(fill = NA), 
        strip.text = element_text(colour = NA), 
        legend.key = element_rect(fill = NA), 
        legend.background = element_rect(fill = NA)) + theme(axis.title = element_text(size = 12), 
    axis.text = element_text(size = 11), 
    legend.text = element_text(size = 12), 
    legend.title = element_text(size = 12))
  #annotate("text", x = 16.2, y = .002, label=expression(paste(italic("Kdm6b"))), size = 6) +
  #annotate("text", x = 18.8, y = .00169, parse = TRUE, size = 5,
  #         label = as.character(expression(paste(italic("F"[1][","][52]), " = 11.08, ", paste(italic("p"), " = 0.001*"))))) +
  #annotate("text", x = 17.55, y = .00185, label="Constant vs. Flux", size = 5)

drop_na(cont_long.df) %>%
  filter(Gene == "Foxl2") %>% 
  ggplot(aes(x=Stage, y=Expression, linetype=Trt, group=Trt, color=Trt, na.rm = TRUE)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="line",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="point",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun.data = mean_se, na.rm = TRUE,
               geom = "errorbar",
               width = 0.2,
               linetype="solid",
               position = position_dodge(0.2)) +
  scale_linetype_manual(name = "Temperature", 
                        values = c("solid",  "dashed", "solid", "dashed"),
                        labels = c("26 Constant", "26 Flux", "31 Constant", "31 Flux")) +
  scale_color_manual(breaks = c("26 Constant", "26 Flux", "31 Constant", "31 Flux"),
                     values=c("royalblue2", "royalblue2", "dark orange", "dark orange")) +
  labs(x = "Developmental Stage", y = "Mean Normalized Expression (± SE)", 
       colour = "Temperature") +
  scale_y_continuous(labels = scales::scientific) +
  scale_x_continuous(breaks=c(15, 16, 17, 18, 19, 20, 21, 22, 23, 24),
                     labels = c(15, 16, 17, 18, 19, 20, 21, 22, 23, 24)) + 
  theme(axis.line = element_line(linetype = "solid"), 
        panel.background = element_rect(fill = NA), 
        strip.text = element_text(colour = NA), 
        legend.key = element_rect(fill = NA), 
        legend.background = element_rect(fill = NA)) +
  #annotate("text", x = 17.5, y = .00025, label= "a", fontface = "bold", size = 4) +
  #annotate("text", x = 20, y = .00128, label= "b", fontface = "bold", size = 4) +
  #annotate("text", x = 22, y = .0005, label= "b", fontface = "bold", size = 4) +
  #annotate("text", x = 23, y = .00075, label= "b", fontface = "bold", size = 4) +
  #annotate("text", x = 24, y = .0005, label= "b", fontface = "bold", size = 4) + 
  theme(axis.title = element_text(size = 12), 
        axis.text = element_text(size = 11), 
        legend.text = element_text(size = 12), 
        legend.title = element_text(size = 12))
  #annotate("text", x = 15.75, y = .0017, label=expression(paste(italic("Foxl2"))), size = 6) +
  #annotate("text", x = 18.18, y = .00143, parse = TRUE, size = 5,
  #         label = as.character(expression(paste(italic("F"[4][","][45]), " = 3.1, ", paste(italic("p"), " = 0.02*"))))) +
  #annotate("text", x = 19.2, y = .00157, label="Temp Treatment x Stage Int.", size = 5)


drop_na(cont_long.df) %>%
  filter(Gene == "Sox9") %>% 
  ggplot(aes(x=Stage, y=Expression, linetype=Trt, group=Trt, color=Trt, na.rm = TRUE)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="line",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="point",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun.data = mean_se, na.rm = TRUE,
               geom = "errorbar",
               width = 0.2,
               linetype="solid",
               position = position_dodge(0.2)) +
  scale_linetype_manual(name = "Temperature", 
                        values = c("solid",  "dashed", "solid", "dashed"),
                        labels = c("26 Constant", "26 Flux", "31 Constant", "31 Flux")) +
  scale_color_manual(breaks = c("26 Constant", "26 Flux", "31 Constant", "31 Flux"),
                     values=c("royalblue2", "royalblue2", "dark orange", "dark orange")) +
  labs(x = "Developmental Stage", y = "Mean Normalized Expression (± SE)", 
       colour = "Temperature") +
  scale_y_continuous(labels = scales::scientific) +
  scale_x_continuous(breaks=c(15, 16, 17, 18, 19, 20, 21, 22, 23, 24),
                     labels = c(15, 16, 17, 18, 19, 20, 21, 22, 23, 24)) + 
  theme(axis.line = element_line(linetype = "solid"), 
        panel.background = element_rect(fill = NA), 
        strip.text = element_text(colour = NA), 
        legend.key = element_rect(fill = NA), 
        legend.background = element_rect(fill = NA)) +
  #annotate("text", x = 15, y = .0000000029, label= "ab", fontface = "bold", size = 4) +
  #annotate("text", x = 17, y = .0000000017, label= "b", fontface = "bold", size = 4) +
  #annotate("text", x = 18, y = .0000000023, label= "ab", fontface = "bold", size = 4) +
  #annotate("text", x = 19, y = .0000000022, label= "ab", fontface = "bold", size = 4) +
  #annotate("text", x = 20, y = .0000000029, label= "a", fontface = "bold", size = 4) +
  #annotate("text", x = 21, y = .0000000044, label= "ab", fontface = "bold", size = 4) + 
  theme(axis.title = element_text(size = 12), 
          axis.text = element_text(size = 11), 
          legend.text = element_text(size = 12), 
          legend.title = element_text(size = 12))
  #annotate("text", x = 15.6, y = .0000000053, label=expression(paste(italic("Sox9"))), size = 6) +
  #annotate("text", x = 18, y = .00000000455, parse = TRUE, size = 5,
  #         label = as.character(expression(paste(italic("F"[1][","][52]), " = 0.18, ", paste(italic("p"), " = 0.68"))))) +
  #annotate("text", x = 17.3, y = .00000000495, label="Constant vs. Flux", size = 5)



drop_na(cont_long.df) %>%
  filter(Gene == "Sox4") %>% 
  ggplot(aes(x=Stage, y=Expression, linetype=Trt, group=Trt, color=Trt, na.rm = TRUE)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="line",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="point",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun.data = mean_se, na.rm = TRUE,
               geom = "errorbar",
               width = 0.2,
               linetype="solid",
               position = position_dodge(0.2)) +
  scale_linetype_manual(name = "Temperature", 
                        values = c("solid",  "dashed", "solid", "dashed"),
                        labels = c("26 Constant", "26 Flux", "31 Constant", "31 Flux")) +
  scale_color_manual(breaks = c("26 Constant", "26 Flux", "31 Constant", "31 Flux"),
                     values=c("grey", "grey", "black", "black")) +
  labs(x = "Developmental Stage", y = y_sox4, 
       colour = "Temperature") +
  scale_y_continuous(labels = scales::scientific) +
  scale_x_continuous(breaks=c(15, 16, 17, 18, 19, 20, 21, 22, 23, 24),
                     labels = c(15, 16, 17, 18, 19, 20, 21, 22, 23, 24)) + 
  theme(axis.line = element_line(linetype = "solid"), 
        panel.background = element_rect(fill = NA), 
        strip.text = element_text(colour = NA), 
        legend.key = element_rect(fill = NA), 
        legend.background = element_rect(fill = NA))

edits <- read_excel("Data/ryan's edits.xlsx")

y_we <-expression(paste("Normalized ", italic("Cyp19A1"), " Expression (± SE)"))

drop_na(edits) %>%
  filter(Temperature == "31 Flux") %>%
  ggplot(aes(x=Day, y=Cyp19A1, na.rm = TRUE)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="line",
               color = "orange",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="point",
               color = "orange",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun.data = mean_se, na.rm = TRUE,
               geom = "errorbar",
               color = "orange",
               width = 0.2,
               linetype="solid",
               position = position_dodge(0.2)) +
  labs(x = "Incubation Day", y = y_we, 
       colour = "Temperature") +
  scale_y_continuous(labels = comma) +
  scale_x_continuous(breaks=c(20, 24, 27, 30, 33),
                     labels = c(20, 24, 27, 30, 33)) +
  theme(axis.line = element_line(linetype = "solid"), 
        panel.background = element_rect(fill = NA), 
        strip.text = element_text(colour = NA), 
        legend.key = element_rect(fill = NA), 
        legend.background = element_rect(fill = NA)) + theme(axis.title = element_text(size = 15), 
                                                             axis.text = element_text(size = 14))

y_ge <-expression(paste("Normalized ", italic("Dmrt1"), " Expression (± SE)"))

drop_na(edits) %>%
  filter(Temperature == "26 Flux") %>%
  ggplot(aes(x=Day, y=Dmrt1, na.rm = TRUE)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="line",
               color = "blue",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="point",
               color = "blue",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun.data = mean_se, na.rm = TRUE,
               geom = "errorbar",
               color = "blue",
               width = 0.2,
               linetype="solid",
               position = position_dodge(0.2)) +
  labs(x = "Incubation Day", y = y_ge, 
       colour = "Temperature") +
  scale_y_continuous(labels = comma) +
  scale_x_continuous(breaks=c(24, 28, 32, 36, 40, 44),
                     labels = c(24, 28, 32, 36, 40, 44)) +
  theme(axis.line = element_line(linetype = "solid"), 
        panel.background = element_rect(fill = NA), 
        strip.text = element_text(colour = NA), 
        legend.key = element_rect(fill = NA), 
        legend.background = element_rect(fill = NA)) + theme(axis.title = element_text(size = 16), 
    axis.text = element_text(size = 14))

cyp <- read_excel("Data/cyprelativechange.xlsx")
cyp$Conditions <- as.factor(cyp$Conditions)

y_ge <-expression(paste("Relative ", italic("Cyp19A1"), " Expression (± SE)"))

drop_na(cyp) %>%
  ggplot(aes(x=Day, y=`Relative Change`, color = Conditions, fill = Conditions, na.rm = TRUE)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="line",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="point",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun.data = mean_se, na.rm = TRUE,
               geom = "errorbar",
               width = 0.2,
               linetype="solid",
               position = position_dodge(0.2)) +
  labs(x = "Incubation Day", y = y_ge) +
  scale_y_continuous(labels = comma) +
  scale_color_manual(breaks = c("31 ± 3 °C", "Discontinuous HW"),
                     values=c("orange", "grey")) +
  theme(axis.line = element_line(linetype = "solid"), 
        panel.background = element_rect(fill = NA), 
        strip.text = element_text(colour = NA), 
        legend.key = element_rect(fill = NA), 
        legend.background = element_rect(fill = NA)) + theme(axis.title = element_text(size = 16), 
                                                             axis.text = element_text(size = 14)) +
  geom_hline(yintercept = 1, linetype = 'dashed') + theme(axis.text = element_text(size = 18), 
        legend.text = element_text(size = 12), 
        legend.title = element_text(size = 14))

dmr <- read_excel("Data/dmrrelativechange.xlsx")
dmr$Conditions <- as.factor(dmr$Conditions)

y_wow <-expression(paste("Relative ", italic("Dmrt1"), " Expression (± SE)"))

drop_na(dmr) %>%
  ggplot(aes(x=Day, y=`Relative Change`, color = Conditions, fill = Conditions, na.rm = TRUE)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="line",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun=mean, na.rm = TRUE, 
               geom="point",
               size = 1,
               position = position_dodge(0.2)) +
  stat_summary(fun.data = mean_se, na.rm = TRUE,
               geom = "errorbar",
               width = 0.2,
               linetype="solid",
               position = position_dodge(0.2)) +
  labs(x = "Incubation Day", y = y_wow) +
  scale_color_manual(breaks = c("26 ± 3 °C", "Discontinuous HW"),
                     values=c("blue", "grey")) +
  scale_y_continuous(labels = comma) +
  theme(axis.line = element_line(linetype = "solid"), 
        panel.background = element_rect(fill = NA), 
        strip.text = element_text(colour = NA), 
        legend.key = element_rect(fill = NA), 
        legend.background = element_rect(fill = NA)) + theme(axis.title = element_text(size = 16), 
                                                             axis.text = element_text(size = 14)) +
  geom_hline(yintercept = 1, linetype = 'dashed') + theme(axis.text = element_text(size = 18), 
    legend.text = element_text(size = 12), 
    legend.title = element_text(size = 14))
