library(dplyr)
library(ggplot2)
library(ggmosaic)
library(tidyr)
SNPAssignment <- read.csv("Chapter 3 SNP assignment_forR_SympAllo_TBversion_JHsppChange.csv")
SNPAssignment

### Remade 18 Feb 2021 as per JH sample classification changes from original "Chapter 3 SNP assignment_forR_SympAllo_TBversion.csv"

### convert to long format, make a locus column and a snp column
# The arguments to gather():
# - data: Data object
# - key: Name of new key column (made from names of data columns)
# - value: Name of new value column
# - ...: Names of source columns that contain values
# - factor_key: Treat the new key column as a factor (instead of character vector)
SNPAssignment_long <- gather(SNPAssignment, Locus, SNP, Enol_Order:ANM_Order, factor_key=TRUE)
SNPAssignment_long
###remove rows with NAs in SNP column 
# remove na in r - remove rows - na.omit function / option
SNPAssignment_long_noNAs <- na.omit(SNPAssignment_long) 
SNPAssignment_long_noNAs
summary(SNPAssignment_long_noNAs$SubPop)
### filter for a table for each patry
alloRN <- filter(SNPAssignment_long_noNAs, SubPop == "Allo_RN")
alloRN
alloYB <- filter(SNPAssignment_long_noNAs, SubPop == "Allo_YB")
alloYB
AB_RN <- filter(SNPAssignment_long_noNAs, SubPop == "AB_RN")
AB_RN
AB_YB <- filter(SNPAssignment_long_noNAs, SubPop == "AB_YB")
AB_YB
hybrid <- filter(SNPAssignment_long_noNAs, SubPop == "Hybrid")
hybrid

all_samples <- ggplot(SNPAssignment_long_noNAs) + geom_mosaic(aes(x = product(SNP, SubpopOrder), fill=SNP, conds=product(Locus)), divider = mosaic("v")) + labs(x= "SubPop", y = "Locus", title = "SNPs by Group") + scale_fill_manual(values=c("black", "grey 85", "black", "grey85")) + theme_test()
all_samples

pdf(file = "~/Documents/Lethbridge/Sapsuckers/Chapter 3/Publication/PubImages/MosaicPlots/Allsamples.pdf", width = 600, height=520)
all_samples
dev.off()


