### RAD-Seq samples only for EcoEvo Mar 12 2021
library(tidyverse)

samples <- read.csv("All_samples_metadata.csv")

### filter to AB only
ABsamples <- filter(samples, N < 60)
ABsamples <- filter(ABsamples, N > 49)
ABsamples <- filter(ABsamples, W > -120)
ABsamples <- filter(ABsamples, W < -110)

### filter to RADSeq only
RADsamples <- filter(ABsamples, ABsamples$GBS == "Y" | ABsamples$ddRAD == "Y")
summary(RADsamples)

### now add the map script

### loady loady
install.packages("ggplot2")
install.packages("ggmap")
install.packages("maps")
install.packages("mapproj")
install.packages("mapdata")
install.packages("rgeos")
install.packages("maptools")
install.packages("sp")
install.packages("raster")
install.packages("rgdal")
install.packages("dismo")

require(ggplot2)
require(ggmap)
require(maps)
require(mapproj)
require(mapdata)
require(rgeos)
require(maptools)
require(sp)
require(raster)
require(rgdal)
require(dismo)

base = get_map(location=c(-120.5,48.75,-110.5,55.5), zoom=7, maptype="terrain")

map1 = ggmap(base)
map1

pdf(file = "~/Documents/Lethbridge/Sapsuckers/Chapter 3/Publication/PubImages/SampleMap/RADSeq_Sample_map.pdf")
map1 + geom_point(data=RADsamples, aes(x=W, y=N, fill=Species, shape=Species), cex=3, alpha=0.7) + # plot the points
  scale_fill_manual(values = c("grey", "black", "white"), labels=c("Hybrid", "S.nuchalis", "S. varius", "ZONE"), name=NULL) +
  scale_shape_manual(values = c(23,24,21,25), labels=c("Hybrid", "S.nuchalis", "S. varius"), name=NULL) + # define shape/color scales
  labs(x="Longitude", y="Latitude") + # label the axes
  theme_bw() + theme(legend.position="bottom", axis.text = element_text(size = rel(0.75)), legend.key = element_rect(colour = "white"), axis.text.x = element_text(angle=45, vjust=0.5)) # tweak the plot's appearance and legend position
dev.off()

### in color
pdf(file = "~/Documents/Lethbridge/Sapsuckers/Chapter 3/Publication/PubImages/SampleMap/RADSeq_Sample_map_color.pdf")
map1 + geom_point(data=RADsamples, aes(x=W, y=N, fill=Species, shape=Species), cex=4.5, alpha=0.7) + # plot the points
  scale_fill_manual(values = c("green3", "blue", "yellow"), labels=c("Hybrid", "S.nuchalis", "S. varius", "ZONE"), name=NULL) +
  scale_shape_manual(values = c(23,24,21,25), labels=c("Hybrid", "S.nuchalis", "S. varius"), name=NULL) + # define shape/color scales
  labs(x="Longitude", y="Latitude") + # label the axes
  theme_bw() + theme(legend.position="bottom", axis.text = element_text(size = rel(0.75)), legend.key = element_rect(colour = "white"), axis.text.x = element_text(angle=45, vjust=0.5)) # tweak the plot's appearance and legend position
dev.off()

### make one with all the RADSeqSamples
### filter to RADSeq only
AllRADsamples <- filter(samples, samples$GBS == "Y" | samples$ddRAD == "Y")
summary(AllRADsamples)

base2 = get_map(location=c(-140.5,30,-70,65), zoom=4, source = "stamen", maptype="watercolor")
map2 = ggmap(base2)
map2

pdf(file = "~/Documents/Lethbridge/Sapsuckers/Chapter 3/Publication/PubImages/SampleMap/Rangewide_RADSeq_Sample_map.pdf")
map2 + geom_point(data=AllRADsamples, aes(x=W, y=N, fill=Species, shape=Species), cex=3, alpha=0.7) + # plot the points
  scale_fill_manual(values = c("grey", "black", "white", "red"), labels=c("Hybrid", "S.nuchalis", "S. varius", "ZONE"), name=NULL) +
  scale_shape_manual(values = c(23,24,21,25), labels=c("Hybrid", "S.nuchalis", "S. varius", "ZONE"), name=NULL) + # define shape/color scales
  labs(x="Longitude", y="Latitude") + # label the axes
  theme_bw() + theme(legend.position="bottom", axis.text = element_text(size = rel(0.75)), legend.key = element_rect(colour = "white"), axis.text.x = element_text(angle=45, vjust=0.5)) # tweak the plot's appearance and legend position
dev.off()

### in color
pdf(file = "~/Documents/Lethbridge/Sapsuckers/Chapter 3/Publication/PubImages/SampleMap/Rangewide_RADSeq_Sample_map_color.pdf")
map2 + geom_point(data=AllRADsamples, aes(x=W, y=N, fill=Species, shape=Species), cex=3, alpha=0.7) + # plot the points
  scale_fill_manual(values = c("green3", "blue", "yellow"), labels=c("Hybrid", "Red-naped", "Yellow-bellied"), name=NULL) +
  scale_shape_manual(values = c(23,24,21,25), labels=c("Hybrid", "Red-naped", "Yellow-bellied"), name=NULL) + # define shape/color scales
  labs(x="Longitude", y="Latitude") + # label the axes
  theme_bw() + theme(legend.position="bottom", axis.text = element_text(size = rel(0.75)), legend.key = element_rect(colour = "white"), axis.text.x = element_text(angle=45, vjust=0.5)) # tweak the plot's appearance and legend position
dev.off()
