# Introduction ----
# UT_PCA_script.R
# Started by Libby Natola on 17 Feb 2021.
# Based on R code written by Darren Irwin for Greenish Warbler analysis, and then the NA warbler analyses, and then the "TOWA_GBS_withMaddie_R_analysis_script.R", and finally "TOWA_BTNW_HEWA_8plates_R_analysis_script.R". Made using Cornell GBS Reads demultiplexed, assembled, and flitered in Tassel

# Initial setup ----

###run in R 4.0.3

#I think he used this because there are so many data points and we want to see them all
options(max.print = 10000)
install.packages("ggplot2")
source("genomics_R_functions.R")

# For pcaMethods, need to do these commands:
if (!requireNamespace("BiocManager", quietly = TRUE))
  install.packages("BiocManager")
BiocManager::install(version = "3.12")
BiocManager::install(c("pcaMethods"))
library(pcaMethods) 


# PCA whole-genome ----
# Load vcf file containing only variable sites throughout genome;
# construct a PCA based on all sites passing an Fst threshold between the "groups" below;
# and all individuals in "groups.to.plot.PCA" according to colors in "group.colors.PCA"

groups_and_colors <- rbind(c("RNSA", "black"),
                           c("YBSA", "white"),
                           c("HYSA", "grey")
)

groups.to.plot.PCA <- groups_and_colors[,1]
group.colors.PCA <- groups_and_colors[,2]
groups <- c("RNSA", "YBSA", "HYSA")  # for purpose of calculating pairwise Fst and Fst_group (to determine SNPs)

base.file.name <- "UofLsnps/40ind_80snpfiltered.tab"
pos <- read.table(paste0(base.file.name, ".012.pos"), col.names = c("chrom", "position"))
column_names <- c("null", paste("c", pos$chrom, pos$position, sep="."))
geno <- read.table(paste0(base.file.name, ".012NA"), colClasses = "integer", col.names = column_names)
SNPnum <- length(geno[1,]) -1   # because the first column is not a SNP (just a count from zero)
ind <- read.table(paste0(base.file.name, ".012.indv"))
locations <- read.table("C.tassel.Fst_groups.txt", header=TRUE)
num_loc_cols <- ncol(locations)
ind_with_locations <- cbind(ind,locations)
combo <- cbind(ind_with_locations[,2:(num_loc_cols+1)],geno[,2:length(geno[1,])])

# determine number of missing SNPs per bird, and filter out those with more than X% missing SNPs
X <- 85 # this is the percentage threshold, set super lenient bc already filtered in tassel
threshold_NA <- SNPnum * X/100
numNAs <- rowSums(is.na(combo[(num_loc_cols+1):ncol(combo)]))
numNAs_by_ID <- data.frame(combo$ID, numNAs)  # useful to see numNAs per sample: numNAs_by_ID
selection <- (numNAs < threshold_NA)
if(any(is.na(selection))) cat("selection contains NA values\n")  # this is a check for noticing errors / bugs
combo.NApass.all <- combo[selection,]
combo$ID[which(selection==F)]

# filter out SNPs with too many missing genotypes:set super lenient bc already filtered in tassel
SNP_NAs <- colSums(is.na(combo.NApass.all[,(num_loc_cols+1):ncol(combo.NApass.all)]))
X <- 85   # this is the percentage threshold
threshold_SNP_NAs <- length(combo.NApass.all[,1]) * X/100
selection <- (SNP_NAs <= threshold_SNP_NAs)
if(any(is.na(selection))) cat("selection contains NA values\n")  # this is a check for noticing errors / bugs
combo.NApass.subset <- combo.NApass.all[, c(rep(TRUE, times=num_loc_cols),selection)]
pos.subset <- pos[selection,]
### finished 934(60_60), 1891(40_60)

# option to filter out all but selected chromosome (or set of them):
choose.chrom <- F
if (choose.chrom == TRUE) {
  chrom <- "Z"
  # selection <- (pos.subset$chrom == chrom)
  selection <- (pos.subset$chrom == chrom)
  if(any(is.na(selection))) cat("selection contains NA values\n")  # this is a check for noticing errors / bugs
  #pos.subset.one.chr <- pos.subset[selection,]
  #loci.selection <- c(rep(TRUE, times=num_loc_cols), selection)  # add placeholders for info columns
  # which(loci.selection == T)    # to check which entries are TRUE
  combo.NApass <- combo.NApass.subset[, c(rep(TRUE, times=num_loc_cols), selection)]
  pos.NApass <- pos.subset[selection,]
  region.text <- paste0("chr", chrom)	
}	else {
  region.text <- "whole_genome"
  combo.NApass <- combo.NApass.subset
  pos.NApass <- pos.subset
}

# Calculate allele freqs and sample sizes (use column Fst_group)
temp.list <- getFreqsAndSampleSizes(combo.NApass, num_loc_cols, groups)
freqs <- temp.list$freqs
sample_size <- temp.list$sample_size
rm(temp.list)
# calculate WC84_Fst 
temp.list <- getWC84Fst(freqs, sample_size, groups, among=TRUE)  # set among to FALSE if no among Fst wanted (some things won't work without it)
WC84_Fst <- temp.list$WC84_Fst
rm(temp.list)


# make the figure:
Fst.filter <- F   # option to filter to high-Fst markers only, using cutoff below
Fst.cutoff <- 0.25  # has no effect if Fst.filter is FALSE
# choose whether to filter by Fst between pair of populations, or by Fst_among (as defined above)
groups.to.compare <- "Fst_among"
axes <- 3
PCA_results <- plotPCA(Fst.filter, Fst.cutoff, groups.to.compare, WC84_Fst, combo.NApass, num_loc_cols, region.text,
                       groups.to.plot.PCA, group.colors.PCA, axes, flip1=T, flip2=F)

PCA_table <- data.frame(PCA_results$scores, row.names = PCA_results$data$ID)

PCA_results$var_explained
# [1] 0.2189218 0.2496415 0.2794353
0.2189218 - 0.2496415
# PC2 is [1] -0.0307197
### Make it purty

PCs <- read.csv("C.tassel.PCtable.csv")

library(ggplot2)
library(tidyr)
library(dplyr)


theme_set(theme_bw())
theme_update(plot.title = element_text(hjust = 0.5))

ggsave(file = "~/Documents/Lethbridge/Sapsuckers/Chapter 3/Publication/PubImages/CornellPCA.pdf", dpi =500, dev=pdf)
PCA <- ggplot(PCs, aes(x=PC1, y=PC2, color = Species, fill=Species, shape = Species)) + geom_point(size=3) + xlab("PC1 21.9%") + ylab("PC2 3.1%") + ggtitle("GBS PCA") + scale_fill_manual(values=c("grey", "black", "white")) + scale_color_manual(values=c("black", "black", "black")) + scale_shape_manual(values = c(23,24,21)) + theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank())
PCA
dev.off()

ggsave(file = "~/Documents/Lethbridge/Sapsuckers/Chapter 3/Publication/PubImages/CornellPCAsympallo.pdf", dpi = 500, dev=pdf)
PCA_sympallo <- ggplot(PCs, aes(x=PC1, y=PC2, color = Location, fill = Species, shape = Species)) + geom_point(size=4) + xlab("PC1 21.9%") + ylab("PC2 3.1%") + ggtitle("GBS PCA") + scale_fill_manual(values=c("grey", "black", "white")) + scale_color_manual(values=c("red", "black", "grey")) + scale_shape_manual(values = c(23,24,21)) + theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank())
PCA_sympallo
dev.off()

### in color
ggsave(file = "~/Documents/Lethbridge/Sapsuckers/Chapter 3/Publication/PubImages/CornellPCA_color.pdf", dpi =500, dev=pdf)
PCA <- ggplot(PCs, aes(x=PC1, y=PC2, color = Species, fill=Species, shape = Species)) + geom_point(size=3.5) + xlab("PC1 21.9%") + ylab("PC2 3.1%") + ggtitle("GBS PCA") + scale_fill_manual(values=c("green3", "blue", "yellow")) + scale_color_manual(values=c("black", "black", "black")) + scale_shape_manual(values = c(23,24,21)) + theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank())
PCA
dev.off()