#!/bin/bash
#BSUB -G uco
#BSUB -J schwarz_extrusion
#BSUB -o ../perf-portable-solids/runs/lassen/schwarz_extrusion/schwarz-q2-t20-r2-l2-%J.out
#BSUB -e schwarz-q2-t20-r2-l2-%J.err
#BSUB -W 02:00
#BSUB -nnodes 1


# loop over, order (Q_n) 1-3, layers 1-5, refine 1-4


for l in 1 2 3 4 5; do
   for r in 1 2 3 4; do
     lrun -M -gpu -N1 -T4\
       build/ex02-quasistatic-elasticity -order 3 -dm_plex_shape schwarz_p -dm_plex_tps_thickness .2 -dm_plex_tps_extent 4,3,3 -dm_plex_tps_layers $l -dm_plex_tps_refine $r -material fs-current-nh -E 1 -nu .3 -bc_clamp 1 -bc_traction 2 -bc_traction_2 .02,0,0 -ts_dt .5 -ts_adapt_monitor -snes_monitor -ksp_converged_reason -dm_view -ksp_rtol 1e-3 -snes_converged_reason -ksp_view_singularvalues -view_diagnostics -device_enable lazy -mg_coarse_pc_gamg_square_graph 0 -preload -log_view -mg_coarse_pc_type hypre -mg_coarse_pc_hypre_boomeramg_coarsen_type pmis -mg_coarse_pc_hypre_boomeramg_interp_type ext+i -mg_coarse_pc_hypre_boomeramg_no_CF -mg_coarse_pc_hypre_boomeramg_P_max 6 -mg_coarse_pc_hypre_boomeramg_relax_type_down Chebyshev -mg_coarse_pc_hypre_boomeramg_relax_type_up Chebyshev -mg_coarse_pc_hypre_boomeramg_strong_threshold 0.5 
done;
done
