#!/bin/bash
#BUB -G uco
#BSUB -J opApply-matrix_free
#BSUB -o /g/g15/stengel3/schwarz-opApply-matrix_free-%J.out
#BSUB -e /g/g15/stengel3/schwarz-opApply-matrix_free-%J.err
#BSUB -W 01:00
#BSUB -nnodes 1

echo "Matrix free"
for n in 4 5 6 7 8 9 10 11 12; do
  lrun -M "-gpu" -N1 -T4 \
   build/ex02-quasistatic-elasticity -order 2 -dm_plex_shape schwarz_p -dm_plex_tps_thickness .2 -dm_plex_tps_extent $n,$n,$n -dm_plex_tps_layers 2 -dm_plex_tps_refine 2 -material fs-current-nh -E 1 -nu .3 -bc_clamp 1 -bc_traction 2 -bc_traction_2 .02,0,0 -ts_dt 1 -ts_adapt_monitor -snes_monitor -dm_view -snes_converged_reason -ksp_converged_reason -ksp_view_singularvalues -pc_type jacobi -ksp_max_it 500 -snes_linesearch_type basic -snes_max_linear_solve_fail 10 -snes_convergence_test skip -snes_max_it 3 -ceed /gpu/cuda -preload -log_view
done
