#!/bin/bash
#BUB -G uco
#BSUB -J opApply-matrix_free
#BSUB -o schwarz-opApply-all-%J.out
#BSUB -e schwarz-opApply-all-%J.err
#BSUB -W 02:00
#BSUB -nnodes 1

### note: on Lassen, order 1 w/ matrix-free and extents 4...12 is about 11 mins for turn around time
###                  order 5 w/ matrix-free and extents 4...12 is about 12 mins for turn around time
###                  order 1 w/ sparse and extents 4...12 is about 30 mins for turn around time
###                  order 5 w/ sparse and extents 4...12 is about 10 mins for turn around time (out of memory errors)

### non-Lassen options: sbatch -o schwarz-opApply-%j.out -A NNN -C gpu -N 1 -n 4 -c16 --gpu-bind=closest --ntasks-per-gpu=1 -t 02:00
### note: crusher, summit, and perlmutter need to be changed to srun
###       also need to change -ceed /gpu/cuda -> -ceed /gpu/hip for non-lassen
echo "Matrix free"
for o in 1 2 3 4 5; do
  for n in 4 5 6 7 8 9 10 11 12; do
    lrun -M "-gpu" -N1 -T4 \
    build/ex02-quasistatic-elasticity -order $o -dm_plex_shape schwarz_p -dm_plex_tps_thickness .2 -dm_plex_tps_extent $n,$n,$n -dm_plex_tps_layers 2 -dm_plex_tps_refine 2 -material fs-current-nh -E 1 -nu .3 -bc_clamp 1 -bc_traction 2 -bc_traction_2 .02,0,0 -ts_dt 1 -ts_adapt_monitor -snes_monitor -dm_view -snes_converged_reason -ksp_converged_reason -ksp_view_singularvalues -pc_type jacobi -coarse_dm_mat_type shell -ksp_max_it 500 -snes_linesearch_type basic -snes_max_linear_solve_fail 10 -snes_convergence_test skip -snes_max_it 3 -ceed /gpu/cuda -coarse_dm_mat_type shell -preload -log_view
  done
done

### sparse assembled 
echo "Sparse assembled"
for o in 1 2 3 4; do
  for n in 2 3 4 5 6 7 8 9 10 11 12; do
  lrun -M "-gpu" -N1 -T4 \
   build/ex02-quasistatic-elasticity -order $o -dm_plex_shape schwarz_p -dm_plex_tps_thickness .2 -dm_plex_tps_extent $n,$n,$n -dm_plex_tps_layers 2 -dm_plex_tps_refine 2 -material fs-current-nh -E 1 -nu .3 -bc_clamp 1 -bc_traction 2 -bc_traction_2 .02,0,0 -ts_dt 1 -ts_adapt_monitor -snes_monitor -dm_view -snes_converged_reason -ksp_converged_reason -ksp_view_singularvalues -pc_type jacobi -ksp_max_it 500 -snes_linesearch_type basic -snes_max_linear_solve_fail 10 -snes_convergence_test skip -snes_max_it 3 -ceed /gpu/cuda -preload -log_view -multigrid amg_only
  done
done