#!/bin/bash
#BUB -G uco
#BSUB -J schwarz-q2-t20-r2-l2
#BSUB -o ../perf-portable-solids/runs/lassen/noKokkos/schwarz-q2-t20-r2-l2-%J.out
#BSUB -e schwarz-q2-t20-r2-l2-%J.err
#BSUB -W 00:30
#BSUB -nnodes 8

### for n in 10 12 14 16 18; do
for n in 10 12 14 16 18; do
  lrun -M "-gpu" -N8 -T8 \
   build/ex02-quasistatic-elasticity -dm_plex_shape schwarz_p -dm_plex_tps_thickness .2 -dm_plex_tps_extent $n,$n,$n -dm_plex_tps_layers 2 -dm_plex_tps_refine 2 -material fs-current-nh -E 1 -nu .3 -bc_clamp 1 -bc_traction 2 -bc_traction_2 .02,0,0 -ts_dt 1 -order 2 -snes_monitor -ksp_converged_reason -dm_view -ksp_rtol 1e-3 -snes_converged_reason -mg_levels_ksp_max_it 2 -log_view -ksp_view_singularvalues -ceed /gpu/cuda -preload -mg_coarse_pc_type hypre -mg_coarse_pc_hypre_boomeramg_coarsen_type pmis -mg_coarse_pc_hypre_boomeramg_interp_type ext+i -mg_coarse_pc_hypre_boomeramg_no_CF -mg_coarse_pc_hypre_boomeramg_P_max 6 -mg_coarse_pc_hypre_boomeramg_relax_type_down Chebyshev -mg_coarse_pc_hypre_boomeramg_relax_type_up Chebyshev -mg_coarse_pc_hypre_boomeramg_strong_threshold 0.5
done
