#!/bin/bash
#BUB -G uco
#BSUB -J opApply-sparse
#BSUB -o /g/g15/stengel3/schwarz-opApply-sparse-%J.out
#BSUB -e /g/g15/stengel3/schwarz-opApply-sparse-%J.err
#BSUB -W 01:30
#BSUB -nnodes 1

### sparse assembled 
echo "Sparse assembled"
for n in 1 2 3 4 5; do
  lrun -M "-gpu" -N1 -T4 \
   build/ex02-quasistatic-elasticity -order $n -dm_plex_shape schwarz_p -dm_plex_tps_thickness .2 -dm_plex_tps_extent 2,2,2 -dm_plex_tps_layers 2 -dm_plex_tps_refine 2 -material fs-current-nh -E 1 -nu .3 -bc_clamp 1 -bc_traction 2 -bc_traction_2 .02,0,0 -ts_dt 1 -ts_adapt_monitor -snes_monitor -dm_view -snes_converged_reason -ksp_converged_reason -ksp_view_singularvalues -pc_type jacobi -ksp_max_it 500 -snes_linesearch_type basic -snes_max_linear_solve_fail 10 -snes_convergence_test skip -snes_max_it 3 -ceed /gpu/cuda -preload -log_view -multigrid amg_only
done

