### Replication of Rezgar’s accuracy study on Lassen 
#!/bin/bash
#BUB -G uco
#BSUB -J schwarz-q2-t20-r2-l2
#BSUB -o ../perf-portable-solids/runs/lassen/accuracy/hex_ordp_refine-%J.out
#BSUB -e schwarz-q2-t20-r2-l2-%J.err
#BSUB -W 00:30
#BSUB -nnodes 1

echo “Replication of Rezgars accuracy study on Lassen“
echo “tet mesh - geo order:2,3,4; p order: 1,2,3,4; ref 0“
for n in 1 2 3 4; do
  for o in 2 3 4; do
    lrun -M “-gpu” -N1 -T4 \
    build/ex02-quasistatic-elasticity -order $n -dm_plex_filename=/g/g15/stengel3/meshes/holes_hex_ord_$o.msh -material fs-current-nh -E 1 -nu .3 -bc_clamp 1 -bc_traction 2 -bc_traction_2 0,0.5,0 -ts-dt 0.5 -ts_adapt_monitor -snes_monitor -ksp_converged_reason -dm_view -ksp_rtol 1e-4 -device_enable lazy -mg_levels_esteig_ksp_max_it 2 —mg_levels_ksp_chebyshev_esteig 0.3,1.2 -mg_coarse_pc_type cholesky -view_diagnostics -preload -log_view 
   done;
done