#!/bin/bash
#BSUB -G uco
#BSUB -J SNES_comp
#BSUB -o ../perf-portable-solids/runs/lassen/SNES_comp/schwarz-q2-t20-r2-l2-%J.out
#BSUB -e schwarz-q2-t20-r2-l2-%J.err
#BSUB -W 01:00
#BSUB -nnodes 1

# linear assembled, quadratic assembled, and quadratic matrix-free , -amg_only vs shell 
# P_1 -amg_only
lrun -M -gpu -N1 -T4\
  build/ex02-quasistatic-elasticity -order 1 -dm_plex_shape schwarz_p -dm_plex_tps_thickness .2 -dm_plex_tps_extent 4,3,3 -dm_plex_tps_layers 2 -dm_plex_tps_refine 2 -material fs-current-nh -E 1 -nu .3 -bc_clamp 1 -bc_traction 2 -bc_traction_2 .02,0,0 -ts_dt 1 -snes_monitor -ksp_converged_reason -dm_view -ksp_rtol 1e-3 -snes_converged_reason -mg_levels_ksp_max_it 2 -log_view -ksp_view_singularvalues -ceed /gpu/cuda -preload -mg_coarse_pc_type hypre -mg_coarse_pc_hypre_boomeramg_coarsen_type pmis -mg_coarse_pc_hypre_boomeramg_interp_type ext+i -mg_coarse_pc_hypre_boomeramg_no_CF -mg_coarse_pc_hypre_boomeramg_P_max 6 -mg_coarse_pc_hypre_boomeramg_relax_type_down Chebyshev -mg_coarse_pc_hypre_boomeramg_relax_type_up Chebyshev -mg_coarse_pc_hypre_boomeramg_strong_threshold 0.5  -multigrid amg_only

# P_2 -multigrid amg_only
lrun -M -gpu -N1 -T4\
  build/ex02-quasistatic-elasticity -order 2 -dm_plex_shape schwarz_p -dm_plex_tps_thickness .2 -dm_plex_tps_extent 4,3,3 -dm_plex_tps_layers 2 -dm_plex_tps_refine 2 -material fs-current-nh -E 1 -nu .3 -bc_clamp 1 -bc_traction 2 -bc_traction_2 .02,0,0 -ts_dt 1 -snes_monitor -ksp_converged_reason -dm_view -ksp_rtol 1e-3 -snes_converged_reason -mg_levels_ksp_max_it 2 -log_view -ksp_view_singularvalues -ceed /gpu/cuda -preload -mg_coarse_pc_type hypre -mg_coarse_pc_hypre_boomeramg_coarsen_type pmis -mg_coarse_pc_hypre_boomeramg_interp_type ext+i -mg_coarse_pc_hypre_boomeramg_no_CF -mg_coarse_pc_hypre_boomeramg_P_max 6 -mg_coarse_pc_hypre_boomeramg_relax_type_down Chebyshev -mg_coarse_pc_hypre_boomeramg_relax_type_up Chebyshev -mg_coarse_pc_hypre_boomeramg_strong_threshold 0.5  -multigrid amg_only

# P_2 shell
lrun -M -gpu -N1 -T4\
  build/ex02-quasistatic-elasticity -order 2 -dm_plex_shape schwarz_p -dm_plex_tps_thickness .2 -dm_plex_tps_extent 4,3,3 -dm_plex_tps_layers 2 -dm_plex_tps_refine 2 -material fs-current-nh -E 1 -nu .3 -bc_clamp 1 -bc_traction 2 -bc_traction_2 .02,0,0 -ts_dt 1 -snes_monitor -ksp_converged_reason -dm_view -ksp_rtol 1e-3 -snes_converged_reason -mg_levels_ksp_max_it 2 -log_view -ksp_view_singularvalues -ceed /gpu/cuda -preload -mg_coarse_pc_type hypre -mg_coarse_pc_hypre_boomeramg_coarsen_type pmis -mg_coarse_pc_hypre_boomeramg_interp_type ext+i -mg_coarse_pc_hypre_boomeramg_no_CF -mg_coarse_pc_hypre_boomeramg_P_max 6 -mg_coarse_pc_hypre_boomeramg_relax_type_down Chebyshev -mg_coarse_pc_hypre_boomeramg_relax_type_up Chebyshev -mg_coarse_pc_hypre_boomeramg_strong_threshold 0.5 
