import os
import sys
import pandas as pd
import numpy as np

class AppCtx:
    pass

def parse_file_content(filename, appCtx):
    grep = appCtx.grep_keywords

    file_data = []
    fd = open(filename, 'r')
    lines = fd.readlines()
    for line in lines:
        ll = line.strip().split()
        if grep[0] in line:   # Global DoFs
            file_data.append(int(ll[-1]))
        elif grep[1] in line: # Computed strain energy
            file_data.append(float(ll[-1]))
        elif ll and ll[0].strip() in grep[2:]:
            #print(line)
            #event = line[:16]
            #count = int(line[17:24])
            #count_balance = float(line[24:28])
            time = float(line[29:39])
            #time_balance = float(line[39:43])
            #print(event, count, count_balance, time, time_balance)
            file_data.append(time)

    if len(file_data) < len(grep):
        print(filename)
    fd.close()
    return file_data

def create_data_frame(files_data, appCtx):

    keywords = appCtx.grep_keywords
    col_size = len(keywords)
    df_vals = np.reshape(files_data,(-1, col_size))

    df_cols = []
    # Add the variables we were loking for as columns
    for i in range(col_size):
        df_cols.append(keywords[i])
    
    df = pd.DataFrame(df_vals, columns = df_cols)
    pd.set_option('display.expand_frame_repr', False)
    pd.set_option('display.float_format', lambda x: '%.12f' % x)

    df_tmp = df.to_numpy()
    
    #create a final dataframe to return
    dff = pd.DataFrame(df_tmp, columns = df_cols)

    dff["Global DoFs"] = dff["Global DoFs"].astype(int)
    return dff

def run_alg_perf():

    filename = 'schwarz-q2-t20-r2-l2-88745.out'
    grep_keywords = ['Global DoFs','Computed strain energy',\
                     'TSStep','KSPSolve',\
                     'SNESSolve','SNESFunctionEval',\
                     'SNESJacobianEval','PCSetUp',\
                     'Polynomial order', 'max/min',\
                     'Element topology']
                                       
    appCtx=AppCtx()
    appCtx.grep_keywords = grep_keywords

    #parse files
    files_data = parse_file_content(filename, appCtx)
    #create a dataframe
    df = create_data_frame(files_data, appCtx)
    return df

if __name__ == "__main__":

    df = run_alg_perf()
    print(df)
    df.to_csv("results", sep=',')
