function out = remap_vert_cons(fld,DRF,dz_i,nz_i)

    % Doesn't assume constant dz_i

    nx = size(fld,1);
    ny = size(fld,2);
    nz = size(fld,3);
    out = zeros(nx,ny,nz_i);

    all_facs = floor(DRF/dz_i);

    idx_st = 1;

    for k=1:nz
        fac = all_facs(k);
        idx_end = idx_st + fac - 1;
        out(:,:,idx_st:idx_end) = repmat(fld(:,:,k)/fac,[1,1,fac]);
        idx_st = idx_end + 1;
    end

end