
function out = remap_vert_RF(fld,DRF,dz_i,nRF_i)

    nx = size(fld,1);
    ny = size(fld,2);
    nz = size(fld,3);
    out = zeros(nx,ny,nRF_i);

    if (size(fld,3) ~= length(DRF) + 1)
        disp('fld must have one more value in the z-dimension')
    end

    idx_st = 1;

    for k=1:nz-1

        fac = floor(DRF(k)/dz_i);
        idx_end = idx_st + fac - 1;

        fac_matrix = (1/fac)*permute(repmat(0:1:fac-1,nx,1,ny),[1,3,2]);

        out(:,:,idx_st:idx_end) = fac_matrix.*repmat(fld(:,:,k+1),1,1,fac) + repmat(fld(:,:,k),1,1,fac).*(1 - fac_matrix);
        idx_st = idx_end + 1;
    end

    out(:,:,end) = fld(:,:,end);

end