
function sigma_idx = get_sigma_idx(sigma_RF,sigma0)

    nx = size(sigma0,1);
    ny = size(sigma0,2);
    nz = size(sigma0,3);
    nsigma = length(sigma_RF);
    sigma_idx = zeros(nx,ny,nsigma);

    sigma0(isnan(sigma0)) = 999;

    % First level
    sigma_min = sigma_RF(1);
    A = sigma0;
    A(A<sigma_min) = 1;
    A(A>=sigma_min) = 0;
    a = sum(A,3);
    a(a==0) = 1;
    sigma_idx(:,:,1) = a;

    % Remaining levels
    for i=2:nsigma
        B = sigma0;
        sigma_max = sigma_RF(i);
        B(B<=sigma_max) = 0;
        B(B>sigma_max) = 1;
        b = sum(B,3);
        b(b==nz) = nz-1;
        sigma_idx(:,:,i) = nz - b;
    end

end
