function RF_i = get_refinement(DRF,dz_i)

    % Assumes DRF is positive.
    % dz_i is the interval we try to match as closely as possible

    n = floor(DRF/dz_i); % Number of divisions for an interval
    n(n==0) = 1;
    nDRF_i = sum(n);
    DRF_i = zeros(nDRF_i,1);

    it_s = 1;
    for i=1:length(DRF)
        it_e = it_s + n(i) - 1;
        DRF_i(it_s:it_e) = DRF(i) / n(i);
        it_s = it_e + 1;
    end

    RF_i = [0;-cumsum(DRF_i)]; % Gives negative RF_i as per convention

end