
function [iso_uflx,iso_vflx,iso_tflx,iso_bflx,iso_GGUD,iso_TRAC,iso_TRAC_tend] = get_iso_budget(uflx,vflx,wflx,GGUD,TRAC,TRAC_tend,sigma_idx,g)

    % Breaks down flux into along/across isopycnal for (nx-2,ny-2) points
    % Must provide boundary points at both extremes of x and y axes
    % Those are needed to break the flux into along/across isopycnal
    % components.

    DRF = g.DRF;
    nRF_i = g.nRF_i;
    dz_i = g.dz_i;
    DRF_i = g.DRF_i;
    DRF_3D = transpose(squeeze(DRF)); DRF_3D = permute(DRF_3D,[3 1 2]); % Forces it to be in 3rd dimension

    nx = size(wflx,1);
    ny = size(wflx,2);
    nRC_i = nRF_i - 1;
    nRC_sig = size(sigma_idx,3)-1;

    % Setting output variables
    iso_uflx = zeros(nx-2,ny-2,nRC_sig);
    iso_vflx = zeros(nx-2,ny-2,nRC_sig);
    iso_bflx = zeros(nx-2,ny-2,nRC_sig);
    iso_tflx = zeros(nx-2,ny-2,nRC_sig);
    iso_TRAC = zeros(nx-2,ny-2,nRC_sig);
    iso_TRAC_tend = zeros(nx-2,ny-2,nRC_sig);
    iso_GGUD = zeros(nx-2,ny-2,nRC_sig);

    % Remapping horizontal/center quantities
    uflx = remap_vert_cons(uflx,DRF,dz_i,nRC_i);
    vflx = remap_vert_cons(vflx,DRF,dz_i,nRC_i);
    GGUD = remap_vert_cons(GGUD,DRF,dz_i,nRC_i);
    TRAC = remap_vert_cons(TRAC.*DRF_3D,DRF,dz_i,nRC_i); % depth integrated tracer concentration
    TRAC_tend = remap_vert_cons(TRAC_tend,DRF,dz_i,nRC_i);

    % Remapping vertical quantities
    wflx = remap_vert_RF(wflx,DRF,dz_i,nRF_i);
   
    % Getting along and across isopycnal fluxes
    sigma_min_idx = sigma_idx(:,:,1);

    for cnt=1:nRC_sig
        sigma_max_idx = sigma_idx(:,:,cnt+1);

        for i=2:nx-1
            ip1 = i+1;
            im1 = i-1;
            for j=2:ny-1
                jm1 = j-1;
                jp1 = j+1;

                % Making vectors out of min/max values
                v = sigma_min_idx(i,j):1:sigma_max_idx(i,j);
                vip1 = sigma_min_idx(ip1,j):1:sigma_max_idx(ip1,j);
                vjp1 = sigma_min_idx(i,jp1):1:sigma_max_idx(i,jp1);
                vim1 = sigma_min_idx(im1,j):1:sigma_max_idx(im1,j);
                vjm1 = sigma_min_idx(i,jm1):1:sigma_max_idx(i,jm1);

                % Getting along fluxes
                [k_im1_int,k_im1_diff] = get_int_setdiff(v,vim1);
                [k_jm1_int,k_jm1_diff] = get_int_setdiff(v,vjm1);
                iso_uflx(i-1,j-1,cnt) = sum(uflx(i-1,j-1,k_im1_int),3);
                iso_vflx(i-1,j-1,cnt) = sum(vflx(i-1,j-1,k_jm1_int),3);

                % Getting across fluxes
                k_ip1_diff = get_setdiff(v,vip1);
                k_jp1_diff = get_setdiff(v,vjp1);
                k = sigma_min_idx(i,j); % (shallower)
                kp1 = sigma_max_idx(i,j) + 1; % (deeper)

                im1_lim = max([1 vim1]);
                jm1_lim = max([1 vjm1]);
                ip1_lim = max([1 vip1]);
                jp1_lim = max([1 vjp1]);

                % Getting across - top fluxes
                kim1_top = k_im1_diff; kim1_top(kim1_top >= im1_lim) = [];
                kjm1_top = k_jm1_diff; kjm1_top(kjm1_top >= jm1_lim) = [];
                kip1_top = k_ip1_diff; kip1_top(kip1_top >= ip1_lim) = [];
                kjp1_top = k_jp1_diff; kjp1_top(kjp1_top >= jp1_lim) = [];

                iso_tflx(i-1,j-1,cnt) =  -sum(uflx(i-1,j-1,kim1_top),3) - sum(vflx(i-1,j-1,kjm1_top),3) + ...
                                               sum(uflx(ip1-1,j-1,kip1_top),3) + sum(vflx(i-1,jp1-1,kjp1_top),3) + ...
                                               + wflx(i,j,k);

                % Getting across - bottom fluxes
                kim1_bot = k_im1_diff; kim1_bot(kim1_bot < im1_lim) = [];
                kjm1_bot = k_jm1_diff; kjm1_bot(kjm1_bot < jm1_lim) = [];
                kip1_bot = k_ip1_diff; kip1_bot(kip1_bot < ip1_lim) = [];
                kjp1_bot = k_jp1_diff; kjp1_bot(kjp1_bot < jp1_lim) = [];

                iso_bflx(i-1,j-1,cnt) = sum(uflx(i-1,j-1,kim1_bot),3) + sum(vflx(i-1,j-1,kjm1_bot),3) + ...
                                              -sum(uflx(ip1-1,j-1,kip1_bot),3) - sum(vflx(i-1,jp1-1,kjp1_bot),3) + ...
                                              + wflx(i,j,kp1);

                % Net tendency
                iso_GGUD(i-1,j-1,cnt) = sum(GGUD(i,j,v),3);
                iso_TRAC_tend(i-1,j-1,cnt) = sum(TRAC_tend(i,j,v),3);
                iso_TRAC(i-1,j-1,cnt) = sum(TRAC(i,j,v),3) / sum(DRF_i(v));

            end
        end
        sigma_min_idx = sigma_max_idx + 1;

    end

end

function Z = get_setdiff(X,Y)
    if ~isempty(X)&&~isempty(Y)
      check = false(1, max(max(X), max(Y)));
      check(X) = true;
      check(Y) = false;
      Z = X(check(X));
    else
      Z = X;
    end
end

function [int,diff] = get_int_setdiff(X,Y)

    % This has been corrected

    if ~isempty(X)&&~isempty(Y)
        P = zeros(1, max(max(X),max(Y)) ) ;
        check = false(1, max(max(X), max(Y)));

        P(X) = 1;
        int = Y(logical(P(Y)));

        check(X) = true;
        check(Y) = false;
        diff = X(check(X));

    else
        int = [];
        diff = X;
    end

end
