#Developed by Jan Fabian Martin




#importing libraries
library(ggplot2)
library(tidyr)
library(dplyr)
library("ggthemes")
library("ggpubr")




#importing dataframes
prob_onwind <- read.csv("Rdata/probability/prob_onwind.csv")
prob_offwind <- read.csv("Rdata/probability//prob_offwind.csv") 
prob_solar <- read.csv("Rdata/probability//prob_solar.csv") 

synthCorrectSd <- read.csv("Rdata/probability//synthCorrectSd.csv") 


probM_onwind <- read.csv("Rdata/probability//probabilityMatrix_onwind.csv")
probM_offwind <- read.csv("Rdata/probability//probabilityMatrix_offwind.csv")
probM_solar <- read.csv("Rdata/probability//probabilityMatrix_solar.csv")





#rmse values (literature)

prob_lit <- data.frame(x = prob_onwind$X,
                       y = c(prob_onwind$RMSE...., prob_offwind$RMSE...., prob_solar$RMSE....),
                       group = c(rep('onshore wind', nrow(prob_onwind)),
                                 rep('offshore wind', nrow(prob_offwind)),
                                 rep('photovoltaic', nrow(prob_solar))))                        




ggp_lit <- ggplot(prob_lit, aes(x=x/4, y=y)) +
  geom_line(aes(color=group), size=1.3) + 
  scale_color_manual(values=c("#33beff", "#3358ff",  "#ffe333"))+
  scale_y_continuous(breaks=seq(0,15,by=2)) +
  scale_x_continuous(breaks=seq(0,36,by=2)) +
  labs(x="forecasting lead-time [h]",
       y="RMSE [% of P installed]",
       color="")+
  theme_set(theme_bw(base_size = 20))+
  theme(legend.position="bottom")


ggp_lit

ggsave("rmse_lit.pdf", width = 34, height = 20, units = "cm")






#rmse values (synth) - (values for entire year)

prob_synth <- data.frame(x = synthCorrectSd$X,
                       y = c(synthCorrectSd$onwind*100, synthCorrectSd$offwind*100,synthCorrectSd$solar*100),
                       group = c(rep('onshore wind', nrow(synthCorrectSd)),
                                 rep('offshore wind', nrow(synthCorrectSd)),
                                 rep('photovoltaic', nrow(synthCorrectSd))))                        



ggp_synth <- ggplot(prob_synth, aes(x=x/4, y=y)) +
  geom_line(aes(color=group), size=1.3) + 
  scale_color_manual(values=c("#33beff", "#3358ff",  "#ffe333"))+
  scale_y_continuous(breaks=seq(0,28,by=2)) +
  scale_x_continuous(breaks=seq(0,36,by=2)) +
  labs(x="forecasting lead-time [h]",
       y="standard deviation [% of power output]",
       color="")+
  theme_set(theme_bw(base_size = 20))+
  theme(legend.position="bottom")

ggp_synth

ggsave("rmse_synth.pdf", width = 34, height = 20, units = "cm")





#-----------------------------------------------------------------------------------------------------------------------------------
#ribbon plot offwind:

f= gather(probM_offwind[1:5000], key='year', value='deviation', 2:5000)

ribbonPlotOffwind<-ggplot(f, aes(x=X/4, y=(deviation*100-100))) +
  stat_summary(geom="ribbon", fun.min = function(x) quantile(x, 0.01), fun.max = function(x) quantile(x, 0.99), fill="gray75")+
  stat_summary(geom="ribbon", fun.min = function(x) quantile(x, 0.05), fun.max = function(x) quantile(x, 0.95), fill="gray50")+
  stat_summary(geom="ribbon", fun.min = function(x) quantile(x, 0.25), fun.max = function(x) quantile(x, 0.75), fill="gray25")+
  scale_y_continuous(breaks=seq(-70,70,by=10)) +
  scale_x_continuous(breaks=seq(0,37,by=2)) +
  annotate("text", x=30, y=0, label="Quantile: [0.25,0.75]", color="white", size=6)+
  annotate("text", x=30, y=30, label="Quantile: [0.05,0.95]", color="white", size=6)+
  annotate("text", x=30, y=53, label="Quantile: [0.01,0.99]", color="black", size=6)+
  labs(x="lead time [h]",
       y="forecasting error [%]",
       color="") +
  theme_set(theme_bw(base_size = 20))+
  theme(legend.position="bottom")

ribbonPlotOffwind
ggsave("ribbonPlotOffwind.pdf", width = 34, height = 20, units = "cm")



#ribbon plot onwind:

f= gather(probM_onwind[1:5000], key='year', value='deviation', 2:5000)


ribbonPlotOnwind<-ggplot(f, aes(x=X/4, y=(deviation*100-100))) +
  stat_summary(geom="ribbon", fun.min = function(x) quantile(x, 0.01), fun.max = function(x) quantile(x, 0.99), fill="gray75")+
  stat_summary(geom="ribbon", fun.min = function(x) quantile(x, 0.05), fun.max = function(x) quantile(x, 0.95), fill="gray50")+
  stat_summary(geom="ribbon", fun.min = function(x) quantile(x, 0.25), fun.max = function(x) quantile(x, 0.75), fill="gray25")+
  scale_y_continuous(breaks=seq(-60,60,by=10)) +
  scale_x_continuous(breaks=seq(0,37,by=2)) +
  annotate("text", x=30, y=0, label="Quantile: [0.25,0.75]", color="white", size=6)+
  annotate("text", x=30, y=25, label="Quantile: [0.05,0.95]", color="white", size=6)+
  annotate("text", x=30, y=45, label="Quantile: [0.01,0.99]", color="black", size=6)+
  labs(x="lead time [h]",
       y="forecasting error [%]",
       color="") +
  theme_set(theme_bw(base_size = 20))+
  theme(legend.position="bottom")

ribbonPlotOnwind
ggsave("ribbonPlotOnwind.pdf", width = 34, height = 20, units = "cm")



#ribbon plot solar:

f= gather(probM_solar[1:5000], key='year', value='deviation', 2:5000)


ribbonPlotSolar<-ggplot(f, aes(x=X/4, y=(deviation*100-100))) +
  stat_summary(geom="ribbon", fun.min = function(x) quantile(x, 0.01), fun.max = function(x) quantile(x, 0.99), fill="gray75")+
  stat_summary(geom="ribbon", fun.min = function(x) quantile(x, 0.05), fun.max = function(x) quantile(x, 0.95), fill="gray50")+
  stat_summary(geom="ribbon", fun.min = function(x) quantile(x, 0.25), fun.max = function(x) quantile(x, 0.75), fill="gray25")+
  scale_y_continuous(breaks=seq(-70,70,by=10)) +
  scale_x_continuous(breaks=seq(0,37,by=2)) +
  annotate("text", x=30, y=0, label="Quantile: [0.25,0.75]", color="white", size=6)+
  annotate("text", x=30, y=27, label="Quantile: [0.05,0.95]", color="white", size=6)+
  annotate("text", x=30, y=48, label="Quantile: [0.01,0.99]", color="black", size=6)+
  labs(x="lead time [h]",
       y="forecasting error [%]",
       color="") +
  theme_set(theme_bw(base_size = 20))+
  theme(legend.position="bottom")

ribbonPlotSolar
ggsave("ribbonPlotsolar.pdf", width = 34, height = 20, units = "cm")

