#Developed by Jan Fabian Martin



# importing libraries
library(ggplot2)
library("ggthemes")
library(ggpubr)


# importing dataframes
dpc_before_balancing <- read.csv("Rdata/dpc_before_balancing.csv")
dpc_after_balancing <- read.csv("Rdata/dpc_after_balancing.csv")


balancingDispatch <- read.csv("Rdata/dpc_balancing.csv")

balancingUp <- read.csv("Rdata/balancing_up.csv")
balancingDown <- read.csv("Rdata/balancing_down.csv")


#--------------------------

#Dispatch before balancing


x = c(24, 12, 8, 6, 4, 2, 1)

#flexible (OCGT, oil)
flexible <- ggplot(dpc_before_balancing, aes(x=factor(x), y=(OCGT+oil)*1e-6)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  coord_cartesian(ylim=c(min(dpc_before_balancing$OCGT+dpc_before_balancing$oil)*0.999e-6, max(dpc_before_balancing$OCGT+dpc_before_balancing$oil)*1.001e-6))+
  labs(title="flexible")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))


#penalty-term
Penalty <- ggplot(dpc_before_balancing, aes(x=factor(x), y=penalty*1e-6)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  labs(title="penalty")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))


#semi-flexible (CCGT, coal)
semiflexible <- ggplot(dpc_before_balancing, aes(x=factor(x), y=(CCGT+coal)*1e-6)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  coord_cartesian(ylim=c(min(dpc_before_balancing$CCGT+dpc_before_balancing$coal)*0.999e-6, max(dpc_before_balancing$CCGT+dpc_before_balancing$coal)*1.001e-6))+
  labs(title="semi-flexible")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))



#least-flexible (lignite, nuclear, biomass, ror)
leastflexible <- ggplot(dpc_before_balancing, aes(x=factor(x), y=(lignite+nuclear+biomass+ror)*1e-6)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  coord_cartesian(ylim=c(min(dpc_before_balancing$lignite+dpc_before_balancing$nuclear+dpc_before_balancing$biomas+dpc_before_balancing$ror)*0.999e-6, max(dpc_before_balancing$lignite+dpc_before_balancing$nuclear+dpc_before_balancing$biomas+dpc_before_balancing$ror)*1.001e-6))+
  labs(title="least-flexible")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))


#variable renewable energy
vre <- ggplot(dpc_before_balancing, aes(x=factor(x), y=(offwind.ac+offwind.dc+onwind+solar)*1e-6)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  coord_cartesian(ylim=c(min(dpc_before_balancing$offwind.ac+dpc_before_balancing$offwind.dc+dpc_before_balancing$onwind+dpc_before_balancing$solar)*0.999e-6, max(dpc_before_balancing$offwind.ac+dpc_before_balancing$offwind.dc+dpc_before_balancing$onwind+dpc_before_balancing$solar)*1.001e-6))+
  labs(title="VRE")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))



#arrange plots on one page
dpc_before_balancing_ggp <- ggarrange(flexible, semiflexible, leastflexible, vre)


annotate_figure(dpc_before_balancing_ggp,
                left = text_grob("total generation [TWh]", rot = 90, size=20),
                bottom = text_grob("auction frequency [h]", size=20))



ggsave("dpcbeforeBalancing.pdf", width = 34, height = 20, units = "cm")





#-------

#Dispatch after balancing

x = c(24, 12, 8, 6, 4, 2, 1)

#flexible (OCGT, oil)
flexible <- ggplot(dpc_after_balancing, aes(x=factor(x), y=(OCGT+oil)*1e-6)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  coord_cartesian(ylim=c(min(dpc_after_balancing$OCGT+dpc_after_balancing$oil)*0.999e-6, max(dpc_after_balancing$OCGT+dpc_after_balancing$oil)*1.001e-6))+
  labs(title="flexible")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))


#penalty-term
Penalty <- ggplot(dpc_after_balancing, aes(x=factor(x), y=penalty*1e-6)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  labs(title="penalty")+
  scale_y_continuous(breaks=seq(0,0.3,by=0.05)) +
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))


#semi-flexible (CCGT, coal)
semiflexible <- ggplot(dpc_after_balancing, aes(x=factor(x), y=(CCGT+coal)*1e-6)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  coord_cartesian(ylim=c(min(dpc_after_balancing$CCGT+dpc_after_balancing$coal)*0.999e-6, max(dpc_after_balancing$CCGT+dpc_after_balancing$coal)*1.001e-6))+
  labs(title="semi-flexible")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))



#least-flexible (lignite, nuclear, biomass, ror)
leastflexible <- ggplot(dpc_after_balancing, aes(x=factor(x), y=(lignite+nuclear+biomass+ror)*1e-6)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  coord_cartesian(ylim=c(min(dpc_after_balancing$lignite+dpc_after_balancing$nuclear+dpc_after_balancing$biomas+dpc_after_balancing$ror)*0.999e-6, max(dpc_after_balancing$lignite+dpc_after_balancing$nuclear+dpc_after_balancing$biomas+dpc_after_balancing$ror)*1.001e-6))+
  labs(title="least-flexible")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))


#variable renewable energy
vre <- ggplot(dpc_after_balancing, aes(x=factor(x), y=(offwind.ac+offwind.dc+onwind+solar)*1e-6)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  coord_cartesian(ylim=c(min(dpc_after_balancing$offwind.ac+dpc_after_balancing$offwind.dc+dpc_after_balancing$onwind+dpc_after_balancing$solar)*0.999e-6, max(dpc_after_balancing$offwind.ac+dpc_after_balancing$offwind.dc+dpc_after_balancing$onwind+dpc_after_balancing$solar)*1.001e-6))+
  labs(title="VRE")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))



#arrange plots on one pageg
dpc_after_balancing_ggp <- ggarrange(flexible, semiflexible, leastflexible, vre, Penalty, ncol = 2, nrow = 3)


annotate_figure(dpc_after_balancing_ggp,
                left = text_grob("total generation [TWh]", rot = 90, size=20),
                bottom = text_grob("auction frequency [h]", size=20))



ggsave("dpcafterBalancing.pdf", width = 34, height = 27, units = "cm")






#--------------------------

#Balancing dispatch

x = c(24, 12, 8, 6, 4, 2, 1)

#flexible (OCGT, oil)
flexible <- ggplot(balancingDispatch, aes(x=factor(x), y=(OCGT+oil)*1e-3)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  scale_y_continuous(breaks=seq(0,600,by=100)) +
  labs(title="flexible")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))


#penalty-term
Penalty <- ggplot(balancingDispatch, aes(x=factor(x), y=penalty*1e-3)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  scale_y_continuous(breaks=seq(0,300,by=50)) +
  labs(title="penalty")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))


#semi-flexible (CCGT, coal)
semiflexible <- ggplot(balancingDispatch, aes(x=factor(x), y=(CCGT+coal)*1e-3)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  scale_y_continuous(breaks=seq(-300,0,by=50)) +
  labs(title="semi-flexible")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))



#least-flexible (lignite, nuclear, biomass, ror)
leastflexible <- ggplot(balancingDispatch, aes(x=factor(x), y=(lignite+nuclear+biomass+ror)*1e-3)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  scale_y_continuous(breaks=seq(-600,0,by=100)) +
  labs(title="least-flexible")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))


#variable renewable energy
vre <- ggplot(balancingDispatch, aes(x=factor(x), y=(offwind.ac+offwind.dc+onwind+solar)*1e-3)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  scale_y_continuous(breaks=seq(-50,0,by=10)) +
  labs(title="VRE")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))



#arrange plots on one page
balancingDispatch_ggp <- ggarrange(flexible, semiflexible, leastflexible, vre, Penalty, ncol = 2, nrow = 3)


annotate_figure(balancingDispatch_ggp,
                left = text_grob("total generation [GWh]", rot = 90, size=20),
                bottom = text_grob("auction frequency [h]", size=20))



ggsave("balancingDispatch.pdf", width = 34, height = 27, units = "cm")







#--------------------------

#Up-balancing dispatch

x = c(24, 12, 8, 6, 4, 2, 1)

#flexible (OCGT, oil)
flexible <- ggplot(balancingUp, aes(x=factor(x), y=(OCGT+oil)*1e-3)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  scale_y_continuous(breaks=seq(0,300,by=50)) +
  labs(title="flexible")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))


#penalty-term
Penalty <- ggplot(balancingUp, aes(x=factor(x), y=penalty*1e-3)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  scale_y_continuous(breaks=seq(0,60,by=10)) +
  labs(title="penalty")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))


#semi-flexible (CCGT, coal)
semiflexible <- ggplot(balancingUp, aes(x=factor(x), y=(CCGT+coal)*1e-3)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  scale_y_continuous(breaks=seq(0,500,by=100)) +
  labs(title="semi-flexible")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))



#least-flexible (lignite, nuclear, biomass, ror)
leastflexible <- ggplot(balancingUp, aes(x=factor(x), y=(lignite+nuclear+biomass+ror)*1e-3)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  scale_y_continuous(breaks=seq(0,200,by=50)) +
  labs(title="least-flexible")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))



#arrange plots on one pageg
balancingUp_ggp <- ggarrange(flexible, semiflexible, leastflexible, Penalty)


annotate_figure(balancingUp_ggp,
                left = text_grob("total generation [GWh]", rot = 90, size=20),
                bottom = text_grob("auction frequency [h]", size=20))



ggsave("balancingUp.pdf", width = 34, height = 20, units = "cm")







#Down-balancing dispatch

x = c(24, 12, 8, 6, 4, 2, 1)

#flexible (OCGT, oil)
flexible <- ggplot(balancingDown, aes(x=factor(x), y=(OCGT+oil)*1e-3)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  scale_y_continuous(breaks=seq(-250,0,by=25)) +
  labs(title="flexible")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))


#penalty-term
Penalty <- ggplot(balancingDown, aes(x=factor(x), y=penalty*1e-3)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  #scale_y_continuous(breaks=seq(0,300,by=50)) +
  labs(title="penalty")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))


#semi-flexible (CCGT, coal)
semiflexible <- ggplot(balancingDown, aes(x=factor(x), y=(CCGT+coal)*1e-3)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  scale_y_continuous(breaks=seq(-400,0,by=50)) +
  labs(title="semi-flexible")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))



#least-flexible (lignite, nuclear, biomass, ror)
leastflexible <- ggplot(balancingDown, aes(x=factor(x), y=(lignite+nuclear+biomass+ror)*1e-3)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  scale_y_continuous(breaks=seq(-600,0,by=100)) +
  labs(title="least-flexible")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))


#variable renewable energy
vre <- ggplot(balancingDown, aes(x=factor(x), y=(offwind.ac+offwind.dc+onwind+solar)*1e-3)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  scale_y_continuous(breaks=seq(-350,0,by=50)) +
  labs(title="VRE")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))



#arrange plots on one pageg
balancingdown_ggp <- ggarrange(flexible, semiflexible, leastflexible, vre)


annotate_figure(balancingdown_ggp,
                left = text_grob("total generation [GWh]", rot = 90, size=20),
                bottom = text_grob("auction frequency [h]", size=20))



ggsave("balancingDown.pdf", width = 34, height = 20, units = "cm")

