#Developed by Jan Fabian Martin




# importing libraries
library(ggplot2)
library("ggthemes")
library(ggpubr)




# importing dataframes
dpc_before_balancing <- read.csv("Rdata/dpc_before_balancing.csv")
dpc_after_balancing <- read.csv("Rdata/dpc_after_balancing.csv")


balancingDispatch <- read.csv("Rdata/dpc_balancing.csv")

balancingUp <- read.csv("Rdata/balancing_up.csv")
balancingDown <- read.csv("Rdata/balancing_down.csv")


#--------------------------

#Dispatch before balancing (stacked per carrier separately) - 1hf as reference/baseline


x = c(24, 12, 8, 6, 4, 2, 1)

#CCGT
CCGT <- ggplot(dpc_before_balancing, aes(x=factor(x), y=CCGT*1e-6)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  coord_cartesian(ylim=c(min(dpc_before_balancing$CCGT)*0.999e-6, max(dpc_before_balancing$CCGT)*1.001e-6))+
  labs(title="CCGT")+
  theme_fivethirtyeight() +
  scale_y_continuous(breaks = scales::pretty_breaks(n = 5))+
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))

#OCGT
OCGT <- ggplot(dpc_before_balancing, aes(x=factor(x), y=OCGT*1e-6)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  coord_cartesian(ylim=c(min(dpc_before_balancing$OCGT)*0.999e-6, max(dpc_before_balancing$OCGT)*1.001e-6))+
  labs(title="OCGT")+
  theme_fivethirtyeight() +
  scale_y_continuous(breaks = scales::pretty_breaks(n = 5))+
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))


#biomass
Biomass <- ggplot(dpc_before_balancing, aes(x=factor(x), y=biomass*1e-6)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  coord_cartesian(ylim=c(min(dpc_before_balancing$biomass)*0.999e-6, max(dpc_before_balancing$biomass)*1.001e-6))+
  labs(title="biomass")+
  theme_fivethirtyeight() +
  scale_y_continuous(breaks = scales::pretty_breaks(n = 5))+
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))



#coal
Coal <- ggplot(dpc_before_balancing, aes(x=factor(x), y=coal*1e-6)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  coord_cartesian(ylim=c(min(dpc_before_balancing$coal)*0.999e-6, max(dpc_before_balancing$coal)*1.001e-6))+
  labs(title="coal")+
  theme_fivethirtyeight() +
  scale_y_continuous(breaks = scales::pretty_breaks(n = 5))+
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))

#lignite
Lignite <- ggplot(dpc_before_balancing, aes(x=factor(x), y=lignite*1e-6)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  coord_cartesian(ylim=c(min(dpc_before_balancing$lignite)*0.998e-6, max(dpc_before_balancing$lignite)*1.0014e-6))+
  labs(title="lignite")+
  theme_fivethirtyeight() +
  scale_y_continuous(breaks = scales::pretty_breaks(n = 5))+
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))



#nuclear
Nuclear <- ggplot(dpc_before_balancing, aes(x=factor(x), y=nuclear*1e-6)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  coord_cartesian(ylim=c(min(dpc_before_balancing$nuclear)*0.999e-6, max(dpc_before_balancing$nuclear)*1.001e-6))+
  labs(title="nuclear")+
  theme_fivethirtyeight() +
  scale_y_continuous(breaks = scales::pretty_breaks(n = 5))+
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))


#oil
Oil <- ggplot(dpc_before_balancing, aes(x=factor(x), y=oil*1e-6)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  coord_cartesian(ylim=c(min(dpc_before_balancing$oil)*0.999e-6, max(dpc_before_balancing$oil)*1.001e-6))+
  labs(title="oil")+
  theme_fivethirtyeight() +
  scale_y_continuous(breaks = scales::pretty_breaks(n = 5))+
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))



#onwind
Onwind <- ggplot(dpc_before_balancing, aes(x=factor(x), y=onwind*1e-6)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  coord_cartesian(ylim=c(min(dpc_before_balancing$onwind)*0.999e-6, max(dpc_before_balancing$onwind)*1.001e-6))+
  labs(title="onshore wind")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))



#offwind (ac&dc)
Offwind <- ggplot(dpc_before_balancing, aes(x=factor(x), y=(offwind.ac+offwind.dc)*1e-6)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  coord_cartesian(ylim=c(min(dpc_before_balancing$offwind.ac+dpc_before_balancing$offwind.dc)*0.999e-6, max(dpc_before_balancing$offwind.ac+dpc_before_balancing$offwind.dc)*1.001e-6))+
  labs(title="offshore wind")+
  theme_fivethirtyeight() +
  scale_y_continuous(breaks = scales::pretty_breaks(n = 5))+
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))

#solar
Solar <- ggplot(dpc_before_balancing, aes(x=factor(x), y=solar*1e-6)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  coord_cartesian(ylim=c(min(dpc_before_balancing$solar)*0.999e-6, max(dpc_before_balancing$solar)*1.001e-6))+
  labs(title="solar")+
  theme_fivethirtyeight() +
  scale_y_continuous(breaks = scales::pretty_breaks(n = 5))+
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))



#ror
Ror <- ggplot(dpc_before_balancing, aes(x=factor(x), y=ror*1e-6)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  coord_cartesian(ylim=c(min(dpc_before_balancing$ror)*0.999e-6, max(dpc_before_balancing$ror)*1.001e-6))+
  labs(title="run-of-river")+
  theme_fivethirtyeight() +
  scale_y_continuous(breaks = scales::pretty_breaks(n = 5))+
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))



#arrange plots on one page
dpc_before_balancing_ggp <- ggarrange(OCGT, Oil, Coal, Lignite, Biomass, Nuclear, Onwind, Offwind, Solar, Ror,  ncol = 3, nrow = 4)


annotate_figure(dpc_before_balancing_ggp,
                left = text_grob("total generation [TWh]", rot = 90, size=20),
                bottom = text_grob("auction frequency [h]", size=20))



ggsave("dpcbeforeBalancing.pdf", width = 34, height = 27, units = "cm")



#-------

#Dispatch after balancing (stacked per carrier separately) - 1hf as reference/baseline

x = c(24, 12, 8, 6, 4, 2, 1)

#CCGT
CCGT <- ggplot(dpc_after_balancing, aes(x=factor(x), y=CCGT*1e-6)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  coord_cartesian(ylim=c(min(dpc_after_balancing$CCGT)*0.999e-6, max(dpc_after_balancing$CCGT)*1.001e-6))+
  labs(title="CCGT")+
  theme_fivethirtyeight() +
  scale_y_continuous(breaks = scales::pretty_breaks(n = 5))+
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))

#OCGT
OCGT <- ggplot(dpc_after_balancing, aes(x=factor(x), y=OCGT*1e-6)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  coord_cartesian(ylim=c(min(dpc_after_balancing$OCGT)*0.999e-6, max(dpc_after_balancing$OCGT)*1.001e-6))+
  labs(title="OCGT")+
  theme_fivethirtyeight() +
  scale_y_continuous(breaks = scales::pretty_breaks(n = 5))+
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))


#biomass
Biomass <- ggplot(dpc_after_balancing, aes(x=factor(x), y=biomass*1e-6)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  coord_cartesian(ylim=c(min(dpc_after_balancing$biomass)*0.999e-6, max(dpc_after_balancing$biomass)*1.001e-6))+
  labs(title="biomass")+
  theme_fivethirtyeight() +
  scale_y_continuous(breaks = scales::pretty_breaks(n = 5))+
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))



#coal
Coal <- ggplot(dpc_after_balancing, aes(x=factor(x), y=coal*1e-6)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  coord_cartesian(ylim=c(min(dpc_after_balancing$coal)*0.999e-6, max(dpc_after_balancing$coal)*1.001e-6))+
  labs(title="coal")+
  theme_fivethirtyeight() +
  scale_y_continuous(breaks = scales::pretty_breaks(n = 5))+
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))

#lignite
Lignite <- ggplot(dpc_after_balancing, aes(x=factor(x), y=lignite*1e-6)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  coord_cartesian(ylim=c(min(dpc_after_balancing$lignite)*0.999e-6, max(dpc_after_balancing$lignite)*1.001e-6))+
  labs(title="lignite")+
  theme_fivethirtyeight() +
  scale_y_continuous(breaks = scales::pretty_breaks(n = 5))+
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))



#nuclear
Nuclear <- ggplot(dpc_after_balancing, aes(x=factor(x), y=nuclear*1e-6)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  coord_cartesian(ylim=c(min(dpc_after_balancing$nuclear)*0.999e-6, max(dpc_after_balancing$nuclear)*1.001e-6))+
  labs(title="nuclear")+
  theme_fivethirtyeight() +
  scale_y_continuous(breaks = scales::pretty_breaks(n = 5))+
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))


#oil
Oil <- ggplot(dpc_after_balancing, aes(x=factor(x), y=oil*1e-6)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  coord_cartesian(ylim=c(min(dpc_after_balancing$oil)*0.999e-6, max(dpc_after_balancing$oil)*1.001e-6))+
  labs(title="oil")+
  theme_fivethirtyeight() +
  scale_y_continuous(breaks = scales::pretty_breaks(n = 5))+
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))



#onwind
Onwind <- ggplot(dpc_after_balancing, aes(x=factor(x), y=onwind*1e-6)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  coord_cartesian(ylim=c(min(dpc_after_balancing$onwind)*0.999e-6, max(dpc_after_balancing$onwind)*1.001e-6))+
  labs(title="onshore wind")+
  theme_fivethirtyeight() +
  scale_y_continuous(breaks = scales::pretty_breaks(n = 5))+
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))



#offwind (ac&dc)
Offwind <- ggplot(dpc_after_balancing, aes(x=factor(x), y=(offwind.ac+offwind.dc)*1e-6)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  coord_cartesian(ylim=c(min(dpc_after_balancing$offwind.ac+dpc_after_balancing$offwind.dc)*0.999e-6, max(dpc_after_balancing$offwind.ac+dpc_after_balancing$offwind.dc)*1.001e-6))+
  labs(title="offshore wind")+
  theme_fivethirtyeight() +
  scale_y_continuous(breaks = scales::pretty_breaks(n = 5))+
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))

#solar
Solar <- ggplot(dpc_after_balancing, aes(x=factor(x), y=solar*1e-6)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  coord_cartesian(ylim=c(min(dpc_after_balancing$solar)*0.999e-6, max(dpc_after_balancing$solar)*1.001e-6))+
  labs(title="solar")+
  theme_fivethirtyeight() +
  scale_y_continuous(breaks = scales::pretty_breaks(n = 5))+
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))



#ror
Ror <- ggplot(dpc_after_balancing, aes(x=factor(x), y=ror*1e-6)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  coord_cartesian(ylim=c(min(dpc_after_balancing$ror)*0.999e-6, max(dpc_after_balancing$ror)*1.001e-6))+
  labs(title="run-of-river")+
  theme_fivethirtyeight() +
  scale_y_continuous(breaks = scales::pretty_breaks(n = 5))+
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))



#penalty-term
Penalty <- ggplot(dpc_after_balancing, aes(x=factor(x), y=penalty*1e-6)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  #scale_y_continuous(breaks=seq(0,2.5,by=0.5)) +
  labs(title="penalty")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))


#arrange plots on one page
dpc_after_balancing_ggp <- ggarrange(OCGT, Oil, Coal, Lignite, Biomass, Nuclear, Onwind, Offwind, Solar, Ror, Penalty, ncol = 3, nrow = 4)


annotate_figure(dpc_after_balancing_ggp,
                left = text_grob("total generation [TWh]", rot = 90, size=20),
                bottom = text_grob("auction frequency [h]", size=20))



ggsave("dpcafterBalancing.pdf", width = 34, height = 27, units = "cm")





#--------------------------

#Balancing dispatch (stacked per carrier separately)

x = c(24, 12, 8, 6, 4, 2, 1)



#OCGT
OCGT <- ggplot(balancingDispatch, aes(x=factor(x), y=OCGT*1e-3)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  #scale_y_continuous(breaks=seq(0,300,by=50)) +
  labs(title="OCGT")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))

#CCGT
CCGT <- ggplot(balancingDispatch, aes(x=factor(x), y=CCGT*1e-3)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  #scale_y_continuous(breaks=seq(-2,5,by=1)) +
  labs(title="CCGT")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))


#biomass
Biomass <- ggplot(balancingDispatch, aes(x=factor(x), y=biomass*1e-3)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
 # scale_y_continuous(breaks=seq(-100,0,by=20)) +
  labs(title="biomass")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))



#coal
Coal <- ggplot(balancingDispatch, aes(x=factor(x), y=coal*1e-3)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  #scale_y_continuous(breaks=seq(-300,0,by=50)) +
  labs(title="coal")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))

#lignite
Lignite <- ggplot(balancingDispatch, aes(x=factor(x), y=lignite*1e-3)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  #scale_y_continuous(breaks=seq(-300,0,by=50)) +
  labs(title="lignite")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))



#nuclear
Nuclear <- ggplot(balancingDispatch, aes(x=factor(x), y=nuclear*1e-3)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  scale_y_continuous(breaks=seq(-100,0,by=20)) +
  labs(title="nuclear")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))


#oil
Oil <- ggplot(balancingDispatch, aes(x=factor(x), y=oil*1e-3)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  scale_y_continuous(breaks=seq(0,100,by=20)) +
  labs(title="oil")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))



#onwind
Onwind <- ggplot(balancingDispatch, aes(x=factor(x), y=onwind*1e-3)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  #scale_y_continuous(breaks=seq(-350,0,by=50)) +
  labs(title="onshore wind")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))



#offwind (ac&dc)
Offwind <- ggplot(balancingDispatch, aes(x=factor(x), y=(offwind.ac+offwind.dc)*1e-3)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  #scale_y_continuous(breaks=seq(-6,0,by=1)) +
  labs(title="offshore wind")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))

#solar
Solar <- ggplot(balancingDispatch, aes(x=factor(x), y=solar*1e-3)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  labs(title="solar")+
  theme_fivethirtyeight() +
  #scale_y_continuous(breaks=seq(0,400,by=10)) +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))



#ror
Ror <- ggplot(balancingDispatch, aes(x=factor(x), y=ror*1e-3)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  labs(title="run-of-river")+
  theme_fivethirtyeight() +
  #scale_y_continuous(breaks=seq(0,400,by=10)) +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))



#penalty-term
Penalty <- ggplot(balancingDispatch, aes(x=factor(x), y=penalty*1e-3)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  #scale_y_continuous(breaks=seq(0,350,by=50)) +
  labs(title="penalty")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))


#arrange plots on one page
balancingDispatch_ggp <- ggarrange(OCGT, Oil, Coal, Lignite, Biomass, Nuclear, Onwind, Offwind, Penalty, ncol = 3, nrow = 3)


annotate_figure(balancingDispatch_ggp,
                left = text_grob("total generation [GWh]", rot = 90, size=20),
                bottom = text_grob("auction frequency [h]", size=20))



ggsave("balancingDispatch.pdf", width = 34, height = 28, units = "cm")




#--------------------------

#BalancingUp dispatch (stacked per carrier separately)

x = c(24, 12, 8, 6, 4, 2, 1)

#CCGT
CCGT <- ggplot(balancingUp, aes(x=factor(x), y=CCGT*1e-3)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  labs(title="CCGT")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))

#OCGT
OCGT <- ggplot(balancingUp, aes(x=factor(x), y=OCGT*1e-3)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  scale_y_continuous(breaks=seq(0,300,by=50)) +
  labs(title="OCGT")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))


#biomass
Biomass <- ggplot(balancingUp, aes(x=factor(x), y=biomass*1e-3)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  labs(title="biomass")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))



#coal
Coal <- ggplot(balancingUp, aes(x=factor(x), y=coal*1e-3)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  labs(title="coal")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))

#lignite
Lignite <- ggplot(balancingUp, aes(x=factor(x), y=lignite*1e-3)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  labs(title="lignite")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))



#nuclear
Nuclear <- ggplot(balancingUp, aes(x=factor(x), y=nuclear*1e-3)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  labs(title="nuclear")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))


#oil
Oil <- ggplot(balancingUp, aes(x=factor(x), y=oil*1e-3)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  scale_y_continuous(breaks=seq(0,40,by=5)) +
  labs(title="oil")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))


#ror
Ror <- ggplot(balancingDispatch, aes(x=factor(x), y=ror*1e-3)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  labs(title="run-of-river")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))




#penalty-term
Penalty <- ggplot(balancingUp, aes(x=factor(x), y=penalty*1e-3)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  scale_y_continuous(breaks=seq(0,60,by=10)) +
  labs(title="penalty")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))


#arrange plots on one page
balancingUp_ggp <- ggarrange(OCGT, Oil, Coal, Lignite, Biomass, Nuclear, Penalty, ncol = 3, nrow = 3)


annotate_figure(balancingUp_ggp,
                left = text_grob("total generation [GWh]", rot = 90, size=20),
                bottom = text_grob("auction frequency [h]", size=20))



ggsave("balancingUp.pdf", width = 34, height = 21, units = "cm")




#--------------------------

#BalancingDown dispatch (stacked per carrier separately)


x = c(24, 12, 8, 6, 4, 2, 1)

#CCGT
CCGT <- ggplot(balancingDown, aes(x=factor(x), y=CCGT*1e-3)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  labs(title="CCGT")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))

#OCGT
OCGT <- ggplot(balancingDown, aes(x=factor(x), y=OCGT*1e-3)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  scale_y_continuous(breaks=seq(-200,0,by=25)) +
  labs(title="OCGT")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))


#biomass
Biomass <- ggplot(balancingDown, aes(x=factor(x), y=biomass*1e-3)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  scale_y_continuous(breaks=seq(-120,0,by=20)) +
  labs(title="biomass")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))



#coal
Coal <- ggplot(balancingDown, aes(x=factor(x), y=coal*1e-3)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  scale_y_continuous(breaks=seq(-350,0,by=50)) +
  labs(title="coal")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))

#lignite
Lignite <- ggplot(balancingDown, aes(x=factor(x), y=lignite*1e-3)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  scale_y_continuous(breaks=seq(-350,0,by=50)) +
  labs(title="lignite")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))



#nuclear
Nuclear <- ggplot(balancingDown, aes(x=factor(x), y=nuclear*1e-3)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  scale_y_continuous(breaks=seq(-160,0,by=30)) +
  labs(title="nuclear")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))


#oil
Oil <- ggplot(balancingDown, aes(x=factor(x), y=oil*1e-3)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  scale_y_continuous(breaks=seq(-10,0,by=2)) +
  labs(title="oil")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))



#onwind
Onwind <- ggplot(balancingDown, aes(x=factor(x), y=onwind*1e-3)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  scale_y_continuous(breaks=seq(-350,0,by=50)) +
  labs(title="onshore wind")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))



#offwind (ac&dc)
Offwind <- ggplot(balancingDown, aes(x=factor(x), y=(offwind.ac+offwind.dc)*1e-3)) + 
  geom_bar(stat="identity", fill="#D3D3D3") +
  scale_y_continuous(breaks=seq(-6,0,by=1)) +
  labs(title="offshore wind")+
  theme_fivethirtyeight() +
  theme(plot.background = element_rect(fill = "white"),
        panel.background = element_rect(fill = "white"),
        plot.title = element_text(size=17, face="bold"),
        axis.text.y = element_text(size=16),
        axis.text.x = element_text(size=16))





#arrange plots on one page
balancingDown_ggp <- ggarrange(OCGT, Oil, Coal, Lignite, Biomass, Nuclear, Onwind, Offwind, ncol = 3, nrow = 3)


annotate_figure(balancingDown_ggp,
                left = text_grob("total generation [GWh]", rot = 90, size=20),
                bottom = text_grob("auction frequency [h]", size=20))



ggsave("balancingDown.pdf", width = 34, height = 22, units = "cm")


