#Developed by Jan Fabian Martin



#importing libraries
library("ggplot2")
library("ggthemes")
library("tidyr")



#importing model results
cost_df_baseline <- read.csv("Rdata/cost_df_baseline.csv")
cost_df_pk <- read.csv("Rdata/cost_df_pk.csv")
cost_df_9am <- read.csv("Rdata/cost_df_9am.csv") 
cost_df_mo <- read.csv("Rdata/cost_df_mo.csv") 

cost_df_janfeb <- read.csv("Rdata/cost_df_janfeb.csv")
cost_df_pk_janfeb <- read.csv("Rdata/cost_df_pk_janfeb.csv")



colnames(cost_df_baseline) <- c('index.name', 'variable.cost', 'startup.cost', 'penalty.cost', 'balancing.cost', 'total.cost')
colnames(cost_df_pk) <- c('index.name', 'variable.cost', 'startup.cost', 'penalty.cost', 'balancing.cost', 'total.cost')
colnames(cost_df_9am) <- c('index.name', 'variable.cost', 'startup.cost', 'penalty.cost', 'balancing.cost', 'total.cost')
colnames(cost_df_mo) <- c('index.name', 'variable.cost', 'startup.cost', 'penalty.cost', 'balancing.cost', 'total.cost')


colnames(cost_df_janfeb) <- c('index.name', 'variable.cost', 'startup.cost', 'penalty.cost', 'balancing.cost', 'total.cost')
colnames(cost_df_pk_janfeb) <- c('index.name', 'variable.cost', 'startup.cost', 'penalty.cost', 'balancing.cost', 'total.cost')






#--------------------------------------------------------------------------------------------------
#total costs (absolute)
run1 <- c(cost_df_baseline[1,6], cost_df_baseline[2,6], cost_df_baseline[3,6], cost_df_baseline[4,6], cost_df_baseline[5,6], cost_df_baseline[6,6], cost_df_baseline[7,6])
run2 <- c(cost_df_pk[1,6], cost_df_pk[2,6], cost_df_pk[3,6], cost_df_pk[4,6], cost_df_pk[5,6], cost_df_pk[6,6], cost_df_pk[7,6])
run3 <- c(cost_df_9am[1,6], cost_df_9am[2,6], cost_df_9am[3,6], cost_df_9am[4,6], cost_df_9am[5,6], cost_df_9am[6,6], cost_df_9am[7,6])
run4 <- c(cost_df_mo[1,6], cost_df_mo[2,6], cost_df_mo[3,6], cost_df_mo[4,6], cost_df_mo[5,6], cost_df_mo[6,6], cost_df_mo[7,6])



frequency <- c(24, 12, 8, 6, 4, 2, 1)

tC <- data.frame(run1, run2, run3, run4)
tC$frequency <- frequency

totalCost_ggp <- data.frame(x = tC$frequency,
                            y = c(tC$run1, tC$run2, tC$run3, tC$run4),
                            group = c(rep('baseline scenario', nrow(tC)),
                                      rep('perfect knowledge', nrow(tC)),
                                      rep('sensitivity 2 (8 a.m.)', nrow(tC)),
                                      rep('sensitivity 3 (merit order)', nrow(tC))))


ggp_tC <- ggplot(totalCost_ggp, aes(x=x, y=y*1e-09, color=group)) +
  geom_line(aes(color=group), size=0.8) + geom_point(aes(color=group)) + scale_x_continuous(labels = as.character(totalCost_ggp$x), breaks = totalCost_ggp$x) +
  scale_y_continuous(breaks=seq(1.71,1.80,by=0.005)) +
  labs(x="auction frequency [h]",
       y="total UC costs [billion €]",
       color="") +
  theme_set(theme_bw(base_size = 20))+
  theme(legend.position="bottom")


ggp_tC

ggsave("totalCost_sensitivity.pdf", width = 34, height = 20, units = "cm")




#total costs (% 1h baseline scenario)

run1 <- c(cost_df_baseline[1,6]/cost_df_baseline[7,6], cost_df_baseline[2,6]/cost_df_baseline[7,6], cost_df_baseline[3,6]/cost_df_baseline[7,6], cost_df_baseline[4,6]/cost_df_baseline[7,6], cost_df_baseline[5,6]/cost_df_baseline[7,6], cost_df_baseline[6,6]/cost_df_baseline[7,6], cost_df_baseline[7,6]/cost_df_baseline[7,6])
run2 <- c(cost_df_9am[1,6]/cost_df_baseline[7,6], cost_df_9am[2,6]/cost_df_baseline[7,6], cost_df_9am[3,6]/cost_df_baseline[7,6], cost_df_9am[4,6]/cost_df_baseline[7,6], cost_df_9am[5,6]/cost_df_baseline[7,6], cost_df_9am[6,6]/cost_df_baseline[7,6], cost_df_9am[7,6]/cost_df_baseline[7,6])
run3 <- c(cost_df_mo[1,6]/cost_df_baseline[7,6], cost_df_mo[2,6]/cost_df_baseline[7,6], cost_df_mo[3,6]/cost_df_baseline[7,6], cost_df_mo[4,6]/cost_df_baseline[7,6], cost_df_mo[5,6]/cost_df_baseline[7,6], cost_df_mo[6,6]/cost_df_baseline[7,6], cost_df_mo[7,6]/cost_df_baseline[7,6])
run4 <- c(cost_df_pk[1,6]/cost_df_baseline[7,6], cost_df_pk[2,6]/cost_df_baseline[7,6], cost_df_pk[3,6]/cost_df_baseline[7,6], cost_df_pk[4,6]/cost_df_baseline[7,6], cost_df_pk[5,6]/cost_df_baseline[7,6], cost_df_pk[6,6]/cost_df_baseline[7,6], cost_df_pk[7,6]/cost_df_baseline[7,6])


frequency <- c(24, 12, 8, 6, 4, 2, 1)

r1tC <- data.frame(run1, run2, run3, run4)
r1tC <- r1tC*100
r1tC$frequency <- frequency

relative1totalCost_ggp <- data.frame(x = r1tC$frequency,
                                     y = c(r1tC$run1, r1tC$run2, r1tC$run3, r1tC$run4),
                                     group = c(rep('baseline scenario', nrow(r1tC)),
                                               rep('sensitivity 2 (8 a.m.)', nrow(r1tC)),
                                               rep('sensitivity 3 (merit order)', nrow(r1tC)),
                                               rep('perfect knowledge', nrow(r1tC))))



ggp_r1tC <- ggplot(relative1totalCost_ggp, aes(x=x, y=y)) +
  geom_line(aes(color=group), size=0.8) + geom_point(aes(color=group)) + scale_x_continuous(labels = as.character(relative1totalCost_ggp$x), breaks = relative1totalCost_ggp$x) +
  scale_y_continuous(breaks=seq(98,105,by=0.25)) +
  labs(x="auction frequency [h]",
       y="total UC costs [% (baseline)]",
       color="") +
  theme_set(theme_bw(base_size = 20))+
  theme(legend.position="bottom")


ggp_r1tC

ggsave("1rtotalCost_sensitivity.pdf", width = 34, height = 20, units = "cm")





#--------------------------------------------------------------------------------------------------
#Januar&February

#total costs (absolute)
run1 <- c(cost_df_janfeb[1,6], cost_df_janfeb[2,6], cost_df_janfeb[3,6], cost_df_janfeb[4,6], cost_df_janfeb[5,6], cost_df_janfeb[6,6], cost_df_janfeb[7,6])
run2 <- c(cost_df_pk_janfeb[1,6], cost_df_pk_janfeb[2,6], cost_df_pk_janfeb[3,6], cost_df_pk_janfeb[4,6], cost_df_pk_janfeb[5,6], cost_df_pk_janfeb[6,6], cost_df_pk_janfeb[7,6])

frequency <- c(24, 12, 8, 6, 4, 2, 1)

tC <- data.frame(run1, run2)
tC$frequency <- frequency

totalCost_ggp <- data.frame(x = tC$frequency,
                            y = c(tC$run1, tC$run2),
                            group = c(rep('sensitivity 1 (January & February)', nrow(tC)),
                                      rep('perfect knowledge (January & February)', nrow(tC))))


ggp_tC <- ggplot(totalCost_ggp, aes(x=x, y=y*1e-09, color=group)) +
  geom_line(aes(color=group), size=0.8) + geom_point(aes(color=group)) + scale_x_continuous(labels = as.character(totalCost_ggp$x), breaks = totalCost_ggp$x) +
  scale_y_continuous(breaks=seq(1.9,2.05,by=0.01)) +
  labs(x="auction frequency [h]",
       y="total UC costs [billion €]",
       color="") +
  theme_set(theme_bw(base_size = 20))+
  theme(legend.position="bottom")


ggp_tC

ggsave("totalCost_janfeb.pdf", width = 34, height = 20, units = "cm")




#total costs (% 1h baseline scenario)

run1 <- c(cost_df_janfeb[1,6]/cost_df_janfeb[7,6], cost_df_janfeb[2,6]/cost_df_janfeb[7,6], cost_df_janfeb[3,6]/cost_df_janfeb[7,6], cost_df_janfeb[4,6]/cost_df_janfeb[7,6], cost_df_janfeb[5,6]/cost_df_janfeb[7,6], cost_df_janfeb[6,6]/cost_df_janfeb[7,6], cost_df_janfeb[7,6]/cost_df_janfeb[7,6])
run2 <- c(cost_df_pk_janfeb[1,6]/cost_df_janfeb[7,6], cost_df_pk_janfeb[2,6]/cost_df_janfeb[7,6], cost_df_pk_janfeb[3,6]/cost_df_janfeb[7,6], cost_df_pk_janfeb[4,6]/cost_df_janfeb[7,6], cost_df_pk_janfeb[5,6]/cost_df_janfeb[7,6], cost_df_pk_janfeb[6,6]/cost_df_janfeb[7,6], cost_df_pk_janfeb[7,6]/cost_df_janfeb[7,6])

frequency <- c(24, 12, 8, 6, 4, 2, 1)

r1tC <- data.frame(run1, run2)
r1tC <- r1tC*100
r1tC$frequency <- frequency

relative1totalCost_ggp <- data.frame(x = r1tC$frequency,
                                     y = c(r1tC$run1, r1tC$run2),
                                     group = c(rep('sensitivity 1 (January & February)', nrow(r1tC)),
                                               rep('perfect knowledge (January & February)', nrow(r1tC))))



ggp_r1tC <- ggplot(relative1totalCost_ggp, aes(x=x, y=y)) +
  geom_line(aes(color=group), size=0.8) + geom_point(aes(color=group)) + scale_x_continuous(labels = as.character(totalCost_ggp$x), breaks = totalCost_ggp$x) +
  scale_y_continuous(breaks=seq(98,105,by=0.5)) +
  labs(x="auction frequency [h]",
       y="total UC costs [%]",
       color="") +
  theme_set(theme_bw(base_size = 20))+
  theme(legend.position="bottom")


ggp_r1tC

ggsave("1rtotalCost_janfeb.pdf", width = 34, height = 20, units = "cm")




#balancing cost (% 1h baseline scenario)

run1 <- c(cost_df_baseline[1,5]/cost_df_baseline[7,5], cost_df_baseline[2,5]/cost_df_baseline[7,5], cost_df_baseline[3,5]/cost_df_baseline[7,5], cost_df_baseline[4,5]/cost_df_baseline[7,5], cost_df_baseline[5,5]/cost_df_baseline[7,5], cost_df_baseline[6,5]/cost_df_baseline[7,5], cost_df_baseline[7,5]/cost_df_baseline[7,5])
run2 <- c(cost_df_janfeb[1,5]/cost_df_baseline[7,5], cost_df_janfeb[2,5]/cost_df_baseline[7,5], cost_df_janfeb[3,5]/cost_df_baseline[7,5], cost_df_janfeb[4,5]/cost_df_baseline[7,5], cost_df_janfeb[5,5]/cost_df_baseline[7,5], cost_df_janfeb[6,5]/cost_df_baseline[7,5], cost_df_janfeb[7,5]/cost_df_baseline[7,5])


frequency <- c(24, 12, 8, 6, 4, 2, 1)

r1bC <- data.frame(run1, run2)
r1bC <- r1bC*100
r1bC$frequency <- frequency

relative1balancingCost_ggp <- data.frame(x = r1bC$frequency,
                                         y = c(r1bC$run1, r1bC$run2),
                                         group = c(rep('baseline scenario', nrow(r1bC)),
                                                   rep('sensitivity 1 (January & February)', nrow(r1bC))))


ggp_r1bC <- ggplot(relative1balancingCost_ggp, aes(x=x, y=y)) +
  geom_line(aes(color=group), size=0.8) + geom_point(aes(color=group)) + scale_x_continuous(labels = as.character(relative1balancingCost_ggp$x), breaks = relative1balancingCost_ggp$x) +
  scale_y_continuous(breaks=seq(0,900,by=50)) +
  labs(x="auction frequency [h]",
       y="balancing costs [%]",
       color="") +
  theme_set(theme_bw(base_size = 20))+
  theme(legend.position="bottom")


ggp_r1bC

ggsave("1rbalancingCost_janfeb.pdf", width = 34, height = 20, units = "cm")




#--------------------------------------------------------------------------------------------------
#balancing costs (absolute values)

run1 <- c(cost_df_baseline[1,5], cost_df_baseline[2,5], cost_df_baseline[3,5], cost_df_baseline[4,5], cost_df_baseline[5,5], cost_df_baseline[6,5], cost_df_baseline[7,5])
run2 <- c(cost_df_9am[1,5], cost_df_9am[2,5], cost_df_9am[3,5], cost_df_9am[4,5], cost_df_9am[5,5], cost_df_9am[6,5], cost_df_9am[7,5])
run3 <- c(cost_df_mo[1,5], cost_df_mo[2,5], cost_df_mo[3,5], cost_df_mo[4,5], cost_df_mo[5,5], cost_df_mo[6,5], cost_df_mo[7,5])

frequency <- c(24, 12, 8, 6, 4, 2, 1)

bC <- data.frame(run1, run2, run3)
bC$frequency <- frequency

balancingCost_ggp <- data.frame(x = bC$frequency,
                                y = c(bC$run1, bC$run2, bC$run3),
                                group = c(rep('baseline scenario', nrow(bC)),
                                          rep('sensitivity 2 (8 a.m.)', nrow(bC)),
                                          rep('sensitivity 3 (merit order)', nrow(bC))))


ggp_b <- ggplot(balancingCost_ggp, aes(x=x, y=y*1e-06, color=group)) +
  geom_line(aes(color=group), size=0.8) + geom_point(aes(color=group)) + scale_x_continuous(labels = as.character(balancingCost_ggp$x), breaks = balancingCost_ggp$x) +
  scale_y_continuous(breaks=seq(0,90,by=5)) +
  labs(x="auction frequency [h]",
       y="balancing costs [million €]",
       color="") +
  theme_set(theme_bw(base_size = 20))+
  theme(legend.position="bottom")


ggp_b

ggsave("balancingCost_sensitivity.pdf", width = 34, height = 20, units = "cm")





#balancing costs (% 1h baseline scenario)

run1 <- c(cost_df_baseline[1,5]/cost_df_baseline[7,5], cost_df_baseline[2,5]/cost_df_baseline[7,5], cost_df_baseline[3,5]/cost_df_baseline[7,5], cost_df_baseline[4,5]/cost_df_baseline[7,5], cost_df_baseline[5,5]/cost_df_baseline[7,5], cost_df_baseline[6,5]/cost_df_baseline[7,5], cost_df_baseline[7,5]/cost_df_baseline[7,5])
run2 <- c(cost_df_9am[1,5]/cost_df_baseline[7,5], cost_df_9am[2,5]/cost_df_baseline[7,5], cost_df_9am[3,5]/cost_df_baseline[7,5], cost_df_9am[4,5]/cost_df_baseline[7,5], cost_df_9am[5,5]/cost_df_baseline[7,5], cost_df_9am[6,5]/cost_df_baseline[7,5], cost_df_9am[7,5]/cost_df_baseline[7,5])
run3 <- c(cost_df_mo[1,5]/cost_df_baseline[7,5], cost_df_mo[2,5]/cost_df_baseline[7,5], cost_df_mo[3,5]/cost_df_baseline[7,5], cost_df_mo[4,5]/cost_df_baseline[7,5], cost_df_mo[5,5]/cost_df_baseline[7,5], cost_df_mo[6,5]/cost_df_baseline[7,5], cost_df_mo[7,5]/cost_df_baseline[7,5])


frequency <- c(24, 12, 8, 6, 4, 2, 1)

r1bC <- data.frame(run1, run2, run3)
r1bC <- r1bC*100
r1bC$frequency <- frequency

relative1balancingCost_ggp <- data.frame(x = r1bC$frequency,
                                         y = c(r1bC$run1, r1bC$run2, r1bC$run3),
                                         group = c(rep('baseline scenario', nrow(r1bC)),
                                                   rep('sensitivity 2 (8 a.m.)', nrow(r1bC)),
                                                   rep('sensitivity 3 (merit order)', nrow(r1bC))))


ggp_r1bC <- ggplot(relative1balancingCost_ggp, aes(x=x, y=y)) +
  geom_line(aes(color=group), size=0.8) + geom_point(aes(color=group)) + scale_x_continuous(labels = as.character(relative1balancingCost_ggp$x), breaks = relative1balancingCost_ggp$x) +
  scale_y_continuous(breaks=seq(0,900,by=50)) +
  labs(x="auction frequency [h]",
       y="balancing costs [% (baseline)]",
       color="") +
  theme_set(theme_bw(base_size = 20))+
  theme(legend.position="bottom")


ggp_r1bC

ggsave("1rbalancingCost_sensitivity.pdf", width = 34, height = 20, units = "cm")





#relative balancing costs (balancing costs / total costs)

run1 <- c(cost_df_baseline[1,5]/cost_df_baseline[1,6], cost_df_baseline[2,5]/cost_df_baseline[2,6], cost_df_baseline[3,5]/cost_df_baseline[3,6], cost_df_baseline[4,5]/cost_df_baseline[4,6], cost_df_baseline[5,5]/cost_df_baseline[5,6], cost_df_baseline[6,5]/cost_df_baseline[6,6], cost_df_baseline[7,5]/cost_df_baseline[7,6])
run2 <- c(cost_df_janfeb[1,5]/cost_df_janfeb[1,6], cost_df_janfeb[2,5]/cost_df_janfeb[2,6], cost_df_janfeb[3,5]/cost_df_janfeb[3,6], cost_df_janfeb[4,5]/cost_df_janfeb[4,6], cost_df_janfeb[5,5]/cost_df_janfeb[5,6], cost_df_janfeb[6,5]/cost_df_janfeb[6,6], cost_df_janfeb[7,5]/cost_df_janfeb[7,6])
run3 <- c(cost_df_9am[1,5]/cost_df_9am[1,6], cost_df_9am[2,5]/cost_df_9am[2,6], cost_df_9am[3,5]/cost_df_9am[3,6], cost_df_9am[4,5]/cost_df_9am[4,6], cost_df_9am[5,5]/cost_df_9am[5,6], cost_df_9am[6,5]/cost_df_9am[6,6], cost_df_9am[7,5]/cost_df_9am[7,6])
run4 <- c(cost_df_mo[1,5]/cost_df_mo[1,6], cost_df_mo[2,5]/cost_df_mo[2,6], cost_df_mo[3,5]/cost_df_mo[3,6], cost_df_mo[4,5]/cost_df_mo[4,6], cost_df_mo[5,5]/cost_df_mo[5,6], cost_df_mo[6,5]/cost_df_mo[6,6], cost_df_mo[7,5]/cost_df_mo[7,6])



frequency <- c(24, 12, 8, 6, 4, 2, 1)

rbC <- data.frame(run1, run2, run3, run4)
rbC <- rbC*100
rbC$frequency <- frequency

relativebalancingCost_ggp <- data.frame(x = rbC$frequency,
                                        y = c(rbC$run1, rbC$run2, rbC$run3, rbC$run4),
                                        group = c(rep('baseline scenario', nrow(rbC)),
                                                  rep('sensitivity 1 (January & February)', nrow(rbC)),
                                                  rep('sensitivity 2 (8 a.m.)', nrow(rbC)),
                                                  rep('sensitivity 3 (merit order)', nrow(rbC))))


ggp_rbC <- ggplot(relativebalancingCost_ggp, aes(x=x, y=y)) +
  geom_line(aes(color=group), size=0.8) + geom_point(aes(color=group)) + scale_x_continuous(labels = as.character(relativebalancingCost_ggp$x), breaks = relativebalancingCost_ggp$x) +
  scale_y_continuous(breaks=seq(0,5,by=0.25)) +
  labs(x="auction frequency [h]",
       y="balancing costs / total UC costs [%]",
       color="") +
  theme_set(theme_bw(base_size = 20))+
  theme(legend.position="bottom")


ggp_rbC

ggsave("rbalancingCost_sensitivity.pdf", width = 34, height = 20, units = "cm")




#--------------------------------------------------------------------------------------------------
#variable costs (absolute values)

run1 <- c(cost_df_baseline[1,2], cost_df_baseline[2,2], cost_df_baseline[3,2], cost_df_baseline[4,2], cost_df_baseline[5,2], cost_df_baseline[6,2], cost_df_baseline[7,2])
run2 <- c(cost_df_pk[1,2], cost_df_pk[2,2], cost_df_pk[3,2], cost_df_pk[4,2], cost_df_pk[5,2], cost_df_pk[6,2], cost_df_pk[7,2])
run3 <- c(cost_df_9am[1,2], cost_df_9am[2,2], cost_df_9am[3,2], cost_df_9am[4,2], cost_df_9am[5,2], cost_df_9am[6,2], cost_df_9am[7,2])
run4 <- c(cost_df_mo[1,2], cost_df_mo[2,2], cost_df_mo[3,2], cost_df_mo[4,2], cost_df_mo[5,2], cost_df_mo[6,2], cost_df_mo[7,2])


frequency <- c(24, 12, 8, 6, 4, 2, 1)

vC <- data.frame(run1, run2, run3)
vC$frequency <- frequency

variableCost_ggp <- data.frame(x = vC$frequency,
                               y = c(vC$run1, vC$run2, vC$run3),
                               group = c(rep('baseline scenario & sensitivity 3 (merit order)', nrow(vC)),
                                         rep('perfect knowledge', nrow(vC)),
                                         rep('sensitivity 2 (8 a.m.)', nrow(vC))))

ggp_v <- ggplot(variableCost_ggp, aes(x=x, y=y*1e-9, color=group)) +
  geom_line(aes(color=group), size=0.8) + geom_point(aes(color=group)) + scale_x_continuous(labels = as.character(variableCost_ggp$x), breaks = variableCost_ggp$x) +
  scale_y_continuous(breaks=seq(1.685, 1.705, 0.002), limits=c(1.685, 1.705))+
  labs(x="auction frequency [h]",
       y="variable costs [billion €]",
       color="") +
  theme_set(theme_bw(base_size = 20))+
  theme(legend.position="bottom")


ggp_v

ggsave("variableCost_sensitivity.pdf", width = 34, height = 20, units = "cm")





#variable costs (% 1h baseline scenario)

run1 <- c(cost_df_baseline[1,2]/cost_df_baseline[7,2], cost_df_baseline[2,2]/cost_df_baseline[7,2], cost_df_baseline[3,2]/cost_df_baseline[7,2], cost_df_baseline[4,2]/cost_df_baseline[7,2], cost_df_baseline[5,2]/cost_df_baseline[7,2], cost_df_baseline[6,2]/cost_df_baseline[7,2], cost_df_baseline[7,2]/cost_df_baseline[7,2])
run2 <- c(cost_df_pk[1,2]/cost_df_baseline[7,2], cost_df_pk[2,2]/cost_df_baseline[7,2], cost_df_pk[3,2]/cost_df_baseline[7,2], cost_df_pk[4,2]/cost_df_baseline[7,2], cost_df_pk[5,2]/cost_df_baseline[7,2], cost_df_pk[6,2]/cost_df_baseline[7,2], cost_df_pk[7,2]/cost_df_baseline[7,2])
run3 <- c(cost_df_9am[1,2]/cost_df_baseline[7,2], cost_df_9am[2,2]/cost_df_baseline[7,2], cost_df_9am[3,2]/cost_df_baseline[7,2], cost_df_9am[4,2]/cost_df_baseline[7,2], cost_df_9am[5,2]/cost_df_baseline[7,2], cost_df_9am[6,2]/cost_df_baseline[7,2], cost_df_9am[7,2]/cost_df_baseline[7,2])
run4 <- c(cost_df_mo[1,2]/cost_df_baseline[7,2], cost_df_mo[2,2]/cost_df_baseline[7,2], cost_df_mo[3,2]/cost_df_baseline[7,2], cost_df_mo[4,2]/cost_df_baseline[7,2], cost_df_mo[5,2]/cost_df_baseline[7,2], cost_df_mo[6,2]/cost_df_baseline[7,2], cost_df_mo[7,2]/cost_df_baseline[7,2])


frequency <- c(24, 12, 8, 6, 4, 2, 1)

r1vC <- data.frame(run1, run2, run3)
r1vC <- r1vC*100
r1vC$frequency <- frequency

relative1variableCost_ggp <- data.frame(x = r1vC$frequency,
                                        y = c(r1vC$run1, r1vC$run2, r1vC$run3),
                                        group = c(rep('baseline scenario & sensitivity 3 (merit order)', nrow(r1vC)),
                                                  rep('perfect knowledge', nrow(r1vC)),
                                                  rep('sensitivity 2 (8 a.m.)', nrow(r1vC))))



ggp_r1vC <- ggplot(relative1variableCost_ggp, aes(x=x, y=y)) +
  geom_line(aes(color=group), size=0.8) + geom_point(aes(color=group)) + scale_x_continuous(labels = as.character(variableCost_ggp$x), breaks = variableCost_ggp$x) +
  scale_y_continuous(breaks=seq(99.4, 100.6, 0.2), limits=c(99.4, 100.6))+
  labs(x="auction frequency [h]",
       y="variable costs [% (baseline)]",
       color="") +
  theme_set(theme_bw(base_size = 20))+
  theme(legend.position="bottom")


ggp_r1vC

ggsave("1rvariableCost_sensitivity.pdf", width = 34, height = 20, units = "cm")



#relative variable costs (variable costs / total costs)

run1 <- c(cost_df_baseline[1,2]/cost_df_baseline[1,6], cost_df_baseline[2,2]/cost_df_baseline[2,6], cost_df_baseline[3,2]/cost_df_baseline[3,6], cost_df_baseline[4,2]/cost_df_baseline[4,6], cost_df_baseline[5,2]/cost_df_baseline[5,6], cost_df_baseline[6,2]/cost_df_baseline[6,6], cost_df_baseline[7,2]/cost_df_baseline[7,6])
run2 <- c(cost_df_janfeb[1,2]/cost_df_janfeb[1,6], cost_df_janfeb[2,2]/cost_df_janfeb[2,6], cost_df_janfeb[3,2]/cost_df_janfeb[3,6], cost_df_janfeb[4,2]/cost_df_janfeb[4,6], cost_df_janfeb[5,2]/cost_df_janfeb[5,6], cost_df_janfeb[6,2]/cost_df_janfeb[6,6], cost_df_janfeb[7,2]/cost_df_janfeb[7,6])
run3 <- c(cost_df_pk[1,2]/cost_df_pk[1,6], cost_df_pk[2,2]/cost_df_pk[2,6], cost_df_pk[3,2]/cost_df_pk[3,6], cost_df_pk[4,2]/cost_df_pk[4,6], cost_df_pk[5,2]/cost_df_pk[5,6], cost_df_pk[6,2]/cost_df_pk[6,6], cost_df_pk[7,2]/cost_df_pk[7,6])
run4 <- c(cost_df_9am[1,2]/cost_df_9am[1,6], cost_df_9am[2,2]/cost_df_9am[2,6], cost_df_9am[3,2]/cost_df_9am[3,6], cost_df_9am[4,2]/cost_df_9am[4,6], cost_df_9am[5,2]/cost_df_9am[5,6], cost_df_9am[6,2]/cost_df_9am[6,6], cost_df_9am[7,2]/cost_df_9am[7,6])
run5 <- c(cost_df_mo[1,2]/cost_df_mo[1,6], cost_df_mo[2,2]/cost_df_mo[2,6], cost_df_mo[3,2]/cost_df_mo[3,6], cost_df_mo[4,2]/cost_df_mo[4,6], cost_df_mo[5,2]/cost_df_mo[5,6], cost_df_mo[6,2]/cost_df_mo[6,6], cost_df_mo[7,2]/cost_df_mo[7,6])


frequency <- c(24, 12, 8, 6, 4, 2, 1)

rvC <- data.frame(run1, run2, run3, run4, run5)
rvC <- rvC*100
rvC$frequency <- frequency

relativevariableCost_ggp <- data.frame(x = rvC$frequency,
                                       y = c(rvC$run1, rvC$run2, rvC$run3, rvC$run4, rvC$run5),
                                       group = c(rep('baseline scenario', nrow(rvC)),
                                                 rep('sensitivity 1 (January & February)', nrow(rvC)),
                                                 rep('perfect knowledge', nrow(rvC)),
                                                 rep('sensitivity 2 (8 a.m.)', nrow(rvC)),
                                                 rep('sensitivity 3 (merit order)', nrow(rvC))))


ggp_rvC <- ggplot(relativevariableCost_ggp, aes(x=x, y=y)) +
  geom_line(aes(color=group), size=0.8) + geom_point(aes(color=group)) + scale_x_continuous(labels = as.character(relativevariableCost_ggp$x), breaks = relativevariableCost_ggp$x) +
  scale_y_continuous(breaks=seq(94,99,by=0.5)) +
  labs(x="auction frequency [h]",
       y="var. costs / total UC costs [%]",
       color="") +
  theme_set(theme_bw(base_size = 20))+
  theme(legend.position="bottom")


ggp_rvC

ggsave("rvariableCost_sensitivity.pdf", width = 34, height = 20, units = "cm")








#--------------------------------------------------------------------------------------------------
#start-up costs (absolute values)

run1 <- c(cost_df_baseline[1,3], cost_df_baseline[2,3], cost_df_baseline[3,3], cost_df_baseline[4,3], cost_df_baseline[5,3], cost_df_baseline[6,3], cost_df_baseline[7,3])
run2 <- c(cost_df_pk[1,3], cost_df_pk[2,3], cost_df_pk[3,3], cost_df_pk[4,3], cost_df_pk[5,3], cost_df_pk[6,3], cost_df_pk[7,3])
run3 <- c(cost_df_9am[1,3], cost_df_9am[2,3], cost_df_9am[3,3], cost_df_9am[4,3], cost_df_9am[5,3], cost_df_9am[6,3], cost_df_9am[7,3])
run4 <- c(cost_df_mo[1,3], cost_df_mo[2,3], cost_df_mo[3,3], cost_df_mo[4,3], cost_df_mo[5,3], cost_df_mo[6,3], cost_df_mo[7,3])


frequency <- c(24, 12, 8, 6, 4, 2, 1)

suC <- data.frame(run1, run2, run3)
suC$frequency <- frequency

startupCost_ggp <- data.frame(x = suC$frequency,
                              y = c(suC$run1, suC$run2, suC$run3),
                              group = c(rep('baseline scenario & sensitivity 3 (merit order)', nrow(suC)),
                                        rep('perfect knowledge', nrow(suC)),
                                        rep('sensitivity 2 (8 a.m.)', nrow(suC))))



ggp_su <- ggplot(startupCost_ggp, aes(x=x, y=y*1e-06, color=group)) +
  geom_line(aes(color=group), size=0.8) + geom_point(aes(color=group)) + scale_x_continuous(labels = as.character(startupCost_ggp$x), breaks = startupCost_ggp$x) +
  scale_y_continuous(breaks=seq(14, 19.5, 0.5), limits=c(14, 19.5))+
  labs(x="auction frequency [h]",
       y="start-up costs [million €]",
       color="") +
  theme_set(theme_bw(base_size = 20))+
  theme(legend.position="bottom")


ggp_su

ggsave("startupCost_sensitivity.pdf", width = 34, height = 20, units = "cm")





#start-up costs (% 1h baseline scenario)

run1 <- c(cost_df_baseline[1,3]/cost_df_baseline[7,3], cost_df_baseline[2,3]/cost_df_baseline[7,3], cost_df_baseline[3,3]/cost_df_baseline[7,3], cost_df_baseline[4,3]/cost_df_baseline[7,3], cost_df_baseline[5,3]/cost_df_baseline[7,3], cost_df_baseline[6,3]/cost_df_baseline[7,3], cost_df_baseline[7,3]/cost_df_baseline[7,3])
run2 <- c(cost_df_pk[1,3]/cost_df_baseline[7,3], cost_df_pk[2,3]/cost_df_baseline[7,3], cost_df_pk[3,3]/cost_df_baseline[7,3], cost_df_pk[4,3]/cost_df_baseline[7,3], cost_df_pk[5,3]/cost_df_baseline[7,3], cost_df_pk[6,3]/cost_df_baseline[7,3], cost_df_pk[7,3]/cost_df_baseline[7,3])
run3 <- c(cost_df_9am[1,3]/cost_df_baseline[7,3], cost_df_9am[2,3]/cost_df_baseline[7,3], cost_df_9am[3,3]/cost_df_baseline[7,3], cost_df_9am[4,3]/cost_df_baseline[7,3], cost_df_9am[5,3]/cost_df_baseline[7,3], cost_df_9am[6,3]/cost_df_baseline[7,3], cost_df_9am[7,3]/cost_df_baseline[7,3])
run4 <- c(cost_df_mo[1,3]/cost_df_baseline[7,3], cost_df_mo[2,3]/cost_df_baseline[7,3], cost_df_mo[3,3]/cost_df_baseline[7,3], cost_df_mo[4,3]/cost_df_baseline[7,3], cost_df_mo[5,3]/cost_df_baseline[7,3], cost_df_mo[6,3]/cost_df_baseline[7,3], cost_df_mo[7,3]/cost_df_baseline[7,3])

frequency <- c(24, 12, 8, 6, 4, 2, 1)

r1suC <- data.frame(run1, run2, run3)
r1suC <- r1suC*100
r1suC$frequency <- frequency

relative1startupCost_ggp <- data.frame(x = r1suC$frequency,
                                       y = c(r1suC$run1, r1suC$run2, r1suC$run3),
                                       group = c(rep('baseline scenario & sensitivity 3 (merit order)', nrow(r1suC)),
                                                 rep('perfect knowledge', nrow(r1suC)),
                                                 rep('sensitivity 2 (8 a.m.)', nrow(r1suC))))



ggp_r1suC <- ggplot(relative1startupCost_ggp, aes(x=x, y=y)) +
  geom_line(aes(color=group), size=0.8) + geom_point(aes(color=group)) + scale_x_continuous(labels = as.character(startupCost_ggp$x), breaks = startupCost_ggp$x) +
  scale_y_continuous(breaks=seq(92, 124, 2), limits=c(95, 124))+
  labs(x="auction frequency [h]",
       y="start-up costs [% (baseline)]",
       color="") +
  theme_set(theme_bw(base_size = 20))+
  theme(legend.position="bottom")


ggp_r1suC

ggsave("1rstartupCost_sensitivity.pdf", width = 34, height = 20, units = "cm")





#relative start-up costs (start-up costs / total costs)

run1 <- c(cost_df_baseline[1,3]/cost_df_baseline[1,6], cost_df_baseline[2,3]/cost_df_baseline[2,6], cost_df_baseline[3,3]/cost_df_baseline[3,6], cost_df_baseline[4,3]/cost_df_baseline[4,6], cost_df_baseline[5,3]/cost_df_baseline[5,6], cost_df_baseline[6,3]/cost_df_baseline[6,6], cost_df_baseline[7,3]/cost_df_baseline[7,6])
run2 <- c(cost_df_pk[1,3]/cost_df_pk[1,6], cost_df_pk[2,3]/cost_df_pk[2,6], cost_df_pk[3,3]/cost_df_pk[3,6], cost_df_pk[4,3]/cost_df_pk[4,6], cost_df_pk[5,3]/cost_df_pk[5,6], cost_df_pk[6,3]/cost_df_pk[6,6], cost_df_pk[7,3]/cost_df_pk[7,6])
run3 <- c(cost_df_janfeb[1,3]/cost_df_janfeb[1,6], cost_df_janfeb[2,3]/cost_df_janfeb[2,6], cost_df_janfeb[3,3]/cost_df_janfeb[3,6], cost_df_janfeb[4,3]/cost_df_janfeb[4,6], cost_df_janfeb[5,3]/cost_df_janfeb[5,6], cost_df_janfeb[6,3]/cost_df_janfeb[6,6], cost_df_janfeb[7,3]/cost_df_janfeb[7,6])
run4 <- c(cost_df_9am[1,3]/cost_df_9am[1,6], cost_df_9am[2,3]/cost_df_9am[2,6], cost_df_9am[3,3]/cost_df_9am[3,6], cost_df_9am[4,3]/cost_df_9am[4,6], cost_df_9am[5,3]/cost_df_9am[5,6], cost_df_9am[6,3]/cost_df_9am[6,6], cost_df_9am[7,3]/cost_df_9am[7,6])
run5 <- c(cost_df_mo[1,3]/cost_df_mo[1,6], cost_df_mo[2,3]/cost_df_mo[2,6], cost_df_mo[3,3]/cost_df_mo[3,6], cost_df_mo[4,3]/cost_df_mo[4,6], cost_df_mo[5,3]/cost_df_mo[5,6], cost_df_mo[6,3]/cost_df_mo[6,6], cost_df_mo[7,3]/cost_df_mo[7,6])


frequency <- c(24, 12, 8, 6, 4, 2, 1)


rsuC <- data.frame(run1, run2, run3, run4, run5)
rsuC <- rsuC*100
rsuC$frequency <- frequency

relativestartupCost_ggp <- data.frame(x = rsuC$frequency,
                                      y = c(rsuC$run1, rsuC$run2, rsuC$run3, rsuC$run4, rsuC$run5),
                                      group = c(rep('baseline scenario', nrow(rsuC)),
                                                rep('perfect knowledge', nrow(rsuC)),
                                                rep('sensitivity 1 (January & February)', nrow(rsuC)),
                                                rep('sensitivity 2 (8 a.m.)', nrow(rsuC)),
                                                rep('sensitivity 3 (merit order)', nrow(rsuC))))



ggp_rsuC <- ggplot(relativestartupCost_ggp, aes(x=x, y=y)) +
  geom_line(aes(color=group), size=0.8) + geom_point(aes(color=group)) + scale_x_continuous(labels = as.character(relativestartupCost_ggp$x), breaks = relativestartupCost_ggp$x) +
  scale_y_continuous(breaks=seq(0.86, 1.10, 0.02), limits=c(0.86, 1.10))+
  labs(x="auction frequency [h]",
       y="start-up costs / total UC costs [%]",
       color="") +
  theme_set(theme_bw(base_size = 20))+
  theme(legend.position="bottom")


ggp_rsuC

ggsave("rstartupCost_sensitivity.pdf", width = 40, height = 22, units = "cm")

